/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/Button","sap/m/Bar","sap/m/Title","sap/m/MessageBox","sap/ui/Device","sap/m/Dialog","sap/m/ResponsivePopover","sap/m/p13n/Container","sap/m/p13n/AbstractContainerItem","sap/m/library","sap/ui/core/library"],function(t,e,n,o,i,r,s,a,p,l,c,h){"use strict";var u=c.P13nPopupMode;var g=h.TitleLevel;var d=t.extend("sap.m.p13n.Popup",{metadata:{library:"sap.m",properties:{title:{type:"string"},mode:{type:"sap.m.P13nPopupMode",defaultValue:u.Dialog},warningText:{type:"string"},reset:{type:"function"}},aggregations:{panels:{type:"sap.m.p13n.IContent",multiple:true},additionalButtons:{type:"sap.m.Button",multiple:true}},events:{close:{parameters:{reason:{type:"string"}}}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("height","100%");t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("div")}}});d.prototype.init=function(){t.prototype.init.apply(this,arguments);this._aPanels=[]};d.prototype.isOpen=function(){return!!this._bIsOpen};d.prototype.setMode=function(t){this.setProperty("mode",t);if(this._oPopup){this._oPopup.removeAllContent();this._oPopup.destroy();var e=this._createContainer();this.addDependent(e);this._oPopup=e}return this};d.prototype.setReset=function(t){if(this._oPopup){var e=this._oPopup.getCustomHeader();if(e){e.destroy()}this._oPopup.setCustomHeader(this._createTitle());this._oPopup.invalidate()}this.setProperty("reset",t);return this};d.prototype.open=function(t,e){if(!t&&this.getMode()==="Popover"){throw new Error("Please provide a source control!")}if(!this._oPopup){var n=this._createContainer(e);this.addDependent(n);this._oPopup=n}if(this.getMode()==="Dialog"){this._oPopup.open()}else{this._oPopup.openBy(t)}var o=this.getResetButton();if(o){o.setEnabled(e?.enableReset)}this._bIsOpen=true};d.prototype.addPanel=function(t,e){var n=t.getBindingInfo("title"),o;if(n&&n.parts){o={parts:n.parts}}if(t.attachChange instanceof Function){t.attachChange(t=>{this.getResetButton()?.setEnabled(true)})}this._getContainer().addView(new l({key:e||t.getId(),text:o||(t.getTitle instanceof Function?t.getTitle():undefined),content:t}));this._aPanels.push(t);return this};d.prototype.removePanel=function(t){this._aPanels.splice(this._aPanels.indexOf(t),1);this._getContainer().removeView(this._getContainer().getView(t));return this};d.prototype.removeAllPanels=function(){this.getPanels().forEach(function(t){this.removePanel(t)}.bind(this))};d.prototype.getPanels=function(){return this._aPanels};d.prototype.getResetButton=function(){return sap.ui.getCore().byId(this.getId()+"-resetBtn")};d.prototype._createContainer=function(t){t=t?t:{};var e=this["_create"+this.getMode()].call(this,t);e.addStyleClass("sapMP13nPopup");e.isPopupAdaptationAllowed=function(){return false};return e};d.prototype._createResponsivePopover=function(t){var e=this.getPanels();var n=e.length>1;var o=new a(this.getId()+"-responsivePopover",{title:this.getTitle(),horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:!n&&!(e[0]&&e[0].getVerticalScrolling instanceof Function&&e[0].getVerticalScrolling()),contentWidth:t.contentWidth?t.contentWidth:"30rem",resizable:t.hasOwnProperty("resizable")?t.resizable:true,contentHeight:t.contentHeight?t.contentHeight:"35rem",placement:t.placement?t.placement:"Bottom",content:n?this._getContainer():e[0],afterClose:function(){this._onClose(o,"AutoClose")}.bind(this)});o.setCustomHeader(this._createTitle());return o};d.prototype._createDialog=function(t){var n=this.getPanels();var o=n.length>1;var i=sap.ui.getCore().getLibraryResourceBundle("sap.m");var a;if(n.length>0){var p=n[0];a=p.getInitialFocusedControl&&p.getInitialFocusedControl();if(!a&&o){a=this._getContainer()._getTabBar().getItems()[0]}}var l=new s(this.getId()+"-dialog",{initialFocus:a,title:this.getTitle(),horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:!o&&!(n[0]&&n[0].getVerticalScrolling instanceof Function&&n[0].getVerticalScrolling()),contentWidth:t.contentWidth?t.contentWidth:"40rem",contentHeight:t.contentHeight?t.contentHeight:"55rem",draggable:true,resizable:true,stretch:r.system.phone,content:o?this._getContainer():n[0],escapeHandler:function(){this._onClose(l,"Escape")}.bind(this),buttons:[new e(this.getId()+this._getIdPrefix()+"-confirmBtn",{text:t.confirm&&t.confirm.text?t.confirm.text:i.getText("p13n.POPUP_OK"),type:"Emphasized",press:function(){this._onClose(l,"Ok")}.bind(this)}),new e(this.getId()+this._getIdPrefix()+"-cancelBtn",{text:i.getText("p13n.POPUP_CANCEL"),press:function(){this._onClose(l,"Cancel")}.bind(this)})]});l.setCustomHeader(this._createTitle());this.getAdditionalButtons().forEach(function(t){l.addButton(t)});return l};d.prototype._getIdPrefix=function(){return""};d.prototype._createTitle=function(){var t=this.getReset();var r=this.getTitle();var s=this.getWarningText();var a=this;var p;if(t instanceof Function){p=new n({contentLeft:[new o({text:r,level:g.H1})]});p.addContentRight(new e(this.getId()+"-resetBtn",{text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("p13n.POPUP_RESET"),press:function(e){var n=e.getSource().getParent().getParent();var o=n.getParent();var r=s;i.warning(r,{actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK,onClose:r=>{if(r===i.Action.OK){n.getButtons()[0].focus();e.getSource().setEnabled(false);a._resetPanels();t(o)}}})}}))}return p};d.prototype._resetPanels=function(){this.getPanels().forEach(t=>{if(t.onReset instanceof Function){t.onReset()}})};d.prototype._getContainer=function(t){if(!this._oContainer){this._oContainer=new p}if(this._oContainer.getViews().length>1){this._oContainer.switchView(this._oContainer.getViews()[1].getKey())}return this._oContainer};d.prototype._onClose=function(t,e){t.close();this._bIsOpen=false;this.fireClose({reason:e})};d.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oPopup){this._oPopup.destroy()}this._aPanels=null};return d});
//# sourceMappingURL=Popup.js.map