/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/layout/Grid","./BasePanel","sap/ui/core/ListItem","sap/m/CustomListItem","sap/m/ComboBox","sap/m/List","sap/m/HBox","sap/m/library","sap/m/Button","sap/base/util/merge","sap/ui/core/library","sap/ui/core/InvisibleMessage"],function(t,e,n,o,i,r,s,a,u,h,l,p){"use strict";var g=l.ValueState;var d=e.extend("sap.m.p13n.QueryPanel",{metadata:{library:"sap.m",properties:{queryLimit:{type:"int",defaultValue:-1}}},renderer:{apiVersion:2}});var m=a.ListType;var _=a.FlexJustifyContent;var c=a.ListKeyboardMode;var f=a.ButtonType;d.prototype.init=function(){e.prototype.init.apply(this,arguments);this._bFocusOnRearrange=false;this.setEnableReorder(true);this.addStyleClass("sapMP13nQueryPanel")};d.prototype.setP13nData=function(t){e.prototype.setP13nData.apply(this,arguments);this._oListControl.removeAllItems();if(t instanceof Array){t.forEach(function(t){if(t[this.PRESENCE_ATTRIBUTE]){this._addQueryRow(t)}}.bind(this));this._addQueryRow()}return this};d.prototype.getP13nData=function(t){var e=[];this._oListControl.getItems().forEach(function(t){var n=this._getControlFromRow(t)._key;if(n){var o=this._getP13nModel().getProperty("/items").find(function(t){return t.name==n});e.push(o)}}.bind(this));if(!t){this._getP13nModel().getProperty("/items").forEach(function(t){if(e.indexOf(t)===-1){e.push(t)}})}return h([],e)};d.prototype._allEntriesUsed=function(){return this.getP13nData().length===this.getP13nData(true).length};d.prototype._moveTableItem=function(t,e){var n=this._oListControl.getItems().indexOf(t);var o=this._oListControl.getItems().length-1;var i=this.getQueryLimit();if((n!==o||this._allEntriesUsed())&&(i===-1||e<i)){this._oListControl.removeItem(t);this._oListControl.insertItem(t,e);this._updateEnableOfMoveButtons(t,false);this._getP13nModel().checkUpdate(true);this.fireChange({reason:this.CHANGE_REASON_MOVE,item:this._getModelEntry(t)})}};d.prototype._updateEnableOfMoveButtons=function(t,n){e.prototype._updateEnableOfMoveButtons.apply(this,arguments);if(this._oListControl.getItems().indexOf(t)===this._oListControl.getItems().length-2&&!this._allEntriesUsed()){this._getMoveDownButton().setEnabled(false)}};d.prototype._createInnerListControl=function(){var t=new r(this.getId()+"-innerP13nList",{itemPress:[this._onItemPressed,this],dragDropConfig:this._getDragDropConfig()});t.setKeyboardMode(c.Edit);return t};d.prototype._getModelEntry=function(t){var e=this._getControlFromRow(t)._key;var n=this._getP13nModel().getProperty("/items").find(function(t){return t.name==e});return n};d.prototype._getAvailableItems=function(t){var e=this._getP13nModel().getProperty("/items");var o=[];e.forEach(function(t,e){o.push(new n({key:t.name,text:t.label,enabled:{path:this.P13N_MODEL+">/items/"+e+"/"+this.PRESENCE_ATTRIBUTE,formatter:function(t){var e=this.getParent();var n=e.getSelectedItem();var o=n&&e.getItems().indexOf(n);var i=this.getBindingPath("enabled");var r=parseInt(i.split("/")[2]);return!t||o===r}}}))}.bind(this));return o};d.prototype._addQueryRow=function(t){var e=this.getQueryLimit()>-1;var n=this.getQueryLimit()<=this._oListControl.getItems().length;if(e&&n&&!t||this._allEntriesUsed()){return}t=t?t:{name:null};var i=this._createQueryRowGrid(t);var r=new o({type:m.Active,content:[i]});if(this.getEnableReorder()&&(this.getQueryLimit()===-1||this.getQueryLimit()>1&&this._oListControl.getItems().length<this.getQueryLimit())){this._addHover(r)}this._getControlFromRow(r)._key=t.name;this._oListControl.addItem(r);var s=!!t.name;var a=this._createRemoveButton(s);r.getContent()[0].addContent(a);return r};d.prototype._createQueryRowGrid=function(e){var n=this._createKeySelect(e.name);return new t({containerQuery:true,defaultSpan:"XL6 L6 M6 S6",content:[n]}).addStyleClass("sapUiTinyMargin")};d.prototype._handleActivated=function(t){var e=t.getContent()[0];if(e){var n=this._getControlFromRow(t,-1);if(t&&n.getItems().length<2){n.insertItem(this._getMoveUpButton(),0);n.insertItem(this._getMoveDownButton(),1);this._updateEnableOfMoveButtons(t,false)}}};d.prototype._getPlaceholderText=function(){return""};d.prototype._getRemoveButtonTooltipText=function(){return""};d.prototype._getRemoveButtonAnnouncementText=function(){return""};d.prototype._announce=function(t){var e=l.InvisibleMessageMode;var n=p.getInstance();n.announce(t,e.Assertive)};d.prototype._createKeySelect=function(t){var e=this;var n=new i({width:"14rem",enabled:{path:this.P13N_MODEL+">/items/",formatter:function(t){if(e.getQueryLimit()<0){return true}var n=e.getP13nData(true).map(function(t){return t.name});var o=this._key;var i=n.indexOf(o)+1;return i<=e.getQueryLimit()}},items:this._getAvailableItems(t),selectedKey:t,placeholder:this._getPlaceholderText(),selectionChange:function(t){var e=t.getSource();var n=e.getSelectedItem();if(!n){this._selectKey(e)}}.bind(this),change:function(t){var e=t.getSource();var n=t.getParameter("newValue");this._selectKey(e);e.setValueState(n&&!e.getSelectedItem()?g.Error:g.None)}.bind(this)});return n};d.prototype._selectKey=function(t){var e=t.getSelectedKey();var n=t._key;var o=t.getParent().getParent();var i=this._oListControl.getItems().length-1==this._oListControl.getItems().indexOf(o);var r=this._getControlFromRow(o,-1);r.setVisible(!(i&&e==""));if(n){this._updatePresence(n,false,undefined)}t._key=e;this._updatePresence(e,true,this._oListControl.getItems().indexOf(o));if(e!==""&&i){this._addQueryRow()}};d.prototype._createRemoveButton=function(t){var e=new s({justifyContent:_.End,width:"100%",visible:t,items:[new u({type:f.Transparent,icon:"sap-icon://decline",press:function(t){var e=t.getSource().getParent().getParent().getParent();var n=this._oListControl.getItems().length;var o=n===1||n==this.getP13nData(true).length;this._oListControl.removeItem(e);this._updatePresence(this._getControlFromRow(e)._key,false,undefined);if(o){this._addQueryRow()}this._announce(this._getRemoveButtonAnnouncementText());setTimeout(function(){if(!this.bIsDestroyed){this.getInitialFocusedControl().focus()}}.bind(this),0);this._getP13nModel().checkUpdate(true)}.bind(this)})]});if(this._getRemoveButtonTooltipText()){e.getItems()[0].setTooltip(this._getRemoveButtonTooltipText())}return e};d.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveUpButton().getParent().getParent().getParent();e.prototype._moveSelectedItem.apply(this,arguments)};d.prototype._updatePresence=function(t,e,n){var o=h([],this._getP13nModel().getProperty("/items"));var i=o.filter(function(e){return e.name===t});if(i[0]){i[0][this.PRESENCE_ATTRIBUTE]=e}this._getP13nModel().setProperty("/items",o);this.fireChange({reason:e?this.CHANGE_REASON_ADD:this.CHANGE_REASON_REMOVE,item:i[0]})};d.prototype.getInitialFocusedControl=function(){var t=this._getRow(-1);return this._getControlFromRow(t)};d.prototype._getRow=function(t){var e=this._oListControl.getItems();if(t<0){t=e.length+t}return e[t]};d.prototype._getControlFromRow=function(t,e){var n=t.getContent()[0].getContent();if(e===undefined){e=0}if(e<0){e=n.length+e}return n[e]};return d});
//# sourceMappingURL=QueryPanel.js.map