/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/Log","sap/m/upload/p13n/modules/PersPopupManager","sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/m/upload/p13n/mediator/SortMediator","sap/m/upload/p13n/mediator/GroupMediator","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/Utils"],function(t,e,r,n,o,a,i,s){"use strict";const p=new WeakMap;let l;let c;const u=function(){if(!c){c=new Promise(function(t,e){sap.ui.require(["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(e){t(e)},e)})}return c};const d=t.extend("sap.m.upload.p13n.PersManager",{constructor:function(){t.call(this);this.oPersPopupManager=r.getInstance()}});d.prototype.register=function(t,e){if(!t){throw Error("Please provide control for which will be performed adaptation")}if(!e?.mediators||e.mediators.length===0){throw Error("Please provide at least a configuration 'mediator' containing a map of key-value pairs (key + Mediator class) in order to register adaptation.")}const r=this._getRegisterEntry(t);if(r){this.deregister(r)}const n=this._registerControl(t);Object.entries(e.mediators).forEach(([t,e])=>{n.mediators[t]=e});if(t.getEnableVariantManagement()&&s.getAppComponentForControl(t)){i.attachVariantApplied({selector:t,vmControlId:t._getVariantManagementControl().getId(),callAfterInitialVariant:true,callback:()=>{d.getInstance().applyStateChange(t);i.detachVariantApplied({selector:t,vmControlId:t._getVariantManagementControl().getId()})}})}};d.prototype.deregister=function(t){const e=this._getRegisterEntry(t);if(!e){return}Object.keys(e.mediators).forEach(t=>{const r=e.mediators[t];r.destroy();delete e.mediators[t]});p.delete(t)};d.prototype._registerControl=function(t){const e={mediators:{},activeP13n:null};p.set(t,e);return e};d.prototype._getRegisterEntry=function(t){return p.get(t)};d.prototype.destroy=function(){l=null;p.delete(this)};d.getInstance=function(){if(!l){l=new d}return l};d.prototype.show=function(t,e){const r=e instanceof Array?e:[e];if(!this.verifyMediators(t,r)){return}const n=this._getRegisterEntry(t);if(n.activeP13n){return}n.activeP13n=true;this.oPersPopupManager.openP13nPopup(t,n.mediators,r,function(t){let e=[];if(t){r.forEach(t=>{e=e.concat(n.mediators[t].getChanges())})}if(e.length){this.addChangesToFlex(e)}n.activeP13n=false}.bind(this))};d.prototype.verifyMediators=function(t,r){const n=this._getRegisterEntry(t);if(!n||!r||!(r instanceof Array)||!r?.length){return false}return r.every(r=>{if(!n.mediators[r]){e.error(`No mediator registered yet for ${t.getId()} and key: ${r}`);return false}return true})};d.prototype.addChangesToFlex=function(t){n.add({changes:t})};d.prototype.waitForChanges=function(t){return u().then(e=>e.waitForChanges({element:t}))};d.prototype.applyStateChange=function(t){const e=this._getRegisterEntry(t);if(!e?.mediators){return}const r=[];Object.entries(e.mediators).forEach(([t,e])=>{if(e instanceof o||e instanceof a){e.applyStateToTable(r)}else{e.applyStateToTable()}});const n=Object.values(r);t.getBinding("items").sort(n.length?n:null)};return d});
//# sourceMappingURL=PersManager.js.map