/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/Popup","sap/m/Popover","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","./NavigationListItem","./NavigationListRenderer","sap/m/Menu","sap/m/MenuItem","sap/base/Log"],function(jQuery,e,t,i,s,o,a,n,r,p,l,m,d,f,g){"use strict";var u=s.extend("sap.tnt.NavigationList",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"},_overflowItem:{type:"sap.tnt.NavigationListItem",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:m});u.prototype.init=function(){this._itemNavigation=new r;this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);this._itemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]})};u.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();var e=this.getSelectedKey();this.setSelectedKey(e)};u.prototype.onAfterRendering=function(){this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(this._getDomRefs());if(this.getExpanded()){return}this.getDomRef().scrollTop=0;this._resizeListenerId=o.register(this.getDomRef().parentNode,this._resize.bind(this));if(t.isThemeApplied()){this._updateOverflowItems()}else{t.attachThemeChanged(this._handleThemeLoad,this)}};u.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){o.deregister(this._resizeListenerId);this._resizeListenerId=null}};u.prototype._handleThemeLoad=function(){this._updateOverflowItems();t.detachThemeChanged(this._handleThemeLoad,this)};u.prototype._resize=function(){this._updateOverflowItems()};u.prototype._updateOverflowItems=function(){var e=this.getDomRef(),t,i,s,o,a,n=0;if(this.getExpanded()||!e){return}i=e.querySelectorAll("li:not(.sapTnTNavLIOverflow)");s=e.querySelector(".sapTnTNavLIOverflow");if(!s){return}s.classList.add("sapTnTNavLIHiddenItem");i.forEach(function(e){e.classList.remove("sapTnTNavLIHiddenItem");n+=e.offsetHeight});t=window.getComputedStyle(e);a=e.offsetHeight-parseFloat(t.paddingTop)-parseFloat(t.paddingBottom);if(a>=n){return}s.classList.remove("sapTnTNavLIHiddenItem");n=s.offsetHeight;o=e.querySelector(".sapTntNavLIItemSelected");if(o){o=o.parentNode;n+=o.offsetHeight;t=window.getComputedStyle(o);n+=parseFloat(t.marginTop)+parseFloat(t.marginBottom)}i.forEach(function(e){if(e===o){return}n+=e.offsetHeight;t=window.getComputedStyle(e);n+=parseFloat(t.marginTop)+parseFloat(t.marginBottom);if(n>=a){e.classList.add("sapTnTNavLIHiddenItem")}})};u.prototype._getOverflowItem=function(){var e=this.getAggregation("_overflowItem");if(!e){e=new l({text:t.getLibraryResourceBundle("sap.tnt").getText("NAVIGATION_LIST_NAVIGATION_OVERFLOW"),icon:"sap-icon://overflow",selectable:false,select:this._overflowPress.bind(this)});e._isOverflow=true;this.setAggregation("_overflowItem",e)}return e};u.prototype._overflowPress=function(e){var t=e.getSource();t.getDomRef().querySelector(".sapTntNavLIItem").classList.add("sapTntNavLIActive");var i=this._createOverflowMenu(t);i.openBy(t,false,a.Dock.EndCenter)};u.prototype._createOverflowMenu=function(e){var t=new d({items:this._createNavigationMenuItems(),itemSelected:function(e){var i=e.getParameter("item"),s;this._selectItem({item:i._navItem});s=this.getDomRef().querySelector(".sapTntNavLIItemSelected");if(s){s.parentNode.focus()}t.close();t.destroy()}.bind(this),closed:function(){e.getDomRef().querySelector(".sapTntNavLIItem").classList.remove("sapTntNavLIActive")}});t.addStyleClass("sapTntNavLIMenu");t._handleMenuItemSelect=function(e){var t=e.getParameter("item"),i;if(!t){return}i=this._findMenuItemByUnfdMenuItem(t);if(i){this.fireItemSelected({item:i})}}.bind(t);this.addDependent(t);return t};u.prototype._createNavigationMenuItems=function(){var e=this.getItems(),t=[];e.forEach(function(e){if(!e.getVisible()||!e.getDomRef().classList.contains("sapTnTNavLIHiddenItem")){return}var i=new f({icon:e.getIcon(),text:e.getText(),enabled:e.getEnabled()});i._navItem=e;e.getItems().forEach(function(e){var t=new f({icon:e.getIcon(),text:e.getText(),enabled:e.getEnabled()});t._navItem=e;i.addItem(t)});t.push(i)});return t};u.prototype._updateNavItems=function(){this._itemNavigation.setItemDomRefs(this._getDomRefs())};u.prototype._getDomRefs=function(){var e=[],t=this.getItems(),i=this.getExpanded(),s=this.getAggregation("_overflowItem").getDomRef();for(var o=0;o<t.length;o++){if(i){jQuery.merge(e,t[o]._getDomRefs())}else{e.push(t[o].getDomRef())}}if(!i&&s){e.push(s)}return e};u.prototype._adaptPopoverPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=8;this._offsets=["0 -8","8 0","0 8","-8 0"];this._myPositions=["center bottom","begin top","center top","end top"];this._atPositions=["center top","end top","center bottom","begin top"]}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin top","begin top","end top"];this._atPositions=["begin top","end top","begin bottom","begin top"]}};u.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy()}if(this._popover){this._popover.destroy()}this._deregisterResizeHandler()};u.prototype._selectItem=function(e){this.fireItemSelect(e);var t=e.item;this.setSelectedItem(t,true)};u.prototype._findItemByKey=function(e){var t=this.getItems(),i,s,o,a,n;for(a=0;a<t.length;a++){i=t[a];if(i._getUniqueKey()===e){return i}s=i.getItems();for(n=0;n<s.length;n++){o=s[n];if(o._getUniqueKey()===e){return o}}}return null};u.prototype.setSelectedKey=function(e){var t=this._findItemByKey(e);this.setSelectedItem(t,true);this.setProperty("selectedKey",e,true);return this};u.prototype.getSelectedItem=function(){var e=this.getAssociation("selectedItem");if(!e){return null}return sap.ui.getCore().byId(e)};u.prototype.setSelectedItem=function(e){var t,s,o;if(this._selectedItem){this._selectedItem._unselect()}if(!e){this._selectedItem=null}o=e instanceof i&&e.isA("sap.tnt.NavigationListItem");if(typeof e!=="string"&&!o){g.warning("Type of selectedItem association should be string or instance of sap.tnt.NavigationListItem. New value was not set.");this.setAssociation("selectedItem",null,true);this._updateOverflowItems();return this}this.setAssociation("selectedItem",e,true);if(typeof e==="string"){t=sap.ui.getCore().byId(e)}else{t=e}s=t?t._getUniqueKey():"";this.setProperty("selectedKey",s,true);if(t){t._select();this._selectedItem=t;this._updateOverflowItems();return this}g.warning("Type of selectedItem association should be a valid NavigationListItem object or ID. New value was not set.");return this};u.prototype._openPopover=function(e,t){var i=this;var s=e.$().find(".sapTntNavLIItem").addClass("sapTntNavLIActive");var o=t.getSelectedItem();if(o&&t.isGroupSelected){o=null}var a=this._popover=new n({showHeader:false,horizontalScrolling:false,verticalScrolling:true,initialFocus:o,afterClose:function(){if(i._popover){i._popover.destroy();i._popover=null;s.removeClass("sapTntNavLIActive")}},content:t,ariaLabelledBy:p.getStaticId("sap.tnt","NAVIGATION_LIST_DIALOG_TITLE")}).addStyleClass("sapContrast sapContrastPlus sapTntNavLIPopover");a._adaptPositionParams=this._adaptPopoverPositionParams;a.openBy(e)};u.prototype._closePopover=function(){if(this._popover){this._popover.close()}};return u});
//# sourceMappingURL=NavigationList.js.map