/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/base/Log","sap/base/strings/capitalize","sap/ui/dom/containsOrEquals","./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","./CarouselRenderer","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Focusable"],function(jQuery,t,e,i,s,o,n,a,r,l,h,d){"use strict";var u=s.enums.Orientation;var c=o.extend("sap.ui.commons.Carousel",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{orientation:{type:"sap.ui.commons.enums.Orientation",group:"Misc",defaultValue:u.horizontal},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},defaultItemHeight:{type:"int",group:"Misc",defaultValue:150},defaultItemWidth:{type:"int",group:"Misc",defaultValue:150},animationDuration:{type:"int",group:"Misc",defaultValue:500},visibleItems:{type:"int",group:"Misc",defaultValue:null},handleSize:{type:"int",group:"Misc",defaultValue:22},firstVisibleIndex:{type:"int",group:"Appearance",defaultValue:0}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});c.prototype.init=function(){this._visibleItems=0;this.data("sap-ui-fastnavgroup","true",true)};c.prototype.exit=function(){if(this.sResizeListenerId){n.deregister(this.sResizeListenerId);this.sResizeListenerId=null}this._destroyItemNavigation()};c.prototype.onclick=function(t){switch(t.target){case this.getDomRef("prevbutton"):this.showPrevious();break;case this.getDomRef("nextbutton"):this.showNext();break;default:return}};c.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){n.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};c.prototype.onAfterRendering=function(){if(this.getOrientation()=="vertical"){this._sAnimationAttribute="margin-top"}else{if(d.getRTL()){this._sAnimationAttribute="margin-right"}else{this._sAnimationAttribute="margin-left"}}this.showElementWithId(this._getItemIdByIndex(this.getFirstVisibleIndex()));this.calculateAndSetSize();this.oDomRef=this.getDomRef();this.sResizeListenerId=n.register(this.oDomRef,jQuery.proxy(this.onresize,this));this._initItemNavigation()};c.prototype._initItemNavigation=function(){var t=this.$("scrolllist");if(!this._oItemNavigation){this._oItemNavigation=new a;this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(a.Events.AfterFocus,function(t){var e=this.$("contentarea"),i=this.$("scrolllist");var s=t.getParameter("event");if(s&&s.type=="mousedown"){var o=false;for(var n=0;n<i.children().length;n++){var a=i.children()[n];if(s.target.id==a.id){o=true;break}}if(!o){s.target.focus()}}if(d.getRTL()){e.scrollLeft(i.width()-e.width())}else{e.scrollLeft(0)}},this)}this._oItemNavigation.setRootDomRef(t[0]);this._oItemNavigation.setItemDomRefs(t.children())};c.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this._oItemNavigation.destroy();this._oItemNavigation=undefined}};c.prototype.onThemeChanged=function(t){this.calculateAndSetSize()};c.prototype.onfocusin=function(t){var e=jQuery(t.target);if(!this._bIgnoreFocusIn&&(e.hasClass("sapUiCrslBefore")||e.hasClass("sapUiCrslAfter"))){this._leaveActionMode();jQuery(this._oItemNavigation.getFocusedDomRef()||this._oItemNavigation.getRootDomRef()).trigger("focus")}};c.prototype.onsaptabnext=function(t){var e=this.$();if(this._bActionMode){if(e.find(".sapUiCrslScl").lastFocusableDomRef()===t.target){e.find(".sapUiCrslScl").firstFocusableDomRef().focus();t.preventDefault();t.stopPropagation()}}else{if(this._oItemNavigation.getFocusedDomRef()===t.target){this._bIgnoreFocusIn=true;e.find(".sapUiCrslAfter").trigger("focus");this._bIgnoreFocusIn=false}}};c.prototype.onsaptabprevious=function(t){var e=this.$();if(this._bActionMode){if(e.find(".sapUiCrslScl").firstFocusableDomRef()===t.target){e.find(".sapUiCrslScl").lastFocusableDomRef().focus();t.preventDefault();t.stopPropagation()}}else{if(this._oItemNavigation.getFocusedDomRef()===t.target&&i(e.find(".sapUiCrslScl").get(0),t.target)){this._bIgnoreFocusIn=true;e.find(".sapUiCrslBefore").trigger("focus");this._bIgnoreFocusIn=false}}};c.prototype.onsapescape=function(t){this._leaveActionMode(t)};c.prototype.onsapnext=function(t){var e=jQuery(t.target);var i=this.$("scrolllist");i.stop(true,true);if(e.hasClass("sapUiCrslItm")&&e.nextAll(":visible").length<2){this.showNext();t.preventDefault()}};c.prototype.onsapprevious=function(t){var e=jQuery(t.target);var i=this.$("scrolllist");i.stop(true,true);if(e.hasClass("sapUiCrslItm")&&e.prevAll(":visible").length<2){this.showPrevious();t.preventDefault()}};c.prototype.onkeydown=function(t){var e=this.$();if(!this._bActionMode&&t.keyCode==h.F2||t.keyCode==h.ENTER){if(e.find(".sapUiCrslScl li:focus").length>0){this._enterActionMode(e.find(".sapUiCrslScl li:focus :sapFocusable").get(0));t.preventDefault();t.stopPropagation()}}else if(this._bActionMode&&t.keyCode==h.F2){this._leaveActionMode(t)}};c.prototype.onmouseup=function(t){if(this.$().find(".sapUiCrslScl li :focus").length>0){this._enterActionMode(this.$().find(".sapUiCrslScl li :focus").get(0))}else{this._leaveActionMode(t)}};if(l.support.touch){c.prototype.onswipeleft=function(t){this.showNext()};c.prototype.onswiperight=function(t){this.showPrevious()}}c.prototype._enterActionMode=function(t){if(t&&!this._bActionMode){this._bActionMode=true;this.removeDelegate(this._oItemNavigation);jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","-1");this.$("scrolllist").attr("aria-activedescendant",jQuery(this._oItemNavigation.getFocusedDomRef()).attr("id"));jQuery(t).trigger("focus")}};c.prototype._leaveActionMode=function(t){if(this._bActionMode){this._bActionMode=false;this.addDelegate(this._oItemNavigation);jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","0");this.$("scrolllist").removeAttr("aria-activedescendant");if(t){if(jQuery(t.target).closest("li[tabindex=-1]").length>0){var e=jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(t.target).closest("li[tabindex=-1]").get(0));this._oItemNavigation.focusItem(e,null)}else{if(i(this.$().find(".sapUiCrslScl").get(0),t.target)){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null)}}}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null)}}};c.prototype.onresize=function(t){if(!this.getDomRef()){if(this.sResizeListenerId){n.deregister(this.sResizeListenerId);this.sResizeListenerId=null}return}this.calculateAndSetSize()};c.prototype.showPrevious=function(){var t=this,e={},i=this.$("scrolllist");var s,o;e[this._sAnimationAttribute]=0;if(i.children("li").length<2){return}i.stop(true,true);i.css(this._sAnimationAttribute,-this._iMaxWidth);s=i.children("li:last");o=i.children("li:first");this._showAllItems();s.insertBefore(o);i.append(s.sapExtendedClone(true));i.animate(e,this.getAnimationDuration(),function(){i.children("li:last").remove();t.setProperty("firstVisibleIndex",t._getContentIndex(i.children("li:first").attr("id")),true);t._hideInvisibleItems()})};c.prototype.showNext=function(){var t=this,e={},i=this._sAnimationAttribute,s=this.$("scrolllist");var o;e[this._sAnimationAttribute]=-this._iMaxWidth;if(s.children("li").length<2){return}s.stop(true,true);this._showAllItems();o=s.children("li:first");o.appendTo(s);o.sapExtendedClone(true).insertBefore(s.children("li:first"));s.animate(e,this.getAnimationDuration(),function(){s.children("li:first").remove();jQuery(this).css(i,"0px");t.setProperty("firstVisibleIndex",t._getContentIndex(s.children("li:first").attr("id")),true);t._hideInvisibleItems()})};c.prototype.showElementWithId=function(t){this._showAllItems();var e=this.$("scrolllist"),i;i=e.children("li").index(this.getDomRef("item-"+t));e.children("li:lt("+i+")").appendTo(e);this._hideInvisibleItems()};c.prototype.calculateAndSetSize=function(){var t=this._getDimensions();var i=t.maxWidth;var s=t.maxHeight;var o;var n=this.getVisibleItems();var a=this.$();var r=this.$("nextbutton");var l=this.$("prevbutton");var h=this.$("contentarea");this._showAllItems();if(this.getContent().length<=0){return}if(this.getWidth()&&this.getOrientation()=="vertical"){i=a.width()}if(this.getHeight()&&this.getOrientation()=="horizontal"){s=a.height()}this.$().addClass("sapUiCrsl"+e(this.getOrientation()));if(this.getOrientation()=="horizontal"){o=a.width()-this.getHandleSize()*2-1;h.css("left",this.getHandleSize()+"px").css("right",this.getHandleSize()+"px");if(n==0){n=Math.floor(o/i)}i=o/n;this._iMaxWidth=i;var d=s+"px";h.find(".sapUiCrslItm").css("width",i+"px").css("height",s+"px").css("display","inline-block");l.css("height",s).css("line-height",d);r.css("height",s).css("line-height",d);h.height(s);a.height(s);var u=this.getContent().length<n?this.getContent().length:n;if(this.getWidth()){a.width(this.getWidth())}else{var c=a.width()-(i*u+(this.getHandleSize()*2-1));if(c>5){a.width(i*u+(this.getHandleSize()*2-1))}}}else{o=a.height()-this.getHandleSize()*2-1;h.css("top",this.getHandleSize()+"px").css("bottom",this.getHandleSize()+"px");if(n==0){n=Math.floor(o/s)}s=o/n;this._iMaxWidth=s;h.find(".sapUiCrslItm").css("width",i+"px").css("height",s+"px").css("display","block");l.width(i).after(h);r.width(i);h.width(i);a.width(i)}this._visibleItems=n;this._hideInvisibleItems()};c.prototype._getDimensions=function(){var t=this.getContent();var e=0;var i=0;for(var s=0;s<t.length;s++){var o,n;try{o=t[s].getWidth();if(o.substr(-1)=="%"){o=this.getDefaultItemWidth()}}catch(t){o=this.getDefaultItemWidth()}try{n=t[s].getHeight();if(n.substr(-1)=="%"){n=this.getDefaultItemHeight()}}catch(t){n=this.getDefaultItemHeight()}e=Math.max(e,parseInt(o));i=Math.max(i,parseInt(n))}if(e==0||isNaN(e)){e=this.getDefaultItemWidth()}if(i==0||isNaN(i)){i=this.getDefaultItemHeight()}return{maxWidth:e,maxHeight:i}};c.prototype.getFocusDomRef=function(){return this.$("scrolllist")[0]};c.prototype._showAllItems=function(){var t=this.$("contentarea");t.find(".sapUiCrslItm").show().css("display","inline-block")};c.prototype._hideInvisibleItems=function(){var t=this.$("contentarea");t.find(".sapUiCrslItm:gt("+(this._visibleItems-1)+")").hide()};c.prototype._getContentIndex=function(t){var e=t.split("-item-");return jQuery.inArray(sap.ui.getCore().byId(e[1]),this.getContent())};c.prototype._getItemIdByIndex=function(t){var e=this.getContent()[t];if(!e){return null}return e.getId()};c.prototype.setFirstVisibleIndex=function(e){if(e>this.getContent().length-1){t.warning("The index is invalid. There are less items available in the carousel.");return this}this.setProperty("firstVisibleIndex",e,true);this.showElementWithId(this._getItemIdByIndex(e));if(this._oItemNavigation){this._oItemNavigation.focusItem(e)}return this};
//Licensed under the terms of the MIT source code license
(function(t){jQuery.fn.sapExtendedClone=function(){var e=t.apply(this,arguments);var i=this.find("textarea").add(this.filter("textarea"));var s=e.find("textarea").add(e.filter("textarea"));var o=this.find("select").add(this.filter("select"));var n=e.find("select").add(e.filter("select"));for(var a=0,r=i.length;a<r;++a){jQuery(s[a]).val(jQuery(i[a]).val())}for(var a=0,r=o.length;a<r;++a){n[a].selectedIndex=o[a].selectedIndex}return e}})(jQuery.fn.clone);return c});
//# sourceMappingURL=Carousel.js.map