/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/base/Log","./TextField","sap/ui/model/type/Date","sap/ui/core/date/UniversalDate","./library","./DatePickerRenderer","sap/ui/core/format/DateFormat","sap/ui/core/library","sap/ui/Device","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Popup","sap/ui/dom/containsOrEquals","sap/ui/core/Configuration","sap/ui/dom/jquery/cursorPos"],function(jQuery,e,t,a,i,o,r,s,n,p,u,l,h,f,d){"use strict";var _=h.Dock;var y=n.CalendarType;var g=t.extend("sap.ui.commons.DatePicker",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{locale:{type:"string",group:"Misc",defaultValue:null},yyyymmdd:{type:"string",group:"Misc",defaultValue:null}}}});g.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oFormatYyyymmdd=s.getInstance({pattern:"yyyyMMdd",strictParsing:true,calendarType:y.Gregorian});if(!p.system.desktop){this._bMobile=true;this._oFormatMobile=s.getInstance({pattern:"yyyy-MM-dd",strictParsing:true,calendarType:y.Gregorian})}this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,99)};g.prototype.exit=function(){this._oDate=undefined;this._oLocale=undefined;if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close()}delete this._oPopup}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar}};g.prototype.onAfterRendering=function(){t.prototype.onAfterRendering.apply(this,arguments);if(this._bMobile){if(this._oDate){var e=jQuery(this.getInputDomRef());var a=this._oFormatMobile.format(this._oDate);e.val(a)}}};g.prototype.invalidate=function(e){if(!e||e!=this._oCalendar){t.prototype.invalidate.apply(this,arguments)}};g.prototype.onsapshow=function(e){var t=this;T(t);e.preventDefault()};g.prototype.onsaphide=g.prototype.onsapshow;g.prototype.onsappageup=function(e){var t=this;M(t,1,"day");e.preventDefault()};g.prototype.onsappageupmodifiers=function(e){var t=this;if(!e.ctrlKey&&e.shiftKey){M(t,1,"month")}else{M(t,1,"year")}e.preventDefault()};g.prototype.onsappagedown=function(e){var t=this;M(t,-1,"day");e.preventDefault()};g.prototype.onsappagedownmodifiers=function(e){var t=this;if(!e.ctrlKey&&e.shiftKey){M(t,-1,"month")}else{M(t,-1,"year")}e.preventDefault()};g.prototype.onkeypress=function(e){if(e.charCode){var t=this;var a=m(t);var i=String.fromCharCode(e.charCode);if(i&&a.sAllowedCharacters&&a.sAllowedCharacters.indexOf(i)<0){e.preventDefault()}}};g.prototype.onclick=function(e){if(jQuery(e.target).hasClass("sapUiTfDateIcon")&&!this._bMobile){var t=this;T(t)}};g.prototype.onsapfocusleave=function(e){if(this._oCalendar&&e.relatedControlId&&(f(this._oCalendar.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())||this.getId()==e.relatedControlId)){return}t.prototype.onsapfocusleave.apply(this,arguments)};g.prototype.setValue=function(t){var a=this.getValue();if(t==a){return this}var i=this;D(i);this.setProperty("value",t,true);this._bValueSet=true;if(t){this._oDate=this._parseValue(t);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;e.warning("Value can not be converted to a valid date",this)}}else{this._oDate=undefined}var o="";if(this._oDate){o=this._oFormatYyyymmdd.format(this._oDate)}this.setProperty("yyyymmdd",o,true);if(this.getDomRef()){var r="";var s=jQuery(this.getInputDomRef());if(this._bMobile&&this._oDate){r=this._oFormatMobile.format(this._oDate)}else{r=t}s.val(r)}return this};g.prototype.setYyyymmdd=function(t){var a=this.getYyyymmdd();if(t==a){return this}this.setProperty("yyyymmdd",t,true);this._bValueSet=false;var i="";if(t){this._oDate=this._oFormatYyyymmdd.parse(t);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;e.warning("Value can not be converted to a valid date",this)}}else{this._oDate=undefined}if(this._oDate){i=this._formatValue(this._oDate)}this.setProperty("value",i,true);if(this.getDomRef()){var o="";var r=jQuery(this.getInputDomRef());if(this._bMobile&&this._oDate){o=this._oFormatMobile.format(this._oDate)}else{o=i}r.val(o)}return this};g.prototype.setLocale=function(t){var a=this.getLocale();if(t==a){return this}this.setProperty("locale",t,true);var i=this;D(i);this._oLocale=new u(t);this._sUsedPattern=undefined;var o="";if(this._bValueSet){o=this.getValue();if(o){this._oDate=this._parseValue(o);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;e.warning("Value can not be converted to a valid date",this)}}else{this._oDate=undefined}var r="";if(this._oDate){r=this._oFormatYyyymmdd.format(this._oDate)}this.setProperty("yyyymmdd",r,true)}else{if(this._oDate){o=this._formatValue(this._oDate)}this.setProperty("value",o,true)}if(this.getDomRef()){var s="";var n=jQuery(this.getInputDomRef());if(this._bMobile&&this._oDate){s=this._oFormatMobile.format(this._oDate)}else{s=o}n.val(s)}return this};g.prototype.oninput=function(e){if(this._bMobile){var a=this.getInputDomRef();var i=a&&a.value;if(i){var o=this._oFormatMobile.parse(i)}if(!i||o){this._checkChange(e)}}else{t.prototype.oninput.apply(this,arguments)}};g.prototype._checkChange=function(e){var t=this.getInputDomRef();var a=t&&t.value;if(this._bMobile&&a!=""){this._oDate=this._oFormatMobile.parse(a);a=this._formatValue(this._oDate)}if(this.getEditable()&&this.getEnabled()&&a!=this.getValue()){var i=false;if(a!=""){if(!this._bMobile){this._oDate=this._parseValue(a);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;i=true}else{a=this._formatValue(this._oDate);t.value=a;if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar.focusDate(this._oDate);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=this._oDate.getTime()){this._oDateRange.setStartDate(new Date(this._oDate.getTime()))}}}}}else{this._oDate=undefined}this.setProperty("value",a,true);this._bValueSet=false;if(!i){var o="";if(this._oDate){o=this._oFormatYyyymmdd.format(this._oDate)}this.setProperty("yyyymmdd",o,true)}this.fireChange(i)}else if(this.getEditable()&&this.getEnabled()&&a==this.getYyyymmdd()){t.value=this.getValue()}};g.prototype.fireChange=function(e,t){if(!(typeof e==="object")){t=e}this.fireEvent("change",{newValue:this.getValue(),newYyyymmdd:this.getYyyymmdd(),invalidValue:t});return this};g.prototype._parseValue=function(e){var t=this;var a=m(t);var i=a.parse(e);return i};g.prototype._formatValue=function(e){var t=this;var a=m(t);var i=a.format(e);return i};g.prototype.getAccessibilityInfo=function(){var e=t.prototype.getAccessibilityInfo.apply(this,arguments);e.type=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_DATEINPUT");return e};function m(e){var t="";var i=false;var o=e.getBinding("value");var r;var n;if(o&&o.oType&&o.oType instanceof a){t=o.oType.getOutputPattern();i=!!o.oType.oOutputFormat.oFormatOptions.relative;n=o.oType.oOutputFormat.oFormatOptions.calendarType}if(!t){r=c(e);var p=l.getInstance(r);t=p.getDatePattern("medium");n=d.getCalendarType()}if(t!=e._sUsedPattern||n!=e._sUsedCalendarType){e._sUsedPattern=t;e._sUsedCalendarType=n;if(t=="short"||t=="medium"||t=="long"){e._oFormat=s.getInstance({style:t,strictParsing:true,relative:i,calendarType:n},r)}else{e._oFormat=s.getInstance({pattern:t,strictParsing:true,relative:i,calendarType:n},r)}}return e._oFormat}function c(e){var t=e.getLocale();var a;if(t){a=e._oLocale}else{a=d.getFormatSettings().getFormatLocale()}return a}function D(t){var i=t.getBinding("value");var o=t.getLocale();if(i&&i.oType&&i.oType instanceof a&&o){e.warning("DatePicker "+t.getId()+": Using a locale and Databinding at the same time is not supported");t._bIgnoreLocale=true}}function v(e){if(!e._oPopup){e._oPopup=new h;e._oPopup.setAutoClose(true);e._oPopup.setDurations(0,0);e._oPopup.attachClosed(P,e)}if(!e._oCalendar){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.require("sap/ui/unified/library");e._oCalendar=new sap.ui.unified.Calendar(e.getId()+"-cal");e._oDateRange=new sap.ui.unified.DateRange;e._oCalendar.addSelectedDate(e._oDateRange);e._oCalendar.attachSelect(b,e);e._oCalendar.attachCancel(C,e);e._oPopup.setContent(e._oCalendar);e._oCalendar.addStyleClass("sapUiSizeCompact");e._oCalendar.setParent(e,undefined,true)}var t="";if(e._oDate){t=e._formatValue(e._oDate)}if(t!=e.$("input").val()){e._checkChange()}var i;var o=e.getBinding("value");if(o&&o.oType&&o.oType instanceof a){i=o.oType.oOutputFormat.oFormatOptions.calendarType}if(i){e._oCalendar.setPrimaryCalendarType(i)}var r=e._oDate;if(r){e._oCalendar.focusDate(r);if(!e._oDateRange.getStartDate()||e._oDateRange.getStartDate().getTime()!=r.getTime()){e._oDateRange.setStartDate(new Date(r.getTime()))}}else{e._oCalendar.focusDate(new Date);if(e._oDateRange.getStartDate()){e._oDateRange.setStartDate(undefined)}}if(!e._bIgnoreLocale){e._oCalendar.setLocale(e.getLocale())}e._oPopup.setAutoCloseAreas([e.getDomRef()]);e._oPopup.open(0,_.BeginTop,_.BeginBottom,e,null,null,true)}function T(e){if(e.getEditable()&&e.getEnabled()){if(!e._oPopup||!e._oPopup.isOpen()){v(e)}else{e._oPopup.close();e.focus()}}}function b(e){var t=this._oCalendar.getSelectedDates();var a="";if(t.length>0){this._oDate=t[0].getStartDate();a=this._formatValue(this._oDate)}this._oPopup.close();this.focus();var i=this._formatValue(this._oDate);this.setProperty("value",i,true);this._bValueSet=false;var o=this._oFormatYyyymmdd.format(this._oDate);this.setProperty("yyyymmdd",o,true);var r=this.$("input");if(r.val()!==a){r.val(a);this._curpos=a.length;r.cursorPos(this._curpos)}this.fireChange()}function C(e){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();this.focus()}}function P(e){if(!f(this.getDomRef(),document.activeElement)&&this.getRenderer().onblur){this.getRenderer().onblur(this)}}function M(e,t,o){var r=e._oDate;if(r&&e.getEditable()&&e.getEnabled()){var s=e.getBinding("value");var n;if(s&&s.oType&&s.oType instanceof a){n=s.oType.oOutputFormat.oFormatOptions.calendarType}else{n=d.getCalendarType()}var p=i.getInstance(new Date(r.getTime()),n);r=i.getInstance(new Date(r.getTime()),n);var u=jQuery(e.getInputDomRef());var l=u.cursorPos();switch(o){case"day":p.setDate(p.getDate()+t);break;case"month":p.setMonth(p.getMonth()+t);var h=(r.getMonth()+t)%12;if(h<0){h=12+h}while(p.getMonth()!=h){p.setDate(p.getDate()-1)}break;case"year":p.setFullYear(p.getFullYear()+t);while(p.getMonth()!=r.getMonth()){p.setDate(p.getDate()-1)}break;default:break}if(p.getTime()<e._oMinDate.getTime()){p=new i(e._oMinDate.getTime())}else if(p.getTime()>e._oMaxDate.getTime()){p=new i(e._oMaxDate.getTime())}e._oDate=new Date(p.getTime());var f=e._formatValue(e._oDate);u.val(f);u.cursorPos(l)}}return g});
//# sourceMappingURL=DatePicker.js.map