/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/containsOrEquals","./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/RenderManager","./DialogRenderer","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Selectors"],function(jQuery,t,e,i,o,s,n,r,a,h,u){"use strict";var p=a.OpenState;var l=a.AccessibleRole;var d=i.enums.BorderDesign;var f=o.extend("sap.ui.commons.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},scrollLeft:{type:"int",group:"Behavior",defaultValue:0},scrollTop:{type:"int",group:"Behavior",defaultValue:0},title:{type:"string",group:"Misc",defaultValue:""},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},showCloseButton:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentBorderDesign:{type:"sap.ui.commons.enums.BorderDesign",group:"Appearance",defaultValue:d.None},modal:{type:"boolean",group:"Misc",defaultValue:false},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:l.Dialog},keepInWindow:{type:"boolean",group:"Behavior",defaultValue:false},autoClose:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{defaultButton:{type:"sap.ui.commons.Button",multiple:false},initialFocus:{type:"sap.ui.core.Control",multiple:false}},events:{closed:{parameters:{width:{type:"int"},height:{type:"int"},top:{type:"int"},left:{type:"int"}}}}}});f.prototype.init=function(){this.oPopup=new s(this,true,true);this._minWidth=64;this._minHeight=48;this.allowTextSelection(false);this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-fhfe";this._mParameters.lastFocusable=this.getId()+"-fhee";this._fnOnResizeRecenter=jQuery.proxy(this._onResize,this)};f.prototype.setInitialFocus=function(t){if(t&&typeof t!="string"){t=t.getId()}this.oPopup.setInitialFocusId(t);this.setAssociation("initialFocus",t,true);return this};f.prototype.onAfterRendering=function(){var t=this.$("cont");var e=this.getMinSize();this._minWidth=e.width;this._minHeight=e.height;if(!this._isSizeSet(this.getWidth())&&!this._isSizeSet(this.getMaxWidth())){t.children().each(function(t,e){if(this.style.width.trim()=="100%"){this.style.width="auto"}})}if(!this._isSizeSet(this.getHeight())&&this._isSizeSet(this.getMinHeight())){var i=this.getDomRef("footer");var o=i.offsetTop+i.offsetHeight;var s=this.getDomRef().offsetHeight;if(o<s){this.$().removeClass("sapUiDlgFlexHeight")}}};f.prototype.onclick=function(t){var e=this.getId()+"-close";if(t.target.id===e){this.close();t.preventDefault()}return false};f.prototype.open=function(){if(!this.oPopup){t.fatal("This dialog instance has been destroyed already")}else if(!this._bOpen){this._oPreviousFocus=s.getCurrentFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);this.oPopup.attachEvent("closed",this.handleClosed,this);this.oPopup.setModal(this.getModal());this.oPopup.setAutoClose(this.getAutoClose());this.oPopup.open(400);this._onResize();this._bOpen=true;this._registerContentResizeHandler()}};f.prototype.onThemeChanged=function(){this.invalidate()};f.prototype._handleOpened=function(){this.$().show();var t=this.getInitialFocus();var e;this._bInitialFocusSet=true;if(t){sap.ui.getCore().byId(t).focus();return}t=this.getDefaultButton();e=jQuery(":sapTabbable",this.$("cont"));if(t){sap.ui.getCore().byId(t).focus()}else if(this.getButtons().length){this.getButtons()[0].focus()}else if(this.getContent().length&&e.length){e[0].focus()}else{var i=document.getElementById(this._mParameters.firstFocusable);if(i){i.focus()}}};f.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);this._handleOpened()};f.prototype.close=function(){if(!this._bOpen){return}var t=this.$().rect();this._bOpen=false;this._bInitialFocusSet=false;if(this.oPopup.isOpen()){this.oPopup.close(400)}setTimeout(function(){this.restorePreviousFocus()}.bind(this),400);jQuery.each(t,function(e,i){t[e]=parseInt(i)});this._oRect=t};f.prototype.handleClosed=function(){this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.fireClosed(this._oRect);this.close();if(this.getDomRef()){n.preserveContent(this.getDomRef());this.$().remove()}};f.prototype.restorePreviousFocus=function(){s.applyFocusInfo(this._oPreviousFocus)};f.prototype.setTitle=function(t){this.setProperty("title",t,true);this.$("lbl").text(t);return this};f.prototype.exit=function(){var t=this.isOpen();this.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.oPopup.destroy();if(t){this.fireClosed(this._oRect)}this.oPopup=null;clearTimeout(this._sDelayedCall);this._sDelayedCall=null;delete this._mParameters;this._fnOnResizeRecenter=null};f.prototype._isSizeSet=function(t){return!!(t&&t!=="auto"&&t!=="inherit")};f.prototype.onsapescape=function(t){this.close();t.preventDefault();t.stopPropagation()};f.prototype.onsapenter=function(t){var e,i=this.getDefaultButton();if(i&&(e=sap.ui.getCore().byId(i))&&jQuery.contains(this.getDomRef(),e.getDomRef())){if(e instanceof sap.ui.commons.Button){e.onclick(t)}}t.preventDefault();t.stopPropagation()};f.prototype.onfocusin=function(t){this.sLastRelevantNavigation=null;if(!this._bInitialFocusSet){return}this._mParameters.event=t;this._mParameters.$FocusablesContent=jQuery(":sapTabbable",this.$("cont"));this._mParameters.$FocusablesFooter=jQuery(":sapTabbable",this.$("footer"));this.oPopup.focusTabChain(this._mParameters)};f.prototype.restoreFocus=function(){if(this.oRestoreFocusInfo&&this.oPopup.bOpen){var t=sap.ui.getCore().byId(this.oRestoreFocusInfo.sFocusId);if(t){t.applyFocusInfo(this.oRestoreFocusInfo.oFocusInfo)}}};f.prototype.onselectstart=function(t){if(!e(this.getDomRef("cont"),t.target)){t.preventDefault();t.stopPropagation()}};f.prototype.getMinSize=function(){var t=36;var e=this.$();var i=this.$("hdr");var o=this.$("footer");var s=o.children("DIV").get(0);var n=s?s.offsetWidth:0;var r=o.css("display")!=="none";var a=0;var h;var u;a+=o.outerWidth(false)-o.width();a+=e.outerWidth(false)-e.width();if(a<=20){a=20}n+=a;if(n<100){n=100}h=i.outerHeight(false);u=o.outerHeight(false);return{width:n,height:h+u+(r?t:0)}};f.prototype.forceInvalidate=o.prototype.invalidate;f.prototype.invalidate=function(t){if(this.oPopup&&(this.oPopup.eOpenState!=="CLOSING"||this.isOpen())){this.forceInvalidate(t)}};f.prototype.isOpen=function(){return this.oPopup.isOpen()};f.prototype.getOpenState=function(){return this.oPopup.getOpenState()};f.prototype.getEnabled=function(){var t=this.getOpenState();return t===p.OPENING||t===p.OPEN};f.prototype.ondragstart=function(t){if(this.sDragMode=="resize"||this.sDragMode=="move"){t.preventDefault();t.stopPropagation()}};f.prototype.onmousedown=function(t){var i=t.target,o=this.getId();this._bRtlMode=u.getRTL();var s=this.getDomRef();if(e(this.getDomRef("hdr"),i)){if(i.id!=o+"-close"){this.sDragMode="move";this._RootWidth=s.offsetWidth;this._RootHeight=s.offsetHeight}}else if(i.id==o+"-grip"){this.sDragMode="resize";var n=s.offsetWidth+"px";var r=s.offsetHeight+"px";s.style.width=n;s.style.height=r;jQuery(s).removeClass("sapUiDlgFlexHeight sapUiDlgFlexWidth");this.setProperty("width",n,true);this.setProperty("height",r,true)}if(!this.sDragMode){return}var a=document.activeElement;if(a&&a.id){var h=jQuery(a).control(0);if(h){this.oRestoreFocusInfo={sFocusId:h.getId(),oFocusInfo:h.getFocusInfo()}}}this.startDragX=t.screenX;this.startDragY=t.screenY;this.originalRectangle=this.$().rect();jQuery(window.document).on("selectstart",jQuery.proxy(this.ondragstart,this));jQuery(window.document).on("mousemove",jQuery.proxy(this.handleMove,this));jQuery(window.document).on("mouseup",jQuery.proxy(this.handleMouseUp,this));var p=this._findSameDomainParentWinDoc();if(p){jQuery(p).on("selectstart",jQuery.proxy(this.ondragstart,this));jQuery(p).on("mousemove",jQuery.proxy(this.handleMove,this));jQuery(p).on("mouseup",jQuery.proxy(this.handleMouseUp,this))}};f.prototype._findSameDomainParentWinDoc=function(){var t=null;try{var e=window;while(e.parent&&e.parent!=e){if(e.parent.document){t=e.parent.document;e=e.parent}}}catch(t){}return t};f.prototype.handleMove=function(t){if(!this.sDragMode){return}t=t||window.event;this._deregisterContentResizeHandler();if(this.sDragMode=="resize"){var e=t.screenX-this.startDragX||0;var i=t.screenY-this.startDragY||0;var o=(this._bRtlMode?this.originalRectangle.width-e:this.originalRectangle.width+e)||0;var n=this.originalRectangle.height+i||0;o=Math.max(o,this._minWidth);n=Math.max(n,this._minHeight);var r=this.getDomRef();r.style.width=o+"px";r.style.height=n+"px";o=r.offsetWidth;n=r.offsetHeight;this.setProperty("width",o+"px",true);this.setProperty("height",n+"px",true)}else if(this.sDragMode=="move"){var a=this.originalRectangle.left+t.screenX-this.startDragX;var h=this.originalRectangle.top+t.screenY-this.startDragY;h=Math.max(h,window.pageYOffset);if(this._bRtlMode||this._keepInWindow()){a=Math.min(a,document.documentElement.clientWidth+window.pageXOffset-this._RootWidth)}if(!this._bRtlMode||this._keepInWindow()){a=Math.max(a,0)}if(this._keepInWindow()){h=Math.min(h,document.documentElement.clientHeight+window.pageYOffset-this._RootHeight)}this.oPopup.setPosition(s.Dock.LeftTop,{left:a,top:h})}t.cancelBubble=true;this._registerContentResizeHandler();return false};f.prototype._keepInWindow=function(){return this.getKeepInWindow()||this.getModal()};f.prototype.handleMouseUp=function(t){if(this.sDragMode===null){return}jQuery(window.document).off("selectstart",this.ondragstart);jQuery(window.document).off("mousemove",this.handleMove);jQuery(window.document).off("mouseup",this.handleMouseUp);var e=this._findSameDomainParentWinDoc();if(e){jQuery(e).off("selectstart",this.ondragstart);jQuery(e).off("mousemove",this.handleMove);jQuery(e).off("mouseup",this.handleMouseUp)}this.restoreFocus();this.sDragMode=null};f.setAutoClose=function(t){this.oPopup.setAutoClose(t)};f.getAutoClose=function(){this.oPopup.getAutoClose()};f.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){h.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null}};f.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=h.register(this.getDomRef("cont"),this._fnOnResizeRecenter)}};f.prototype._onResize=function(){var t=s.Dock;if(this.oPopup){this.oPopup.setPosition(t.CenterCenter,t.CenterCenter,window)}};return f});
//# sourceMappingURL=Dialog.js.map