/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TextField","./TextView","./library","sap/ui/core/Control","sap/ui/core/ValueStateSupport","sap/ui/core/theming/Parameters","./InPlaceEditRenderer","sap/ui/core/library","sap/ui/Device","./Button","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes"],function(t,e,i,o,s,n,a,l,r,d,h,u){"use strict";var _=i.TextViewDesign;var f=l.ValueState;var p=o.extend("sap.ui.commons.InPlaceEdit",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:f.None},undoEnabled:{type:"boolean",group:"Misc",defaultValue:true},design:{type:"sap.ui.commons.TextViewDesign",group:"Data",defaultValue:_.Standard}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},events:{change:{parameters:{newValue:{type:"string"}}},liveChange:{parameters:{liveValue:{type:"string"}}}}}});p.prototype.init=function(){this._bEditMode=false};p.prototype.exit=function(){this._bEditMode=undefined;this._oDisplayControl=undefined;this._oEditControl=undefined;this._sOldText=undefined;this._sOldTextAvailable=undefined;this._bUseEditButton=undefined;this._iHeight=undefined;if(this._oTextView){this._oTextView.destroy();delete this._oTextView}if(this._oTextField){this._oTextField.destroy();delete this._oTextField}if(this._oUndoButton){this._oUndoButton.destroy();delete this._oUndoButton}if(this._oEditButton){this._oEditButton.destroy();delete this._oEditButton}var e=this.getContent();if(e){e.detachEvent("_change",B,this);if(e instanceof t){e.detachEvent("change",w,this);e.detachEvent("liveChange",D,this)}}};p.prototype.onBeforeRendering=function(){var t=this;g(t);x(t);var e=this.getTooltip();if(e instanceof sap.ui.core.TooltipBase){if(this._bEditMode){e._currentControl=this._oEditControl}else{e._currentControl=this._oDisplayControl}}};p.prototype.onAfterRendering=function(){if(!this._bEditMode&&this.getEditable()&&this._oTextView&&this._oTextView.getDomRef()){this._oTextView.$().attr("tabindex","0")}var t=this.$();var e;var i;if(this._bEditMode){this._oEditControl.$().css("width","100%");if(this._iHeight>0){i=t.height();var o=this._iHeight-i;var s=t.outerHeight(true)-t.outerHeight(false);o=o+s;var n=Math.floor(o/2);var a=o-n;t.css("margin-top",n+"px").css("margin-bottom",a+"px")}}else if(this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){this._oDisplayControl.$().css("width","auto").css("max-width","100%")}else{var l=this._oDisplayControl.$();l.css("width","100%");if(!this._iHeight&&this._iHeight!=0&&this.getDesign()!=_.Standard){e=l.outerHeight(true);i=t.innerHeight();if(i<e){var r=t.outerHeight()-t.innerHeight();this._iHeight=e+r}else{this._iHeight=0}}if(this._iHeight>0){t.css("height",this._iHeight+"px")}}if(this._sOldTextAvailable&&this._oUndoButton&&this._oUndoButton.getDomRef()){this._oUndoButton.$().attr("tabindex","-1")}if(this._oEditButton&&this._oEditButton.getDomRef()){this._oEditButton.$().attr("tabindex","-1")}if(this._delayedCallId){clearTimeout(this._delayedCallId);this._delayedCallId=null}if(this.getValueState()==f.Success){this._delayedCallId=setTimeout(function(){this.removeValidVisualization()}.bind(this),3e3)}};p.prototype.removeValidVisualization=function(){var t=this.$();if(t){t.removeClass("sapUiIpeSucc")}};p.prototype.clearOldText=function(){if(!this.getUndoEnabled()){return}if(this._bEditMode){this._sOldText=this._oEditControl.getValue();this._sOldTextAvailable=true}else{this._sOldText=undefined;this._sOldTextAvailable=false}this.rerender()};p.prototype.getRequired=function(){if(this.getContent()&&this.getContent().getRequired){return this.getContent().getRequired()}else{return false}};p.prototype.getEditable=function(){var t=this.getContent();if(!t||t.getEditable&&!t.getEditable()||t.getEnabled&&!t.getEnabled()){return false}else{return true}};p.prototype.onsapescape=function(t){if(this.getUndoEnabled()){if(!r.browser.firefox){var e=this;b(e)}else{this._bEsc=true}if(this.$().hasClass("sapUiIpeUndo")){t.stopPropagation()}this._oEditControl._bEsc=undefined;this._oEditControl._sValue=undefined}};p.prototype.onkeypress=function(t){if(this._bEsc){var e=this;this._bEsc=undefined;b(e)}};p.prototype.onkeydown=function(t){if(t.keyCode==u.F2&&!this._bEditMode){var e=this;T(e);this.$().addClass("sapUiIpeFocus")}};p.prototype.onfocusin=function(t){if(!this._bEditMode){if(!this._bUseEditButton&&t.target.id!=this.getId()+"--X"){var e=this;T(e)}this.$().addClass("sapUiIpeFocus")}else if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null}};p.prototype.ontap=function(t){if(r.os.name=="iOS"){this.onfocusin(t)}};p.prototype.onfocusout=function(t){if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null}this._focusDelay=setTimeout(function(){this._handleFocusOut(t)}.bind(this),200)};p.prototype._handleFocusOut=function(t){var e=document.activeElement;if(!h(this.getDomRef(),e)){if(!this._bEditMode){this.$().removeClass("sapUiIpeFocus")}var i=this;E(i)}this._focusDelay=undefined};p.prototype.setContent=function(e){var i=this.getContent();if(i){i.detachEvent("_change",B,this);if(i instanceof t){i.detachEvent("change",w,this);i.detachEvent("liveChange",D,this);i._propagateEsc=undefined}}this._sOldText=undefined;this._sOldTextAvailable=false;this._oDisplayControl=undefined;this._oEditControl=undefined;this.setAggregation("content",e);if(e){e.attachEvent("_change",B,this);if(e instanceof t){e.attachEvent("change",w,this);e.attachEvent("liveChange",D,this);e._propagateEsc=true}}var o=this;g(o);return this};p.prototype.setValueState=function(t){var e=this.getContent();if(e&&e.setValueState){e.setValueState(t)}else if(this._oEditControl&&this._oEditControl.setValueState){this._oEditControl.setValueState(t);B.call(this)}else{this.setProperty("valueState",t)}return this};p.prototype.getValueState=function(){var t=this.getContent();if(t&&t.getValueState){return t.getValueState()}else if(this._oEditControl&&this._oEditControl.getValueState){return this._oEditControl.getValueState()}else{return this.getProperty("valueState")}};p.prototype.setTooltip=function(t){var e=this.getContent();if(e){e.setTooltip(t)}else{this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t)}return this};p.prototype.getTooltip=function(){var t=this.getContent();if(t){return t.getTooltip()}else{return this.getAggregation("tooltip")}};p.prototype.setDesign=function(t){this.setProperty("design",t);this._iHeight=undefined;return this};p.prototype.clone=function(){var e=this.getContent();if(e){e.detachEvent("_change",B,this);if(e instanceof t){e.detachEvent("change",w,this);e.detachEvent("liveChange",D,this)}}var i=o.prototype.clone.apply(this,arguments);if(e){e.attachEvent("_change",B,this);if(e instanceof t){e.attachEvent("change",w,this);e.attachEvent("liveChange",D,this)}}return i};p.prototype.getFocusDomRef=function(){if(!this.getDomRef()){return undefined}if(this._bEditMode){return this._oEditControl.getFocusDomRef()}else{return this._oDisplayControl.getFocusDomRef()}};p.prototype.getIdForLabel=function(){if(this._oDisplayControl&&this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){return this._oDisplayControl.getId()}else if(this._oEditControl){return this._oEditControl.getId()}else{return this.getId()}};p.prototype.onThemeChanged=function(t){var e=this;C(e);V(e);this._iHeight=undefined;if(this.getDomRef()&&!this._bEditMode){this.rerender()}};p.prototype.getAccessibilityInfo=function(){var t=this.getContent();return t&&t.getAccessibilityInfo?t.getAccessibilityInfo():null};var c={onAfterRendering:function(){this.onAfterRendering()}};function g(t){var i=t.getContent();if(!i){return}var o=i.getTooltip();switch(i.getMetadata().getName()){case"sap.ui.commons.TextField":case"sap.ui.commons.ComboBox":case"sap.ui.commons.DropdownBox":if(!t._oTextView){t._oTextView=new e(t.getId()+"--TV",{wrapping:false});t._oTextView.setParent(t);t._oTextView.removeDelegate(c);t._oTextView.addDelegate(c,t);t._oTextView.getTooltip=function(){return this.getParent().getTooltip()}}t._oTextView.setText(i.getValue());t._oTextView.setEnabled(i.getEnabled());t._oTextView.setTextDirection(i.getTextDirection());t._oTextView.setVisible(i.getVisible());t._oTextView.setWidth("100%");t._oTextView.setTextAlign(i.getTextAlign());t._oTextView.setDesign(t.getDesign());t._oTextView.setHelpId(i.getHelpId());t._oTextView.setAccessibleRole(i.getAccessibleRole());if(t._oTextView._oTooltip&&t._oTextView._oTooltip!=o){t._oTextView.removeDelegate(t._oTextView._oTooltip);t._oTextView._oTooltip=undefined}if(o instanceof sap.ui.core.TooltipBase){if(!t._oTextView._oTooltip||t._oTextView._oTooltip!=o){t._oTextView.addDelegate(o);t._oTextView._oTooltip=o}}t._oDisplayControl=t._oTextView;t._oEditControl=i;t._bUseEditButton=false;break;case"sap.ui.commons.Link":t._oDisplayControl=i;t._oDisplayControl.removeDelegate(c);t._oDisplayControl.addDelegate(c,t);if(t._oTextField){t._oTextField.setValue(i.getText());t._oTextField.setWidth("100%");t._oEditControl=t._oTextField;if(t._oTextField._oTooltip&&t._oTextField._oTooltip!=o){t._oTextField.removeDelegate(t._oTextField._oTooltip);t._oTextField._oTooltip=undefined}if(o instanceof sap.ui.core.TooltipBase){if(!t._oTextField._oTooltip||t._oTextField._oTooltip!=o){t._oTextField.addDelegate(o);t._oTextField._oTooltip=o}}}y(t);t._bUseEditButton=true;break;default:throw new Error("Control not supported for InPlaceEdit")}}function T(e){if(!e._bEditMode&&e.getEditable()){if(!e._oEditControl&&e.getContent().getMetadata().getName()=="sap.ui.commons.Link"){var i=e.getValueState();e._oTextField=new t(e.getId()+"--input",{valueState:i});e._oTextField.setParent(e);e._oTextField.attachEvent("change",U,e);e._oTextField.attachEvent("liveChange",D,e);e._oTextField._propagateEsc=true;e._oTextField.getTooltip=function(){return this.getParent().getTooltip()}}if(!e._sOldTextAvailable&&e.getUndoEnabled()){e._sOldText=v(e);e._sOldTextAvailable=true}e._bEditMode=true;e.rerender();e._oEditControl.focus()}}function E(t){if(t._bEditMode&&t.getEditable()){t._bEditMode=false;if(t._sOldText==v(t)){t._sOldText=undefined;t._sOldTextAvailable=false}t.rerender()}}function v(t){var e=t.getContent();if(!e){return undefined}if(e.getValue){return e.getValue()}else if(e.getText){return e.getText()}}function x(t){if(!t._oUndoButton&&t.getUndoEnabled()){t._oUndoButton=new d(t.getId()+"--X",{lite:true}).setParent(t);C(t);t._oUndoButton.attachEvent("press",m,t)}if(t._oUndoButton){t._oUndoButton.setEnabled(t.getEditable())}}function C(t){if(t._oUndoButton){var e=n._getThemeImage("_sap_ui_commons_InPlaceEdit_UndoImageURL");var i=n._getThemeImage("_sap_ui_commons_InPlaceEdit_UndoImageDownURL");if(!e){e="sap-icon://decline"}t._oUndoButton.setIcon(e);t._oUndoButton.setIconHovered(i)}}function m(t){var e=this;b(e);if(this._bEditMode){this._oEditControl.focus();this.$().removeClass("sapUiIpeUndo")}}function b(t){if(t.getUndoEnabled()&&t._sOldTextAvailable){var e=t.getContent();if(!e){return}if(e.setValue){e.setValue(t._sOldText)}else if(e.setText){e.setText(t._sOldText)}if(t._bEditMode){t._oEditControl.setValue(t._sOldText);t._oEditControl.fireChange({newValue:t._sOldText})}else if(e.fireChange){e.fireChange({newValue:t._sOldText})}else{t.fireChange({newValue:t._sOldText})}if(!t._bEditMode){t._sOldText=undefined;t._sOldTextAvailable=false}}}function y(t){if(!t._oEditButton){t._oEditButton=new d(t.getId()+"--Edit",{lite:true}).setParent(t);t._oEditButton.addStyleClass("sapUiIpeEBtn");V(t);t._oEditButton.attachEvent("press",I,t)}}function V(t){if(t._oEditButton){var e=n._getThemeImage("_sap_ui_commons_InPlaceEdit_EditImageURL");var i=n._getThemeImage("_sap_ui_commons_InPlaceEdit_EditImageDownURL");if(!e){e="sap-icon://edit"}t._oEditButton.setIcon(e);t._oEditButton.setIconHovered(i)}}function I(t){var e=this;T(e);this.$().addClass("sapUiIpeFocus")}function U(t){var e=this.getContent();if(e.setText){var i=t.getParameter("newValue");e.setText(i);w.apply(this,arguments)}}function w(t){if(this._sOldText!=t.getParameter("newValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo")}else{this.$().removeClass("sapUiIpeUndo")}this.fireChange(t.getParameters())}function D(t){if(this._sOldText!=t.getParameter("liveValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo")}else{this.$().removeClass("sapUiIpeUndo")}this.fireLiveChange({liveValue:t.getParameter("liveValue")})}function B(){if(!this._bEditMode){this.invalidate()}else{switch(this.getValueState()){case f.Error:if(!this.$().hasClass("sapUiIpeErr")){this.$().addClass("sapUiIpeErr");this.$().removeClass("sapUiIpeWarn");this.$().removeClass("sapUiIpeSucc")}break;case f.Success:if(!this.$().hasClass("sapUiIpeSucc")){this.$().addClass("sapUiIpeSucc");this.$().removeClass("sapUiIpeErr");this.$().removeClass("sapUiIpeWarn")}break;case f.Warning:if(!this.$().hasClass("sapUiIpeWarn")){this.$().addClass("sapUiIpeWarn");this.$().removeClass("sapUiIpeErr");this.$().removeClass("sapUiIpeSucc")}break;default:this.$().removeClass("sapUiIpeWarn");this.$().removeClass("sapUiIpeErr");this.$().removeClass("sapUiIpeSucc");break}}}return p});
//# sourceMappingURL=InPlaceEdit.js.map