/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./RatingIndicatorRenderer","sap/ui/events/checkMouseEnterOrLeave"],function(jQuery,e,t,a,i){"use strict";var r=e.RatingIndicatorVisualMode;var o=t.extend("sap.ui.commons.RatingIndicator",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{editable:{type:"boolean",group:"Behavior",defaultValue:true},maxValue:{type:"int",group:"Behavior",defaultValue:5},value:{type:"float",group:"Behavior",defaultValue:0,bindable:"bindable"},averageValue:{type:"float",group:"Behavior",defaultValue:0},iconSelected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconUnselected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},visualMode:{type:"sap.ui.commons.RatingIndicatorVisualMode",group:"Behavior",defaultValue:r.Half}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"int"}}}}}});o.NoValue=-9999;o.prototype.init=function(){this.iHoveredRating=-1};o.prototype.exit=function(){};o.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};o.prototype.ondragstart=function(e){e.preventDefault()};o.prototype._getDisplayValue=function(){var e=this.getValue();if(e==o.NoValue){return this.getAverageValue()}else{return e}};o.prototype.onsapincrease=function(e){var t=this.iHoveredRating;if(t==-1){t=Math.round(this._getDisplayValue())-1;if(t==-1){t=0}}if(t<this.getMaxValue()){t=t+1}else{t=this.getMaxValue()}this.updateHoverState(e,t)};o.prototype.onsapdecrease=function(e){var t=this.iHoveredRating;if(t==-1&&Math.round(this._getDisplayValue())==0){return}if(t==-1){t=Math.round(this._getDisplayValue())+1}if(t>1){t=t-1}else{t=1}this.updateHoverState(e,t)};o.prototype.onsaphome=function(e){this.updateHoverState(e,1)};o.prototype.onsapend=function(e){this.updateHoverState(e,this.getMaxValue())};o.prototype.onsapselect=function(e){this.saveValue(e,true,this.iHoveredRating)};o.prototype.onsapescape=function(e){this.saveValue(e,true,-1)};o.prototype.onfocusout=function(e){this.saveValue(e,false,this.iHoveredRating)};o.prototype.onclick=function(e){this.saveValue(e,true,this.getSymbolValue(e))};o.prototype.onmouseover=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return}this.iHoveredRating=-1;var t=this.getSymbolValue(e);if(t==-1){return}for(var i=1;i<=t;i++){a.hoverRatingSymbol(i,this)}for(var i=t+1;i<=this.getMaxValue();i++){a.hoverRatingSymbol(i,this,true)}};o.prototype.onmouseout=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return}if(i(e,this.getDomRef())){this.iHoveredRating=-1;for(var t=1;t<=this.getMaxValue();t++){a.unhoverRatingSymbol(t,this)}}};o.prototype.getSymbolValue=function(e){var t=jQuery(e.target);if(t.hasClass("sapUiRatingItmImg")||t.hasClass("sapUiRatingItmOvrflw")){t=jQuery(e.target.parentNode)}else if(t.hasClass("sapUiRatingItmOvrflwImg")){t=jQuery(e.target.parentNode.parentNode)}var a=t.attr("itemvalue");if(a){return parseInt(a)}return-1};o.prototype.updateKeyboardHoverState=function(e){for(var t=1;t<=this.getMaxValue();t++){a.unhoverRatingSymbol(t,this);if(t<=this.iHoveredRating){a.hoverRatingSymbol(t,this)}else if(!e){a.hoverRatingSymbol(t,this,true)}}this.setAriaState()};o.prototype.onAfterRendering=function(){this.setAriaState()};o.prototype.setAriaState=function(){var e=this.iHoveredRating==-1?this._getDisplayValue():this.iHoveredRating;this.$().attr("aria-valuenow",e).attr("aria-valuetext",this._getText("RATING_ARIA_VALUE",[e])).attr("aria-label",this._getText("RATING_ARIA_NAME"))};o.prototype._getText=function(e,t){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(a){return a.getText(e,t)}return e};o.prototype.saveValue=function(e,t,i){if(t){e.preventDefault()}if(!this.getEditable()){return false}this.iHoveredRating=-1;if(i!=-1&&i!=this.getValue()){this.setValue(i);this.fireChange({value:i});return true}else{for(var r=1;r<=this.getMaxValue();r++){a.unhoverRatingSymbol(r,this)}this.setAriaState();return false}};o.prototype.updateHoverState=function(e,t){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return}this.iHoveredRating=t;this.updateKeyboardHoverState()};o.prototype.setMaxValue=function(e){if(e<1){e=1}this.setProperty("maxValue",e);return this};o.prototype.getAccessibilityInfo=function(){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"slider",type:e.getText("ACC_CTR_TYPE_RATING"),description:e.getText("ACC_CTR_STATE_RATING",[this._getDisplayValue(),this.getMaxValue()]),focusable:true,editable:this.getEditable()}};return o});
//# sourceMappingURL=RatingIndicator.js.map