/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./SegmentedButtonRenderer"],function(jQuery,t,e,o){"use strict";var i=t.extend("sap.ui.commons.SegmentedButton",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{enabled:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{buttons:{type:"sap.ui.commons.Button",multiple:true,singularName:"button"}},associations:{selectedButton:{type:"sap.ui.commons.Button",multiple:false}},events:{select:{parameters:{selectedButtonId:{type:"string"}}}}}});i.prototype.init=function(){if(!this._oItemNavigation){this._oItemNavigation=new e;this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation)}this._oButtonDelegate={oSegmentedButton:this,onAfterRendering:this._buttonOnAfterRendering}};i.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};i.prototype.onAfterRendering=function(){this._setItemNavigation(true)};i.prototype._buttonSelected=function(t){var e=sap.ui.getCore().byId(this.getSelectedButton()),o=t.getSource();if(o!==e){this.setSelectedButton(o);this.fireSelect({selectedButtonId:o.getId()})}};i.prototype._setItemNavigation=function(t){var e,o,i=[];if(!this.getEnabled()){return}if(this.getDomRef()){this._oItemNavigation.setRootDomRef(this.getDomRef("radiogroup"));o=this.getButtons();for(var n=0;n<o.length;n++){e=o[n];i.push(e.getDomRef());this._setAriaInfo(e,n+1);if(t){e.removeDelegate(this._oButtonDelegate);e.addDelegate(this._oButtonDelegate)}}this._oItemNavigation.setItemDomRefs(i)}};i.prototype._setAriaInfo=function(t,e){var o=jQuery(t.getDomRef()),i=this.getButtons().length;o.attr("aria-posinset",e);o.attr("aria-setsize",i);o.attr("role","radio");if(t.getId()===this.getSelectedButton()){o.attr("aria-checked","true");o.removeAttr("aria-describedby")}else{o.removeAttr("aria-checked");o.attr("aria-describedby",this.getId()+"-label")}};i.prototype._buttonOnAfterRendering=function(){this.oSegmentedButton._setItemNavigation()};i.prototype._rerenderButtons=function(){var t=this.$();if(t.length>0){var e=sap.ui.getCore().createRenderManager();o.renderButtons(e,this);e.flush(t[0]);e.destroy()}};i.prototype.addButton=function(t){this.addAggregation("buttons",t,true);t.attachPress(this._buttonSelected,this);this._rerenderButtons();return this};i.prototype.insertButton=function(t,e){this.insertAggregation("buttons",t,e,true);t.attachPress(this._buttonSelected,this);this._rerenderButtons();return this};i.prototype.removeButton=function(t){var e=this.removeAggregation("buttons",t,true);if(e){e.detachPress(this._buttonSelected,this);e.removeDelegate(this._oButtonDelegate);this._rerenderButtons()}return e};i.prototype.removeAllButtons=function(){var t=this.removeAllAggregation("buttons",true);jQuery.each(t,function(t,e){e.detachPress(this._buttonSelected,this);e.removeDelegate(this._oButtonDelegate)});this._rerenderButtons();return t};i.prototype.setSelectedButton=function(t){var e,o=sap.ui.getCore().byId(this.getSelectedButton());this.setAssociation("selectedButton",t,true);e=sap.ui.getCore().byId(this.getSelectedButton());this._setItemNavigation();var i=this.getButtons();for(var n=0;n<i.length;n++){if(i[n]===e){this._oItemNavigation.setFocusedIndex(n);break}}if(o){o.removeStyleClass("sapUiSegButtonSelected");o.$().trigger("blur")}if(o&&o._icon){o.setIcon(o._icon);o._icon=null}if(e){if(e.getIconHovered()){e._icon=e.getIcon();e.setIcon(e.getIconHovered())}e.addStyleClass("sapUiSegButtonSelected")}return this};i.prototype.setEnabled=function(t){jQuery.each(this.getButtons(),function(e,o){o.setEnabled(t)});if(this._oItemNavigation&&!t){this.removeDelegate(this._oItemNavigation)}else{this.addDelegate(this._oItemNavigation)}this.setProperty("enabled",t);return this};i.prototype.clone=function(e){var o=this.getButtons(),i,n=0;for(;n<o.length;n++){i=o[n];i.detachPress(this._buttonSelected,this)}var s=t.prototype.clone.apply(this,arguments);for(n=0;n<o.length;n++){i=o[n];i.attachPress(this._buttonSelected,this)}return s};i.prototype.getFocusDomRef=function(){return this.getDomRef("radiogroup")||null};return i});
//# sourceMappingURL=SegmentedButton.js.map