/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Manifest","./ComponentMetadata","./ElementRegistry","sap/base/config","sap/base/i18n/Localization","sap/base/util/extend","sap/base/util/deepExtend","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/core/ResizeHandler","sap/ui/thirdparty/URI","sap/ui/performance/trace/Interaction","sap/ui/util/_enforceNoReturnValue","sap/base/assert","sap/base/Log","sap/base/util/Deferred","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions","sap/base/strings/camelize","sap/ui/core/_UrlResolver","sap/ui/VersionInfo","sap/ui/core/mvc/ViewType","sap/ui/core/Configuration","sap/ui/core/ComponentRegistry","sap/ui/core/util/_LocalizationHelper"],function(e,t,n,i,o,r,a,s,u,c,f,p,d,l,g,m,h,v,y,M,_,C,b,w,S,E,A){"use strict";var T={lazy:"lazy",eager:"eager",waitFor:"waitFor"};function O(e){return{name:e,type:i.Type.String,external:true}}function U(e){["sap-client","sap-server"].forEach(function(t){if(!e.hasSearch(t)){var n=i.get(O(_(t)));if(n){e.addSearch(t,n)}}})}function I(e,t,n,i){if(n){for(var o in e){if(!t[o]&&n[o]&&n[o].uri){t[o]=i}}}}function P(e,n,i,o){var r=n.getEntry(i);if(r!==undefined&&!y(r)){return r}var s,u;if(o&&(s=e.getParent())instanceof t){u=s._getManifestEntry(i,o)}if(u||r){r=a({},u,r)}return r}function k(e,t){var n=Object.create(Object.getPrototypeOf(e));n._oMetadata=e;n._oManifest=t;for(var i in e){if(!/^(getManifest|_getManifest|getManifestObject|getManifestEntry|_getManifestEntry|getMetadataVersion)$/.test(i)&&typeof e[i]==="function"){n[i]=e[i].bind(e)}}n.getManifest=function(){return this._getManifest()};n.getManifestEntry=function(e,t){return this._getManifestEntry(e,t)};n._getManifest=function(){return t&&t.getJson()};n.getManifestObject=function(){return t};n._getManifestEntry=function(n,i){return P(e,t,n,i)};n.getMetadataVersion=function(){return 2};return n}var j=u.extend("sap.ui.core.Component",{constructor:function(e,t){var n=Array.prototype.slice.call(arguments);if(typeof e!=="string"){t=e;e=undefined}if(t&&typeof t._metadataProxy==="object"){this._oMetadataProxy=t._metadataProxy;this._oManifest=t._metadataProxy._oManifest;delete t._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy}}if(t&&typeof t._cacheTokens==="object"){this._mCacheTokens=t._cacheTokens;delete t._cacheTokens}if(t&&Array.isArray(t._activeTerminologies)){this._aActiveTerminologies=t._activeTerminologies;delete t._activeTerminologies}if(t&&typeof t._manifestModels==="object"){this._mManifestModels=t._manifestModels;delete t._manifestModels}else{this._mManifestModels={}}this._mServices={};this._oKeepAliveConfig=this.getManifestEntry("/sap.ui5/keepAlive");if(this._oKeepAliveConfig){this._oKeepAliveConfig.supported=!!this._oKeepAliveConfig.supported}this._bIsActive=true;this._aDestroyables=[];u.apply(this,n)},metadata:{stereotype:"component",abstract:true,specialSettings:{componentData:"any"},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},t);E.init(j);function D(e,t){n.forEach(function(n,i){var o=j.getOwnerIdFor(n);if(o===t&&!n.getParent()){e(n,i)}})}function N(e){var t,n;if(i.get({name:"sapUiXxDisableCustomizing",type:i.Type.Boolean})){return t}if(typeof e==="string"){n=e}else if(e&&typeof e.isA==="function"&&!e.isA("sap.ui.core.Component")){n=j.getOwnerIdFor(e)}else{t=e}if(n){t=j.getComponentById(n)}if(t){if(t.getExtensionComponent){t=t.getExtensionComponent();if(!t){throw new Error("getExtensionComponent() must return an instance.")}}}return t}j.getCustomizing=function(e,t){var n=t.type,i=t.name?"/"+t.name:"",o="/sap.ui5/extends/extensions/"+n+i;if(n==="sap.ui.viewExtensions"){o+="/"+t.extensionName}var r=N(e);return r?r._getManifestEntry(o,true):undefined};j.getComponentPreloadMode=function(){return i.get({name:"sapUiXxComponentPreload",type:i.Type.String,external:true})||c.getPreloadMode()};j.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata()._getManifest()}else{return this._oManifest.getJson()}};j.prototype.getManifestEntry=function(e){return this._getManifestEntry(e)};j.prototype._getManifestEntry=function(e,t){if(!this._oManifest){return this.getMetadata()._getManifestEntry(e,t)}else{return P(this.getMetadata(),this._oManifest,e,t)}};j.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject()}else{return this._oManifest}};j.prototype._isVariant=function(){if(this._oManifest){var e=this.getManifestEntry("/sap.ui5/componentName");return e&&e!==this.getManifestEntry("/sap.app/id")}else{return false}};j.activateCustomizing=function(e){};j.deactivateCustomizing=function(e){};j.getOwnerIdFor=function(e){g(e instanceof u,"oObject must be given and must be a ManagedObject");var t=e instanceof u&&e._sOwnerId;return t||undefined};j.getOwnerComponentFor=function(e){return j.getComponentById(j.getOwnerIdFor(e))};j.prototype.runAsOwner=function(e){if(!this.isActive()){throw new Error("Execute 'runAsOwner' on an inactive owner component is not supported. Component: '"+this.getMetadata().getName()+"' with id '"+this.getId()+"'.")}return u.runWithOwner(e,this.getId())};j.prototype.getInterface=function(){return this};j.prototype._initCompositeSupport=function(e){this.oComponentData=e&&e.componentData;if(this._oManifest){this._oManifest.init(this)}else{this.getMetadata().init()}if(this._isVariant()){var t=this._oManifest.getEntry("/sap.app/id");if(t){B(t,this._oManifest.resolveUri("./","manifest"))}}this.initComponentModels();(()=>{if(this.onWindowError){this._fnWindowErrorHandler=function(e){var t=e.originalEvent;this.onWindowError(t.message,t.filename,t.lineno)}.bind(this);window.addEventListener("error",this._fnWindowErrorHandler)}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=function(e){var t=this.onWindowBeforeUnload.apply(this,arguments);if(typeof t==="string"){e.returnValue=t;e.preventDefault();return t}}.bind(this);window.addEventListener("beforeunload",this._fnWindowBeforeUnloadHandler)}if(this.onWindowUnload){this._fnWindowUnloadHandler=this.onWindowUnload.bind(this);window.addEventListener("unload",this._fnWindowUnloadHandler)}})()};j.prototype._getDestroyables=function(){if(!this._aDestroyables){m.error("[FUTURE FATAL] Mandatory super constructor not called for Component: '"+this.getManifestObject().getComponentName()+"'.",null,"sap.ui.support",function(){return{type:"missingSuperConstructor"}});this._aDestroyables=[]}return this._aDestroyables};j.prototype.destroy=function(){var e,t=false;for(var n in this._mServices){if(this._mServices[n].instance){this._mServices[n].instance.destroy()}}delete this._mServices;for(var i in this._mManifestModels){this._mManifestModels[i].destroy()}delete this._mManifestModels;(()=>{if(this._fnWindowErrorHandler){window.removeEventListener("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler}if(this._fnWindowBeforeUnloadHandler){window.removeEventListener("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler}if(this._fnWindowUnloadHandler){window.removeEventListener("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler}})();if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus}function o(e){if(e&&!e._bIsBeingDestroyed){e.destroy()}}function r(e){t=true}var a=this._getDestroyables();for(var s=0;s<a.length;s++){a[s]=a[s].then(o,r)}if(a.length>0){e=Promise.all(a).then(function(){if(t){D(function(e){e.destroy()},this.getId())}}.bind(this))}u.prototype.destroy.apply(this,arguments);const c=sap.ui.require("sap/ui/core/Messaging");c?.unregisterObject(this);if(this._oManifest){this._oManifest.exit(this);delete this._oManifest}else{this.getMetadata().exit()}return e};j.prototype.getComponentData=function(){return this.oComponentData};j.prototype.getEventBus=function(){if(!this._oEventBus){var e=sap.ui.require("sap/ui/core/EventBus");if(!e){var t=this.getMetadata().getName();m.warning("Synchronous loading of EventBus, due to #getEventBus() call on Component '"+t+"'.","SyncXHR",null,function(){return{type:"SyncXHR",name:t}});e=sap.ui.requireSync("sap/ui/core/EventBus")}this._oEventBus=new e;if(!this.isActive()){this._oEventBus.suspend()}}return this._oEventBus};j.prototype.isActive=function(){return this._bIsActive};j.prototype.initComponentModels=function(){var e=this.getMetadata();if(e.isBaseClass()){return}var t=this._getManifestEntry("/sap.app/dataSources",true)||{};var n=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(n,t,this._mCacheTokens)};j.prototype._initComponentModels=function(e,t,n){var i=this.getManifestObject().getComponentName();var o=j._findManifestModelClasses({models:e,dataSources:t,componentName:i});j._loadManifestModelClasses(o,i);var r=j._createManifestModelConfigurations({models:o,dataSources:t,component:this,mergeParent:true,cacheTokens:n,activeTerminologies:this.getActiveTerminologies()}),a={},s;if(!r){return}for(s in r){if(!this._mManifestModels[s]){a[s]=r[s]}}var u=j._createManifestModels(a,i);for(s in u){this._mManifestModels[s]=u[s]}for(s in this._mManifestModels){var c=this._mManifestModels[s];this.setModel(c,s||undefined)}};j.prototype.getService=function(e){if(!this._mServices[e]){this._mServices[e]={};this._mServices[e].promise=new Promise(function(t,n){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(i){var o=this._getManifestEntry("/sap.ui5/services/"+e,true);var r=o&&o.factoryName;if(!r){n(new Error("Service "+e+" not declared!"));return}var a=i.get(r);if(a){a.createInstance({scopeObject:this,scopeType:"component",settings:o.settings||{}}).then(function(i){if(!this.bIsDestroyed){this._mServices[e].instance=i;this._mServices[e].interface=i.getInterface();t(this._mServices[e].interface)}else{n(new Error("Service "+e+" could not be loaded as its Component was destroyed."))}}.bind(this)).catch(n)}else{var s="The ServiceFactory "+r+" for Service "+e+" not found in ServiceFactoryRegistry!";var u=this._getManifestEntry("/sap.ui5/services/"+e+"/optional",true);if(!u){m.error(s)}n(new Error(s))}}.bind(this),n)}.bind(this))}return this._mServices[e].promise};function R(e,t){var n=e._getManifestEntry("/sap.ui5/services",true);var i=t?[]:null;if(!n){return i}var o=Object.keys(n);if(!t&&o.some(function(e){return n[e].startup===T.waitFor})){throw new Error('The specified component "'+e.getMetadata().getName()+'" cannot be loaded in sync mode since it has some services declared with "startup" set to "waitFor"')}return o.reduce(function(t,i){if(n[i].lazy===false||n[i].startup===T.waitFor||n[i].startup===T.eager){var o=e.getService(i);if(n[i].startup===T.waitFor){t.push(o)}}return t},i)}j.prototype.createComponent=function(e){g(typeof e==="string"&&e||typeof e==="object"&&typeof e.usage==="string"&&e.usage,"vUsage either must be a non-empty string or an object with a non-empty usage id");var t={async:true};if(e){var n;if(typeof e==="object"){n=e.usage;["id","async","settings","componentData"].forEach(function(n){if(e[n]!==undefined){t[n]=e[n]}})}else if(typeof e==="string"){n=e}t=this._enhanceWithUsageConfig(n,t)}var i=j._createComponent(t,this);if(i instanceof Promise){this.registerForDestroy(i)}return i};j.prototype._enhanceWithUsageConfig=function(e,t){var n=this.getManifestEntry("/sap.ui5/componentUsages/"+e);if(!n){throw new Error('Component usage "'+e+'" not declared in Component "'+this.getManifestObject().getComponentName()+'"!')}if(n.activeTerminologies){throw new Error("Terminologies vector can't be used in component usages")}return a(n,t)};j.prototype.getActiveTerminologies=function(){return this._aActiveTerminologies?this._aActiveTerminologies.slice():undefined};j._createComponent=function(e,t){function n(){if(e.async===true){return j.create(e)}else{return sap.ui.component(e)}}if(t){if(!t.isActive()){throw new Error("Creation of component '"+e.name+"' is not possible due to inactive owner component '"+t.getId()+"'")}return t.runAsOwner(n)}else{return n()}};j._applyCacheToken=function(e,t,n){var o=n?"Model":"DataSource";var r=n?'["sap.ui5"]["models"]':'["sap.app"]["dataSources"]';var a=n&&n["sap-language"]||e.search(true)["sap-language"];var s=n&&n["sap-client"]||e.search(true)["sap-client"];if(!a){m.warning('Component Manifest: Ignoring provided "sap-context-token='+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+"). "+'Missing "sap-language" URI parameter',r+'["'+t.dataSource+'"]',t.componentName);return}if(!s){m.warning('Component Manifest: Ignoring provided "sap-context-token='+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+"). "+'Missing "sap-client" URI parameter',r+'["'+t.dataSource+'"]',t.componentName);return}var u=i.get(O("sapClient"));if(s!==u){m.warning('Component Manifest: Ignoring provided "sap-context-token='+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+"). "+'URI parameter "sap-client='+s+'" must be identical with configuration "sap-client='+u+'"',r+'["'+t.dataSource+'"]',t.componentName);return}if(e.hasQuery("sap-context-token")&&!e.hasQuery("sap-context-token",t.cacheToken)||n&&n["sap-context-token"]&&n["sap-context-token"]!==t.cacheToken){m.warning('Component Manifest: Overriding existing "sap-context-token='+(e.query(true)["sap-context-token"]||n["sap-context-token"])+'" with provided value "'+t.cacheToken+'" for '+o+' "'+t.dataSource+'" ('+e.toString()+").",r+'["'+t.dataSource+'"]',t.componentName)}if(n){if(e.hasQuery("sap-context-token")){m.warning('Component Manifest: Move existing "sap-context-token='+e.query(true)["sap-context-token"]+'" to metadataUrlParams for '+o+' "'+t.dataSource+'" ('+e.toString()+").",r+'["'+t.dataSource+'"]',t.componentName)}e.removeQuery("sap-context-token");n["sap-context-token"]=t.cacheToken}else{e.setQuery("sap-context-token",t.cacheToken)}};j._findManifestModelClasses=function(e){if(!e.models){return null}var t={models:e.models,dataSources:e.dataSources||{},origin:{dataSources:{},models:{}}};var n=e.componentName;var i={};for(var o in t.models){var r=t.models[o];if(typeof r==="string"){r={dataSource:r}}if(r.dataSource){var a=t.dataSources&&t.dataSources[r.dataSource];if(typeof a==="object"){if(a.type===undefined){a.type="OData"}var s;if(!r.type){switch(a.type){case"OData":s=a.settings&&a.settings.odataVersion;if(s==="4.0"){r.type="sap.ui.model.odata.v4.ODataModel"}else if(!s||s==="2.0"){r.type="sap.ui.model.odata.v2.ODataModel"}else{m.error('[FUTURE FATAL] Component Manifest: Provided OData version "'+s+'" in '+'dataSource "'+r.dataSource+'" for model "'+o+'" is unknown. '+'Falling back to default model type "sap.ui.model.odata.v2.ODataModel".','["sap.app"]["dataSources"]["'+r.dataSource+'"]',n);r.type="sap.ui.model.odata.v2.ODataModel"}break;case"JSON":r.type="sap.ui.model.json.JSONModel";break;case"XML":r.type="sap.ui.model.xml.XMLModel";break;default:}}}}if(!r.type){m.error('[FUTURE FATAL] Component Manifest: Missing "type" for model "'+o+'"','["sap.ui5"]["models"]["'+o+'"]',n);continue}i[o]=r}return i};j._createManifestModelConfigurations=function(e){var n=e.component;var o=e.manifest||n.getManifestObject();var r=e.mergeParent;var a=e.cacheTokens||{};var s=n?n.getMetadata().getComponentName():o.getComponentName();var u=S;var c=e.activeTerminologies;if(!e.models){return null}var f={models:e.models,dataSources:e.dataSources||{},origin:{dataSources:{},models:{}}};if(n&&r){var d=n.getMetadata();while(d instanceof t){var l=d.getManifestObject();var g=d._getManifestEntry("/sap.app/dataSources");I(f.dataSources,f.origin.dataSources,g,l);var h=d._getManifestEntry("/sap.ui5/models");I(f.models,f.origin.models,h,l);d=d.getParent()}}var y={};for(var M in f.models){var _=f.models[M];var b=sap.ui.require(_.type.replace(/\./g,"/"));if(!b){b=v.get(_.type)}if(!b){m.error('[FUTURE FATAL] Component Manifest: Class "'+_.type+'" for model "'+M+'" could not be found','["sap.ui5"]["models"]["'+M+'"]',s);continue}var w=b.getMetadata();var E=w.isA("sap.ui.model.odata.ODataModel");var A=w.isA("sap.ui.model.odata.v2.ODataModel");var T=w.isA("sap.ui.model.odata.v4.ODataModel");var P=w.isA("sap.ui.model.resource.ResourceModel");var k=false;var D=null;if(typeof _==="string"){_={dataSource:_}}if(_.dataSource){var N=f.dataSources&&f.dataSources[_.dataSource];if(typeof N==="object"){if(N.type===undefined){N.type="OData"}if(T&&N.settings&&N.settings.odataVersion){_.settings=_.settings||{};_.settings.odataVersion=N.settings.odataVersion}if(!_.uri){_.uri=N.uri;k=true}if(N.type==="OData"&&N.settings){_.settings=_.settings||{};if(typeof N.settings.maxAge==="number"){_.settings.headers=_.settings.headers||{};_.settings.headers["Cache-Control"]="max-age="+N.settings.maxAge}if("ignoreAnnotationsFromMetadata"in N.settings){_.settings.ignoreAnnotationsFromMetadata=N.settings.ignoreAnnotationsFromMetadata}if(N.settings.annotations){var R=N.settings.annotations;for(var x=0;x<R.length;x++){var F=R[x];var B=f.dataSources[F];if(!B){m.error('[FUTURE FATAL] Component Manifest: ODataAnnotation "'+F+'" for dataSource "'+_.dataSource+'" could not be found in manifest','["sap.app"]["dataSources"]["'+F+'"]',s);continue}if(B.type!=="ODataAnnotation"){m.error('[FUTURE FATAL] Component Manifest: dataSource "'+F+'" was expected to have type "ODataAnnotation" but was "'+B.type+'"','["sap.app"]["dataSources"]["'+F+'"]',s);continue}if(!B.uri){m.error('[FUTURE FATAL] Component Manifest: Missing "uri" for ODataAnnotation "'+F+'"','["sap.app"]["dataSources"]["'+F+'"]',s);continue}var L=new p(B.uri);if(A||T){var H=S.getSAPLogonLanguage();if(!L.hasQuery("sap-language")&&H){L.setQuery("sap-language",H)}H=i.get(O("sapClient"));if(!L.hasQuery("sap-client")&&H){L.setQuery("sap-client",H)}var W=a.dataSources&&a.dataSources[B.uri];if(W){j._applyCacheToken(L,{cacheToken:W,componentName:s,dataSource:F})}}var q=f.origin.dataSources[R[x]]||o;var z=q.resolveUri(L.toString());_.settings.annotationURI=_.settings.annotationURI||[];_.settings.annotationURI.push(z)}}}}else{m.error('[FUTURE FATAL] Component Manifest: dataSource "'+_.dataSource+'" for model "'+M+'" not found or invalid','["sap.app"]["dataSources"]["'+_.dataSource+'"]',s);continue}}if(E&&(!_.settings||_.settings.json===undefined)){_.settings=_.settings||{};_.settings.json=true}if(P){if(_.uri&&_.settings&&_.settings.bundleUrl){m.warning("Defining both model uri and bundleUrl is not supported. Only model uri will be resolved.")}if(!_.uri&&_.settings&&_.settings.terminologies){if(_.bundleUrl||_.settings.bundleUrl){_.uri=_.bundleUrl||_.settings.bundleUrl;delete _.settings.bundleUrl}}}if(_.uri){var V=new p(_.uri);var J=(k?f.origin.dataSources[_.dataSource]:f.origin.models[M])||o;V=new p(J.resolveUri(_.uri));if(_.dataSource){U(V);if(A||T){var K=f.dataSources&&f.dataSources[_.dataSource];var Q=a.dataSources&&a.dataSources[K.uri];D=_.settings&&_.settings.metadataUrlParams;var X=(!D||typeof D["sap-language"]==="undefined")&&!V.hasQuery("sap-language")&&u.getSAPLogonLanguage();if(X||Q){_.settings=_.settings||{};D=_.settings.metadataUrlParams=_.settings.metadataUrlParams||{};if(X){D["sap-language"]=u.getSAPLogonLanguage()}}if(Q){j._applyCacheToken(V,{cacheToken:Q,componentName:s,dataSource:M},D)}}}_.uri=V.toString()}if(_.uriSettingName===undefined){if(E||A||T){_.uriSettingName="serviceUrl"}else if(P){_.uriSettingName="bundleUrl"}else{}}var $;var G;if(n){G=n.getComponentData()}else{G=e.componentData}$=G&&G.startupParameters&&G.startupParameters["sap-system"];if(!$){$=i.get(O("sapSystem"))}var Y=false;var Z;if($&&(E||A||T)){Y=true;Z=sap.ui.require("sap/ui/model/odata/ODataUtils")}if(_.uri){if(Y){_.preOriginBaseUri=_.uri.split("?")[0];_.uri=Z.setOrigin(_.uri,{alias:$});_.postOriginBaseUri=_.uri.split("?")[0]}if(_.uriSettingName!==undefined){_.settings=_.settings||{};if(!_.settings[_.uriSettingName]){_.settings[_.uriSettingName]=_.uri}}else if(_.settings){_.settings=[_.uri,_.settings]}else{_.settings=[_.uri]}}else if(Y&&_.uriSettingName!==undefined&&_.settings&&_.settings[_.uriSettingName]){_.preOriginBaseUri=_.settings[_.uriSettingName].split("?")[0];_.settings[_.uriSettingName]=Z.setOrigin(_.settings[_.uriSettingName],{alias:$});_.postOriginUri=_.settings[_.uriSettingName].split("?")[0]}if(Y&&_.settings&&_.settings.annotationURI){var ee=[].concat(_.settings.annotationURI);var te=[];for(var ne=0;ne<ee.length;ne++){te.push(Z.setAnnotationOrigin(ee[ne],{alias:$,preOriginBaseUri:_.preOriginBaseUri,postOriginBaseUri:_.postOriginBaseUri}))}_.settings.annotationURI=te}if(P&&_.settings){if(c){_.settings.activeTerminologies=c}C._processResourceConfiguration(_.settings,{alreadyResolvedOnRoot:true,baseURI:o._oBaseUri,manifestBaseURI:o._oManifestBaseUri,relativeTo:undefined})}if(_.settings&&!Array.isArray(_.settings)){_.settings=[_.settings]}y[M]=_}if(o.getEntry("/sap.ui5/commands")||n&&n._getManifestEntry("/sap.ui5/commands",true)){y["$cmd"]={type:"sap.ui.model.json.JSONModel"}}return y};j._loadManifestModelClasses=function(e,t){for(var n in e){var i=e[n];try{sap.ui.requireSync(i.type.replace(/\./g,"/"))}catch(e){m.error('[FUTURE FATAL] Component Manifest: Class "'+i.type+'" for model "'+n+'" could not be loaded. '+e,'["sap.ui5"]["models"]["'+n+'"]',t);continue}}};j._createManifestModels=function(e,t){var n={};for(var i in e){var o=e[i];var r=v.get(o.type)||sap.ui.require(o.type.replace(/\./g,"/"));var a=[null].concat(o.settings||[]);var s=r.bind.apply(r,a);var u=new s;n[i]=u}return n};function x(e){var t={afterManifest:{},afterPreload:{}};var n=s({},e.getEntry("/sap.app/dataSources"));var i=s({},e.getEntry("/sap.ui5/models"));var o=e.getComponentName();var r=j._findManifestModelClasses({models:i,dataSources:n,componentName:o});var a=new URLSearchParams(window.location.search).get("sap-ui-xx-preload-component-models-"+e.getComponentName());var u=a&&a.split(",");for(var c in r){var f=r[c];if(!f.preload&&u&&u.indexOf(c)>-1){f.preload=true;m.warning('FOR TESTING ONLY!!! Activating preload for model "'+c+'" ('+f.type+")",o,"sap.ui.core.Component")}if(f.type==="sap.ui.model.resource.ResourceModel"&&(!f.settings||f.settings.async!==true)){t.afterPreload[c]=f}else if(f.preload){if(sap.ui.loader._.getModuleState(f.type.replace(/\./g,"/")+".js")){t.afterManifest[c]=f}else{m.warning('Can not preload model "'+c+'" as required class has not been loaded: "'+f.type+'"',o,"sap.ui.core.Component")}}}return t}function F(e){return sap.ui.require.toUrl(e.replace(/\./g,"/")+"/manifest.json")}function B(e,t){M.registerResourcePath(e.replace(/\./g,"/"),t)}function L(e){var n=[];var i=[];function o(e){if(!e._oManifest){var r=e.getComponentName();var a=F(r);var s=M.loadResource({url:a,dataType:"json",async:true}).catch(function(e){m.error('Failed to load component manifest from "'+a+'" (component '+r+")! Reason: "+e);return{}});n.push(s);i.push(e)}var u=e.getParent();if(u&&u instanceof t&&!u.isBaseClass()){o(u)}}o(e);return Promise.all(n).then(function(e){for(var t=0;t<e.length;t++){if(e[t]){i[t]._applyManifest(e[t])}}})}j._fnLoadComponentCallback=null;var H=[];Object.defineProperty(j,"_fnOnInstanceCreated",{get:function(){return H[0]},set:function(e){if(typeof e==="function"){H.push(e)}else{H=[]}}});j._fnPreprocessManifest=null;j.create=function(e){if(e==null||typeof e!=="object"){throw new TypeError("Component.create() must be called with a configuration object.")}var t=s({},e);t.async=true;if(t.manifest===undefined){t.manifest=true}return z(t)};sap.ui.component=function(e){if(!e){throw new Error("sap.ui.component cannot be called without parameter!")}var t=function(e){return{type:"sap.ui.component",name:e}};if(typeof e==="string"){m.warning("Do not use deprecated function 'sap.ui.component' ("+e+") + for Component instance lookup. "+"Use 'Component.get' instead","sap.ui.component",null,t.bind(null,e));return j.getComponentById(e)}if(e.async){m.info("Do not use deprecated factory function 'sap.ui.component' ("+e["name"]+"). "+"Use 'Component.create' instead","sap.ui.component",null,t.bind(null,e["name"]))}else{m.warning("Do not use synchronous component creation ("+e["name"]+")! "+"Use the new asynchronous factory 'Component.create' instead","sap.ui.component",null,t.bind(null,e["name"]))}return z(e,true)};function W(e){const t=[];let n;const i=e.getEntry("/sap.ui5/rootView");if(typeof i==="string"){n="XML"}else if(i&&typeof i==="object"&&i.type){n=i.type}if(n&&w[n]){const e="sap/ui/core/mvc/"+w[n]+"View";t.push(e)}const o=e.getEntry("/sap.ui5/routing");if(o){if(o.routes){const n=e.getEntry("/sap.ui5/routing/config/routerClass")||"sap.ui.core.routing.Router";if(typeof n==="string"){const e=n.replace(/\./g,"/");t.push(e)}}else if(o.targets){const n=e.getEntry("/sap.ui5/routing/config/targetsClass")||"sap.ui.core.routing.Targets";if(typeof n==="string"){const e=n.replace(/\./g,"/");t.push(e)}t.push("sap/ui/core/routing/Views")}}return t}function q(e,t){const n=new h;sap.ui.require([e],n.resolve,i=>{m.warning(`[FUTURE FATAL] Cannot load module '${e}'. `+"This will most probably cause an error once the module is used later on.",t,"sap.ui.core.Component");m.warning(i);n.resolve()});return n.promise}function z(e,n){var i=j.getComponentById(u._sOwnerId);if(Array.isArray(e.activeTerminologies)&&e.activeTerminologies.length&&Array.isArray(o.getActiveTerminologies())&&o.getActiveTerminologies().length){if(JSON.stringify(e.activeTerminologies)!==JSON.stringify(o.getActiveTerminologies())){m.warning(n?"sap.ui.component: ":"Component.create: "+"The 'activeTerminolgies' passed to the component factory differ from the ones defined on the global 'sap/base/i18n/Localization.getActiveTerminologies';"+"This might lead to inconsistencies; ResourceModels that are not defined in the manifest and created by the component will use the globally configured terminologies.")}}var a=e.activeTerminologies||i&&i.getActiveTerminologies()||o.getActiveTerminologies();if(!e.asyncHints||!e.asyncHints.cacheTokens){var s=i&&i._mCacheTokens;if(typeof s==="object"){e.asyncHints=e.asyncHints||{};e.asyncHints.cacheTokens=s}}function c(e,t){return H.map(function(n){return n(e,t)})}function f(e,t){if(t.async){var n=e.rootControlLoaded?e.rootControlLoaded():Promise.resolve();var i=c(e,t);i.push(n);return Promise.all(i)}else{c(e,t)}return e}function p(t){if(n&&t.getMetadata().isA("sap.ui.core.IAsyncContentCreation")){throw new Error("Do not use deprecated factory function 'sap.ui.component' in combination with IAsyncContentCreation ("+e["name"]+"). "+"Use 'Component.create' instead")}var i=e.name,o=e.id,s=e.componentData,u=i+".Component",c=e.settings;var p=new t(r({},c,{id:o,componentData:s,_cacheTokens:e.asyncHints&&e.asyncHints.cacheTokens,_activeTerminologies:a}));g(p instanceof j,'The specified component "'+u+'" must be an instance of sap.ui.core.Component!');m.info("Component instance Id = "+p.getId());var d=p.getMetadata()._getManifestEntry("/sap.ui5/handleValidation");if(d!==undefined||e.handleValidation){const t=sap.ui.require("sap/ui/core/Messaging");if(t){t.registerObject(p,d===undefined?e.handleValidation:d)}else{sap.ui.require(["sap/ui/core/Messaging"],function(t){if(!p.isDestroyed()){t.registerObject(p,d===undefined?e.handleValidation:d)}})}}var l=R(p,e.async);if(e.async){return f(p,e).then(function(){return Promise.all(l)}).then(function(){return p})}else{return f(p,e)}}var d=V(e,{failOnError:true,createModels:true,waitFor:e.asyncHints&&e.asyncHints.waitFor,activeTerminologies:a});if(e.async){var l=u._sOwnerId;return d.then(function(e){var n=function(e){var i=e.getParent();var o=Promise.resolve();if(i instanceof t){o=o.then(function(){return n(i)})}return o.then(function(){return e.getManifestObject().loadDependenciesAndIncludes(true)})};return n(e.getMetadata()).then(async function(){const t=e.getMetadata().getManifestObject();const n=t.getComponentName();const i=W(t);const o=i.map(e=>q(e,n));await Promise.all(o);return u.runWithOwner(function(){return p(e)},l)})})}else{return p(d)}}j.load=function(e){var t=s({},e);t.async=true;if(t.manifest===undefined){t.manifest=true}return V(t,{preloadOnly:t.asyncHints&&t.asyncHints.preloadOnly})};j.get=function(e){return j.getComponentById(e)};j.getComponentById=function(e){return E.get(e)};sap.ui.component.load=function(e,t){m.warning("Do not use deprecated function 'sap.ui.component.load'! Use 'Component.load' instead");return V(e,{failOnError:t,preloadOnly:e.asyncHints&&e.asyncHints.preloadOnly})};function V(t,n){var o=n.activeTerminologies,r=t.name,u=t.url,f=/^(sync|async)$/.test(j.getComponentPreloadMode()),p=t.manifest,l,h,v,y,M,_;function C(n,i){var o=JSON.parse(JSON.stringify(n));if(t.async){return w(o).then(function(t){return new e(t,i)})}else{return new e(o,i)}}function w(e){if(typeof j._fnPreprocessManifest==="function"&&e!=null){try{var n=a({},t);return j._fnPreprocessManifest(e,n)}catch(e){m.error("Failed to execute flexibility hook for manifest preprocessing.",e);return Promise.reject(e)}}else{return Promise.resolve(e)}}g(!u||typeof u==="string","sUrl must be a string or undefined");if(r&&typeof u==="string"){B(r,u)}d.setStepComponent(r);if(p===undefined){l=t.manifestFirst===undefined?i.get({name:"sapUiManifestFirst",type:i.Type.Boolean,external:true}):!!t.manifestFirst;h=t.manifestUrl}if(p!==undefined){if(t.async===undefined){t.async=true}l=!!p;h=p&&typeof p==="string"?p:undefined;v=p&&typeof p==="object"?C(p,{url:t&&t.altManifestUrl,activeTerminologies:o,process:!t.async}):undefined}if(!v&&h){v=e.load({activeTerminologies:o,manifestUrl:h,componentName:r,processJson:w,async:t.async,failOnError:true})}if(v&&!t.async){r=v.getComponentName();if(r&&typeof u==="string"){B(r,u)}}if(!(v&&t.async)){if(!r){throw new Error("The name of the component is undefined.")}g(typeof r==="string","sName must be a string")}if(l&&!v){v=e.load({activeTerminologies:o,manifestUrl:F(r),componentName:r,async:t.async,processJson:w,failOnError:false})}function S(){return(r+".Component").replace(/\./g,"/")}function E(e){var t=r+".Component";if(!e){var i="The specified component controller '"+t+"' could not be found!";if(n.failOnError){throw new Error(i)}else{m.warning("[FUTURE FATAL] "+i)}}if(v){var o=k(e.getMetadata(),v);var a=function(){var t=Array.prototype.slice.call(arguments);var n;if(t.length===0||typeof t[0]==="object"){n=t[0]=t[0]||{}}else if(typeof t[0]==="string"){n=t[1]=t[1]||{}}n._metadataProxy=o;if(y){n._manifestModels=y}var i=Object.create(e.prototype);e.apply(i,t);return i};a.getMetadata=function(){return o};a.extend=function(){throw new Error("Extending Components created by Manifest is not supported!")};return a}else{return e}}function A(e,t){g(typeof e==="string"&&e||typeof e==="object"&&typeof e.name==="string"&&e.name,"reference either must be a non-empty string or an object with a non-empty 'name' and an optional 'url' property");if(typeof e==="object"){if(e.url){B(e.name,e.url)}return e.lazy&&t!==true?undefined:e.name}return e}function T(e,t){var n=e+".Component",i=c.isDepCacheEnabled(),o,r,a,s=function(e,t){return function(n){var i="Component-preload for this component does not exist.";m.warning("Couldn't preload component from "+e+": "+(n&&n.message||n),!t?i:i+" If the component is part of a library or another component, the configuration 'sap.app/embeddedBy' is not maintained. "+" The 'sap.app/embeddedBy' property must be relative path inside the deployment unit (library or component).","sap.ui.core.Component#preload")}};if(f&&e!=null&&!sap.ui.loader._.getModuleState(n.replace(/\./g,"/")+".js")){if(t){r=b._getTransitiveDependencyForComponent(e);if(r&&!r.hasOwnPreload){a=[r.library];Array.prototype.push.apply(a,r.dependencies);return c._load(a,{preloadOnly:true}).catch(s(r.library,true))}else{o=n.replace(/\./g,"/")+(i?"-h2-preload.js":"-preload.js");return sap.ui.loader._.loadJSResourceAsync(o).catch(s(o,true))}}try{o=n+"-preload";sap.ui.requireSync(o.replace(/\./g,"/"))}catch(e){s(o,false)(e)}}else if(t){return Promise.resolve()}}function O(e,t,n){var i=[];var o=n?function(e){i.push(e)}:function(){};var r=t.getEntry("/sap.ui5/dependencies/libs");if(r){var a=[];for(var s in r){if(!r[s].lazy){a.push(s)}}if(a.length>0){m.info('Component "'+e+'" is loading libraries: "'+a.join(", ")+'"');o(c._load(a,{sync:!n}))}}var u=t.getEntry("/sap.ui5/extends/component");if(u){o(T(u,n))}var f=[];var p=t.getEntry("/sap.ui5/dependencies/components");if(p){for(var d in p){if(!p[d].lazy){f.push(d)}}}var l=t.getEntry("/sap.ui5/componentUsages");if(l){for(var g in l){if(l[g].lazy===false&&f.indexOf(l[g].name)===-1){f.push(l[g].name)}}}if(f.length>0){f.forEach(function(e){o(T(e,n))})}return n?Promise.all(i):undefined}if(t.async){var U=t.asyncHints||{},I=[],P=function(e){e=e.then(function(e){return{result:e,rejected:false}},function(e){return{result:e,rejected:true}});return e},D=function(e){if(e){I.push(P(e))}},N=function(e){return e},R,H;R=[];if(Array.isArray(U.preloadBundles)){U.preloadBundles.forEach(function(e){R.push(sap.ui.loader._.loadJSResourceAsync(A(e,true),true))})}if(Array.isArray(U.libs)){H=U.libs.map(A).filter(N);R.push(c._load(H,{preloadOnly:true}))}R=Promise.all(R);if(H&&!n.preloadOnly){R=R.then(function(){return c._load(H)})}D(R);if(U.components){Object.keys(U.components).forEach(function(e){D(T(A(U.components[e]),true))})}if(!v){D(T(r,true))}else{var z=[];v=v.then(function(e){var t=e.getComponentName();if(typeof u==="string"){B(t,u)}e.defineResourceRoots();e._preprocess({resolveUI5Urls:true,i18nProperties:z});return e});if(n.createModels){D(v.then(function(e){var n=e.getComponentName();M=x(e);if(Object.keys(M.afterManifest).length>0){j._loadManifestModelClasses(M.afterManifest,n);var i=s({},e.getEntry("/sap.app/dataSources"));var r=j._createManifestModelConfigurations({models:M.afterManifest,dataSources:i,manifest:e,componentData:t.componentData,cacheTokens:U.cacheTokens,activeTerminologies:o});y=j._createManifestModels(r,n)}return e}))}D(v.then(function(e){var i=Promise.resolve();var r=e.getEntry("/sap.app/embeddedBy");var a=e.getComponentName();if(!r){i=T(a,true)}else if(!sap.ui.loader._.getModuleState(S()+".js")){m.warning("Component '"+a+"' is defined to be embedded in a library or another component"+"The relatively given preload for the embedding resource was not loaded before hand. "+"Please make sure to load the embedding resource containing this Component before instantiating.",undefined,"sap.ui.core.Component#embeddedBy")}return i.then(function(){return e._processI18n(true,z)}).then(function(){if(!n.createModels){return null}var i=Object.keys(M.afterPreload);if(i.length===0){return null}return new Promise(function(e,t){sap.ui.require(["sap/ui/model/resource/ResourceModel"],function(t){e(t)},t)}).then(function(r){var a=s({},e.getEntry("/sap.app/dataSources"));var u=j._createManifestModelConfigurations({models:M.afterPreload,dataSources:a,manifest:e,componentData:t.componentData,cacheTokens:U.cacheTokens,activeTerminologies:o});function c(t){var i=u[t];if(Array.isArray(i.settings)&&i.settings.length>0){var o=i.settings[0];o.activeTerminologies=n.activeTerminologies;return r.loadResourceBundle(o,true).then(function(e){o.bundle=e;delete o.terminologies;delete o.activeTerminologies;delete o.enhanceWith},function(n){m.error("Component Manifest: Could not preload ResourceBundle for ResourceModel. "+"The model will be skipped here and tried to be created on Component initialization.",'["sap.ui5"]["models"]["'+t+'"]',e.getComponentName());m.error(n);delete u[t]})}else{return Promise.resolve()}}return Promise.all(i.map(c)).then(function(){if(Object.keys(u).length>0){var t=j._createManifestModels(u,e.getComponentName());if(!y){y={}}for(var n in t){y[n]=t[n]}}})})})}));_=function(e){if(typeof j._fnLoadComponentCallback==="function"){var n=a({},t);try{return j._fnLoadComponentCallback(n,e)}catch(t){m.error('[FUTURE FATAL] Callback for loading the component "'+e.getComponentName()+'" run into an error. The callback was skipped and the component loading resumed.',t,"sap.ui.core.Component")}}}}return Promise.all(I).then(function(e){var t=[],n=false,i;n=e.some(function(e){if(e&&e.rejected){i=e.result;return true}t.push(e.result);return false});if(n){return Promise.reject(i)}return t}).then(function(e){if(v&&_){return v.then(_).then(function(){return e})}return e}).then(function(e){m.debug("Component.load: all promises fulfilled, then "+e);if(v){return v.then(function(e){if(!e._bLoadManifestRequestFailed){v=e;r=v.getComponentName();return O(r,v,true)}else{v=undefined;return v}})}else{return e}}).then(function(){if(n.preloadOnly){return true}return new Promise(function(e,t){sap.ui.require([S()],function(t){e(t)},t)}).then(function(t){var i=t.getMetadata();var r=i.getComponentName();var a=F(r);var s;if(v&&typeof p!=="object"&&(typeof h==="undefined"||h===a)){i._applyManifest(JSON.parse(JSON.stringify(v.getRawJson())))}s=L(i);return s.then(function(){var r=Promise.resolve();if(!v&&Array.isArray(n.activeTerminologies)&&n.activeTerminologies.length>0){v=new e(i.getManifestObject().getRawJson(),{process:false,activeTerminologies:o});r=v._processI18n(true)}return r.then(E.bind(undefined,t))})})}).then(function(e){if(!v){return e}const t=W(v);var n=s({},v.getEntry("/sap.ui5/models"));var i=s({},v.getEntry("/sap.app/dataSources"));var o=j._findManifestModelClasses({models:n,dataSources:i,componentName:v.getComponentName()});for(var r in o){if(!o.hasOwnProperty(r)){continue}var a=o[r];if(!a.type){continue}var u=a.type.replace(/\./g,"/");if(t.indexOf(u)===-1){t.push(u)}}if(t.length>0){const n=v.getComponentName();return Promise.all(t.map(function(e){return q(e,n)})).then(function(){return e})}else{return e}}).then(function(e){var t=n.waitFor;if(t){var i=Array.isArray(t)?t:[t];return Promise.all(i).then(function(){return e})}return e}).catch(function(e){if(y){for(var t in y){var n=y[t];if(n&&typeof n.destroy==="function"){n.destroy()}}}throw e})}if(v){v.defineResourceRoots();v._preprocess({resolveUI5Urls:true});O(r,v)}T(r);return E(sap.ui.requireSync(S()))}if(Math.sqrt(2)<1){sap.ui.require(["sap/ui/core/Core"],function(){})}j.registry=E;j.prototype.getCommand=function(e){if(!this._mComputedCommands){var t=j.getCustomizing(this,{type:"sap.ui.commands"})||{},n=this._getManifestEntry("/sap.ui5/commands",true)||{},i=this.getMetadata().getComponentName(),o="",r=this.getExtensionComponent&&this.getExtensionComponent();if(r&&r.getLocalId){o="#"+(r.getLocalId(this.getId())||this.getId())}this._mComputedCommands=s({},n,t[i],t[i+o])}return e?this._mComputedCommands[e]:this._mComputedCommands};j.prototype.deactivate=function(){var e=j.getOwnerComponentFor(this);if(e&&e.isActive()){throw new Error("Component.deactivate must not be called on nested components.")}if(!this.isKeepAliveSupported()){m.warning("Deactivation of component failed. Component '"+this.getId()+"' does not support 'keepAlive'.");return}if(!this.isActive()){m.warning("Deactivation of component failed. Component '"+this.getId()+"' is already inactive.");return}this.onOwnerDeactivation();this._bIsActive=false;D(function(e){f.suspend(e.getDomRef());e.onOwnerDeactivation()},this.getId());E.forEach(function(e){var t=j.getOwnerIdFor(e);if(t===this.getId()){e.deactivate()}},this);if(this._oEventBus){this._oEventBus.suspend()}if(this.getRouter()){this.getRouter().stop()}if(typeof this.onDeactivate==="function"){l(this.onDeactivate(),{name:"onDeactivate",component:this.getId()})}};j.prototype.activate=function(){if(!this.isKeepAliveSupported()){m.warning("Activation of component failed. Component '"+this.getId()+"' does not support 'keepAlive'.");return}if(this.isActive()){m.warning("Activation of component failed. Component '"+this.getId()+"' is already active.");return}this.onOwnerActivation();this._bIsActive=true;D(function(e){f.resume(e.getDomRef());e.onOwnerActivation()},this.getId());E.forEach(function(e){var t=j.getOwnerIdFor(e);if(t===this.getId()){e.activate()}},this);if(this._oEventBus){this._oEventBus.resume()}if(this.getRouter()){this.getRouter().initialize()}if(typeof this.onActivate==="function"){l(this.onActivate(),{name:"onActivate",component:this.getId()})}};j.prototype.isKeepAliveSupported=function(){var e=this._oKeepAliveConfig&&this._oKeepAliveConfig.supported;if(e){e=j.registry.filter(function(e){var t=j.getOwnerIdFor(e);return t===this.getId()},this).every(function(e){return e.isKeepAliveSupported()},this)}return!!e};j.prototype.registerForDestroy=function(e){var t=this._getDestroyables();e=e.then(function(n){t.splice(t.indexOf(e),1);return n});t.push(e)};A.registerForUpdate("Components",E.all);return j});
//# sourceMappingURL=Component.js.map