/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/base/EventProvider","sap/base/assert","sap/base/Log"],function(e,t,n,s){"use strict";let i;var u=e.extend("sap.ui.core.EventBus",{constructor:function(){e.apply(this);this._mChannels={};this._defaultChannel=new t;this._bIsSuspended=false}});u.prototype.subscribe=function(e,t,s,i){if(typeof t==="function"){i=s;s=t;t=e;e=null}n(!e||typeof e==="string","EventBus.subscribe: sChannelId must be empty or a non-empty string");n(typeof t==="string"&&t,"EventBus.subscribe: sEventId must be a non-empty string");n(typeof s==="function","EventBus.subscribe: fnFunction must be a function");n(!i||typeof i==="object","EventBus.subscribe: oListener must be empty or an object");var u=o(this,e);u.attachEvent(t,s,i);return this};u.prototype.subscribeOnce=function(e,t,n,s){if(typeof t==="function"){s=n;n=t;t=e;e=null}function i(){this.unsubscribe(e,t,i,undefined);n.apply(s||this,arguments)}return this.subscribe(e,t,i,undefined)};u.prototype.unsubscribe=function(e,s,i,u){if(typeof s==="function"){u=i;i=s;s=e;e=null}n(!e||typeof e==="string","EventBus.unsubscribe: sChannelId must be empty or a non-empty string");n(typeof s==="string"&&s,"EventBus.unsubscribe: sEventId must be a non-empty string");n(typeof i==="function","EventBus.unsubscribe: fnFunction must be a function");n(!u||typeof u==="object","EventBus.unsubscribe: oListener must be empty or an object");var o=r(this,e);if(!o){return this}o.detachEvent(s,i,u);if(o!=this._defaultChannel){var a=t.getEventList(o);var p=true;for(var f in a){if(o.hasListeners(f)){p=false;break}}if(p){delete this._mChannels[e]}}return this};u.prototype.publish=function(e,i,u){if(arguments.length==1){u=null;i=e;e=null}else if(arguments.length==2){if(typeof i!="string"){u=i;i=e;e=null}}if(this._bIsSuspended){s.warning("Failed to publish into channel '"+e+"'."+" The EventBus is suspended.",e+"#"+i,"sap.ui.core.EventBus");return}u=u?u:{};n(!e||typeof e==="string","EventBus.publish: sChannelId must be empty or a non-empty string");n(typeof i==="string"&&i,"EventBus.publish: sEventId must be a non-empty string");n(typeof u==="object","EventBus.publish: oData must be an object");var o=r(this,e);if(!o){if(s.isLoggable(s.Level.DEBUG,"sap.ui.core.EventBus")){s.debug("Failed to publish into channel '"+e+"'."+" No such channel.",e,"sap.ui.core.EventBus")}return}var a=t.getEventList(o)[i];if(Array.isArray(a)){a=a.slice();var p;for(var f=0,l=a.length;f<l;f++){p=a[f];this._callListener(p.fFunction,p.oListener||this,e,i,u)}}else if(s.isLoggable(s.Level.DEBUG,"sap.ui.core.EventBus")){s.debug("Failed to publish Event '"+i+"' in '"+e+"'."+" No listeners found.",e+"#"+i,"sap.ui.core.EventBus")}};u.prototype.getInterface=function(){return this};u.prototype._callListener=function(e,t,n,s,i){e.call(t,n,s,i)};u.prototype.destroy=function(){this._defaultChannel.destroy();for(var t in this._mChannels){this._mChannels[t].destroy()}this._mChannels={};e.prototype.destroy.apply(this,arguments)};u.prototype.suspend=function(){this._bIsSuspended=true};u.prototype.resume=function(){this._bIsSuspended=false};function r(e,t){if(!t){return e._defaultChannel}return e._mChannels[t]}function o(e,n){var s=r(e,n);if(!s&&n){e._mChannels[n]=new t;s=e._mChannels[n]}return s}u.getInstance=()=>{if(!i){i=new u;i.destroy=()=>{s.error("Global EventBus cannot be destroyed!")}}return i};return u});
//# sourceMappingURL=EventBus.js.map