/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../base/EventProvider","../base/Object","sap/base/Log","sap/ui/core/UIAreaRegistry","sap/ui/thirdparty/jquery","sap/ui/dom/_ready"],function(t,o,e,n,jQuery,r){"use strict";var s;var u;var i;var a=new t;var c="focusInfo";var l={};var f=o.extend("sap.ui.core.FocusHandler",{constructor:function(){o.apply(this);this.oCurrent=null;this.oLast=null;this.aEventQueue=[];this.oLastFocusedControlInfo=null;this.oPatchingControlFocusInfo=null;this.fnEventHandler=this.onEvent.bind(this);r().then(function(){var t=document.body;t.addEventListener("focus",this.fnEventHandler,true);t.addEventListener("blur",this.fnEventHandler,true);e.debug("FocusHandler setup on Root "+t.type+(t.id?": "+t.id:""),null,"sap.ui.core.FocusHandler")}.bind(this))}});f.prototype.getControlFocusInfo=function(t){var o;s??=sap.ui.require("sap/ui/core/Element");t=t||s?.getActiveElement()?.getId();if(!t){return null}o=p(t);if(o){return{id:t,control:o,info:o.getFocusInfo(),type:o.getMetadata().getName(),focusref:o.getFocusDomRef()}}return null};f.prototype.storePatchingControlFocusInfo=function(t){var o=document.activeElement;if(!o||!t.contains(o)){this.oPatchingControlFocusInfo=null}else{this.oPatchingControlFocusInfo=this.getControlFocusInfo();if(this.oPatchingControlFocusInfo){this.oPatchingControlFocusInfo.patching=true}}};f.prototype.getPatchingControlFocusInfo=function(){return this.oPatchingControlFocusInfo};f.prototype.updateControlFocusInfo=function(t){if(t&&this.oLastFocusedControlInfo&&this.oLastFocusedControlInfo.control===t){var o=t.getId();this.oLastFocusedControlInfo=this.getControlFocusInfo(o);e.debug("Update focus info of control "+o,null,"sap.ui.core.FocusHandler")}};f.prototype.addFocusInfoExtender=function(t,o){a.attachEvent(c,l,t,o);return this};f.prototype.removeFocusInfoExtender=function(t,o){a.detachEvent(c,t,o);return this};f.prototype.restoreFocus=function(t){var o=t||this.oLastFocusedControlInfo;if(!o){return}var n=p(o.id);var r=o.focusref;if(n&&o.info&&n.getMetadata().getName()==o.type&&(o.patching||n.getFocusDomRef()!=r&&(t||n!==o.control||o.preserved))){e.debug("Apply focus info of control "+o.id,null,"sap.ui.core.FocusHandler");o.control=n;this.oLastFocusedControlInfo=o;delete this.oLastFocusedControlInfo.patching;l.info=o.info;a.fireEvent(c,{domRef:n.getDomRef()});n.applyFocusInfo(l.info);Object.keys(l).forEach(function(t){delete l[t]})}else{e.debug("Apply focus info of control "+o.id+" not possible",null,"sap.ui.core.FocusHandler")}};f.prototype.destroy=function(t){var o=t.data.oRootRef;if(o){o.removeEventListener("focus",this.fnEventHandler,true);o.removeEventListener("blur",this.fnEventHandler,true)}};f.prototype.onEvent=function(t){var o=jQuery.event.fix(t);e.debug("Event "+o.type+" reached Focus Handler (target: "+o.target+(o.target?o.target.id:"")+")",null,"sap.ui.core.FocusHandler");var n=o.type=="focus"||o.type=="focusin"?"focus":"blur";this.aEventQueue.push({type:n,controlId:d(o.target)});if(this.aEventQueue.length==1){this.processEvent()}};f.prototype.processEvent=function(){var t=this.aEventQueue[0];if(!t){return}try{if(t.type=="focus"){this.onfocusEvent(t.controlId)}else if(t.type=="blur"){this.onblurEvent(t.controlId)}}finally{this.aEventQueue.shift();if(this.aEventQueue.length>0){this.processEvent()}}};f.prototype.onfocusEvent=function(t){var o=p(t);if(o){this.oLastFocusedControlInfo=this.getControlFocusInfo(t);e.debug("Store focus info of control "+t,null,"sap.ui.core.FocusHandler")}this.oCurrent=t;if(!this.oLast){return}if(this.oLast!=this.oCurrent){h(this.oLast,t)}this.oLast=null};f.prototype.onblurEvent=function(t){if(!this.oCurrent){return}this.oLast=t;this.oCurrent=null;setTimeout(this["checkForLostFocus"].bind(this),0)};f.prototype.checkForLostFocus=function(){if(this.oCurrent==null&&this.oLast!=null){h(this.oLast,null)}this.oLast=null};f.prototype.trackFocusForPreservedElement=function(t){if(t.contains(document.activeElement)&&this.oLastFocusedControlInfo&&document.activeElement===this.oLastFocusedControlInfo.focusref){this.oLastFocusedControlInfo.preserved=true}};var d=function(t){var o=jQuery(t).closest("[data-sap-ui]").attr("id");if(o){return o}return null};var h=function(t,o){var e=p(t);if(e){var n=jQuery.Event("sapfocusleave");n.target=e.getDomRef();var r=p(o);n.relatedControlId=r?r.getId():null;n.relatedControlFocusInfo=r?r.getFocusInfo():null;u=u||sap.ui.require("sap/ui/core/UIArea");if(u){var s=e.getUIArea();var a=null;if(s){a=s}else{i=i||sap.ui.require("sap/ui/core/StaticArea");if(i){var c=i.getDomRef();if(c.contains(n.target)){a=i.getUIArea()}}}if(a){a._handleEvent(n)}}}};function p(t){var o;if(!s){s=sap.ui.require("sap/ui/core/Element")}if(s){o=s.getElementById(t)}return o||null}return new f});
//# sourceMappingURL=FocusHandler.js.map