/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/config","sap/base/i18n/Localization","sap/base/i18n/ResourceBundle","sap/base/Log","sap/base/util/deepExtend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions","sap/base/util/fetch","sap/base/util/mixedFetch","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/ui/Global","sap/ui/VersionInfo","sap/ui/base/DataType","sap/ui/base/EventProvider","sap/ui/base/Object","sap/ui/base/SyncPromise","sap/ui/core/Configuration","sap/ui/core/_UrlResolver"],function(e,n,t,r,i,a,s,o,u,l,c,f,d,p,h,g,y,m,b,v,_,S){"use strict";var L={};var j={};var P=new Set(["sap.suite.ui.generic.template","sap.ui.comp","sap.ui.layout","sap.ui.unified"]);function T(e,n){return sap.ui.require.toUrl(e.replace(/\./g,"/")+n)}function w(e,n){u.registerResourcePath(e.replace(/\./g,"/"),n)}function E(e,n){var t=e.modules,r=function(e){return/^jquery\.sap\./.test(e)?e:e.replace(/\./g,"/")};if(d(e.version||"1.0").compareTo("2.0")<0){t={};for(var i in e.modules){t[r(i)+".js"]=e.modules[i]}}sap.ui.require.preload(t,e.name,n)}var O={};n.get({name:"sapUiXxLibraryPreloadFiles",type:n.Type.StringArray,external:true}).forEach(function(e){var n=String(e).trim().split(/\s*:\s*/),t=n[0],r=n[1];if(n.length===1){r=t;t=""}if(/^(?:none|js|json|both)$/.test(r)){O[t]=r}});var C=[];var A;function F(e){var n=sap.ui.require("sap/ui/core/theming/ThemeManager");if(!A){if(!n){A=new Promise(function(e,n){sap.ui.require(["sap/ui/core/theming/ThemeManager"],function(n){e(n)},n)})}else{A=Promise.resolve(n)}}if(n&&e){n.reset()}return A}var R=Symbol("sap.ui.core.Lib");var z={configurable:true,enumerable:true,writable:false};function B(e){z.value=e;return z}function U(e){if(e&&typeof e==="object"&&!Object.isFrozen(e)){Object.freeze(e);for(var n in e){if(Object.hasOwn(e,n)){U(e[n])}}}}function x(){var e=n.get({name:"sapUiPreloadLibCss",type:n.Type.StringArray,external:true});if(e.length>0){if(e[0].startsWith("!")){e[0]=e[0].slice(1)}if(e[0]==="*"){e.shift();Object.keys(L).forEach(function(n){if(!e.includes(n)){e.unshift(n)}})}}return e}var M=b.extend("sap.ui.core.Lib",{constructor:function(n){b.call(this);e(typeof n==="object","A settings object must be given to the constructor of sap/ui/base/Library");e(typeof n.name==="string"&&n.name,"The settings object that is given to the constructor of sap/ui/base/Library must contain a 'name' property which is a non-empty string");if(n._key!==R){throw new Error("The constructor of sap/ui/core/Lib is restricted to the internal usage. To get an instance of Library with name '"+n.name+"', use the static method 'get' from sap/ui/core/Lib instead.")}this.name=n.name;var t=["dependencies","types","interfaces","controls","elements"];t.forEach(function(e){Object.defineProperty(this,e,B([]))}.bind(this));Object.defineProperty(this,"_resourceBundles",{value:{},writable:true});Object.defineProperty(this,"_loadingStatus",{value:null,writable:true});Object.defineProperty(this,"_settingsEnhanced",{value:false,writable:true});Object.defineProperty(this,"_manifestFailed",{value:false,writable:true})},getInterface:function(){return this},isSettingsEnhanced:function(){return this._settingsEnhanced},enhanceSettings:function(e){if(this._settingsEnhanced){return this}this._settingsEnhanced=true;var n,t,r;for(n in e){t=e[n];r=undefined;if(t!==undefined){if(Array.isArray(this[n])){if(this[n].length===0){r=t}else{r=p(this[n].concat(t))}}else if(this[n]===undefined){r=t}else if(n!="name"){i.warning("[FUTURE FATAL] library info setting ignored: "+n+"="+t)}if(r!==undefined){Object.defineProperty(this,n,B(r))}}}return this},_getFileType:function(e){var n;var t=O[this.name]||O[""]||"both";if(e===true){n="json"}else if(e===false){n="js"}else{n=t}if(t!=="both"&&n!=="both"&&t!==n){n="none"}return n},preload:function(e){if(e&&(e.hasOwnProperty("async")||e.hasOwnProperty("sync"))){i.error("[FUTURE FATAL] The 'preload' function of class sap/ui/core/Lib only support preloading a library asynchronously. The given 'async' or 'sync' setting is ignored.")}if(e&&e.hasOwnProperty("json")){i.error("[FUTURE FATAL] The 'preload' function of class sap/ui/core/Lib only support preloading in JS Format. The given 'json' setting is ignored.")}return this._preload(["url","lazy"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{}))},_preload:function(e){e=e||{};var n=this._getFileType(e.json),t=this.name.replace(/\./g,"/"),r=!!sap.ui.loader._.getModuleState(t+"/library.js"),a=M.isDepCacheEnabled();if(n==="none"){return e.sync?this:Promise.resolve(this)}if(this._loadingStatus==null&&e.url){w(this.name,e.url)}this._loadingStatus=this._loadingStatus||{};if(this._loadingStatus.pending){if(e.sync){if(e.lazy){return this}else if(this._loadingStatus.async){i.warning("request to load "+this.name+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller")}else{i.warning("request to load "+this.name+" synchronously while sync loading is pending (cycle, ignored)");return this}}else if(this._loadingStatus.preloadFinished){return Promise.resolve(this)}}if(e.sync&&this._loadingStatus.pending===false||!e.sync&&this._loadingStatus.promise){return e.sync?this:this._loadingStatus.promise}if(e.lazy){i.debug("Lazy dependency to '"+this.name+"' encountered, loading library-preload-lazy.js");if(e.sync){try{sap.ui.requireSync(t+"/library-preload-lazy")}catch(e){i.error("failed to load '"+t+"/library-preload-lazy.js"+"' synchronously ("+(e&&e.message||e)+")")}return this}return sap.ui.loader._.loadJSResourceAsync(t+"/library-preload-lazy.js",true)}this._loadingStatus.pending=true;this._loadingStatus.async=!e.sync;var s;if(r){s=(e.sync?v:Promise).resolve()}else{s=n!=="json"?this._preloadJSFormat({fallbackToJSON:n!=="js",http2:a,sync:e.sync}):this._preloadJSONFormat({sync:e.sync})}this._loadingStatus.promise=s.then(function(n){n=n||this._getDependencies();this._loadingStatus.preloadFinished=true;var t=this.getManifest(),r;if(n&&n.length){if(!e.sync){var i=[],a=[];n.forEach(function(e){if(e.lazy){a.push(e)}else{i.push(e.name)}});i=g._getTransitiveDependencyForLibraries(i).map(function(e){return{name:e}});n=i.concat(a)}r=n.map(function(n){var t=M._get(n.name,true);return t._preload({sync:e.sync,lazy:n.lazy})})}else{r=[]}if(!e.sync&&t&&d(t._version).compareTo("1.9.0")>=0){r.push(this.loadResourceBundle())}var s=e.sync?v.all(r):Promise.all(r);return s.then(function(){this._loadingStatus.pending=false;return this}.bind(this))}.bind(this));return e.sync?this._loadingStatus.promise.unwrap():this._loadingStatus.promise},_preloadJSFormat:function(e){e=e||{};var n=this;var t=this.name.replace(/\./g,"/")+(e.http2?"/library-h2-preload":"/library-preload")+(e.sync?"":".js");var r;if(e.sync){r=v.resolve().then(function(){sap.ui.requireSync(t)})}else{r=sap.ui.loader._.loadJSResourceAsync(t)}return r.catch(function(r){if(e.fallbackToJSON){var a;if(e.sync){var s=r;while(s&&s.cause){s=s.cause}a=s&&s.name==="XHRLoadError"}else{a=true}if(a){i.error("failed to load '"+t+"' ("+(r&&r.message||r)+"), falling back to library-preload.json");return n._preloadJSONFormat({sync:e.sync})}}})},_preloadJSONFormat:function(e){e=e||{};var n=T(this.name,"/library-preload.json");l=c?c:l;return l(n,{headers:{Accept:l.ContentTypes.JSON}},e.sync).then(function(e){if(e.ok){return e.json().then(function(e){if(e){E(e,n);if(Array.isArray(e.dependencies)){return e.dependencies.map(function(e){return{name:e.replace(/\.library-preload$/,"")}})}else{return e.dependencies}}})}else{throw Error(e.statusText||e.status)}}).catch(function(e){i.error("failed to load '"+n+"': "+e.message)})},getManifest:function(e){if(!this.oManifest){var n=this.name.replace(/\./g,"/")+"/manifest.json";if(sap.ui.loader._.getModuleState(n)||e&&!this._manifestFailed){try{this.oManifest=u.loadResource(n,{dataType:"json",async:false,failOnError:!this.isSettingsEnhanced()});if(this._oManifest){U(this.oManifest)}else{this._manifestFailed=true}}catch(e){this._manifestFailed=true}}}return this.oManifest},_getDependencies:function(){var e=this.getManifest();var n=[];var t=e&&e["sap.ui5"]&&e["sap.ui5"].dependencies&&e["sap.ui5"].dependencies.libs;if(t){return Object.keys(t).reduce(function(e,n){if(!t[n].lazy){e.push({name:n})}else if(P.has(n)){e.push({name:n,lazy:true})}return e},n)}else{return n}},_getI18nSettings:function(){var e=this.getManifest(),n;if(e&&d(e._version).compareTo("1.9.0")>=0){n=e["sap.ui5"]&&e["sap.ui5"].library&&e["sap.ui5"].library.i18n}n=this._normalizeI18nSettings(n);return n},_normalizeI18nSettings:function(e){if(e==null||e===true){e={bundleUrl:"messagebundle.properties"}}else if(typeof e==="string"){e={bundleUrl:e}}else if(typeof e==="object"){e=a({},e)}return e},_includeTheme:function(e,n){var t=this.name,r=x().indexOf(t)!==-1;C.push({name:t,version:this.version,variant:e,preloadedCss:r});F().then(function(r){r.includeLibraryTheme(t,e,n)})},getResourceBundle:function(e){return this._loadResourceBundle(e,true)},loadResourceBundle:function(e){return this._loadResourceBundle(e)},_loadResourceBundle:function(n,i){var a=this,s=this.getManifest(i),o=!!s,u,l,c,f;e(n===undefined||typeof n==="string","sLocale must be a string or omitted");n=n||t.getLanguage();c=n+"/manifest-not-available";if(o){f=n;delete this._resourceBundles[c]}else{f=c}u=this._resourceBundles[f];if(!u||i&&u instanceof Promise){l=this._getI18nSettings();if(l){var d=T(this.name+"/",l.bundleUrl);j[d]=this;u=r.create({bundleUrl:d,supportedLocales:l.supportedLocales,fallbackLocale:l.fallbackLocale,locale:n,async:!i,activeTerminologies:t.getActiveTerminologies()});if(u instanceof Promise){u=u.then(function(e){a._resourceBundles[f]=e;return e})}this._resourceBundles[f]=u}}return i?u:Promise.resolve(u)}});M.getAllInstancesRequiringCss=function(){return C.slice()};M.isLoaded=function(e){return L[e]?true:false};M._get=function(e,n){var t=L[e];if(!t&&n){L[e]=t=new M({name:e,_key:R})}return t};M._getByBundleUrl=function(e){if(e){if(j[e]){return j[e]}var n=sap.ui.loader._.guessResourceName(e);if(n){for(var t in L){if(!L[t].isSettingsEnhanced()){continue}var r=t.replace(/\./g,"/");var i=L[t];if(r!==""&&n.startsWith(r+"/")){var a=n.replace(r+"/","");var s=i._getI18nSettings();if(s){var o=T(r,"/"+s.bundleUrl);a=T(r,"/"+a);if(a===o){j[e]=i;return i}j[e]=false}}}}}};M.all=function(){return M._all(false)};M._all=function(e){var n={};Object.keys(L).forEach(function(t){if(e||L[t].isSettingsEnhanced()){n[t]=L[t]}});return n};const q=Symbol("isProxy");function k(e,n){const t=new WeakMap;t.set(n,`${e}.`);const r={set(e,n,a){if(o(a)&&!a[q]){const o=s(a);let u=o;if(!o){if(y._isEnumCandidate(a)){e[n]=a;const r=t.get(e);y.registerEnum(`${r}${n}`,a);i.debug(`[Library API-Version 2] If you intend to use API-Version 2 in your library, make sure to call 'sap/ui/base/DataType.registerEnum' for ${r}${n}.`)}else{const t=n.charAt(0);if(t===t.toLowerCase()&&t!==t.toUpperCase()){u=true}else{e[n]=a}}}if(u){e[n]=new Proxy(a,r);const i=`${t.get(e)}${n}.`;t.set(a,i)}}else{e[n]=a}return true},get(e,n){if(n===q){return true}return e[n]}};return r}M.init=function(n){if(!sap.ui.require("sap/ui/core/Core")){throw new Error("Library "+n.name+": Library must not be used before the core is ready!")}e(typeof n==="object","mSettings given to 'sap/ui/core/Lib.init' must be an object");e(typeof n.name==="string"&&n.name,"mSettings given to 'sap/ui/core/Lib.init' must have the 'name' property set");var t="sap/ui/core/Lib.init";i.debug("Analyzing Library "+n.name,null,t);var r=M._get(n.name,true);r.enhanceSettings(n);var a=Object.create(null),s;a=f.create(n.name);const o=n.apiVersion??1;if(o<2){const e=k(n.name,a);a=new Proxy(a,e);f.set(n.name,a)}for(s=0;s<r.dependencies.length;s++){var u=r.dependencies[s];var l=M._get(u,true);i.debug("resolve Dependencies to "+u,null,t);if(!l.isSettingsEnhanced()){i.warning("Dependency from "+n.name+" to "+u+" has not been resolved by library itself",null,t);M._load({name:u},{sync:true})}}y.registerInterfaceTypes(r.interfaces);for(s=0;s<r.types.length;s++){if(!/^(any|boolean|float|int|string|object|void)$/.test(r.types[s])){const e=r.types[s];const n=r.name.replace(/\./g,"/")+"/library";sap.ui.loader._.declareModule(e.replace(/\./g,"/")+".js",`Deprecation: Importing the type '${e}' as a pseudo module is deprecated. Please import the type from the module '${n}'. You can then reference this type via the library's module export. `+`For more information, see documentation under 'Best Practices for Loading Modules'.`);var c=e.substring(0,e.lastIndexOf("."));if(f.get(c)===undefined){f.create(c)}}}(()=>{var e=r.controls.concat(r.elements);for(s=0;s<e.length;s++){sap.ui.lazyRequire(e[s],"new extend getMetadata")}})();if(!r.noLibraryCSS){var d={name:r.name,version:r.version,preloadedCss:x().indexOf(r.name)!==-1};C.push(d);F(!d.preloadedCss).then(function(e){e._includeLibraryThemeAndEnsureThemeRoot(d)})}r.sName=r.name;r.aControls=r.controls;M.fireLibraryChanged({name:n.name,stereotype:"library",operation:"add",metadata:r});return a};function I(e){return e.map(function(e){return e.name.replace(/\./g,"/")+"/library"})}function D(e){var n=I(e);return new Promise(function(t,r){sap.ui.require(n,function(){t(e)},r)})}M.load=function(e){if(typeof e==="string"){e={name:e}}else{e=["name","url"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{})}return M._load(e).then(function(e){return e[0]})};M._load=function(e,n){n=n||{};if(!Array.isArray(e)){e=[e]}var t={};var r=[];e.forEach(function(e){if(typeof e==="object"){if(e.hasOwnProperty("url")||e.hasOwnProperty("json")){t[e.name]=e}r.push(e.name)}else{r.push(e)}});var a=M.getPreloadMode()==="sync"||M.getPreloadMode()==="async",s=!n.preloadOnly;if(!n.sync){r=g._getTransitiveDependencyForLibraries(r)}var o=r.map(function(e){var n=M._get(e,true);if(n._loadingStatus==null&&t[e]&&t[e].url){w(e,t[e].url)}return n});if(n.sync){if(a){o.forEach(function(e){var n={sync:true};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}e._preload(n)})}if(s){I(o).forEach(function(e,n){if(o[n].isSettingsEnhanced()){return}sap.ui.requireSync(e);if(!o[n].isSettingsEnhanced()){i.warning("library "+o[n].name+" didn't initialize itself");M.init({name:o[n].name})}})}return o}const u=a?Promise.all(o.map(function(e){const n={};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}return e._preload(n)})):Promise.resolve(o);return s?u.then(D):u};M.getResourceBundleFor=function(e,n){var t=M._get(e,true);return t.getResourceBundle(n)};M._registerElement=function(e){var n=e.getName(),t=e.getLibraryName()||"",r=M._get(t),a=e.isA("sap.ui.core.Control")?"controls":"elements";if(!r){f.create(t);r=M._get(t,true)}if(r[a].indexOf(n)<0){r[a].push(n);i.debug("Class "+n+" registered for library "+t);M.fireLibraryChanged({name:n,stereotype:e.getStereotype(),operation:"add",metadata:e})}};var $=new m;M.attachLibraryChanged=function(e,n){$.attachEvent("LibraryChanged",e,n)};M.detachLibraryChanged=function(e,n){$.detachEvent("LibraryChanged",e,n)};M.fireLibraryChanged=function(e){$.fireEvent("LibraryChanged",e)};r._enrichBundleConfig=function(e){if(!e.terminologies||!e.enhanceWith){var n=M._getByBundleUrl(e.url);if(n){var r=n._getI18nSettings();if(r){var i=n.name.replace(/\./g,"/");i=i.endsWith("/")?i:i+"/";i=sap.ui.require.toUrl(i);S._processResourceConfiguration(r,{alreadyResolvedOnRoot:true,relativeTo:i});e.fallbackLocale=e.fallbackLocale||r.fallbackLocale;e.supportedLocales=e.supportedLocales||r.supportedLocales;e.terminologies=e.terminologies||r.terminologies;e.enhanceWith=e.enhanceWith||r.enhanceWith;e.activeTerminologies=e.activeTerminologies||t.getActiveTerminologies()}}}return e};M.getVersionedLibCss=function(){return n.get({name:"sapUiVersionedLibCss",type:n.Type.Boolean,external:true})};M.isDepCacheEnabled=function(){return n.get({name:"sapUiXxDepCache",type:n.Type.Boolean,external:true})};M.getPreloadMode=function(){if(_.getDebug()===true){return""}let e=n.get({name:"sapUiPreload",type:n.Type.String,defaultValue:"auto",external:true});if(e==="auto"){if(window["sap-ui-optimized"]){e=sap.ui.loader.config().async?"async":"sync"}else{e=""}}return e};return M});
//# sourceMappingURL=Lib.js.map