/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./HyphenationTestingWords","sap/ui/base/ManagedObject","sap/base/Log","sap/ui/core/Locale","sap/ui/core/Configuration"],function(e,n,t,r,i){"use strict";var a={bg:true,ca:true,hr:true,cs:false,// no valid license
da:true,nl:true,"en-us":true,et:true,fi:true,fr:true,de:true,"el-monoton":true,hi:true,hu:true,it:true,lt:true,"nb-no":true,pl:false,// no valid license
pt:true,ru:true,sr:false,// no valid license
sl:true,es:true,sv:true,th:true,tr:true,uk:true};var o={bg:"Bulgarian",ca:"Catalan",hr:"Croatian",cs:"Czech",da:"Danish",nl:"Dutch",en:"English",et:"Estonian",fi:"Finnish",fr:"French",de:"German",el:"Greek",hi:"Hindi",hu:"Hungarian",it:"Italian",lt:"Lithuanian",nb:"Norwegian Bokmål",no:"Norwegian",pl:"Polish",pt:"Portuguese",ru:"Russian",sr:"Serbian",sl:"Slovenian",es:"Spanish",sv:"Swedish",th:"Thai",tr:"Turkish",uk:"Ukrainian"};var u={};var s={};var p={};var h=null;var l=null;var c={};function y(e){t.info("[UI5 Hyphenation] Initializing third-party module for language "+P(e),"sap.ui.core.hyphenation.Hyphenation.initialize()");var n=d();n.require[e]="FORCEHYPHENOPOLY";return f(sap.ui.require.toUrl("sap/ui/thirdparty/hyphenopoly/"),"Hyphenopoly_Loader.js").then(function(){delete n.require[e];return window.Hyphenopoly.hyphenators[e]})}function d(){if(!window.Hyphenopoly){window.Hyphenopoly={require:{},setup:{selectors:{".hyphenate":{hyphen:"­",leftmin:3,rightmin:3,compound:"all"}},hide:"DONT_HIDE"},handleEvent:{error:function(e){if(e.msg.match(/engine for language .* loaded, but no elements found./)){e.preventDefault()}}}}}return window.Hyphenopoly}function f(e,n){return new Promise(function(t,r){var i=document.createElement("script");i.async=true;i.src=e+n;i.addEventListener("load",t);i.addEventListener("error",function(){return r("Error loading script: "+n)});i.addEventListener("abort",function(){return r(n+" Script loading aborted.")});document.head.appendChild(i)})}var g=function e(){var n=["visibility:hidden;","-moz-hyphens:auto;","-webkit-hyphens:auto;","hyphens:auto;","width:48px;","font-size:12px;","line-height:12px;","border:none;","padding:0;","word-wrap:normal"];return n.join("")}();function v(e,n){if(!l){l=document.createElement("body")}var t=document.createElement("div");t.lang=e;t.id=e;t.style.cssText=g;t.appendChild(document.createTextNode(n));l.appendChild(t)}function m(e){if(l){e.appendChild(l);return l}return null}function H(){if(l){l.parentNode.removeChild(l)}}function b(e){return e.style.hyphens==="auto"||e.style.webkitHyphens==="auto"||e.style.msHyphens==="auto"||e.style["-moz-hyphens"]==="auto"}function w(e){var n;if(e){n=new r(e)}else{n=i.getLocale()}var t=n.getLanguage().toLowerCase();switch(t){case"en":t="en-us";break;case"nb":t="nb-no";break;case"no":t="nb-no";break;case"el":t="el-monoton";break;default:break}return t}function L(e){if(e){return new r(e).toString()}return i.getLocale().toString()}function I(e){if(typeof e==="string"){return e.substring(0,2)}else{return null}}function P(e){var n=I(e);if(o.hasOwnProperty(n)){return"'"+o[n]+"' (code:'"+n+"')"}else{return"'"+n+"'"}}function E(e){h.fireError(e);t.error("[UI5 Hyphenation] "+e,"sap.ui.core.hyphenation.Hyphenation")}var k=n.extend("sap.ui.core.hyphenation.Hyphenation",{metadata:{library:"sap.ui.core",events:{error:{parameters:{sErrorMessage:{type:"string"}}}}}});k.prototype.canUseNativeHyphenation=function(n){var r=L(n),i=w(n),a;if(!this.isLanguageSupported(i)){return null}if(!u.hasOwnProperty(r)){v(r,e[i.toLowerCase()]);var o=m(document.documentElement);if(o!==null){var s=document.getElementById(r);if(b(s)&&s.offsetHeight>12){a=true}else{a=false}H()}u[r]=a;if(a){t.info("[UI5 Hyphenation] Browser-native hyphenation can be used for language "+P(r),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()")}else{t.info("[UI5 Hyphenation] Browser-native hyphenation is not supported by current platform for language "+P(r),"sap.ui.core.hyphenation.Hyphenation.canUseNativeHyphenation()")}}else{a=u[r]}return a};k.prototype.canUseThirdPartyHyphenation=function(e){var n=w(e),r;if(!this.isLanguageSupported(e)){return null}if(!p.hasOwnProperty(n)){r=a.hasOwnProperty(n)&&a[n];if(r){t.info("[UI5 Hyphenation] Third-party hyphenation can be used for language "+P(n),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()")}else{t.info("[UI5 Hyphenation] Third-party hyphenation is not supported for language "+P(n),"sap.ui.core.hyphenation.Hyphenation.canUseThirdPartyHyphenation()")}p[n]=r}else{r=p[n]}return r};k.prototype.isLanguageSupported=function(n){var r=w(n),i;if(!s.hasOwnProperty(r)){i=e.hasOwnProperty(r);if(!i){t.info("[UI5 Hyphenation] Language "+P(r)+" is not known to the Hyphenation API","sap.ui.core.hyphenation.Hyphenation.isLanguageSupported()")}s[r]=i}else{i=s[r]}return i};k.prototype.hyphenate=function(e,n){var t=w(n);if(!c.hasOwnProperty(t)){E("Language "+P(t)+" is not initialized. You have to initialize it first with method 'initialize()'");return e}return c[t](e)};k.prototype.getInitializedLanguages=function(){return Object.keys(c).map(function(e){return I(e)})};k.prototype.isLanguageInitialized=function(e){var n=w(e);return Object.keys(c).indexOf(n)!=-1};k.prototype.initialize=function(e){var n=w(e);if(!a[n]){var t="Language "+P(e)+" can not be initialized. It is either not supported by the third-party module or an error occurred";E(t);return Promise.reject(t)}if(c[n]){return Promise.resolve()}var r;if(!this._pInitLanguage){r=this._pInitLanguage=y(n).then(function(e){c[n]=e;this._pInitLanguage=null}.bind(this))}else{r=this._pInitLanguage.then(function(){return this.initialize(e)}.bind(this))}return r};k.getInstance=function(){if(!h){h=new k}return h};return k});
//# sourceMappingURL=Hyphenation.js.map