/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Control","sap/ui/base/DesignTime","sap/ui/core/Element","./Controller","./ViewRenderer","./ViewType","./XMLProcessingMode"],function(e,t,r,n,o,i,s,a,c,p,u,f,l){"use strict";var d=s.extend("sap.ui.core.mvc.View",{metadata:{interfaces:["sap.ui.core.IDScope"],abstract:true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:"sap.ui.core.mvc.Controller",controllerName:"string",preprocessors:"Object",resourceBundleName:"string",resourceBundleUrl:"sap.ui.core.URI",resourceBundleLocale:"string",resourceBundleAlias:"string",type:"string",definition:"any",viewContent:{type:"any",deprecated:true},viewData:"any",async:{type:"boolean",defaultValue:false}},designtime:"sap/ui/core/designtime/mvc/View.designtime"},renderer:u});d._mPreprocessors={};function g(e){e._settings={};for(var t in e){if(t.indexOf("_")!==0){e._settings[t]=e[t]}}}function m(e,t){var r;if(typeof e.preprocessor==="string"){var n=e.preprocessor.replace(/\./g,"/");if(t){return new Promise(function(e,t){sap.ui.require([n],function(t){e(t)},t)})}else{return sap.ui.requireSync(n)}}else if(typeof e.preprocessor==="function"&&!e.preprocessor.process){r={process:e.preprocessor}}else{r=e.preprocessor}if(t){return Promise.resolve(r)}else{return r}}function h(e,t){var n=this.mPreprocessors[t]||[],o=[],i,s,a,c=[];if(d._mPreprocessors[e]&&d._mPreprocessors[e][t]){o=d._mPreprocessors[e][t].map(function(e){return Object.assign({},e)})}for(i=0,s=o.length;i<s;i++){if(o[i]._onDemand){a=o[i]}else{c.push(o[i])}}for(i=0,s=n.length;i<s;i++){var p=!n[i].preprocessor;if(p&&a){c.unshift(r(n[i],a))}else if(!p){c.push(n[i])}}return c}function y(e,t){var r=e.getMetadata().getClass();function n(e){e.preprocessor=m(e,t.async)}e.mPreprocessors=Object.assign({},t.preprocessors);for(var o in r.PreprocessorType){var i=r.PreprocessorType[o];if(e.mPreprocessors[i]&&!Array.isArray(e.mPreprocessors[i])){e.mPreprocessors[i]=[e.mPreprocessors[i]]}else if(!e.mPreprocessors[i]){e.mPreprocessors[i]=[]}e.mPreprocessors[i].forEach(g);e.mPreprocessors[i]=h.call(e,r._sType,i);e.mPreprocessors[i].forEach(n)}}function w(e){e.oAsyncState={};e.oAsyncState.promise=null}var v=function(e,t){var r=t.async;var n=function(t){e.oController=t;t.oView=e};if(!a.isControllerCodeDeactivated()){var o=t.controller,s=o&&typeof o.getMetadata==="function"&&o.getMetadata().getName();if(!o&&e.getControllerName){e.bControllerIsViewManaged=true;var c=e.getControllerName();if(c){var u=sap.ui.require("sap/ui/core/Component");if(u){var f=u.getCustomizing(e,{type:"sap.ui.controllerReplacements",name:c});if(f){c=typeof f==="string"?f:f.controllerName}}if(r){o=p.create({name:c,_viewId:e.sId})}else{o=sap.ui.controller(c,true,false,e.sId)}}}else if(o){e.bControllerIsViewManaged=false;var l=i._sOwnerId;if(!o._isExtended()){o=p.applyExtensions(o,s,l,e.sId,r)}else if(r){o=Promise.resolve(o)}}if(o){if(r){if(!e.oAsyncState){throw new Error("The view "+e.sViewName+" runs in sync mode and therefore cannot use async controller extensions!")}return o.then(n)}else{n(o)}}}else if(r){const e=Object.assign(new p,{"_sap.ui.core.mvc.EmptyControllerImpl":true});return Promise.resolve(e).then(n)}else{sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl",{"_sap.ui.core.mvc.EmptyControllerImpl":true});e.oController=sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl")}};d.prototype._initCompositeSupport=function(o){o=o||{};e(!o.preprocessors||this.getMetadata().getName().indexOf("XMLView"),"Preprocessors only available for XMLView");this.oViewData=o.viewData;this.sViewName=o.viewName;if(this.sViewName&&this.sViewName.startsWith("module:")){this.sViewName=this.sViewName.slice("module:".length).replace(/\//g,".")}var i=this;y(this,o);if(o.async){w(this)}var s=sap.ui.require("sap/ui/core/Component");if(s){var a=s.getCustomizing(this,{type:"sap.ui.viewModifications",name:this.sViewName});if(!n(a)){this._fnSettingsPreprocessor=function(e){var n=this.getId();if(n){if(i.isPrefixedId(n)){n=n.substring((i.getId()+"--").length)}var o=Object.assign({},a[n]);if(o){for(var s in o){if(s!=="visible"){t.warning("[FUTURE FATAL] Customizing: custom value for property '"+s+"' of control '"+n+"' in View '"+i.sViewName+"' ignored: only the 'visible' property can be customized.");delete o[s]}}t.info("Customizing: custom value for property 'visible' of control '"+n+"' in View '"+i.sViewName+"' applied: "+o.visible);e=r(e,o)}}}}}var c=function(t,r){e(typeof t==="function","fn must be a function");var n=s&&s.getOwnerComponentFor(i);if(n){if(r){i.fnScopedRunWithOwner=i.fnScopedRunWithOwner||function(e){return n.runAsOwner(e)}}return n.runAsOwner(t)}return t()};var p=function(e){if(e.oController&&e.oController.connectToView){return e.oController.connectToView(e)}};var u=function(e){if(i.onControllerConnected){return i.onControllerConnected(i.oController,e)}};if(o.async){this.oAsyncState.promise=this.initViewSettings(o).then(function(){return c(v.bind(null,i,o),true)}).then(function(){return c(u.bind(null,o),true)}).then(function(){return p(i)}).then(function(){return i.runPreprocessor("controls",i,false)}).then(function(){return c(i.fireAfterInit.bind(i),true)}).then(function(){return i}).catch(function(e){this.deregister();throw e}.bind(this))}else{this.initViewSettings(o);v(this,o);u(o);p(this);this.runPreprocessor("controls",this,true);this.fireAfterInit()}};d.prototype.getController=function(){return this.oController};d.prototype.byId=function(e){return c.getElementById(this.createId(e))};d.prototype.createId=function(e){if(!this.isPrefixedId(e)){e=this.getId()+"--"+e}return e};d.prototype.getLocalId=function(e){var t=this.getId()+"--";return e&&e.indexOf(t)===0?e.slice(t.length):null};d.prototype.isPrefixedId=function(e){return!!(e&&e.indexOf(this.getId()+"--")===0)};d.prototype.getViewData=function(){return this.oViewData};function P(){this.oAsyncState=null}d.prototype.exit=function(){this.fireBeforeExit();if(this.oController&&this.bControllerIsViewManaged){this.oController.destroy();delete this.oController}delete this.oPreprocessorInfo;if(this.oAsyncState){var e=P.bind(this);this.oAsyncState.promise.then(e,e)}};d.prototype.onAfterRendering=function(){this.fireAfterRendering()};d.prototype.onBeforeRendering=function(){this.fireBeforeRendering()};d.prototype.clone=function(e,r){t.error("[FUTURE FATAL] Cloning a View and/or using a View as a binding template is deprecated. Please call the corresponding View factory instead, e.g. XMLView.create()");var n={},o,i;for(o in this.mProperties&&!(this.isBound&&this.isBound(o))){if(this.mProperties.hasOwnProperty(o)){n[o]=this.mProperties[o]}}i=s.prototype.clone.call(this,e,r,{cloneChildren:false,cloneBindings:true});var a,c,p;for(a in i.mEventRegistry){c=i.mEventRegistry[a];for(p=c.length-1;p>=0;p--){if(c[p].oListener===this.getController()){c[p]={oListener:i.getController(),fFunction:c[p].fFunction,oData:c[p].oData}}}}i.applySettings(n);return i};d.prototype.getPreprocessors=function(){return this.mPreprocessors};d.prototype.getPreprocessorInfo=function(e){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!e}}if(d._supportInfo){this.oPreprocessorInfo._supportInfo=d._supportInfo}return this.oPreprocessorInfo};d.prototype.runPreprocessor=function(e,r,n){var o=this.getPreprocessorInfo(n),i=this.mPreprocessors&&this.mPreprocessors[e]||[],s,a,c;if(!n){a=function(e,t){return function(r){return t.preprocessor.then(function(n){return n.process(r,e,t._settings)})}};c=Promise.resolve(r)}for(var p=0,u=i.length;p<u;p++){if(n&&i[p]._syncSupport===true){s=i[p].preprocessor.process;r=s(r,o,i[p]._settings)}else if(!n){c=c.then(a(o,i[p]))}else{t.debug('Async "'+e+'"-preprocessor was skipped in sync view execution for '+this.getMetadata().getClass()._sType+"View",this.getId())}}return n?r:c};function C(e,t){if(!d._mPreprocessors[t]){d._mPreprocessors[t]={}}if(!d._mPreprocessors[t][e]){d._mPreprocessors[t][e]=[]}}function V(e,t){return d._mPreprocessors[e][t].some(function(e){return!!e._onDemand})}d.registerPreprocessor=function(e,r,n,o,i,s){if(typeof i!=="boolean"){s=i;i=false}if(r){C(e,n);if(i&&V(n,e)){t.error('[FUTURE FATAL] Registration for "'+e+'" failed, only one on-demand-preprocessor allowed',this.getMetadata().getName());return}d._mPreprocessors[n][e].push({preprocessor:r,_onDemand:i,_syncSupport:o,_settings:s});t.debug("Registered "+(i?"on-demand-":"")+'preprocessor for "'+e+'"'+(o?" with syncSupport":""),this.getMetadata().getName())}else{t.error('[FUTURE FATAL] Registration for "'+e+'" failed, no preprocessor specified',this.getMetadata().getName())}};d.prototype.hasPreprocessor=function(e){return!!this.mPreprocessors[e].length};d.create=function(e){var t=o({},e);t.async=true;t.viewContent=t.definition;var r=sap.ui.require("sap/ui/core/Component");var n;if(r&&i._sOwnerId){n=r.getComponentById(i._sOwnerId)}function s(){return b(t.id,t,t.type).loaded()}return new Promise(function(e,r){var n=d._getViewClassName(t);sap.ui.require([n],function(t){e(t)},r)}).then(function(e){if(e.getMetadata().isA("sap.ui.core.mvc.XMLView")){t.processingMode=l.Sequential}if(n){return n.runAsOwner(s)}else{return s()}})};d._create=b;sap.ui.view=function(e,r,n){var o=typeof e==="string"?e:r;o=typeof o==="object"?o.viewName:o;t.warning("Do not use deprecated view factory functions (View: "+o+"). "+"Use the static create function on the view module instead: [XML|HTML|JSON]View.create().","sap.ui.view",null,function(){return{type:"sap.ui.view",name:o}});return b(e,r,n)};function b(n,o,s){var a=null,c={};if(typeof n==="object"||typeof n==="string"&&o===undefined){o=n;n=undefined}if(o){if(typeof o==="string"){c.viewName=o}else{c=o}}e(!c.async||typeof c.async==="boolean","sap.ui.view factory: Special setting async has to be of the type 'boolean'!");if(n){c.id=n}if(s){c.type=s}if(c.type===f.XML&&c.async){c.processingMode=c.processingMode||l.SequentialLegacy}var p=sap.ui.require("sap/ui/core/Component");if(p&&i._sOwnerId){var u=p.getCustomizing(i._sOwnerId,{type:"sap.ui.viewReplacements",name:c.viewName});if(u){delete u.async;t.info("Customizing: View replacement for view '"+c.viewName+"' found and applied: "+u.viewName+" (type: "+u.type+")");r(c,u)}else{t.debug("Customizing: no View replacement found for view '"+c.viewName+"'.")}}var g=d._getViewClassName(c);a=I(g,c);return a}d._getViewClassName=function(e,r){var n=d._getModuleName(e);if(n){if(e.type&&!r){t.error("When using the view factory, the 'type' setting must be omitted for typed views. When embedding typed views in XML, don't use the <JSView> tag, use the <View> tag instead.")}return n}if(!e.type){throw new Error("No view type specified.")}if(e.type===f.XML){return"sap/ui/core/mvc/XMLView"}if(e.type===f.JS){n="sap/ui/core/mvc/JSView"}else if(e.type===f.JSON){n="sap/ui/core/mvc/JSONView"}else if(e.type===f.HTML){n="sap/ui/core/mvc/HTMLView"}else if(e.type===f.Template){n="sap/ui/core/mvc/TemplateView"}if(!n){throw new Error("Unknown view type "+e.type+" specified.")}return n};function I(e,r){var n=sap.ui.require(e);if(!n){n=sap.ui.requireSync(e);if(r.async){t.warning("sap.ui.view was called without requiring the according view class.")}}return new n(r)}d.prototype.loaded=function(){if(this.oAsyncState&&this.oAsyncState.promise){return this.oAsyncState.promise}else{return Promise.resolve(this)}};d._getModuleName=function(e){var t;if(e.viewName&&e.viewName.startsWith("module:")){t=e.viewName.slice("module:".length)}return t};d.prototype.getAutoPrefixId=function(){return false};d.prototype.onControllerConnected=function(e,t){if(!this.createContent&&typeof this.createContent!=="function"){return}var r={id:this.getAutoPrefixId()?this.createId.bind(this):undefined,settings:this._fnSettingsPreprocessor};return i.runWithPreprocessors(function(){var r=this.createContent(e);if(t.async){r=Promise.resolve(r);return r.then(function(e){this.applySettings({content:e})}.bind(this))}else if(r instanceof Promise){throw new Error("An asynchronous view (createContent) cannot be instantiated synchronously. Affected view: '"+this.getMetadata().getName()+"'.")}else{this.applySettings({content:r})}}.bind(this),r)};d.prototype.initViewSettings=function(e){if(!this.getMetadata()._oRenderer){this.getMetadata().getRenderer=function(){return d.getMetadata().getRenderer()};this.getMetadata().getRendererName=function(){return d.getMetadata().getRendererName()}}if(e.async){return Promise.resolve()}};return d});
//# sourceMappingURL=View.js.map