/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./View","./ViewType","./XMLViewRenderer","sap/base/config","sap/base/Log","sap/base/strings/hash","sap/base/util/LoaderExtensions","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/RenderManager","sap/ui/core/XMLTemplateProcessor","sap/ui/core/cache/CacheManager","sap/ui/model/resource/ResourceModel","sap/ui/util/XMLHelper","sap/ui/Global","sap/ui/VersionInfo","sap/ui/performance/trace/Interaction","sap/ui/thirdparty/jquery"],function(e,t,n,r,i,o,s,a,c,u,l,d,p,f,h,m,g,v,w,jQuery){"use strict";var y=d.RenderPrefixes,C="XMLViewCacheError",P={};var M=l.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{metadata:{library:"sap.ui.core"},renderer:{apiVersion:2,render:function(e,t){e.text("")}}});var b=e.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:"sap.ui.core.mvc.XMLView",visibility:"hidden"},xmlNode:{type:"Element",visibility:"hidden"},cache:"Object",processingMode:{type:"sap.ui.core.mvc.XMLProcessingMode",visibility:"hidden"},requireContext:"Object"},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"},renderer:n});sap.ui.xmlview=function(e,n){return sap.ui.view(e,n,t.XML)};b.create=function(n){var r=a({},n);r.viewContent=r.definition;r.async=true;r.type=t.XML;return e.create(r)};b._sType=t.XML;b.asyncSupport=true;b._bUseCache=r.get({name:"sapUiXxViewCache",type:r.Type.Boolean,defaultValue:true,external:true})&&f._isSupportedEnvironment();function x(e){if(e.parseError.errorCode!==0){var t=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+t.url+" code: "+t.errorCode+" reason: "+t.reason+" src: "+t.srcText+" line: "+t.line+" linepos: "+t.linepos+" filepos: "+t.filepos)}}function E(e,t){if(!t){throw new Error("mSettings must be given")}else if(t.viewName&&t.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.")}else if((t.viewName||t.viewContent)&&t.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.")}else if(!(t.viewName||t.viewContent)&&!t.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.")}else if(t.cache&&!(t.cache.keys&&t.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.")}}function N(e,t){e.mProperties["viewContent"]=t.viewContent;var n=m.parse(t.viewContent);x(n);return n.documentElement}function _(e,t){if((e._resourceBundleName||e._resourceBundleUrl)&&(!t.models||!t.models[e._resourceBundleAlias])){var n=new h({bundleName:e._resourceBundleName,bundleUrl:e._resourceBundleUrl,bundleLocale:e._resourceBundleLocale,async:t.async});var r=n.getResourceBundle();if(r instanceof Promise){return r.then(function(){e.setModel(n,e._resourceBundleAlias)})}e.setModel(n,e._resourceBundleAlias)}}function V(e){e.oAfterRenderingNotifier=new M;e.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){e.onAfterRenderingBeforeChildren()}})}function A(e){var t=sap.ui.require("sap/ui/core/Component"),n;if(t){while(e){var r=t.getOwnerComponentFor(e);if(r){e=n=r}else{if(e instanceof t){n=e}e=e.getParent&&e.getParent()}}}return n}function R(e,t){var n=A(e),r=n?JSON.stringify(n.getManifest()):null,i=[];i=i.concat(T(e,n),I(),X(e),t.keys);return D(e,i).then(function(e){return{key:e+"("+o(r||"")+")",componentManifest:r,additionalData:t.additionalData}})}function L(e){return e}function D(e,t){return Promise.all(t).then(function(e){e=e.filter(function(e){return e!==P});if(e.every(L)){return e.join("_")}else{var t=new Error("Provided cache keys may not be empty or undefined.");t.name=C;return Promise.reject(t)}})}function T(e,t){var n=t&&t.getMetadata().getName();return[n||window.location.host+window.location.pathname,e.getId(),u.getLanguageTag()].concat(t&&t.getActiveTerminologies()||[])}function X(e){var t=e.getPreprocessors(),n=e.getPreprocessorInfo(false),r=[];function i(e){r.push(e.preprocessor.then(function(e){if(e.getCacheKey){return e.getCacheKey(n)}else{return P}}))}for(var o in t){t[o].forEach(i)}return r}function I(){return v.load().then(function(e){var t="";if(!e.libraries){t=g.buildinfo.buildtime}else{e.libraries.forEach(function(e){t+=e.buildTimestamp})}return t}).catch(function(e){i.warning("version info could not be retrieved","sap.ui.core.mvc.XMLView");i.debug(e);return""})}function S(e,t){var n=e.key;delete e.key;var r=e.additionalData;e.xml=m.serialize(t);if(r&&r.setAdditionalCacheData&&r.getAdditionalCacheData){e.additionalData=r.getAdditionalCacheData()}return f.set(n,e)}function B(e){return f.get(e.key).then(function(t){if(t&&t.componentManifest==e.componentManifest){t.xml=m.parse(t.xml,"application/xml").documentElement;if(t.additionalData){var n=e.additionalData;if(n&&n.setAdditionalCacheData&&n.getAdditionalCacheData){n.setAdditionalCacheData(t.additionalData)}else{i.error("Deprecated: Don't use an object reference for caching additional Data! Use a CacheDataProvider instead!");a(e.additionalData,t.additionalData)}}return t}})}b.prototype.initViewSettings=function(t){var n=this,r;function o(r){n._xContent=r;if(e._supportInfo){e._supportInfo({context:n._xContent,env:{caller:"view",viewinfo:a({},n),settings:a({},t||{}),type:"xmlview"}})}if(!n.isSubView()){p.parseViewAttributes(r,n)}else{delete t.controller}var i=_(n,t);if(i instanceof Promise){return i.then(function(){V(n)})}V(n)}function c(e,t){if(n.hasPreprocessor("viewxml")){return p.enrichTemplateIdsPromise(e,n,t).then(function(){return n.runPreprocessor("viewxml",e,!t)})}return e}function u(e){var t=w.notifyAsyncStep("VIEW PREPROCESSING");return n.runPreprocessor("xml",e).then(function(e){return c(e,true)}).finally(t)}function l(e){return s.loadResource(e,{async:true}).then(function(e){return e.documentElement})}function d(e,t){return l(e).then(u).then(function(e){if(t){S(t,e)}return e})}function f(e,t){return R(n,t).then(function(t){return B(t).then(function(n){if(!n){return d(e,t)}else{return n.xml}})}).catch(function(t){if(t.name===C){i.error(t.message,t.name,"sap.ui.core.mvc.XMLView");i.error("Processing the View without caching.","sap.ui.core.mvc.XMLView");return d(e)}else{return Promise.reject(t)}})}this._oContainingView=t.containingView||this;this._sProcessingMode=t.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true}E(this,t);if(t.viewName){var h=t.viewName.replace(/\./g,"/")+".view.xml";if(t.async){if(t.cache&&b._bUseCache){return f(h,t.cache).then(o)}else{return l(h).then(u).then(o)}}else{r=s.loadResource(h).documentElement}}else if(t.viewContent){if(t.viewContent.nodeType===window.Node.DOCUMENT_NODE){r=t.viewContent.documentElement}else{r=N(this,t)}}else if(t.xmlNode){r=t.xmlNode}if(t.async){return u(r).then(o)}else{r=this.runPreprocessor("xml",r,true);r=c(r,false);if(r&&typeof r.getResult==="function"){if(r.isRejected()){throw r.getResult()}r=r.getResult()}o(r)}};b.prototype.onBeforeRendering=function(){var t=this.getDomRef();if(t&&!d.isPreservedContent(t)){d.preserveContent(t,true)}e.prototype.onBeforeRendering.apply(this,arguments)};b.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy()}e.prototype.exit.apply(this,arguments)};b.prototype.onControllerConnected=function(e,t){var n=this;function r(e){return c.runWithPreprocessors(e,{settings:n._fnSettingsPreprocessor})}if(!this.oAsyncState){this._aParsedContent=r(p.parseTemplate.bind(null,this._xContent,this,t))}else{var i=w.notifyAsyncStep("VIEW PROCESSING");return p.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:r}).then(function(e){n._aParsedContent=e;delete n.oAsyncState.suppressPreserve}).finally(i)}};b.prototype.getControllerName=function(){return this._controllerName};b.prototype.isSubView=function(){return this._oContainingView!=this};b.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var t=0;t<e.length;t++){var n=document.getElementById(y.Temporary+e[t].getId())||e[t].getDomRef()||document.getElementById(y.Invisible+e[t].getId());if(n){jQuery(document.getElementById(y.Dummy+e[t].getId())).replaceWith(n)}}}jQuery(document.getElementById(y.Temporary+this.getId())).replaceWith(this._$oldContent)}this._$oldContent=undefined};b.prototype._onChildRerenderedEmpty=function(e,t){jQuery(t).replaceWith('<div id="'+y.Dummy+e.getId()+'" class="sapUiHidden"></div>');return true};b.registerPreprocessor=function(t,n,r,o,s,a){var c=this.getMetadata().getClass()._sType;if(typeof r==="string"){if(r!==c){throw new TypeError("View types other than "+c+" are not supported by XMLView.registerPreprocessor,"+" check View.registerPreprocessor instead")}}else{a=s;s=o;o=r}t=t.toUpperCase();if(b.PreprocessorType[t]){e.registerPreprocessor(b.PreprocessorType[t],n,c,o,s,a)}else{i.error('[FUTURE FATAL] Preprocessor could not be registered due to unknown sType "'+t+'"',this.getMetadata().getName())}};b.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};b.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return b});
//# sourceMappingURL=XMLView.js.map