/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/core/support/Plugin","sap/ui/performance/Measurement","sap/base/security/encodeXML"],function(e,t,r,i){"use strict";var a=[];var n=0;var s=0;var d=250;var o=false;var l;var u={selectedInterval:{start:0,end:0},nodes:{slider:null,handle:null,leftResizeHandle:null,rightResizeHandle:null},consts:{LEFT_HANDLE_ID:"left",RIGHT_HANDLE_ID:"right"},sizes:{width:0,handleWidth:0,handleMinWidth:10},drag:{handleClickOffsetX:0,handleOffsetLeft:0,isResize:false,whichResizeHandle:""}};var c=t.extend("sap.ui.core.support.plugins.Performance",{constructor:function(e){t.apply(this,["sapUiSupportPerf","Performance",e]);l=this;if(this.runsAsToolPlugin()){this._aEventIds=[this.getId()+"SetMeasurements",this.getId()+"SetActive"]}else{this._aEventIds=[this.getId()+"Refresh",this.getId()+"Clear",this.getId()+"Start",this.getId()+"End",this.getId()+"Activate"]}}});c.prototype.init=function(e){t.prototype.init.apply(this,arguments);if(this.runsAsToolPlugin()){f.call(this,e)}else{p.call(this,e)}};c.prototype.exit=function(e){t.prototype.exit.apply(this,arguments)};function f(e){this.$().get(0).innerHTML=S();I()}function p(e){h.call(this)}function h(e){var t=r.getAllMeasurements(true);this._oStub.sendEvent(this.getId()+"SetMeasurements",{measurements:t})}c.prototype.onsapUiSupportPerfSetMeasurements=function(e){var t=e.getParameter("measurements");this.setData(t)};c.prototype.onsapUiSupportPerfRefresh=function(e){h.call(this)};c.prototype.onsapUiSupportPerfClear=function(e){r.clear();this._oStub.sendEvent(this.getId()+"SetMeasurements",{measurements:[]})};c.prototype.onsapUiSupportPerfStart=function(e){r.start(this.getId()+"-perf","Measurement by support tool")};c.prototype.onsapUiSupportPerfEnd=function(e){r.end(this.getId()+"-perf");h.call(this)};c.prototype.onsapUiSupportPerfActivate=function(e){r.setActive(true)};c.prototype.setData=function(e){var t=document.querySelector("#sapUiSupportNoDataOverlay");var r=document.querySelector("#slider");var i=document.querySelector("#sapUiSupportPerfHeaderTimelineOverview .timeline");if(e.length===0){t.style.display="block";r.classList.add("sapUiSupportHidden");i.innerHTML="";return}else{r.classList.remove("sapUiSupportHidden");t.style.display=""}a=JSON.parse(JSON.stringify(e));a=a.sort(function(e,t){return e.start-t.start});var n=e[0].start;a=a.map(function(e){e.start=parseFloat((e.start-n).toFixed(2));e.end=parseFloat((e.end-n).toFixed(2));e.uid=x();return e});s=a[a.length-1].end-a[0].start;u.selectedInterval.start=a[0].start;u.selectedInterval.end=a[a.length-1].end;X();T(a);w(a);N()};var v=10;var m=0;var g;function y(e){clearInterval(g);if(o){o=false;l._oStub.sendEvent(l.getId()+"End");e.target.setAttribute("data-state","Start recording ("+(m/1e3).toFixed(2)+" s)")}else{m=0;o=true;l._oStub.sendEvent(l.getId()+"Activate");l._oStub.sendEvent(l.getId()+"Clear");l._oStub.sendEvent(l.getId()+"Start");e.target.setAttribute("data-state","Stop recording ("+(m/1e3).toFixed(2)+" s)");g=setInterval(function(){m+=v;e.target.setAttribute("data-state","Stop recording ("+(m/1e3).toFixed(2)+" s)")},v)}}function S(){return""+'<section id="sapUiSupportPerf">'+'<section id="sapUiSupportNoDataOverlay"></section>'+'<section id="sapUiSupportPerfHeader">'+'<div class="sapUiSupportToolbar">'+'<label class="sapUiSupportLabel">Order:</label>'+'<select id="sapUiSupportPerfHeaderFilterSort" class="sapUiSupportTxtFld sapUiSupportSelect" name="orderBy">'+'<option value="chronologically">Chronologically</option>'+'<option value="time">By Time</option>'+'<option value="duration">By Duration</option>'+"</select>"+'<label class="sapUiSupportLabel">Min. Duration:</label>'+'<input id="sapUiSupportPerfHeaderFilterMinDuration" type="number" min="0" value="0">'+'<label class="sapUiSupportLabel"> ms.</label>'+'<div class="flex-spacer"></div>'+'<div id="categories"></div>'+"</div>"+'<section id="sapUiSupportPerfHeaderTimelineOverview">'+'<div class="timeline"></div>'+'<button id="sapUiSupportPerfToggleRecordingBtn"></button>'+'<div id="slider">'+'<div id="slideHandle">'+'<span id="leftHandle"></span>'+'<span id="rightHandle"></span>'+"</div>"+"</div>"+"</section>"+"</section>"+'<section id="sapUiSupportPerfHeaderTimeline">'+'<div id="sapUiSupportPerfHeaderTimelineBarInfoWrapper"></div>'+'<div id="sapUiSupportPerfHeaderTimelineBarWrapper"></div>'+"</section>"+"</section>"}function E(e){return a.reduce(function(t,r){if(r.uid===e){t=r}return t},null)}function x(){return"uID-"+(x.id!==undefined?++x.id:x.id=0)}function I(){document.querySelector("#sapUiSupportPerfHeaderFilterSort").addEventListener("change",w,false);document.querySelector("#sapUiSupportPerfHeaderFilterMinDuration").addEventListener("change",w,false);document.querySelector("#categories").addEventListener("change",w,false);document.querySelector("#sapUiSupportPerfHeaderTimelineBarWrapper").addEventListener("mouseover",B,false);document.querySelector("#sapUiSupportPerfHeaderTimelineBarInfoWrapper").addEventListener("mouseover",B,false);window.addEventListener("resize",function(){w();J()},false);window.addEventListener("keydown",j);document.getElementById("slideHandle").addEventListener("dblclick",X);document.getElementById("sapUiSupportPerfToggleRecordingBtn").addEventListener("click",y);document.getElementById("sapUiSupportPerfToggleRecordingBtn").dataset.state="Start recording"}function H(e,t){return"Duration: "+e.toFixed(2)+" ms.\nTime: "+t.toFixed(2)+" ms."}function L(e){var t=50;var r=s/t;var i=[];for(var a=0;a<t;a++){var n=r*a;var d=n+r;var o=C({start:n,end:d},e);var l=o.map(function(e){return{category:e.categories[0],duration:e.duration}});var u={_total:0};l.map(function(e){if(!u[e.category]){u[e.category]=0}u._total+=e.duration;u[e.category]=u[e.category]+e.duration});var c=o.map(function(e){return{category:e.categories[0],time:e.time}});var f={_total:0};c.map(function(e){if(!f[e.category]){f[e.category]=0}f._total+=e.time;f[e.category]=f[e.category]+e.time});i.push({duration:u,time:f})}return i}function z(e,t,r){Object.keys(t.duration).sort().forEach(function(i){if(i!=="_total"){var a=t[r][i]/t[r]._total*100;e.openStart("div").class(O(i)).style("height",a.toFixed(2)+"%").openEnd().close("div")}})}function T(t){var r=document.querySelector("#sapUiSupportPerfHeaderTimelineOverview .timeline");var i=JSON.parse(JSON.stringify(t));var a=i.map(function(e){return e.duration}).reduce(function(e,t){return e+t});var n=i.map(function(e){return e.time}).reduce(function(e,t){return e+t});var s=L(i);var d={time:{_total:0}};var o={duration:{_total:0}};s.forEach(function(e){if(d.time._total<e.time._total){d=e}if(o.duration._total<e.duration._total){o=e}});n=d.time._total;a=o.duration._total;var l=e.createRenderManager();l.openStart("ol").openEnd();s.forEach(function(e){var t=Math.ceil(e.duration._total/a*100);var r=Math.ceil(e.time._total/n*100);l.openStart("li").openEnd();l.openStart("div").class("bars-wrapper").attr("title",H(e.duration._total,e.time._total)).openEnd();l.openStart("div").class("duration").style("height",t+"%");if(t>0){l.style("min-height","1px")}l.openEnd();z(l,e,"duration");l.close("div");l.openStart("div").class("time").style("height",r+"%");if(r>0){l.style("min-height","1px")}l.openEnd();z(l,e,"time");l.close("div");l.close("div");l.close("li")});l.close("ol");l.flush(r);l.destroy()}function w(){var t=e.createRenderManager();var r=e.createRenderManager();var i=R();var n=q(a,i);if(n.length===0){t.openStart("li").class("line").class("nodata").attr("data-uid",-1).openEnd().close("li");r.openStart("li").class("line").class("nodata").attr("data-uid",-1).openEnd();r.openStart("div").class("info").class("line").openEnd().text("No data").close("div");r.close("li")}n.forEach(function(e){var a=E(e.uid);t.openStart("li").class("line").attr("data-uid",e.uid).attr("title",U(a)).attr("data-item-category",a.categories[0]).openEnd();t.openStart("div").class("bar").class(W(a.duration)).style("width",M(e.duration)).style("margin-left",b(e,i.filterByTime.start)).openEnd();t.openStart("div").class("sub-bar").class(W(a.time)).style("width",M(e.time)).openEnd().close("div");t.close("div");t.close("li");r.openStart("li").class("line").class(O(a.categories[0])).attr("data-uid",e.uid).attr("title",U(a)).attr("data-item-category",a.categories[0]).openEnd();r.openStart("div").class("line").class("info").openEnd().text(P(a)+" ("+a.time.toFixed(0)+" ms)").close("div");r.close("li")});t.close("ol");r.close("ol");t.flush(document.querySelector("#sapUiSupportPerfHeaderTimelineBarWrapper"));r.flush(document.querySelector("#sapUiSupportPerfHeaderTimelineBarInfoWrapper"));t.destroy();r.destroy();k(i);F()}function M(e){var t=e*n;var r=Math.max(t,1);return r+"px;"}function b(e,t){var r=(e.start-t)*n;return r.toFixed(0)+"px"}function U(e){return e.info+"\nduration: "+e.duration.toFixed(2)+" ms. \ntime: "+e.time.toFixed(2)+" ms. \nstart: "+e.start.toFixed(2)+" ms.\nend: "+e.end.toFixed(2)+" ms."}function P(e){var t=e.info;t=t.substring(t.lastIndexOf("/")+1,t.length);t=t.substring(t.lastIndexOf("sap.m."),t.length);t=t.replace("Rendering of ","");return t}function O(e){var t="unknownType";if(e.indexOf("require")!==-1){t="requireModuleType"}else if(e.indexOf("xmlhttprequest")!==-1){t="requestType"}else if(e.indexOf("javascript")!==-1){t="afterRenderingType"}else if(e.indexOf("rendering")!==-1){t="renderingType"}return t}function W(e){var t="";if(e>200){t="oneTimeStyle"}if(e>500){t="twoTimeStyle"}if(e>1e3){t="threeTimeStyle"}if(e>2e3){t="fourTimeStyle"}if(e>3e3){t="fiveTimeStyle"}if(e>4e3){t="sixTimeStyle"}return t}function _(e){var t=[];e.forEach(function(e){if(t.indexOf(e.categories[0])===-1){t.push(e.categories[0])}});return t}function B(e){var t=e.srcElement;if(t.classList.contains("info")&&t.nodeName==="DIV"){t=t.parentNode}if(t.nodeName==="LI"){var r=t.getAttribute("data-uid");var i=document.querySelector("#sapUiSupportPerfHeaderTimelineBarInfoWrapper li.hover");var a=document.querySelector("#sapUiSupportPerfHeaderTimelineBarWrapper li.hover");if(i&&a){i.classList.remove("hover");a.classList.remove("hover")}var n=document.querySelector('#sapUiSupportPerfHeaderTimelineBarInfoWrapper li[data-uid="'+r+'"]');var s=document.querySelector('#sapUiSupportPerfHeaderTimelineBarWrapper li[data-uid="'+r+'"]');if(n&&s){n.classList.add("hover");s.classList.add("hover")}}}function q(e,t){var r=JSON.parse(JSON.stringify(e));var i=document.querySelector("#sapUiSupportPerfHeaderTimeline").offsetWidth-document.querySelector("#sapUiSupportPerfHeaderTimelineBarInfoWrapper").offsetWidth;var a=20;var s=1;r=C(t.filterByTime,r);r=D(t.orderByValue,r);r=A(t.minValue,r);if(r.length){s=t.filterByTime.end-t.filterByTime.start}n=(i-a)/s;return r}function R(){var e={};var t=document.querySelector("#sapUiSupportPerfHeaderFilterSort");e.orderByValue=t.options[t.selectedIndex].value;e.minValue=document.querySelector("#sapUiSupportPerfHeaderFilterMinDuration").valueAsNumber||0;e.filterByTime={start:u.selectedInterval.start,end:u.selectedInterval.end};return e}function F(){var e=document.querySelectorAll("#categories input");function t(e,t){var r=O(e);var i=document.querySelectorAll('li[data-item-category="'+e+'"]');var a=document.querySelectorAll(".timeline .bars-wrapper ."+r);for(var n=0;n<i.length;n++){i[n].style.display=t?"":"none"}for(var s=0;s<a.length;s++){a[s].style.display=t?"":"none"}}for(var r=0;r<e.length;r++){t(e[r].name,e[r].checked)}}function D(e,t){if(e==="time"||e==="duration"){document.querySelector("body").classList.add("flattenBarOffset")}else{document.querySelector("body").classList.remove("flattenBarOffset")}if(e==="time"){t=t.sort(function(e,t){if(e.time>t.time){return-1}if(e.time<t.time){return 1}return 0})}if(e==="duration"){t=t.sort(function(e,t){if(e.duration>t.duration){return-1}if(e.duration<t.duration){return 1}return 0})}return t}function A(e,t){return t.filter(function(t){return t.duration>=e})}function C(e,t){return t.filter(function(t){return!(t.end<=e.start||t.start>=e.end)}).map(function(t){var r=Math.max(e.start-t.start,0);var i=Math.max(t.start+t.time-e.end,0);t.time=t.time-r-i;var a=Math.max(e.start-t.start,0);var n=Math.max(t.start+t.duration-e.end,0);t.duration=t.duration-a-n;t.start=Math.max(t.start,e.start);t.end=Math.min(t.end,e.end);return t})}function N(){var e="";var t=_(a);t.forEach(function(t){t=i(t);e+='<label title="'+t+'"><input class="'+O(t)+'" checked type="checkbox" name="'+t+'">'+t+"</label>"});var r=document.querySelector("#categories");r.innerHTML=e}function k(e){var t=document.getElementById("sapUiSupportPerfHeaderTimelineBarWrapper");var r=Math.round(t.offsetWidth/10);var i=e.filterByTime.end-e.filterByTime.start;var a=parseInt(i/r);if(document.getElementById("grid")){document.getElementById("grid").parentNode.removeChild(document.getElementById("grid"))}var n=document.createElement("div");n.innerHTML='<div class="header"></div><div class="body"></div>';n.id="grid";for(var s=1;s<=r;s++){var d=document.createElement("div");var o=document.createElement("div");if(s%5===0||s===1){var l=parseInt(e.filterByTime.start);if(s!==1){l+=s*a}l=l>500?(l/1e3).toFixed(2)+" s":l+" ms";o.setAttribute("data-time",l)}n.querySelector(".body").appendChild(d);n.querySelector(".header").appendChild(o)}document.querySelector("#sapUiSupportPerf").appendChild(n)}function X(){u.nodes.slider=u.nodes.slider||document.querySelector("#slider");u.nodes.handle=u.nodes.handle||document.querySelector("#slideHandle");u.nodes.leftResizeHandle=u.nodes.leftResizeHandle||document.querySelector("#leftHandle");u.nodes.rightResizeHandle=u.nodes.rightResizeHandle||document.querySelector("#rightHandle");u.nodes.handle.style.left=0;u.nodes.handle.style.width="100%";J();u.nodes.slider.addEventListener("mousedown",V)}function J(){if(u.nodes.handle==null||u.nodes.slider==null){return}var e=window.getComputedStyle(u.nodes.handle).width;var t=u.sizes.width;u.sizes.handleWidth=parseInt(e);u.sizes.width=u.nodes.slider.offsetWidth;if(u.sizes.width!==u.sizes.handleWidth){Y(t)}K()}function V(e){var t=e.target.id;var r=d+u.sizes.handleWidth/2;var i=Math.max(e.clientX-r,0);var a=u.sizes.width-u.sizes.handleWidth;var n=Math.min(i,a);if(t===u.nodes.slider.id){u.nodes.handle.style.left=n+"px";u.drag.handleOffsetLeft=u.nodes.handle.offsetLeft;u.drag.isResize=false}else if(t===u.nodes.handle.id){u.drag.handleClickOffsetX=e.offsetX;u.drag.isResize=false}else if(t===u.nodes.leftResizeHandle.id){u.drag.whichResizeHandle=u.consts.LEFT_HANDLE_ID;u.drag.isResize=true}else if(t===u.nodes.rightResizeHandle.id){u.drag.whichResizeHandle=u.consts.RIGHT_HANDLE_ID;u.drag.isResize=true}else{return}window.addEventListener("mousemove",G);window.addEventListener("mouseup",$)}function G(e){e.stopImmediatePropagation();var t;var r=e.clientX-d;if(u.drag.isResize){Q(e);return}var i=u.sizes.width-u.sizes.handleWidth+u.drag.handleClickOffsetX;t=Math.max(Math.min(r,i),u.drag.handleClickOffsetX);u.nodes.handle.style.left=t-u.drag.handleClickOffsetX+"px"}function j(e){var t=0;var r=37;var i=39;var a=5;if(e.keyCode!=r&&e.keyCode!=i){return}else if(e.keyCode==r){t=-a}else if(e.keyCode==i){t=a}var n=Math.min(u.drag.handleOffsetLeft+t,u.sizes.width-u.sizes.handleWidth);u.drag.handleOffsetLeft=Math.max(n,0);u.nodes.handle.style.left=u.drag.handleOffsetLeft+"px";Z();w()}function $(e){e.stopImmediatePropagation();window.removeEventListener("mousemove",G);window.removeEventListener("mouseup",$);K()}function K(){var e=window.getComputedStyle(u.nodes.handle).width;u.sizes.handleWidth=parseInt(e);u.drag.handleOffsetLeft=u.nodes.handle.offsetLeft;var t="(Double click to expand)";u.nodes.slider.setAttribute("title",t);Z();w()}function Q(e){e.stopImmediatePropagation();var t;var r;var i;var a;var n;var s;var o=e.clientX-d;var l=9;if(u.drag.whichResizeHandle===u.consts.RIGHT_HANDLE_ID){a=o-u.drag.handleOffsetLeft;t=Math.max(a,u.sizes.handleMinWidth);r=u.sizes.width-u.drag.handleOffsetLeft;i=Math.min(t,r);u.nodes.handle.style.width=i+"px"}if(u.drag.whichResizeHandle===u.consts.LEFT_HANDLE_ID){t=u.drag.handleOffsetLeft+u.sizes.handleWidth-u.sizes.handleMinWidth;o=Math.max(Math.min(o,t),0);r=u.drag.handleOffsetLeft+u.sizes.handleWidth;n=Math.min(o,u.sizes.width);s=Math.max(Math.max(n,-2*u.sizes.handleMinWidth),l);i=r-s+9;if(i<=l+u.sizes.handleMinWidth){i-=l;s+=l}u.nodes.handle.style.left=s-l+"px";u.nodes.handle.style.width=i+"px"}}function Y(e){var t=u.sizes.width-e;var r=u.sizes.width-u.drag.handleOffsetLeft;var i=u.sizes.handleWidth+t;u.sizes.handleWidth=Math.max(u.sizes.handleMinWidth,Math.min(i,r));u.nodes.handle.style.width=u.sizes.handleWidth+"px";if(u.sizes.width<u.drag.handleOffsetLeft+u.sizes.handleWidth){u.drag.handleOffsetLeft=u.sizes.width-u.sizes.handleWidth;u.nodes.handle.style.left=u.drag.handleOffsetLeft+"px"}}function Z(){if(!a.length){return}var e=u.drag.handleOffsetLeft/u.sizes.width*100;var t=e+u.sizes.handleWidth/u.sizes.width*100;var r=a[a.length-1].end/100;u.selectedInterval.start=(e*r).toFixed(0);u.selectedInterval.end=(t*r).toFixed(0)}return c});
//# sourceMappingURL=Performance.js.map