/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/support/Plugin","sap/ui/core/support/controls/TreeViewer","sap/ui/core/support/controls/ObjectViewer","sap/ui/Device","sap/base/Log","sap/ui/base/DataType","sap/ui/base/ManagedObject","sap/ui/thirdparty/jquery"],function(e,t,n,o,i,r,a,s,l){"use strict";var p=t.extend("sap.ui.core.support.plugins.ViewInfo",{metadata:{deprecated:true},constructor:function(e){t.apply(this,["sapUiSupportViewInfo","XML View and Templating Support Tools",e])}});p.prototype.init=function(e){t.prototype.init.apply(this,arguments);if(!this.runsAsToolPlugin()){return}if(!i.browser.chrome){this.$().get(0).innerHTML="View Info Support Tool is currently only available on Chrome. We are currently working to support all browsers.";return}try{this.supportInfo=window.opener.sap.ui.core.support.Support.info}catch(e){this.$().get(0).innerHTML="View Info Support Tool needs access to the opener window. The opener window might not be accessible due to cross domain restrictions.";return}if(typeof this.supportInfo!=="function"){this.$().get(0).innerHTML="<div class='sapUISupportLabel'>"+"View Info Support Tool is only available in <b>Support Mode.</b>"+"<br>Turn it on by adding '<b>sap-ui-support=true</b>' to the URL of your application."+"</div>";return}try{this.aViews=this.supportInfo.getAll("view");this.aOdataModels=this.supportInfo.getAll("datajs")}catch(e){this.$().get(0).innerHTML="View Info Support Tool raised an internal error while reading the support informations.";return}if(!this.aViews){this.$().get(0).innerHTML="View Info Support Tool did not record any information on the current page.<br>"+"Possible reasons:<br>"+"There are no XML Views defined in the current app.<br>"+"Views where not loaded before the Diagnostics tool was started."}if(this.runsAsToolPlugin()){d.call(this,e)}};function d(e){l(document).on("click",".viewxmlheader",l.proxy(this._onToggleViewInfo,this)).on("click",".viewxmlmain",l.proxy(this._onMainViewInfo,this));this.renderContentAreas()}p.prototype.exit=function(e){t.prototype.exit.apply(this,arguments);if(this.runsAsToolPlugin()){l(document).off("click",".viewxmlheader",l.proxy(this._onToggleViewInfo,this)).off("click",".viewxmlmain",l.proxy(this._onMainViewInfo,this))}};p.prototype.provideNodeInfo=function(e,t,n){if(e.env.type!=="template"){var o=this.getObjectInfo(t);var i=[];if(o){var r=this.getBreakpointInfos(o);if(r.Template){i.push(r.Template)}if(r.Attributes){i.push(r.Attributes)}if(r.Properties){i.push(r.Properties)}if(r.Methods){i.push(r.Methods)}}return i}};p.prototype.highlightTemplateTreeNode=function(e,t,n){e.clearHighlights();var o=this.getSupportInfos(t);for(var n=0;n<o.length;n++){if(o[n].context){e.expandNode(o[n].context);e.highlightNode(o[n].context)}}};p.prototype.createTree=function(e,t){var o=new n,i=this,r=e.context;o.viewDebugInfo=e;if(e.env.type==="template"){o.ignoreIds();r=e.env.clone}var a=r.querySelectorAll("*");for(var s=0;s<a.length;s++){var l=a[s],p=l.getAttribute("support:data"),d=this.supportInfo.getIds(p);if(d.length>0){if(!l.getAttribute("id")){l.setAttribute("id","")}l.setAttribute("__id",d[0])}else{l.setAttribute("__id",l.getAttribute("id"))}}o.setRootObject(r);o.attachSelectionChange(function(t){return function(n,o){if(e){if(e.env.type!=="template"){i.updateObjectInfo(n,t,o);if(e.env.templateTree){i.highlightTemplateTreeNode(e.env.templateTree,n,t)}}}}}(t));o.attachAttributeInfos(function(t,n){if(e){if(e.env.type!=="template"){if(n.name.indexOf("support:")>-1){return{visible:false}}if(n.name.indexOf("xmlns:support")>-1){return{visible:false}}}}});o.attachNodeInfos(function(t,n){return i.provideNodeInfo(e,t,n)});return o};p.prototype.renderContentAreas=function(){this._propertyChangeDebugger={};this._methodDebugger={};var e=sap.ui.getCore().createRenderManager();if(!this.aTrees){this.aTrees=[];this.aDataTrees=[];this.aObjectViewers=[];var t=0;e.openStart("div").class("viewxmlmain").openEnd();e.openStart("div").class("settingscontainer").openEnd();e.openStart("span").class("settings").attr("raise","_onClearAllBreakpoints").openEnd().text("Clear all breakpoints").close("span");e.openStart("span").class("settings").attr("raise","_onClearAllXMLModifications").openEnd().text("Clear all XML modifications").close("span");e.close("div");this.aMetamodels=[];if(this.aOdataModels){for(var n=0;n<this.aOdataModels.length;n++){var o=this.aOdataModels[n];if(o&&o.env.type==="metadata"){this.aMetamodels.push(o);var i=this.createTree(o,t);this.aTrees[t]=i;e.openStart("div").class("viewxmlheader").attr("collapsed","true").openEnd();e.openStart("span").class("toggle").openEnd().close("span");e.openStart("span").class("info").openEnd().text("Metadata: "+o.env.settings.response.requestUri).close("span");e.openStart("div").class("settingscontainer").openEnd();e.openStart("span").class("settings").class("sapUiSupportViewInfoElementHidden").attr("raise","_onToggleDebugNodes").attr("idx",t).openEnd().text("Expand debugged nodes").close("span");e.openStart("span").class("settings").class("sapUiSupportViewInfoElementHidden").attr("raise","_onToggleRealIds").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Show XML View Ids");e.close("span");e.openStart("span").class("settings").attr("raise","_onToggleNamespace").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Hide tag namespace");e.close("span");e.openStart("span").class("settings").attr("raise","_onToggleInactive").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Hide inactive");e.close("span");e.close("div");e.close("div");e.openStart("div").class("sapUiSupportViewInfoElementHidden").openEnd();e.openStart("div","treecontent_"+t).openEnd().close("div");e.openStart("div").class("viewxmlsplitter").openEnd().close("div");e.openStart("div").class("viewxmlinfo").openEnd();e.openStart("div","objectHeader"+t).class("title").class("sapUiSupportViewInfoElementHidden").openEnd().text("Header").close("div");e.openStart("div","objectToolbar"+t).class("toolbar").class("sapUiSupportViewInfoElementHidden").openEnd().text("Toolbar").close("div");e.openStart("div","selectedcontent_"+t).class("content").openEnd().close("div");e.close("div");e.close("div")}o.env.tree=i;t++}}if(this.aViews){for(var n=0;n<this.aViews.length;n++){var r=this.aViews[n];var i=this.createTree(r,t);this.aTrees[t]=i;this.aObjectViewers[t]=null;var a="";if(r.env.type=="template"){a=r.env.viewinfo.id}else{a=r.env.viewinfo.getId();for(var s=0;s<this.aTrees.length;s++){if(this.aTrees[s]&&this.aTrees[s].viewDebugInfo.env.type==="template"&&this.aTrees[s].viewDebugInfo.env.viewinfo.id===a){r.env.templateTree=this.aTrees[s]}}if(r.env.settings.preprocessors&&r.env.settings.preprocessors.xml&&r.env.settings.preprocessors.xml.models){var l=r.env.settings.preprocessors.xml.models;if(l){for(var p in l){if(l[p].oMetadata){var d=l[p].oMetadata.sUrl;for(var s=0;s<this.aMetamodels.length;s++){var c=this.aMetamodels[s];if(c&&c.env.settings.response.requestUri===d){if(!r.env.metamodels){r.env.metamodels=[]}r.env.metamodels.push({tree:c.env.tree,model:c,data:l[p],metamodel:l[p].oMetaModel,metadata:l[p].oMetadata})}}}}}}}if(r.env.type==="template"){e.openStart("div").class("viewxmlheader").attr("collapsed","true").openEnd();e.openstart("span").class("toggle").openEnd().close("span");e.openStart("span").class("info").openEnd().text(a+" ("+r.env.type+")").close("span");e.openStart("div").class("settingscontainer").openEnd();e.openStart("span").class("settings").attr("raise","_onToggleDebugNodes").attr("idx",t).openEnd().text("Expand debugged nodes").close("span");e.openStart("span").class("settings").class("sapUiSupportViewInfoElementHidden").attr("raise","_onToggleRealIds").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Show XML View Ids");e.close("span");e.openStart("span").class("settings").attr("raise","_onToggleNamespace").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Hide tag namespace");e.close("span");e.openStart("span").class("settings").attr("raise","_onToggleInactive").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Hide inactive");e.close("span");e.close("div");e.close("div")}else{var f="";if(r.env.metamodels){f=":templated by [";for(var g=0;g<r.env.metamodels.length;g++){f+=r.env.metamodels[g].metadata.sUrl}f+="]"}var u="";if(r.env.settings.cache){u+=" from client cache "+JSON.stringify(r.env.settings.cache)}e.openStart("div").class("viewxmlheader").attr("collapsed","true").openEnd();e.openStart("span").class("toggle").openEnd().close("span");e.openStart("span").class("info").openEnd().text(a+" ("+r.env.type+f+") "+u).close("span");e.openStart("div").class("settingscontainer").openEnd();e.openStart("span").class("settings").attr("raise","_onToggleDebugNodes").attr("idx",t).openEnd().text("Expand debugged nodes").close("span");e.openStart("span").class("settings").attr("raise","_onToggleRealIds").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Show XML View Ids");e.close("span");e.openStart("span").class("settings").attr("raise","_onToggleNamespace").attr("idx",t).openEnd();e.openStart("span").attr("selected","false").openEnd().close("span");e.text("Hide tag namespace");e.close("span");e.close("div");e.close("div")}e.openStart("div").class("sapUiSupportViewInfoElementHidden").openEnd();e.openStart("div","treecontent_"+t).openEnd().close("div");e.openStart("div").class("viewxmlsplitter").openEnd().close("div");e.openStart("div").class("viewxmlinfo").openEnd();e.openStart("div","objectHeader"+t).class("title").class("sapUiSupportViewInfoElementHidden").openEnd().text("Header").close("div");e.openStart("div","objectToolbar"+t).class("toolbar").class("sapUiSupportViewInfoElementHidden").openEnd().text("Toolbar").close("div");e.openStart("div","selectedcontent_"+t).class("content").openEnd().close("div");e.close("div");e.close("div");e.close("div");t++}}}e.flush(this.$().get(0));if(this.aTrees){for(var t=0;t<this.aTrees.length;t++){var i=this.aTrees[t];var h=document.getElementById("treecontent_"+t);if(h){i.update(h)}}}e.destroy()};p.prototype._onClearAllBreakpoints=function(){this.supportInfo.removeAllBreakpoints()};p.prototype._onClearAllXMLModifications=function(){this.supportInfo.removeAllXMLModification()};p.prototype.getBreakpointInfos=function(e){var t={},n;function o(e){var t=0;for(var n in e){if(e[n].__enabled){t++}}return t}if(e.Template){n=o(e.Template);t["Template"]={selected:n>0,color:"orange",tooltip:"Template Breakpoints ("+n+")"}}if(e.Attributes){n=o(e.Attributes);t["Attributes"]={selected:n>0,color:"blue",tooltip:"Attribute Changes ("+n+")"}}if(e.Properties){n=o(e.Properties);t["Properties"]={selected:n>0,color:"green",tooltip:"Property Change Breakpoints ("+n+")"}}if(e.Methods){n=o(e.Methods);t["Methods"]={selected:n>0,color:"red",tooltip:"Method Breakpoints ("+n+")"}}return t};p.prototype.getSupportInfos=function(e){var t=e.getAttribute("support:data");return this.supportInfo.getInfos(t)};p.prototype.parseScalarType=function(e,t,n,o){try{var i=s.bindingParser(t,o,true);if(i&&typeof i==="object"){return{binding:i}}}catch(e){return{error:"Property "+n+" - Invalid Binding:"+e.message}}var r=t=typeof i==="string"?i:t;var l=a.getType(e);if(l){if(l instanceof a){r=l.parseValue(t)}}else{return{error:"Property "+n+" has unknown type "+e}}if(!l.isValid(r)){return{error:"Property "+n+" has invalid value;"}}return{value:r}};p.prototype.getObjectInfo=function(e,t){var n=this;function o(e,t,o){return function(i){var r=n.parseScalarType(e.type,i,e.name,null);for(var a=0;a<t.length;a++){t[a].isBound(e.name);if(e.bindable){t[a][e._sUnbind](r.binding)}else{t[a].unbindProperty(e.name)}if(r.binding){if(e.bindable){t[a][e._sBind](r.binding)}else{t[a].bindProperty(e.name,r.binding)}}else if(r.value!==undefined){t[a][e._sMutator](r.value)}}o.setAttribute("__changed"+e.name,i);return r}}function i(e,o,i){return function(i){var r=n.parseScalarType(e.type,i,e.name,null);for(var a=0;a<g.length;a++){g[a].isBound(e.name);if(e.bindable){g[a][e._sUnbind](r.binding)}else{g[a].unbindProperty(e.name)}if(r.binding){if(e.bindable){g[a][e._sBind](r.binding)}else{g[a].bindProperty(e.name,r.binding)}}else if(r.value!==undefined){g[a][e._sMutator](r.value)}}if(!r.error){o.getAttribute("_index");var s=o.parentNode,l=null;while(s){l=s;s=s.parentNode}if(l){var p=l.querySelectorAll("*");for(var a=0;a<p.length;a++){if(p[a]===o){n.supportInfo.addXMLModification(t,a+1,{setAttribute:[e.name,i]});return}}}}return r}}var r=e.namespaceURI,a=e.localName,s={};var l=window.opener.jQuery.sap.getObject(r+"."+a);if(l){var d=e.getAttribute("support:data");var c=l.getMetadata().getAllProperties(),f=l.prototype,g=this.supportInfo.getElements(d),u=this.getValidDebugStackIndices(e);if(g.length>0){s.Control={};s.Control[g[0].getMetadata().getName()]={value:g[0].getId(),__highlightid:true,__readonly:true};if(g.length>1){s.Clones={};for(var h=1;h<g.length;h++){s.Clones[g[h].getMetadata().getName()+"("+h+")"]={value:g[h].getId(),__highlightid:true}}}}if(u.length>0){s.Template={};for(var h=0;h<u.length;h++){var v=u[h];s.Template[v.__infokey]={value:v.__infovalue,__idx:u[h]._idx,__enabled:this.supportInfo.hasBreakpointAt(u[h]._idx),__level:v.__level}}}var _=Object.keys(c).sort();if(e.attributes.length>0){s.Attributes={};for(var h=0;h<e.attributes.length;h++){var b=e.attributes[h];if(_.indexOf(b.name)>-1){var m=c[_[_.indexOf(b.name)]];s.Attributes[b.name]={value:b.value,__enabled:false,__docu:p.DemokitUrl+m._oParent.getName()+"#"+m._sGetter,__original:b.value,__change:i(m,e,t),__add:true}}}}if(_.length>0){s.Properties={};for(var h=0;h<_.length;h++){var m=c[_[h]];var y={value:e.getAttribute("__changed"+m.name)||e.getAttribute(_[h]),value2:g[0]&&g[0][m._sGetter]?g[0]&&g[0][m._sGetter]():null,__controls:g,__enabled:g[0]&&this._propertyChangeDebugger[g[0].getId()+"__"+_[h]]!=null,__docu:p.DemokitUrl+m._oParent.getName()+"#"+m._sGetter,__original:e.getAttribute(_[h]),__changed:null};y.__change=o(m,g,e);s.Properties[_[h]]=y}}var I=Object.keys(f).sort();if(I.length>0){s.Methods={};for(var h=0;h<I.length;h++){s.Methods[I[h]]={value:"",__controls:g,__enabled:g[0]&&this._methodDebugger[g[0].getId()+"__"+I[h]]!=null}}}}return s};p.prototype._makePropFn=function(e){return function(t){if(t.getParameter("name")===e){debugger}}};p.prototype._makeFn=function(e){return function(){debugger;return e.apply(this,arguments)}};p.prototype.highlightControl=function(e,t,n){try{if(this._highlightControl){this._highlightControl.control.getDomRef().style.outline=this._highlightControl.outline}if(this._highlightControls){for(var o=0;o<this._highlightControls.length;o++){this._highlightControls[o].control.getDomRef().style.outline=this._highlightControls[o].outline}}this._highlightControl=null;this._highlightControls=[];if(e.Control&&e.Control[Object.keys(e.Control)[0]].__highlightid){if(t==="Control"&&e.Clones){for(var i in e.Clones){var a=opener.Element.getElementById(e.Clones[i].value);if(a&&a.getDomRef()){this._highlightControls.push({control:a,outline:a.getDomRef().style.outline});a.getDomRef().style.outline="solid 1px orange"}}}else{if(!n){n=e.Control[Object.keys(e.Control)[0]]}if(t==="Control"&&n){var s=opener.Element.getElementById(n.value);if(s&&s.getDomRef()){this._highlightControl={control:s,outline:s.getDomRef().style.outline};if(s.getDomRef()){s.getDomRef().style.outline="solid 1px orange"}}}}if(t==="Clones"){var s=opener.Element.getElementById(n.value);if(s&&s.getDomRef()){this._highlightControl={control:s,outline:s.getDomRef().style.outline};if(s.getDomRef()){s.getDomRef().style.outline="solid 1px orange"}}}}}catch(e){r.debug("Diagnostics: ViewInfo failed to remove highlighting of controls")}};p.DemokitUrl="https://sdk.openui5.org/api/";p.prototype.updateObjectInfo=function(e,t,n){var i=this.aObjectViewers[t],r=this;if(!i){i=new o;this.aObjectViewers[t]=i}var a=document.getElementById("objectHeader"+t);a.style.display="none";var s=this.aTrees[t];i.initialExpandedSections=this.oObjectViewer?this.oObjectViewer.expandedSections:[];var l=this.getObjectInfo(e,s.viewDebugInfo.env.viewinfo.getId());var d="";try{if(!l.Control&&e.parentNode){var c=e.parentNode.namespaceURI+"."+e.parentNode.localName;var f="get"+e.localName.substring(0,1).toUpperCase()+e.localName.substring(1);d+='<a target="_docu" href="'+p.DemokitUrl+c+'">'+c+"</a> ("+e.tagName+") ";d+=': <a target="_docu" href="'+p.DemokitUrl+c+"#"+f+'">'+e.localName+" aggregation</a>"}else{var c=e.namespaceURI+"."+e.localName;d+='<a target="_docu" href="'+p.DemokitUrl+c+'">'+c+"</a> ("+e.tagName+") ";var g=window.opener.jQuery.sap.getObject(Object.keys(l.Control)[0]).getMetadata().getParent().getName();d+=': <a target="_docu" href="'+p.DemokitUrl+g+'">'+g+"</a>"}}catch(e){d+=""}a.style.display="block";a.innerHTML=d;r.highlightControl(l,"Control");i.setRootObject(l);i.attachObjectInfos(function(e,t,n,o){if(t==="Template"){if(l[t][o].__enabled){return[{selected:true,color:"orange",tooltip:"Disable breakpoint"}]}else{return[{selected:false,color:"orange",tooltip:"Break if resolved after reload/reprocess"}]}}else if(t==="Attributes"){if(l[t][o].__enabled){return[{selected:true,color:"blue",tooltip:"Disable breakpoint"}]}else{return[{selected:false,color:"blue",tooltip:"Break if changed"}]}}else if(t==="Properties"){if(l[t][o].__enabled){return[{selected:true,color:"green",tooltip:"Disable breakpoint"}]}else{return[{selected:false,color:"green",tooltip:"Break if changed"}]}}else if(t==="Methods"){if(l[t][o].__enabled){return[{selected:true,color:"red",tooltip:"Disable breakpoint"}]}else{return[{selected:false,color:"red",tooltip:"Break if called"}]}}return[]});i.attachSelect(function(e){if(e&&e.__docu){window.open(e.__docu,"_docu")}});i.attachHover(function(e,t,n){r.highlightControl(l,t,e)});i.attachInfoPress(function(e,t,n){var o=l[e][t].__idx,a=l[e][t].__enabled;if(!a){if(e==="Template"){r.supportInfo.addBreakpointAt(o)}else if(e==="Properties"){var p=l[e][t].__controls;if(p){for(var d=0;d<p.length;d++){var c=p[d];r._propertyChangeDebugger[c.getId()+"__"+t]=r.supportInfo._breakAtProperty(t);c.attachEvent("_change",r._propertyChangeDebugger[c.getId()+"__"+t])}}}else if(e==="Methods"){var p=l[e][t].__controls;if(p){for(var d=0;d<p.length;d++){var c=p[d];var f=c[t];r._methodDebugger[c.getId()+"__"+t+"__fn"]=f;r._methodDebugger[c.getId()+"__"+t]=r.supportInfo._breakAtMethod(f);c[t]=r._methodDebugger[c.getId()+"__"+t]}}}l[e][t].__enabled=true;i.setInfoSelected(e,t,n,true)}else{if(e==="Template"){r.supportInfo.removeBreakpointAt(o)}else if(e==="Properties"){var p=l[e][t].__controls;if(p){for(var d=0;d<p.length;d++){var c=p[d];c.detachEvent("_change",r._propertyChangeDebugger[c.getId()+"__"+t]);delete r._propertyChangeDebugger[c.getId()+"__"+t]}}}else if(e==="Methods"){var p=l[e][t].__controls;if(p){for(var d=0;d<p.length;d++){var c=p[d];c[t]=r._methodDebugger[c.getId()+"__"+t+"__fn"];delete r._methodDebugger[c.getId()+"__"+t];delete r._methodDebugger[c.getId()+"__"+t+"__fn"]}}}l[e][t].__enabled=false;i.setInfoSelected(e,t,n,false)}if(l){var g=r.getBreakpointInfos(l);var d=0;if(g.Template){s.setInfoSelected(s.getSelectedIndex(),d++,g.Template.selected,g.Template.tooltip)}if(g.Attributes){s.setInfoSelected(s.getSelectedIndex(),d++,g.Attributes.selected,g.Attributes.tooltip)}if(g.Properties){s.setInfoSelected(s.getSelectedIndex(),d++,g.Properties.selected,g.Properties.tooltip)}if(g.Methods){s.setInfoSelected(s.getSelectedIndex(),d,g.Methods.selected,g.Methods.tooltip)}}});var u=document.getElementById("selectedcontent_"+t);if(u){i.update(u)}this.oObjectViewer=i};p.prototype._onToggleRealIds=function(e){var t=e.target;if(t.getAttribute("selected")){t=t.parentNode}var n=parseInt(t.getAttribute("idx")),o=this.aTrees[n];if(o.toggleIds()){t.innerHTML='<span selected="false"></span>Show XML View Ids'}else{t.innerHTML='<span selected="true"></span>Show Real Ids'}};p.prototype._onToggleInactive=function(e){var t=e.target;if(t.getAttribute("selected")){t=t.parentNode}var n=parseInt(t.getAttribute("idx")),o=this.aTrees[n];if(o.toggleInactive()){t.innerHTML='<span selected="false"></span>Hide inactive'}else{t.innerHTML='<span selected="true"></span>Show inactive'}e.stopPropagation()};p.prototype._onToggleNamespace=function(e){var t=e.target;if(t.getAttribute("selected")){t=t.parentNode}var n=parseInt(t.getAttribute("idx")),o=this.aTrees[n];if(o.toggleNS()){t.innerHTML='<span selected="false"></span>Hide tag namespace'}else{t.innerHTML='<span selected="true"></span>Show tag namespace'}e.stopPropagation()};p.prototype._onToggleDebugNodes=function(e){var t=parseInt(e.target.getAttribute("idx")),n=this.aTrees[t];n.expandNodesWithSelectedInfo(0);n.expandNodesWithSelectedInfo(1);n.expandNodesWithSelectedInfo(2)};p.prototype.resizeHandler=function(){var e=document.querySelectorAll(".viewxmlheader");for(var t=0;t<e.length;t++){var n=e[t];var o=n.getAttribute("collapsed")==="true";if(!o){var i=n.offsetWidth-30;var r=n.nextSibling.firstChild.offsetHeight;n._iOldWidth=i;n._iOldHeight=r;n.nextSibling.firstChild.style.width=i/3*2+"px";n.nextSibling.lastChild.style.width=i/3+"px";n.nextSibling.lastChild.style.height=r+"px";n.nextSibling.lastChild.style.marginTop=-r+"px";n.nextSibling.lastChild.style.marginLeft=i/3*2+20+"px";n.nextSibling.lastChild.lastChild.height=r-50+"px";n.nextSibling.lastChild.lastChild.width="100%"}}if(!this.iInterval){var a=this;this.iInterval=window.setInterval(function(){var e=document.querySelectorAll(".viewxmlheader");var t=e[0];for(var n=0;n<e.length;n++){var t=e[n];var o=t.getAttribute("collapsed")==="true";if(!o){if(t._iOldWidth!==t.offsetWidth-30||t._iOldHeight!==t.nextSibling.firstChild.offsetHeight){a.resizeHandler()}}}},100)}};p.prototype._onMainViewInfo=function(e){var t=e.target,n=t.getAttribute("raise");if(n&&this[n]){this[n](e);e.stopPropagation();return}};p.prototype._onToggleViewInfo=function(e){var t=e.target,n=t.getAttribute("raise");if(n&&this[n]){this[n](e);e.stopPropagation();return}n=t.parentNode.getAttribute("raise");if(n&&this[n]){this[n](e);e.stopPropagation();return}if(!t.getAttribute("collapsed")){t=t.parentNode}var o=t.getAttribute("collapsed")==="true";if(o){t.setAttribute("collapsed","false");t.nextSibling.style.display="block";this.resizeHandler()}else{t.setAttribute("collapsed","true");t.nextSibling.style.display="none"}};p.prototype.getValidDebugStackIndices=function(e){var t=[],n=e.getAttribute("support:data"),o=["xmlns","support:data"];if(n){var i=n.split(","),r=this.supportInfo,a=0;for(var s=0;s<i.length;s++){var l=parseInt(i[s]);var p=r.byIndex(l);if(!p){continue}p.__debugging=r.hasBreakpointAt(l);if(p.env){if(p.env.caller==="visitAttributes"){for(var d in p.env){if(d==="caller"||d==="info"){continue}var c=true;for(var f=0;f<o.length;f++){if(p.env[d].name.indexOf(o[f])===0){c=false;break}}if(c){if(d.indexOf("after")===0){a--}p.__infokey=d+":"+p.env[d].name;p.__level=a;p.__infovalue=p.env[d].value;if(d.indexOf("before")===0){a++}t.push(p)}}}else if(p.env.caller==="getMetadata"){for(var d in p.env){if(d==="caller"||d==="info"){continue}var c=true;for(var f=0;f<o.length;f++){if(p.env[d].name.indexOf(o[f])===0){c=false;break}}if(c){if(d.indexOf("after")===0){a--}p.__infokey=d+":"+p.env[d].name;p.__level=a;p.__infovalue=p.env[d].value;t.push(p);if(d.indexOf("before")===0){a++}}}}else if(p.env.caller==="getProperty"){for(var d in p.env){if(d==="caller"||d==="info"){continue}var c=true;for(var f=0;f<o.length;f++){if(p.env[d].name.indexOf(o[f])===0){c=false;break}}if(c){if(d.indexOf("after")===0){a--}p.__infokey=d+":"+p.env[d].name;p.__level=a;p.__infovalue=p.env[d].value;t.push(p);if(d.indexOf("before")===0){a++}}}}else if(p.env.caller==="visitNode"){for(var d in p.env){if(d.indexOf("after")===0){a--}p.__infokey=d+":Node";p.__infovalue=p.env[d].name;t.push(p);if(d.indexOf("before")===0){a++}}}}}}return t};return p});
//# sourceMappingURL=ViewInfo.js.map