/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/base/EventProvider","./ReadyState","sap/ui/thirdparty/URI","sap/base/Log"],function(t,e,o,n,s){"use strict";var r=e.extend("sap.ui.core.ws.WebSocket",{constructor:function(o,n){e.apply(this);if(!t.support.websocket){throw new Error("Browser does not support WebSockets.")}if(typeof o!=="string"){throw new Error("sUrl must be a string.")}if(typeof n!=="undefined"&&!Array.isArray(n)&&typeof n!=="string"){throw new Error("aProtocols must be a string, array of strings or undefined.")}this._openConnection(o,n)},metadata:{publicMethods:["send","close","getReadyState","getProtocol"]}});r.prototype.getInterface=function(){return this};r.M_EVENTS={Open:"open",Close:"close",Error:"error",Message:"message"};r.prototype.attachOpen=function(t,e,o){this.attachEvent("open",t,e,o);return this};r.prototype.detachOpen=function(t,e){this.detachEvent("open",t,e);return this};r.prototype.fireOpen=function(t){this.fireEvent("open",t);return this};r.prototype.attachClose=function(t,e,o){this.attachEvent("close",t,e,o);return this};r.prototype.detachClose=function(t,e){this.detachEvent("close",t,e);return this};r.prototype.fireClose=function(t){this.fireEvent("close",t);return this};r.prototype.attachError=function(t,e,o){this.attachEvent("error",t,e,o);return this};r.prototype.detachError=function(t,e){this.detachEvent("error",t,e);return this};r.prototype.fireError=function(t){this.fireEvent("error",t);return this};r.prototype.attachMessage=function(t,e,o){this.attachEvent("message",t,e,o);return this};r.prototype.detachMessage=function(t,e){this.detachEvent("message",t,e);return this};r.prototype.fireMessage=function(t){this.fireEvent("message",t);return this};r.prototype._resolveFullUrl=function(t){var e=new n(t);var o=new n(document.baseURI);o.search("");o.protocol(o.protocol()==="https"?"wss":"ws");e=e.absoluteTo(o);return e.toString()};r.prototype._openConnection=function(t,e){t=this._resolveFullUrl(t);this._oWs=typeof e==="undefined"?new window.WebSocket(t):new window.WebSocket(t,e);this._oWs.onopen=this._onopen.bind(this);this._oWs.onclose=this._onclose.bind(this);this._oWs.onmessage=this._onmessage.bind(this);this._oWs.onerror=this._onerror.bind(this)};r.prototype._onopen=function(){this.fireOpen()};r.prototype._onclose=function(t){this.fireClose({code:t.code,reason:t.reason,wasClean:t.wasClean})};r.prototype._onerror=function(t){this.fireError()};r.prototype._onmessage=function(t){this.fireMessage({data:t.data})};r.prototype.send=function(t){if(this.getReadyState()===o.OPEN){this._oWs.send(t)}else if(this.getReadyState()===o.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.send(t)})}else{s.warning("Unable to send WebSocket message. "+"Connection is already closed or closing. message: "+t)}return this};r.prototype.close=function(t,e){if(typeof t==="string"){e=t;t=undefined}t=typeof t==="undefined"?1e3:t;e=typeof e==="undefined"?"":e;if(this.getReadyState()===o.OPEN){this._oWs.close(t,e)}else if(this.getReadyState()===o.CONNECTING){this.attachEventOnce("open",function(o){this._oWs.close(t,e)})}else{var n="";switch(this.getReadyState()){case o.CLOSED:n="Connection is already closed.";break;case o.CLOSING:n="Connection is already closing.";break}s.warning("Unable to close WebSocket connection. "+n)}return this};r.prototype.getReadyState=function(){return this._oWs.readyState};r.prototype.getProtocol=function(){return this._oWs.protocol};return r});
//# sourceMappingURL=WebSocket.js.map