//@ui5-bundle sap/ui/documentation/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/BorrowedList", ["sap/ui/core/Control"],function(t){"use strict";return t.extend("sap.ui.documentation.BorrowedList",{metadata:{library:"sap.ui.documentation",properties:{list:{type:"array"}}},renderer:{apiVersion:2,render:function(t,e){var a=e.getList(),n,r,i;t.openStart("div",e);t.openEnd();for(i=0,r=a.length;i<r;i++){n=a[i];t.openStart("a");t.attr("href",n.link).attr("role","link").attr("tabindex","0").class("sapMLnk").class("sapMLnkMaxWidth").class("sapUiTinyMargin").openEnd().text(n.name).close("a")}t.close("div")}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/DemokitTreeItem", ["sap/m/TreeItemBase","./DemokitTreeItemRenderer"],function(e,t){"use strict";return e.extend("sap.ui.documentation.DemokitTreeItem",{metadata:{library:"sap.ui.documentation",properties:{title:{type:"string",defaultValue:""},deprecated:{type:"boolean",defaultValue:false},target:{type:"string",defaultValue:""},encodeTarget:{type:"boolean",defaultValue:false},section:{type:"string",defaultValue:"#"},entityType:{type:"string",defaultValue:""}}},renderer:t,setDeprecated:function(e){return this.setProperty("deprecated",!!e)},getHref:function(){return this.getSection()+"/"+(this.getEncodeTarget()?encodeURIComponent(this.getTarget()):this.getTarget())},_getPadding:e.prototype.getLevel})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/DemokitTreeItemRenderer", ["sap/m/TreeItemBaseRenderer","sap/ui/core/Core","sap/ui/core/Renderer"],function(e,t,n){"use strict";var r=n.extend(e);r.apiVersion=2;r.renderEntityType=function(e,t){var n=t.getEntityType(),r=n?n[0].toUpperCase():"";if(!n){return}e.openStart("span").class("sapUiDemoKitTreeItemIcon").class("sapUiDemoKitTreeItem"+r).openEnd().text(r).close("span")};r.renderTooltip=function(e,t){var n=t.getEntityType(),r=t.getTarget();if(n&&r){e.attr("title",n+" "+r)}};r.renderLIContent=function(e,n){var r;this.renderEntityType(e,n);e.openStart("a").attr("href",n.getHref()).openEnd();e.openStart("span").class("sapDemokitTreeItemTitle").class("sapUiTinyMarginEnd").openEnd().text(n.getTitle()).close("span");e.close("a");if(n.getDeprecated()){r=t.getLibraryResourceBundle("sap.ui.documentation");e.openStart("span").class("sapDemokitTreeItemLabel").openEnd().text(r.getText("API_MASTER_DEPRECATED")).close("span")}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/JSDocText", ["sap/ui/core/Control","sap/base/security/sanitizeHTML"],function(e,t){"use strict";return e.extend("sap.ui.documentation.JSDocText",{metadata:{library:"sap.ui.documentation",properties:{text:{type:"string",defaultValue:""},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:true}}},renderer:{apiVersion:2,render:function(e,n){var i=n.getText();if(n.getSanitizeContent()){i=t(i)}e.openStart("div",n);e.class("sapUiJSD");e.openEnd();e.unsafeHtml(i);e.close("div")}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/LightTable", ["sap/ui/core/Control"],function(e){"use strict";return e.extend("sap.ui.documentation.LightTable",{metadata:{library:"sap.ui.documentation",properties:{columnTitles:{type:"string[]"},columnCount:{type:"int"}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.documentation.Row",multiple:true}}},renderer:{apiVersion:2,render:function(e,t){var n=t.getRows(),o,i=t.getColumnTitles(),s,l,a,r;e.openStart("div",t);e.class("sapUiDocLightTable");e.class("columns-"+t.getColumnCount());e.openEnd();e.openStart("div").class("head").openEnd();for(r=0,a=i.length;r<a;r++){e.openStart("div").class("cell").openEnd();e.text(i[r]).close("div")}e.close("div");for(r=0,a=n.length;r<a;r++){e.openStart("div").class("row").openEnd();o=n[r].getContent();for(l=0,s=o.length;l<s;l++){e.openStart("div").class("cell").openEnd();if(l>0){e.openStart("div").class("inTitle").openEnd().text(i[l]+":").close("div")}e.renderControl(o[l]);e.close("div")}e.close("div")}e.close("div")}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/ObjectPageSubSection", ["sap/ui/core/Control","sap/uxap/ObjectPageSubSection"],function(e,t){"use strict";var n=t.extend("sap.ui.documentation.ObjectPageSubSection",{metadata:{library:"sap.ui.documentation"},renderer:"sap.uxap.ObjectPageSubSectionRenderer"});var r=e.extend("sap.ui.documentation.Container",{metadata:{library:"sap.ui.documentation",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},renderer:{apiVersion:2,render:function(e,t){var n=t.getContent(),r,i;e.openStart("div",t).openEnd();for(i=0,r=n.length;i<r;i++){e.renderControl(n[i])}e.close("div")}}});n.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new r({id:this.getId()+"-innerGrid"}),true)}return this.getAggregation("_grid")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/ParamText", ["sap/ui/core/Control","sap/ui/Device"],function(e,t){"use strict";var a=e.extend("sap.ui.documentation.ParamText",{metadata:{library:"sap.ui.documentation",properties:{text:{type:"string",defaultValue:""},phoneText:{type:"string",defaultValue:""},depth:{type:"int",defaultValue:0},optional:{type:"boolean",defaultValue:false},defaultFlag:{type:"boolean",defaultValue:false},deprecated:{type:"boolean",defaultValue:false},experimental:{type:"boolean",defaultValue:false},href:{type:"sap.ui.core.URI"}},events:{press:{}}},_getText:function(){var e=this.getPhoneText();return t.system.phone&&e?e:this.getText()},renderer:{apiVersion:2,render:function(e,t){var a=t.getHref();if(a){e.openStart("a",t).attr("href",a).class("sapMLnk")}else{e.openStart("div",t)}e.class("depth-"+t.getDepth()).class("sapUiParamText").openEnd();e.text(t._getText());if(t.getOptional()){e.text("?")}if(t.getDefaultFlag()){e.openStart("span").class("parameterDefault").openEnd().text("(default)").close("span")}if(a){e.close("a").openStart("div").class("sapUiParamText").openEnd()}if(t.getDeprecated()){e.openStart("div").class("deprecated").openEnd();e.icon("sap-icon://message-error");e.openStart("span").class("deprecatedText").openEnd().text("Deprecated").close("span");e.close("div")}if(t.getExperimental()){e.openStart("div").class("experimental").openEnd();e.icon("sap-icon://message-warning");e.openStart("span").class("experimentalText").openEnd().text("Experimental").close("span");e.close("div")}e.close("div")}}});a.prototype._handlePress=function(e){this.firePress({})};if(t.support.touch){a.prototype.ontap=a.prototype._handlePress}else{a.prototype.onclick=a.prototype._handlePress}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/Row", ["sap/ui/core/Element"],function(e){"use strict";return e.extend("sap.ui.documentation.Row",{metadata:{library:"sap.ui.documentation",properties:{visible:{type:"boolean"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/Search", ["sap/ui/core/Core","sap/ui/core/Control","sap/ui/Device","sap/ui/thirdparty/jquery","sap/m/library","sap/m/Button","sap/m/SearchField"],function(e,t,i,jQuery,n,a,r){"use strict";var s=t.extend("sap.ui.documentation.Search",{metadata:{library:"sap.ui.documentation",properties:{isOpen:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}},aggregations:{_openingButton:{type:"sap.m.Button",multiple:false},_closingButton:{type:"sap.m.Button",multiple:false},_searchField:{type:"sap.m.SearchField",multiple:false},suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,singularName:"suggestionItem",forwarding:{getter:"_lazyLoadSearchField",aggregation:"suggestionItems"}}},events:{toggle:{parameters:{isOpen:{type:"boolean"}}},search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,t){var i=t.getWidth(),n,a,r;e.openStart("div",t);e.style("width",i);e.class("sapUiDocumentationSearch");e.openEnd();if(t.getIsOpen()){r=t._lazyLoadSearchField(true);a=t._lazyLoadClosingButton(true);e.renderControl(r);e.renderControl(a)}else{n=t._lazyLoadOpeningButton(true);e.renderControl(n)}e.close("div")}}});s.prototype.onAfterRendering=function(){if(this.getIsOpen()){this._maximizeSearchField()}};s.prototype.onsapescape=function(e){var t=jQuery(window).width(),n=t>=i.media._predefinedRangeSets[i.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];if(this.getIsOpen()&&!n){this._toggleOpen(false)}};s.prototype.getValue=function(){return this._lazyLoadSearchField().getValue()};s.prototype.setValue=function(e){this._lazyLoadSearchField().setValue(e);return this};s.prototype._maximizeSearchField=function(){return this._resizeSearchField("100%")};s.prototype._minimizeSearchField=function(){return this._resizeSearchField("10%")};s.prototype.suggest=function(){this._lazyLoadSearchField().suggest()};s.prototype.attachSuggest=function(){r.prototype.attachSuggest.apply(this._lazyLoadSearchField(),arguments);return this};s.prototype._resizeSearchField=function(e){return new Promise(function(t,i){var n=this.$("searchField");if(!n.length){i()}if(n.css("max-width")===e){t()}n.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend",function(){t()});n.css("max-width",e)}.bind(this))};s.prototype._toggleOpen=function(e){this.setIsOpen(e);this.fireToggle({isOpen:e})};s.prototype._lazyLoadOpeningButton=function(e){if(!this.getAggregation("_openingButton")){var t=new a(this.getId()+"-openingBtn",{icon:"sap-icon://search",type:n.ButtonType.Default,press:function(){this._toggleOpen(true)}.bind(this)}).addStyleClass("sapUiDemokitSearchOpeningButton sapMBarChild");this.setAggregation("_openingButton",t,e)}return this.getAggregation("_openingButton")};s.prototype._lazyLoadClosingButton=function(t){if(!this.getAggregation("_closingButton")){var i=new a(this.getId()+"-closingBtn",{text:e.getLibraryResourceBundle("sap.ui.documentation").getText("APP_SEARCH_FIELD_CLOSE"),type:n.ButtonType.Default,press:function(){this._minimizeSearchField().then(function(){this._toggleOpen(false);this.setValue("")}.bind(this))}.bind(this)}).addStyleClass("sapMBarChild");this.setAggregation("_closingButton",i,t)}return this.getAggregation("_closingButton")};s.prototype._lazyLoadSearchField=function(t){if(!this.getAggregation("_searchField")){var i=new r(this.getId()+"-searchField",{placeholder:e.getLibraryResourceBundle("sap.ui.documentation").getText("APP_HEADER_SEARCH_FIELD_PLACEHOLDER"),showSearchButton:true,search:function(e){var t=e.getParameters();t.id=this.getId();this.fireSearch(t)}.bind(this),liveChange:function(e){var t=e.getParameters();t.id=this.getId();this.fireLiveChange(t)}.bind(this)});i.addStyleClass("sdkHeaderSearchField");this.setAggregation("_searchField",i,t)}return this.getAggregation("_searchField")};s.prototype._updateValue=function(e){this._lazyLoadSearchField()._updateValue(e)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/TitleLink", ["sap/ui/core/library","sap/ui/core/Renderer","sap/ui/util/defaultLinkTypes","sap/ui/Device","sap/m/Title"],function(e,t,r,a,i){"use strict";var s=e.TitleLevel;var l=i.extend("sap.ui.documentation.TitleLink",{metadata:{library:"sap.ui.documentation",properties:{target:{type:"string",group:"Behavior",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},filter:{type:"string",group:"Data",defaultValue:""},wrap:{type:"boolean",group:"Behavior",defaultValue:true},rel:{type:"string",group:"Behavior",defaultValue:null}},events:{press:{allowPreventDefault:true}}},init:function(){if(a.support.touch){this.ontap=this._handlePress}else{this.onclick=this._handlePress}this.ontouchstart=function(e){if(this.getHref()){e.setMarked()}}},onsapspace:function(e){this._handlePress(e);if(this.getHref()&&!e.isDefaultPrevented()){e.preventDefault();e.setMarked();var t=document.createEvent("MouseEvents");t.initEvent("click",false,true);this.getDomRef().dispatchEvent(t)}},_handlePress:function(e){e.setMarked();if(!this.firePress()||!this.getHref()){e.preventDefault()}},setHref:function(e){this.setProperty("href",e,true);e=this.getProperty("href");this.$().attr("href",e);return this},setTarget:function(e){var t=r(this.getRel(),this.getTarget());this.setProperty("target",e,true);if(!e){this.$().removeAttr("target")}else{this.$().attr("target",e)}if(!t){this.$().removeAttr("rel")}else{this.$().attr("rel",t)}return this},renderer:{apiVersion:2,render:function(a,i){var l=i._getTitle(),n=(l?l.getLevel():i.getLevel())||e.TitleLevel.Auto,o=n==s.Auto,u=t.getTextAlign(i.getTextAlign()),p=o?"div":n;a.openStart(p.toLowerCase(),i).class("sapUiDocTitleLink").class("sapMTitle").class("sapMTitleStyle"+(i.getTitleStyle()||e.TitleLevel.Auto)).class("sapUiSelectable");if(i.getWrap()){a.class("wrap")}else{a.class("sapMTitleNoWrap")}var g=i.getWidth();if(!g){a.class("sapMTitleMaxWidth")}else{a.style("width",g)}if(u){a.style("text-align",u)}if(i.getParent().isA("sap.m.Toolbar")){a.class("sapMTitleTB")}var f=l?l.getTooltip_AsString():i.getTooltip_AsString();if(f){a.attr("title",f)}if(o){a.attr("role","heading")}a.openEnd();a.openStart("a").class("sapMLnk");if(i.getText()){a.attr("tabindex","0")}else{a.attr("tabindex","-1")}a.attr("href",i.getHref());if(i.getTarget()){a.attr("target",i.getTarget())}var h=r(i.getRel(),i.getTarget());if(h){a.attr("rel",h)}a.openEnd();a.openStart("span",i.getId()+"-inner").openEnd().text(l?l.getText():i.getText());a.close("span").close("a").close(p.toLowerCase())}}});return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/WebPageTitleUtil", ["sap/ui/core/Element"],function(t){"use strict";var e=t.extend("sap.ui.documentation.WebPageTitleUtil",{metadata:{properties:{title:{type:"string",defaultValue:""}}}});e.prototype.setTitle=function(t){if(t){document.title=t;this.setProperty("title",t,true)}return this};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/library", ["sap/base/Log","sap/ui/core/Core","sap/ui/thirdparty/jquery","sap/ui/core/util/LibraryInfo","sap/ui/documentation/sdk/util/Resources","sap/ui/core/library","sap/m/library"],function(e,i,jQuery,r,n){"use strict";var t=i.initLibrary({name:"sap.ui.documentation",version:"1.120.31",dependencies:["sap.ui.core","sap.m"],types:[],interfaces:[],controls:["sap.ui.documentation.BorrowedList","sap.ui.documentation.DemokitTreeItem","sap.ui.documentation.JSDocText","sap.ui.documentation.LightTable","sap.ui.documentation.ObjectPageSubSection","sap.ui.documentation.ParamText","sap.ui.documentation.Search","sap.ui.documentation.TitleLink"],elements:["sap.ui.documentation.Row","sap.ui.documentation.WebPageTitleUtil"]});var a;var o=r.extend("sap.ui.documentation.DocumentationLibraryInfo",{});if(n.getHasProxy()){o.prototype.getResourceUrl=function(e){return n.getResourceOriginPath(e)}}t._getLicense=function(){var e="./LICENSE.txt";return jQuery.ajax({url:e,dataType:"text"})};t._getAppInfo=function(i){var r=sap.ui.require.toUrl("sap-ui-version.json");r=n.getResourceOriginPath(r);jQuery.ajax({url:r,dataType:"json",error:function(n,t,a){e.error("failed to load library list from '"+r+"': "+t+", "+a);i(null)},success:function(n,t,a){if(!n){e.error("failed to load library list from '"+r+"': "+t+", Data: "+n);i(null);return}i(n)}})};t._getLibraryInfoSingleton=function(){if(!a){a=new o}return a};t._loadAllLibInfo=function(e,i,r,n){if(typeof r==="function"){n=r;r=undefined}var a=t._getLibraryInfoSingleton();var o=i=="_getLibraryInfoAndReleaseNotes";if(o){i="_getLibraryInfo"}t._getAppInfo(function(e){if(!(e&&e.libraries)){n(null,null);return}var t=0,u=e.libraries,s=u.length,l={},c={},f=[],p,d;for(var b=0;b<s;b++){p=u[b].name;d=u[b].version;f.push(p);c[p]=d;a[i](p,function(i){var u=function(){t++;if(t==s){n(f,l,e)}};l[i.library]=i;if(!l[i.library].version){l[i.library].version=c[i.library]}if(o){a._getReleaseNotes(i.library,r,function(e){l[i.library].relnotes=e;u()})}else{u()}})}})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/Component", ["sap/ui/thirdparty/jquery","sap/ui/core/UIComponent","sap/ui/Device","sap/ui/documentation/sdk/model/models","sap/ui/documentation/sdk/controller/ErrorHandler","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ConfigUtil","sap/ui/documentation/sdk/controller/util/URLUtil","sap/base/util/Version","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/util/DocumentationRouter","sap/m/ColumnListItem"],function(jQuery,e,t,i,s,o,n,r,a,l){"use strict";return e.extend("sap.ui.documentation.sdk.Component",{metadata:{manifest:"json",includes:["css/style.css"]},init:function(){this._oErrorHandler=new s(this);this.setModel(i.createDeviceModel(),"device");this.setModel(new o,"libsData");this.setModel(new o,"versionData");this.setModel(new o({includeDeprecated:false}),"searchData");e.prototype.init.apply(this,arguments);this.loadVersionInfo().then(this._bindVersionModel.bind(this));this.getRouter().initialize()},getCookiesManagement:function(){var e="sap.ui.documentation.sdk.cookieSettingsDialog";if(!this._pCookiesComponent){this._pCookiesComponent=this.createComponent({usage:"cookieSettingsDialog",id:"cookiesComp-"+e})}return this._pCookiesComponent},destroy:function(){this._oErrorHandler.destroy();this._oConfigUtil.destroy();this._oConfigUtil=null;this._pCookiesComponent&&this._pCookiesComponent.then(function(e){e.destroy()});e.prototype.destroy.apply(this,arguments)},getContentDensityClass:function(){if(!this._sContentDensityClass){if(!t.support.touch){this._sContentDensityClass="sapUiSizeCompact"}else{this._sContentDensityClass="sapUiSizeCozy"}}return this._sContentDensityClass},getConfigUtil:function(){if(!this._oConfigUtil){this._oConfigUtil=new n(this)}return this._oConfigUtil},loadVersionInfo:function(){return new Promise(function(e,t){jQuery.ajax({async:true,url:l.getResourceOriginPath("resources/sap-ui-version.json"),dataType:"json",success:function(t){e(t)},error:function(e){t(e)}})})},_bindVersionModel:function(e){var t,i,s,o,n,u=l.getResourcesVersion();this.aAllowedMembers=["public","protected"];if(!e){return}t=a(e.version);o=t.getSuffix();i=/-SNAPSHOT$/i.test(o);s=e.gav&&/openui5/i.test(e.gav);if(l.isInternal(e)){n=true;this.aAllowedMembers.push("restricted")}this.getModel("versionData").setData({enableAdvancedCookieSettings:false,versionGav:e.gav,versionName:e.name,version:[t.getMajor(),t.getMinor(),t.getPatch()].join("."),fullVersion:e.version,openUi5Version:u||e.version,isOpenUI5:s,isSnapshotVersion:i,isDevVersion:i,isBetaVersion:!s&&!i&&/-beta$/i.test(o),isURLVersioned:!!r.parseVersion(document.location.href),isInternal:!!n,isDevEnv:/testsuite/.test(e.name),libraries:e.libraries,allowedMembers:this.aAllowedMembers})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/blocks/IndexEntry", ["sap/uxap/BlockBase","sap/ui/documentation/sdk/model/formatter"],function(e,t){"use strict";var n=e.extend("sap.ui.documentation.sdk.blocks.IndexEntry",{metadata:{views:{Collapsed:{viewName:"sap.ui.documentation.sdk.blocks.IndexEntry",type:"XML"},Expanded:{viewName:"sap.ui.documentation.sdk.blocks.IndexEntry",type:"XML"}}},formatText:function(){return t.formatIndexByVersionEntry.apply(t,arguments)}});return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/ApiDetail.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/core/CustomData","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/core/mvc/XMLView","sap/base/Log"],function(e,t,i,n,s,o,r){"use strict";return e.extend("sap.ui.documentation.sdk.controller.ApiDetail",{NOT_AVAILABLE:"N/A",NOT_FOUND:"Not found",onInit:function(){this.getRouter().getRoute("apiSpecialRoute").attachPatternMatched(this._onTopicMatched,this);this._oModel=new t;this._oModel.setSizeLimit(1e4);this._oContainerPage=this.getView().byId("apiDetailPageContainer")},_onTopicMatched:function(e){var t,i,s;t=this.getRouter()._decodeSpecialRouteArguments(e);i=this.getOwnerComponent();if(this._sTopicid===t.id){s=this._oView&&this._oView.getController();if(s){s.scrollToEntity(t.entityType,t.entityId)}return}this._sTopicid=t.id;this._sEntityType=t.entityType;this._sEntityId=t.entityId;if(this._oView&&!this._oView.bIsDestroyed){this._oView.destroy();this._oContainerPage.setBusy(true)}i.loadVersionInfo().then(function(){this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers")}.bind(this)).then(n.getIndexJsonPromise).then(this._processApiIndexAndLoadApiJson.bind(this)).then(this._findEntityInApiJsonData.bind(this)).then(this._addMissingNodesToControlData.bind(this)).then(this._buildBorrowedModel.bind(this)).then(this._createModelAndSubView.bind(this)).then(this._initSubView.bind(this)).catch(function(e){if(e===this.NOT_FOUND){this._oContainerPage.setBusy(false);this.onRouteNotFound()}else if(typeof e==="string"){r.error(e)}else if(e.name){r.error(e.name,e.message)}else if(e.message){r.error(e.message)}}.bind(this))},_initSubView:function(e){var t=e.getController();if(e.data("topicid")!==this._sTopicid){e.destroy();return}this._oView=e;this._oContainerPage.addContent(e);this._oContainerPage.setBusy(false);t.initiate({sTopicId:this._sTopicid,oModel:this._oModel,aApiIndex:this._aApiIndex,aAllowedMembers:this._aAllowedMembers,oEntityData:this._oEntityData,sEntityType:this._sEntityType,sEntityId:this._sEntityId,oOwnerComponent:this.getOwnerComponent(),oContainerView:this.getView(),oContainerController:this})},_createModelAndSubView:function(e){this._oControlData.borrowed=e;this._bindData(this._sTopicid);return o.create({height:"100%",customData:new i({key:"topicid",value:this._sTopicid}),viewName:"sap.ui.documentation.sdk.view.SubApiDetail",async:true,preprocessors:{xml:{models:{data:this._oModel}}}})},_buildBorrowedModel:function(e){this._oControlData=e;return this.buildBorrowedModel(e)},_addMissingNodesToControlData:function(e){var t,i,n,s,o;if(this._oEntityData.kind==="namespace"){o=Array.isArray(this._oEntityData.nodes)&&this._oEntityData.nodes;t=Array.isArray(e.nodes)&&e.nodes;if(o&&t&&o.length>t.length){t.sort(this._compareStringsCaseInsensitive);o.forEach(function(e,o){i=e.name;s=t[o]&&t[o].name;if(i!==s){n={};n.name=i;n.description="";n.href="api/"+i;if(e.deprecated){n.deprecated=true}t.splice(o,0,n)}})}}return e},_compareStringsCaseInsensitive:function(e,t){var i=e.name.toLowerCase(),n=t.name.toLowerCase();if(i<n){return-1}if(i>n){return 1}return 0},_filterEntityByVisibilityInApiJsonData:function(e){var t=this.getModel("versionData"),i=t.getProperty("/isInternal");if(!i){e=(e||[]).filter(function(e){return!e.hasOwnProperty("visibility")||e.visibility!=="restricted"})}return e},_findEntityInApiJsonData:function(e){var t,i,n;for(n=0,i=e.length;n<i;n++){t=e[n];if(t.name===this._sTopicid){if(t.visibility===undefined||this._aAllowedMembers.indexOf(t.visibility)>=0){return t}else{return Promise.reject(this.NOT_FOUND)}}}return Promise.reject(this.NOT_FOUND)},_processApiIndexAndLoadApiJson:function(e){var t,i,s=this._sTopicid;this._aApiIndex=e;function o(e){return e.some(function(e){var i=e.name===s;if(!i&&e.nodes){return o(e.nodes)}else if(i){t=e;return true}return false})}o(e);if(t){this._oEntityData=t;if(t.deprecated||t.bAllContentDeprecated){i=this.getOwnerComponent().getConfigUtil().getMasterView("apiId").getController();i.selectDeprecatedSymbol(this._sTopicid)}t.nodes=this._filterEntityByVisibilityInApiJsonData(t.nodes);return n.getLibraryElementsJSONPromise(t.lib).then(function(e){return Promise.resolve(e)})}return Promise.reject(this.NOT_FOUND)},_bindData:function(e){var t=this._oControlData,i,n,o=function(e,t){e=e.toLowerCase();t=t.toLowerCase();if(e>t){return 1}else if(e<t){return-1}return 0};n=t["ui5-metadata"];t.hasProperties=false;t.hasOwnMethods=false;t.hasControlProperties=false;t.hasAssociations=false;t.hasAggregations=false;t.hasSpecialSettings=false;t.hasAnnotations=false;var r=function(e){return this._aAllowedMembers.indexOf(e.visibility)>=0}.bind(this);var a=function(e){e.name&&(e.name=s.apiRefEntityName(e.name));e.code&&(e.code=s.apiRefEntityName(e.code));if(e.name){var t=e.name.replace(/[$#/]/g,".");e.placeholderId=t+"_method";e.subPlaceholderId=t+"__method"}return e};if(t.borrowed.properties.length){n=n||(t["ui5-metadata"]={});n.properties=(n.properties||[]).concat(t.borrowed.properties)}if(t.borrowed.aggregations.length){n=n||(t["ui5-metadata"]={});n.aggregations=(n.aggregations||[]).concat(t.borrowed.aggregations)}if(t.borrowed.associations.length){n=n||(t["ui5-metadata"]={});n.associations=(n.associations||[]).concat(t.borrowed.associations)}if(t.borrowed.fields.length){t.properties=(t.properties||[]).concat(t.borrowed.fields)}if(t.properties){t.properties=this.transformElements(t.properties,r,a);t.hasProperties=!!t.properties.length}if(t.methods){t.methods=this.transformElements(t.methods,r,a);t.hasOwnMethods=!!t.methods.length}if(t.events){t.events=this.transformElements(t.events,r,a);t.hasOwnevents=!!t.events.length}if(n){t.dnd=n.dnd;t.hasControlProperties=!!(n.properties&&n.properties.length);t.hasAssociations=!!(n.associations&&n.associations.length);t.hasAggregations=!!(n.aggregations&&n.aggregations.length);t.hasSpecialSettings=!!(n.specialSettings&&n.specialSettings.length);t.hasAnnotations=!!(n.annotations&&n.annotations.length);if(t.hasControlProperties){n.properties=this.transformElements(n.properties,r).sort(function(e,t){return o(e.name,t.name)})}if(t.hasAssociations){n.associations=this.transformElements(n.associations,r).sort(function(e,t){return o(e.name,t.name)})}if(t.hasAggregations){n.aggregations=this.transformElements(n.aggregations,r).sort(function(e,t){return o(e.name,t.name)});t.hasAggregationAltTypes=n.aggregations.some(function(e){return!!e.altTypes})}if(t.hasSpecialSettings){n.specialSettings=this.transformElements(n.specialSettings,r).sort(function(e,t){return o(e.name,t.name)})}if(t.hasAnnotations){n.annotations=n.annotations.sort(function(e,t){return o(e.annotation,t.annotation)})}}t.nodes=this.transformElements(t.nodes||[],r).sort(function(e,t){return o(e.name,t.name)});t.hasChildren=t.nodes&&!!t.nodes.length;t.hasConstructor=t.hasOwnProperty("constructor")&&!!t.constructor;t.hasOwnEvents=!!t.events;t.hasEvents=!!(t.hasOwnEvents||t.borrowed&&t.borrowed.events.length>0);t.hasMethods=!!(t.hasOwnMethods||t.borrowed&&t.borrowed.methods.length>0);if(t.implements&&t.implements.length){t.implementsParsed=t.implements.map(function(e,t,i){var n=e.split("."),s=n[n.length-1];return{href:e,name:s}});t.hasImplementsData=true}else{t.hasImplementsData=false}t.isFunction=t.kind==="function";t.isClass=t.kind==="class";t.isNamespace=t.kind==="namespace";t.isTypedef=t.kind==="typedef";t.isDerived=!!t.extends;t.extendsText=t.extends||this.NOT_AVAILABLE;t.sinceText=t.since||this.NOT_AVAILABLE;t.module=t.module||this.NOT_AVAILABLE;this._oModel.setData(t);if(this.extHookbindData){this.extHookbindData(e,i)}},buildBorrowedModel:function(e){var t,i,s,o,r,a,d,l,h,u,f,m,c,p,g,_,b,w,y,v=[],A;if(!e){return Promise.resolve({events:[],methods:[],properties:[],aggregations:[],associations:[],fields:[]})}l={methods:[],events:[],properties:[],aggregations:[],associations:[],fields:[]};d=e.extends;var E=function(e){return this._aAllowedMembers.indexOf(e.visibility)!==-1}.bind(this);h=e.methods||[];u=h.map(function(e){return e.name});f=e["ui5-metadata"]&&e["ui5-metadata"].properties||[];m=f.map(function(e){return e.name});c=e["ui5-metadata"]&&e["ui5-metadata"].aggregations||[];p=c.map(function(e){return e.name});g=e["ui5-metadata"]&&e["ui5-metadata"].associations||[];_=g.map(function(e){return e.name});b=e.properties||[];w=b.map(function(e){return e.name});var O=function(e){return u.indexOf(e.name)===-1};var C=function(e){return m.indexOf(e.name)===-1&&!e.borrowedFrom&&!l.properties.some(function(t){return t.name===e.name})};var D=function(e){return p.indexOf(e.name)===-1&&!e.borrowedFrom};var I=function(e){return _.indexOf(e.name)===-1&&!e.borrowedFrom};var T=function(e){return w.indexOf(e.name)===-1&&!e.borrowedFrom};function M(e,t){A=null;return e.some(function(e){var i=e.name===t;if(!i&&e.nodes){return M(e.nodes,t)}else if(i){A=e;return true}return false})}y=[d];while(d){M(this._aApiIndex,d);if(A){d=A.extends;if(d){y.push(d)}if(v.indexOf(A.lib)===-1){v.push(A.lib)}}else{d=false;break}}var P=v.map(function(e){return n.getLibraryElementsJSONPromise(e)});return Promise.all(P).then(function(n){var d=[],h;n.forEach(function(e){d=d.concat(e)});y.forEach(function(n){var u,f=d.length;while(f--){if(d[f].name===n){u=d[f];break}}var m=function(e){return{name:e.name,link:"api/"+n+"#methods/"+e.name}};var c=function(e){return{name:e.name,link:"api/"+n+"#events/"+e.name}};var p=function(e){return Object.assign({},e,{borrowedFrom:n})};if(u){h=u["ui5-metadata"]||[];if(e["ui5-metadata"]&&!e["ui5-metadata"].defaultAggregation&&h.defaultAggregation){e["ui5-metadata"].defaultAggregation=h.defaultAggregation}t=(u.methods||[]).filter(E).filter(O).map(m);if(t.length){l.methods.push({name:n,methods:t})}i=(u.events||[]).filter(E).map(c);if(i.length){l.events.push({name:n,events:i})}s=(h.properties||[]).filter(E).filter(C).map(p);if(s.length){l.properties=l.properties.concat(s)}o=(h.aggregations||[]).filter(E).filter(D).map(p);if(o.length){l.aggregations=l.aggregations.concat(o)}r=(h.associations||[]).filter(E).filter(I).map(p);if(r.length){l.associations=l.associations.concat(r)}a=(u.properties||[]).filter(E).filter(T).map(p);if(a.length){l.fields=l.fields.concat(a)}}});return l})},transformElements:function(e,t,i){var n,s=e.length,o=[],r;for(n=0;n<s;n++){r=e[n];if(t&&!t(r)){continue}if(i){i(r)}o.push(r)}return o}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/ApiDetailIndexDeprecatedExperimental.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter"],function(e,t,i,n){"use strict";return e.extend("sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental",{formatter:n,onInit:function(){var e=this.getRouter();this._oModel=new t;this._oModel.setSizeLimit(1e4);this.setModel(this._oModel);e.getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);e.getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);e.getRoute("since").attachPatternMatched(this._onTopicMatched,this);this._hasMatched=false},_onTopicMatched:function(e){var t=e.getParameter("name"),n={experimental:i.getExperimentalPromise,deprecated:i.getDeprecatedPromise,since:i.getSincePromise}[t];if(this._hasMatched){return}this._hasMatched=true;this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");n().then(function(e){e=this._filterVisibleElements(e);this._oModel.setData(e)}.bind(this))},_filterVisibleElements:function(e){var t={},i;Object.keys(e).forEach(function(i){var n=e[i];n.apis=n.apis.filter(function(e){return this._aAllowedMembers.indexOf(e.visibility)>-1}.bind(this));if(n.apis.length>0){t[i]=n}}.bind(this));i=Object.keys(t).sort(function(e,t){var i=e.split("."),n=t.split(".");var a=parseInt(i[0]),s=parseInt(n[0]);if(a!==s){return s-a}var r=parseInt(i[1]),o=parseInt(n[1]);return o-r}).reduce(function(e,i){e[i]=t[i];return e},{});return i},_modifyLinks:function(e){var t=e.getSource().getItems(),i=t.length,n;while(i--){n=t[i];if(n._getLinkSender){var a=n.getCustomData(),s=a[0].getValue(),r=a[1].getValue(),o=a[2].getValue(),c;if(a[3].getValue()){r=s+"."+r}c="api/"+s;if(o!=="class"){c+="/"+o+"/"+r}n._getLinkSender().setHref(c)}}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/ApiDetailInitial.controller", ["sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController"],function(n,e){"use strict";return e.extend("sap.ui.documentation.sdk.controller.ApiDetailInitial",{onInit:function(){e.prototype.onInit.call(this);this._onOrientationChange({landscape:n.orientation.landscape})},onBeforeRendering:function(){this._deregisterOrientationChange()},onAfterRendering:function(){this._registerOrientationChange()},onExit:function(){this._deregisterOrientationChange()}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/ApiMaster.controller", ["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/m/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/Highlighter"],function(e,t,i,s,n,o,a,r){"use strict";var l=i.SplitAppMode;return t.extend("sap.ui.documentation.sdk.controller.ApiMaster",{onInit:function(){var e=this.getOwnerComponent();this._oRouter=this.getRouter();this._oRouter.getRoute("api").attachPatternMatched(this._onMatched,this);this._oRouter.getRoute("apiSpecialRoute").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("since").attachPatternMatched(this._onTopicMatched,this);this.bIsInitial=true;this._oTreeModel=new a;this._oTreeModel.setSizeLimit(1e4);this.setModel(this._oTreeModel,"treeData");this._bIncludeDeprecated=false;this._oTree=this.byId("tree");this._oDataLoadedPromise=e.loadVersionInfo().then(function(){this._aAllowedMembers=e.aAllowedMembers}.bind(this)).then(o.getIndexJsonPromise).then(this._bindTreeModel.bind(this)).then(function(){this.buildAndApplyFilters();this._initTreeUtil("name","nodes")}.bind(this))},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new r(this._oTree.getDomRef(),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false})}},onExit:function(){this.highlighter.destroy()},_bindTreeModel:function(e){var t=function(e,i){return e.filter(function(e){if(e.hasOwnProperty("nodes")){e.nodes=t(e.nodes,i)}return!e.hasOwnProperty("visibility")||i.indexOf(e.visibility.toLowerCase())>=0})};if(e.length>0){e.push({isSelected:false,name:"experimental",displayName:"Experimental APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"deprecated",displayName:"Deprecated APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"since",displayName:"Index by Version",bAllContentDeprecated:false,visibility:"public"})}e=t(e,this._aAllowedMembers);this._oTreeModel.setData(e,false)},selectDeprecatedSymbol:function(e){this._bIncludeDeprecated=true;this.byId("includeDeprecated").setSelected(true);this.buildAndApplyFilters();this._expandTreeToNode(e,this.getModel("treeData"))},_onTopicMatched:function(e){var t=decodeURIComponent(e.getParameter("arguments").id)||e.getParameter("name"),i;if(e.getParameter("name")==="apiSpecialRoute"){i=this._oRouter._decodeSpecialRouteArguments(e);t=i.id}if(this.bIsInitial){this.showMasterSide();this.bIsInitial=false}this._oDataLoadedPromise.then(function(){this._expandTreeToNode(t,this._oTreeModel)}.bind(this))},_onMatched:function(){var t=this.getView().getParent().getParent(),i=this._oTree.getSelectedItem();i&&i.setSelected(false);this._oDataLoadedPromise.then(function(){this._oTree.collapseAll().expand(0)}.bind(this));t.setMode(l.ShowHideMode);if(e.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus()}.bind(this),0)}},onNodeSelect:function(e){this._oRouter.navTo("apiId",{id:e.getParameter("listItem").getTarget()},false)},onTreeFilter:function(){t.prototype.onTreeFilter.apply(this,arguments);if(this.highlighter){this.highlighter.highlight(this._sFilter)}return this},buildAndApplyFilters:function(){var e=[];if(!this._bIncludeDeprecated){e.push(new s({path:"bAllContentDeprecated",operator:n.EQ,value1:false}))}if(this._sFilter){e.push(new s({and:false,filters:[new s({path:"name",operator:n.Contains,value1:this._sFilter}),new s({path:"name",operator:n.Contains,value1:this._sFilter.replace(/\s/g,"")})]}))}this._oTree.getBinding("items").filter(new s({and:true,filters:e}));return!!this._sFilter},onIncludeDeprecatedItemsChange:function(e){this._bIncludeDeprecated=e.getParameter("selected");this.buildAndApplyFilters()}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/App.controller", ["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/NewsInfo","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/ui/documentation/library","sap/m/library","sap/base/Log","sap/base/util/Version","sap/ui/core/Core","sap/ui/util/openWindow","sap/ui/documentation/sdk/model/formatter","sap/m/ResponsivePopover","sap/ui/documentation/sdk/controller/util/Highlighter","sap/m/Button","sap/m/Toolbar","sap/ui/documentation/sdk/util/Resources","sap/base/util/LoaderExtensions","sap/ui/documentation/sdk/controller/util/ThemePicker"],function(jQuery,e,t,i,o,n,s,a,r,h,u,l,c,g,p,d,f,_,v,S,m,w,y,P){"use strict";var b=function(e){return w.getResourcesVersion()&&!self["sap-ui-documentation-config"]?window.origin+e:w.getResourceOriginPath(e)};var D="Demo Kit - � SDK",C={topic:"Documentation - "+D,api:"API Reference - "+D,controls:"Samples - "+D,demoapps:"Demo Apps - "+D,tools:"Tools - "+D,home:D};var V=l.URLHelper,A=l.SplitAppMode,I=b("/neo-app.json"),M=b("/versionoverview.json"),T="about",R="change_version",N="settings",k="cookie_preferences",E="en",L="language",O="appearance",U="sitemap";return e.extend("sap.ui.documentation.sdk.controller.App",{formatter:f,_arrToTreeConverter:function(){var e,t=this._aNeoAppVersions.slice(),i=[],o=0,n="";for(var s=0;s<t.length;s++){n=t[s].groupTitle;o=0;e=[];while(t[s]&&t[s].groupTitle&&t[s].groupTitle===n){e.push(t[s]);o++;s++}s--;i.push({groupTitle:n,version:n+" ("+o+" versions)",nodes:e,path:e[0].path})}return i},onInit:function(){e.prototype.onInit.call(this);var o=new s({busy:false,delay:0,device:r,bPhoneSize:false,bDesktopSize:false,bShowVersionSwitchButton:false,bDarkThemeActive:false,bLandscape:r.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideTopicSection:!!window["sap-ui-documentation-hideTopicSection"],bHideApiSection:!!window["sap-ui-documentation-hideApiSection"],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://ui5.sap.com/versionoverview.html'>https://ui5.sap.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://ui5.sap.com/1.71.46/'>https://ui5.sap.com/1.71.46/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://sdk.openui5.org/versionoverview.html'>https://sdk.openui5.org/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sdk.openui5.org/1.71.46/'>https://sdk.openui5.org/1.71.46/</a>"});var n=this.getOwnerComponent(),h=this;P.init(h);this.MENU_LINKS_MAP={copyright:"https://www.sap.com/corporate/en/legal/copyright.html",trademark:"https://www.sap.com/corporate/en/legal/trademark.html",disclaimer:"https://help.sap.com/viewer/disclaimer",sitemap:"sitemap"};jQuery.extend(this.MENU_LINKS_MAP,e.LEGAL_LINKS);this.getOwnerComponent().loadVersionInfo().then(function(){var e;if(this.getModel("versionData").getProperty("/isOpenUI5")){e="OPENUI5"}else{e="SAPUI5"}D=D.replace("�",e);Object.keys(C).forEach(function(t){C[t]=C[t].replace("�",e)});if(this._sKey){this.appendPageTitle(null).appendPageTitle(C[this._sKey])}}.bind(this));this.oRouter=this.getRouter();this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this._aNeoAppVersions=[];this._oView=this.getView();this.setModel(o,"appView");this._oNewsModel=new s;this.setModel(this._oNewsModel,"news");this._oSupportedLangModel=new s;this.setModel(this._oSupportedLangModel,"supportedLanguages");this.setModel(new s,"messagesData");this._demoKitPage=this.byId("demoKitPage");this._demoKitSubHeader=this.byId("demoKitSubHeader");this._demoKitSideNavigation=this.byId("demoKitSideNavigation");this._demoKitSplitApp=this.byId("splitApp");this._demoKitSplitApp._oDetailNav.setAutoFocus(false);this._demoKitSplitApp.attachEvent("afterMasterClose",function(e){o.setProperty("/bIsShownMaster",false)},this);this._requestVersionInfo();this.initSearch();i.init();this.setSurveyModelData();this.bus=p.getEventBus();this.bus.subscribe("newsChanged","onDemoKitNewsChanged",this._syncNewsModelWithNewsInfo,this);this.bus.subscribe("themeChanged","onThemeChanged",this._onThemeChanged,this);this._oConfigUtil=this.getOwnerComponent().getConfigUtil();this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;this._sLocalStorageNewsName=this._oConfigUtil.LOCAL_STORAGE_NAMES["OLD_NEWS_IDS"];t.prepareNewsData(this._oConfigUtil);this._createConfigurationBasedOnURIInput();if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"&&this._aConfiguration.length>0){this._applyCookiesConfiguration(this._aConfiguration)}else{this._applyDefaultConfiguration(this._aConfiguration)}n.getCookiesManagement().then(function(e){e.enable(n.getRootControl())});a.register(this._demoKitPage,this.onPageResize.bind(this))},onBeforeRendering:function(){r.orientation.detachHandler(this._onOrientationChange,this)},onAfterRendering:function(){jQuery(document.body).addClass(this.getOwnerComponent().getContentDensityClass());r.orientation.attachHandler(this._onOrientationChange,this);this._syncNewsModelWithNewsInfo();this._adjustVersionSwitchButton()},onExit:function(){r.orientation.detachHandler(this._onOrientationChange,this);if(this.highlighter){this.highlighter.destroy()}},onRouteChange:function(e){if(!this.oRouter.getRoute(e.getParameter("name"))._oConfig.target){return}var t,i,o=r.system.phone,n=e.getParameter("name"),s=this.oRouter.getRoute(n)._oConfig.target[0]+"Tab",a=this._oView.byId(s),h=a?a.getKey():"home",u=this.getModel("appView"),l=this.getOwnerComponent().getConfigUtil().hasMasterView(n);this._setHeaderSelectedKey(h);this._setSelectedSectionTitle(h);u.setProperty("/bHasMaster",l);if(o&&l){t=this.getOwnerComponent().getConfigUtil().getMasterView(n);i=t&&t.getId();u.setProperty("/sMasterViewId",i)}this._demoKitSplitApp.hideMaster();u.setProperty("/bIsShownMaster",false);this.appendPageTitle(null).appendPageTitle(C[h])},toggleMaster:function(e){var t=this.getModel("appView"),i=t.getProperty("/sMasterViewId"),o=this._demoKitSplitApp.getMode()===A.ShowHideMode,n=this._demoKitSplitApp.getMode()===A.HideMode,s=r.system.phone,a=e.getParameter("pressed"),h;if(!s&&(o||n)){h=a?this._demoKitSplitApp.showMaster:this._demoKitSplitApp.hideMaster;h.call(this._demoKitSplitApp);return}if(s){if(a){this._demoKitSplitApp.to(i)}else{this._demoKitSplitApp.backDetail()}}},navigateToSection:function(e){var t=e.getParameter("key")||e.getParameter("item").getKey(),i=e.getSource().isA("sap.tnt.SideNavigation");if(r.system.phone&&i){this.onSideNavigationButtonPress()}if(t&&t!=="home"){this.getRouter().navTo(t,{})}else{this.getRouter().navTo("welcome",{});this._setHeaderSelectedKey("home")}},navigateToNews:function(){this.getRouter().navTo("news")},onNewsButtonPress:function(e){var t=e.getSource(),i=this.getView();if(this._oNewsModel.getProperty("/newsCount")===0){this.navigateToNews()}else if(!this._oNewsPopover){h.load({name:"sap.ui.documentation.sdk.view.NewsPopover",controller:this}).then(function(e){i.addDependent(e);this._oNewsPopover=e;this._oNewsPopover.openBy(t)}.bind(this))}else{this._oNewsPopover.openBy(t)}},handleShowAllPress:function(){this._oNewsPopover.close();this.navigateToNews()},handleDismissAllPress:function(){t.moveAllNewItemsToOld()},handleNewsItemClose:function(e){var i=e.getSource(),o=i.getCustomData()[0].getValue(),n=this._oNewsModel.getProperty("/items").find(function(e){return e.id===o});t.moveNewItemToOld(n)},handleVisitNewsLink:function(e){var t=e.getSource(),i=t.getCustomData()[0].getValue();V.redirect(i,true)},_syncNewsModelWithNewsInfo:function(){var e,i=t.getPreparationFailureMessage();if(!i){e=t.getNewNewsArray().slice();this._oNewsModel.setProperty("/items",e);this._oNewsModel.setProperty("/newsCount",e.length)}this._oNewsModel.setProperty("/newsPreparationFailureMessage",i)},onMenuButtonItemSelected:function(e){var t=e.getParameter("item").getKey(),i=this.MENU_LINKS_MAP[t];if(t===T){this.aboutDialogOpen()}else if(t===N){this.settingsDialogOpen()}else if(t===k){this.getOwnerComponent().getCookiesManagement().then(function(e){e.cookieSettingsDialogOpen({showCookieDetails:true},this.getView())}.bind(this))}else if(t===R){this.onChangeVersionButtonPress()}else if(P._getTheme()[t]){this._updateAppearance(t)}else if(i===U){this.onSiteMapPress()}else if(i){V.redirect(i,true)}this.sTarget=i},createSearchPopover:function(){var e=l.PlacementType,t=this.getView().byId("searchControl"),i=new _({showArrow:false,showHeader:false,contentWidth:"600px",placement:e.Vertical,horizontalScrolling:false,initialFocus:this.getView().byId("searchControl-searchField")}).addStyleClass("sapMSltPicker-CTX");i.open=function(){i.openBy(t)};this.getView().addDependent(i);return i},createSearchPicker:function(){var e=r.system.phone?this.createSearchDialog():this.createSearchPopover();this.createSearchPickerContent().then(function(t){e.addContent(t)});return e},createSearchDialog:function(){var e,t,i,o,n,s,a;var r=this.getView().byId("searchControl");function h(){var i=r.getValue();if(i!==t){r._updateValue(i);r.fireLiveChange({newValue:i})}else{r.fireLiveChange({newValue:t})}e.close();r._toggleOpen(false)}function u(e){if(typeof e.selectionStart=="number"){e.selectionStart=e.selectionEnd=e.value.length}else if(typeof e.createTextRange!="undefined"){e.focus();var t=e.createTextRange();t.collapse(false);t.select()}}i=new(sap.ui.require("sap/m/SearchField"))({liveChange:function(e){var t=e.getParameter("newValue");r._updateValue(t);r.fireLiveChange({newValue:t})},search:function(t){if(!t.getParameter("clearButtonPressed")){e.close();a=true}}});s=new S({icon:"sap-icon://decline",press:function(){h()}});o=new m({content:[i,s]});n=new S({text:p.getLibraryResourceBundle("sap.m").getText("MSGBOX_OK"),press:function(){h()}});e=new(sap.ui.require("sap/m/Dialog"))({stretch:true,customHeader:o,beginButton:n,beforeClose:function(){r._bSuggestionSuppressed=true},beforeOpen:function(){t=r.getValue();i._updateValue(t);a=false},afterOpen:function(){var e=i.$().find("input");e.trigger("focus");u(e.get(0))},afterClose:function(e){if(a){r.fireSearch({query:r.getValue(),clearButtonPressed:false})}r._toggleOpen(false)}});this.getView().addDependent(e);return e},openSearchPicker:function(){if(!this.oPicker){this.oPicker=this.createSearchPicker()}if(!this.oPicker.isOpen()){this.oPicker.open()}},createSearchPickerContent:function(){return h.load({name:"sap.ui.documentation.sdk.view.GlobalSearchPicker",controller:this}).then(function(e){var t=p.byId("shortList"),i=this,o;t.addEventDelegate({onAfterRendering:function(){var e={useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false};i.highlighter=new v(t.getDomRef(),e);o=i.getModel("searchData").getProperty("/query");o&&i.highlighter.highlight(o);t.removeEventDelegate(this)}});return e}.bind(this))},initSearch:function(){var e=this.getModel("searchData"),t={topics:["topic","topicId","subTopicId"],entity:["sample","controlsMaster","controls","code","entity"],apiref:["api","apiSpecialRoute","apiId"]};this.oRouter.attachRouteMatched(function(){e.setProperty("/preferencedCategory",null)});Object.keys(t).forEach(function(i){var o=t[i];o.forEach(function(t){this.oRouter.getRoute(t).attachPatternMatched(function(){e.setProperty("/preferencedCategory",i)})}.bind(this))}.bind(this))},getSearchPickerTitle:function(e){var t=p.getLibraryResourceBundle("sap.ui.documentation"),i;switch(this.getModel("searchData").getProperty("/preferencedCategory")){case"topics":i=t.getText("SEARCH_SUGGESTIONS_TITLE_DOCUMENTATION");break;case"apiref":i=t.getText("SEARCH_SUGGESTIONS_TITLE_API_REFERENCE");break;case"entity":i=t.getText("SEARCH_SUGGESTIONS_TITLE_SAMPLES");break;default:i=t.getText("SEARCH_SUGGESTIONS_TITLE_ALL")}return i},formatSuggestionTitle:function(e,t){var i=e||"";if(t){i+=": "+t}return i},onSearchResultsSummaryPress:function(e){var t=e.oSource.data("category");this.navToSearchResults(t)},onSearchPickerItemPress:function(e){var t=e.oSource.getBindingContextPath(),i=this.getModel("searchData").getProperty(t);if(i.external){d(new URL(i.path,document.baseURI).href)}else{this.getRouter().parsePath(i.path)}this.oPicker.close()},_updateAppearance:function(e){var t=this;P._updateAppearance(e,t)},_createConfigurationBasedOnURIInput:function(){var e=new URLSearchParams(window.location.search);this._aConfiguration=[];if(!(e.has("sap-ui-language")||e.has("sap-language"))){this._aConfiguration.push(L)}if(!(e.has("sap-ui-theme")||e.has("sap-theme"))){this._aConfiguration.push(O)}},_applyDefaultConfiguration:function(){this._aConfiguration.forEach(function(e){if(e===L){p.getConfiguration().setLanguage(E)}else if(e===O){this._updateAppearance(P._getTheme().auto)}},this);this._oSupportedLangModel.setProperty("/selectedLang",p.getConfiguration().getLanguage())},_applyCookiesConfiguration:function(){var e,t,i;for(i=0;i<this._aConfiguration.length;i++){t=this._aConfiguration[i];e=this._oConfigUtil.getCookieValue(t);if(e!==""){if(t===L){this._setSelectedLanguage(e)}else if(t===O){this._updateAppearance(e)}this._aConfiguration.splice(i,1);i--}}if(this._aConfiguration.length>0){this._applyDefaultConfiguration()}},_prepareSupportedLangModelData:function(){return p.getConfiguration().getLanguagesDeliveredWithCore().reduce(function(e,t){var i,o=t,n=t;if(typeof t==="string"&&t.length>0){switch(t){case"sh":o="sr_Latn";break;case"no":o="nb";break;case"iw":o="he";n="he";break;case"zh_TW":n="zh_Hant";break;case"zh_CN":n="zh_Hans";break}e.push(new Promise(function(e,s){y.loadResource("sap/ui/core/cldr/"+o+".json",{async:true}).then(function(o){i=o.languages[n];e({text:typeof i==="string"?i.charAt(0).toUpperCase()+i.substring(1):"Unknown",key:t})})}))}return e},[])},_setSelectedLanguage:function(e){this._oSupportedLangModel.setProperty("/selectedLang",e);p.getConfiguration().setLanguage(e);if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"){this._oConfigUtil.setCookie(L,e)}if(this._sKey){this._setSelectedSectionTitle(this._sKey)}},_getSelectedLanguage:function(){return this._oSupportedLangModel.getProperty("/selectedLang")},settingsDialogOpen:function(){var e;if(!this._oSettingsDialog){h.load({name:"sap.ui.documentation.sdk.view.globalSettingsDialog",controller:this}).then(function(e){this._oView.addDependent(e);this._oSettingsDialog=e;p.byId("LanguageSelect").setSelectedKey(this._getSelectedLanguage());this._oSettingsDialog.open()}.bind(this))}else{this._oSettingsDialog.open()}if(!this._oSupportedLangModel.getProperty("/langs")){e=this._oSupportedLangModel;e.setProperty("/selectBusy",true);Promise.all(this._prepareSupportedLangModelData()).then(function(t){e.setProperty("/selectBusy",false);e.setProperty("/langs",t)})}},handleCloseAppSettings:function(){this._oSettingsDialog.close()},handleSaveAppSettings:function(){var e=p.byId("LanguageSelect").getSelectedKey();this._oSettingsDialog.close();this._applyAppConfiguration(e)},_applyAppConfiguration:function(e){this._setSelectedLanguage(e)},getAboutDialog:function(){return new Promise(function(e,t){if(!this._oAboutDialog){h.load({id:"aboutDialogFragment",name:"sap.ui.documentation.sdk.view.AboutDialog",controller:this}).then(function(t){this._oAboutDialog=t;this._oView.addDependent(this._oAboutDialog);e(this._oAboutDialog)}.bind(this))}else{e(this._oAboutDialog)}}.bind(this))},aboutDialogOpen:function(){this.getAboutDialog().then(function(e){e.getContent()[0].backToTop();e.open()})},aboutDialogClose:function(e){this.getAboutDialog().then(function(e){e.close()})},onAboutVersionDetails:function(e){var t=this.getModel("appView"),i=t.getData(),o=this;u._loadAllLibInfo("","_getLibraryInfo","",function(e,n){var s={};var a=u._getLibraryInfoSingleton();for(var r=0,h=e.length;r<h;r++){e[r]=n[e[r]];e[r].libDefaultComponent=a._getDefaultComponent(e[r])}s.libs=e;i.oVersionInfo=s;t.setData(i);o.setModel(t,"appView")});var n=h.byId("aboutDialogFragment","aboutNavCon"),s=h.byId("aboutDialogFragment","aboutDetail");n.to(s)},onAboutThirdParty:function(e){var t=this.getModel("appView"),i=t.getData(),o=this;u._loadAllLibInfo("","_getThirdPartyInfo",function(e,n){if(!e){return}var s={};s.thirdparty=[];for(var a=0;a<e.length;a++){var r=n[e[a]];for(var h=0;h<r.libs.length;h++){var u=r.libs[h];u._lib=e[a];s.thirdparty.push(u)}}s.thirdparty.sort(function(e,t){var i=(e.displayName||"").toUpperCase();var o=(t.displayName||"").toUpperCase();if(i>o){return 1}else if(i<o){return-1}else{return 0}});i.oThirdPartyInfo=s;t.setData(i);o.setModel(t,"appView")});var n=h.byId("aboutDialogFragment","aboutNavCon"),s=h.byId("aboutDialogFragment","aboutThirdParty");n.to(s)},_getReleaseDialog:function(){return new Promise(function(e){if(!this._oReleaseDialog){h.load({id:"releaseDialogFragment",name:"sap.ui.documentation.sdk.view.ReleaseDialog",controller:this}).then(function(t){this._oReleaseDialog=t;this._oView.addDependent(this._oReleaseDialog);e(this._oReleaseDialog)}.bind(this))}else{e(this._oReleaseDialog)}}.bind(this))},_getNotesView:function(){var e;return new Promise(function(t){if(!this._oNotesView){e=new s;h.load({id:"notesView",name:"sap.ui.documentation.sdk.view.ReleaseNotesView",controller:this}).then(function(i){this._oNotesView=i;this._oNotesView.setModel(e);t(this._oNotesView)}.bind(this))}else{t(this._oNotesView)}}.bind(this))},onReleaseDialogOpen:function(e){var t=u._getLibraryInfoSingleton(),i=e.getSource().data("version"),o=e.getSource().data("library"),n=new s;Promise.all([this._getReleaseDialog(),this._getNotesView()]).then(function(e){var s=e[0],a=e[1],r={};t._getReleaseNotes(o,i,function(e,t){var i={};if(e&&e[t]&&e[t].notes&&e[t].notes.length>0){r=e[t]}else{i.noData=true}a.getModel().setData(r);i.library=o;n.setData(i)});s.setModel(n);s.addContent(a);s.open()})},onReleaseDialogClose:function(e){this._getReleaseDialog().then(function(e){e.close()})},onAboutNavBack:function(e){var t=h.byId("aboutDialogFragment","aboutNavCon");t.back()},onChangeVersionButtonPress:function(){this.getVersionSwitchDialog().then(function(e){e.open()})},onCloseVersionDialog:function(){this.getVersionSwitchDialog().then(function(e){e.close()})},onChangeVersionDialogSearch:function(e){var t=e.getParameter("newValue"),i=new o("version",n.Contains,t),s=p.byId("versionList"),a=s.getBinding("items");a.filter([i]);if(a.getChildCount()===1){a.expand(0)}else{s.collapseAll()}},onHeaderLogoPress:function(){this._demoKitPage.setSideExpanded(false);this.oRouter.navTo("welcome",{})},onSiteMapPress:function(){this.oRouter.navTo("sitemap",{})},onLatestVersionItemPress:function(){if(w.getResourcesVersion()){window.sessionStorage.removeItem("versionPrefixPath");window.location.reload()}else{window.location.href="/"}},onVersionItemPress:function(e){var t=p.byId("versionList").getSelectedItem(),i=t.getCustomData()[0];if(i&&i.getKey()==="path"){if(w.getHasProxy()){window.sessionStorage.setItem("versionPrefixPath",i.getValue());window.location.reload()}else{window.location.href=i.getValue()}}},getVersionSwitchDialog:function(){return new Promise(function(e){if(!this._oChangeVersionDialog){h.load({name:"sap.ui.documentation.sdk.view.ChangeVersionDialog",controller:this}).then(function(t){this._oChangeVersionDialog=t;this._oChangeVersionDialog.setModel(this._buildVersionDialogModel());this._oView.addDependent(this._oChangeVersionDialog);e(this._oChangeVersionDialog)}.bind(this))}else{e(this._oChangeVersionDialog)}}.bind(this))},versionSwitchCustomComparator:function(e,t){return g(e).compareTo(g(t))},_updateVersionSwitchVisibility:function(){this.getModel("appView").setProperty("/bShowVersionSwitchButton",!!this._aNeoAppVersions.length)},_buildVersionDialogModel:function(){var e=new s;e.setSizeLimit(1e3);e.setData(this._aNeoAppVersions);e.setData(this._arrToTreeConverter(this._aNeoAppVersions));return e},launchSurvey:function(e,t){var i=this.byId(!t?"surveyButton":"aboutMenuButton"),o=this.getView(),n=this.getModel("appView"),s=n.getProperty("/bShowLongSurvey");if(!s){this.shortSurveyRedirect()}else if(!this._oSurveyPopover){h.load({name:"sap.ui.documentation.sdk.view.SurveyPopover",controller:this}).then(function(e){o.addDependent(e);this._oSurveyPopover=e;if(r.system.phone){this.addSurveyPopoverCloseBtn()}this._oSurveyPopover.openBy(i)}.bind(this))}else{this._oSurveyPopover.openBy(i)}},closeSurveyPopover:function(e){this._oSurveyPopover.close()},shortSurveyRedirect:function(){var e="?Release_version="+this._getUI5Version()+"&Source="+this._getUI5Distribution()+"&Type="+this._getUI5VersionType()+"&product=SAPUI5%2FOpenUI5"+"&product_filter=UI5"+"&cluster=BTP"+"&page="+encodeURIComponent(document.location.href);var t="https://sapinsights.eu.qualtrics.com/jfe/form/SV_byI4QeS7Ic2Psyi"+e,i="https://sapinsights.eu.qualtrics.com/jfe/form/SV_3Epqk1MLAUQVrwy"+e,o=!this.getModel("versionData").getProperty("/isDevEnv");V.redirect(o?t:i,true)},longSurveyRedirect:function(){var e="https://sapinsights.eu.qualtrics.com/jfe/form/SV_7X5P63Zg5zXC5zE",t="?product=SAPUI5%2FOpenUI5"+"&product_filter=UI5"+"&cluster=BTP"+"&page="+encodeURIComponent(document.location.href),i=e+t,o=e+t+"&Q_CHL=preview&Q_SurveyVersionID=current",n=!this.getModel("versionData").getProperty("/isDevEnv");V.redirect(n?i:o,true)},setSurveyModelData:function(){var e=this.getModel("appView"),t=new Date,i=t.getFullYear(),o=[[new Date(i,1,1),new Date(i,1,21)],[new Date(i,4,1),new Date(i,4,21)],[new Date(i,7,1),new Date(i,7,21)],[new Date(i,10,1),new Date(i,10,21)]],n=false,s;o.forEach(function(e){var i=e[0],o=e[1];if(t>=i&&t<=o){n=true;s=o.toLocaleDateString();return}});e.setProperty("/bShowLongSurvey",n);if(n){e.setProperty("/sLongSurveyLastDate",s)}},addSurveyPopoverCloseBtn:function(){var e=this.getModel("i18n").getResourceBundle(),t=this.closeSurveyPopover.bind(this),i=new S({text:e.getText("SURVEY_POPOVER_CLOSE_BTN"),press:t});this._oSurveyPopover.setEndButton(i)},onSearch:function(e){var t=encodeURIComponent(e.getParameter("query"));if(!t){return}this.getRouter().navTo("search",{searchParam:t},false);this.oPicker.close()},navToSearchResults:function(e){var t=this.getModel("searchData").getProperty("/query"),i={searchParam:t};if(!t){return}if(e){i["?options"]={category:e}}this.getRouter().navTo("search",i,true);this.oPicker.close()},onSearchLiveChange:function(e){var t=this.getModel("searchData"),o=e.getParameter("newValue"),n=t.getProperty("/preferencedCategory"),s=t.getProperty("/includeDeprecated");if(!o&&r.system.desktop){if(this.oPicker.isOpen()){this.oPicker.close()}return}this.openSearchPicker();if(this.highlighter){this.highlighter.highlight(o)}t.setProperty("/query",o);i.search(o,{preferencedCategory:n,includeDeprecated:s}).then(function(e){t.setProperty("/matches",e.matches)})},onPageResize:function(e){var t=e.size.width,i=t>=r.media._predefinedRangeSets[r.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1],o=t<r.media._predefinedRangeSets[r.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],n=this.getModel("appView");if(o!==n.getProperty("/bPhoneSize")){n.setProperty("/bPhoneSize",o);this._demoKitPage.setSideExpanded(false)}if(i!==n.getProperty("/bDesktopSize")){n.setProperty("/bDesktopSize",i);setTimeout(function(){this._updateSearchFieldState()}.bind(this),0)}},onSideNavigationButtonPress:function(){this._demoKitPage.setSideExpanded(!this._demoKitPage.getSideExpanded())},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",r.orientation.landscape)},onToggleSearchMode:function(e){var t=e.getParameter("isOpen"),i=this.getModel("appView");i.setProperty("/bSearchMode",t);if(t){setTimeout(function(){if(r.system.desktop){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus()}else{this.openSearchPicker()}}.bind(this),0)}},_getCurrentYear:function(){return(new Date).getFullYear()},_getCurrentQuarter:function(){var e=new Date,t=e.getMonth(),i=Math.floor(t/3)+1;return i},_filterVersionsPastEOCP:function(e){var t=e.patches;return t.filter(function(e){var t=e.extended_eocp||e.eocp||"";if(!t){return true}var i=/^Q[1-4]\/\d{4}$/i.test(t);if(!i){return true}var o=Number(t.substring(1,2)),n=Number(t.substring(3));return n>this._getCurrentYear()||n===this._getCurrentYear()&&o>=this._getCurrentQuarter()}.bind(this))},_processVersionOverview:function(e){var t=e.versions,i=[];if(Array.isArray(t)){t=t.filter(function(e){return!!e.hidden}).forEach(function(e){var t=e.hidden.split(",").map(function(e){return e.trim()});i=i.concat(t)})}return i},_processNeoAppJSON:function(e){var t=this.getModel("versionData"),i=t.getProperty("/isInternal"),o=t.getProperty("/isSnapshotVersion"),n=[];if(!(e&&e.routes)){c.warning("No versions were found");return}n=e.routes;n.pop();if(!i&&!o){n=n.filter(function(e){return e.target.version.indexOf("-beta")===-1})}n=n.map(function(e){var t=g(e.target.version),i={};i.patchVersion=t.getPatch();i.groupTitle=t.getMajor()+"."+t.getMinor();i.version=t.toString();i.path=e.path;return i});return n},_requestVersionInfo:function(){Promise.all([jQuery.ajax(I),jQuery.ajax(M)]).then(function(e){var t=this._processNeoAppJSON(e[0]),i=this._processVersionOverview(e[1]),o=this._filterVersionsPastEOCP(e[1]);if(Array.isArray(t)){t=t.filter(function(e){return i.indexOf(e.version)===-1});t=t.filter(function(e){return o.find(function(t){return t.version===e.version})});this._aNeoAppVersions=t;this._updateVersionSwitchVisibility();this.getModel("versionData").setProperty("/latestVersion",this._aNeoAppVersions[0].version)}else{this._aNeoAppVersions=[];c.warning("No multi-version environment detected")}}.bind(this),function(){c.warning("No neo-app.json or versionoverview.json was detected")})},_getFullVersion:function(){return this.getModel("versionData").getProperty("/fullVersion")},_getUI5Version:function(){return w.getResourcesVersion()?window.sessionStorage.getItem("versionPrefixPath"):this.getModel("versionData").getProperty("/version")},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav")},_getUI5Distribution:function(){var e=this._getUI5VersionGav(),t="SAPUI5";if(e&&/openui5/i.test(e)){t="OpenUI5"}return t},_getUI5VersionType:function(){var e=this.getModel("versionData"),t=e.getProperty("/isInternal"),i=e.getProperty("/isSnapshotVersion"),o;switch(true){case i&&t:o="InternalSnapshot";break;case t:o="Internal";break;case i:o="Snapshot";break;default:o="Release"}return o},_getCurrentPageRelativeURL:function(){var e=window.location;return e.pathname+e.hash+e.search},_getCurrentURL:function(){var e=window.location;return e.href},_setHeaderSelectedKey:function(e){this._demoKitSubHeader.setSelectedKey(e);this._demoKitSideNavigation.setSelectedKey(e);this._sKey=e},_onThemeChanged:function(e,t,i){var o=this.getModel("appView"),n=i.sThemeActive,s=n&&(n.includes("dark")||n.includes("hcb"));o.setProperty("/bDarkThemeActive",s)},_updateSearchFieldState:function(){var e=this.getModel("appView"),t=e.getProperty("/bDesktopSize"),i=this.byId("searchControl").getAggregation("_closingButton");if(t){e.setProperty("/bSearchMode",false);i.setVisible(false)}else{i.setVisible(true)}},_setSelectedSectionTitle:function(e){var t=this.getModel("appView"),i=this.getModel("i18n").getResourceBundle();var o=[{key:"home",text:i.getText("APP_TABHEADER_ITEM_HOME")},{key:"topic",text:i.getText("APP_TABHEADER_ITEM_DOCUMENTATION")},{key:"api",text:i.getText("APP_TABHEADER_ITEM_API_REFERENCE")},{key:"controls",text:i.getText("APP_TABHEADER_ITEM_SAMPLES")},{key:"demoapps",text:i.getText("APP_TABHEADER_ITEM_DEMO_APPS")},{key:"tools",text:i.getText("APP_TABHEADER_ITEM_TOOLS")}];var n=o.find(function(t){return t.key===e});t.setProperty("/selectedSectionTitle",n.text)},_adjustVersionSwitchButton:function(){var e=this.byId("versionSwitchButton");if(e){e.addEventDelegate({onAfterRendering:function(){var t=e.getDomRef(),i=t.querySelector(".sapMBtnContent");if(i){if(!i.classList.contains("sapUiDemoKitHeaderActionsVersionSwitchTextContent")){i.classList.add("sapUiDemoKitHeaderActionsVersionSwitchTextContent")}}}})}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/BPSupport.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/util/Resources","sap/ui/thirdparty/jquery","sap/ui/model/resource/ResourceModel","sap/ui/core/HTML"],function(t,e,n,jQuery,o,i){"use strict";return t.extend("sap.ui.documentation.sdk.controller.BPSupport",{onInit:function(){this.getRouter().getRoute("BPSupport").attachPatternMatched(this._onMatched,this);this._oModel=new e;this.setModel(this._oModel);if(!this._oMessageBundle){this._oMessageBundle=new o({bundleName:"sap.ui.documentation.messagebundle"})}this.setModel(this._oMessageBundle,"i18n");this.oConfigUtil=this.getOwnerComponent().getConfigUtil()},_requestContentPage:function(t){return new Promise(function(e,o){jQuery.ajax(n.getResourceOriginPath(t["browserSupportPath"]),{dataType:"text"}).done(function(t){e(t)}).fail(function(t,e,n){o()})})},_onMatched:function(){try{this.hideMasterSide()}catch(t){}this.oConfigUtil._requireConfigJSON().then(this._requestContentPage).then(function(t){this._oHTML=new i({id:"BPSupportContent",content:'<div id="d4h5-main-container" class="bpsupport">'+t+"</div>"});this.byId("BPSupportPage").removeAllContent();this.byId("BPSupportPage").addContent(this._oHTML)}.bind(this)).catch(function(t){this.onRouteNotFound()}.bind(this))}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/BaseController", ["sap/ui/documentation/library","sap/ui/core/Core","sap/ui/core/Fragment","sap/ui/core/mvc/Controller","sap/ui/core/routing/History","sap/ui/model/resource/ResourceModel","sap/ui/Device","sap/m/library","sap/ui/documentation/sdk/controller/util/APIInfo","sap/base/strings/formatMessage","sap/ui/documentation/WebPageTitleUtil"],function(e,t,n,i,o,r,s,a,u,l,c){"use strict";var g=a.SplitAppMode;var p=a.URLHelper;var d=new c;var h=[];var f=i.extend("sap.ui.documentation.sdk.controller.BaseController",{_oCore:t,formatMessage:l,appendPageTitle:function(e){if(e===null){h=[]}else{if(h.indexOf(e)>=0){return this}h.length===2?h[0]=e:h.unshift(e)}d.setTitle(h.join(" - "));return this},onInit:function(){var e=new r({bundleName:"sap.ui.documentation.messagebundle"});this.setModel(e,"i18n");if(s.system.phone||s.system.tablet){this.getOwnerComponent().loadVersionInfo()}},hideMasterSide:function(){var e=this.getSplitApp();e.setMode(g.HideMode)},showMasterSide:function(){var e=this.getSplitApp();e.setMode(g.ShowHideMode)},getSplitApp:function(){return this.getView().getParent().getParent()},getRouter:function(){return this.getOwnerComponent().getRouter()},getModel:function(e){return this.getView().getModel(e)},setModel:function(e,t){return this.getView().setModel(e,t)},getConfig:function(){return this.getOwnerComponent().getManifestEntry("/sap.ui5/config")||{}},onNavBack:function(e){var t=o.getInstance().getPreviousHash();if(t!==undefined){if(t.indexOf("search/")===0){this.getRouter().navTo("search",{searchParam:t.split("/")[1]},false)}else{history.go(-1)}}else{var n=window.location.hash;if(n.indexOf("#/topic/")==0){this.getRouter().navTo("topic",{},true)}else if(n.indexOf("#/api/")==0){this.getRouter().navTo("api",{},true)}}},searchResultsButtonVisibilitySwitch:function(e){var t=o.getInstance().getPreviousHash();if(t&&t.indexOf("search/")===0){e.setVisible(true)}else{e.setVisible(false)}},getRootView:function(){var e=this.getOwnerComponent();return e.byId(e.getManifestEntry("/sap.ui5/rootView").id)},onDisclaimerLinkPress:function(e){var t=e.getSource?e.getSource():e.target;if(!this.oDisclaimerPopover){n.load({name:"sap.ui.documentation.sdk.view.LegalDisclaimerPopover"}).then(function(e){this.getView().addDependent(e);this.oDisclaimerPopover=e;e.openBy(t)}.bind(this));return}else if(this.oDisclaimerPopover.isOpen()){this.oDisclaimerPopover.close()}this.oDisclaimerPopover.openBy(t)},_getControlComponent:function(t,n){var i=n.libComponentInfos,o=e._getLibraryInfoSingleton();return o._getActualComponent(i,t)},_onOrientationChange:function(e){var t=this.byId("phoneImage");if(s.system.phone&&t){t.toggleStyleClass("phoneHeaderImageLandscape",e.landscape)}},_registerOrientationChange:function(){s.orientation.attachHandler(this._onOrientationChange,this)},_deregisterOrientationChange:function(){s.orientation.detachHandler(this._onOrientationChange,this)},handleLandingImageLoad:function(){this.getView().byId("landingImageHeadline").setVisible(true)},handleFooterMasterItemPress:function(e){var t=e.getParameter("item").getKey(),n=f.LEGAL_LINKS[t];p.redirect(n,true)},getAPIReferenceCheckPromise:function(e){return u.getIndexJsonPromise().then(function(t){function n(t){return t.some(function(t){var i=t.name===e;if(!i&&t.nodes){return n(t.nodes)}return i})}return n(t)})},onRouteNotFound:function(){var e=this.getModel("i18n").getProperty("NOT_FOUND_TITLE");this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);setTimeout(this.appendPageTitle.bind(this,e));return}});f.LEGAL_LINKS={legal:"https://www.sap.com/corporate/en/legal/impressum.html",privacy:"https://www.sap.com/corporate/en/legal/privacy.html",terms_of_use:"https://www.sap.com/corporate/en/legal/terms-of-use.html",license:"LICENSE.txt"};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Code.controller", ["sap/ui/documentation/sdk/controller/Sample.controller","../model/ExploreSettingsModel","sap/ui/core/Component","sap/ui/core/HTML","sap/ui/Device","sap/base/util/restricted/_debounce","sap/ui/model/odata/v4/lib/_MetadataRequestor","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/model/formatter"],function(e,t,i,s,a,n,o,r,l){"use strict";return e.extend("sap.ui.documentation.sdk.controller.Code",{constructor:function(){this.onFileEditorFileChangeDebounced=n(this.onFileEditorFileChangeDebounced,500)},onInit:function(){e.prototype.onInit.call(this);this.getView().setModel(t,"settings");this._fileEditor=this.byId("fileEditor");this._fileEditor.attachBeforeFileChange(this.onBeforeFileChanged.bind(this));this._fileEditor.attachFileChange(this.onFileEditorFileChangeDebounced.bind(this));this._registerResize()},onExit:function(){this._deregisterResize()},onBeforeFileChanged:function(e){var t=e.getParameter("sFile");this._oChangedFile={sFile:t}},onFileEditorFileChangeDebounced:function(){var e=this.oModel.getData();if(this._oChangedFile){var i=sap.ui.require.toUrl(this._sId.replace(/\./g,"/"));var s=this._getChangedSamplesLocalStorage();if(!s){this._setChangedSamplesLocalStorage(JSON.stringify([this._sId]))}else{var a=JSON.parse(s);if(a.indexOf(this._sId)<0){a.push(this._sId);this._setChangedSamplesLocalStorage(JSON.stringify(a))}}e.showWarning=true;this.oModel.setData(e);this._updateFileContent(i,this._oChangedFile.sFile,true);this._oChangedFile=null}if(t.getProperty("/autoRun")){this._updateSample()}},onFileSwitch:function(e){t.setProperty("/editable",e.getParameter("editable"))},onRunPressed:function(e){this._updateSample()},onClearButtonPressed:function(e){var t=document.getElementById("sampleFrameEdit"),i=this._getChangedSamplesLocalStorage(),s=this.oModel.getData(),a=sap.ui.require.toUrl(this._sId.replace(/\./g,"/"));if(i){var n=JSON.parse(i);n.splice(n.indexOf(this._sId),1);this._setChangedSamplesLocalStorage(JSON.stringify(n))}s.showWarning=false;this.oModel.setData(s);this._getPage().setBusy(true);t.addEventListener("load",function(){this._getPage().setBusy(false)}.bind(this),{once:true});Promise.allSettled(this._oData.files.map(function(e){return fetch(e.url,{method:"DELETE"})})).then(function(){this._fileEditor._setClearButtonPressed(true);this._updateSample();this._fileEditor._fetchContents();this._oData.files.forEach(function(e){this._updateFileContent(a,e.name,true)},this)}.bind(this))},onChangeSplitterOrientation:function(e){t.setProperty("/splitViewVertically",!t.getProperty("/splitViewVertically"));var i=t.getProperty("/splitViewVertically");this.getView().byId("splitView").getRootPaneContainer().setOrientation(i?"Vertical":"Horizontal")},_attachPaternMatched:function(){this.oRouter.getRoute("code").attachPatternMatched(this._onRouteMatched,this);this.oRouter.getRoute("codeFile").attachPatternMatched(this._onRouteMatched,this)},_deregisterResize:function(){a.media.detachHandler(this._onResize,this)},_registerResize:function(){a.media.attachHandler(this._onResize,this);this._onResize()},_onResize:function(){var e=t.getProperty("/splitViewVertically"),i=a.media.getCurrentRange("StdExt").name;if(i=="Tablet"||i=="Phone"&&!e){t.setProperty("/splitViewVertically",true);this.getView().byId("splitView").getRootPaneContainer().setOrientation("Vertical")}},_onRouteMatched:function(e){var t=e.getParameter("arguments");this._sId=t.sampleId;this._sEntityId=t.entityId;this._sFileName=l.routeParamsToFilePath(t);this.byId("splitView").setBusy(true);r.loadData().then(function(e){return Promise.all([this._loadCode(e),this._loadSample(e)])}.bind(this)).then(function(e){this._showCode(e[0])}.bind(this))},_loadCode:function(e){var t=this._sFileName;var i=e.samples[this._sId];if(!i||i.contexts&&!i.contexts[this._sEntityId]){this.onRouteNotFound();return Promise.reject()}if(!this._oData||i.id!==this._oData.id){return this._createComponent().then(function(e){var s=e.getManifestEntry("/sap.ui5/config")||{},a=s.sample&&s.sample.additionalEditableFiles;this._oData={id:i.id,title:"Code: "+i.name,name:i.name,stretch:s.sample?s.sample.stretch:false,files:s.sample.files.map(function(e){return{key:e,name:e,editable:!!(e.endsWith(".xml")||e.endsWith(".js")||a&&a.indexOf(e)>-1),url:sap.ui.require.toUrl(i.id.replace(/\./g,"/"))+"/"+e}}),iframe:s.sample.iframe,fileName:t,includeInDownload:s.sample.additionalDownloadFiles,customIndexHTML:s.sample.customIndexHTML};return this._oData}.bind(this))}else{this._oData.fileName=t;return Promise.resolve(this._oData)}},_showCode:function(e){var i=!!e.useIFrame;this._oCurrSample=e;if(e.files){this._fileEditor.setFiles(e.files)}else{this.byId("splitView").setBusy(false)}t.setProperty("/useIFrame",i);this.oModel.setProperty("/sample",e);window.addEventListener("message",function(e){if(e.data==="sampleLoaded"){this.byId("splitView").setBusy(false)}}.bind(this))},_createHTMLControl:function(){return new s({id:"sampleFrameEdit",content:'<iframe src="'+this.sIFrameUrl+'" frameBorder="0" width="100%" height="100%"></iframe>'})},_getPage:function(){return this.byId("samplePageEdit")},onMessage:function(e){if(e.origin!==this.getOwnerComponent()._sSampleIframeOrigin){return}if(e.source!==(this._oHtmlControl.getDomRef()&&this._oHtmlControl.getDomRef().contentWindow)){return}if(e.data.type==="INIT"){this.fnMessageInit(e)}else if(e.data.type==="ERR"){this.fnMessageError(e)}else if(e.data.type==="LOAD"){this.fnMessageLoad(e)}},onNavBack:function(){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this._sId},false)},onPreviousSample:function(e){this.oRouter.navTo("code",{entityId:this.entityId,sampleId:this.oModel.getProperty("/previousSampleId")})},onNextSample:function(e){this.oRouter.navTo("code",{entityId:this.entityId,sampleId:this.oModel.getProperty("/nextSampleId")})},_updateSample:function(){var e=document.getElementById("sampleFrameEdit");if(e.contentWindow&&e.contentWindow.sap){e.contentWindow.location.reload()}},_createComponent:function(){var e="sampleComp-"+this._sId;var t=this._sId;var s=i.getComponentById(e);if(s){s.destroy()}return i.create({id:e,name:t})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Controls.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device"],function(e,n){"use strict";return e.extend("sap.ui.documentation.sdk.controller.Controls",{onInit:function(){e.prototype.onInit.call(this);this._onOrientationChange({landscape:n.orientation.landscape})},onBeforeRendering:function(){this._deregisterOrientationChange()},onAfterRendering:function(){this._registerOrientationChange()},onExit:function(){this._deregisterOrientationChange()},onPress:function(e){var n=e.oSource.getFilter(),t=this.getOwnerComponent().byId("controlsMaster").byId("searchField");t.setValue(n).fireLiveChange({newValue:n});setTimeout(function(){this.getSplitApp().showMaster()}.bind(this),0)}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/ControlsMaster.controller", ["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/Sorter","sap/ui/util/Storage","sap/ui/core/Core","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/core/Fragment"],function(jQuery,t,e,i,s,o,n,r,h,a,l,g,u){"use strict";var c="cozy",d="compact",_="condensed";return e.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:new a(a.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{densityMode:d,themeActive:"sap_horizon",rtl:false},_oDefaultSettings:{densityMode:d,themeActive:"sap_horizon",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:""},_mGroupFunctions:{name:function(t){var e=t.getProperty("name").charAt(0);return{key:e,text:e}},namespace:true,category:true,since:true,formFactors:true},_sFilterValue:"",onInit:function(){this._oList=this.byId("exploredMasterList");var e,o,n,r=function(t){this._oView.getModel().setData({entityCount:t.entityCount,entities:t.entities});this.getModel("filter").setData(t.filter);this._toggleListItem(this._getItemToSelect(),true)}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();s.loadData().then(r);e=new i;e.setSizeLimit(1e5);this._oView.setModel(e);o=new i({listMode:t.system.phone?"None":"SingleSelectMaster",listItemType:t.system.phone?"Active":"Inactive"});o.setDefaultBindingMode("OneWay");this._oView.setModel(o,"viewModel");n=new i;n.setSizeLimit(1e5);this.setModel(n,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("listFilter").attachPatternMatched(this._onFilterMatched,this);this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("codeFile").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._getList().addEventDelegate({onAfterRendering:function(){setTimeout(this._scrollToSelectedListItem.bind(this),this._iDomRenderingDelay)}},this);this._oCore.attachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.attachLocalizationChanged(this._onLocalizationChange,this);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();switch(this._oComponent.getContentDensityClass()){case"sapUiSizeCompact":this._oViewSettings.densityMode=d;break;case"sapUiSizeCondensed":this._oViewSettings.densityMode=_;break;default:this._oViewSettings.densityMode=c}this._oViewSettings.rtl=this._oCore.getConfiguration().getRTL();this._oDefaultSettings.densityMode=this._oViewSettings.densityMode;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();this.bus=l.getEventBus();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this)},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new g(this._oList.getDomRef(),{shouldBeObserved:true})}},onDemoKitThemeChanged:function(t,e,i){this._oDefaultSettings.themeActive=i.sThemeActive},_initListSettings:function(){var t=this._oStorage.get(this._sStorageKey);if(t){this._oListSettings=JSON.parse(t)}},_onGroupMatched:function(t){this._onMatched("#/group/",t)},_onEntityMatched:function(t){this._onMatched("#/entity/",t)},_onSampleMatched:function(t){this._onMatched("#/sample/",t)},_onMatched:function(t,e){var i=this._getList().getModel(),s=e.getParameter("arguments").entityId;this.showMasterSide();this._topicId=t+s;this._entityId=s;i.refresh();this._updateListSelection()},_onControlsMasterMatched:function(e){this.showMasterSide();if(!t.system.phone){this.getRouter().navTo("controls")}},_onFilterMatched:function(e){var i=e.getParameter("arguments").value,s;if(i){i=decodeURI(i);s=this.byId("searchField");s.setValue(i).fireLiveChange({newValue:i});setTimeout(function(){this.getSplitApp().showMaster()}.bind(this),0);if(t.system.phone){this.getRouter().navTo("controlsMaster",{})}}this._onControlsMatched(e)},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();if(t.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus()}.bind(this),0)}},_onLocalizationChange:function(t){this._iDomRenderingDelay=3e3;setTimeout(function(){this._iDomRenderingDelay=0}.bind(this),this._iDomRenderingDelay)},onNavToEntity:function(t){var e=t.getParameter("listItem"),i=e?e:t.getSource(),s=i.getBindingContext().getPath(),o=this.getView().getModel().getProperty(s);this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:o.id,part:"samples"})},getGroupHeader:function(t){return new o({title:t.key})},_updateListSelection:function(){var t=this._getItemToSelect();if(!t){return}this._toggleListItem(t,true);if(!this._bNavToEntityViaList){setTimeout(this._scrollToSelectedListItem.bind(this),0)}this._bNavToEntityViaList=false},_resetListSelection:function(){var t=this._getList().getSelectedItem();if(t){this._toggleListItem(t,false);setTimeout(this._scrollPageTo.bind(this,0,0),0)}},_toggleListItem:function(t,e){this._getList().setSelectedItem(t,e,false)},_scrollToSelectedListItem:function(){var t=this._getList().getSelectedItem();if(t){this._getPage().scrollToElement(t,this.LIST_SCROLL_DURATION)}},_scrollPageTo:function(t,e){this._getPage().scrollTo(t,e)},_getItemToSelect:function(){var t=this._getList(),e=t.getModel(),i,s,o,n=this._entityId,r=null;t.getItems().forEach(function(t){s=t.getBindingContext();if(s){o=s.getPath();i=e.getProperty(o);if(i.id===n){r=t;return false}}});return r},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage")}return this.oPage},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList")}return this.oList},onBeforeFirstShow:function(){this._updateView()},onExit:function(){this._oCore.detachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.detachLocalizationChanged(this._onLocalizationChange,this);this.highlighter.destroy()},onConfirmViewSettings:function(t){var e=t.getParameter("groupItem");this._oListSettings.filter=t.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=e?e.getKey():null;this._oListSettings.groupDescending=t.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView()},getViewSettingsDialog:function(){return new Promise(function(t){if(!this._oVSDialog){u.load({id:this.getView().getId(),name:"sap.ui.documentation.sdk.view.viewSettingsDialog",controller:this}).then(function(e){this._oVSDialog=e;this.getView().addDependent(this._oVSDialog);t(this._oVSDialog)}.bind(this))}else{t(this._oVSDialog)}}.bind(this))},handleListSettings:function(){this.getViewSettingsDialog().then(function(t){t.setSelectedFilterCompoundKeys(this._oListSettings.filter);t.setSelectedGroupItem(this._oListSettings.groupProperty);t.setGroupDescending(this._oListSettings.groupDescending);t.open()}.bind(this))},handleListFilter:function(t){this._sFilterValue=t.getParameter("newValue").trim();if(this.highlighter){this.highlighter.highlight(this._sFilterValue)}this._updateView()},_updateListBinding:function(){var t,e,i=[],s=[],o=false,a=false,l=this._oView.byId("exploredMasterList"),g=l.getBinding("items"),u;if(this._oListSettings.groupProperty==="since"){u=function(t,e){const i=t.split(".").map(Number);const s=e.split(".").map(Number);for(let t=0;t<Math.max(i.length,s.length);t++){const e=i[t]||0;const o=s[t]||0;if(e<o){return-1}else if(e>o){return 1}}return 0}}o=true;i.push(new n("searchTags",r.Contains,this._sFilterValue));jQuery.each(this._oListSettings.filter,function(t,e){var s=[];jQuery.each(e,function(e,i){var o=t==="formFactors"?r.Contains:r.EQ;s.push(new n(t,o,e))});o=true;i.push(new n(s,false))});if(o&&i.length===0){g.filter(i,"Application")}else if(o&&i.length>0){t=new n(i,true);g.filter(t,"Application")}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){a=true}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){a=true}if(a){e=new h(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty],u);s.push(e);s.push(new h("name",false));g.sort(s)}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding()},_updateFilterBarDisplay:function(){var t=[];jQuery.each(this._oListSettings.filter,function(e,i){t=t.concat(Object.keys(i))});if(t.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(t.join(", "))}else{this._vsFilterBar.setVisible(false)}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/DemoApps.controller", ["sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/Device","sap/ui/VersionInfo","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ResourceDownloadUtil","sap/ui/documentation/sdk/model/formatter","sap/ui/documentation/sdk/model/libraryData","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/thirdparty/jquery","sap/ui/core/Fragment"],function(e,t,n,i,o,a,r,s,l,d,u,c,h,jQuery,p){"use strict";return a.extend("sap.ui.documentation.sdk.controller.DemoApps",{formatter:s,onInit:function(){var e=new c,t=new h({bundleName:"sap.ui.documentation.messagebundle"});l.fillJSONModel(e).then(function(){return this.loadDemoAppsCellFragments(e)}.bind(this)).then(function(t){this._cellFragments=t;this.setModel(e)}.bind(this));this.getView().setModel(t,"i18n");this.setModel(new c({demoAppsHomeLink:"topic/a3ab54ecf7ac493b91904beb2095d208"}),"newWindowLinks");this.getRouter().getRoute("demoapps").attachPatternMatched(this._onMatched,this);o.load().then(function(e){var t=new c({isOpenUI5:e&&e.gav&&/openui5/i.test(e.gav)});this.getView().setModel(t,"appView")}.bind(this));this._onOrientationChange({landscape:i.orientation.landscape});this._onResize({name:i.resize.width<=600?"Phone":"NoPhone"})},onBeforeRendering:function(){this._deregisterOrientationChange()},onAfterRendering:function(){this._registerOrientationChange();this._registerResize()},onExit:function(){this._deregisterOrientationChange();this._deregisterResize()},_registerOrientationChange:function(){i.orientation.attachHandler(this._onOrientationChange,this)},_deregisterOrientationChange:function(){i.orientation.detachHandler(this._onOrientationChange,this)},_registerResize:function(){i.media.attachHandler(this._onResize,this)},_deregisterResize:function(){i.media.detachHandler(this._onResize,this)},_onOrientationChange:function(e){this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape",e.landscape)},_onResize:function(e){this.byId("phoneImage").setVisible(e.name==="Phone");this.byId("desktopImage").setVisible(e.name!=="Phone");this.byId("phoneImage").toggleStyleClass("phoneHeaderImageDesktop",e.name==="Phone")},_onMatched:function(){try{this.hideMasterSide()}catch(t){e.error(t)}},onDownloadButtonPress:function(e){var t=this.byId("downloadDialog"),n=this.byId("downloadDialogList");this._oDownloadButton=e.getSource();n.getBinding("items").filter([]);t.open()},onReadMoreButtonPress:function(){var e=s.formatHttpHrefForNewWindow(this.getModel("newWindowLinks").getProperty("/demoAppsHomeLink"));window.open(e,"_blank")},onSearch:function(e){var t=this.byId("downloadDialogList"),n=e.getParameter("newValue");t.getBinding("items").filter([new d("name",u.Contains,n)])},onCloseDialog:function(){var e=this.byId("downloadDialog"),t=this.byId("downloadDialogSearch");e.close();t.setValue("")},onDownloadPress:function(e){var t=e.getParameters().selectedItem,i=t?t:e.getSource().getParent();this._oDownloadButton.setBusy(true);sap.ui.require(["sap/ui/core/util/File","sap/ui/thirdparty/jszip"],function(e,t){var o=new t;jQuery.getJSON(i.data("config"),function(t){var a=t.files,s=[],l=[];a.forEach(function(e){var n=r.fetch(t.cwd+e);n.then(function(t){if(t.errorMessage){l.push(t.errorMessage)}else{if(!e.startsWith("../")){o.file(e,t,{base64:false,binary:true})}}});s.push(n)});
// add generic license file
var d=sap.ui.require.toUrl("LICENSE.txt").replace("resources/","");var u=r.fetch(d);var c=new Promise(function(e,t){u.then(function(t){o.file("LICENSE.txt",t);e()}).catch(function(){
// LICENSE.txt not available in SAPUI5, continue without it
e()})});s.push(c);Promise.all(s).then(function(){if(l.length){var t=l.reduce(function(e,t){return e+t+"\n"},"Could not locate the following download files:\n");this._handleError(t)}this._oDownloadButton.setBusy(false);n.show('Downloading for app "'+i.getLabel()+'" has been started');var a=o.generate({type:"blob"});this._createArchive(e,a,i.getLabel())}.bind(this))}.bind(this))}.bind(this))},loadDemoAppsCellFragments:function(e){var t={},n=this.createDemoAppCell.bind(this),i=e.getProperty("/demoAppsByCategory");function o(e){return Promise.all(e.rows.map(a))}function a(e){return Promise.all(e.map(function(e){return n(e).then(function(n){t[e.id]=n})}))}return new Promise(function(e,n){Promise.all(i.map(o)).then(function(){e(t)}).catch(function(e){n(e)})})},createDemoAppCellFactory:function(e,t){var n=t.getObject().id;return this._cellFragments[n]},onDemoAppCellCreated:function(e,t){var n=t[0],i=t[1];i.getContent()[0].addContent(n);sap.ui.loader.config({paths:{"test-resources":null}});n.addEventDelegate({onAfterRendering:function(){this.getParent().getDomRef().childNodes[1].setAttribute("aria-hidden","true")}.bind(n)});i.setBindingContext(e);return i},onDemoAppCellFailed:function(t,n){e.warning('Teaser for demo app "'+t.name+'" could not be loaded: '+n);return this.createNormalDemoAppCell(t)},createNormalDemoAppCell:function(e){return new Promise(function(t){p.load({id:e.id,name:"sap.ui.documentation.sdk.view.BlockLayoutCell",controller:this}).then(function(n){n.setBindingContext(e);t(n)})}.bind(this))},createDemoAppCellFromTeaser:function(e){sap.ui.loader.config({paths:{"test-resources":"test-resources"}});var t=sap.ui.require.toUrl(e.teaser),n=p.load({id:e.id,name:t,controller:this}),i=p.load({id:e.id,name:"sap.ui.documentation.sdk.view.BlockLayoutTeaserCell",controller:this}),o=this.onDemoAppCellCreated.bind(this,e),a=this.onDemoAppCellFailed.bind(this,e);return Promise.all([n,i]).then(function(e){return o(e)}).catch(function(e){return a(e)})},createDemoAppCell:function(e){if(e.teaser){return this.createDemoAppCellFromTeaser(e)}else{return this.createNormalDemoAppCell(e)}},_createArchive:function(e,t,n){e.save(t,n,"zip","application/zip")},_handleError:function(e){t.error(e)},handleLandingImageLoad:function(){this.byId("landingImageHeadline").setVisible(true)}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Downloads.controller", ["sap/ui/documentation/sdk/controller/BaseController"],function(t){"use strict";return t.extend("sap.ui.documentation.sdk.controller.Downloads",{onInit:function(){this.getRouter().getRoute("downloads").attachPatternMatched(this._onMatched,this)},_onMatched:function(){this.hideMasterSide()}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Entity.controller", ["sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/EntityInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute"],function(e,t,i,n,a,o,s,r,u,c,l){"use strict";return t.extend("sap.ui.documentation.sdk.controller.Entity",{onInit:function(){this.router=this.getRouter();this.router.getRoute("entity").attachPatternMatched(this.onRouteMatched,this);this._oObjectPage=this.byId("ObjectPageLayout");this.getView().setModel(new e)},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.getRouter().navTo("entity",{id:t},false)},onAPIRefPress:function(e){var t=e.getSource().data("name");this.getRouter().navTo("apiId",{id:t},false)},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true)},onNavToSample:function(e){var t=e.getSource().getBindingContext().getPath(),i=this.getView().getModel().getProperty(t);this.router.navTo("sample",{entityId:this._sNewId,sampleId:i.id})},_wrapInSpanTag:function(e){var t=o.formatTextBlock(e,{linkFormatter:function(e,t){var i="entity",n,a,o;t=t||e;if(e.match("://")){return'<a target="_blank" href="'+e+'">'+t+"</a>"}e=e.trim().replace(/\.prototype\./g,"#");o=e.indexOf("#");if(o===0){return"<code>"+e.slice(1)+"</code>"}else if(o>0){e=e.slice(0,o)}a=e.match(/^topic:(\w{32})$/);if(a){e=a[1];i="topic"}n=e.split("/");if(n.length>1&&["methods","events"].indexOf(n[1].toLowerCase())!==-1){i="api"}return'<a href="'+i+"/"+e+'">'+t+"</a>"}});return'<span class="sapUiJSD">'+t+"</span>"},_TAB_KEYS:["samples","about"],_loadSample:function(e){var t=this._sNewId;var i=e.entities.filter(function(e){return e.id===t});var a=i.length?i[0]:undefined;function o(){if(this._TAB_KEYS.indexOf(this._sNewTab)===-1){this._sNewTab="samples"}if(!s.show[this._sNewTab]){this._sNewTab="samples"}this._switchPageTab();setTimeout(function(){this._oObjectPage.setBusy(false)}.bind(this),0)}var s,r=this.getView();if(this._sId!==t){n.getEntityDocuAsync(t,a&&a.library).then(function(i){if(!a&&!i){this.onRouteNotFound();return}s=this._getViewData(t,i,a,e);this.getAPIReferenceCheckPromise(s.name).then(function(e){s.bHasAPIReference=e;this._buildHeaderLayout(s)}.bind(this));r.getModel().setData(s,false);this._sId=t;o.call(this);this.appendPageTitle(this.getModel().getProperty("/name"))}.bind(this))}else{s=this.getView().getModel().getData();o.call(this);this.appendPageTitle(this.getModel().getProperty("/name"))}},onRouteMatched:function(e){this._oObjectPage.setBusy(true);this._sNewId=e.getParameter("arguments").id;this._sNewTab=e.getParameter("arguments").sectionTab;i.loadData().then(function(e){this._loadSample(e)}.bind(this));this.searchResultsButtonVisibilitySwitch(this.byId("entityBackToSearch"))},onToggleFullScreen:function(e){a.updateMode(e,this.getView(),this)},_getViewData:function(e,t,i,n){var a=this._convertEntityInfo(e,t,n),o=false,s=0;a.show.introLink=false;if(i){if(!a.shortDescription&&i.description){a.shortDescription=i.description}if(!a.baseName){a.baseName=i.name}if(i.docuLink){a.show.introLink=true;a.docuLink=i.docuLink.replace("docs/guide","topic").replace(/\.html$/,"");a.docuLinkText=a.baseName}o=i.samples.length>0;s=i.samples.length}a.show.samples=o;a.count.samples=s;a.entity=i;if(t){if(t.docuLink){a.show.introLink=true;a.docuLink="topic/"+t.docuLink;a.docuLinkText=t.docuLinkText}a.uxGuidelinesLink=t.uxGuidelinesLink;a.uxGuidelinesLinkText=t.uxGuidelinesLinkText}return a},_convertEntityInfo:function(e,t,i){var n={name:e,deprecated:t?this._formatDeprecated(t.deprecation):null,deprecatedMark:t?this._createDeprecatedMark(t.deprecation):null,baseType:t?this._formatType(t.baseType):null,baseTypeText:t?this._formatTypeText(t.baseType):"-",baseTypeNav:t?this._formatTypeNav(t.baseType):null,shortDescription:t?this._formatDeprecatedDescription(t.deprecation):null,description:t?this._wrapInSpanTag(t.doc):null,docuLink:null,docuLinkText:null,uxGuidelinesLink:null,uxGuidelinesLinkText:null,values:t?t.values:[],show:{baseType:t?!!t.baseType:false,about:!!t,values:false,introActive:false},count:{samples:0},appComponent:this._getControlComponent(e,i)};if(!t){return n}n.show.values=Array.isArray(n.values)&&n.values.length>0;return n},_formatDeprecated:function(e){return e&&e.length>0?"true":"false"},_formatDeprecatedDescription:function(e){return e&&e.length>0?this._createDeprecatedMark(e)+": "+e:null},_formatType:function(e){if(!e){return null}else{return e.replace("[]","")}},_formatTypeText:function(e){if(!e){return null}else{e=e.replace("sap.ui.core.","");var t=e.lastIndexOf(".");return t!==-1?e.substr(t+1):e}},_createDeprecatedMark:function(e){var t=this.getModel("i18n").getResourceBundle();return e?t.getText("ENTITY_DEPRECATED"):""},_switchPageTab:function(){var e=this.byId(this._sNewTab);if(!e){return}if(this._oObjectPage){this._oObjectPage.attachEvent("onAfterRenderingDOMReady",function(){this._oObjectPage.setSelectedSection(e.getId())},this)}},_getHeaderLayoutUtil:function(){var e;if(!this._oHeaderLayoutUtil){var t=function(e,t){return new l({title:e,text:t}).addStyleClass("sapUiTinyMarginBottom")},i=function(e){return new r(e||{})},n=function(e){return new u(e||{})},a=function(e){return new s(e||{})},o=function(e,t){var i=new c(e||{});if(t){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom")}return i};e=this.getModel("i18n").getResourceBundle();this._oHeaderLayoutUtil={_getApiReferenceBlock:function(t){return o({items:[a({design:"Bold",text:e.getText("ENITITY_API")}),i({emphasized:true,text:t.name,href:"api/"+t.name})]},true)},_getDocumentationBlock:function(t){return o({items:[a({design:"Bold",text:e.getText("ENTITY_DOCUMENTATION")}),i({emphasized:true,text:t.docuLinkText,href:t.docuLink.replace(/^#\/?/,"")})]},true)},_getUXGuidelinesBlock:function(t){return o({items:[a({design:"Bold",text:e.getText("ENTITY_UX")}),i({emphasized:true,text:t.uxGuidelinesLinkText,href:t.uxGuidelinesLink,target:"_blank"})]},true)},_getExtendsBlock:function(t){return o({items:[a({text:e.getText("ENTITY_EXTENDS")}),i({text:t.baseTypeText,href:"entity/"+t.baseType,visible:!!t.baseTypeNav}),n({text:"N/A",visible:!t.baseTypeNav||!t.baseType})]},true)},_getApplicationComponentBlock:function(i){return t(e.getText("ENTITY_COMPONENT"),i.appComponent)},_getAvailableSinceBlock:function(i){return t(e.getText("ENTITY_SINCE"),i.entity.since)},_getCategoryBlock:function(i){return t(e.getText("ENTITY_CATEGORY"),i.entity.category)},_getContentDensityBlock:function(i){return t(e.getText("ENTITY_DENSITY"),i.entity.formFactors)}}}return this._oHeaderLayoutUtil},backToSearch:function(){this.onNavBack()},_buildHeaderLayout:function(e){var t=0,i=1,n=2,a=3,o=[[],[],[]],s=this._getHeaderLayoutUtil(),r=[{creator:"_getApiReferenceBlock",exists:e.bHasAPIReference},{creator:"_getDocumentationBlock",exists:e.show.introLink},{creator:"_getUXGuidelinesBlock",exists:!!e.uxGuidelinesLink},{creator:"_getExtendsBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getCategoryBlock",exists:true},{creator:"_getContentDensityBlock",exists:true}],u=function(){var u=0,c,l=function(e){if(e<=a){return t}else if(e<=a*2){return i}return n};r.forEach(function(t){var i;if(t.exists){i=s[t.creator].call(this,e);c=l(++u);o[c].push(i)}},this)}.bind(this);u();o.forEach(function(e,t){var i=this.byId("headerColumn"+t);i.removeAllContent();if(e.length>0){i.setVisible(true);e.forEach(i.addContent,i)}},this)},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string","Date","Object"],_formatTypeNav:function(e){return this._baseTypes.indexOf(e)===-1}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/ErrorHandler", ["sap/ui/base/Object","sap/m/MessageBox"],function(e,t){"use strict";return e.extend("sap.ui.documentation.sdk.controller.ErrorHandler",{constructor:function(e){this._oComponent=e;this._oModel=e.getModel();this._bMessageOpen=false;this._sErrorText="Sorry, a technical error occurred! Please try again later."},_showMetadataError:function(e){t.error(this._sErrorText,{id:"metadataErrorMessageBox",details:e,styleClass:this._oComponent.getContentDensityClass(),actions:[t.Action.RETRY,t.Action.CLOSE],onClose:function(e){if(e===t.Action.RETRY){this._oModel.refreshMetadata()}}.bind(this)})},_showServiceError:function(e){if(this._bMessageOpen){return}this._bMessageOpen=true;t.error(this._sErrorText,{id:"serviceErrorMessageBox",details:e,styleClass:this._oComponent.getContentDensityClass(),actions:[t.Action.CLOSE],onClose:function(){this._bMessageOpen=false}.bind(this)})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Group.controller", ["sap/ui/documentation/sdk/controller/BaseController"],function(t){"use strict";return t.extend("sap.ui.documentation.sdk.controller.Group",{onInit:function(){this.getRouter().getRoute("group").attachPatternMatched(this._onGroupMatched,this)},_onGroupMatched:function(t){this._id=t.getParameter("arguments").id}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/License.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/library"],function(t,e){"use strict";return t.extend("sap.ui.documentation.sdk.controller.License",{onInit:function(){this.getRouter().getRoute("license").attachPatternMatched(this._onTopicMatched,this)},_onTopicMatched:function(t){
// Get the LICENSE.txt file and display it. In case of error redirect to NotFound view.
e._getLicense().done(function(t){if(t!==""){this.getView().byId("licenseText").setText(t)}else{this.onRouteNotFound()}}.bind(this)).fail(function(){this.onRouteNotFound()}.bind(this))}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/LiveEditor.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/thirdparty/URI","sap/uxap/ThrottledTaskHelper","sap/ui/core/Core"],function(e,t,i,o,r){"use strict";var s={HTML:"index.html",XML:"App.view.xml",INDEX_JS:"index.js",CONTROLLER_JS:"App.controller.js"},n="HelloWorld",a=function(e){return n+"/"+e},l={};l[s.HTML]="text";l[s.XML]="xml";l[s.INDEX_JS]="javascript";l[s.CONTROLLER_JS]="javascript";return e.extend("sap.ui.documentation.sdk.controller.LiveEditor",{onInit:function(){this._oSrcFileContent={};this._oViewModel=new t({autoPreview:true,selectedFileName:s.XML,selectedFileType:l[s.XML],selectedFileContent:""});this.getView().setModel(this._oViewModel,"viewModel");new t(sap.ui.require.toUrl("sap/ui/documentation/sdk/model/LiveEditorData.json")).attachRequestCompleted(function(e){var t=e.getSource().getData(),o=new i(sap.ui.require.toUrl("sap-ui-core.js"),document.baseURI).href();if(t[s.HTML]){t[s.HTML]=t[s.HTML].replace(/&sol;/g,"/").replace("resources/sap-ui-core.js",o)}this._oSrcFileContent=t;this.showFileInEditor(s.XML)}.bind(this));this.getView().byId("resultBox").addEventDelegate({onAfterRendering:this.requestExecuteCurrentSrc.bind(this)});this._bSuppressRemoveOnce=false;this._bSuppressInsertOnce=false;this._oThrottledTask=null;this.bus=r.getEventBus();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this)},onDemoKitThemeChanged:function(e,t,i){this._oThrottledTask=null;this.requestExecuteCurrentSrc()},onSrcLiveChange:function(e){var t=e.getParameter("value"),i=e.getParameter("editorEvent").action,o;if(this._bSuppressRemoveOnce===true&&i==="remove"){this._bSuppressRemoveOnce=false;return}if(this._bSuppressInsertOnce===true&&i==="insert"){this._bSuppressInsertOnce=false;return}o=this._oViewModel.getProperty("/selectedFileName");this._oSrcFileContent[o]=t;if(this._oViewModel.getProperty("/autoPreview")){this.requestExecuteCurrentSrc()}},requestExecuteCurrentSrc:function(){this._getExecuteSrcThrottledTask().reSchedule(false,{}).catch(function(e){})},createFrame:function(){var e=document.createElement("iframe");e.id="outputWindow";e.width="100%";e.className="editorOutputWindow";e.src=sap.ui.require.toUrl("sap/ui/documentation/sdk/util/liveEditorOutput.html");e.sandbox="allow-forms allow-modals allow-pointer-lock allow-popups allow-scripts";return e},onFileSwitch:function(e){var t=e.getParameter("selectedKey");this._bSuppressRemoveOnce=true;this._bSuppressInsertOnce=true;this.showFileInEditor(t)},showFileInEditor:function(e){this._oViewModel.setProperty("/selectedFileContent",this._oSrcFileContent[e]);this._oViewModel.setProperty("/selectedFileType",l[e])},_getDataToPost:function(){var e={},t=a(s.INDEX_JS).slice(0,-3),i,o;Object.keys(s).forEach(function(t){o=s[t];i=a(o);e[i]=this._oSrcFileContent[o]},this);return{src:e,moduleNameToRequire:t,activeTheme:r.getConfiguration().getTheme().toLowerCase()}},_getExecuteSrcThrottledTask:function(){var e;if(!this._oThrottledTask){e=function(){var e=this.getView().byId("outputWindowWrapper").getDomRef(),t;if(e){while(e.firstChild){e.removeChild(e.firstChild)}t=this.createFrame();t.onload=function(){if(t.contentWindow){t.contentWindow.postMessage(this._getDataToPost(),"*");t.onload=null}}.bind(this);e.appendChild(t)}};this._oThrottledTask=new o(e,500,this)}return this._oThrottledTask},onNavButtonPress:function(){this.getRouter().myNavBack("welcome")}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/MasterTreeBaseController", ["sap/ui/thirdparty/jquery","./BaseController","./util/TreeUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator"],function(jQuery,e,t,i,l){"use strict";var o=300;var n=e.extend("sap.ui.documentation.sdk.controller.MasterTreeBaseController",{_initTreeUtil:function(e,i){this._oTreeUtil=new t(e,i)},_expandTreeToNode:function(e,t){var i=this.byId("tree"),l=t.getData();var o=this._oTreeUtil.getPathToNode(e,l);var n;o.forEach(function(e){var t=this._findTreeItem(e);if(t){i.getBinding("items").expand(i.indexOfItem(t));n=t}},this);if(n){n.setSelected(true);this.oSelectedItem={sTopicId:e,oModel:t};setTimeout(function(){if(n.getDomRef()&&!r(n.getDomRef())){this._scrollTreeItemIntoView(n)}}.bind(this),0)}},_findTreeItem:function(e){var t=this.byId("tree").getItems();for(var i=0;i<t.length;i++){if(t[i].getTarget()===e){return t[i]}}return null},_scrollTreeItemIntoView:function(e){var t=this.byId("page");t.scrollToElement(e.getDomRef(),o)},onTreeFilter:function(e){this._sFilter=e.getParameter("newValue").trim();if(this._filterTimeout){clearTimeout(this._filterTimeout)}this._filterTimeout=setTimeout(function(){if(this.buildAndApplyFilters()){this._expandAllNodes()}else{this._collapseAllNodes();if(this.oSelectedItem){this._expandTreeToNode(this.oSelectedItem.sTopicId,this.oSelectedItem.oModel)}}this._filterTimeout=null}.bind(this),250)},buildAndApplyFilters:function(){var e=this.byId("tree").getBinding("items");if(this._sFilter){e.filter(new i({path:"name",operator:l.Contains,value1:this._sFilter}));return true}else{e.filter();return false}},_expandAllNodes:function(){this.byId("tree").expandToLevel(10)},_collapseAllNodes:function(){this.byId("tree").collapseAll()},_clearSelection:function(){var e=this.byId("tree").getItems();if(e.length){e[0].setSelected(false)}},onTreeExpandAll:function(e){this._expandAllNodes()},onTreeCollapseAll:function(e){this._collapseAllNodes()}});function r(e){var t=e.getBoundingClientRect();return t.top>=0&&t.left>=0&&t.bottom<=jQuery(document).height()&&t.right<=jQuery(document).width()}return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/News.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/NewsInfo","sap/ui/core/Core","sap/m/library"],function(e,t,o,n,s){"use strict";return e.extend("sap.ui.documentation.sdk.controller.News",{onInit:function(){this.getRouter().getRoute("news").attachPatternMatched(this._onMatched,this);this._oModel=new t;this.setModel(this._oModel);o.prepareNewsData(this.getOwnerComponent().getConfigUtil());n.getEventBus().subscribe("newsChanged","onDemoKitNewsChanged",this._syncModelWithNewsInfo,this)},onAfterRendering:function(){this._syncModelWithNewsInfo()},handleNewsItemClose:function(e){var t=e.getSource(),n=t.getCustomData()[0].getValue(),s=this._oModel.getProperty("/new").find(function(e){return e.id===n});o.moveNewItemToOld(s)},handleMarkAsRead:function(){o.moveAllNewItemsToOld()},handleVisitLink:function(e){var t=e.getSource(),o=t.getCustomData()[0].getValue();s.URLHelper.redirect(o,true)},_syncModelWithNewsInfo:function(){var e=o.getPreparationFailureMessage();if(!e){this._oModel.setProperty("/new",o.getNewNewsArray().slice());this._oModel.setProperty("/old",o.getOldNewsArray().slice())}this._oModel.setProperty("/preparationFailureMessage",e)},_onMatched:function(){try{this.hideMasterSide()}catch(e){}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/NotFound.controller", ["./BaseController"],function(e){"use strict";return e.extend("sap.ui.documentation.sdk.controller.NotFound",{})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/ReleaseNotes.controller", ["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/library","sap/base/util/Version","sap/base/Log","sap/ui/documentation/sdk/util/Resources"],function(jQuery,e,s,o,i,t,n){"use strict";var r=n.getResourceOriginPath("neo-app.json"),a=n.getResourceOriginPath("resources/sap-ui-version.json");return e.extend("sap.ui.documentation.sdk.controller.ReleaseNotes",{onInit:function(){this._oView=this.getView();this._requestResources();this._resourceAvailabilityHandler();this._oModel=new s;this._oVersionModel=new s;this._oView.setModel(this._oModel);this._oView.setModel(this._oVersionModel,"select");o._getAppInfo(this._processAppInfo.bind(this))},_processAppInfo:function(e){var s,o,t,n,r;if(!e){return}s=i(e.version);o=s.getMajor();t=s.getMinor();if(s.getSuffix()!==""){if(t%2!==0){t=t+1}}n=o+"."+t;this._updateVersionInformation(n);r={items:[]};while(t>=28){n=o+"."+t;r.items.push({key:n,value:n});t=t-(t<=60?2:1)}this._oVersionModel.setData(r);this.appendPageTitle(this.getModel("i18n").getProperty("RELEASE_NOTES_TITLE"))},_processLibInfo:function(e,s){var o,t=[],n=e.length,r,a;r=function(s,t){o+=t.notes.length;e[a].versions.push({version:s,notes:t.notes});e[a].versions.sort(function(e,s){return i(s.version).compareTo(e.version)})};for(a=0;a<n;a++){e[a]=s[e[a]];e[a].versions=[];if(e[a].relnotes){o=0;jQuery.each(e[a].relnotes,r);if(o>0){t.push(e[a])}}}this._oModel.setData({libs:t});this._hideBusyIndicator()},_requestResources:function(){this._oNeoAppJsonPromise=jQuery.ajax(r);this._oSapUiVersionJsonPromise=jQuery.ajax(a)},_resourceAvailabilityHandler:function(){jQuery.when(this._oNeoAppJsonPromise,this._oSapUiVersionJsonPromise).then(function(e,s){this._oNeoAppVersions=e[0].routes;this._sSapUiVersion=s[0].version;this._oView.byId("VersionSelect").setVisible(true)}.bind(this),function(){t.warning("No neo-app.json was detected")})},_compareUI5Versions:function(e,s){var o=i(e),t=i(s);return o.getMajor()+"."+o.getMinor()===t.getMajor()+"."+t.getMinor()},_updateLastReleasedVersion:function(e){if(this._compareUI5Versions(e,this._sSapUiVersion)&&parseFloat(this._sLastReleasedVersion)>parseFloat(this._sSapUiVersion)){this._sLastReleasedVersion=this._sSapUiVersion}},_getLastVersionFromNeoAppJson:function(e){var s=this._oNeoAppVersions?this._oNeoAppVersions.length:0,o,i;for(i=0;i<s;i++){o=this._oNeoAppVersions[i].target.version;if(this._compareUI5Versions(o,e)){return o}}},handleVersionChange:function(e){var s=e.getParameter("selectedItem"),o=s.getKey();this._updateVersionInformation(o)},_updateVersionInformation:function(e){var s;this._sLastReleasedVersion=this._getLastVersionFromNeoAppJson(e);this._updateLastReleasedVersion(e);s=this._sLastReleasedVersion?this._sLastReleasedVersion:e;this._showBusyIndicator();o._loadAllLibInfo("","_getLibraryInfoAndReleaseNotes",s,this._processLibInfo.bind(this))},_showBusyIndicator:function(){this.byId("releaseNotesObjectPage").setBusy(true)},_hideBusyIndicator:function(){this.byId("releaseNotesObjectPage").setBusy(false)}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Sample.controller", ["sap/ui/documentation/sdk/controller/SampleBaseController","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/m/BusyDialog","sap/m/Text","sap/ui/core/HTML","sap/m/library","sap/base/Log","sap/ui/core/Core","sap/ui/core/Fragment","sap/ui/documentation/sdk/util/Resources","./config/sampleForwardingConfig","sap/base/strings/capitalize","sap/ui/core/Configuration"],function(e,t,i,n,s,o,a,r,l,h,d,m,u,p,c,g,f,_){"use strict";var I=d.URLHelper;var S=["sap-ui-rtl","sap-ui-language"];return e.extend("sap.ui.documentation.sdk.controller.Sample",{onInit:function(){var i=_;e.prototype.onInit.call(this);this.oRouter=this.getRouter();this._attachPaternMatched();this.oModel=new t({showNavButton:true,showNewTab:false,rtaLoaded:false,density:this.getOwnerComponent().getContentDensityClass(),rtl:i.getRTL(),theme:i.getTheme(),showWarning:false});this._sId=null;this._sEntityId=null;this.getView().setModel(this.oModel);this.bus=u.getEventBus();this.setDefaultSampleTheme();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this);this.getOwnerComponent()._sSampleIframeOrigin=c.getConfig()!=="."?c.getResourceOrigin():window.origin},_attachPaternMatched:function(){this.oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this)},_onSampleMatched:function(e){var t=new URLSearchParams(window.location.search).has("dk-sample-standalone");this._sId=e.getParameter("arguments").sampleId;this._sEntityId=e.getParameter("arguments").entityId;this.byId("page").setBusy(true);if(t){this._handleRedirect()}if(g[this._sId]){return this.oRouter.navTo("sample",{entityId:g[this._sId].entityId,sampleId:g[this._sId].sampleId},true)}this.getModel("appView").setProperty("/bHasMaster",false);o.loadData().then(this._loadSample.bind(this))},_loadSample:function(e){var t=this._getPage(),i=this.oModel.getData(),n=e.samples[this._sId],s;if(!n){setTimeout(function(){t.setBusy(false)},0);this.onRouteNotFound();return}this.entityId=this._sEntityId?this._sEntityId:n.entityId;this._sLib=n.library;i.sEntityId=this.entityId;if(n.previousSampleId||n.nextSampleId){i.previousSampleId=n.previousSampleId;i.nextSampleId=n.nextSampleId}if(n.contexts){s=n.contexts[this.entityId];if(s){i.previousSampleId=s.previousSampleId;i.nextSampleId=s.nextSampleId}else{this.onRouteNotFound();return}}i.title="Sample: "+n.name;i.showNewTab=true;i.id=n.id;i.name=n.name;i.details=n.details;i.description=n.description;i.showSettings=true;var o=this._getChangedSamplesLocalStorage();if(o&&JSON.parse(o).indexOf(n.id)>-1){i.showWarning=true}else{i.showWarning=false}this._createIframe().then(function(e){this.getOwnerComponent()._oCurrentOpenedSample=this._oHtmlControl;if(e){i.stretch=e.stretch;i.includeInDownload=e.additionalDownloadFiles;i.customIndexHTML=e.customIndexHTML;if(e.files){var s=sap.ui.require.toUrl(n.id.replace(/\./g,"/"));i.files=[];for(var o=0;o<e.files.length;o++){var a=e.files[o];i.files.push({name:a});this._updateFileContent(s,a)}}i.iframe=e.iframe||null;t.setProperty("enableScrolling",!!e.stretch,true)}this.getAPIReferenceCheckPromise(n.entityId).then(function(e){this.getView().byId("apiRefButton").setVisible(e)}.bind(this));this.oModel.setData(i);this.appendPageTitle(this.getModel().getProperty("/name"))}.bind(this)).catch(function(e){t.removeAllContent();t.addContent(new l({text:"Error while loading the sample: "+e}))}).finally(function(){setTimeout(function(){t.setBusy(false)},0)})},_handleRedirect:function(){this._initIframeURL();this._applySearchParamValueToIframeURL("sap-ui-theme",this._sDefaultSampleTheme);this.sIFrameUrl+="&dk-sample-standalone";I.redirect(this.sIFrameUrl,false)},_initIframeURL:function(){var e=c.getConfig(),t=c.getResourcesVersion(),i="";S.forEach(function(e,t){if(new URL(document.location.href).searchParams.get(e)){i+=(i===""?"?":"&")+e+"="+new URL(document.location.href).searchParams.get(e)}});i=(i===""?"?":i+"&")+"sap-ui-xx-sample-id="+this._sId+"&sap-ui-xx-sample-lib="+(this._sLib||"")+"&sap-ui-xx-sample-origin="+e+t+"&sap-ui-xx-dk-origin="+window.location.origin;this.sIFrameUrl=c.getResourceOrigin()+"/resources/sap/ui/documentation/sdk/index.html"+i},getSettingsDialog:function(){return new Promise(function(e,t){if(!this._oSettingsDialog){p.load({id:"sample",name:"sap.ui.documentation.sdk.view.appSettingsDialog",controller:this}).then(function(t){this._oSettingsDialog=t;this._oSettingsDialog.setModel(this._oMessageBundle,"i18n");e(this._oSettingsDialog)}.bind(this))}else{e(this._oSettingsDialog)}}.bind(this))},_getChangedSamplesLocalStorage:function(){return localStorage.getItem("dk_changed_samples")},_setChangedSamplesLocalStorage:function(e){localStorage.setItem("dk_changed_samples",e)},handleSettings:function(){if(!this._oMessageBundle){this._oMessageBundle=new i({bundleName:"sap.ui.documentation.messagebundle"})}this.getSettingsDialog().then(function(e){this.loadSampleSettings(this.applySampleSettings.bind(this));return e}.bind(this)).then(function(e){e.open()}).catch(function(e){m.error(e)})},applySampleSettings:function(e){if(e.data.type==="SETTINGS"){var t=u.byId("sample--ThemeSelect");t.setSelectedKey(e.data.data.theme);u.byId("sample--RTLSwitch").setState(e.data.data.RTL);u.byId("sample--DensityModeSwitch").setSelectedKey(this._presetDensity(e.data.data.density,true))}},loadSampleSettings:function(e){return new Promise(function(t,i){var n=this._oHtmlControl.getDomRef();n.contentWindow.postMessage({type:"SETTINGS",reason:"get"},this.getOwnerComponent()._sSampleIframeOrigin);window.addEventListener("message",s);function s(i){e(i);window.removeEventListener("message",s);t()}setTimeout(function(){i("The sample iframe is not loading settings")},3e3)}.bind(this))},handleCloseAppSettings:function(){this._oSettingsDialog.close()},handleSaveAppSettings:function(){var e=u.byId("sample--DensityModeSwitch").getSelectedKey(),t=u.byId("sample--ThemeSelect").getSelectedKey(),i=u.byId("sample--RTLSwitch").getState();this._oSettingsDialog.close();if(!this._oBusyDialog){this._oBusyDialog=new r;this._handleBusyDialog()}else{this._handleBusyDialog()}this._applyAppConfiguration(t,e,i);this._saveLocalSettings(t,e,i)},_saveLocalSettings:function(e,t,i){t=this._presetDensity(t);this.oModel.setData({theme:e,rtl:i,density:t},true)},_presetDensity:function(e,t){return t?e.slice(9).toLowerCase():"sapUiSize"+f(e)},_applyAppConfiguration:function(e,t,i){var n=this._oHtmlControl.getDomRef();t=this._presetDensity(t);n.contentWindow.postMessage({type:"SETTINGS",reason:"set",data:{density:t,RTL:i,theme:e}},this.getOwnerComponent()._sSampleIframeOrigin)},_handleBusyDialog:function(){this._oBusyDialog.open();setTimeout(function(){this._oBusyDialog.close()}.bind(this),1e3)},_updateFileContent:function(e,t,i){this.fetchSourceFile(e+"/"+t,undefined,i).then(function(e){var i=this.oModel.getProperty("/files");i.some(function(i){if(i.name===t){i.raw=e;return true}});this.oModel.setProperty("/files",i)}.bind(this))},onAPIRefPress:function(){this.oRouter.navTo("apiId",{id:this.entityId})},onNewTab:function(){if(this.oModel.getProperty("/iframe")){I.redirect(this.sIFrameUrl,true);return}this.loadSampleSettings(function(e){this._applySearchParamValueToIframeURL("sap-ui-theme",e.data.data.theme);this._applySearchParamValueToIframeURL("sap-ui-rtl",e.data.data.RTL);this._applySearchParamValueToIframeURL("sap-ui-density",e.data.data.density)}.bind(this)).then(function(){I.redirect(this.sIFrameUrl,true)}.bind(this)).catch(function(e){m.error(e)})},onPreviousSample:function(e){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/previousSampleId")})},onNextSample:function(e){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/nextSampleId")})},onInfoSample:function(e){var t=e.getSource();if(!this._oPopover){p.load({name:"sap.ui.documentation.sdk.view.samplesInfo",controller:this}).then(function(e){this.getView().addDependent(e);this._oPopover=e;this._oPopover.openBy(t)}.bind(this))}else{this._oPopover.openBy(t)}},onWarningSample:function(e){var t=e.getSource();if(!this._oWarningPopover){p.load({name:"sap.ui.documentation.sdk.view.samplesWarning",controller:this}).then(function(e){this.getView().addDependent(e);this._oWarningPopover=e;this._oWarningPopover.openBy(t)}.bind(this))}else{this._oWarningPopover.openBy(t)}},_resolveIframePath:function(e,t){var i=t.split("/"),n;for(n=0;n<i.length-1;n++){if(i[n]==".."){e=e.substring(0,e.lastIndexOf("."))}else{e+="."+i[n]}}return e},_createIframe:function(){return new Promise(function(e,t){this.fResolve=e;this.fReject=t;this._initIframeURL();if(this._oHtmlControl){this._oHtmlControl.destroy()}this._oHtmlControl=this._createHTMLControl().addEventDelegate({onBeforeRendering:function(){window.removeEventListener("message",this.onMessage.bind(this))}.bind(this)}).addEventDelegate({onAfterRendering:function(){window.addEventListener("message",this.onMessage.bind(this))}.bind(this)});this._getPage().removeAllContent();this._getPage().addContent(this._oHtmlControl)}.bind(this))},_createHTMLControl:function(){return new h({id:"sampleFrame",content:'<iframe src="'+this.sIFrameUrl+'" id="sampleFrame" frameBorder="0"></iframe>'})},_getPage:function(){return this.byId("page")},onMessage:function(e){if(e.origin!==this.getOwnerComponent()._sSampleIframeOrigin){return}if(e.source!==this._oHtmlControl.getDomRef().contentWindow){return}if(e.data.type==="INIT"){this.fnMessageInit(e)}else if(e.data.type==="ERR"){this.fnMessageError(e)}else if(e.data.type==="LOAD"){this.fnMessageLoad(e)}else if(e.data.type==="RTA"){this._loadRTA.call(this)}},fnMessageInit:function(e){var t,i="",n=/\/([^\/]*)$/,s=/\..+$/,o,a,r,l,h=this.oModel.getData();if(e.data.config&&e.data.config.sample&&e.data.config.sample.iframe){t=this._sId;l=e.data.config.sample.iframe;i=this._resolveIframePath(t,l);o=n.exec(l);a=o&&o.length>1?o[1]:l;r=s.exec(a)[0];var d=a.replace(s,"");this.sIFrameUrl=(sap.ui.require.toUrl((i+"/"+d).replace(/\./g,"/"))+r||".html")+"?sap-ui-theme="+_.getTheme();this._oHtmlControl.getDomRef().src=this.sIFrameUrl}this._oHtmlControl.getDomRef().contentWindow.postMessage({type:"SETTINGS",reason:"set",data:{density:h.density,RTL:h.rtl,theme:h.theme}},this.getOwnerComponent()._sSampleIframeOrigin);this.fResolve(e.data.config.sample)},fnMessageLoad:function(){m.info("Sample Iframe for sample "+this._sId+" is loaded")},fnMessageError:function(e){this.fReject(e.data.data.msg)},_createComponent:function(){var e="sampleComp-"+this._sId;var t=this._sId;var i=this.getOwnerComponent();var o=n.getComponentById(e);if(o){o.destroy()}return i.runAsOwner(function(){return n.create({id:e,name:t}).then(function(e){return new s({component:e})})})},setDefaultSampleTheme:function(){var e=c.getResourcesVersion();this._sDefaultSampleTheme=e&&parseInt(e.slice(3,5))<68?"sap_belize":_.getTheme()},onDemoKitThemeChanged:function(e,t,i){if(this._oHtmlControl&&this.getModel().getProperty("/iframe")){this._applySearchParamValueToIframeURL("sap-ui-theme",i.sThemeActive);this._oHtmlControl.getDomRef().src=this.sIFrameUrl}},onNavBack:function(e){this.oRouter.navTo("entity",{id:this.entityId})},onNavToCode:function(e){this.oRouter.navTo("code",{entityId:this.entityId,sampleId:this._sId},false)},onToggleFullScreen:function(e){a.updateMode(e,this.getView(),this)},_oRTA:null,_applySearchParamValueToIframeURL:function(e,t){var i=window.URL,n;try{n=new i(this.sIFrameUrl,document.location)}catch(e){m.warning("window.URL is not supported. The search param value won't be applied.");return}this.sIFrameUrl=this.sIFrameUrl.replace(n.search,"");n.searchParams.set(e,t);this.sIFrameUrl=this.sIFrameUrl+decodeURI(n.search)},_loadRTA:function(){var e=this.oModel.getData();e.rtaLoaded=true;this.oModel.setData(e,true);this.oRouter.attachRouteMatched(function(){if(this._oRTA){this._oRTA.destroy();this._oRTA=null}},this)},onToggleAdaptationMode:function(e){if(!this._oHtmlControl||!this._oHtmlControl.getDomRef()){return false}var t=this._oHtmlControl.getDomRef();t.contentWindow.postMessage({type:"RTA",data:{msg:"Start the RTA"}},this.getOwnerComponent()._sSampleIframeOrigin)},onRouteNotFound:function(){var e=this.getModel("i18n").getProperty("NOT_FOUND_SAMPLE_TITLE");this.oRouter.myNavToWithoutHash("sap.ui.documentation.sdk.view.SampleNotFound","XML",false);setTimeout(this.appendPageTitle.bind(this,e));return}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/SampleBaseController", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/thirdparty/URI","sap/base/Log","sap/ui/documentation/sdk/controller/util/ResourceDownloadUtil","sap/ui/documentation/sdk/util/Resources"],function(e,t,i,n,r){"use strict";var a=sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl"),o=sap.ui.require.toUrl("sap/ui/demo/mock");return e.extend("sap.ui.documentation.sdk.controller.SampleBaseController",{_aMockFiles:["products.json","supplier.json","img.json"],fetchSourceFile:function(e,t,r){return n.fetch(e,t,r).catch(function(e){i.warning(e);return"File not loaded"})},onDownload:function(){sap.ui.require(["sap/ui/thirdparty/jszip"],function(e){var t=new e,i=r.getResourceOriginPath(sap.ui.require.toUrl(this._sId.replace(/\./g,"/"))),n=this.oModel.getData(),s=n.includeInDownload||[],l,u,p=n.customIndexHTML,c=n.files.find(function(e){return e.name.includes("package.json")}),m=n.files.find(function(e){return e.name.includes("ui5.yaml")}),h=[],f=function(e){var i=[];for(var n=0;n<this._aMockFiles.length;n++){var r=this._aMockFiles[n];if(typeof e==="string"&&e.indexOf(r)>-1){i.push(this._addFileToZip({name:this._formatWebAppPath("mockdata/"+r),url:o+"/"+r,formatter:this._formatMockFile},t))}}return Promise.all(i)};for(var d=0;d<n.files.length;d++){var g=n.files[d],_=i+"/"+g.name,I=g.name&&(g.name===n.iframe||g.name.split(".").pop()==="html");if(g.name==="manifest.json"){l=JSON.parse(g.raw);h.push(this._addFileToZip({name:this._formatWebAppPath(g.name),url:_,formatter:this._formatManifestJsFile},t));continue}else if(this._isRootLevelFile(g.name)){continue}else{h.push(this._addFileToZip({name:this._formatWebAppPath(g.name.replace(new RegExp(/(\.\.\/)+/g),"./")),url:_,formatter:I&&!p?this._rewriteRelativeURLs.bind(this):undefined},t));h.push(this.fetchSourceFile(_).then(f.bind(this)))}}if(!n.iframe||r.getHasProxy()){u=n.files.some(function(e){return e.name==="manifest.json"});h.push(this._addFileToZip({name:this._formatWebAppPath("Component.js"),url:i+"/"+"Component.js"},t));if(!p){var v=this._formatWebAppPath("index.html");h.push(this._addFileToZip({name:v,url:a+"/"+(u?"indexevo.html.tmpl":"index.html.tmpl"),formatter:function(e){return this._rewriteRelativeURLs(this._formatIndexHtmlFile(e,n,l),v)}.bind(this)},t,true))}if(!u){var b=this._formatWebAppPath("index.js");h.push(this._addFileToZip({name:b,url:a+"/"+"index.js.tmpl",formatter:function(e){return this._rewriteRelativeURLs(this._formatIndexJsFile(e,n),b)}.bind(this)},t,true))}}s.forEach(function(e){h.push(this._addFileToZip({name:this._formatWebAppPath(e),url:i+"/"+e},t))}.bind(this));
// add generic license file
h.push(this._addFileToZip({name:"LICENSE.txt",url:"LICENSE.txt"},t));h.push(this._addFileToZip({name:"ui5.yaml",url:m?i+"/"+m.name:a+"/ui5.yaml.tmpl",formatter:function(e){return m?this._formatCustomUI5Yaml(e):this._formatUI5Yaml(e,n,l)}.bind(this)},t,true));h.push(this._addFileToZip({name:"package.json",url:c?i+"/"+c.name:a+"/package.json.tmpl",formatter:function(e){return c?e:this._formatPackageJson(e,n)}.bind(this)},t,true));Promise.all(h).then(function(){var e=t.generate({type:"blob"});this._openGeneratedFile(e,this._sId)}.bind(this))}.bind(this))},_openGeneratedFile:function(e,t){sap.ui.require(["sap/ui/core/util/File"],function(i){i.save(e,t,"zip","application/zip")})},_addFileToZip:function(e,t,i){var n=e.name.replace(new RegExp(/(\.+\/)+/g),""),r=e.url,a=e.formatter;return this.fetchSourceFile(r,i).then(function(e){if(e==="File not loaded"){return;// ignore 404 responses, e.g. for Apache license text file in SAPUI5 environment
}if(a){e=a(e,n)}t.file(n,e)})},_formatNameToNpmSpec:function(e){var t;var i=/[^\w_\-\.]+/gi;e=e.replace(i,"").replaceAll(".","-");t=e.split(/(?=[A-Z])/);return t.map(function(e){return e.toLowerCase()}).join("-")},_formatPackageJson:function(e,t){var i=e.replace(/{{TITLE}}/g,t.title).replace(/{{SAMPLE_ID}}/g,this._formatNameToNpmSpec(t.id)),n=JSON.parse(i);return JSON.stringify(n,null,2)},_formatUI5Yaml:function(e,t,i){let n=e.replace(/{{SAMPLE_ID}}/g,this._formatNameToNpmSpec(t.id));const r=this.getModel("versionData").getProperty("/isOpenUI5");const a=this.getModel("versionData").getProperty("/fullVersion");n=n.replace(/{{UI5_KIND}}/g,r?"OpenUI5":"SAPUI5");n=n.replace(/{{UI5_VERSION}}/g,a);if(this._isOpenUI5NightlySDK()){n=n.replace(/libraries:/g,"libraries:"+this._getSnapshotNote())}if(i){const e=i["sap.ui5"];const t=e&&e.dependencies;if(t&&t.libs){Object.keys(t.libs).forEach(function(e){n+="\n    - name: "+e})}}return n},_formatCustomUI5Yaml:function(e){const t=this._isOpenUI5NightlySDK()?this._getSnapshotNote():"";return e.replace(/ #MainVersion#/g,t)},_formatManifestJsFile:function(e){return e.replace(new RegExp(/(\.\.\/)+/g),"./")},_formatIndexHtmlFile:function(e,t,i){let n=e.replace(/{{TITLE}}/g,t.name).replace(/{{SAMPLE_ID}}/g,t.id);if(i){const e=i["sap.ui5"];const t=e&&e.dependencies;if(t&&t.libs&&t.libs["sap.ui.fl"]){n=n.replace(/<script id="sap-ui-bootstrap"/g,'<script id="sap-ui-bootstrap"\n\t\tdata-sap-ui-flexibilityServices=\'[{"connector": "LocalStorageConnector"}]\'')}}return n},_formatIndexJsFile:function(e,t){return e.replace(/{{TITLE}}/g,t.name).replace(/{{SAMPLE_ID}}/g,t.id).replace(/{{HEIGHT}}/g,t.stretch?'height : "100%", ':"").replace(/{{SCROLLING}}/g,!t.stretch)},_formatMockFile:function(e){var t="test-resources/sap/ui/documentation/sdk/images/",i="https://sdk.openui5.org/test-resources/sap/ui/documentation/sdk/images/",n=new RegExp(t,"g");return e.replace(n,i)},_rewriteRelativeURLs:function(e,t){const i=/(['"])(?:[a-zA-Z0-9./])*(resources|test-resources)\//g;const n=this._getRelativePathToRoot(t);return e.replaceAll(i,"$1"+n+"$2/")},_getRelativePathToRoot:function(e){const t=e.split("/").length-2;return"../".repeat(t)},_formatWebAppPath:function(e){const t="webapp/";return e.startsWith(t)?e:t+e},_isRootLevelFile:function(e){return["package.json","ui5.yaml"].includes(e)},_isOpenUI5NightlySDK:function(){const e=this.getModel("versionData"),t=e.getProperty("/isDevVersion"),i=e.getProperty("/isDevEnv"),n=e.getProperty("/isOpenUI5");return t&&n&&!i},_getSnapshotNote:function(){return"\n  # Note: Consumption of SNAPSHOT versions is only available to SAP employees from within the corporate network.\n"+"  # If this does not apply to you, please adjust the UI5 version to the latest stable version either manually\n"+'  # or using the command "ui5 use latest".'}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/SampleNotFound.controller", ["./BaseController"],function(e){"use strict";return e.extend("sap.ui.documentation.sdk.controller.SampleNotFound",{})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/SearchPage.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/model/json/JSONModel","sap/m/GroupHeaderListItem","sap/base/Log"],function(e,t,r,i,a,s){"use strict";return e.extend("sap.ui.documentation.sdk.controller.SearchPage",{onInit:function(){this.setModel(new i,"searchView");this.getRouter().getRoute("search").attachPatternMatched(this._onTopicMatched,this)},onAfterRendering:function(){var e={useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false};if(!this.highlighter){this.highlighter=new r(this.getView().getDomRef(),e)}},onExit:function(){this.highlighter.destroy()},_onTopicMatched:function(e){var r=decodeURIComponent(e.getParameter("arguments").searchParam),i=e.getParameter("arguments")["?options"],a=i&&i.category,o=this.byId("allList"),n=this._findSectionForCategory(a),c=n?n.getId():null,h=this.getModel("searchView").getProperty("/lastProcessedQuery"),l="";try{this.hideMasterSide()}catch(e){s.error(e)}if(r===h){this.getView().byId("searchPage").setSelectedSection(c);this._modifyLinks();return}this.getModel("searchData").setProperty("/query",r);o.setBusy(true);t.search(r,{includeDeprecated:this.getModel("searchData").getProperty("/includeDeprecated")}).then(function(e){this.getModel("searchView").setProperty("/lastProcessedQuery",r);this.getModel("searchData").setProperty("/matches",e.matches);this.getView().byId("searchPage").setSelectedSection(c);o.setBusy(false)}.bind(this));if(this.highlighter){this.highlighter.highlight(r)}l=this.getModel("i18n").getResourceBundle().getText("SEARCH_PAGE_TITLE",[r]);this.appendPageTitle(l)},formatTableTitle:function(e,t,r){var i=r>0?"1 - "+t:"0";return this.formatMessage(e,i,r)},onDeprecatedFlagChange:function(e){var r=e.getParameter("selected"),i=this.getModel("searchData").getProperty("/query");t.search(i,{includeDeprecated:r}).then(function(e){this.getModel("searchData").setProperty("/matches",e.matches)}.bind(this))},_findSectionForCategory:function(e){var t=this.getView().byId("searchPage").getSections().filter(function(t){return t.data("category")==e});return t.length&&t[0]},_modifyLinks:function(e){var t=this.getView(),r=[].concat(t.byId("allList").getItems(),t.byId("apiList").getItems(),t.byId("documentationList").getItems(),t.byId("samplesList").getItems()),i=r.length,a,s,o,n="_self",c,h=true;while(i--){a=r[i];if(a._getLinkSender){s=this.loadSearchResultLink(a,h);if(e){o=a.getCustomData()[0].getValue();c=a.getCustomData()[1].getValue();if(c){o=new URL(o,document.baseURI).href;n="_blank"}s.setHref(o);s.setTarget(n)}}}},loadSearchResultLink:function(e,t){var r;if(!e._getLinkSender){return null}if(t){r=!!e.getText()}return e._getLinkSender(r)},getGroupHeader:function(e){return new a({title:e.key,upperCase:false})},categoryAPIFormatter:function(e){return e==="API Reference"},categoryDocFormatter:function(e){return e==="Documentation"},categoryExploredFormatter:function(e){return e==="Samples"},onAllLoadMore:function(e){this.getModel("searchView").setProperty("/visibleAllLength",e.getParameter("actual"));this._modifyLinks(true)},onAPILoadMore:function(e){this.getModel("searchView").setProperty("/visibleAPILength",e.getParameter("actual"));this._modifyLinks(true)},onDocLoadMore:function(e){this.getModel("searchView").setProperty("/visibleDocLength",e.getParameter("actual"));this._modifyLinks(true)},onExploredLoadMore:function(e){this.getModel("searchView").setProperty("/visibleExploredLength",e.getParameter("actual"));this._modifyLinks(true)},onSwitchTab:function(e){var t=e.getParameter("section").data("category"),r={searchParam:this.getModel("searchView").getProperty("/lastProcessedQuery")};if(t){r["?options"]={category:t}}this.getRouter().navTo("search",r)}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Sitemap.controller", ["./BaseController","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/controller/util/DocuInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/ToolsInfo","sap/ui/documentation/sdk/model/libraryData"],function(t,e,o,a,n,i,s){"use strict";var r={API:"api",TOPIC:"topic",TOOLS:"tools",ENTITY:"entity",DEMO_APPS:"demoApps"};var u={};u[r.API]={getData:e.getIndexJsonPromise,formatNode:function(t){return{name:t.name,href:r.API+"/"+t.name,hidden:t.visibility!=="public"}}};u[r.TOPIC]={getData:function(t){return o.getDocuIndexPromise(t)},formatNode:function(t){return{name:t.text,href:r.TOPIC+"/"+t.key}}};u[r.ENTITY]={getData:n.loadData,formatNode:function(t){return{name:t.id,href:r.ENTITY+"/"+t.id}}};u[r.DEMO_APPS]={getData:s.getDemoAppsData,formatNode:function(t){return{name:t.name,href:t.ref}}};u[r.TOOLS]={getData:i.getToolsConfig,formatNode:function(t){return{name:t.text,href:t.href,hidden:!t.href}}};function d(t,e){var o=[],a,n;for(var i=0;i<t.length;i++){a=t[i];n=u[e].formatNode(a);if(n.hidden!==true){o.push(n)}}return o}return t.extend("sap.ui.documentation.sdk.controller.Sitemap",{onInit:function(){this.oPage=this.byId("sitemapPage");this.oModel=new a;this.getView().setModel(this.oModel);this._oData={};this.getRouter().getRoute("sitemap").attachPatternMatched(this._onMatched,this)},_onMatched:function(){this.hideMasterSide();this.oPage.setBusy(true);this._loadResources().then(function(){this.oPage.setBusy(false);this.oModel.setData(this._oData)}.bind(this)).catch(function(){this.onRouteNotFound()}.bind(this));this.appendPageTitle(this.getModel("i18n").getProperty("SITEMAP_TITLE"))},_loadResources:function(){var t=Object.keys(r).map(function(t){var e=r[t];return u[e].getData(this.getConfig()).then(function(t){this._onDataLoaded({data:t,type:e})}.bind(this))},this);return Promise.all(t)},_onDataLoaded:function(t){switch(t.type){case r.API:this._onApiRefData(t.data);break;case r.TOPIC:this._onTopicsData(t.data);break;case r.ENTITY:this._onSamplesData(t.data);break;case r.DEMO_APPS:this._onDemoAppsData(t.data);break;case r.TOOLS:this._onToolsData(t.data);break}},_getDocuIndexPromise:function(){return o.getDocuIndexPromise(this.getConfig())},_onApiRefData:function(t){var e=r.API,o;o=t.reduce(function(t,o){if(o.visibility==="public"&&o.nodes){return t.concat(d(o.nodes,e))}return t},[]);this._oData[e]=o},_onTopicsData:function(t){var e=r.TOPIC;this._oData[e]=d(t,e)},_onSamplesData:function(t){var e=r.ENTITY;this._oData[e]=d(t.entities,e)},_onDemoAppsData:function(t){var e=r.DEMO_APPS;this._oData[e]=d(t.demoApps,e)},_onToolsData:function(t){var e=r.TOOLS;this._oData[e]=d(t,e)},onNavButtonPress:function(){this.getRouter().myNavBack("welcome")}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/SubApiDetail.controller", ["sap/ui/thirdparty/jquery","sap/ui/core/Fragment","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/model/formatter","sap/m/Image","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute","sap/m/ObjectStatus","sap/m/Popover","sap/m/library","sap/ui/core/library","sap/m/CustomListItem","sap/m/List","sap/ui/dom/includeStylesheet","sap/ui/dom/includeScript"],function(jQuery,t,e,i,o,s,n,r,a,l,c,h,u,d,p,g,_,f,m){"use strict";var y=d.FlexWrap;var b=p.ValueState;return e.extend("sap.ui.documentation.sdk.controller.SubApiDetail",{NOT_AVAILABLE:"N/A",PUBLIC_GITHUB_FRAMEWORK_DOMAIN:"https://github.com/SAP/openui5/blob/master/src/",SECTION_MAP:{properties:"controlProperties",fields:"properties","special settings":"specialsettings"},EXTERNAL_BASE_TYPES:["Date","Object"],formatter:o,onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");if(!window.hljs){f("resources/sap/ui/documentation/sdk/thirdparty/highlight.js/styles.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/highlight.js/highlight.js"})}},initiate:function(t){var e,i,o,s=function(t){return!t.borrowedFrom};this._sTopicId=t.sTopicId;this._oModel=t.oModel;this._oControlData=this._oModel.getData();this._aApiIndex=t.aApiIndex;this._aAllowedMembers=t.aAllowedMembers;this._sEntityType=t.sEntityType;this._sEntityId=t.sEntityId!=="undefined"?t.sEntityId:undefined;this._oEntityData=t.oEntityData;this._oContainerController=t.oContainerController;this._oContainerView=t.oContainerView;this._oToggleFullScreenBtn=this.byId("toggleFullScreenBtn");this.getOwnerComponent=function(){return t.oOwnerComponent};this._oRouter=this.getRouter();this._allProperties=this._oModel.getProperty("/ui5-metadata/properties");this._allAggregations=this._oModel.getProperty("/ui5-metadata/aggregations");this._allAssociations=this._oModel.getProperty("/ui5-metadata/associations");if(this._allProperties){this._selfProperties=this._allProperties.filter(s);e=this._selfProperties.length>0;this._oModel.setProperty("/bShowBorrowedProps",!e);this._oModel.setProperty("/bHasSelfProps",e);this._oModel.setProperty("/bHasBorrowedProps",this._allProperties.length>this._selfProperties.length);this._oModel.setProperty("/ui5-metadata/properties",e?this._selfProperties:this._allProperties)}if(this._allAggregations){this._selfAggregations=this._allAggregations.filter(s);i=this._selfAggregations.length>0;this._oModel.setProperty("/bShowBorrowedAggr",!i);this._oModel.setProperty("/bHasSelfAggr",i);this._oModel.setProperty("/bHasBorrowedAggr",this._allAggregations.length>this._selfAggregations.length);this._oModel.setProperty("/ui5-metadata/aggregations",i?this._selfAggregations:this._allAggregations)}if(this._allAssociations){this._selfAssociations=this._allAssociations.filter(s);o=this._selfAssociations.length>0;this._oModel.setProperty("/bShowBorrowedAssoc",!o);this._oModel.setProperty("/bHasSelfAssoc",o);this._oModel.setProperty("/bHasBorrowedAssoc",this._allAssociations.length>this._selfAssociations.length);this._oModel.setProperty("/ui5-metadata/associations",o?this._selfAssociations:this._allAssociations)}if(this._oModel.getProperty("/hasFAQ")){var n=this._oEntityData.lib,r=n.replace(/\./g,"/"),a=this._oEntityData.name.replace(n,"").replace(/^[.]/,"").replace(/\./g,"/")+".html";jQuery.ajax({type:"GET",url:"./docs/api/"+r+"/demokit/faq/"+a,success:function(t){this._oModel.setProperty("/faqContent",t)}.bind(this)})}this.setModel(this._oModel);this._oEntityData.appComponent=this._oControlData.component||this.NOT_AVAILABLE;this._oEntityData.hasSample=this._oControlData.hasSample;this._oEntityData.sample=this._oControlData.hasSample?this._sTopicId:this.NOT_AVAILABLE;this._buildHeaderLayout(this._oControlData,this._oEntityData);setTimeout(function(){this._hljs();this._objectPage.attachEvent("subSectionEnteredViewPort",function(){if(this._sHljsDelayedCallID){clearTimeout(this._sHljsDelayedCallID)}this._sHljsDelayedCallID=setTimeout(function(){var t=this._objectPage.$().find("pre:not(.hljs)");if(t.length>0&&window.hljs){t.addClass("hljs");document.querySelectorAll("pre").forEach(function(t){window.hljs.highlightBlock(t)})}}.bind(this),200)},this);setTimeout(function(){if(this._sEntityType){this.scrollToEntity(this._sEntityType,this._sEntityId)}setTimeout(function(){this._objectPage.attachEvent("_sectionChange",function(t){var e=t.getParameter("section"),i=t.getParameter("subSection");if(this._oNavigatingTo){if(this._oNavigatingTo===i){this._oNavigatingTo=null}return}this._modifyURL(e,i,false)},this);this._objectPage.attachEvent("navigate",function(t){var e=t.getParameter("section"),i=t.getParameter("subSection");this._oNavigatingTo=i;this._modifyURL(e,i,true)},this)}.bind(this),500)}.bind(this),1e3)}.bind(this),0);this.searchResultsButtonVisibilitySwitch(this.byId("apiDetailBackToSearch"));this.appendPageTitle(this._oModel.getProperty("/displayName"))},onAfterRendering:function(){this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);i.updateControl(this._oToggleFullScreenBtn,this._oContainerView,this._oContainerController)},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this)},onToggleFullScreen:function(t){i.updateMode(t,this._oContainerView,this._oContainerController)},onBorrowedPropCheckboxClick:function(t){var e=t.getParameter("selected");this._oModel.setProperty("/bShowBorrowedProps",e);this._oModel.setProperty("/ui5-metadata/properties",e?this._allProperties:this._selfProperties)},onBorrowedAggrCheckboxClick:function(t){var e=t.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAggr",e);this._oModel.setProperty("/ui5-metadata/aggregations",e?this._allAggregations:this._selfAggregations)},onBorrowedAssocCheckboxClick:function(t){var e=t.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAssoc",e);this._oModel.setProperty("/ui5-metadata/associations",e?this._allAssociations:this._selfAssociations)},onJSDocLinkClick:function(t){var e=t.target.classList,i=e.contains("sapUISDKExternalLink");if(i){this.onDisclaimerLinkPress(t);return}},onVisibilityInformationClick:function(e){var i=e.getSource(),o=this.getView();if(!this._oPopover){this._oPopover=t.load({name:"sap.ui.documentation.sdk.view.VisibilityInformation",controller:this}).then(function(t){o.addDependent(t);return t})}this._oPopover.then(function(t){t.openBy(i)})},_modifyURL:function(t,e,i){var o=t.getTitle().toLowerCase(),s=e&&e.getTitle()!=="Overview"?e.getTitle():"";if(Object.keys(this.SECTION_MAP).indexOf(o)>=0){o=this.SECTION_MAP[o]}this._oRouter.navToChangeUrlOnly({id:this._sTopicId,entityType:o,entityId:s},i)},_hljs:function(){if(window.hljs){document.querySelectorAll("pre").forEach(function(t){window.hljs.highlightBlock(t)})}},scrollToEntity:function(t,e){var i,o,s;if(!t){return}t=t.toLowerCase();s=this.byId(t);if(!s){return}if(e){e=e.toLowerCase();o=s.getSubSections();i=o.filter(function(t){return t.getTitle().toLowerCase()===e});if(i.length){this._objectPage.scrollToSection(i[0].getId(),250)}}else{this._objectPage.scrollToSection(s.getId(),250)}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0)}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var t=function(t,e,i){var o=new c({title:t,text:e}).addStyleClass("sapUiTinyMarginBottom");if(i){o.setCustomContent(i)}return o},e=function(t,e){return new h({title:"Visibility",text:o.formatVisibility(t,e),state:b.Warning}).addStyleClass("sapUiTinyMarginBottom")},i=function(t){return new r(t||{})},u=function(t){return new a(t||{})},d=function(t){return new n(t||{})},p=function(t,e){var i=new l(t||{});if(e){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom")}return i};this._oHeaderLayoutUtil={_getControlSampleBlock:function(t,e){var o=t&&t["ui5-metadata"]&&t["ui5-metadata"].stereotype||"";if(typeof o==="string"&&o.length>0){o=o.charAt(0).toUpperCase()+o.slice(1)+" "}return p({items:[d({design:"Bold",text:o+"Sample:"}),i({emphasized:true,text:e.sample,visible:!!e.hasSample,href:"entity/"+t.name}),u({text:e.sample,visible:!e.hasSample})]},true)},_getControlGithub:function(t,e){return p({items:[d({design:"Bold",text:"GitHub:"}),i({emphasized:true,text:t.resource,visible:true,href:this.PUBLIC_GITHUB_FRAMEWORK_DOMAIN+e.lib+"/src/"+t.resource})]},true)},_getDocumentationBlock:function(t,e){return p({items:[d({design:"Bold",text:"Documentation:"}),i({emphasized:true,text:t.docuLinkText,href:"topic/"+t.docuLink})]},true)},_getUXGuidelinesBlock:function(t){return p({items:[d({design:"Bold",text:"UX Guidelines:"}),i({emphasized:true,text:t.uxGuidelinesLinkText,href:t.uxGuidelinesLink,target:"_blank"}),new s({src:"./resources/sap/ui/documentation/sdk/images/link-sap.png",tooltip:"Information published on SAP site",press:this.onDisclaimerLinkPress})]},true)},_getExtendsBlock:function(t,e){var o=t.isDerived&&!this.EXTERNAL_BASE_TYPES.includes(t.extendsText);return p({items:[d({text:"Extends:"}),i({text:t.extendsText,href:"api/"+t.extendsText,visible:o}),u({text:t.extendsText,visible:!o})]},true)},_getSubclassesBlock:function(t,e){var o=e.extendedBy||e.implementedBy,s;this._aSubClasses=o;if(o.length===1){s=i({text:o[0],href:"api/"+o[0]})}else{s=i({text:t.isClass?"View subclasses":"View implementations",press:this._openSubclassesImplementationsPopover.bind(this)});s.onclick=function(t){t.allowPreventDefault=true;r.prototype._handlePress.call(this,t)}}return p({items:[d({text:t.isClass?"Known direct subclasses:":"Known direct implementations:"}),s]},true)},_getImplementsBlock:function(t,e){var o=[d({text:"Implements:"})];t.implementsParsed.forEach(function(t){o.push(i({text:t.name,href:"api/"+t.href}))});return p({items:o,wrap:y.Wrap},true).addStyleClass("sapUiDocumentationCommaList")},_getModuleBlock:function(e,i){return t("Module",e.module)},_getLibraryBlock:function(e,i){return t("Library",i.lib)},_getVisibilityBlock:function(o,s){var n=o.visibility,r=s.allowedFor;if(n==="restricted"&&r){return r.length>1?t("Visibility",n,i({text:"restricted to",press:this._openVisibilityPopover.bind(this,r)})):e(n,r)}else{return t("Visibility",n)}},_getAvailableSinceBlock:function(e,i){return t("Available since",e.sinceText)},_getApplicationComponentBlock:function(e,i){return t("Application Component",i.appComponent)}}}return this._oHeaderLayoutUtil},_openSubclassesImplementationsPopover:function(t){var e=this._aSubClasses.map(function(t){return new g({content:[new r({text:t,href:"api/"+t}).addStyleClass("sapUiTinyMargin")]})}),i=this._addPopoverContent(e);i.openBy(t.getSource())},_openVisibilityPopover:function(t,e){var i=t.map(function(t){return new g({content:[new a({text:t}).addStyleClass("sapUiTinyMargin")]})}),o=this._addPopoverContent(i);o.openBy(e.getSource())},_addPopoverContent:function(t){var e=this._getPopover();if(e.getContent().length>0){e.destroyContent()}if(t&&t.length>0){var i=new _({items:t||[]});e.addContent(i)}return e},_getPopover:function(){if(!this._oPopover){this._oPopover=new u({placement:"Bottom",showHeader:false})}return this._oPopover},_buildHeaderLayout:function(t,e){var i=0,o=1,s=2,n=3,r=[[],[],[]],a=this._getHeaderLayoutUtil(),l=e.extendedBy||e.implementedBy||[],c=this.getModel("versionData").getProperty("/isOpenUI5"),h=[{creator:"_getControlSampleBlock",exists:t.isClass||t.isNamespace},{creator:"_getDocumentationBlock",exists:t.docuLink!==undefined},{creator:"_getControlGithub",exists:c&&t.resource&&e.lib},{creator:"_getUXGuidelinesBlock",exists:t.uxGuidelinesLink!==undefined},{creator:"_getExtendsBlock",exists:t.isClass||t.isTypedef&&t.isDerived},{creator:"_getSubclassesBlock",exists:l.length>0},{creator:"_getImplementsBlock",exists:t.hasImplementsData},{creator:"_getModuleBlock",exists:true},{creator:"_getLibraryBlock",exists:t.kind==="namespace"&&e.lib},{creator:"_getVisibilityBlock",exists:t.visibility},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true}],u=function(){var l=0,c,u=function(t){if(t<=n){return i}else if(t<=n*2){return o}return s};h.forEach(function(i){var o;if(i.exists){o=a[i.creator].call(this,t,e);c=u(++l);r[c].push(o)}},this)}.bind(this);u();r.forEach(function(t,e){var i=this.byId("headerColumn"+e);i.removeAllContent();if(t.length>0){i.setVisible(true);t.forEach(i.addContent,i)}},this)},onAnnotationsLinkPress:function(){this.scrollToEntity("annotations","Summary")},backToSearch:function(){this.onNavBack()}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/TermsOfUse.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/thirdparty/jquery"],function(t,jQuery){"use strict";return t.extend("sap.ui.documentation.sdk.controller.TermsOfUse",{onInit:function(){this.oRouter=this.getRouter();this.oRouter.getRoute("termsOfUse").attachPatternMatched(this._onTopicMatched,this)},_onTopicMatched:function(t){jQuery.ajax({url:"./TermsOfUse.txt",dataType:"text"}).done(function(t){this.getView().byId("termsOfUseText").setText(t)}.bind(this)).fail(function(){this.onRouteNotFound()}.bind(this))}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Tools.controller", ["sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/base/Log","sap/ui/documentation/sdk/model/formatter","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ToolsInfo"],function(e,t,o,n,i,s){"use strict";return t.extend("sap.ui.documentation.sdk.controller.Tools",{formatter:n,onInit:function(){t.prototype.onInit.call(this);this._onOrientationChange({landscape:e.orientation.landscape});this._oModel=new i;this.getView().setModel(this._oModel);s.getToolsConfig().then(this._onToolConfigLoaded.bind(this));this.getRouter().getRoute("tools").attachPatternMatched(this._onMatched,this)},_onToolConfigLoaded:function(e){var t={};e.forEach(function(e){t[e.id]=e},this);this._oModel.setData(t);this.setModel(new i({inspectorHomeLink:"topic/b24e72443eb34d0fb7bf6940f2d697eb",supportAssistantHomeLink:t.supportAssistant.href,iconExplorerHomeLink:"topic/21ea0ea94614480d9a910b2e93431291",ui5TestRecorderHomeLink:t.ui5TestRecorder.href}),"newWindowLinks")},onBeforeRendering:function(){this._deregisterOrientationChange()},onAfterRendering:function(){this._registerOrientationChange()},onExit:function(){this._deregisterOrientationChange()},_onMatched:function(){try{this.hideMasterSide()}catch(e){o.error(e)}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/TopicDetail.controller", ["sap/ui/thirdparty/jquery","sap/ui/core/ResizeHandler","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/XML2JSONUtils","sap/ui/Device","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/controller/util/ResponsiveImageMap","sap/ui/documentation/sdk/controller/util/SidyBySideImageMap","sap/m/LightBox","sap/m/LightBoxItem","./util/DataTableHelper","./util/DataTable","sap/m/Button","sap/m/MessageToast","sap/ui/dom/includeStylesheet","sap/ui/dom/includeScript","sap/ui/util/openWindow"],function(jQuery,t,e,i,a,n,s,o,r,c,l,u,h,d,g,p,f,m,b){"use strict";var T="https://sap.github.io/openui5-docs/#/",_={SPECIAL_CHARS:/[\\\/:*\?"<>|]/g,SPACES:/\s+/g};return e.extend("sap.ui.documentation.sdk.controller.TopicDetail",{onInit:function(){var t,e;this.oPage=this.byId("topicDetailPage");this.oPage.addStyleClass("docuPage");this.oHtml=this.byId("staticContent");this.aWaitingDatatables=[];this.aResponsiveImageMaps=[];this.oLayout=this.byId("staticContentLayout");this.oHtml.attachEvent("afterRendering",this._onHtmlRendered.bind(this));this._oConfig=e=this.getConfig();this.oMatchedTopicDataTablesConfig={};if(!window.hljs){f("resources/sap/ui/documentation/sdk/thirdparty/highlight.js/styles.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/highlight.js/highlight.js"})}f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/css/dataTables.jqueryui.css");f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/css/buttons.jqueryui.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/jquery.dataTables.js"}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/dataTables.jqueryui.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/dataTables.buttons.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.jqueryui.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.html5.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.colVis.js"})}).then(function(){t=o.getResourceOriginPath(e.docuPath+"dataTablesConfig.json");return jQuery.ajax({url:t})}).then(function(t){this.oDataTablesConfig=t;this.bDataTablesPluginLoaded=true;this._getDataTableHelper().addMiddlewares();if(this.aWaitingDatatables.length>0){this.aWaitingDatatables.forEach(function(t){this._enableDataTable(t)},this);this.aWaitingDatatables=[]}}.bind(this));this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("subTopicId").attachPatternMatched(this._onTopicMatched,this);this.jsonDefModel=new i;this.getView().setModel(this.jsonDefModel)},onBeforeRendering:function(){var e=this.getView().getDomRef();if(e&&this.fnOnPageClickListener){e.removeEventListener("click",this.fnOnPageClickListener)}t.deregister(this._onResize.bind(this));n.orientation.detachHandler(this._onOrientationChange,this)},onAfterRendering:function(){var e=this.getView().getDomRef();this.fnOnPageClickListener=this._onPageClick.bind(this);if(e){e.addEventListener("click",this.fnOnPageClickListener)}t.register(this.getView().getDomRef(),this._onResize.bind(this));n.orientation.attachHandler(this._onOrientationChange,this)},_getCopyButtons:function(t){var e="Copied to clipboard.";this.aButtonElements=t.querySelectorAll(".copyButton");this.aButtonElements.forEach(function(t){var i=new g({icon:"sap-icon://copy"});i.placeAt(t);t.addEventListener("click",function(){var i=document.createElement("textarea");i.value=t.parentNode.innerText;document.body.appendChild(i);i.select();document.execCommand("copy");document.body.removeChild(i);p.show(e)})})},onExit:function(){this.aResponsiveImageMaps.forEach(function(t){t.removeEventListeners()});t.deregister(this._onResize.bind(this));n.orientation.detachHandler(this._onOrientationChange,this)},_onResize:function(){this.aResponsiveImageMaps.forEach(function(t){t.resize()})},_onPageClick:function(t){var e=t.target,i=e.classList,a=i.contains("collapsible-icon"),n=i.contains("lightbox-img"),s;if(n){this._onThumbnailClicked(e)}if(a){s=e.parentNode;s.classList.toggle("expanded")}},_onThumbnailClicked:function(t){var e=this._getLightBox(),i=e.getImageContent()[0],a=t.getAttribute("src"),n=t.getAttribute("title"),s=t.getAttribute("alt");i.setImageSrc(a);i.setTitle(n);i.setAlt(s);e.open()},_getLightBox:function(){if(!this._oLightBox){this._oLightBox=new l({imageContent:new u})}return this._oLightBox},_getDataTableHelper:function(){return h.getInstance()},_onHtmlResourceLoaded:function(t){var e;if(!t){setTimeout(function(){this.onRouteNotFound()}.bind(this),0);return}e=a.XML2JSON(t,this._oConfig);e.bIsPhone=n.system.phone;e.topicURL=this.sTopicURL;if(e.shortdesc){e.shortdesc=e.shortdesc.trim().replace(/(\r\n|\n|\r)/gm," ")}this.jsonDefModel.setData(e);this.oHtml.setContent(e.html);this.oLayout.invalidate();this._scrollContentToTop();this.searchResultsButtonVisibilitySwitch(this.byId("topicDetailBackToSearch"));this.appendPageTitle(this.getModel().getProperty("/topictitle1"))},_onTopicMatched:function(t){var e=decodeURIComponent(t.getParameter("arguments").id),i=e.split("#"),a=i[0],n=i[1];this.sTopicId=a.replace(".html","");this.sSubTopicId=n;this.sTopicURL=o.getResourceOriginPath(this._oConfig.docuPath+a+(a.match(/\.html/)?"":".html"));this.sSubTopicId=t.getParameter("arguments").subId||n;jQuery.ajax(this.sTopicURL).done(this._onHtmlResourceLoaded.bind(this)).fail(this.onRouteNotFound.bind(this))},_onHtmlRendered:function(){this._getDataTableHelper().destroyDatatables();var t,e=this.oPage.$().find("#d4h5-main-container :not(.imagemap_sidebyside)>.imagemap"),i=this.oPage.$().find("#d4h5-main-container .imagemap_sidebyside"),a=this.oPage.$().find("#d4h5-main-container table.datatable"),n=this.oPage.$().find("#d4h5-main-container img"),s=this.oLayout.getDomRef();this._fixExternalLinks(s);this._getCopyButtons(s);this._computeColumnGroupValues(s);if(this.sSubTopicId){t=document.getElementById(this.sSubTopicId);if(t){t.scrollIntoView(true)}}this.aResponsiveImageMaps.forEach(function(t){t.removeEventListeners()});this.aResponsiveImageMaps=[];if(a.length){a.each(function(t,e){if(this.bDataTablesPluginLoaded){this._enableDataTable(e)}else{this.aWaitingDatatables.push(e)}}.bind(this))}e.each(function(t,e){this._enableImageMap(e)}.bind(this));i.each(function(t,e){this._enableImageMap(e,true)}.bind(this));n.each(function(t,e){var i=e.getAttribute("src");e.setAttribute("src",o.getResourceOriginPath(i))});if(window.hljs){document.querySelectorAll('pre:not([class*="lines"])').forEach(function(t){window.hljs.highlightBlock(t)})}},_enableImageMap:function(t,e){var i=t.querySelector("img"),a,n,s=/<img[^>]+src="([^">]+)/g,o=this;if(i.complete){this._addResponsiveImageMap(t,e)}else{a=new Image;a.onload=function(){o._addResponsiveImageMap(t,e)};n=s.exec(i.outerHTML);if(n){a.src=n&&n[1]}}},_enableDataTable:function(t){var e=t.id,i=this._getDataTableConfig(e),a;if(i){a=(new d).init(e,t,i);this._getDataTableHelper().addDatatable(a)}},_getDataTableConfig:function(t){var e=this.oDataTablesConfig[this.sSubTopicId]||this.oDataTablesConfig[this.sTopicId]||{};return e[t]},_addResponsiveImageMap:function(t,e){var i=e?c:r;this.aResponsiveImageMaps.push(new i(t))},_fixExternalLinks:function(t){var e=t.querySelectorAll("a.external-link"),i,a,n,s="http://help.sap.com/disclaimer?site=";for(i=0;i<e.length;i++){a=e[i];n=a.getAttribute("href");a.setAttribute("href",s+n);this._addIconToExternalUrl(a,n)}},_computeColumnGroupValues:function(t){var e,i,a,n,s,o=t.querySelectorAll("colgroup");o=[].slice.call(o);o.forEach(function(t){e=0;a=[];s=[].slice.call(t.children);s.forEach(function(t,n){i=parseInt(t.getAttribute("width"));a[n]=i;e+=i});s.forEach(function(t,i){n=a[i]/e*100;t.setAttribute("width",n+"%")})})},_addIconToExternalUrl:function(t,e){var i=this._isSAPHostedUrl(e),a="Information published on "+(i?"":"non ")+"SAP site",n=new Image,s=i?"link-sap":"link-external";n.onload=function(){t.appendChild(n)};n.src="./resources/sap/ui/documentation/sdk/images/"+s+".png";n.setAttribute("title",a);n.className="sapUISDKExternalLink"},_isSAPHostedUrl:function(t){return/^https?:\/\/([\w.]*\.)?(?:sap|hana\.ondemand|sapfioritrial)\.com/.test(t)},_scrollContentToTop:function(){if(this.oPage&&this.oPage.$().length>0){this.oPage.getScrollDelegate().scrollTo(0,1)}},_formatHTML:function(t){return"<div>"+t+"</div>"},backToSearch:function(t){this.onNavBack()},onToggleFullScreen:function(t){s.updateMode(t,this.getView(),this)},onEditGitHubPress:function(t){b(this.jsonDefModel.getProperty("/mdEditLink"))},_formatToGitHubUrl:function(t,e){var i=e.trim().replace(_.SPECIAL_CHARS,"").replace(_.SPACES,"_");i+="_";i+=t.split("/").pop().substring(0,7);i+=".md";return T+i}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/TopicDetailInitial.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device","sap/ui/thirdparty/jquery"],function(e,n,jQuery){"use strict";var t="https://github.com/SAP/openui5-docs";return e.extend("sap.ui.documentation.sdk.controller.TopicDetailInitial",{onInit:function(){e.prototype.onInit.call(this);this._onOrientationChange({landscape:n.orientation.landscape});this.handleDocumentationDisclaimer()},handleDocumentationDisclaimer:function(){jQuery.ajax(this.getConfig().docuPath+"disclaimer.json",{dataType:"json"}).then(function(e){var n=this.getView();if(e.showDisclaimer&&e.message){n.byId("disclaimerBlock").setVisible(true);n.byId("disclaimerMessage").setText(e.message)}}.bind(this),function(){})},onBeforeRendering:function(){this._deregisterOrientationChange()},onAfterRendering:function(){this._registerOrientationChange()},onExit:function(){this._deregisterOrientationChange()},onDownloadButtonPress:function(){window.open(this._determineFileLocation(),"_blank")},onGitHubButtonPress:function(){window.open(t,"_blank")},_determineFileLocation:function(){var e=this.getModel("versionData"),n=e.getProperty("/isDevVersion"),t=e.getProperty("/isOpenUI5");if(t){return"https://help.sap.com/OpenUI5_PDF/OpenUI5.pdf"}return n?"https://help.sap.com/DRAFT/SAPUI5_Internal_PDF/SAPUI5_Internal.pdf":"https://help.sap.com/SAPUI5_PDF/SAPUI5.pdf"}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/TopicMaster.controller", ["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/ui/model/json/JSONModel","sap/m/library","sap/base/Log","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/documentation/sdk/controller/util/DocuInfo"],function(t,e,i,o,s,n,r){"use strict";var h=o.SplitAppMode;return e.extend("sap.ui.documentation.sdk.controller.TopicMaster",{onInit:function(){this._oTree=this.byId("tree");var t=new i;t.setSizeLimit(1e4);this.getView().setModel(t);this.getRouter().getRoute("topic").attachPatternMatched(this._onMatched,this);this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("subTopicId").attachPatternMatched(this._onTopicMatched,this);this._oIndexPromise=this._getDocuIndexPromise().then(function(e){e=this._addSearchMetadata(e,"");t.setData(e);this._initTreeUtil("key","links")}.bind(this)).catch(function(){this.onRouteNotFound()}.bind(this))},_onTopicMatched:function(t){try{this.showMasterSide()}catch(t){s.error(t)}this._topicId=t.getParameter("arguments").id.split("/")[0];this._oIndexPromise.then(function(){this._expandTreeToNode(this._preProcessTopicID(this._topicId),this.getModel())}.bind(this))},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new n(this._oTree.getDomRef(),{shouldBeObserved:true})}},onExit:function(){this.highlighter.destroy()},onTreeFilter:function(){e.prototype.onTreeFilter.apply(this,arguments);if(this.highlighter){this.highlighter.highlight(this._sFilter)}return this},_onMatched:function(){this.getView().getParent().getParent().setMode(h.ShowHideMode);this._collapseAllNodes();this._clearSelection();if(t.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus()}.bind(this),0)}},_getDocuIndexPromise:function(){return r.getDocuIndexPromise(this.getConfig())},_addSearchMetadata:function(t,e){for(var i=0;i<t.length;i++){t[i].name=e?e+" "+t[i].text:t[i].text;if(t[i].links){t[i].links=this._addSearchMetadata(t[i].links,t[i].name)}}return t},onNodeSelect:function(t){this.getRouter().navTo("topicId",{id:t.getParameter("listItem").getTarget()},false)},_preProcessTopicID:function(t){if(!t||typeof t!=="string"){return t}return t.replace(/\.html[#]?[0-9a-z_]*$/,"")}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/VersionNotFound.controller", ["./BaseController","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/documentation/sdk/controller/util/URLUtil","sap/m/library"],function(e,jQuery,t,r,n){"use strict";return e.extend("sap.ui.documentation.sdk.controller.VersionNotFound",{onInit:function(){this._loadVersionInfo().then(this._onVersionInfo.bind(this)).catch(this._onError.bind(this))},onReadMore:function(){n.URLHelper.redirect("https://blogs.sap.com/2021/01/26/removing-outdated-ui5-versions-from-ui5-cdn/")},onHomePress:function(){n.URLHelper.redirect("/")},_onError:function(){var e=this.getView().byId("page");e.setBusy(false);e.setText(this._getLibraryResourceBundle().getText("NOT_FOUND_UNAVAILABLE_TEXT"))},_onVersionInfo:function(e){var t=this.getView().byId("page"),i=this.getView().byId("readMoreButton"),o=document.location.href,s,u=r.parseVersion(o),a=this._getPatchInfo(e,u),c=a&&a.removed,d=a&&a.runtimeOnly;t.setBusy(false);if((c||d)&&r.requestsDemokitView(o)){s=r.removeVersion(o);n.URLHelper.redirect(s);return}if(r.hasSEOOptimizedFormat(o)){s=r.convertToNonSEOFormat(o);n.URLHelper.redirect(s);return}if(c){t.setText(this._getLibraryResourceBundle().getText("NOT_FOUND_REMOVED_TEXT"));i.setVisible(true)}else if(d){t.setText(this._getLibraryResourceBundle().getText("NOT_FOUND_DK_REMOVED_TEXT"));i.setVisible(true)}else{i.setVisible(false);t.setText(this._getLibraryResourceBundle().getText("NOT_FOUND_UNAVAILABLE_TEXT"))}},_getPatchInfo:function(e,t){var r=e.patches;return r.find(function(e){return t===e.version})},_getLibraryResourceBundle:function(){return t.getLibraryResourceBundle("sap.ui.documentation")},_loadVersionInfo:function(){return new Promise(function(e,t){jQuery.ajax({async:true,url:"/versionoverview.json",dataType:"json",success:function(t){e(t)},error:function(e){t(e)}})})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/Welcome.controller", ["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device","sap/ui/VersionInfo","sap/ui/model/json/JSONModel","sap/base/Log"],function(e,t,n,o,i){"use strict";return e.extend("sap.ui.documentation.sdk.controller.Welcome",{onInit:function(){this.getRouter().getRoute("welcome").attachPatternMatched(this._onMatched,this);n.load().then(function(e){var t=new o({isOpenUI5:e&&e.gav&&/openui5/i.test(e.gav)});this.getView().setModel(t,"welcomeView")}.bind(this));this._onOrientationChange({landscape:t.orientation.landscape})},onBeforeRendering:function(){this._deregisterOrientationChange()},onAfterRendering:function(){this._registerOrientationChange()},onExit:function(){this._deregisterOrientationChange()},navigateToDetails:function(e){var t=e.oSource.getHref()||e.oSource.getTarget();t=t.replace("#/","").split("/");var n=t[0];var o=t[1];e.preventDefault();this.getRouter().navTo(n,{id:o},true)},onGetStarted:function(){this.getRouter().parse("topic/8b49fc198bf04b2d9800fc37fecbb218")},onDownloadButtonPress:function(e){var t=this.getView().getModel("welcomeView").getProperty("/isOpenUI5"),n=t?"https://openui5.org/releases/":"https://tools.hana.ondemand.com/#sapui5";window.open(n,"_blank")},_onMatched:function(){try{this.hideMasterSide()}catch(e){i.error(e)}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/config/datatable", [],function(){"use strict";return{getPreset:function(){return{dom:'<"fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix ui-corner-tl ui-corner-tr"<"searchWrapper"f>l<"pagingWrapper"p>t>'+"t"+'<"fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix ui-corner-bl ui-corner-br"ip>',buttons:[{extend:"colvis"}],lengthMenu:[[10,25,50,100,-1],[10,25,50,100,"All"]],sapTableId:"",language:{buttons:{colvis:"Show/hide columns"}}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/config/sampleForwardingConfig", [],function(){"use strict";return{"sap.f.sample.IllustratedMessageInCardNoActivities":{entityId:"sap.m.IllustratedMessage",sampleId:"sap.m.sample.IllustratedMessageInCardNoActivities"},"sap.f.sample.IllustratedMessageInCardNoEmail":{entityId:"sap.m.IllustratedMessage",sampleId:"sap.m.sample.IllustratedMessageInCardNoEmail"},"sap.f.sample.IllustratedMessageInDialog":{entityId:"sap.m.IllustratedMessage",sampleId:"sap.m.sample.IllustratedMessageInDialog"},"sap.f.sample.IllustratedMessageInPage":{entityId:"sap.m.IllustratedMessage",sampleId:"sap.m.sample.IllustratedMessageInPage"},"sap.f.sample.IllustratedMessageInPageTNT":{entityId:"sap.m.IllustratedMessage",sampleId:"sap.m.sample.IllustratedMessageInPageTNT"},"sap.f.sample.IllustratedMessageSessionTimeout":{entityId:"sap.m.IllustratedMessage",sampleId:"sap.m.sample.IllustratedMessageSessionTimeout"},"sap.f.sample.Avatar":{entityId:"sap.m.Avatar",sampleId:"sap.m.sample.Avatar"}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/APIInfo", ["sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/documentation/sdk/util/Resources"],function(jQuery,e,r){"use strict";var n;var i={};function s(){if(i["index"]){return Promise.resolve(i["index"])}return new Promise(function(n,s){jQuery.ajax({async:true,url:r.getResourceOriginPath("/docs/api/api-index.json"),dataType:"json",success:function(e){var r=e.symbols||[];i["index"]=r;n(r)},error:function(){jQuery.ajax({async:true,url:r.getResourceOriginPath("../../../../../../docs/api/api-index.json"),dataType:"json",success:function(e){var r=e.symbols||[];i["index"]=r;n(r)},error:function(){e.error("failed to load api-index.json");i["index"]=[];n([])}})}})})}function o(){if(i["deprecated"]){return Promise.resolve(i["deprecated"])}return new Promise(function(e,n){jQuery.ajax({async:true,url:r.getResourceOriginPath("/docs/api/api-index-deprecated.json"),dataType:"json",success:function(r){i["deprecated"]=r;e(r)},error:function(){n()}})})}function t(){if(i["experimental"]){return Promise.resolve(i["experimental"])}return new Promise(function(e,n){jQuery.ajax({async:true,url:r.getResourceOriginPath("/docs/api/api-index-experimental.json"),dataType:"json",success:function(r){i["experimental"]=r;e(r)},error:function(){n()}})})}function a(){if(i["since"]){return Promise.resolve(i["since"])}return new Promise(function(e,n){jQuery.ajax({async:true,url:r.getResourceOriginPath("/docs/api/api-index-since.json"),dataType:"json",success:function(r){i["since"]=r;e(r)},error:function(){n()}})})}function u(s){if(!s){return Promise.resolve([])}if(i[s]){return Promise.resolve(i[s])}return new Promise(function(o){jQuery.ajax({async:true,url:r.getResourceOriginPath(n+s.replace(/\./g,"/")+"/designtime/apiref/api.json"),dataType:"json",success:function(e){var r=e.symbols||[];i[s]=r;o(r)},error:function(r){e.error("failed to load api.json for: "+s);i[s]=[];o([])}})})}function c(e){e=e==null?sap.ui.require.toUrl("")+"/"+"../test-resources/":e;if(e.slice(-1)!="/"){e+="/"}n=e}c();return{_setRoot:c,getIndexJsonPromise:s,getDeprecatedPromise:o,getExperimentalPromise:t,getSincePromise:a,getLibraryElementsJSONPromise:u}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/ConfigUtil", ["sap/ui/base/Object","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/util/Resources","sap/base/Log"],function(t,e,jQuery,n,o){"use strict";return t.extend("sap.ui.documentation.sdk.controller.util.ConfigUtil",{COOKIE_NAMES:{APPROVAL_REQUESTED:"dk_approval_requested",ALLOW_REQUIRED_COOKIES:"dk_allow_required_cookies"},LOCAL_STORAGE_NAMES:{OLD_NEWS_IDS:"dk_old_news_ids"},constructor:function(t){this._oComponent=t},hasMasterView:function(t){var e=this._getRouteConfig(t),n=e&&e.target.length===2;return!!n},getMasterView:function(t){var n=this._getMasterTargetName(t),o=this._getTargetConfig(n),i=o.viewName;i="sap.ui.documentation.sdk.view."+e(i,0);return this._oComponent.getRouter().getView(i,"XML")},setCookie:function(t,e){var n,o=new Date;o.setTime(o.getTime()+356*24*60*60*1e3);n="expires="+o.toUTCString();document.cookie=t+"="+e+";"+n+";path=/"},getCookieValue:function(t){var e=document.cookie.split(";"),n;t=t+"=";for(var o=0;o<e.length;o++){n=e[o].trim();if(n.indexOf(t)===0){return n.substring(t.length,n.length)}}return""},setLocalStorageItem:function(t,e){window.localStorage.setItem(t,JSON.stringify(e))},getLocalStorageItem:function(t){return JSON.parse(window.localStorage.getItem(t))},removeLocalStorageItem:function(t){window.localStorage.removeItem(t)},_getMasterTargetName:function(t){var e=this._getRouteConfig(t),n=e&&e.target.length===2,o=n&&e.target[0];return o},_getRouteConfig:function(t){var e=this._getSapUI5ConfigEntry(),n=e.routing.routes;return n.find(function(e){return e.name===t})},_getSapUI5ConfigEntry:function(){return this._oComponent.getMetadata().getManifestObject().getEntry("sap.ui5")},_getTargetConfig:function(t){return this._getSapUI5ConfigEntry().routing.targets[t]},destroy:function(){this._oComponent=null;return t.prototype.destroy.apply(this,arguments)},_requireConfigJSON:function(){return new Promise(function(t){jQuery.ajax(n.getResourceOriginPath("/news-config.json"),{type:"GET",dataType:"JSON",success:function(e){t(e)},error:function(){o.error("failed to load news-config.json");t()}})})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/ControlsInfo", ["sap/ui/thirdparty/jquery","sap/ui/documentation/library","sap/base/Log","sap/ui/documentation/sdk/util/Resources"],function(jQuery,e,r,n){"use strict";var s;var t={loadData:function(){if(!s){s=new Promise(function(r,n){e._loadAllLibInfo("","_getDocuIndex",function(e,n){var s=t._getIndices(e,n,function(){r(s)})})})}return s},_getIndices:function(s,t,i){var a=["_PRIVATE_"];var o=["Action","Application","Container","Display","Chart","Mini Chart","Layout","List","Floorplans & Patterns","Popup","Tile","User Input","Showcase","Testing","Theming","Tutorial","Routing","Data Binding","Data Visualization","Map","Utility","Web Components","Smart Controls"];var l=["namespace","since","category"];var p={namespace:{},since:{},category:{},formFactors:{Independent:true,Condensed:true,Compact:true,Cozy:true}};var f={"-":"Independent",S:"Condensed",SM:"Condensed, Compact",SL:"Condensed, Cozy",SML:"Condensed, Compact, Cozy",M:"Compact",ML:"Compact, Cozy",L:"Cozy"};var c={};c={};c.entityCount=0;c.entities=[];c.filter={};c.samples={};jQuery.each(t,function(e,s){if(!s.explored){return}else if(!s.explored.samplesRef){r.error("explored: cannot register lib '"+s.library+"'. missing 'explored.samplesRef'");return}else if(Array.isArray(s.explored.samplesRef)&&s.explored.samplesRef.length!==s.explored.samplesRef.filter(function(e){return e.namespace&&e.ref}).length){r.error("explored: cannot register lib '"+s.library+"'. missing 'explored.samplesRef.namespace' or 'explored.samplesRef.ref' in one or more of the configured namespaces");return}else if(!Array.isArray(s.explored.samplesRef)&&!s.explored.samplesRef.namespace){r.error("explored: cannot register lib '"+s.library+"'. missing 'explored.samplesRef.namespace'");return}else if(!Array.isArray(s.explored.samplesRef)&&!s.explored.samplesRef.ref){r.error("explored: cannot register lib '"+s.library+"'. missing 'explored.samplesRef.ref'");return}else if(!s.explored.entities){r.error("explored: cannot register lib '"+s.library+"'. missing 'explored.entities'");return}else{r.info("explored: now reading lib '"+s.library+"'")}if(Array.isArray(s.explored.samplesRef)){s.explored.samplesRef.forEach(function(e){(function(){var r={};r[e.namespace.replace(/\./g,"/")]=""+n.getResourceOriginPath(e.ref||".");sap.ui.loader.config({paths:r})})()})}else{(function(){var e={};e[s.explored.samplesRef.namespace.replace(/\./g,"/")]=""+n.getResourceOriginPath(s.explored.samplesRef.ref||".");sap.ui.loader.config({paths:e})})()}jQuery.each(s.explored.samples,function(e,n){if(!n.id){r.error("explored: cannot register sample '?'. missing 'id'")}else if(!n.name){r.error("explored: cannot register sample '"+n.id+"'. missing 'name'")}else{c.samples[n.id]=n;n.library=s.library}});jQuery.each(s.explored.entities,function(e,n){if(!n.id){r.error("explored: cannot register entity '?'. missing 'id'");return}if(s.explored.entitiesDefaults){jQuery.each(s.explored.entitiesDefaults,function(e,r){if(!n.hasOwnProperty(e)){n[e]=r}})}var t=n.id.lastIndexOf(".");var i=t!==-1?n.id.substring(0,t):n.id;n.namespace=i;if(!n.name){r.error("explored: cannot register entity '"+n.id+"'. missing 'name'");return}if(o.indexOf(n.category)===-1&&a.indexOf(n.category)===-1){r.error("explored: cannot register entity '"+n.id+"'. category '"+n.category+"' is not allowed");return}if(!n.formFactors){r.error("explored: cannot register entity '"+n.id+"'. missing 'formFactors'");return}if(!f[n.formFactors]){r.error("explored: cannot register entity '"+n.id+"'. formFactors '"+n.formFactors+"' is not allowed");return}n.formFactors=f[n.formFactors];var d=false;jQuery.each(l,function(e,s){if(!n[s]){r.error("explored: cannot register entity '"+n.id+"'. missing '"+s+"'");d=true;return false}});if(d){return}jQuery.each(l,function(e,r){p[r][n[r]]=true});n.library=s.library;if(o.indexOf(n.category)>-1){c.entities.push(n)}})});jQuery.each(c.entities,function(e,n){var s=0,t,i;n.searchTags=n.name+" "+n.name.replace(/\s/g,"")+" "+n.category;if(n.samples){n.samples.forEach(function(e){var r=c.samples[e];if(r){n.searchTags+=" "+r.name;n.searchTags+=" "+r.description}})}if(n.samples&&!(n.samples instanceof Array)){n.samples=[];r.error("explored: cannot register samples for entity '"+n.id+"'. 'samples' is not an array");return}if(!n.samples){n.samples=[]}if(n.samplesAsSteps){if(!(n.samplesAsSteps instanceof Array)){r.error("explored: cannot register samples for entity '"+n.id+"'. 'samplesAsSteps' is not an array");return}i=function(e){if(e.toString().length===1){return"0"+e}return e};for(;s<n.samplesAsSteps.length;s++){t={id:n.id+"."+i(s+1),name:n.name+" - Step "+(s+1)+" - "+n.samplesAsSteps[s]};if(s>0){t.previousSampleId=n.id+"."+i(s)}if(s<n.samplesAsSteps.length-1){t.nextSampleId=n.id+"."+i(s+2)}t.entityId=n.id;n.samples.push(t);t.library=n.library;c.samples[t.id]=t;n.searchTags+=" "+t.name}}else{var a=[],o;jQuery.each(n.samples,function(e,s){var t=c.samples[s];if(!t){r.warning("explored: cannot register sample '"+s+"' for '"+n.id+"'. not found in the available docu indizes")}else{t.entityId=n.id;if(!t.contexts){t.contexts={}}if(!t.contexts[t.entityId]){t.contexts[t.entityId]={}}t.contexts[t.entityId].previousSampleId=o?o.id:undefined;if(o){o.contexts[t.entityId].nextSampleId=t.id}o=t;a.push(t);n.searchTags+=" "+t.name}});n.samples=a}n.sampleCount=n.samples.length});c.entityCount=c.entities.length;jQuery.each(p,function(e,r){c.filter[e]=[];jQuery.each(r,function(r,n){c.filter[e].push({id:r})})});var d=e._getLibraryInfoSingleton();var m={};var u=[];for(var g=0;g<s.length;g++){u.push(new Promise(function(e){var r=function(r){m[r.library]=r.componentInfo;e()};d._getLibraryInfo(s[g],r)}))}Promise.all(u).then(function(){i&&i()});c.libComponentInfos=m;c.groups=this.getGroups(c.entities);return c},findGroup:function(e,r){var n;for(var s=0;s<e.length;s++){n=e[s];if(n.name==r){return n}}},getGroups:function(e){var r=[],n,s,t,i,a,o;for(a=0;a<e.length;a++){n=e[a];n.key="#/entity/"+n.id;t=n.samples;for(o=0;o<t.length;o++){i=t[o];i.key="#/sample/"+i.id+"/preview"}s=this.findGroup(r,n.category);if(!s){s={name:n.category,key:"#/group/"+n.category,controls:[n]};r.push(s)}else{s.controls.push(n)}}return r}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/DataTable", ["sap/ui/thirdparty/jquery","sap/m/Input","sap/m/library","../config/datatable","./datatable/filters/DataTableFilterDropDown","./datatable/filters/DataTableFilterRange","sap/ui/documentation/sdk/controller/util/Highlighter","./DataTableUtil"],function(t,e,i,n,s,o,a,r){"use strict";var l=i.InputType;function h(){this.oColumns=[];this.oChangedFilters=[];this.aShownRows=[];this.API=null}h.DEFAULT_SORTING="0,asc";h.FILTER_CLASS_WRAPPER="sapUiDocumentationDatatableFilterWrapper";h.FILTER_TYPES={REGEX:"REGEX",NORMAL:"NORMAL",NUMBER:"NUMBER",SELECT:"SELECT",CELL_RANGE:"CELL_RANGE",NUMBER_RANGE:"NUMBER_RANGE"};h.prototype.destroy=function(){this.oColumns.forEach(function(t){if(t.highlighter){t.highlighter.destroy();t.highlighter=null}t.aControls.forEach(function(t){t.destroy()});t.aControls=[]});this.oColumns=[];this.API.destroy()};h.prototype.get=function(t){return this.oConfig[t]};h.prototype.init=function(e,i,n){this.sId=e;this.oDomTable=i;this.oConfig=this.getConfig(e,n);var s=t(i).DataTable(Object.assign(this.oConfig,this.getLifeCycleMethods(e,n)));s.on("draw",function(){if(this.get("highlight")){var t=s.search();if(t||this.oChangedFilters.length){this.oColumns.forEach(function(e,i){var n=this.oChangedFilters[i]&&this.oChangedFilters[i].value,s=Array.isArray(n);if(s){n=n.reduce(function(t,e,i){if(e.value){t+=" "+e.text}return t},"")}if(n&&!(typeof n==="object")){if(t){t+=" "+n}else{t=n}}this.highlight(i,t)},this)}else{this.highlight(null,"")}}}.bind(this));s.buttons().container().insertBefore("#"+e+"_length");s.on("column-visibility.dt",function(t,e,i,n){this.onColumnVisibilityChange(i,n)}.bind(this));this.oConfig.columns.forEach(function(t,e){this.onColumnVisibilityChange(e,t.visible)},this);return this};h.prototype.highlight=function(t,e){if(t===null){this.oColumns.forEach(function(t){t.highlighter.highlight(e)});return}this.oColumns[t].highlighter.highlight(e)};h.prototype.onColumnVisibilityChange=function(t,e){var i=this.oColumns[t]&&this.oColumns[t].filterHeader,n=this.oDomTable.querySelector("colgroup"),s;if(n){s=n.children[t];if(s){s.classList.toggle("hidden",!e)}}if(i){i.toggle(e)}};h.prototype.handleSearch=function(t,e,i,n,s){var o,a,r,l,u=[],f;this.oChangedFilters.forEach(function(n,s){o=e[s];r=n.value;l=n.control;if(r===""){return}switch(true){case l.hasStyleClass(h.FILTER_TYPES.REGEX):case l.hasStyleClass(h.FILTER_TYPES.NORMAL):case l.hasStyleClass(h.FILTER_TYPES.ALPHA_NUMERIC):case l.hasStyleClass(h.FILTER_TYPES.NUMBER):f=o.toLowerCase().indexOf(r.toLowerCase())>-1;break;case l.hasStyleClass(h.FILTER_TYPES.NUMBER_RANGE):var c=r.from!==""?r.from:Number.MIN_SAFE_INTEGER,g=r.to!==""?r.to:Number.MAX_SAFE_INTEGER,E=parseFloat(o)||0;f=isNaN(c)&&isNaN(g)||isNaN(c)&&E<=g||c<=E&&isNaN(g)||c<=E&&E<=g;break;case l.hasStyleClass(h.FILTER_TYPES.CELL_RANGE):var p=o.split("-"),C=parseFloat(r);f=p[0]<=C&&p[1]>=C;break;case l.hasStyleClass(h.FILTER_TYPES.SELECT):var d=r.some(function(t){return t.value});f=!d||r.findIndex(function(e){a=t.aoData[i].anCells[s].querySelectorAll("li");var n=[];if(a.length){for(var r=0;r<a.length;r++){n[r]=a[r].textContent}}else{n.push(o)}return e.value&&n.indexOf(e.text)>-1},this)>-1;break;default:f=true}u.push(f)},this);return u.indexOf(false)<0};h.prototype.getConfig=function(t,e){var i=[],s=JSON.parse(JSON.stringify(n.getPreset()));s.sapTableId=t;s.columnDefs=[];if(e){s.save=e["save"]!==false;s.searching=e["search"]!==false;s.highlight=e["highlight"]!==false;if(e["excel_export"]){s.buttons.push("csv")}if(e["paginate"]){var o=parseInt(e["paginate"]);s.pageLength=o>0?o:-1}s.columns=e.columns.map(function(t,e){var i={visible:true};i.visible=t.visible!==false;if(t.sort){var n=s.columnDefs.find(function(e){return e.type===t.sort});if(n){n.targets.push(e)}else{s.columnDefs.push({type:t.sort,targets:[e]})}}return i});e["initial_sort"]=e["initial_sort"]||h.DEFAULT_SORTING;if(e["initial_sort"]!=="none"){i=e["initial_sort"].split(";");i=i.map(function(t){return t.split(",")})}s.order=i}return s};h.prototype.onFilterChange=function(t,e){this.oChangedFilters[t]={control:e.control,value:e.value};this.API.columns(t).draw()};h.prototype.getSelectOptions=function(e){var i=[];this.API.columns(e).data().unique().sort()[0].forEach(function(e){var n;if(i.indexOf(e)>-1){return}try{n=t(e)}catch(t){n=null}if(n&&n.is("p")){var s=n.text();if(i.indexOf(s)<0){i.push(s)}}else if(n&&n.length>0){n.find("li").each(function(t,e){if(i.indexOf(e.textContent)<0){i.push(e.textContent)}})}else{e&&i.push(e)}});i.sort(r.sortAlphaNumeric);return i};h.prototype.getLifeCycleMethods=function(e,i){var n=this;return{initComplete:function(){n.API=this.api();var s=t("#"+e+" > thead"),o=t("<tr/>"),r,l,u=0;this.api().columns().every(function(){var e=u,s=i.columns[u],f=[],c,g=s.filter==="select";r=t("<th/>");r.addClass(h.FILTER_CLASS_WRAPPER);n.oColumns[u]={};n.oColumns[u].aControls=[];n.oColumns[u].filterHeader=r;if(n.get("highlight")){l=new a([].slice.call(this.nodes()),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});n.oColumns[u].highlighter=l}if(g){f=n.getSelectOptions(u)}c=h.getFilterByType(s.filter,f);if(c.control){n.oColumns[u].aControls.push(c.control);c.control.attachEvent(c.event,function(t){n.onFilterChange(e,{value:t.getParameter("value"),control:c.control})});c.control.placeAt(r[0])}o.append(r);u++});s.append(o)}}};h.getFilterByType=function(t,i){var n,a="liveChange";switch(t){case"number-range":n=new o({from:new e({type:l.Number,placeholder:"From"}),to:new e({type:l.Number,placeholder:"To"})}).addStyleClass(h.FILTER_TYPES.NUMBER_RANGE);break;case"select":a="change";n=new s({options:i}).addStyleClass(h.FILTER_TYPES.SELECT);break;case"none":n="";break;default:var r=h.FILTER_TYPES.NORMAL,u=l.Text;if(t==="regex"){r=h.FILTER_TYPES.REGEX}else if(t==="cell-range"){r=h.FILTER_TYPES.CELL_RANGE;u=l.Number}else if(t==="number"){r=h.FILTER_TYPES.NUMBER;u=l.Number}n=new e({type:u,placeholder:"Filter"}).addStyleClass(r)}return{control:n,event:a}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/DataTableHelper", ["sap/ui/thirdparty/jquery","./DataTableUtil"],function(t,a){"use strict";function e(){this.aDataTables=[]}e.prototype.addDatatable=function(t){this.aDataTables.push(t)};e.prototype.destroyDatatables=function(){this.aDataTables.forEach(function(t){t.destroy()});this.aDataTables=[]};e.prototype.addMiddlewares=function(){t.fn.dataTable.ext.search.push(function(t,a,e,n,r){var i=true,u=this.aDataTables.find(function(a){return a.sId===t.sTableId});if(u){i=u.handleSearch(t,a,e,n,r)}return i}.bind(this));t.extend(t.fn.dataTableExt.oSort,{"alpha-numeric-asc":function(t,e){return a.sortAlphaNumeric(t,e)},"alpha-numeric-desc":function(t,e){return a.sortAlphaNumeric(e,t)}})};function n(){var t=null;return{getInstance:function(){if(!t){t=new e}return t}}}return n()});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/DataTableUtil", [],function(){"use strict";function e(e,r){var n=new RegExp("^([a-zA-Z]*)(.*)"),t=n.exec(e),u=n.exec(r),i=t[1],a=u[1];if(i>a){return 1}if(i<a){return-1}return parseInt(t[2])-parseInt(u[2])}return{sortAlphaNumeric:e}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/DocuInfo", ["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/util/Resources"],function(jQuery,e){"use strict";var n;function r(r){if(n){return Promise.resolve(n)}return new Promise(function(u,t){jQuery.ajax({async:true,url:e.getResourceOriginPath(r.docuPath+"index.json"),dataType:"json",success:function(e){n=e;u(e)},error:function(e){t(e)}})})}return{getDocuIndexPromise:r}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/EntityInfo", ["./APIInfo","sap/base/util/ObjectPath","sap/ui/VersionInfo"],function(e,n,r){"use strict";function i(e){return r.load().catch(function(){}).then(function(n){if(n&&Array.isArray(n.libraries)){var r=n.libraries.length;for(var i=0;i<r;i++){var t=n.libraries[i];if(e===t.name||e.indexOf(t.name+".")===0){return t.name}}}return"sap.ui.core"})}function t(e,n){return new Promise(function(r,t){if(n){r(n);return}sap.ui.require([e.replaceAll(".","/")],function(t){if(t&&t.getMetadata){var u=t.getMetadata();if(u.getLibraryName){n=u.getLibraryName()}else{n="sap.ui.core"}return r(n)}return i(e)},t)})}function u(n,r){return t(n,r).then(function(n){return e.getLibraryElementsJSONPromise(n)}).then(function(e){var r,i;for(var t=0,u=e.length;t<u;t++){if(e[t].name===n){r=e[t];break}}if(r){i={baseType:r.extends,deprecation:r.deprecatedText?r.deprecatedText:null,doc:r.description,module:r.module,name:r.name,since:r.since,values:r.properties,uxGuidelinesLink:r.uxGuidelinesLink,uxGuidelinesLinkText:r.uxGuidelinesLinkText,docuLink:r.docuLink,docuLinkText:r.docuLinkText}}return i})}return{getEntityDocuAsync:function(e,n){return u(e,n)}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/Highlighter", [],function(){"use strict";var e={};e.CURRENTLY_HIGHLIGHTED_DOM_REFS=[];e.MUTATION_OBSERVER=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;var t=function e(t,i){this._bIsCaseSensitive=!!i.isCaseSensitive;this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._aOldTerms=[];this._aRegExTerms=[];this._bUseExternalStyles=!!i.useExternalStyles;this._oObserver=null;if(Array.isArray(t)){this._oDomRef=t}else{this._oDomRef=[t]}this._oDomRef.forEach(this.validate,this);if(i.shouldBeObserved){this._addMutationObserver()}};t.prototype.validate=function(t){if(e.CURRENTLY_HIGHLIGHTED_DOM_REFS.indexOf(t)===-1){e.CURRENTLY_HIGHLIGHTED_DOM_REFS.forEach(function(e){if(this._bIsDomNodeDescendant(t,e)){throw new Error("Desired DOM Ref is parent of DOM Ref which is being highlighted.")}else if(this._bIsDomNodeDescendant(e,t)){throw new Error("Desired DOM Ref is child of DOM Ref which is being highlighted.")}},this);e.CURRENTLY_HIGHLIGHTED_DOM_REFS.push(t)}else{throw new Error("Highlighter instance is already created for this DOM Reference")}};t.prototype.highlight=function(e){var t;if(!e){this._restorePreviouslyHighlightedNodes();this._aRegExTerms=[];this._aOldTerms=[];return}t=this._formatTerms(e);if(!t||!t.length||this._isNewTermsSameAsOld(t)){return}this._aOldTerms=t;this._cacheRegExTerms();if(this._aPreviouslyHighlightedNodes&&this._aPreviouslyHighlightedNodes.length>0){this._restorePreviouslyHighlightedNodes()}this._toggleMutationObserver(false);this._oDomRef.forEach(function(e){this._highlightSubTree(e)},this);this._toggleMutationObserver(true)};t.prototype._cacheRegExTerms=function(){var e;this._aRegExTerms=[];this._aOldTerms.forEach(function(t){t=this._escapeRegExp(t);e=this._bIsCaseSensitive?new RegExp(t,"g"):new RegExp(t,"gi");this._aRegExTerms.push(e)},this)};t.prototype._escapeRegExp=function(e){return e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&")};t.prototype._isNewTermsSameAsOld=function(e){var t=this._aOldTerms.length,i;if(t!==e.length){return false}for(i=0;i<t;i++){if(this._aOldTerms[i]!==e[i]){return false}}return true};t.prototype._highlightSubTree=function(e){var t,i;for(i=0;i<e.childNodes.length;i++){t=e.childNodes[i];this._processNode(t)}};t.prototype._processNode=function(e){var t,i,s,r,o,n,h,a,l,u;if(e.nodeName==="IFRAME"){this._highlightSubTree(e.contentDocument.body);return}if(e.nodeType===document.ELEMENT_NODE){this._highlightSubTree(e)}else if(e.nodeType===document.TEXT_NODE){t=e.data;o=Object.create(null);a=[];for(s=0;s<this._aRegExTerms.length;s++){i=this._aRegExTerms[s];while((h=i.exec(t))!==null){l=h["index"];if(a.indexOf(l)===-1){n=h["0"];o[l]=n;for(r=l;r<l+n.length;r++){a.push(r)}}}}if(Object.keys(o).length!==0){u=this._createHighlightedNode(o,t);this._replaceNode(e,u)}}};t.prototype._formatTerms=function(e){var t=e&&e.replace(/\s+/g," ").trim().split(" "),i;i=t.reduce(function(e,t){if(e.indexOf(t)===-1){e.push(t)}return e},[]);return i.sort(function(e,t){return t.length-e.length})};t.prototype._replaceNode=function(e,t){if(e.parentNode){e.parentNode.replaceChild(t,e);this._aPreviouslyHighlightedNodes.push(t);this._aPreviouslyOriginalNodes.push(e)}};t.prototype._restorePreviouslyHighlightedNodes=function(){var e,t;this._toggleMutationObserver(false);for(var i=0;i<this._aPreviouslyHighlightedNodes.length;i++){e=this._aPreviouslyHighlightedNodes[i];t=this._aPreviouslyOriginalNodes[i];if(e.parentNode){e.parentNode.replaceChild(t,e)}}this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._toggleMutationObserver(true)};t.prototype._createHighlightedNode=function(e,t){var i=document.createElement("span"),s=[],r=function(e,t){return parseInt(e)>parseInt(t)},o=Object.keys(e).sort(r),n,h=0;for(var a=0;a<o.length;a++){var l=Number(o[a]),u=e[l],d=u.length,g=t.substring(h,l);if(g.length){s.push(g)}s.push(u);h=l+d}if(h<t.length){s.push(t.substring(h))}for(n in s){var f=document.createElement("span");f.innerText=s[n];if(Object.values(e).indexOf(s[n])>-1){f.classList.add("defaultHighlightedText")}i.appendChild(f)}return i};t.prototype._addMutationObserver=function(){this._instantiateMutationObserver();this._toggleMutationObserver(true)};t.prototype._removeMutationObserver=function(){this._toggleMutationObserver(false);this._oObserver=null;this._oDomRef=[]};t.prototype._toggleMutationObserver=function(e){if(e){this._oDomRef.forEach(function(e){this._oObserver.observe(e,this.oObserverConfig)},this)}else{this._oObserver.disconnect()}};t.prototype._bIsDomNodeDescendant=function(e,t){return e.contains(t)};t.prototype._instantiateMutationObserver=function(){this.oObserverConfig={attributes:false,childList:true,characterData:true,subtree:true};this._oObserver=new e.MUTATION_OBSERVER(this._onMutationDetectionCallback.bind(this))};t.prototype._onMutationDetectionCallback=function(e){var t,i;this._toggleMutationObserver(false);e.forEach(function(e){if(e.type==="childList"){t=e.addedNodes;for(var s=0;s<t.length;s++){i=t[s];this._processNode(i)}}else if(e.type==="characterData"){this._processNode(e.target)}},this);this._toggleMutationObserver(true)};t.prototype.destroy=function(){this._removeMutationObserver()};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/JSDocUtil", ["sap/base/strings/escapeRegExp"],function(r){"use strict";function e(r,e){return"<code>"+(e||r)+"</code>"}function a(a,t){t=t||{};var n=t.beforeParagraph==null?"<p>":t.beforeParagraph;var f=t.afterParagraph==null?"</p>":t.afterParagraph;var i=t.beforeFirstParagraph==null?n:t.beforeFirstParagraph;var s=t.afterLastParagraph==null?f:t.afterLastParagraph;var l=typeof t.linkFormatter==="function"?t.linkFormatter:e;var p=/(<pre>)|(<\/pre>)|(<h[\d+]>)|(<\/h[\d+]>)|\{@link\s+([^}\s]+)(?:\s+([^\}]*))?\}|((?:\r\n|\r|\n)[ \t]*(?:\r\n|\r|\n))/gi;var u=false;a=a||"";l=l||e;a=i+a.replace(p,function(r,e,a,t,i,s,p,o){if(e){u=true}else if(a){u=false}else if(t){if(!u){return f+r}}else if(i){if(!u){return r+n}}else if(o){if(!u){return f+n}}else if(s){if(!u){return l(s,p)}}return r})+s;a=a.replace(new RegExp(r(n)+"s*"+r(f),"g"),"");return a}return{formatTextBlock:a}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/NewsInfo", ["sap/ui/core/Core","sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/util/Resources","sap/base/Log"],function(e,jQuery,t,n){"use strict";var r={},i=[],s=[],a=null,o=false,u="OLD_NEWS_IDS",c,f;function l(e){if(r["newsRSS"]){return Promise.resolve(r["newsRSS"])}f=e;c=f.LOCAL_STORAGE_NAMES[u];return e._requireConfigJSON().then(L).then(w).then(d).catch(function(e){a=e.message;n.error(a)}).finally(v)}function d(){if(o){return Promise.resolve()}var e=f.getLocalStorageItem(c);return new Promise(function(t){var n=r["newsRSS"].items,a;if(Array.isArray(e)){for(var u=0;u<n.length;u++){a=n[u];if(e.indexOf(a.id)!==-1){s.push(a)}else{i.push(a)}}}else{i=n.slice()}o=true;t()})}function h(){return a}function p(){return i}function S(){return s}function g(e){var t=i.indexOf(e),n=f.getLocalStorageItem(c)||[];if(t>-1){i.splice(t,1)}s.push(e);n.push(e.id);f.setLocalStorageItem(c,n);v()}function m(){var e=f.getLocalStorageItem(c)||[],t;for(var n=0;n<i.length;n++){t=i[n];s.push(t);e.push(t.id)}i=[];f.setLocalStorageItem(c,e);v()}function w(){var e=r["newsRSS"].items;e.forEach(function(e){e.updated=new Date(e.updated).toLocaleString()})}function v(){e.getEventBus().publish("newsChanged","onDemoKitNewsChanged")}function L(e){return new Promise(function(i){jQuery.ajax(t.getResourceOriginPath(e.feedPath),{type:"GET",dataType:"xml",success:function(e){var t=[];jQuery("item",e).each(function(){var e={};e.title=jQuery(this).find("title").eq(0).text();e.link=jQuery(this).find("link").eq(0).text();e.description=jQuery(this).find("description").eq(0).text();e.updated=jQuery(this).find("pubDate").eq(0).text();e.id=jQuery(this).find("guid").eq(0).text();t.push(e)});r["newsRSS"]={items:t};i(r["newsRSS"])},error:function(){n.error("failed to load news rss");r["newsRSS"]=null;i()}})})}return{moveAllNewItemsToOld:m,moveNewItemToOld:g,prepareNewsData:l,getPreparationFailureMessage:h,getNewNewsArray:p,getOldNewsArray:S}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/ResourceDownloadUtil", [],function(){"use strict";var e={};var t={fetch:function(t,r,n){if(!(t in e)||n){e[t]=this._fetch(t,r)}return e[t]},_fetch:function(e,r){return new Promise(function(n,s){var o,u,i=this._getExpectedResponseType(e,r);function f(r){u=r.type==="load"&&(o.status===200||o.status===0);if(!u){s(new Error("could not fetch '"+e+"': "+o.status));return}n(t._readResponse(o))}o=new XMLHttpRequest;o.open("GET",e,true);o.responseType=i;o.onload=o.onerror=f;o.send()}.bind(this))},_readResponse:function(e){var t=e.responseType,r=t==="text"?e.responseText:e.response;if(t==="arraybuffer"){r=new Uint8Array(r)}return r},_getExpectedResponseType:function(e,t){if(e.match(/.+(.js|.ts|.json|.less|.xml|.html|.properties|.css|.svg|.md|.txt|.feature|.yaml|.yml)$/i)||t){return"text"}return"arraybuffer"}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/ResponsiveImageMap", ["./overlay/Overlay","./Tooltip"],function(e,t){"use strict";var i=function(i){var r=i.querySelector("map"),o=i.querySelector("img");this.oImg=o;this.oMapWrapper=this.oImg.parentNode;this.oOverlay=new e(this.oImg.parentNode);this.oToolTip=new t;this.fnHandlers={areaMouseenter:this.onmouseenter.bind(this),areaMouseleave:this.onmouseleave.bind(this)};this.iOriginalWidth=o.naturalWidth;this.areas=Array.prototype.map.call(r.getElementsByTagName("area"),function(e){e.addEventListener("mouseenter",this.fnHandlers.areaMouseenter);e.addEventListener("mouseleave",this.fnHandlers.areaMouseleave);return{element:e,originalCoords:e.getAttribute("originalCoords").split(",")}},this);this.resize()};i.prototype.resize=function(){var e,t=this.oImg.offsetWidth/this.iOriginalWidth;this.areas.forEach(function(i){e=[];i.originalCoords.forEach(function(i){e.push(Math.round(i*t))});i.element.coords=e.join(",")});this.resizeOverlay();return true};i.prototype.resizeOverlay=function(){var e=this.oMapWrapper.getBoundingClientRect(),t=e.width,i=e.height;this.oOverlay.setSize(t,i)};i.prototype.onmouseenter=function(e){if(this.bAreasDisabled){return}var t=e.target.coords,i=e.target.getAttribute("shape");this.oOverlay.setShape(i,t);this.oOverlay.show();this.sTitle=this.getTooltipText(e);if(this.sTitle){e.target.setAttribute("title","");this.oToolTip.setText(this.sTitle);this.oToolTip.show(this.oOverlay.getCurrentShape().oContainer)}};i.prototype.getTooltipText=function(e){return e.target.getAttribute("title")};i.prototype.onmouseleave=function(e){if(this.sTitle){e.target.setAttribute("title",this.sTitle)}this.oOverlay.hide();this.oToolTip.hide()};i.prototype.removeEventListeners=function(){this.areas.forEach(function(e){e.element.removeEventListener("mouseenter",this.fnHandlers.areaMouseenter);e.element.removeEventListener("mouseleave",this.fnHandlers.areaMouseleave)},this)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/SearchUtil", ["sap/base/Log"],function(e){"use strict";var n={URL:sap.ui.require.toUrl("sap/ui/documentation/sdk/controller/util/IndexWorker.js"),COMMANDS:{INIT:"fetch",SEARCH:"search"},RESPONSE_FIELDS:{DONE:"bDone",SEARCH_RESULT:"oSearchResult"}},r,t;function a(){if(!r){r=new Promise(function(e,r){t=new window.Worker(n.URL);t.addEventListener("message",function(t){var a=t.data;if(t.data.error){r(t.data.error)}e(a&&a[n.RESPONSE_FIELDS.DONE]===true)},false);t.postMessage({cmd:n.COMMANDS.INIT})})}return r}function o(r,o){return new Promise(function(s,i){a().then(function(){t.addEventListener("message",function(e){var r=e.data;s(r&&r[n.RESPONSE_FIELDS.SEARCH_RESULT])},false);t.postMessage({cmd:n.COMMANDS.SEARCH,query:r,options:o})}).catch(function(n){e.error(n)})})}return{init:a,search:o}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/SidyBySideImageMap", ["./overlay/Overlay","sap/ui/documentation/sdk/controller/util/ResponsiveImageMap"],function(t,e){"use strict";var i="200",s=/.+\/(.+)/;var n=function(t,e,i){if(i){e.setAttribute(t,true)}else{e.removeAttribute(t)}};var r=function(i){var s=i.querySelector("map"),n=i.querySelector(".imagemap");e.call(this,i);this.oHighlighter=new t(this.oImg.parentNode);this.oMapWrapper=n;this.aSections=[].slice.call(i.querySelectorAll(":scope > section"));this.bStatic=i.dataset.staticType==="true";this.bRestoreSize=false;this.oMap=s;this.fnHandlers=Object.assign(this.fnHandlers,{click:this.onclick.bind(this),imgTransitionend:this.ontransitionendImage.bind(this),imgTransitionstart:this.ontransitionstartImage.bind(this),imgMouseenter:this.onmouseenterImage.bind(this),imgMouseleave:this.onmouseleaveImage.bind(this)});this.areas.forEach(function(t){t.element.addEventListener("click",this.fnHandlers.click)},this);if(!this.bStatic){this.setWidth(this.iOriginalWidth);this.oMapWrapper.addEventListener("transitionstart",this.fnHandlers.imgTransitionstart);this.oMapWrapper.addEventListener("transitionend",this.fnHandlers.imgTransitionend);this.oMapWrapper.addEventListener("mouseenter",this.fnHandlers.imgMouseenter);this.oMapWrapper.addEventListener("mouseleave",this.fnHandlers.imgMouseleave)}this.showSection(this.aSections[0].getAttribute("id"))};r.prototype=Object.create(e.prototype);r.prototype.constructor=r;r.prototype.showSection=function(t){this.aSections.forEach(function(e){n("hidden",e,e.getAttribute("id")!==t)})};r.prototype.onmouseenterImage=function(){if(this.bRestoreSize){this.setWidth(this.iOriginalWidth);this.bRestoreSize=false}};r.prototype.onmouseleaveImage=function(t){if(this.oMap.contains(t.relatedTarget)||this.oImg.contains(t.relatedTarget)){return}this.bRestoreSize=true};r.prototype.ontransitionendImage=function(t){if(t.propertyName==="width"){this.bAreasDisabled=false;this.resize()}};r.prototype.ontransitionstartImage=function(t){if(t.propertyName==="width"){this.bAreasDisabled=true}};r.prototype.highlightArea=function(t){var e=t.coords,i=t.getAttribute("shape");this.oHighlighter.setShape(i,e);this.oHighlighter.show()};r.prototype.resizeHighlighter=function(){var t=this.oMapWrapper.getBoundingClientRect(),e=t.width,i=t.height;this.oHighlighter.setSize(e,i)};r.prototype.onclick=function(t){if(this.bAreasDisabled){return}var e=t.target.alt.match(s)[1];t.preventDefault();this.showSection(e);this.resizeHighlighter();this.highlightArea(t.target);if(!this.bStatic){this.setWidth(i)}};r.prototype.removeEventListeners=function(){e.prototype.removeEventListeners.call(this);this.areas.forEach(function(t){t.element.removeEventListener("click",this.fnHandlers.click)},this);if(!this.bStatic){this.oImg.removeEventListener("transitionend",this.fnHandlers.imgTransitionend);this.oImg.removeEventListener("mouseenter",this.fnHandlers.imgMouseenter);this.oImg.removeEventListener("mouseleave",this.fnHandlers.imgMouseleave)}};r.prototype.getTooltipText=function(t){var e=t.target.getAttribute("title"),i,n,r;if(!e){i=t.target.alt.match(s)[1];n=this.getSection(i);if(n){r=n.querySelector(".title");e=r&&r.textContent}}return e};r.prototype.setWidth=function(t){this.oMapWrapper.style.width=t+"px"};r.prototype.getSection=function(t){return this.aSections.find(function(e){return e.id===t})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/ThemePicker", ["sap/ui/core/Core"],function(e){"use strict";var i={};var t="appearance",a="light",o="dark",n="hcb",h="hcw",s="auto",r=Object.create(null);r[a]="sap_horizon";r[o]="sap_horizon_dark";r[n]="sap_horizon_hcb";r[h]="sap_horizon_hcw";r[s]="sap_horizon";i.init=function(t){this.oComponent=t;this._oConfigUtil=t.getOwnerComponent().getConfigUtil();this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;this.bus=e.getEventBus();this._createConfigurationBasedOnURIInput();this._bSupportsPrefersColorScheme=!!(window.matchMedia&&(window.matchMedia("(prefers-color-scheme: dark)").matches||window.matchMedia("(prefers-color-scheme: light)").matches));if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"&&this._aConfiguration.length>0){i._applyCookiesConfiguration(this._aConfiguration)}else{i._applyDefaultConfiguration(this._aConfiguration)}};i._getTheme=function(){return r};i._updateAppearance=function(i){var n=this._bSupportsPrefersColorScheme&&i===s,h=window.matchMedia("(prefers-color-scheme: dark)").matches;if(n){this._toggleLightOrDarkAppearance(h);this._attachPrefersColorSchemeChangeListener()}else{e.applyTheme(this._getTheme()[i])}this._sLastKnownAppearanceKey=i;if(n){this.bus.publish("themeChanged","onThemeChanged",{sThemeActive:r[h?o:a]})}else{this.bus.publish("themeChanged","onThemeChanged",{sThemeActive:this._getTheme()[i]})}if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"){this._oConfigUtil.setCookie(t,i)}};i._toggleLightOrDarkAppearance=function(i){if(i){e.applyTheme(this._getTheme().dark)}else{e.applyTheme(this._getTheme().light)}};i._attachPrefersColorSchemeChangeListener=function(){var e=this,i,t;if(!this._bAttachedPrefersColorSchemeChangeListener){i=window.matchMedia("(prefers-color-scheme: dark)");t=function(i){if(e._sLastKnownAppearanceKey===s){this._toggleLightOrDarkAppearance(i.matches);e.bus.publish("themeChanged","onThemeChanged",{sThemeActive:r[i.matches?o:a]})}};if(i.addEventListener){i.addEventListener("change",t)}else{i.addListener(t)}this._bAttachedPrefersColorSchemeChangeListener=true}};i._applyCookiesConfiguration=function(){var e,i,a;for(a=0;a<this._aConfiguration.length;a++){i=this._aConfiguration[a];e=this._oConfigUtil.getCookieValue(i);if(e!==""){if(i===t){this._updateAppearance(e,this.oComponent)}this._aConfiguration.splice(a,1);a--}}if(this._aConfiguration.length>0){this._applyDefaultConfiguration()}};i._applyDefaultConfiguration=function(){this._aConfiguration.forEach(function(e){if(e===t){this._updateAppearance(s)}},this)};i._createConfigurationBasedOnURIInput=function(){var e=new URLSearchParams(window.location.search);this._aConfiguration=[];if(!(e.has("sap-ui-theme")||e.has("sap-theme"))){this._aConfiguration.push(t)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/ToolsInfo", [],function(){"use strict";var e=[{id:"uiThemeDesigner",text:"UI Theme Designer",href:"https://www.sap.com/community/topics/ui-theme-designer.html"},{id:"businessApplicationStudio",text:"SAP Business Application Studio",href:"http://www.sap.com/appstudio"},{id:"ui5Tooling",text:"UI5 Tooling",href:"https://github.com/SAP/ui5-tooling"},{id:"ui5Inspector",text:"UI5 Inspector",href:"https://github.com/SAP/ui5-inspector"},{id:"cardExplorer",text:"Card Explorer",href:"test-resources/sap/ui/integration/demokit/cardExplorer/index.html"},{id:"supportAssistant",text:"Support Assistant",href:"topic/57ccd7d7103640e3a187ed55e1d2c163"},{id:"iconExplorer",text:"Icon Explorer",href:"test-resources/sap/m/demokit/iconExplorer/webapp/index.html"},{id:"themeParameterToolbox",text:"Theme Parameter Toolbox",href:"test-resources/sap/m/demokit/theming/webapp/index.html"},{id:"ui5WebComponents",text:"UI5 Web Components",href:"https://sap.github.io/ui5-webcomponents/"},{id:"liveEditor",text:"Live Editor",href:"liveEditor",hideOnPhone:true},{id:"fioriTools",text:"SAP Fiori Tools",href:"https://help.sap.com/viewer/product/SAP_FIORI_tools/Latest/en-US"},{id:"flexibleProgrammingModelExplorer",text:"Flexible Programming Model Explorer",href:"test-resources/sap/fe/core/fpmExplorer/index.html#/overview/introduction",isDistributionScope:true,hideOnPhone:true},{id:"accessibilityGuide",text:"Accessibility Guide",href:"test-resources/sap/m/demokit/accessibilityGuide/webapp/index.html",hideOnPhone:true},{id:"ui5TestRecorder",text:"Test Recorder",href:"topic/2535ef9272064cb6bd6b44e5402d531d",hideOnPhone:true}];return{getToolsConfig:function(){return Promise.resolve(e)}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/Tooltip", ["sap/m/Popover","sap/m/Text","sap/m/library"],function(e,t,o){"use strict";var n=o.PlacementType,r=(new t).addStyleClass("sapUiSmallMargin"),a=new e({showHeader:false,placement:n.VerticalPreferredTop,horizontalScrolling:false,contentWidth:"200px",content:r}).addStyleClass("imagemap-overlay-popover");function p(){}p.prototype.setText=function(e){r.setText(e)};p.prototype.show=function(e){a.openBy(e)};p.prototype.hide=function(){a.close()};p.prototype.getPopoverDomRef=function(){return a.getDomRef()};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/TreeUtil", [],function(){"use strict";var e=function(e,t){this.nodeIdField=e;this.childrenField=t};e.prototype.getPathToNode=function(e,t){var i=[];this._walkTree(e,t,i);return i};e.prototype._walkTree=function(e,t,i){var r=this._findLeaf(t,e);if(r){i.push(e);return true}for(var n=0;n<t.length;n++){if(t[n][this.childrenField]){i.push(t[n][this.nodeIdField]);if(this._walkTree(e,t[n][this.childrenField],i)){return true}i.pop()}}};e.prototype._findLeaf=function(e,t){for(var i=0;i<e.length;i++){if(e[i][this.nodeIdField]===t){return e[i]}}return null};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/URLUtil", ["sap/ui/thirdparty/URI"],function(e){"use strict";var t=new RegExp("^([0-9]+)(?:\\.([0-9]+)(?:\\.([0-9]+))?)?(.+)?"),r=[/^\/controls/,/^\/group/,/^\/entity/,/^\/sample/,/^\/downloads/,/^\/api/,/^\/topic/,/^\/liveEditor/,/^\/sitemap\//,/\/sitemap$/,/^\/demoapps/,/^\/tools/,/^\/news\//,/\/news$/,/^\/search\//,/^\/license[.]txt/,/^\/docs\/guide/,/^\/docs\/api\/symbols/];function n(e){return r.some(function(t){return t.test(e)})}return{parseVersion:function(r){var i=new e(r),o=i.segment(),s;if(n(i.path())){return}for(var a=0,u=o.length;a<u;a++){if(t.test(o[a])){s=o[a];break}if(n("/"+o[a]+"/")){break}}return s},removeVersion:function(t){var r=new e(t),n=r.path(),i=this.parseVersion(t);if(i){n=n.substring(n.indexOf(i)+i.length);r.path(n);return r.href()}return t},requestsDemokitView:function(t){if(this.hasSEOOptimizedFormat(t)){return true}return n(new e(t).fragment())},hasSEOOptimizedFormat:function(t){var r=new e(t).path();if(n(r)){return true}t=this.removeVersion(t);r=new e(t).path();return n(r)},convertToNonSEOFormat:function(t){var r=new e(t),n=new e(this.removeVersion(t)).path(),i=r.fragment(),o,s;o=r.path().replace(n,"/");s=n;if(i){s+=encodeURIComponent("#")+i}r.path(o);r.fragment(s);return r.href()}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/XML2JSONUtils", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";function e(e,n){var i=r(e,n);var a=["topictitle1","shortdesc"];var u=n.preservedContent&&n.preservedContent.length&&n.preservedContent.map(function(e){return e.className});var c=function(e){var r;n.preservedContent.forEach(function(t){if(t.className===e){r=t.preservedTags}});return r};var o=function(e,r){var n=u&&u.indexOf(e)>-1;if(n){return jQuery("<div></div>").html(t(r,c(e))).html()}return jQuery("<div></div>").html(t(r)).text()};var l=function(e,r){var t=r||i;var n=t.getElementsByClassName(e);if(n.length===0){return""}var a=n[0].innerHTML,u=o(e,a);return n&&n.length>0&&"innerHTML"in n[0]&&u||""};var s=function(e){var r=e.querySelectorAll("img");for(var t=0;t<r.length;t++){if(r[t].classList.contains("link-external")){r[t].setAttribute("src","./resources/sap/ui/documentation/sdk/images/link-external.png");continue}r[t].setAttribute("src",n.docuPath+r[t].getAttribute("src"))}return e.innerHTML};var f=function(){var e=i,r=e.querySelectorAll("script, .topictitle1"),t=[".shortdesc"],n,a,u;r=Array.prototype.slice.call(r);t.forEach(function(t){n=e.querySelector(t);if(n&&r.indexOf(n)===-1){r.push(n)}});for(var u=0;u<r.length;u++){a=r[u].parentElement;if(a){a.removeChild(r[u])}}s(e);v["html"]=e.innerHTML};var v={},d;a.forEach(function(e,r){v[e]=l(e)});d=i.querySelector(".mdeditlink");if(d){v.mdEditLink=d.getAttribute("href")}f();return v}function r(e,r){var t=jQuery.parseHTML(e);var n=r.topicHtmlMainDivId;for(var i=0;i<t.length;i++){if(t[i].getAttribute&&t[i].getAttribute("id")===n){var a='<div id ="'+n+'">'+t[i].innerHTML+"</div>";t[i].innerHTML=a;return t[i]}}}function t(e,r){if(r===undefined||r.length===0){return n(e)}return e.replace(/<\/?([^>]+)>/g,function(e,t){if(r.indexOf(t)===-1){return""}return e}).replace(/\s{2,}/g," ")}function n(e){return e.replace(/<[^>]*>/g," ").replace(/\s{2,}/g," ")}return{DomXml2JSON:e,XML2DOM:r,XML2JSON:e,removeHTMLTags:t}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterDropDown", ["sap/ui/core/Control","./DataTableFilterDropDownRenderer"],function(t,e){"use strict";var i=t.extend("sap.ui.documentation.sdk.DataTableFilterDropDown",{metadata:{properties:{checked:{type:"array",defaultValue:[]},options:{type:"array",defaultValue:[]},expanded:{type:"boolean",defaultValue:false,visibility:"hidden"}}},renderer:e});i.M_EVENTS={CHANGE:"change"};i.isCheckbox=function(t){return t.tagName.toLowerCase()==="input"&&t.type==="checkbox"};i.prototype.setAll=function(t){var e=this.getChecked();for(var i=0;i<e.length;i++){e[i].value=t;this.optionsList.find("input[index="+i+"]").prop("checked",t)}this.setChecked(e,true)};i.prototype.init=function(){this.setChecked([])};i.prototype.onBeforeRendering=function(){var t=this.getChecked(),e;if(t.length===0){e=this.getOptions();for(var i=0;i<e.length;i++){t[i]={text:e[i],value:false}}this.setChecked(t,true)}this.detachEvents()};i.prototype.onAfterRendering=function(){this.cacheElements();this.attachEvents()};i.prototype.cacheElements=function(){this.filterBtn=this.$("filterBtn");this.optionsList=this.$("optionsList")};i.prototype.detachEvents=function(){if(this.filterBtn){this.filterBtn.off("click")}if(this.optionsList){this.optionsList.off("click")}};i.prototype.attachEvents=function(){this.filterBtn.on("click",function(){this.setProperty("expanded",!this.getProperty("expanded"))}.bind(this));this.optionsList.on("click",this.onClick.bind(this))};i.prototype.onsapfocusleave=function(t){this.setProperty("expanded",false)};i.prototype.onClick=function(t){var e,n=this.getChecked(),s=t.target,o=i.isCheckbox(s),r=s.classList.contains("selectAll"),a=s.classList.contains("clearFilter"),l=o||r||a;if(o){e=s.getAttribute("index");n[e].value=t.target.checked;this.setProperty("checked",n,true)}else if(r){this.setAll(true,false)}else if(a){this.setAll(false,false)}if(l){this.fireEvent("change",{value:n})}};i.prototype.getDefaultOptions=function(t){return[{text:"Clear Filter",key:"clearFilter"},{text:"Select All",key:"selectAll"}]};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterDropDownRenderer", [],function(){"use strict";var t={apiVersion:2};t.render=function(t,e){t.openStart("div",e);t.class("selectWrapper");t.openEnd();t.openStart("a",e.getId()+"-filterBtn");t.class("filterBtn");t.attr("tabindex",0);t.openEnd();t.text("Filter");t.close("a");t.openStart("ul",e.getId()+"-optionsList");t.attr("tabindex",0);if(!e.getProperty("expanded")){t.style("display","none")}t.openEnd();this.renderDefaultOptions(t,e);this.renderOptions(t,e);t.close("ul");t.close("div")};t.renderOptions=function(t,e){var n=e.getOptions(),o=e.getChecked();n.forEach(function(e,n){t.openStart("li");t.openEnd();t.voidStart("input");if(o[n].value){t.attr("checked","true")}t.attr("type","checkbox");t.attr("id","dropDownFilterOption"+n);t.attr("index",n);t.voidEnd();t.openStart("label");t.attr("for","dropDownFilterOption"+n);t.openEnd();t.text(e);t.close("label");t.close("li")})};t.renderDefaultOptions=function(t,e){e.getDefaultOptions().forEach(function(e){t.openStart("li");t.openEnd();t.openStart("a");t.attr("tabindex",0);t.class(e.key);t.openEnd();t.text(e.text);t.close("a");t.close("li")})};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterRange", ["sap/ui/core/Control","./DataTableFilterRangeRenderer"],function(t,e){"use strict";var a=t.extend("sap.ui.documentation.sdk.DataTableFilterRange",{metadata:{aggregations:{from:{type:"sap.m.Input",multiple:false},to:{type:"sap.m.Input",multiple:false}}},renderer:e});a.M_EVENTS={LIVECHANGE:"liveChange"};a.prototype.onBeforeRendering=function(){this.attachEvents()};a.prototype.attachEvents=function(){var t,e,a;if(!this.bEventsAttached){this.bEventsAttached=true;e=this.getAggregation("from");a=this.getAggregation("to");[e,a].forEach(function(n){n.attachLiveChange(function(){t={from:e.getValue(),to:a.getValue()};this.fireEvent("liveChange",{value:t})},this)},this)}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterRangeRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,r){var n=r.getAggregation("from"),t=r.getAggregation("to");e.openStart("div",r);e.openEnd();if(n){e.renderControl(n)}if(t){e.renderControl(t)}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/overlay/Overlay", ["./shapes/ShapeFactory"],function(t){"use strict";var e="http://www.w3.org/2000/svg";function i(t){var i=document.createElementNS(e,"svg"),n=t.getBoundingClientRect(),o=n.width,r=n.height;i.setAttribute("viewBox","0 0 "+o+" "+r);i.setAttribute("class","overlay");t.appendChild(i);return i}function n(t){this.oContainer=i(t);this.oShapes={};this.sCurrentShapeType=""}n.prototype.setSize=function(t,e){this.oContainer.setAttribute("viewBox","0 0 "+t+" "+e)};n.prototype.setShape=function(e,i){var n=this.oShapes[e];if(!n){n=t.create(e,i);n.setPosition(i);this.oShapes[e]=n;this.oContainer.appendChild(n.oContainer)}else{n.setPosition(i)}this.sCurrentShapeType=e};n.prototype.getCurrentShape=function(){return this.oShapes[this.sCurrentShapeType]};n.prototype.show=function(){var t=this.getCurrentShape();if(t){t.show()}};n.prototype.hide=function(){var t=this.getCurrentShape();if(t){t.hide()}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/overlay/shapes/Circle", ["./Shape"],function(t){"use strict";var e=t.extend();e.prototype.setPosition=function(t){var e=t.split(","),i={cx:e[0],cy:e[1],r:e[2]};this.oContainer.setAttribute("cx",i.cx);this.oContainer.setAttribute("cy",i.cy);this.oContainer.setAttribute("r",i.r)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/overlay/shapes/Polygon", ["./Shape"],function(t){"use strict";var e=t.extend();e.prototype.setPosition=function(t){this.oContainer.setAttribute("points",t)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/overlay/shapes/Rect", ["./Shape"],function(t){"use strict";var i=t.extend();i.prototype.setPosition=function(t){var i=t.split(","),e={x:i[0],y:i[1],width:i[2]-i[0],height:i[3]-i[1]};this.oContainer.setAttribute("x",e.x);this.oContainer.setAttribute("y",e.y);this.oContainer.setAttribute("width",e.width);this.oContainer.setAttribute("height",e.height)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/overlay/shapes/Shape", [],function(){"use strict";function t(){this.oContainer=null}t.extend=function(){var o=function(){};o.prototype=new t;o.prototype.constructor=o;return o};t.prototype.createShape=function(t,o){this.oContainer=document.createElementNS(t,o);this.oContainer.setAttribute("class",["shape",o].join(" "));return this};t.prototype.setPosition=function(t){};t.prototype.show=function(){this.oContainer.style.opacity="1"};t.prototype.hide=function(){this.oContainer.style.opacity="0"};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controller/util/overlay/shapes/ShapeFactory", ["./Rect","./Polygon","./Circle"],function(e,r,t){"use strict";var c="http://www.w3.org/2000/svg";function n(n){switch(n){case"rect":return(new e).createShape(c,n);case"poly":return(new r).createShape(c,"polygon");case"circle":return(new t).createShape(c,n);default:}}return{create:n}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/controls/FileEditor", ["../util/FileUtils","sap/base/util/extend","sap/m/IconTabHeader","sap/m/IconTabFilter","sap/m/Image","sap/m/MessageStrip","sap/ui/codeeditor/CodeEditor","sap/ui/core/Control"],function(e,t,i,r,s,n,o,a){"use strict";var l=a.extend("sap.ui.documentation.sdk.controls.FileEditor",{metadata:{properties:{files:{type:"object[]",defaultValue:[]},editable:{type:"boolean",defaultValue:true}},aggregations:{_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_editor:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_readOnlyWarningStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_errorsStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_schemaErrorsStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_image:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{beforeFileChange:{parameters:{sFile:{type:"string"}}},fileChange:{},fileSwitch:{parameters:{editable:{type:"boolean"}}}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapUiFileEditor").style("height","100%").openEnd();e.openStart("div").class("sapUiFileEditorHeader").openEnd();e.renderControl(t._getErrorsStrip());e.renderControl(t._getSchemaErrorsStrip());e.renderControl(t._getReadOnlyWarningStrip());if(t.getFiles().length>1){e.renderControl(t._getHeader())}e.close("div");e.openStart("div").class("sapUiFileEditorContent").openEnd();e.renderControl(t._getImage());e.renderControl(t._getEditor());e.close("div");e.close("div")}}});l.prototype.init=function(){this._bFetch=false;this._aFiles=[]};l.prototype.onBeforeRendering=function(){if(!this._bFetch){return}this._bFetch=false;this._fetchContents()};l.prototype.setFiles=function(e){this._getHeader().destroyItems();this._bFetch=true;this._bFirstRefresh=2;this._createInternalFiles(e);return this.setProperty("files",e)};l.prototype._getHeader=function(){var e=this.getAggregation("_header");if(!e){e=new i(this.getId()+"-header",{select:this._onFileSwitch.bind(this)});this.setAggregation("_header",e)}return e};l.prototype._getEditor=function(){var e=this.getAggregation("_editor");if(!e){e=new o(this.getId()+"-editor",{liveChange:this._onFileEdit.bind(this),syntaxHints:false});e._oEditor.session.on("changeAnnotation",this._onSyntaxError.bind(this));e._oEditor.completers=[];this.setAggregation("_editor",e)}return e};l.prototype._getReadOnlyWarningStrip=function(){var e=this.getAggregation("_readOnlyWarningStrip");if(!e){e=new n({showIcon:true,type:"Information",text:"This file is read-only.",visible:false});this.setAggregation("_readOnlyWarningStrip",e)}return e};l.prototype._getErrorsStrip=function(){var e=this.getAggregation("_errorsStrip");if(!e){e=new n({showIcon:true,type:"Error",visible:false});this.setAggregation("_errorsStrip",e)}return e};l.prototype._getSchemaErrorsStrip=function(){var e=this.getAggregation("_schemaErrorsStrip");if(!e){e=new n({showIcon:true,type:"Error",visible:false});this.setAggregation("_schemaErrorsStrip",e)}return e};l.prototype._getImage=function(){var e=this.getAggregation("_image");if(!e){e=new s(this.getId()+"-image",{width:"100%"});this.setAggregation("_image",e)}return e};l.prototype._update=function(){var t=this._getHeader().getSelectedKey(),i=t.split(".").pop(),r=this._aFiles.findIndex(function(e){return e.key===t}),s=this._aFiles[r],n=s.editable;switch(i){case"js":i="javascript";break;case"cds":i="red";break;default:break}this._getReadOnlyWarningStrip().setVisible(!n);this._getErrorsStrip().setVisible(false);this._getSchemaErrorsStrip().setVisible(false);if(e.isBlob(t)){this._getImage().setSrc(s.content).setVisible(true);this._getEditor().setVisible(false)}else{this._bPreventLiveChange=true;this._getEditor().setEditable(n).setType(i).setValue(s.content).setVisible(true);this._bPreventLiveChange=false;this._getImage().setVisible(false)}this.fireFileSwitch({editable:n})};l.prototype._createIconTabFilters=function(){this._getHeader().destroyItems();this._aFiles.forEach(function(e){this._getHeader().addItem(new r({key:e.key,text:e.name}))}.bind(this))};l.mimetypes={js:"text/javascript",json:"application/json",html:"text/html",properties:"text/plain"};l.prototype._fetchContents=function(){var t=this._aFiles.map(function(t){var i=t.url,r=i.substring(t.url.lastIndexOf(".")+1);t._type=l.mimetypes[r]||"text/plain";t.promise=e.fetch(i);return t.promise});Promise.all(t).then(function(e){e.map(function(e,t){this._aFiles[t]._url=URL.createObjectURL(new Blob([e],{type:this._aFiles[t]._type}));this._aFiles[t].content=e}.bind(this));this._getHeader().setSelectedKey(this._aFiles[0].key);this._createIconTabFilters();this._update();window.postMessage("sampleLoaded")}.bind(this)).catch(function(e){this._getErrorsStrip().setVisible(true).setText(e)}.bind(this))};l.prototype._onFileSwitch=function(e){this._update()};l.prototype._onFileEdit=function(e){if(this._bFirstRefresh>0&&e.mParameters.editorEvent.action==="insert"){this._bFirstRefresh--;return}if(this._bPreventLiveChange){return}if(e.getParameter("value")===""){return}if(this._bClearButtonPressed&&e.getParameter("value")===""){this._bClearButtonPressed=false;return}var t=this.getAggregation("_header").getSelectedKey();var i=this._aFiles;var r=i.find(function(e){return e.key===t});if(!r||r.content===e.getParameter("value")){return}this.fireBeforeFileChange({sFile:t});r.content=e.getParameter("value");var s=this;fetch(r.url,{method:"POST",body:r.content}).then(function(e){return e.text()}).then(function(e){s.fireFileChange()}).catch(function(e){})};l.prototype._setClearButtonPressed=function(e){this._bClearButtonPressed=true};l.prototype._findIndex=function(e){return this._aFiles.findIndex(function(t){return t.key===e})};l.prototype._onSyntaxError=function(){var e=this._getEditor()._oEditor.session.$annotations,t="";if(e&&e.length){e.forEach(function(e){t+="Line "+String(e.row)+": "+e.text+"\n"});this._getErrorsStrip().setVisible(true).setText(t)}else{this._getErrorsStrip().setVisible(false)}};l.prototype._createInternalFiles=function(e){this._aFiles=e.map(function(e){return t({},e,{content:"",promise:null})})};l.prototype.hideSchemaErrors=function(){this._getSchemaErrorsStrip().setVisible(false)};l.prototype.getFilesWithContent=function(){var e=this._aFiles.map(function(e){return e.promise});return Promise.all(e).then(function(){return this._aFiles}.bind(this))};l.prototype.showError=function(e){this._getErrorsStrip().setVisible(true).setText(e)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/cookieSettingsDialog/Component", ["sap/ui/core/Component","sap/ui/core/mvc/Controller","sap/ui/VersionInfo","sap/base/util/merge"],function(e,t,o,i){"use strict";var n=e.extend("sap.ui.documentation.sdk.cookieSettingsDialog.Component",{COOKIE_NAMES:{APPROVAL_REQUESTED:"dk_approval_requested",ALLOW_REQUIRED_COOKIES:"dk_allow_required_cookies"},metadata:{manifest:"json"},enable:function(e){var t=new URLSearchParams(window.location.search),o="cookie-settings-dialog",i=t.has(o);if(i){this.sCookieSettingsParameterValue=t.get(o)}if(this.sCookieSettingsParameterValue==="true"||this.sCookieSettingsParameterValue===""||!i){var n=this.getCookieValue(this.COOKIE_NAMES.APPROVAL_REQUESTED)==="1";if(!n){this.cookieSettingsDialogOpen({showCookieDetails:false,enableAdvancedSettings:false},e)}}},setCookie:function(e,t){var o,i=new Date;i.setTime(i.getTime()+356*24*60*60*1e3);o="expires="+i.toUTCString();document.cookie=e+"="+t+";"+o+";path=/"},getCookieValue:function(e){var t=document.cookie.split(";"),o;e=e+"=";for(var i=0;i<t.length;i++){o=t[i].trim();if(o.indexOf(e)===0){return o.substring(e.length,o.length)}}return""},cookieSettingsDialogOpen:function(e,t){this.getCookieSettingsController().then(function(o){o.openCookieSettingsDialog(e,t,this)}.bind(this))},getCookieSettingsController:function(){if(!this.oCookieSettingsControllerPromise){this.oCookieSettingsControllerPromise=new Promise(function(e,o){t.create({name:"sap.ui.documentation.sdk.cookieSettingsDialog.controller.CookieSettingsDialog"}).then(function(t){e(t)})})}return this.oCookieSettingsControllerPromise}});return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/cookieSettingsDialog/controller/CookieSettingsDialog.controller", ["sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/ui/core/Fragment","sap/ui/model/resource/ResourceModel","sap/ui/core/Core"],function(o,e,i,t,s){"use strict";return o.extend("sap.ui.documentation.sdk.cookieSettingsDialog.controller.CookieSettingsDialog",{constructor:function(){this._oCookiesUtil=null;this._oRootView=null;this._oInitOptions=null;this._oModel=new e},openCookieSettingsDialog:function(o,e,t){this._oInitOptions=o;this._oModel.setData(o,true);if(this._oCookieSettingsDialog){this._oCookieSettingsDialog.open()}else{this._initData(e,t);i.load({name:"sap.ui.documentation.sdk.cookieSettingsDialog.view.CookieSettingsDialog",controller:this}).then(this._initDialog.bind(this)).then(function(o){this._oCookieSettingsDialog=o;this._oCookieSettingsDialog.open()}.bind(this))}},_initDialog:function(o){var e=new t({bundleName:"sap.ui.documentation.sdk.cookieSettingsDialog.i18n.i18n"});o.setModel(this._oModel,"cookieData");o.setModel(e,"i18n");this._oRootView.addDependent(o);o.attachBeforeOpen(function(){this._oCookieSettingsDialog.toggleStyleClass("cookiesDetailedView",this._oModel.getProperty("/showCookieDetails"))},this);o.attachAfterOpen(function(){s.byId("btnSetPreferences").focus()});if(!this._bAlreadyRequestedCookiesApproval){o.attachEventOnce("afterClose",function(){this._bAlreadyRequestedCookiesApproval=true;this._oCookiesUtil.setCookie(this._oCookiesUtil.COOKIE_NAMES.APPROVAL_REQUESTED,"1")},this)}return o},formatCookieValue:function(o){return Boolean(Number(o))},onAcceptAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,true);this._oCookieSettingsDialog.close()},onRejectAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,false);this._oCookieSettingsDialog.close()},onSaveCookies:function(){var o=s.byId("requiredCookiesSwitch").getState();this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,o);this._oCookieSettingsDialog.close()},showCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",true);this._oCookieSettingsDialog.addStyleClass("cookiesDetailedView");this._focusButton(s.byId("btnSavePreferences"))},onCancelPress:function(){if(this._oInitOptions.showCookieDetails===true){this.onCancelEditCookies()}else{this.hideCookieDetails()}},hideCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",false);this._oCookieSettingsDialog.removeStyleClass("cookiesDetailedView");this._focusButton(s.byId("btnSetPreferences"))},onCancelEditCookies:function(){this._oCookieSettingsDialog.close();s.byId("requiredCookiesSwitch").setState(this._oCookiesUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1")},_saveCookiePreference:function(o,e){var i=e?"1":"0";this._oCookiesUtil.setCookie(o,i);this._oModel.setProperty("/"+o,i)},_initData:function(o,e){this._oCookiesUtil=e;this._oRootView=o;this._oCookieNames=this._oCookiesUtil.COOKIE_NAMES;this._bAlreadyRequestedCookiesApproval=this._oCookiesUtil.getCookieValue(this._oCookieNames.APPROVAL_REQUESTED)==="1";this._setInitialCookieValues()},_setInitialCookieValues:function(){var o={};if(!this._bAlreadyRequestedCookiesApproval){o[this._oCookieNames.ALLOW_REQUIRED_COOKIES]="1"}else{o[this._oCookieNames.ALLOW_REQUIRED_COOKIES]=this._oCookiesUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)}this._oModel.setData(o,true)},_focusButton:function(o){if(o.getDomRef()){o.focus();return}o.addEventDelegate({onAfterRendering:function(){o.focus();o.removeEventDelegate(this)}})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/model/ExploreSettingsModel", ["sap/ui/model/json/JSONModel"],function(e){"use strict";return new e({autoRun:true,schemaValidation:false,splitViewVertically:false,editable:true,editorType:"text",internal:window._isinternal})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/model/formatter", ["sap/ui/base/Object","sap/base/util/merge","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/base/security/sanitizeHTML","sap/ui/documentation/sdk/controller/util/URLUtil","sap/base/strings/formatMessage"],function(t,e,r,i,n,o){"use strict";var a=/^p\d+$/;var s=t.extend("sap.ui.documentation.sdk.model.formatter"),u={crossLink:function(t){if(t[0]==="#"){t=document.location.href.substring(0,document.location.href.search("demoapps.html"))+t}return t},libraryLink:function(t){if(t&&t.search("sap\\.")===0){return this.formatter.crossLink("api/"+t)}else{return""}},libraryLinkEnabled:function(t){return!!this.formatter.libraryLink.bind(this)(t)},categoryName:function(t){var e=this.getModel("i18n").getResourceBundle();t=t.toUpperCase();return e.getText("DEMO_APPS_CATEGORY_"+t)},apiRefEntityName:function(t){if(t){return t.replace("module:","")}},apiRefAggregationAltTypes:function(t){return t&&t.join(", ")},formatVisibility:function(t,e){var r=t;if(e&&Array.isArray(e)){r+=" to "+e.join(", ")}return r},formatVersionTitle:function(t,e){if(e){return this.formatMessage(t,e)}return this.getModel("i18n").getResourceBundle().getText("API_DETAIL_NA_VERSION")},formatSenderLink:function(t,e,r){if(r==="methods"){return t+"#"+e}if(r==="events"){return t+"#events:"+e}if(r==="class"){return t}return""},formatIndexByVersionEntry:function(t,e,r,i,n){var o=this.formatSenderLink(t,e,r),a=this.formatApiHref(t,e,r,i),s=this.formatLinks(n);return'<a href="'+a+'" class="sapMLnk sapMLnkMaxWidth">'+o+"</a>"+s},formatApiHref:function(t,e,r,i){var n;if(i){e=t+"."+e}n="api/"+t;if(r!=="class"){n+="/"+r+"/"+e}return n},formatLinks:function(t){return r.formatTextBlock(t,{linkFormatter:function(t,e){var r;if(t.match("://")){return'<a target="_blank" href="'+t+'">'+(e||t)+"</a>"}t=t.trim().replace(/\.prototype\./g,"#");r=t.indexOf("#");e=e||t;if(r<0){var i=t.lastIndexOf("."),n=t.substring(0,i),o=t.substring(i+1),a=o;if(a){if(a.static===true){t=n+"/methods/"+n+"."+o}else{t=n+"/methods/"+o}}}if(r===0){return"<code>"+t.slice(1)+"</code>"}if(r>0){t=t.slice(0,r)+"/methods/"+t.slice(r+1)}return'<a href="api/'+t+'" target="_self">'+e+"</a>"}})},filePathToRouteParams:function(t){var e,r={};if(!t){return{}}e=t.split("/");e.forEach(function(t,e){r["p"+ ++e]=t});return r},routeParamsToFilePath:function(t){var e=Object.keys(t),r,i,n=[];for(var o=0;o<e.length;o++){r=a.test(e[o]);i=r&&t[e[o]];if(i){n.push(i)}if(r&&!i){break}}if(n.length){return n.join("/")}},formatHttpHrefForNewWindow:function(t){if(window["sap-ui-documentation-static"]&&!/^https?:\/\//.test(t)){t="#/"+t}return t},formatImportantMessage:function(t){var e=this._getUI5Distribution();return o(t,e)},formatMessageStripLinks:function(t){var e=window["sap-ui-documentation-static"];if(t){t=i(t,{uriRewriter:function(t){if(e&&n.hasSEOOptimizedFormat("/"+t)){t=n.convertToNonSEOFormat(t).replace(/^\//,"")}return t}})}return t},formatToolCardVisibility:function(t){if(!t){return false}if(t.hideOnPhone&&this.getOwnerComponent().getModel("device").getProperty("/system/phone")){return false}if(t.isDistributionScope&&this.getOwnerComponent().getModel("versionData").getProperty("/isOpenUI5")){return false}return true}};return e(s,u)});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/model/libraryData", ["sap/ui/documentation/library","sap/base/Log","sap/base/util/extend","sap/base/util/isPlainObject","sap/ui/core/Configuration"],function(e,t,r,n,i){"use strict";var o={Template:"Template"};var a=0;function s(e,t,r){var o=i.getTheme();var s=[],c=e.ref;if(c.indexOf("#")>0){c=c.slice(0,c.indexOf("#"))+"?sap-ui-theme="+o+c.slice(c.indexOf("#"))}else{c=c+"?sap-ui-theme="+o}if(n(e.links)){s=Object.keys(e.links).map(function(t){return{name:t,ref:e.links[t]}})}var f={id:"demoapp-"+e.category+"-"+a++,lib:e.namespace||r,name:e.text,icon:e.icon,desc:e.desc,config:e.config,teaser:e.teaser,category:e.category,ref:(e.resolve==="lib"?t:"")+c,links:s};return f}function c(e,r){var n=["Showcase","Tutorial","Template","RTA","Misc"];var i={};n.forEach(function(e){i[e]=[]});var a={demoApps:[],demoAppsByCategory:[]};for(var c=0;c<e.length;c++){var f=r[e[c]].demo;if(!f){continue}if(f.links&&f.links.length>0){for(var u=0;u<f.links.length;u++){var l=s(f.links[u],r[e[c]].libraryUrl,f.text);if(o[l.category]){continue}a.demoApps.push(l);if(n.indexOf(l.category)<0){t.warning('Demo app category "'+l.category+'" not found, correcting demo app "'+l.name+'" to "Misc"');l.category="Misc"}if(f.links[u].category!=="Tool"){i[l.category].push(l)}}}}Object.keys(i).forEach(function(e){if(i[e].length===0){return}var t=[];var r=t.push([]);var n=0;for(var o=0;o<i[e].length;o++){n++;if(i[e][o].teaser){n++}if(n>4){r=t.push([]);n=0}t[r-1].push(i[e][o])}a.demoAppsByCategory.push({categoryId:e,rows:t})});return a}return{fillJSONModel:function(t){return new Promise(function(n){function i(e,i){t.setProperty("/bFooterVisible",true);if(!e){return}var o=t.getData();t.setData(r(o,c(e,i)));n(t)}t.setProperty("/bFooterVisible",false);e._loadAllLibInfo("","_getDocuIndex",i)})},getDemoAppsData:function(){return new Promise(function(t){e._loadAllLibInfo("","_getDocuIndex",function(e,r){if(!e){return}t(c(e,r))})})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/model/models", ["sap/ui/model/json/JSONModel","sap/ui/Device"],function(e,n){"use strict";return{createDeviceModel:function(){var i=new e(n);i.setDefaultBindingMode("OneWay");return i}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/util/DocumentationRouter", ["sap/m/routing/Router","sap/ui/core/routing/History","sap/ui/thirdparty/hasher","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/thirdparty/URI"],function(t,e,i,n,a){"use strict";i.raw=true;var o=t.extend("sap.ui.documentation.sdk.util.DocumentationRouter",{constructor:function(){t.prototype.constructor.apply(this,arguments);this._URLSeparator=window["sap-ui-documentation-static"]?"%23":"#";this._fnPopstateHandlerRef=this.popstateHandler.bind(this);this.getRoute("entitySamplesLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityAboutLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityPropertiesLegacyRoute").attachPatternMatched({entityType:"controlProperties"},this._forwardToAPIRef,this);this.getRoute("entityAggregationsLegacyRoute").attachPatternMatched({entityType:"aggregations"},this._forwardToAPIRef,this);this.getRoute("entityAssociationsLegacyRoute").attachPatternMatched({entityType:"associations"},this._forwardToAPIRef,this);this.getRoute("entityEventsLegacyRoute").attachPatternMatched({entityType:"events"},this._forwardToAPIRef,this);this.getRoute("entityMethodsLegacyRoute").attachPatternMatched({entityType:"methods"},this._forwardToAPIRef,this);this.getRoute("topicIdLegacyRoute").attachPatternMatched(this._onOldTopicRouteMatched,this);this.getRoute("apiIdLegacyRoute").attachPatternMatched(this._onOldApiRouteMatched,this);this.getRoute("sampleLegacyRoute").attachPatternMatched({routeName:"sample"},this._onOldSampleRouteMatched,this);this.getRoute("codeLegacyRoute").attachPatternMatched({routeName:"code"},this._onOldSampleRouteMatched,this);this.getRoute("codeFileLegacyRoute").attachPatternMatched({routeName:"codeFile"},this._onOldSampleRouteMatched,this);this.getRoute("ReleaseNotesLegacyRoute").attachPatternMatched(function(){this.navTo("releaseNotes")},this)},_removeNonStandardEncoding:function(t){return typeof t==="string"?t.replace(/[\[\]']+/g,""):t},_onOldEntityRouteMatched:function(t){this.navTo("entity",{id:t.getParameter("arguments").id},true)},_forwardToAPIRef:function(t,e){e||(e={});e["id"]=t.getParameter("arguments").id;this.navTo("apiId",e)},_onOldSampleRouteMatched:function(t,e){var i=t.getParameter("arguments"),a=i.id;n.loadData().then(function(t){var n=t.samples[a],o;if(!n){this.onRouteNotFound()}o={entityId:n.contexts?Object.keys(n.contexts)[0]:n.entityId,sampleId:a};if(e.routeName==="codeFile"){o["fileName"]=decodeURIComponent(i.fileName)}this.navTo(e.routeName,o,true)}.bind(this))},_onOldTopicRouteMatched:function(t){this.navTo("topicId",{id:t.getParameter("arguments").id.replace(/.html$/,"")},true)},_onOldApiRouteMatched:function(t){var e,i,n,a=t.getParameter("arguments").id;if(a){n=a.split("#");if(n.length===2){a=n[0];e=n[1];n=e.split(":");if(n.length===2){e=n[0];i=n[1]}}a=a.replace(/.html$/,"");if(e==="event"){e="events"}}this.navTo("apiId",{id:a,entityType:e,entityId:i},true)},myNavBack:function(t,i){var n=e.getInstance();var a=n.getPreviousHash();if(a!==undefined){window.history.go(-1)}else{var o=true;this.navTo(t,i,o)}},myNavToWithoutHash:function(t,e,i,n){var a=this._getOwnerComponent(),o=a.byId(a.getManifestEntry("/sap.ui5/rootView").id);o.loaded().then(function(a){var o=a.byId("splitApp"),r=this.getView(t,e);o.addPage(r,i);o.toDetail(r.getId(),"show",n)}.bind(this))},_getOwnerComponent:function(){return this._oOwner},_destroySampleComponent:function(){var t=this._getOwnerComponent()._oCurrentOpenedSample;if(t){t.getDomRef().contentWindow.postMessage({type:"EXIT",data:{msg:"Destroy the container"}},this._getOwnerComponent()._sSampleIframeOrigin)}}});o.prototype.linkClickHandler=function(t){if(t.defaultPrevented){t.preventDefault();return}var e=t.target,i,n,a=t.ctrlKey||t.metaKey,o;if(!e){return}if(a){return}i=r(e,true);if(!i){return}o=d(i);if(o==="javascript:void(0)"){return}n=/^blob:/.test(o)||/^https?:\/\//.test(o)||/^test-resources\//.test(o)||/^resources\//.test(o)||/^tel:/.test(o)||/^mailto:/.test(o);if(o&&!n){if(t.preventDefault){t.preventDefault()}this.parsePath(o)}};o.prototype.parsePath=function(t){if(t==="#"){t=""}if(window["sap-ui-documentation-static"]&&this.shouldConvertHash(t)){t=t.replace("#","%23")}t=this._removeNonStandardEncoding(t);this.parse(t);if(window["sap-ui-documentation-static"]){window.history.pushState({},undefined,"#/"+t)}else{window.history.pushState({},undefined,t)}};o.prototype.mouseDownClickHandler=function(t){var e=t.buttons,i=t.target,n=r(i),o=t.ctrlKey||t.metaKey,s,c,p;if(n){s=this._removeNonStandardEncoding(d(n));c=o||!h(n)}if(!s||(p=a(s)).is("absolute")||p.suffix()==="html"){return}if(e===2||e===4||c&&e===1){s=this.convertToStaticFormat(s);n.setAttribute("href",s)}};o.prototype.popstateHandler=function(){var t=!!window["sap-ui-documentation-static"],e=t?location.hash.replace(/^[#/]/,""):this._processPath(location.pathname);this.parse(e)};o.prototype.attachGlobalLinkHandler=function(){if(!this._bGlobalHandlerAttached){document.body.addEventListener("click",this.linkClickHandler.bind(this));window["sap-ui-documentation-static"]&&document.body.addEventListener("mousedown",this.mouseDownClickHandler.bind(this),true);this._bGlobalHandlerAttached=true}};o.prototype.attachPopstateHandler=function(){if(!this._bPopstateHandlerAttached){window.addEventListener("popstate",this._fnPopstateHandlerRef);this._bPopstateHandlerAttached=true}};o.prototype.detachPopstateHandler=function(){if(this._bPopstateHandlerAttached){window.removeEventListener("popstate",this._fnPopstateHandlerRef);this._bPopstateHandlerAttached=false}};o.prototype._decodeSpecialRouteArguments=function(t){var e=t.getParameters().arguments,i=[],n,a=[],o;if(e.p1===undefined){if(e.id.indexOf(this._URLSeparator)>-1){o=e.id.split(this._URLSeparator);e.id=o[0];e.p1=o[1]}return{id:decodeURIComponent(e.id),entityId:undefined,entityType:e.p1}}if(/^module:\S+$/.test(e.id)){Object.keys(e).forEach(function(t){var o=e[t],r;if(!o){return}if(!n&&o.indexOf(this._URLSeparator)!==-1){r=o.split(this._URLSeparator);i.push(r[0]);n=r[1];return}if(!n){i.push(o)}else{a.push(o)}}.bind(this));return{id:i.join("/"),entityId:a.length?a.join("/"):undefined,entityType:n}}if(e.id.indexOf(this._URLSeparator)!==-1){o=e.id.split(this._URLSeparator);e.p2=e.p1;e.id=o[0];e.p1=o[1]}return{id:decodeURIComponent(e.id),entityType:e.p1,entityId:e.p2?decodeURIComponent(e.p2):undefined}};o.prototype.navTo=function(t,e,i){var n;var a=i?"replaceState":"pushState";this._destroySampleComponent();if(t==="apiId"){if(e.id){e.id=encodeURIComponent(e.id)}if(e.entityId){e.entityId=encodeURIComponent(e.entityId)}}n=this.getURL(t,e);if(t==="apiId"){n=n.replace(/#$/,"");n=decodeURIComponent(n)}this.parse(n);if(window["sap-ui-documentation-static"]){window.history[a]({},undefined,"#/"+n.replace("#",this._URLSeparator))}else{window.history[a]({},undefined,n)}return this};if(!window["sap-ui-documentation-static"]){o.prototype._processPath=function(t){var e=document.querySelector("base[href]"),i=e?e.getAttribute("href"):"",n=i.slice(0,i.length-1),a=location.hash,o;if(t.startsWith(i)){t=t.replace(i,"")}else if(t.startsWith(n)){t=t.replace(n,"")}if(a){if(!t&&a.indexOf("module%3A")!==-1){o=a.split("/");a="#"+o[1]+"/"+decodeURIComponent(o[2])+(o[3]?"#"+o[3]:"")+(!o[3]?"/":"")+(o[4]?"/"+decodeURIComponent(o[4]):"")}t+=(t?"#":"")+a.slice(1)}return t};o.prototype.initialize=function(){var t=this._processPath(location.pathname);this.stop();this.parse(t);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this};o.prototype.navToChangeUrlOnly=function(t,e){var i;if(t.id){t.id=encodeURIComponent(t.id)}if(t.entityId){t.entityId=encodeURIComponent(t.entityId)}i=this.getURL("apiId",t);i=decodeURIComponent(i);if(e){window.history.pushState({},undefined,i)}else{window.history.replaceState({},undefined,i)}return this}}else{o.prototype.initialize=function(){this.getRoute("sample").attachPatternMatched(function(){if(new URLSearchParams(window.location.search).has("dk-sample-standalone")){document.body.style.visibility="hidden"}});t.prototype.initialize.apply(this,arguments);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this};o.prototype.navToChangeUrlOnly=function(t,e){var i;if(t.id){t.id=encodeURIComponent(t.id)}if(t.entityId){t.entityId=encodeURIComponent(t.entityId)}i=this.getURL("apiId",t);i=decodeURIComponent(i);i=i.replace("#",this._URLSeparator);this.stop();hasher.stop();this.detachPopstateHandler();if(e){hasher.setHash(i)}else{hasher.replaceHash(i)}hasher.init();this.initialize(true);this.attachPopstateHandler()}}o.prototype.shouldConvertHash=function(t){return this.getRoute("apiId").match(t)||this.getRoute("apiSpecialRoute").match(t)};o.prototype.convertToStaticFormat=function(t){var e=window.location,i=t;if(this.shouldConvertHash(t)){i=t.replace("#","%23")}i=e.origin+e.pathname+"#/"+i;return i};function r(t,e,i){var n=s(t,e),a=0;i||(i=3);while(!n&&a++<i){t=t&&t.parentElement;n=s(t,e)}return t}function s(t,e){if(t&&t.nodeName==="A"||t.nodeName==="AREA"){return e?h(t):true}return false}function d(t){return t.getAttribute("href")}function h(t){return t.getAttribute("target")!=="_blank"}return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/util/FileUtils", ["sap/base/strings/formatMessage","sap/ui/thirdparty/jquery"],function(t,jQuery){"use strict";var e={fetch:function(n){if(e.isBlob(n)){return e._fetchBlob(n)}return new Promise(function(e,r){jQuery.ajax(n,{dataType:"text"}).done(function(t){e(t)}).fail(function(e,a,i){r(t("Error {0} {1} ({2})",[e.status,n,i]))})})},isBlob:function(t){return t.match(/\.(jpeg|jpg|gif|png)$/)!==null},_fetchBlob:function(t){return new Promise(function(n,r){jQuery.ajax(t,{xhrFields:{responseType:"text"},mimeType:"text/plain; charset=x-user-defined"}).done(function(t){var r="data:image/png; base64,"+e._base64Encode(t);n(r)}).fail(function(t,e,n){r(n)})})},_base64Encode:function(t){var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var n="",r=0,a,i,c;while(r<t.length){a=t.charCodeAt(r++)&255;if(r==t.length){n+=e.charAt(a>>2);n+=e.charAt((a&3)<<4);n+="==";break}i=t.charCodeAt(r++);if(r==t.length){n+=e.charAt(a>>2);n+=e.charAt((a&3)<<4|(i&240)>>4);n+=e.charAt((i&15)<<2);n+="=";break}c=t.charCodeAt(r++);n+=e.charAt(a>>2);n+=e.charAt((a&3)<<4|(i&240)>>4);n+=e.charAt((i&15)<<2|(c&192)>>6);n+=e.charAt(c&63)}return n}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/documentation/sdk/util/ToggleFullScreenHandler", [],function(){"use strict";var t={updateMode:function(t,e,i){var p=this._getSplitApp(i).getMode()==="ShowHideMode";if(p){this._getSplitApp(i).setMode("HideMode")}else{this._getSplitApp(i).setMode("ShowHideMode")}this.updateControl(t.getSource(),e,i,p)},_getSplitApp:function(t){if(!this._oSplitApp){this._oSplitApp=t.getSplitApp()}return this._oSplitApp},updateControl:function(t,e,i,p){if(arguments.length===3){p=!(this._getSplitApp(i).getMode()==="ShowHideMode")}if(!p){t.setTooltip("Show this sample in full screen mode");t.setIcon("sap-icon://full-screen")}else{t.setTooltip("Show this sample in the detail view of a split container.");t.setIcon("sap-icon://exit-full-screen")}},cleanUp:function(){this._oSplitApp=null}};return t},true);
sap.ui.require.preload({
	"sap/ui/documentation/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.documentation","type":"library","embeds":["sdk","sdk/cookieSettingsDialog"],"applicationVersion":{"version":"1.120.31"},"title":"SAPUI5 library for the Demokit 2.0.","description":"SAPUI5 library for the Demokit 2.0.","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"esprima","packagedWithMySelf":true,"version":"1.2.2"},{"name":"highlight.js","packagedWithMySelf":true,"version":"10.4.1"},{"name":"elasticlunr","packagedWithMySelf":true,"version":"0.9.5"},{"name":"datatables","packagedWithMySelf":true,"version":"1.10.15"},{"name":"datatables-buttons","packagedWithMySelf":true,"version":"1.4.0"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_hcb","sap_belize_hcw","sap_belize_plus","sap_fiori_3","sap_fiori_3_dark","sap_fiori_3_hcb","sap_fiori_3_hcw","sap_horizon","sap_horizon_dark","sap_horizon_hcb","sap_horizon_hcw"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.31"},"sap.ui.layout":{"minVersion":"1.120.31"},"sap.m":{"minVersion":"1.120.31"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.documentation.BorrowedList","sap.ui.documentation.DemokitTreeItem","sap.ui.documentation.JSDocText","sap.ui.documentation.LightTable","sap.ui.documentation.ObjectPageSubSection","sap.ui.documentation.ParamText","sap.ui.documentation.Search","sap.ui.documentation.TitleLink"],"elements":["sap.ui.documentation.Row","sap.ui.documentation.WebPageTitleUtil"],"types":[],"interfaces":[]}}}}',
	"sap/ui/documentation/sdk/blocks/IndexEntry.view.xml":'<mvc:View\n        controllerName="sap.ui.documentation.sdk.blocks.IndexEntry"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:custom="sap.ui.documentation"\n\t\txmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><m:List items="{ path: \'apis\', templateShareable: false}"\n\t\t\tshowSeparators="Inner"\n\t\t\tclass="sapUxAPObjectPageSubSectionAlignContent"\n\t\t\twidth="auto"><m:items><m:CustomListItem\n\t\t\t\t\t\tclass="indexEntry"><custom:JSDocText text="{parts : [\n\t\t\t\t\t\t{path : \'control\'},\n\t\t\t\t\t\t{path : \'entityName\'},\n\t\t\t\t\t\t{path: \'type\'},\n\t\t\t\t\t\t{path: \'static\'},\n\t\t\t\t\t\t {path: \'text\'}],\n\t\t\t\t\t\tformatter : \'.formatText\'}"\n\t\t\t\t\t\tapp:control="{control}"\n\t\t\t\t\t\tapp:entity="{entityName}"\n\t\t\t\t\t\tapp:type="{type}"\n\t\t\t\t\t\tapp:static="{static}"\n\t\t\t\t\t\tapp:text="{text}"/></m:CustomListItem></m:items></m:List></mvc:View>\n',
	"sap/ui/documentation/sdk/controller/util/IndexWorker.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(){"use strict";fetch("../../../../../../../documentation-config.js").then(function(t){if(t.ok){importScripts(t.url);var n={getResourceOriginPath:function(e){var t=self["sap-ui-documentation-config"],n=t&&t.demoKitResourceOrigin||".";return n+this._formatPath(e)},_formatPath:function(e){e=e.replace(/^\.\//,"/");if(!e.match(/^\//)){e="/"+e}return e}};e.SEARCH_INDEX=n.getResourceOriginPath("../../../../../../../searchindex.json")}});var e={SEARCH_INDEX:"../../../../../../../searchindex.json",SEARCH_LIB:"../../thirdparty/elasticlunr.js"};var t={properties:"controlProperties",fields:"properties",aggregations:"aggregations",associations:"associations",events:"events",specialSettings:"specialsettings",annotations:"annotations",methods:"methods"},n={properties:"property",fields:"field",aggregations:"aggregation",associations:"association",events:"event",specialSettings:"specialsetting",annotations:"annotation",methods:"method"},r={documentation:"topics",samples:"entity",apiref:"apiref"};importScripts(e.SEARCH_LIB);var i={COMMANDS:{INIT:"fetch",SEARCH:"search"},RESPONSE_FIELDS:{DONE:"bDone",SEARCH_RESULT:"oSearchResult"}},o=["properties","aggregations","associations","events","methods","specialSettings","annotations"],a=o.concat(["title","contents","paramTypes"]),s=["get","set","add","insert","remove","removeAll","destroy","indexOf","attach","detach"],c=new RegExp("[a-zA-Z]+"),f=" ",u={};self.addEventListener("message",function(e){var t=e.data,n=t&&t.cmd;if(n===i.COMMANDS.INIT){d().then(function(){var e={};e[i.RESPONSE_FIELDS.DONE]=true;self.postMessage(e)})}else if(n===i.COMMANDS.SEARCH){l(e.data.query,e.data.options).then(function(e){var t={};t[i.RESPONSE_FIELDS.SEARCH_RESULT]=e;self.postMessage(t)})}},false);function d(){return new Promise(function(t,n){var r=u["index"],i;if(r){t(r);return}var o=new XMLHttpRequest,a=function(e){if(e.target.response===null){return self.postMessage({error:"Resource file searchindex.json not found"})}i=e.target.response;if(typeof i!=="object"){i=JSON.parse(i)}i=g(i);p();r=lunr.Index.load(i.lunr);u["index"]=r;u["docs"]=i.docs;t(r)};o.responseType="json";o.addEventListener("load",a,false);o.open("get",e.SEARCH_INDEX);o.send()})}function l(e,t){t||(t={});e=h(e);return new Promise(function(n,r){d().then(function(r){var i,a=new m;function s(e,t,n){var i=r.search(t,E(e));a.add(i,t,e,n)}s("title",e);o.forEach(function(t){lunr.tokenizer(e).forEach(function(e){s(t,e,true)})});s("paramTypes",e);s("contents",e);i=a.getAll();i=y(i,e,t);n({success:i.data&&!!i.data.length,totalHits:i.data&&i.data.length,matches:i})})})}function h(e){var t;for(var n=0;n<s.length;n++){var r=s[n];if(e.indexOf(r)===0){t=e.substring(r.length)}}if(t&&c.test(t)){e+=f+t}return e}function p(){var e=lunr.tokenizer;var t=/[-./#_,;\(\)=><|]/g;lunr.tokenizer=function(n){return e.call(lunr,n).reduce(function(e,n){if(t.test(n)){n=n.replace(t," ");e.push.apply(e,n.toLowerCase().split(/ +/))}else{e.push(n.toLowerCase())}return e},[])};Object.keys(e).forEach(function(t){lunr.tokenizer[t]=e[t]})}function g(e){function t(t){var n=e.lunr.index[t].tfValues;n[0]=NaN;e.lunr.index[t].tfValues=undefined;function r(e){var t=[];e.split(",").forEach(function(e){var n=e.split(":"),r=parseInt(n[0]),i=n[1];while(i.length>0){t.push(i.slice(0,r));i=i.slice(r)}});return t}function i(e){var t=e.docs,i=0;if(t===undefined){e.docs={}}else{Object.keys(t).forEach(function(e){if(typeof t[e]==="number"){t[e]={tf:n[t[e]]}}if(e.indexOf(":")>=0){var o=r(e);o.forEach(function(n){t[n]=t[e];i++});t[e]=undefined}else{i++}})}if(e.df===undefined){e.df=i}}function o(e){i(e);Object.keys(e).forEach(function(t){if(t!=="docs"&&t!=="df"){var n=e[t];var r=t.length;if(r>1){while(--r>0){var i={};i[t.charAt(r)]=n;n=i}e[t.charAt(0)]=n;e[t]=undefined}o(n)}})}o(e.lunr.index[t].root)}function n(e,t){for(var r in e){t.apply(e,[r,e[r]]);if(e[r]!==null&&typeof e[r]=="object"){n(e[r],t)}}}function r(e,t){if(t===undefined){delete this[e]}}a.forEach(function(e){t(e)});n(e,r);return e}var m=function(){var e=u["docs"];if(!e){throw new Error("docs are required")}this._oDocs=e;this._oCollectedResults={}};m.prototype.add=function(e,t,n,r){e.forEach(function(e){this._mergeResultWithDocInfo(e,t,n,r);this._oCollectedResults[this._getResultId(e)]=e}.bind(this));return this};m.prototype.getAll=function(){return S(this._oCollectedResults)};m.prototype._mergeResultWithDocInfo=function(e,t,n,r){var i=this._oDocs[e.ref];e.doc=i;e.matchedDocField=n;if(r){e.matchedDocWord=v(i[n],t)}};m.prototype._getResultId=function(e){var t=e.ref,n=e.matchedDocWord||"";return t+"/"+n};function v(e,t){if(e){var n=function(e){return e.toLowerCase().indexOf(t.toLowerCase())===0};var r=e.split(" ");var i=r.filter(n);if(i.length){return i[0]}}return null}function E(e){var t={fields:{},expand:true};t.fields[e]={};return t}function S(e){var t=Object.keys(e),n=[];t.forEach(function(t){n.push(e[t])});return n}function y(e,t,n){var i,o=0,a=[],s=[],c=[],f=[],u=[],d=0,l=0,h=0,p=0,g=n.sPreferencedCategory,m=n.includeDeprecated;if(e){for(var v=0;v<e.length;v++){var E=e[v],S=E.doc;S.modifiedStr=S.modified+"";var y=S.modifiedStr.substring(0,4)+"/"+S.modifiedStr.substring(4,6)+"/"+S.modifiedStr.substring(6,8)+", "+S.modifiedStr.substring(8,10)+":"+S.modifiedStr.substring(10),A=S.title,_=S.summary?S.summary.trim():"",C=S.path,I=false,O,L,N;if(S.category===r.documentation){I=true;O="Documentation";L={title:A?A:"Untitled",path:C,summary:_||"",score:S.score,modified:y,category:O,external:S.external};c.push(L);h++}else if(S.category===r.samples){I=true;if(S.deprecated&&!m){continue}O="Samples";N=S.deprecated?"deprecated ":"";L={title:A?A+" ("+N+"samples)":"Untitled",path:C,summary:_||"",score:S.score,modified:y,category:O,external:S.external};f.push(L);p++}else if(S.category===r.apiref){C=D(E);A=R(E);_=x(E);I=true;if(!m&&S.deprecated){continue}O="API Reference";L={title:A,path:C,summary:_||"",score:S.score,modified:y,category:O};s.push(L);l++}if(I){a.push(L);d++;if(u.length<10&&S.category===g){u.push(L)}}}}while(u.length<10&&o<a.length){i=a[o++];if(u.indexOf(i)===-1){u.push(i)}}return{data:a,aDataAPI:s,aDataDoc:c,aDataExplored:f,filteredData:u,AllLength:d,APILength:l,DocLength:h,ExploredLength:p}}function D(e){var n=e.matchedDocField,r=e.doc.title,i=t[n],o;o="api/"+r;if(i){o+="#"+i}if(n==="methods"){o+="/"+e.matchedDocWord}return o}function R(e){var t=e.doc,r=t.kind.toLowerCase(),i=n[e.matchedDocField],o=e.matchedDocWord;if(i&&o){return o+" ("+i+")"}if(r){var a=t.deprecated?"deprecated "+r:r;return t.title+" ("+a+")"}return t.title}function x(e){var t=e.doc,r=n[e.matchedDocField],i=e.matchedDocWord,o=r&&i;if(o){return t.title}return t.summary}})();
},
	"sap/ui/documentation/sdk/cookieSettingsDialog/manifest.json":'{"sap.app":{"id":"sap.ui.documentation.sdk.cookieSettingsDialog","applicationVersion":{"version":"1.0.0"}},"sap.ui5":{"dependencies":{"libs":{"sap.f":{},"sap.m":{},"sap.ui.core":{},"sap.ui.layout":{}}},"resources":{"css":[{"uri":"css/style.css"}]},"config":{}}}',
	"sap/ui/documentation/sdk/cookieSettingsDialog/view/CookieSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:f="sap.f"\n\t\txmlns:grid="sap.ui.layout.cssgrid"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"><Dialog title="{i18n>COOKIE_SETTINGS_DIALOG_TITLE}" contentWidth="45rem"><content><html:div class="sapUiSmallMargin"><Text text="{i18n>COOKIE_SETTINGS_DIALOG_REQUIRED_COOKIES_TEXT}"\n\t\t\t\t\t  visible="{= !${cookieData>/showCookieDetails} }"/><f:GridList visible="{cookieData>/showCookieDetails}"><f:customLayout><grid:GridBasicLayout gridTemplateColumns="1fr" gridGap="1rem"/></f:customLayout><f:GridListItem><HBox justifyContent="SpaceBetween" class="sapUiSmallMarginBeginEnd sapUiSmallMarginTop"><VBox><Title text="{i18n>COOKIE_SETTINGS_DIALOG_REQUIRED_COOKIES_TITLE}" /><Text text="{i18n>COOKIE_SETTINGS_DIALOG_REQUIRED_COOKIES_SUMMARY}"/></VBox><Switch id="requiredCookiesSwitch" class="sapUiSmallMarginBegin"\n\t\t\t\t\t\t\t\tstate="{path: \'cookieData>/dk_allow_required_cookies\', type: \'sap.ui.model.type.Boolean\', formatter: \'.formatCookieValue\'}"/></HBox><Panel headerText="{i18n>COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_MORE_INFO}" expandable="true" class="sapUiTinyMarginTop"><Text text="{i18n>COOKIE_SETTINGS_DIALOG_REQUIRED_COOKIES_TEXT}"/></Panel></f:GridListItem></f:GridList></html:div></content><buttons><Button text="{i18n>COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_ACCEPT_ALL}" type="Emphasized" press="onAcceptAllCookies" visible="{=! ${cookieData>/showCookieDetails} }"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button text="{i18n>COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_SET_PREFERENCES}" id="btnSetPreferences" type="Ghost" press="showCookieDetails" visible="{= !${cookieData>/showCookieDetails} &amp;&amp; ${cookieData>/enableAdvancedSettings} }"></Button><Button text="{i18n>COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_REJECT_ALL}" press="onRejectAllCookies" visible="{=! ${cookieData>/showCookieDetails} }"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button text="{i18n>COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_SAVE_PREFERENCES}" id="btnSavePreferences" type="Emphasized" press="onSaveCookies" visible="{cookieData>/showCookieDetails}"></Button><Button text="{i18n>COOKIE_SETTINGS_DIALOG_CANCEL_BTN}" press="onCancelPress" visible="{= ${cookieData>/showCookieDetails} }"></Button></buttons></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/index.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(){"use strict";var e=function(e){return new window.URLSearchParams(window.location.search).get(e)},t=e("sap-ui-xx-sample-id"),a=e("sap-ui-xx-sample-lib"),n=e("sap-ui-theme")||"sap_fiori_3",i=e("sap-ui-rtl")||false,s=e("sap-ui-density"),o={},r=window.location===window.parent.location,p=function(t){if(!r){window.parent.postMessage(t,e("sap-ui-xx-dk-origin"))}};window.onInit=function(){p({type:"LOAD"});sap.ui.require(["sap/ui/core/Core","sap/ui/core/ComponentContainer","sap/ui/core/Component","sap/ui/documentation/library","sap/base/Log"],function(e,n,i,o,r){var c=function(e){var t=Array.prototype.find.call(document.body.classList,function(e){return e.includes("sapUiSize")});return t?document.body.classList.replace(t,e):document.body.classList.add(e)};if(s){c(s)}var u=o._getLibraryInfoSingleton();u.getResourceUrl=undefined;var d=function(){return new Promise(function(e){u._getDocuIndex(a,function(t){if(!t.explored){e();return}if(Array.isArray(t.explored.samplesRef)){t.explored.samplesRef.forEach(function(e){var t={};t[e.namespace.replace(/\./g,"/")]=""+(e.ref||".");sap.ui.loader.config({paths:t})})}else{var a={};a[t.explored.samplesRef.namespace.replace(/\./g,"/")]=""+(t.explored.samplesRef.ref||".");sap.ui.loader.config({paths:a})}e()})})};Promise.all([d(),e.loadLibrary("sap.ui.fl",{async:true}),e.loadLibrary("sap.ui.rta",{async:true})]).then(function(){r.info("Samples paths added successfully");var a="sampleComp-"+t;var s=t;sap.ui.require(["sap/ui/fl/Utils","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,t){t.checkControlId=function(){return true};e.checkControlId=function(){return true};e.isApplication=function(){return true};p({type:"RTA",data:{msg:"RTA is loaded"}})});i.create({id:a,name:s}).then(function(t){var a=t.getManifestEntry("/sap.ui5/config");var i=new n({component:t,height:"100%"}).placeAt("content");var s=new URLSearchParams(window.location.search).has("dk-sample-standalone");if(s&&a.sample&&a.sample.iframe){sap.ui.require(["sap/m/IllustratedMessage","sap/m/IllustratedMessageType"],function(e,t){i.destroy();new e({title:"Sample unsupported",description:"Samples with own index.html are currently unsupported by dk-sample-standalone.",illustrationType:t.PageNotFound}).placeAt("content")})}var o={};var r=null;o.type="INIT";o.data={msg:"fired after component container is placed in DOM"};o.config=a;p(o);window.addEventListener("message",function(a){if(a.data.type==="EXIT"){t.destroy()}else if(a.data.type==="RTA"){u()}else if(a.data.type==="SETTINGS"){if(a.data.reason==="get"){p({type:"SETTINGS",data:{density:document.body.classList[1],theme:e.getConfiguration().getTheme(),RTL:e.getConfiguration().getRTL()}})}else if(a.data.reason==="set"){c(a.data.data.density);e.getConfiguration().setRTL(a.data.data.RTL);e.applyTheme(a.data.data.theme)}}});function u(){if(r){r.stop();r=null;return}sap.ui.require(["sap/ui/rta/api/startKeyUserAdaptation"],function(e){e({rootControl:i.getComponentInstance()}).then(function(e){r=e;i.$().css({"padding-top":"2.5rem","box-sizing":"border-box"});e.attachStop(function(){i.$().css({"padding-top":"0","box-sizing":"content-box"});e.destroy()})})})}}).catch(function(e){p({type:"ERR",data:{msg:e}})})})})};o["sap/ui/demo/mock"]="test-resources/sap/ui/documentation/sdk";o["test-resources/sap/ui/documentation/sdk"]=".";var c=document.createElement("script");c.setAttribute("src","resources/sap-ui-core.js");c.setAttribute("id","sap-ui-bootstrap");c.dataset.sapUiLibs="sap.m";c.dataset.sapUiAsync=true;c.dataset.sapUiRtl=i;c.dataset.sapUiResourceroots=JSON.stringify(o);c.dataset.sapUiTheme=n;c.dataset.sapUiCompatversion="edge";c.dataset.sapUiOninit="onInit";c.dataset.sapUiBindingsyntax="complex";c.dataset.sapUiFlexibilityservices='[{"connector": "LocalStorageConnector"}]';document.write(c.outerHTML)})();
},
	"sap/ui/documentation/sdk/manifest.json":'{"_version":"1.12.0","sap.app":{"id":"sap.ui.documentation.sdk","type":"application","title":"OpenUI5 SDK - Demo Kit","applicationVersion":{"version":"1.0.0"},"embeddedBy":"../"},"sap.ui":{"technology":"UI5","icons":{"icon":"sap-icon://detail-view","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.documentation.sdk.view.App","type":"XML","async":true,"id":"app"},"resources":{"css":[{"uri":"css/style.css"}]},"dependencies":{"minUI5Version":"1.46.0","libs":{"sap.ui.core":{"minVersion":"1.46.0"},"sap.m":{"minVersion":"1.46.0"},"sap.ui.layout":{"minVersion":"1.46.0"},"sap.f":{"minVersion":"1.46.0"},"sap.uxap":{"minVersion":"1.46.0"},"sap.tnt":{"minVersion":"1.46.0"},"sap.ui.codeeditor":{"minVersion":"1.46.0"}}},"contentDensities":{"compact":true,"cozy":true},"models":{"theme":{"type":"sap.ui.model.json.JSONModel","uri":"model/theme-parameters.json"}},"config":{"docuPath":"./docs/topics/","exploredURI":"./","topicHtmlMainDivId":"d4h5-main-container","preservedContent":[{"className":"shortdesc","preservedTags":["code"]}]},"routing":{"config":{"routerClass":"sap.ui.documentation.sdk.util.DocumentationRouter","viewType":"XML","viewPath":"sap.ui.documentation.sdk.view","controlId":"splitApp","controlAggregation":"detailPages","bypassed":{"target":["welcome"]},"async":true,"clearTarget":false},"routes":[{"pattern":"","name":"welcome","target":["welcome"]},{"pattern":"controlsMaster","name":"controlsMaster","target":["controlsMaster"]},{"pattern":"controls","name":"controls","target":["controlsMaster","controls"]},{"pattern":"controls/filter/{value}","name":"listFilter","target":["controlsMaster","controls"]},{"pattern":"group/{id}","name":"group","target":["controlsMaster","group"]},{"pattern":"entity/{id}/samples","name":"entitySamplesLegacyRoute"},{"pattern":"entity/{id}/about","name":"entityAboutLegacyRoute"},{"pattern":"entity/{id}/properties","name":"entityPropertiesLegacyRoute"},{"pattern":"entity/{id}/aggregations","name":"entityAggregationsLegacyRoute"},{"pattern":"entity/{id}/associations","name":"entityAssociationsLegacyRoute"},{"pattern":"entity/{id}/events","name":"entityEventsLegacyRoute"},{"pattern":"entity/{id}/methods","name":"entityMethodsLegacyRoute"},{"pattern":"topic/a6a78b7e104348b4bb94fb8bcf003480","name":"ReleaseNotesLegacyRoute"},{"pattern":"entity/{id}/:sectionTab:","name":"entity","target":["controlsMaster","entity"]},{"pattern":"sample/{id}/preview","name":"sampleLegacyRoute"},{"pattern":"sample/{id}/code","name":"codeLegacyRoute"},{"pattern":"sample/{id}/code/{fileName}","name":"codeFileLegacyRoute"},{"pattern":"entity/{entityId}/sample/{sampleId}","name":"sample","target":["controlsMaster","sample"]},{"pattern":"entity/{entityId}/sample/{sampleId}/code","name":"code","target":["controlsMaster","code"]},{"pattern":"entity/{entityId}/sample/{sampleId}/code/:p1:/:p2:/:p3:/:p4:/:p5:/:p6:/:p7:/:p8:/:p9:/:p10:/:p11:/:p12:/:p13:/:p14:/:p15:","name":"codeFile","target":["controlsMaster","code"]},{"pattern":"downloads","name":"downloads","target":["downloads"]},{"pattern":"api","name":"api","target":["apiMaster","apiDetailInitial"]},{"pattern":"api/deprecated","name":"deprecated","target":["apiMaster","apiDetailDeprecated"]},{"pattern":"api/experimental","name":"experimental","target":["apiMaster","apiDetailExperimental"]},{"pattern":"api/since","name":"since","target":["apiMaster","apiDetailSince"]},{"pattern":"api/{id}/:p1:/:p2:/:p3:/:p4:/:p5:/:p6:/:p7:/:p8:/:p9:/:p10:/:p11:/:p12:/:p13:/:p14:/:p15:","name":"apiSpecialRoute","target":["apiMaster","apiDetail"]},{"pattern":"api/{id}#:entityType:/:entityId:","name":"apiId","target":["apiMaster","apiDetail"]},{"pattern":"topic","name":"topic","target":["topicMaster","topicDetailInitial"]},{"pattern":"topic/{id}","name":"topicId","target":["topicMaster","topicDetail"]},{"pattern":"topic/{id}/{subId}","name":"subTopicId","target":["topicMaster","topicDetail"]},{"pattern":"demoapps","name":"demoapps","target":["demoApps"]},{"pattern":"tools","name":"tools","target":["tools"]},{"pattern":"news","name":"news","target":["news"]},{"pattern":"static/BPSupport","name":"BPSupport","target":["BPSupport"]},{"pattern":"search/{searchParam}:?options:","name":"search","target":["searchPage"]},{"pattern":"releasenotes.html","name":"releaseNotes","target":["topicMaster","releaseNotes"]},{"pattern":"versioninfo.html","name":"versionInfo","target":["topicMaster","versionInfo"]},{"pattern":"LICENSE.txt","name":"license","target":["license"]},{"pattern":"TermsOfUse.txt","name":"termsOfUse","target":["termsOfUse"]},{"pattern":"docs/guide/{id}","name":"topicIdLegacyRoute"},{"pattern":"docs/api/symbols/{id}","name":"apiIdLegacyRoute"},{"pattern":"sitemap","name":"sitemap","target":["sitemap"]},{"pattern":"liveEditor","name":"liveEditor","target":["liveEditor"]}],"targets":{"empty":{"viewName":"Empty","viewLevel":1,"viewId":"empty","controlAggregation":"masterPages"},"welcome":{"viewName":"Welcome","viewLevel":2,"viewId":"welcome"},"controls":{"viewName":"Controls","viewLevel":2,"viewId":"controls"},"controlsMaster":{"viewName":"ControlsMaster","viewLevel":1,"viewId":"controlsMaster","controlAggregation":"masterPages"},"group":{"viewName":"Group","viewLevel":2,"viewId":"group"},"entity":{"viewName":"Entity","viewLevel":2,"viewId":"entity"},"sample":{"viewName":"Sample","viewLevel":2,"viewId":"sample"},"code":{"viewName":"Code","viewLevel":2,"viewId":"code","transition":"slide"},"downloads":{"viewName":"Downloads","viewLevel":2,"viewId":"downloads"},"apiMaster":{"viewName":"ApiMaster","viewLevel":1,"viewId":"apiMaster","controlAggregation":"masterPages"},"demoApps":{"viewName":"DemoApps","viewLevel":2,"viewId":"demoApps"},"tools":{"viewName":"Tools","viewLevel":2,"viewId":"tools"},"news":{"viewName":"News","viewLevel":2,"viewId":"news"},"BPSupport":{"viewName":"BPSupport","viewLevel":2,"viewId":"BPSupport"},"apiDetailInitial":{"viewName":"ApiDetailInitial","viewId":"apiDetailInitial","viewLevel":2},"apiDetail":{"viewName":"ApiDetail","viewId":"apiDetail","viewLevel":2},"apiDetailDeprecated":{"viewName":"ApiDetailDeprecated","viewId":"apiDetailDeprecated","viewLevel":2},"apiDetailExperimental":{"viewName":"ApiDetailExperimental","viewId":"apiDetailExperimental","viewLevel":2},"apiDetailSince":{"viewName":"ApiDetailSince","viewId":"apiDetailSince","viewLevel":2},"topicMaster":{"viewName":"TopicMaster","viewLevel":1,"viewId":"topicMaster","controlAggregation":"masterPages"},"topicDetailInitial":{"viewName":"TopicDetailInitial","viewId":"topicDetailInitial","viewLevel":2},"topicDetail":{"viewName":"TopicDetail","viewId":"topicDetail","viewLevel":2},"searchPage":{"viewName":"SearchPage","viewId":"searchPage","viewLevel":2,"controlAggregation":"detailPages"},"sampleNotFound":{"viewName":"SampleNotFound","viewId":"sampleNotFound"},"notFound":{"viewName":"NotFound","viewId":"notFound"},"versionNotFound":{"viewName":"VersionNotFound","viewId":"versionNotFound"},"sitemap":{"viewName":"Sitemap","viewId":"sitemap"},"liveEditor":{"viewName":"LiveEditor","viewId":"liveEditor"},"releaseNotes":{"viewName":"ReleaseNotes","viewLevel":2,"viewId":"releaseNotes","controlAggregation":"detailPages"},"license":{"viewName":"License","viewLevel":2,"viewId":"releaseNotes","controlAggregation":"detailPages"},"termsOfUse":{"viewName":"TermsOfUse","viewLevel":2,"viewId":"termsOfUse","controlAggregation":"detailPages"},"versionInfo":{"viewName":"VersionInfo","viewLevel":2,"viewId":"versionInfo","controlAggregation":"detailPages"}}},"componentUsages":{"cookieSettingsDialog":{"name":"sap.ui.documentation.sdk.cookieSettingsDialog"}}}}',
	"sap/ui/documentation/sdk/util/LiveEditorOutput.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(){"use strict";window.addEventListener("message",function(t){if(t.origin!==window.location.protocol+"//"+window.location.host){return}var o=t.data,i,r,a;if(!o||!o.src||!o.moduleNameToRequire){return}n();e(o);i=sap.ui.getCore();r=i.getConfiguration().getTheme();a=o.activeTheme;if(r!==a){i.applyTheme(a)}});function e(e){sap.ui.require.preload(e.src);sap.ui.require([e.moduleNameToRequire])}function n(){window.addEventListener("error",function(e){e.preventDefault();var n=document.createElement("span");n.innerText=e.message;n.style.cssText="position:absolute; top:1rem; left:1rem";if(!document.body){document.write("<span></span>")}document.body.appendChild(n)});window.addEventListener("unhandledrejection",function(e){e.preventDefault();var n=document.createElement("span");n.innerText=e.reason&&e.reason.message;n.style.cssText="position:absolute; top:1rem; left:1rem";if(!document.body){document.write("<span></span>")}document.body.appendChild(n)})}})();
},
	"sap/ui/documentation/sdk/util/Resources.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(e,i){"use strict";if(self.sap&&self.sap.ui&&typeof self.sap.ui.define==="function"){sap.ui.define(["sap/ui/thirdparty/URI"],i)}else if(typeof self.exports==="object"&&typeof self.exports.nodeName!=="string"){self.exports["ResourcesUtil"]=i()}else{e["ResourcesUtil"]=i()}})(self,function(e,i){"use strict";var t={getResourceOriginPath:function(i){var t,n=e(i),s=this.getResourcesVersion();if(n&&n.is("absolute")){return i}t=this.getConfig();return t+s+this._formatPath(i)},getHasProxy:function(){return new window.URLSearchParams(window.location.search).get("sap-ui-xx-unifiedResources")!=null||window["sap-ui-unified-resources"]},getResourcesVersion:function(){return this.getHasProxy()&&window.sessionStorage.getItem("versionPrefixPath")||""},getConfig:function(){return self["sap-ui-documentation-config"]&&self["sap-ui-documentation-config"].demoKitResourceOrigin||"."},getResourceOrigin:function(){return this.getConfig().replace("/sapui5","").replace("/openui5","")},_formatPath:function(e){e=e.replace(/^\.\//,"/");if(!e.match(/^\//)){e="/"+e}return e},isInternal:function(e){return/internal/i.test(e.name)||self["sap-ui-documentation-config"]&&self["sap-ui-documentation-config"].visibility==="internal"||false}};return t});
},
	"sap/ui/documentation/sdk/view/AboutDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation"><Dialog\n\t\t\tid="aboutDialog"\n\t\t\tresizable="true"\n\t\t\tdraggable="true"\n\t\t\ttitle="{i18n>ABOUT_DIALOG_TITLE}"\n\t\t\tcontentWidth="42rem"\n\t\t\tcontentHeight="50rem"\n\t\t\tshowHeader="false"\n\t\t\tstretch="{appView>/bPhoneSize}"\n\t\t\tclass="aboutDialog"><NavContainer\n\t\t\tid="aboutNavCon"><Page\n\t\t\t\tid="aboutMaster"\n\t\t\t\ttitle="{i18n>ABOUT_DIALOG_TITLE}"><VBox class="sapUiSmallMargin"><Image id="aboutLogoSAP" src="./resources/sap/ui/documentation/sdk/images/Logo_B_SAPUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/><Image id="aboutLogoUI5" src="./resources/sap/ui/documentation/sdk/images/Logo_B_OpenUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{versionData>/isOpenUI5}"/><Text text="{i18n>ABOUT_DIALOG_TEXT_1}" class="sapMTitleStyleH2 sapUiSmallMarginBottom" /><Text text="{i18n>ABOUT_DIALOG_TEXT_2}" class="sapUiTinyMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/><Text text="{i18n>ABOUT_DIALOG_TEXT_3}" visible="{versionData>/isOpenUI5}"/><custom:JSDocText class="sapUiSmallMarginBottom" visible="{versionData>/isOpenUI5}" text="Licensed under the Apache License, Version 2.0 – see &lt;a href=\'LICENSE.txt\' target=\'_blank\' class=\'sapMLnk sapMLnkMaxWidth aboutLink\'&gt;LICENSE.txt&lt;/a&gt;"/><Text text="{i18n>ABOUT_DIALOG_TEXT_7}" class="sapUiTinyMarginBottom"/><Link text="{i18n>ABOUT_DIALOG_TEXT_8}" press="onAboutThirdParty" class="sapUiMediumMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/><Link text="{i18n>ABOUT_DIALOG_TEXT_8}" href="THIRDPARTY.txt" target="_blank" class="sapUiMediumMarginBottom" visible="{versionData>/isOpenUI5}"/><Text text="{\n\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\'i18n>ABOUT_DIALOG_TEXT_4\',\n\t\t\t\t\t\t\t\t\'versionData>/versionName\',\n\t\t\t\t\t\t\t\t\'versionData>/fullVersion\'\n\n\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t\t\t\t}"\n\t\t\t\t\t\tclass="sapMTitleStyleH4 sapUiSmallMarginBottom"/><Text text="{\n\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\'i18n>ABOUT_DIALOG_TEXT_5\',\n\t\t\t\t\t\t\t\t\'versionData>/openUi5Version\'\n\n\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t\t\t\t}"\n\t\t\t\t\t\tclass="sapMTitleStyleH5 sapUiSmallMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/><Text text="{i18n>ABOUT_DIALOG_TEXT_6}"/><custom:JSDocText class="sapUiTinyMarginBottom" text="(a full change log for all libraries can be found &lt;a href=\'releasenotes.html\' target=\'_blank\' class=\'sapMLnk sapMLnkMaxWidth aboutLink\'&gt;here&lt;/a&gt;)."/><Link text="{i18n>ABOUT_DIALOG_LINK_1}" press="onAboutVersionDetails" class="sapUiSmallMarginBottom"/><MessageStrip showIcon="true" text="{= ${versionData>/isOpenUI5} ? ${appView>/sAboutInfoOpenUI5} : ${appView>/sAboutInfoSAPUI5}}" class="sapUiSmallMarginBottom" enableFormattedText="true"/></VBox></Page><Page\n\t\t\t\tid="aboutDetail"\n\t\t\t\tshowNavButton="true"\n\t\t\t\tnavButtonPress="onAboutNavBack"\n\t\t\t\ttitle="{i18n>ABOUT_DIALOG_VERSION_TITLE}"><l:VerticalLayout class="sapUiSmallMargin" content="{path: \'appView>/oVersionInfo/libs\'}"><f:Form width="100%" editable="false"><f:title><core:Title text="{appView>library}"/></f:title><f:layout><f:ResponsiveGridLayout/></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement label="{i18n>ABOUT_DIALOG_VERSION}"><f:fields><Text text="{appView>version}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement label="{i18n>ABOUT_DIALOG_DESCRIPTION}"><f:fields><Text text="{appView>documentation}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement label="{i18n>ABOUT_DIALOG_CHANGE_LOG}" visible="{=!!${appView>releasenotes}}"><f:fields><Link text="{i18n>ABOUT_DIALOG_CHANGE_LOG_LINK}" press="onReleaseDialogOpen" class="sapUiSmallMarginBottom"><customData><core:CustomData key="library" value="{appView>library}" /><core:CustomData key="version" value="{versionData>/version}" /></customData></Link></f:fields></f:FormElement><f:FormElement label="{i18n>ABOUT_DIALOG_COMPONENT}" visible="{=!!${appView>libDefaultComponent}}"><f:fields><Text text="{appView>libDefaultComponent}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form></l:VerticalLayout></Page><Page\n\t\t\t\tid="aboutThirdParty"\n\t\t\t\tshowNavButton="true"\n\t\t\t\tnavButtonPress="onAboutNavBack"\n\t\t\t\ttitle="{i18n>ABOUT_DIALOG_THIRD_PARTY}"><l:VerticalLayout class="sapUiSmallMargin" content="{path: \'appView>/oThirdPartyInfo/thirdparty\'}"><f:Form width="100%" editable="false"><f:title><core:Title text="{appView>displayName}"/></f:title><f:layout><f:GridLayout/></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement><f:fields><Link text="Web Site" target="_blank" href="{appView>homepage}" class="sapUiSmallMarginBottom"/><Link text="Licensed by SAP under {appView>license/type} license" target="_blank" href="{appView>license/url}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form></l:VerticalLayout></Page></NavContainer><beginButton><Button id="aboutDialogCloseButton" text="{i18n>ABOUT_DIALOG_CLOSE_BTN}" press="aboutDialogClose"/></beginButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ApiDetail.view.xml":'<mvc:View xmlns="sap.m"\n\t\t  xmlns:mvc="sap.ui.core.mvc"\n\t\t  controllerName="sap.ui.documentation.sdk.controller.ApiDetail"><Page\n\t\t\tid="apiDetailPageContainer"\n\t\t\tshowHeader="false"\n\t\t\tshowSubHeader="false"\n\t\t\tshowFooter="false"\n\t\t\tbusyIndicatorDelay="0"\n\t\t\tbusy="true"\n\t\t\tclass="apiDetailPage" /></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailDeprecated.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental"\n\t\t  xmlns="sap.uxap"\n\t\t  xmlns:m="sap.m"\n\t\t  xmlns:mvc="sap.ui.core.mvc"\n\t\t  xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage"\n\t\t\t\t\t  upperCaseAnchorBar="false"\n\t\t\t\t\t  sections="{/}"><headerTitle><ObjectPageHeader objectTitle="{i18n>API_DETAIL_DEPRECATED_TITLE}"/></headerTitle><headerContent><m:MessageStrip text="{i18n>API_DETAIL_DEPRECATED_WARNING}"\n\t\t\t\t\ttype="Error"\n\t\t\t\t\tclass="specialListsMessageStrip"\n\t\t\t\t\tshowIcon="true"/></headerContent><ObjectPageSection\n\t\t\t\ttitleUppercase="false"\n\t\t\t\ttitle="{\n\t\t\t\t\tparts: [\n\t\t\t\t\t\t\'i18n>API_DETAIL_AS_OF_VERSION\',\n\t\t\t\t\t\t\'name\'\n\t\t\t\t\t],\n\t\t\t\t\tformatter: \'.formatter.formatVersionTitle\'\n\t\t\t\t}"><ObjectPageSubSection><m:List items="{path: \'apis\', templateShareable: false}"\n\t\t\t\t\t\tupdateFinished="._modifyLinks"\n\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\tclass="sapUxAPObjectPageSubSectionAlignContent"\n\t\t\t\t\t\twidth="auto"><m:items><m:FeedListItem\n\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\tsender="{parts : [{path : \'control\'}, {path : \'entityName\'}, {path: \'type\'}],\n\t\t\t\t\t\t\t\t\t\t  formatter : \'.formatter.formatSenderLink\'}"\n\t\t\t\t\t\t\t\ttext="{path : \'text\', formatter: \'.formatter.formatLinks\'}"\n\t\t\t\t\t\t\t\tclass="specialListFeedItem"\n\t\t\t\t\t\t\t\tapp:control="{control}"\n\t\t\t\t\t\t\t\tapp:entity="{entityName}"\n\t\t\t\t\t\t\t\tapp:type="{type}"\n\t\t\t\t\t\t\t\tapp:static="{static}"/></m:items></m:List></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailExperimental.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental"\n\t\t  xmlns="sap.uxap"\n\t\t  xmlns:m="sap.m"\n\t\t  xmlns:mvc="sap.ui.core.mvc"\n\t\t  xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage"\n\t\t\t\t\t  upperCaseAnchorBar="false"\n\t\t\t\t\t  sections="{/}"><headerTitle><ObjectPageHeader objectTitle="{i18n>API_DETAIL_EXPERIMENTAL_TITLE}"/></headerTitle><headerContent><m:MessageStrip\n\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\ttext="Experimental features are not part of the officially delivered scope that SAP is going to guarantee for future releases – means experimental Features may be changed by SAP at any time for any reason without notice. The Experimental features are NOT FOR PRODUCTION USE. You may not demonstrate, test, examine, evaluate or otherwise use the Experimental Features in a live operating environment or with data that has not been sufficiently backed up. The purpose of Experimental features is to get feedback at an early point of time allowing customers/partners to influence the future product accordingly. Please use the SDN Developer Center &lt;a target=\'_blank\' href=\'https://www.sap.com/developer/topics/ui5.html\'&gt;https://www.sap.com/developer/topics/ui5.html&lt;/a&gt; to provide feedback accepting that Intellectual Property rights of the contributions or derivative works shall remain the exclusive property of SAP. For general information about Experimental features, please check the Compatibility Rules"\n\t\t\t\t\ttype="Warning"\n\t\t\t\t\tshowIcon="true"\n\t\t\t\t\tclass="specialListsMessageStrip" /></headerContent><ObjectPageSection\n\t\t\t\ttitleUppercase="false"\n\t\t\t\ttitle="{\n\t\t\t\t\tparts: [\n\t\t\t\t\t\t\'i18n>API_DETAIL_AS_OF_VERSION\',\n\t\t\t\t\t\t\'name\'\n\t\t\t\t\t],\n\t\t\t\t\tformatter: \'.formatter.formatVersionTitle\'\n\t\t\t\t}"><ObjectPageSubSection><m:List items="{path: \'apis\', templateShareable: false}"\n\t\t\t\t\t\tupdateFinished="._modifyLinks"\n\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\tclass="sapUxAPObjectPageSubSectionAlignContent"\n\t\t\t\t\t\twidth="auto"><m:items><m:FeedListItem\n\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\tsender="{parts : [{path : \'control\'}, {path : \'entityName\'}, {path: \'type\'}],\n\t\t\t\t\t\t\t\t\t\t formatter : \'.formatter.formatSenderLink\'}"\n\t\t\t\t\t\t\t\ttext="{path : \'text\', formatter: \'.formatter.formatLinks\'}"\n\t\t\t\t\t\t\t\tclass="specialListFeedItem"\n\t\t\t\t\t\t\t\tapp:control="{control}"\n\t\t\t\t\t\t\t\tapp:entity="{entityName}"\n\t\t\t\t\t\t\t\tapp:type="{type}"\n\t\t\t\t\t\t\t\tapp:static="{static}"/></m:items></m:List></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailInitial.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.ApiDetailInitial"\n\t\txmlns="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation"><Page showHeader="false" class="sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo\n\t\t\t\tcontentRole="Main"\n\t\t\t\tcontentLabel="API Reference"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image\n\t\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/API_ref_S_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{device>/system/phone}"/><Image\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/API_ref_M_and_L_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/><Text id="landingImageHeadline"\n\t\t\t\t\t\t\tclass="sapUiDocumentationApiHeaderText sapUiDocumentationApiHeaderTitleText"\n\t\t\t\t\t\t\ttext="API Reference"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttextAlign="Left"/></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel\taccessibleRole="Region"\n\t\t\t\tbackgroundDesign="Transparent"\n\t\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="Featured Namespaces"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\twidth="2"\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Main Controls"\n\t\t\t\t\t\t\t\t\thref="api/sap.m"/><Text\n\t\t\t\t\t\t\t\t\ttext="Responsive controls for touch-enabled devices and desktop browsers"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.m"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Layout"\n\t\t\t\t\t\t\t\t\thref="api/sap.ui.layout.form.Form"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.layout"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Tables"\n\t\t\t\t\t\t\t\t\thref="api/sap.ui.table"/><Text\n\t\t\t\t\t\t\t\t\ttext="Tables for desktop-type scenarios"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.table"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="SAP Fiori"\n\t\t\t\t\t\t\t\t\thref="api/sap.f"/><Text\n\t\t\t\t\t\t\t\t\ttext="Controls specialized for SAP Fiori applications"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.f"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="SAP Fiori for Tools"\n\t\t\t\t\t\t\t\t\thref="api/sap.tnt"/><Text\n\t\t\t\t\t\t\t\t\ttext="Controls specialized for administrative applications"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.tnt"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"\n\t\t\t\t\t\t\twidth="2"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="UI5 Core Runtime"\n\t\t\t\t\t\t\t\t\thref="api/sap.ui.core"/><Text\n\t\t\t\t\t\t\t\t\ttext="Boots the core framework and makes it available for the application via method sap.ui.getCore()"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.core"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"\n\t\t\t\t\t\t\twidth="2"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Object Page"\n\t\t\t\t\t\t\t\t\thref="api/sap.uxap"/><Text\n\t\t\t\t\t\t\t\t\ttext="Controls for displaying, creating and editing objects"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.uxap"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"\n\t\t\t\t\t\t\twidth="2"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Models"\n\t\t\t\t\t\t\t\t\thref="api/sap.ui.model"/><Text\n\t\t\t\t\t\t\t\t\ttext="Data binding utilities"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.model"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow visible="{= !${versionData>/isOpenUI5}}"><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"\n\t\t\t\t\t\t\twidth="2"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Smart Controls"\n\t\t\t\t\t\t\t\t\thref="api/sap.ui.comp"/><Text\n\t\t\t\t\t\t\t\t\ttext="Metadata-driven controls"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.comp"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Micro Charts"\n\t\t\t\t\t\t\t\t\thref="api/sap.suite.ui.microchart"/><Text\n\t\t\t\t\t\t\t\t\ttext="Lightweight diagrams"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.suite.ui.microchart"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeD"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Charts"\n\t\t\t\t\t\t\t\t\thref="api/sap.viz"/><Text\n\t\t\t\t\t\t\t\t\ttext="Data visualization"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Label\n\t\t\t\t\t\t\t\t\ttext="Namespace: sap.viz"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" /></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailSince.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental"\n\t\t  xmlns="sap.uxap"\n\t\t  xmlns:m="sap.m"\n\t\t  xmlns:mvc="sap.ui.core.mvc"\n\t\t  xmlns:custom="sap.ui.documentation"\n\t\t  xmlns:blocks="sap.ui.documentation.sdk.blocks"\n\t\t  xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage"\n\t\t\t\t\t  enableLazyLoading="true"\n\t\t\t\t\t  showAnchorBarPopover="true"\n\t\t\t\t\t  upperCaseAnchorBar="false"\n\t\t\t\t\t  useIconTabBar="true"\n\t\t\t\t\t  sections="{/}"><headerTitle><ObjectPageHeader objectTitle="{i18n>API_DETAIL_SINCE_TITLE}"/></headerTitle><ObjectPageSection\n\t\t\t\ttitleUppercase="false"\n\t\t\t\ttitle="{\n\t\t\t\t\tparts: [\n\t\t\t\t\t\t\'i18n>API_DETAIL_AS_OF_VERSION\',\n\t\t\t\t\t\t\'name\'\n\t\t\t\t\t],\n\t\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t\t}"><ObjectPageSubSection><blocks:IndexEntry></blocks:IndexEntry></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>\n',
	"sap/ui/documentation/sdk/view/ApiMaster.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.ApiMaster"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation"\n\t\tclass="sapContrast sapContrastPlus"><Page\n\t\t\tid="page"\n\t\t\tenableScrolling="true"\n\t\t\tshowFooter="false"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowNavButton="false"\n\t\t\tclass="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="{i18n>API_MASTER_PLACEHOLDER}" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"/><Button id="expandAllButton" icon="sap-icon://expand-all" press="onTreeExpandAll" tooltip="{i18n>API_MASTER_EXPAND_BTN_TOOLTIP}"/><Button id="collapseAllButton" icon="sap-icon://collapse-all" press="onTreeCollapseAll" tooltip="{i18n>API_MASTER_COLLAPSE_BTN_TOOLTIP}"/></Toolbar></customHeader><subHeader><Toolbar><CheckBox id="includeDeprecated" text="{i18n>API_MASTER_DEPRECATED_CB}" class="sapUiNoMarginBegin" select="onIncludeDeprecatedItemsChange"/></Toolbar></subHeader><content><l:FixFlex fixFirst="false"><l:flexContent><Tree\n\t\t\t\t\t\tid="tree"\n\t\t\t\t\t\tmode="SingleSelectMaster"\n\t\t\t\t\t\tnoDataText="{i18n>API_MASTER_NO_DATA_TEXT}"\n\t\t\t\t\t\tselectionChange="onNodeSelect"\n\t\t\t\t\t\titems="{treeData>/}"><custom:DemokitTreeItem\n\t\t\t\t\t\t\t\ttitle="{treeData>displayName}"\n\t\t\t\t\t\t\t\ttarget="{treeData>name}"\n\t\t\t\t\t\t\t\tentityType="{treeData>kind}"\n\t\t\t\t\t\t\t\tsection="api"\n\t\t\t\t\t\t\t\tclass="sapDemokitTreeItem"\n\t\t\t\t\t\t\t\tdeprecated="{treeData>deprecated}"/></Tree></l:flexContent><l:fixContent><core:Fragment fragmentName="sap.ui.documentation.sdk.view.FooterMaster" type="XML" /></l:fixContent></l:FixFlex></content></Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/App.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.documentation.sdk.controller.App"\n\txmlns="sap.m"\n\txmlns:tnt="sap.tnt"\n\txmlns:core="sap.ui.core"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:grid="sap.ui.layout.cssgrid"\n\txmlns:custom="sap.ui.documentation"\n\tdisplayBlock="true"\n\tbusy="{appView>/busy}"\n\tbusyIndicatorDelay="{appView>/delay}"><tnt:ToolPage id="demoKitPage" class="sapUiDemokit"><tnt:header><tnt:ToolHeader id="demoKitHeader" class="sapUiDemokitMainHeader"><grid:CSSGrid width="100%" class="sapUiDemokitMainHeaderGrid"><grid:customLayout><grid:GridResponsiveLayout><grid:layoutXL><grid:GridSettings\n\t\t\t\t\t\t\t\t\tgridTemplateColumns="1fr auto 1fr"></grid:GridSettings></grid:layoutXL><grid:layoutL><grid:GridSettings gridTemplateColumns="1fr auto 1fr"></grid:GridSettings></grid:layoutL><grid:layoutM><grid:GridSettings gridTemplateColumns="1fr auto auto"></grid:GridSettings></grid:layoutM><grid:layoutS><grid:GridSettings gridTemplateColumns="1fr auto auto"></grid:GridSettings></grid:layoutS></grid:GridResponsiveLayout></grid:customLayout><HBox alignItems="{= ${appView>/bPhoneSize} ? \'Center\' : \'Baseline\' }"><Button\n\t\t\t\t\t\t\ticon="sap-icon://menu2"\n\t\t\t\t\t\t\tpress="onSideNavigationButtonPress"\n\t\t\t\t\t\t\tvisible="{appView>/bPhoneSize}" /><Image\n\t\t\t\t\t\t\tsrc="{= ${appView>/bDarkThemeActive} ? ${theme>/darkLogo} : ${theme>/lightLogo} }"\n\t\t\t\t\t\t\talt="{i18n>APP_HEADER_LOGO_ALT}"\n\t\t\t\t\t\t\tclass="sapUiDemokitMainHeaderLogo"\n\t\t\t\t\t\t\theight="2rem"\n\t\t\t\t\t\t\tid="sap_logo"\n\t\t\t\t\t\t\tdecorative="false"\n\t\t\t\t\t\t\tpress="onHeaderLogoPress" /><Title\n\t\t\t\t\t\t\tclass="sapUiSmallMarginBeginEnd"\n\t\t\t\t\t\t\ttext="{i18n>APP_HEADER_TITLE}"\n\t\t\t\t\t\t\ttooltip="{i18n>APP_HEADER_TITLE}"\n\t\t\t\t\t\t\tvisible="{= !${appView>/bPhoneSize} }" /></HBox><HBox justifyContent="Center" alignItems="Center"><custom:Search\n\t\t\t\t\t\t\tid="searchControl"\n\t\t\t\t\t\t\ttoggle="onToggleSearchMode"\n\t\t\t\t\t\t\tsearch="onSearch"\n\t\t\t\t\t\t\tliveChange="onSearchLiveChange"\n\t\t\t\t\t\t\tisOpen="{appView>/bDesktopSize}" /></HBox><OverflowToolbar class="sapUiDemoKitHeaderOTB" style="Clear"><ObjectStatus\n\t\t\t\t\t\t\ttext="{= ${versionData>/isDevVersion} &amp;&amp; !${appView>/bShowVersionSwitchButton}\n\t\t\t\t\t\t\t\t? [${i18n>APP_VERSION_VERSION}, ${versionData>/version}, ${i18n>APP_VERSION_IN_PROGRESS}].join(\' \')\n\t\t\t\t\t\t\t\t: \'\' }"\n\t\t\t\t\t\t\tstate="Information"\n\t\t\t\t\t\t\tinverted="false"\n\t\t\t\t\t\t\tvisible="{= ${appView>/bDesktopSize} &amp;&amp; !${appView>/bSearchMode} }"></ObjectStatus><Button\n\t\t\t\t\t\t\tid="versionSwitchButton"\n\t\t\t\t\t\t\tclass="sapUiDemoKitHeaderActionsVersionSwitch"\n\t\t\t\t\t\t\ttype="Default"\n\t\t\t\t\t\t\ticon="sap-icon://dimension"\n\t\t\t\t\t\t\ttext="{= ${appView>/bDesktopSize}\n\t\t\t\t\t\t\t\t? [${i18n>APP_VERSION_VERSION}, ${versionData>/version}].join(\' \')\n\t\t\t\t\t\t\t\t: \'\' }"\n\t\t\t\t\t\t\tpress="onChangeVersionButtonPress"\n\t\t\t\t\t\t\tvisible="{= ${appView>/bShowVersionSwitchButton} }"></Button><OverflowToolbarButton\n\t\t\t\t\t\t\tid="surveyButton"\n\t\t\t\t\t\t\tclass="surveyButton"\n\t\t\t\t\t\t\ticon="sap-icon://feedback"\n\t\t\t\t\t\t\tpress="launchSurvey"\n\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_FEEDBACK}"\n\t\t\t\t\t\t\ttooltip="{i18n>APP_FEEDBACK_BTN_TOOLTIP}"><customData><BadgeCustomData visible="{appView>/bShowLongSurvey}" value="1" /></customData></OverflowToolbarButton><OverflowToolbarMenuButton\n\t\t\t\t\t\t\tclass="sapUiDemoKitHeaderActionsMenuButton"\n\t\t\t\t\t\t\ticon="sap-icon://official-service"\n\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_POLICIES}"\n\t\t\t\t\t\t\ttooltip="{i18n>APP_LEGAL_BTN_TOOLTIP}"><menu><Menu itemSelected="onMenuButtonItemSelected"><MenuItem\n\t\t\t\t\t\t\t\t\t\tkey="legal"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://compare"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_LEGAL}" /><MenuItem\n\t\t\t\t\t\t\t\t\t\tkey="privacy"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://locked"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_PRIVACY}" /><MenuItem\n\t\t\t\t\t\t\t\t\t\tkey="license"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://permission"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_LICENSE}"\n\t\t\t\t\t\t\t\t\t\tvisible="{versionData>/isOpenUI5}" /><MenuItem\n\t\t\t\t\t\t\t\t\t\tkey="terms_of_use"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://document-text"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_TERMS_OF_USE}"\n\t\t\t\t\t\t\t\t\t\tvisible="{versionData>/isOpenUI5}" /><MenuItem\n\t\t\t\t\t\t\t\t\t\tkey="terms_of_use"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://document-text"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_TERMS_OF_USE}"\n\t\t\t\t\t\t\t\t\t\tvisible="{= !${versionData>/isOpenUI5} &amp;&amp; !${versionData>/isDevEnv} }"><items><MenuItem key="terms_of_use" text="{i18n>APP_INFORMATION_BTN_TERMS_OF_USE}" /><MenuItem key="copyright" text="{i18n>APP_INFORMATION_BTN_COPYRIGHT}" /><MenuItem key="trademark" text="{i18n>APP_INFORMATION_BTN_TRADEMARK}" /><MenuItem key="disclaimer" text="{i18n>APP_INFORMATION_BTN_DISCLAIMER}" /></items></MenuItem></Menu></menu></OverflowToolbarMenuButton><OverflowToolbarMenuButton\n\t\t\t\t\t\t\tid="aboutMenuButton"\n\t\t\t\t\t\t\tclass="sapUiDemoKitHeaderActionsMenuButton"\n\t\t\t\t\t\t\ticon="sap-icon://action-settings"\n\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_SETTINGS}"\n\t\t\t\t\t\t\ttooltip="{i18n>APP_INFORMATION_BTN_TOOLTIP}"><menu><Menu itemSelected="onMenuButtonItemSelected"><items><MenuItem\n\t\t\t\t\t\t\t\t\t\t\tkey="about"\n\t\t\t\t\t\t\t\t\t\t\ticon="sap-icon://hint"\n\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_ABOUT}" /><MenuItem\n\t\t\t\t\t\t\t\t\t\t\tkey="appearance"\n\t\t\t\t\t\t\t\t\t\t\ticon="sap-icon://palette"\n\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_APPEARANCE}"><items><MenuItem key="light" text="{i18n>APP_INFORMATION_BTN_APPEARANCE_LIGHT}" /><MenuItem key="dark" text="{i18n>APP_INFORMATION_BTN_APPEARANCE_DARK}" /><MenuItem key="hcb" text="{i18n>APP_INFORMATION_BTN_APPEARANCE_HCB}" /><MenuItem key="hcw" text="{i18n>APP_INFORMATION_BTN_APPEARANCE_HCW}" /><MenuItem key="auto" text="{i18n>APP_INFORMATION_BTN_APPEARANCE_AUTO}" /></items></MenuItem><MenuItem\n\t\t\t\t\t\t\t\t\t\t\tkey="sitemap"\n\t\t\t\t\t\t\t\t\t\t\ticon="sap-icon://tree"\n\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_SITEMAP}"\n\t\t\t\t\t\t\t\t\t\t\tvisible="{versionData>/isOpenUI5}" /><MenuItem\n\t\t\t\t\t\t\t\t\t\t\tkey="settings"\n\t\t\t\t\t\t\t\t\t\t\ticon="sap-icon://hello-world"\n\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_SETTINGS_DIALOG_LANGUAGE}" /><MenuItem\n\t\t\t\t\t\t\t\t\t\t\tkey="cookie_preferences"\n\t\t\t\t\t\t\t\t\t\t\ticon="sap-icon://customize"\n\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>APP_SETTINGS_DIALOG_COOKIE_PREFERENCES}"\n\t\t\t\t\t\t\t\t\t\t\tvisible="{versionData>/enableAdvancedCookieSettings}" /></items></Menu></menu></OverflowToolbarMenuButton><OverflowToolbarButton\n\t\t\t\t\t\t\tclass="sapUiDemoKitHeaderActionsNewsButton"\n\t\t\t\t\t\t\ticon="sap-icon://bell"\n\t\t\t\t\t\t\tpress="onNewsButtonPress"\n\t\t\t\t\t\t\ttext="{i18n>APP_INFORMATION_BTN_NEWS}"\n\t\t\t\t\t\t\ttooltip="{i18n>APP_NEWS_BTN_TOOLTIP}"><customData><BadgeCustomData key="badge" value="{news>/newsCount}" /></customData></OverflowToolbarButton></OverflowToolbar></grid:CSSGrid></tnt:ToolHeader></tnt:header><tnt:subHeader><tnt:ToolHeader class="sapUiDemokitSubHeader" visible="{= !${appView>/bPhoneSize} }"><IconTabHeader\n\t\t\t\t\tid="demoKitSubHeader"\n\t\t\t\t\tmode="Inline"\n\t\t\t\t\tselect="navigateToSection"\n\t\t\t\t\tselectedKey="home"><items><IconTabFilter\n\t\t\t\t\t\t\tid="welcomeTab"\n\t\t\t\t\t\t\tkey="home"\n\t\t\t\t\t\t\ticon="sap-icon://home"\n\t\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_HOME}"></IconTabFilter><IconTabFilter\n\t\t\t\t\t\t\tid="topicMasterTab"\n\t\t\t\t\t\t\tkey="topic"\n\t\t\t\t\t\t\ticon="sap-icon://learning-assistant"\n\t\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_DOCUMENTATION}"></IconTabFilter><IconTabFilter\n\t\t\t\t\t\t\tid="apiMasterTab"\n\t\t\t\t\t\t\tkey="api"\n\t\t\t\t\t\t\ticon="sap-icon://syntax"\n\t\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_API_REFERENCE}"></IconTabFilter><IconTabFilter\n\t\t\t\t\t\t\tid="controlsMasterTab"\n\t\t\t\t\t\t\tkey="controls"\n\t\t\t\t\t\t\ticon="sap-icon://example"\n\t\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_SAMPLES}"></IconTabFilter><IconTabFilter\n\t\t\t\t\t\t\tid="demoAppsTab"\n\t\t\t\t\t\t\tkey="demoapps"\n\t\t\t\t\t\t\ticon="sap-icon://grid"\n\t\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_DEMO_APPS}"></IconTabFilter><IconTabFilter\n\t\t\t\t\t\t\tid="toolsTab"\n\t\t\t\t\t\t\tkey="tools"\n\t\t\t\t\t\t\ticon="sap-icon://wrench"\n\t\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_TOOLS}"></IconTabFilter></items></IconTabHeader></tnt:ToolHeader></tnt:subHeader><tnt:sideContent><tnt:SideNavigation\n\t\t\t\tid="demoKitSideNavigation"\n\t\t\t\tvisible="{appView>/bPhoneSize}"\n\t\t\t\texpanded="false"\n\t\t\t\tselectedKey="home"\n\t\t\t\titemSelect="navigateToSection"><tnt:NavigationList><tnt:NavigationListItem\n\t\t\t\t\t\tkey="home"\n\t\t\t\t\t\ticon="sap-icon://home"\n\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_HOME}" /><tnt:NavigationListItem\n\t\t\t\t\t\tkey="topic"\n\t\t\t\t\t\ticon="sap-icon://learning-assistant"\n\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_DOCUMENTATION}" /><tnt:NavigationListItem\n\t\t\t\t\t\tkey="api"\n\t\t\t\t\t\ticon="sap-icon://syntax"\n\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_API_REFERENCE}" /><tnt:NavigationListItem\n\t\t\t\t\t\tkey="controls"\n\t\t\t\t\t\ticon="sap-icon://example"\n\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_SAMPLES}" /><tnt:NavigationListItem\n\t\t\t\t\t\tkey="demoapps"\n\t\t\t\t\t\ticon="sap-icon://grid"\n\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_DEMO_APPS}" /><tnt:NavigationListItem\n\t\t\t\t\t\tkey="tools"\n\t\t\t\t\t\ticon="sap-icon://wrench"\n\t\t\t\t\t\ttext="{i18n>APP_TABHEADER_ITEM_TOOLS}"></tnt:NavigationListItem></tnt:NavigationList></tnt:SideNavigation></tnt:sideContent><tnt:mainContents><OverflowToolbar\n\t\t\t\tvisible="{= (${appView>/bHasMaster} &amp;&amp; !${appView>/bLandscape}) &#124;&#124; ${appView>/bHasMaster} &amp;&amp; ${appView>/device/system/phone} }"><ToggleButton\n\t\t\t\t\tclass="sapUiDocumentationMasterToggleButton"\n\t\t\t\t\tpress="toggleMaster"\n\t\t\t\t\tpressed="{appView>/bIsShownMaster}"\n\t\t\t\t\ticon="{= ${appView>/bIsShownMaster} ? \'sap-icon://navigation-left-arrow\' : \'sap-icon://navigation-right-arrow\' }" /><Title level="H3" text="{appView>/selectedSectionTitle}" /></OverflowToolbar><ScrollContainer\n\t\t\t\tid="demoKitScrollContainer"\n\t\t\t\twidth="100%"\n\t\t\t\theight="{= ${appView>/bHasMaster} &amp;&amp; !${appView>/bLandscape} &amp;&amp; ${appView>/device/system/desktop} ? \'calc(100% - 2rem)\'\n\t\t\t\t\t: (${appView>/bHasMaster} &amp;&amp; !${appView>/bLandscape}) ? \'calc(100% - 2.75rem)\'\n\t\t\t\t\t: (${appView>/bHasMaster} &amp;&amp; ${appView>/device/system/phone}) ? \'calc(100% - 2.75rem)\'\n\t\t\t\t\t: \'100%\'}"\n\t\t\t\thorizontal="false"\n\t\t\t\tvertical="false"><SplitApp\n\t\t\t\t\tid="splitApp"\n\t\t\t\t\tclass="sapUiDocumentationSplitApp"\n\t\t\t\t\tmode="HideMode"\n\t\t\t\t\tdefaultTransitionNameDetail="show"\n\t\t\t\t\tdefaultTransitionNameMaster="fade" /></ScrollContainer></tnt:mainContents></tnt:ToolPage></mvc:View>',
	"sap/ui/documentation/sdk/view/BPSupport.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.BPSupport"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"><Page id="BPSupportPage" showNavButton="false" showFooter="false" showHeader="false" class="sapUiResponsiveContentPadding"></Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/BlockLayoutCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\txmlns:custom="sap.ui.documentation"><l:BlockLayoutCell\n\t\twidth="2"><l:VerticalLayout width="100%"><core:Icon\n\t\t\t\tsrc="sap-icon://{icon}"\n\t\t\t\tsize="2rem"\n\t\t\t\tcolor="Default"></core:Icon><custom:TitleLink\n\t\t\t\tlevel="H1"\n\t\t\t\ttitleStyle="H1"\n\t\t\t\ttext="{name}"\n\t\t\t\thref="{ref}"\n\t\t\t\ttarget="_blank"\n\t\t\t\tclass="sapUiTinyMarginTop"/><Text\n\t\t\t\ttext="{desc}"\n\t\t\t\tclass="sapUiTinyMarginBottom"/><l:VerticalLayout\n\t\t\t\tcontent="{links}"\n\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }"><Link\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'ref\',\n\t\t\t\t\t\tformatter: \'.formatter.crossLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\ttext="{name}"/></l:VerticalLayout><l:HorizontalLayout><Label\n\t\t\t\t\tdesign="Bold"\n\t\t\t\t\ttext="{i18n>DEMO_APPS_LIBRARY}"\n\t\t\t\t\tclass="sapUiTinyMarginEnd"/><Link\n\t\t\t\t\ttext="{lib}"\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\tenabled="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLinkEnabled\'\n\t\t\t\t\t}"\n\t\t\t\t\temphasized="true"/></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/BlockLayoutTeaserCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\txmlns:custom="sap.ui.documentation"><l:BlockLayoutCell\n\twidth="4"><l:Grid\n\t\thSpacing="0"\n\t\tdefaultSpan="L6 M12 S12"><l:VerticalLayout class="sapUiTinyMarginEnd" width="100%"><core:Icon\n\t\t\t\tsrc="sap-icon://{icon}"\n\t\t\t\tsize="2rem"\n\t\t\t\tcolor="Default"></core:Icon><custom:TitleLink\n\t\t\t\tlevel="H1"\n\t\t\t\ttitleStyle="H1"\n\t\t\t\ttext="{name}"\n\t\t\t\thref="{ref}"\n\t\t\t\ttarget="_blank"\n\t\t\t\tclass="sapUiTinyMarginTop"/><Text\n\t\t\t\ttext="{desc}"\n\t\t\t\tclass="sapUiTinyMarginBottom"/><l:VerticalLayout\n\t\t\t\tcontent="{links}"\n\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }"><Link\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'ref\',\n\t\t\t\t\t\tformatter: \'.formatter.crossLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\ttext="{name}"/></l:VerticalLayout><l:HorizontalLayout><Label\n\t\t\t\t\tdesign="Bold"\n\t\t\t\t\ttext="{i18n>DEMO_APPS_LIBRARY}"\n\t\t\t\t\tclass="sapUiTinyMarginEnd"/><Link\n\t\t\t\t\ttext="sap.m"\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\tenabled="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLinkEnabled\'\n\t\t\t\t\t}"\n\t\t\t\t\temphasized="true"/></l:HorizontalLayout></l:VerticalLayout></l:Grid></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ChangeVersionDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"><Dialog\n\t\t\ttitle="{i18n>CHANGE_VERSION_DIALOG_TITLE}"\n\t\t\tcontentHeight="400px"\n\t\t\tstretch="{appView>/bPhoneSize}"><buttons><Button\n\t\t\t\ttext="{i18n>CHANGE_VERSION_DIALOG_APPLY_BTN}"\n\t\t\t\ttype="Emphasized"\n\t\t\t\tpress="onVersionItemPress"></Button><Button\n\t\t\t\t\ttext="{i18n>CHANGE_VERSION_DIALOG_LATEST_BTN}"\n\t\t\t\t\ttype="Ghost"\n\t\t\t\t\tpress="onLatestVersionItemPress"></Button><Button\n\t\t\t\t\ttext="{i18n>CHANGE_VERSION_DIALOG_CLOSE_BTN}"\n\t\t\t\t\tpress="onCloseVersionDialog"></Button></buttons><subHeader><Bar><contentMiddle><SearchField\n\t\t\t\t\t\t\tliveChange="onChangeVersionDialogSearch"\n\t\t\t\t\t\t\tshowSearchButton="false"></SearchField></contentMiddle></Bar></subHeader><Tree\n\t\t\t\tid="versionList"\n\t\t\t\tmode="SingleSelectMaster"\n\t\t\t\titems="{\n\t\t\t\t\tpath: \'/\',\n\t\t\t\t\tsorter: [{\n\t\t\t\t\t\tpath: \'groupTitle\',\n\t\t\t\t\t\tdescending: true,\n\t\t\t\t\t\tgroup: true,\n\t\t\t\t\t\tcomparator: \'.versionSwitchCustomComparator\'\n\t\t\t\t\t}, {\n\t\t\t\t\t\tpath: \'patchVersion\',\n\t\t\t\t\t\tdescending: true\n\t\t\t\t\t}]\n\t\t\t\t}"><StandardTreeItem\n\t\t\t\t\ttitle="{path: \'version\'}{= ${path: \'version\'} === ${versionData>/latestVersion} ? \' (Latest)\' : \'\'}"><customData><core:CustomData key="path" value="{path: \'path\'}" /></customData></StandardTreeItem></Tree></Dialog></core:FragmentDefinition>\n',
	"sap/ui/documentation/sdk/view/Code.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Code"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns="sap.m"\n\t\txmlns:fileEditor="sap.ui.documentation.sdk.controls" height="100%"><l:ResponsiveSplitter id="splitView" height="100%"><l:PaneContainer orientation="Horizontal"><l:SplitPane id="previewPane" requiredParentWidth="1"><Page\n\t\t\t\t\tid="samplePageEdit"\n\t\t\t\t\tshowHeader="false"\n\t\t\t\t\tshowNavButton="true"\n\t\t\t\t\tnavButtonPress="onNavBack"\n\t\t\t\t\tbusyIndicatorDelay="0"\n\t\t\t\t\tclass="sapUiDocumentationSamplePage"><landmarkInfo><PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo></landmarkInfo><subHeader><Bar id="header" class="sapContrast sapContrastPlus"><contentLeft><Button type="Back" press="onNavBack" tooltip="{i18n>SAMPLE_BACK_BTN_TOOLTIP}" enabled="{= ${/disableNavBack} === undefined }"/></contentLeft><contentMiddle><Title level="H1" text="{/title}" tooltip="{/title}"/><Button\n\t\t\t\t\t\t\t\t\t\tid="warningSample"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://warning"\n\t\t\t\t\t\t\t\t\t\tvisible="{=${/showWarning}}"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_EDITED_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiExploredWarningIcon"\n\t\t\t\t\t\t\t\t\t\tpress="onWarningSample"/></contentMiddle><contentRight><Button\n\t\t\t\t\t\t\t\t\t\tid="infoSample"\n\t\t\t\t\t\t\t\t\t\tvisible="{=${/details} !== undefined || ${/description} !== undefined}"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://hint"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_INFO_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\tpress="onInfoSample"/><Button id="apiRefButton" text="{i18n>SAMPLE_API_REFERENCE_BTN}" type="Emphasized" press="onAPIRefPress" visible="false"/><Button\n\t\t\t\t\t\t\t\t\t\tid="prevSample"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://navigation-up-arrow"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_PREV_BTN_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\tenabled="{= ${/previousSampleId} !== undefined }"\n\t\t\t\t\t\t\t\t\t\tpress="onPreviousSample"/><Button\n\t\t\t\t\t\t\t\t\t\tid="nextSample"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://navigation-down-arrow"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_NEXT_BTN_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\tenabled="{= ${/nextSampleId} !== undefined }"\n\t\t\t\t\t\t\t\t\t\tpress="onNextSample"/><Button\n\t\t\t\t\t\t\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\t\t\t\tvisible="{:= ${device>/system/desktop} ||\n\t\t\t\t\t\t\t\t\t\t\t\t\t&#40; ${device>/system/tablet} &amp;&amp;\n\t\t\t\t\t\t\t\t\t\t\t\t\t${device>/orientation/landscape} &#41; }"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_FULLSCREEN_BTN_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\tpress="onToggleFullScreen" /><Button visible="{/showNewTab}"\n\t\t\t\t\t\t\t\t\t\tid="newTab"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_NEW_TAB_BTN_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://inspect"\n\t\t\t\t\t\t\t\t\t\tpress="onNewTab" /></contentRight></Bar></subHeader></Page></l:SplitPane><l:SplitPane id="editorPane" requiredParentWidth="1"><Page\n\t\t\t\t\tid="page"\n\t\t\t\t\tshowHeader="false"\n\t\t\t\t\tshowNavButton="true"\n\t\t\t\t\tnavButtonPress="onNavBack"\n\t\t\t\t\ttitle="{/title}"\n\t\t\t\t\ticon="img/144_iPad_Retina_Web_Clip.png"\n\t\t\t\t\tenableScrolling="false"><landmarkInfo><PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo></landmarkInfo><subHeader><OverflowToolbar><Button\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBegin"\n\t\t\t\t\t\t\t\ttext="Run"\n\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\ticon="sap-icon://media-play"\n\t\t\t\t\t\t\t\tpress="onRunPressed"\n\t\t\t\t\t\t\t\tenabled="{settings>/editable}"\n\t\t\t\t\t\t\t><layoutData><OverflowToolbarLayoutData priority="High" /></layoutData></Button><CheckBox text="Auto Run" selected="{settings>/autoRun}" enabled="{settings>/editable}"><layoutData><OverflowToolbarLayoutData priority="Low" /></layoutData></CheckBox><ToolbarSpacer /><Button\n\t\t\t\t\t\t\t\ttext="{i18n>SAMPLE_RESET_CHANGES}"\n\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\tpress="onClearButtonPressed" /><ToolbarSpacer /><MenuButton id="downloadSampleButton" icon="sap-icon://download" tooltip="Download" text="Download" type="Transparent"><menu><Menu><MenuItem text="All files as .zip" icon="sap-icon://attachment-zip-file" press="onDownload" /></Menu></menu><layoutData><OverflowToolbarLayoutData priority="High" /></layoutData></MenuButton><Button class="orientationBtn" press="onChangeSplitterOrientation" tooltip="Change position" icon="sap-icon://header" type="Transparent"><layoutData><OverflowToolbarLayoutData priority="Low" /></layoutData></Button></OverflowToolbar></subHeader><fileEditor:FileEditor\n\t\t\t\t\t\tid="fileEditor"\n\t\t\t\t\t\tfileChange="onFileEditorFileChange"\n\t\t\t\t\t\tfileSwitch="onFileSwitch"\n\t\t\t\t\t\tvisible="{= ${settings>/editorType} === \'text\' }" /></Page></l:SplitPane></l:PaneContainer></l:ResponsiveSplitter></mvc:View>\n',
	"sap/ui/documentation/sdk/view/Controls.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Controls"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation"><Page showHeader="false" class="sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo\n\t\t\t\tcontentRole="Main"\n\t\t\t\tcontentLabel="Samples"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image\n\t\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Explored_S_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{device>/system/phone}"/><Image\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Explored_M_and_L_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/><l:VerticalLayout\n\t\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\twidth="100%"><Text class="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredHeaderTitleText"\n\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_PAGE_TITLE}"\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttextAlign="Left"/><Text\n\t\t\t\t\t\t\t\tclass="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredSubText"\n\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_PAGE_DESC}"\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttextAlign="Left"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel\taccessibleRole="Region"\n\t\t\t\tbackgroundDesign="Transparent"\n\t\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="{i18n>CONTROLS_FEATURED_CONTROLS}"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://edit"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Input"\n\t\t\t\t\t\t\t\t\tfilter="Input"\n\t\t\t\t\t\t\t\t\ttext="Input"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_1}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://list"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/List"\n\t\t\t\t\t\t\t\t\tfilter="List"\n\t\t\t\t\t\t\t\t\ttext="Lists"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_2}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://table-view"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Table"\n\t\t\t\t\t\t\t\t\tfilter="Table"\n\t\t\t\t\t\t\t\t\ttext="Tables"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_3}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://popup-window"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Popup"\n\t\t\t\t\t\t\t\t\tfilter="Popup"\n\t\t\t\t\t\t\t\t\ttext="Pop-Ups"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_4}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://grid"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Tile"\n\t\t\t\t\t\t\t\t\tfilter="Tile"\n\t\t\t\t\t\t\t\t\ttext="Tiles"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_TEXT_5}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://message-popup"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Message"\n\t\t\t\t\t\t\t\t\tfilter="Message"\n\t\t\t\t\t\t\t\t\ttext="Messages"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_6}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://header"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Bar"\n\t\t\t\t\t\t\t\t\tfilter="Bar"\n\t\t\t\t\t\t\t\t\ttext="Bars"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_7}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://tree"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Tree"\n\t\t\t\t\t\t\t\t\tfilter="Tree"\n\t\t\t\t\t\t\t\t\ttext="Trees"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_8}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow visible="{= !${versionData>/isOpenUI5}}"><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://lightbulb"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Smart"\n\t\t\t\t\t\t\t\t\tfilter="Smart"\n\t\t\t\t\t\t\t\t\ttext="Smart Controls"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_9}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://map-2"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Map"\n\t\t\t\t\t\t\t\t\tfilter="Map"\n\t\t\t\t\t\t\t\t\ttext="Maps"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_TEXT_10}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://filter-analytics"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Chart"\n\t\t\t\t\t\t\t\t\tfilter="Chart"\n\t\t\t\t\t\t\t\t\ttext="Charts"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_TEXT_11}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://process"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Process"\n\t\t\t\t\t\t\t\t\tfilter="Process"\n\t\t\t\t\t\t\t\t\ttext="Processes"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text text="{i18n>CONTROLS_TEXT_12}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel\taccessibleRole="Region"\n\t\t\t\tbackgroundDesign="Transparent"\n\t\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="{i18n>CONTROLS_LAYOUT_PAGES}"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://write-new"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Object Page"\n\t\t\t\t\t\t\t\t\tfilter="Object Page"\n\t\t\t\t\t\t\t\t\ttext="Object Page"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_TEXT_13}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://chart-table-view"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Dynamic Page"\n\t\t\t\t\t\t\t\t\tfilter="Dynamic Page"\n\t\t\t\t\t\t\t\t\ttext="Dynamic Page"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_TEXT_14}"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://screen-split-three"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Flexible Column Layout"\n\t\t\t\t\t\t\t\t\tfilter="Flexible Column Layout"\n\t\t\t\t\t\t\t\t\ttext="Flexible Column Layout"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_TEXT_15}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://screen-split-one"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\t\thref="controls/filter/Split App"\n\t\t\t\t\t\t\t\t\tfilter="Split App"\n\t\t\t\t\t\t\t\t\ttext="Split App"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>CONTROLS_TEXT_16}"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" /></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/ControlsMaster.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.ControlsMaster"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns="sap.m"\n\t\tclass="sapContrast sapContrastPlus"><Page\n\t\t\tid="exploredMasterPage"\n\t\t\tshowFooter="false"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowNavButton="false"\n\t\t\tclass="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="{i18n>CONTROLS_MASTER_FILTER_PLACERHOLDER}" liveChange="handleListFilter" class="sapUiDocumentationFilterField" /><Button id="listFilterSettings" icon="sap-icon://filter" press="handleListSettings" tooltip="{i18n>CONTROLS_MASTER_FILTER_BTN_TOOLTIP}"/></Toolbar></customHeader><content><l:FixFlex fixFirst="false"><l:flexContent><List id="exploredMasterList"\n\t\t\t\t\t\t\tmode="{viewModel>/listMode}"\n\t\t\t\t\t\t\tselectionChange="onNavToEntity"\n\t\t\t\t\t\t\tnoDataText="{i18n>CONTROLS_MASTER_NO_DATA_TEXT}"\n\t\t\t\t\t\t\titems="{path: \'/entities\',\n\t\t\t\t\t\t\tgroupHeaderFactory: \'.getGroupHeader\',\n\t\t\t\t\t\t\tsorter: [{\n\t\t\t\t\t\t\t\tpath: \'category\',\n\t\t\t\t\t\t\t\tdescending: false,\n\t\t\t\t\t\t\t\tgroup: true\n\t\t\t\t\t\t\t},{\n\t\t\t\t\t\t\t\tpath: \'name\',\n\t\t\t\t\t\t\t\tdescending: false\n\t\t\t\t\t\t\t}]}"><infoToolbar><Toolbar id="vsFilterBar"\n\t\t\t\t\t\t\t\t\tactive="true"\n\t\t\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\t\t\tpress="handleListSettings"><Label id="vsFilterLabel" /></Toolbar></infoToolbar><items><StandardListItem\n\t\t\t\t\t\t\t\t\ttitle="{name}"\n\t\t\t\t\t\t\t\t\tcounter="{sampleCount}"\n\t\t\t\t\t\t\t\t\ttype="{viewModel>/listItemType}"\n\t\t\t\t\t\t\t\t\tpress="onNavToEntity" /></items></List></l:flexContent><l:fixContent><core:Fragment fragmentName="sap.ui.documentation.sdk.view.FooterMaster" type="XML" /></l:fixContent></l:FixFlex></content></Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/DemoApps.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.DemoApps"\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"><Page\n\t\tid="demoAppsPage"\n\t\tshowSubHeader="false"\n\t\tshowFooter="false"\n\t\tshowHeader="false"\n\t\tclass="sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo\n\t\t\t\theaderRole="Region"\n\t\t\t\theaderLabel="Demo Apps"\n\t\t\t\tcontentRole="Main"\n\t\t\t\tcontentLabel="Demo Apps by Category"/></landmarkInfo><content><ScrollContainer vertical="true" width="100%" height="100%"><Panel\n\t\t\t\t\tid="rootPage"\n\t\t\t\t\taccessibleRole="Region"\n\t\t\t\t\tclass="sapUiNoContentPadding"><l:BlockLayout\n\t\t\t\t\t\tid="headerLayout"\n\t\t\t\t\t\tbackground="Light"><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\t\tclass="sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image\n\t\t\t\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/DemoApps_S_cropped.jpg"\n\t\t\t\t\t\t\t\t\talt="{i18n>DEMO_APPS_IMAGE_PHONE}"\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\t\t\t\tload=".handleLandingImageLoad"\n\t\t\t\t\t\t\t\t\tvisible="{device>/system/phone}"\n\t\t\t\t\t\t\t\t\tdensityAware="false"/><Image\n\t\t\t\t\t\t\t\t\tid="desktopImage"\n\t\t\t\t\t\t\t\t\tclass="desktopImage welcomeImage"\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/DemoApps_M_and_L_cropped.jpg"\n\t\t\t\t\t\t\t\t\talt="{i18n>DEMO_APPS_IMAGE_DESKTOP}"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\tload=".handleLandingImageLoad"\n\t\t\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"\n\t\t\t\t\t\t\t\t\twidth="100%"/><l:Grid\n\t\t\t\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\t\t\tclass="headerGrid"\n\t\t\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\t\t\tdefaultSpan="L6 M6 S12"><l:VerticalLayout width="100%" class="sapUiTinyMarginTop sapUiTinyMarginEnd"><Text class="headerText" text="{i18n>DEMO_APPS_TEXT}" width="100%" textAlign="Left"/><l:HorizontalLayout><Button\n\t\t\t\t\t\t\t\t\t\t\t\tclass="actionButton headerButton"\n\t\t\t\t\t\t\t\t\t\t\t\tid="download"\n\t\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>DEMO_APPS_DOWNLOAD_BTN}"\n\t\t\t\t\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\t\t\t\t\tpress=".onDownloadButtonPress"></Button><Button\n\t\t\t\t\t\t\t\t\t\t\t\tclass="actionButton headerButton sapContrast sapContrastPlus sapUiSmallMarginBegin"\n\t\t\t\t\t\t\t\t\t\t\t\tid="readMoreButton"\n\t\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>DEMO_APPS_READ_MORE_BTN}"\n\t\t\t\t\t\t\t\t\t\t\t\tpress=".onReadMoreButtonPress"></Button></l:HorizontalLayout></l:VerticalLayout></l:Grid></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:VerticalLayout content="{/demoAppsByCategory}" width="100%"><Panel\n\t\t\t\t\t\taccessibleRole="Region"\n\t\t\t\t\t\tbackgroundDesign="Transparent"\n\t\t\t\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title\n\t\t\t\t\t\t\t\t\ttext="{\n\t\t\t\t\t\t\t\t\t\tpath: \'categoryId\',\n\t\t\t\t\t\t\t\t\t\tformatter: \'.formatter.categoryName\'\n\t\t\t\t\t\t\t\t\t}"\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout\n\t\t\t\t\t\t\tcontent="{\n\t\t\t\t\t\t\t\t path: \'rows\',\n\t\t\t\t\t\t\t\t templateShareable: false\n\t\t\t\t\t\t\t}"\n\t\t\t\t\t\t\tbackground="Light"><l:BlockLayoutRow content="{\n\t\t\t\t\t\t\t\tpath: \'\',\n\t\t\t\t\t\t\t\tfactory: \'.createDemoAppCellFactory\'\n\t\t\t\t\t\t\t}"/></l:BlockLayout></Panel></l:VerticalLayout><core:Fragment id="demoAppsFooter" visible="{/bFooterVisible}" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" /></ScrollContainer></content><dependents><Dialog id="downloadDialog"\n\t\t\t\ttitle="{i18n>DEMO_APPS_DOWNLOAD_DIALOG_TITLE}"><subHeader><Toolbar><SearchField id="downloadDialogSearch" liveChange=".onSearch"/></Toolbar></subHeader><List items="{/demoApps}" id="downloadDialogList"><InputListItem\n\t\t\t\t\t\tvisible="{= !!${config} }"\n\t\t\t\t\t\tlabel="{name}"><customData><core:CustomData key="config" value="{config}"/></customData><Button\n\t\t\t\t\t\t\ttext="{i18n>DEMO_APPS_DOWNLOAD_BTN}"\n\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\tpress=".onDownloadPress"/></InputListItem></List><buttons><Button text="{i18n>DEMO_APPS_DOWNLOAD_DIALOG_CANCEL_BTN}" press=".onCloseDialog" /></buttons></Dialog></dependents></Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/Downloads.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Downloads"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"><Label text="{i18n>DOWNLOADS_TEXT}" /></mvc:View>\n',
	"sap/ui/documentation/sdk/view/Empty.view.xml":'<mvc:View\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"><Label text="Empty" /></mvc:View>\n',
	"sap/ui/documentation/sdk/view/Entity.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Entity"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns="sap.uxap"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"><ObjectPageLayout\n\t\t\tid="ObjectPageLayout"\n\t\t\tuseIconTabBar="true"\n\t\t\tselectedSection="samples"\n\t\t\tupperCaseAnchorBar="false"\n\t\t\tbusyIndicatorDelay="0"><headerTitle><ObjectPageHeader\n\t\t\t\t\tid="entityHeader"\n\t\t\t\t\tobjectTitle="{/name}"><actions><ObjectPageHeaderActionButton id="entityBackToSearch" text="{i18n>ENTITY_BACK_BTN}" hideIcon="true" hideText="false" press="backToSearch" visible="false"/><ObjectPageHeaderActionButton\n\t\t\t\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\t\t\t\tvisible="{device>/system/desktop}"\n\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\ttooltip="{i18n>ENTITY_FULLSCREEN_TOOLTIP}"\n\t\t\t\t\t\t\tpress="onToggleFullScreen" /></actions></ObjectPageHeader></headerTitle><headerContent><l:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0"><l:VerticalLayout width="98%" id="headerColumn0"/><l:VerticalLayout width="100%" id="headerColumn1" visible="false"/><l:VerticalLayout width="100%" id="headerColumn2" visible="false"/></l:Grid></headerContent><sections><ObjectPageSection class="sapUiDemokitEntityAbout" id="about" title="{i18n>ENTITY_ABOUT}"><subSections><ObjectPageSubSection><l:VerticalLayout><core:HTML content="{/description}" /><l:VerticalLayout visible="{/show/introLink}"><m:Text text="{/shortDescription}"/></l:VerticalLayout></l:VerticalLayout></ObjectPageSubSection></subSections></ObjectPageSection><ObjectPageSection class="sapUiDemokitEntitySamples" id="samples" title="{\n\t\t\t\t\tparts: [\n\t\t\t\t\t\t\'i18n>ENTITY_SAMPLES\',\n\t\t\t\t\t\t\'/count/samples\'\n\t\t\t\t\t],\n\t\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t\t}"\n\t\t\t\tvisible="{= ${/count/samples} > 0 }"><subSections><ObjectPageSubSection><m:VBox><m:MessageStrip\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom sapUiSmallNegativeMarginBeginEnd"\n\t\t\t\t\t\t\t\t\ttext="{/deprecatedMark}"\n\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\tvisible="{= ${/deprecated} === \'true\'}"/><m:Table\n\t\t\t\t\t\t\t\t\tclass="myTable sapUxAPObjectPageSubSectionAlignContent"\n\t\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\t\tid="table"\n\t\t\t\t\t\t\t\t\titems="{/entity/samples}"\n\t\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\t\tshowSeparators="Inner" ><m:columns><m:Column><m:Label text="{i18n>ENTITY_TABLE_NAME}" /></m:Column><m:Column minScreenWidth="Tablet"><m:Label text="{i18n>ENTITY_TABLE_DESCRIPTION}" /></m:Column></m:columns><m:items><m:ColumnListItem type="Navigation" press="onNavToSample" vAlign="Middle"><m:cells><m:Text text="{name}" class="entitySampleName" wrapping="false" /><m:FormattedText htmlText="{= ${path: \'description\'} ? ${path: \'description\'} : \'\'}" /></m:cells></m:ColumnListItem></m:items></m:Table></m:VBox></ObjectPageSubSection></subSections></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/Footer.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"><Toolbar style="Clear" class="sapUiDocumentationFooter"><FlexBox\n\t\t\t\talignItems="{= ${device>/system/phone} ? \'Start\' : \'Center\' }"\n\t\t\t\tjustifyContent="SpaceBetween"\n\t\t\t\tdirection ="{= ${device>/system/phone} ? \'Column\' : \'Row\' }"\n\t\t\t\twidth="100%"><items><Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_sap.png"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\twidth="3rem"\n\t\t\t\t\t\theight="1.5rem"></Image><FlexBox\n\t\t\t\t\t\tdirection ="{= ${device>/system/phone} ? \'Column\' : \'Row\' }"\n\t\t\t\t\t\tclass="sapUiTinyMarginTop"><items><Link\n\t\t\t\t\t\t\t\tclass="sapUiLargeMarginEnd sapUiTinyMarginBottom"\n\t\t\t\t\t\t\t\ttext="{i18n>FOOTER_LEGAL_DISCOLURE}"\n\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/impressum.html"\n\t\t\t\t\t\t\t\ttarget="_blank"/><Link\n\t\t\t\t\t\t\t\tclass="sapUiLargeMarginEnd sapUiTinyMarginBottom"\n\t\t\t\t\t\t\t\ttext="{i18n>FOOTER_PRIVACY}"\n\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/privacy.html"\n\t\t\t\t\t\t\t\ttarget="_blank"/><Link\n\t\t\t\t\t\t\t\ttext="{i18n>FOOTER_TERMS}"\n\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/terms-of-use.html"\n\t\t\t\t\t\t\t\tvisible="{= !${versionData>/isOpenUI5} &amp;&amp; !${versionData>/isDevEnv} }"\n\t\t\t\t\t\t\t\ttarget="_blank"/><Link\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiLargeMarginEnd"\n\t\t\t\t\t\t\t\ttext="{i18n>FOOTER_LICENSE}"\n\t\t\t\t\t\t\t\thref="LICENSE.txt"\n\t\t\t\t\t\t\t\tvisible="{versionData>/isOpenUI5}"\n\t\t\t\t\t\t\t\ttarget="_blank"/><Link\n\t\t\t\t\t\t\t\ttext="{i18n>FOOTER_TERMS}"\n\t\t\t\t\t\t\t\thref="TermsOfUse.txt"\n\t\t\t\t\t\t\t\tvisible="{versionData>/isOpenUI5}"\n\t\t\t\t\t\t\t\ttarget="_blank"/></items></FlexBox></items></FlexBox></Toolbar></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/FooterMaster.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:tnt="sap.tnt"\n\t\txmlns:core="sap.ui.core"><tnt:NavigationList itemSelect="handleFooterMasterItemPress"><tnt:NavigationListItem icon="sap-icon://compare" key="legal" text="{i18n>APP_INFORMATION_BTN_LEGAL}" /><tnt:NavigationListItem icon="sap-icon://locked" key="privacy" text="{i18n>APP_INFORMATION_BTN_PRIVACY}" /><tnt:NavigationListItem icon="sap-icon://permission" text="{i18n>APP_INFORMATION_BTN_LICENSE}" key="license" visible="{versionData>/isOpenUI5}" /><tnt:NavigationListItem icon="sap-icon://document-text" key="terms_of_use" text="{i18n>APP_INFORMATION_BTN_TERMS_OF_USE}" visible="{=!${versionData>/isOpenUI5}}" /></tnt:NavigationList></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/GlobalSearchPicker.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"><VBox><List id="shortList"\n\t\t\t\titems="{\n\t\t\t\t\tpath: \'searchData>/matches/filteredData\',\n\t\t\t\t\tsorter: [{\n\t\t\t\t\t\tpath: \'\',\n\t\t\t\t\t\tdescending: true,\n\t\t\t\t\t\tgroup: \'.getSearchPickerTitle\'\n\t\t\t\t\t}]\n\t\t\t\t}"><StandardListItem\n\t\t\t\t\ttitle="{\n\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\'searchData>title\',\n\t\t\t\t\t\t\t\'searchData>summary\'\n\n\t\t\t\t\t\t],\n\t\t\t\t\t\tformatter: \'.formatSuggestionTitle\'\n\t\t\t\t\t}"\n\t\t\t\t\tpress="onSearchPickerItemPress"\n\t\t\t\t\ttype="Active"></StandardListItem></List><Link width="100%"\n\t\t\t  class="sapMSelectListItem sapMSelectListItemBase sapMSelectListItemBaseHoverable"\n\t\t\t  press="onSearchResultsSummaryPress"\n\t\t\t  text="{i18n>SEARCH_SUGGESTIONS_ALL_SECTION_TITLE} ({searchData>/matches/AllLength})"\n\t\t\t  visible="{= ${searchData>/matches/AllLength}>0 }"/><List id="categoryList"><GroupHeaderListItem title="Results by Category"/><StandardListItem\n\t\t\t\t\ttitle="{i18n>SEARCH_SUGGESTIONS_API_SECTION_TITLE}"\n\t\t\t\t\tcounter="{searchData>/matches/APILength}"\n\t\t\t\t\tpress="onSearchResultsSummaryPress"\n\t\t\t\t\ttype="Active"><customData><core:CustomData key="category" value="apiref" /></customData></StandardListItem><StandardListItem\n\t\t\t\t\ttitle="{i18n>SEARCH_SUGGESTIONS_DOCUMENTATION_SECTION_TITLE}"\n\t\t\t\t\tcounter="{searchData>/matches/DocLength}"\n\t\t\t\t\tpress="onSearchResultsSummaryPress"\n\t\t\t\t\ttype="Active"><customData><core:CustomData key="category" value="topics" /></customData></StandardListItem><StandardListItem\n\t\t\t\t\ttitle="{i18n>SEARCH_SUGGESTIONS_SAMPLES_SECTION_TITLE}"\n\t\t\t\t\tcounter="{searchData>/matches/ExploredLength}"\n\t\t\t\t\tpress="onSearchResultsSummaryPress"\n\t\t\t\t\ttype="Active"><customData><core:CustomData key="category" value="entity" /></customData></StandardListItem></List></VBox></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Group.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Group"\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:controls="sap.ui.documentation"><m:Page\n\t\t\tid="controlsDetailPage"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowHeader="{device>/orientation/portrait}"\n\t\t\tshowSubHeader="false"\n\t\t\tshowFooter="false"\n\t\t\tshowNavButton="{device>/system/phone}"\n\t\t\tbusy="{detailView>/busy}"\n\t\t\tbusyIndicatorDelay="{detailView>/delay}"><m:content></m:content></m:Page></mvc:View>',
	"sap/ui/documentation/sdk/view/LegalDisclaimerPopover.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"><ResponsivePopover placement="Auto" title="{i18n>LEGAL_DISCLAIMER_TITLE}" horizontalScrolling="false" contentWidth="30%" class="sapUiContentPadding"><Label text="{i18n>LEGAL_DISCLAIMER_LABEL_1}" design="Bold"/><Image\n\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\twidth="1.25rem"\n\t\t\tclass="sapUiTinyMarginBegin"/><Text text="{i18n>LEGAL_DISCLAIMER_TEXT_1}"/><Text text="{i18n>LEGAL_DISCLAIMER_TEXT_2}"/><Text text="{i18n>LEGAL_DISCLAIMER_TEXT_3}"/><Label text="{i18n>LEGAL_DISCLAIMER_LABEL_2}" design="Bold" class="sapUiTinyMarginTop"/><Image\n\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\twidth="1.25rem"\n\t\t\tclass="sapUiTinyMarginBegin"/><Text text="{i18n>LEGAL_DISCLAIMER_TEXT_4}"/></ResponsivePopover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/License.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.License"\n          height="100%"\n          xmlns:mvc="sap.ui.core.mvc"\n          xmlns="sap.m"><Page height="100%"\n          showHeader="false"\n          showSubHeader="false"><Text id="licenseText"\n              renderWhitespace="true"\n              class="sapUiTinyMarginBegin"/></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/LiveEditor.view.xml":'<mvc:View\n        controllerName="sap.ui.documentation.sdk.controller.LiveEditor"\n        xmlns="sap.m"\n        xmlns:l="sap.ui.layout"\n        xmlns:core="sap.ui.core"\n        xmlns:mvc="sap.ui.core.mvc"\n        xmlns:custom="sap.ui.documentation"\n        xmlns:editor="sap.ui.codeeditor"\n        xmlns:html="http://www.w3.org/1999/xhtml"\n        class="liveEditor"><Page\n\t\tid="liveEditorPage"\n\t\tshowSubHeader="false"\n\t\tshowFooter="false"\n\t\tshowNavButton="true"\n        enableScrolling="false"\n\t\ttitle="{i18n>LIVE_EDITOR_TITLE}"\n\t\tnavButtonPress="onNavButtonPress"><html:div class="editorWrapper"><html:div><IconTabHeader selectedKey="{viewModel>/selectedFileName}" select="onFileSwitch"><items><IconTabFilter text="App.view.xml" key="App.view.xml"/><IconTabFilter text="App.controller.js" key="App.controller.js"/><IconTabFilter text="index.js" key="index.js"/><IconTabFilter text="index.html" key="index.html"/></items></IconTabHeader><html:div class="editorSrcWindow"><editor:CodeEditor id="srcEditor"\n                                       editable="{= ${viewModel>/selectedFileType} !== \'text\' }"\n                                       value="{viewModel>/selectedFileContent}"\n                                       type="{viewModel>/selectedFileType}"\n                                       liveChange="onSrcLiveChange"/></html:div></html:div><VBox id="resultBox" class="liveEditorResultBox" width="100%" height="100%"><Toolbar style="Clear" class="editorToolbar"><Button text="{i18n>LIVE_EDITOR_PREVIEW_BTN}"\n                            press="requestExecuteCurrentSrc"\n                            enabled="{= !${viewModel>/autoPreview}}"/><CheckBox text="{i18n>LIVE_EDITOR_LIVE_PREVIEW_TEXT}"\n                              selected="{viewModel>/autoPreview}"/></Toolbar><core:HTML id="outputWindowWrapper" class="outputWindowWrapper" content="&lt;div class=&quot;outputWindowWrapper&quot;&gt;&lt;/div&gt;"><core:layoutData><FlexItemData growFactor="1"></FlexItemData></core:layoutData></core:HTML></VBox></html:div></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/News.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.News"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"><MessagePage\n\t\tvisible="{=!!${/preparationFailureMessage}}"\n\t\ttext="{i18n>NEWS_PREP_FAILURE_TITLE}"\n\t\tdescription="{/preparationFailureMessage}"\n\t\tshowHeader="false"\n\t\ticon="sap-icon://message-warning"/><VBox visible="{=!${/preparationFailureMessage}}"><NotificationList><NotificationListGroup\n\t\t\t\titems="{path:  \'/new\', templateShareable: false}"\n\t\t\t\ttitle="{i18n>NEWS_NEW_GROUP_TITLE}"\n\t\t\t\tshowCloseButton="false"><buttons><Button text="{i18n>NEWS_BTN_MARK_AS_READ}" press="handleMarkAsRead" /></buttons><NotificationListItem\n\t\t\t\t\ttitle="{title}"\n\t\t\t\t\tdescription="{description}"\n\t\t\t\t\tdatetime="{updated}"\n\t\t\t\t\tclose="handleNewsItemClose"\n\t\t\t\t\tclass="sapUiDemokitCustomNLI"><buttons><Button visible="{= %{link} !== \'\'}" text="{i18n>NEWS_BTN_VISIT_LINK}" press="handleVisitLink"><customData><core:CustomData key="newsLink" value="{link}"/></customData></Button></buttons><customData><core:CustomData key="newsID" value="{id}"/></customData></NotificationListItem></NotificationListGroup><NotificationListGroup\n\t\t\t\titems="{path:  \'/old\', templateShareable: false}"\n\t\t\t\ttitle="{i18n>NEWS_READ_GROUP_TITLE}"\n\t\t\t\tshowCloseButton="false"><NotificationListItem\n\t\t\t\t\ttitle="{title}"\n\t\t\t\t\tdescription="{description}"\n\t\t\t\t\tdatetime="{updated}"\n\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\tclass="sapUiDemokitCustomNLI"><buttons><Button visible="{= %{link} !== \'\'}" text="{i18n>NEWS_BTN_VISIT_LINK}" press="handleVisitLink"><customData><core:CustomData key="newsLink" value="{link}"/></customData></Button></buttons></NotificationListItem></NotificationListGroup></NotificationList></VBox></mvc:View>\n',
	"sap/ui/documentation/sdk/view/NewsPopover.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"><ResponsivePopover\n\t\tid="newsPopover"\n\t\tplacement="Bottom"\n\t\ttitle="{i18n>APP_NEWS_BTN_TOOLTIP}"><beginButton><Button\n\t\t\t\t\tid="dismissAllNotifications"\n\t\t\t\t\ttext="{i18n>APP_NEWS_DISMISS_ALL_BTN}"\n\t\t\t\t\tpress="handleDismissAllPress"\n\t\t\t\t\tenabled="{= %{news>/newsCount} > 0}" /></beginButton><endButton><Button\n\t\t\t\t\tid="showAllNotifications"\n\t\t\t\t\ttext="{i18n>APP_NEWS_SHOW_ALL_BTN}"\n\t\t\t\t\tpress="handleShowAllPress" /></endButton><VBox><NotificationList\n\t\t\tnoDataText="{i18n>APP_NEWS_NO_NEW_TEXT}"\n\t\t\titems="{path:  \'news>/items\', templateShareable: false}"\n\t\t\t><layoutData><FlexItemData maxHeight="450px" maxWidth="600px" /></layoutData><NotificationListItem\n\t\t\t\ttitle="{news>title}"\n\t\t\t\tdescription="{news>description}"\n\t\t\t\tdatetime="{news>updated}"\n\t\t\t\tclose="handleNewsItemClose"\n\t\t\t\tclass="sapUiDemokitCustomNLI"><buttons><Button visible="{= %{news>link} !== \'\'}" text="{i18n>NEWS_BTN_VISIT_LINK}" press="handleVisitNewsLink"><customData><core:CustomData key="newsLink" value="{news>link}"/></customData></Button></buttons><customData><core:CustomData key="newsID" value="{news>id}"/></customData></NotificationListItem></NotificationList></VBox></ResponsivePopover></core:FragmentDefinition>\n',
	"sap/ui/documentation/sdk/view/NotFound.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.NotFound"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"><MessagePage\n\t\t\tid="page"\n\t\t\ttitle="{i18n>NOT_FOUND_TITLE}"\n\t\t\ttext="{i18n>NOT_FOULD_TEXT}"\n\t\t\ticon="sap-icon://document"\n\t\t\tdescription=""\n\t\t\tshowNavButton="{device>/system/phone}"\n\t\t\tnavButtonPress="onNavBack"></MessagePage></mvc:View>\n',
	"sap/ui/documentation/sdk/view/ReleaseDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"><Dialog\n\t\t\tid="releaseDialog"\n\t\t\tresizable="true"\n\t\t\tdraggable="true"\n\t\t\ttitle="{\n\t\t\t\tparts: [\n\t\t\t\t\t\'i18n>RELEASE_DIALOG_TITLE\',\n\t\t\t\t\t\'/library\'\n\t\t\t\t],\n\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t}"\n\t\t\tcontentWidth="40%"\n\t\t\tcontentHeight="40%"\n\t\t\tstretch="{appView>/bPhoneSize}"><Text text="{i18n>RELEASE_DIALOG_NO_DATA_TEXT}" class="sapUiSmallMargin" visible="{=!!${/noData}}"/><beginButton><Button text="{i18n>RELEASE_DIALOG_CLOSE_BTN}" press="onReleaseDialogClose"/></beginButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ReleaseNotes.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ReleaseNotes"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.uxap"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:m="sap.m"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"\n\t\theight="100%"><ObjectPageLayout\n\t\t\t\t\tid="releaseNotesObjectPage"\n\t\t\t\t\tbusy="true"\n\t\t\t\t\tenableLazyLoading="false"\n\t\t\t\t\tshowTitleInHeaderContent="false"\n\t\t\t\t\tsections="{/libs}"\n\t\t\t\t\tupperCaseAnchorBar="false"><headerTitle><ObjectPageHeader objectTitle="{i18n>RELEASE_NOTES_TITLE}"/></headerTitle><headerContent><layout:VerticalLayout><m:Text text="This log includes the library notes for the libraries listed below."/><m:Select id="VersionSelect" items="{select>/items}" change="handleVersionChange" visible="false"><core:Item text="{select>value}" key="{select>key}"/></m:Select></layout:VerticalLayout></headerContent><sections><ObjectPageSection title="{library}" titleUppercase="false"><ObjectPageSubSection titleUppercase="false"><layout:VerticalLayout content="{path: \'versions\', templateShareable: false}" width="100%"><m:Panel\n\t\t\t\t\t\t\t\t\theaderText="{version}"\n\t\t\t\t\t\t\t\t\tcontent="{path: \'notes\', templateShareable: false}"\n\t\t\t\t\t\t\t\t\texpandable="true"\n\t\t\t\t\t\t\t\t\texpanded="true"\n\t\t\t\t\t\t\t\t\tclass="sapUxAPObjectPageSubSectionAlignContent"\n\t\t\t\t\t\t\t\t\twidth="auto"><m:Text width="100%" text="[{type}] {text}"/></m:Panel></layout:VerticalLayout></ObjectPageSubSection></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ReleaseNotesView.fragment.xml":'<core:FragmentDefinition xmlns="sap.m"\n\txmlns:l="sap.ui.layout"\n\txmlns:core="sap.ui.core"><List items="{/notes}"><StandardListItem title="{type}" description="{text}" /></List></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Sample.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Sample"\n\t\txmlns="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:controls="sap.ui.documentation"><Page\n\t\t\tid="page"\n\t\t\tshowHeader="false"\n\t\t\tshowNavButton="true"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tbusyIndicatorDelay="0"\n\t\t\tclass="sapUiDocumentationSamplePage"><landmarkInfo><PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo></landmarkInfo><subHeader><Bar id="header" class="sapContrast sapContrastPlus"><contentLeft><Button type="Back" press="onNavBack" tooltip="{i18n>SAMPLE_BACK_BTN_TOOLTIP}" enabled="{= ${/disableNavBack} === undefined }"/></contentLeft><contentMiddle><Title level="H1" text="{/title}" tooltip="{/title}"/><Button\n\t\t\t\t\t\t\tid="warningSample"\n\t\t\t\t\t\t\ticon="sap-icon://warning"\t\n\t\t\t\t\t\t\tvisible="{=${/showWarning}}"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_EDITED_TOOLTIP}"\n\t\t\t\t\t\t\tclass="sapUiExploredWarningIcon"\n\t\t\t\t\t\t\tpress="onWarningSample"/></contentMiddle><contentRight><Button\n\t\t\t\t\t\t\tid="infoSample"\n\t\t\t\t\t\t\tvisible="{=${/details} !== undefined || ${/description} !== undefined}"\n\t\t\t\t\t\t\ticon="sap-icon://hint"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_INFO_TOOLTIP}"\n\t\t\t\t\t\t\tpress="onInfoSample"/><Button id="apiRefButton" text="{i18n>SAMPLE_API_REFERENCE_BTN}" type="Emphasized" press="onAPIRefPress" visible="false"/><Button\n\t\t\t\t\t\t\tid="prevSample"\n\t\t\t\t\t\t\ticon="sap-icon://navigation-up-arrow"\n\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_PREV_BTN_TOOLTIP}"\n\t\t\t\t\t\t\tenabled="{= ${/previousSampleId} !== undefined }"\n\t\t\t\t\t\t\tpress="onPreviousSample"/><Button\n\t\t\t\t\t\t\tid="nextSample"\n\t\t\t\t\t\t\ticon="sap-icon://navigation-down-arrow"\n\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_NEXT_BTN_TOOLTIP}"\n\t\t\t\t\t\t\tenabled="{= ${/nextSampleId} !== undefined }"\n\t\t\t\t\t\t\tpress="onNextSample"/><Button\n\t\t\t\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\tvisible="{:= ${device>/system/desktop} ||\n\t\t\t\t\t\t\t\t\t\t&#40; ${device>/system/tablet} &amp;&amp;\n\t\t\t\t\t\t\t\t\t\t${device>/orientation/landscape} &#41; }"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_FULLSCREEN_BTN_TOOLTIP}"\n\t\t\t\t\t\t\tpress="onToggleFullScreen" /><Button\n\t\t\t\t\t\t\tid="toggleRTA"\n\t\t\t\t\t\t\ticon="sap-icon://wrench"\n\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_ADAPT_BTN_TOOLTIP}"\n\t\t\t\t\t\t\tpress="onToggleAdaptationMode"\n\t\t\t\t\t\t\tvisible="{= ${/rtaLoaded} &amp;&amp; !${/iframe} }" /><Button\n\t\t\t\t\t\t\tid="code"\n\t\t\t\t\t\t\ticon="sap-icon://source-code"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_CODE_BTN_TOOLTIP}"\n\t\t\t\t\t\t\tpress="onNavToCode" /><Button visible="{/showNewTab}"\n\t\t\t\t\t\t\tid="newTab"\n\t\t\t\t\t\t\ttooltip="{i18n>SAMPLE_NEW_TAB_BTN_TOOLTIP}"\n\t\t\t\t\t\t\ticon="sap-icon://inspect"\n\t\t\t\t\t\t\tpress="onNewTab" /><Button id="sampleSettings"\n\t\t\t\t\t\t\tvisible="{= ${/showSettings} &amp;&amp; !${/iframe} }"\n\t\t\t\t\t\t\ticon="sap-icon://action-settings"\n\t\t\t\t\t\t\tpress="handleSettings" /><Button\n\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\ttext="{i18n>SAMPLE_DOWNLOAD_BTN_TOOLTIP}"\n\t\t\t\t\t\t\ticon="sap-icon://download"\n\t\t\t\t\t\t\tpress="onDownload" /><Button\n\t\t\t\t\t\t\tclass="sapUiVisibleOnlyOnPhone"\n\t\t\t\t\t\t\ticon="sap-icon://download"\n\t\t\t\t\t\t\tpress="onDownload" /></contentRight></Bar></subHeader></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/SampleNotFound.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.SampleNotFound"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"><MessagePage\n\t\t\tid="page"\n\t\t\ttitle="{i18n>NOT_FOUND_SAMPLE_TITLE}"\n\t\t\ttext="{i18n>NOT_FOUND_SAMPLE_TEXT}"\n\t\t\tdescription="&lt;a target=\'_self\' href=\'controls\' &gt;Samples page&lt;/a&gt;"\n\t\t\ticon="sap-icon://document"\n\t\t\tenableFormattedText="true"\n\t\t\tshowNavButton="{device>/system/phone}"\n\t\t\tnavButtonPress="onNavBack"></MessagePage></mvc:View>\n',
	"sap/ui/documentation/sdk/view/SearchPage.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.SearchPage"\n\t\txmlns="sap.m"\n\t\txmlns:op="sap.uxap"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><op:ObjectPageLayout id="searchPage"\n\t\t\t\t\t\t\tuseIconTabBar="true"\n\t\t\t\t\t\t\talwaysShowContentHeader="true"\n\t\t\t\t\t\t\tupperCaseAnchorBar="false"\n\t\t\t\t\t\t\tnavigate="onSwitchTab"><op:headerTitle><op:ObjectPageHeader id="searchTitle" objectTitle="{\n\t\t\t\tparts: [\n\t\t\t\t\t\'i18n>SEARCH_PAGE_TITLE\',\n\t\t\t\t\t\'searchView>/lastProcessedQuery\'\n\t\t\t\t],\n\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t}"></op:ObjectPageHeader></op:headerTitle><op:headerContent><ObjectAttribute title="" text="{i18n>SEARCH_PAGE_DESCRIPTION}"/></op:headerContent><op:sections><op:ObjectPageSection id="allSummaryTitle" title="{\n\t\t\t\tparts: [\n\t\t\t\t\t\'i18n>SEARCH_PAGE_ALL_SECTION_TITLE\',\n\t\t\t\t\t\'searchData>/matches/AllLength\'\n\t\t\t\t],\n\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{\n\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\'i18n>SEARCH_PAGE_ALL_SECTION_TABLE_TITLE\',\n\t\t\t\t\t\t\t\t\t\t\'searchView>/visibleAllLength\',\n\t\t\t\t\t\t\t\t\t\t\'searchData>/matches/AllLength\'\n\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\tformatter: \'.formatTableTitle\'\n\t\t\t\t\t\t\t\t}"/></OverflowToolbar><CheckBox text="{i18n>API_MASTER_DEPRECATED_CB}" class="sapUiNoMarginBegin" selected="{searchData>/includeDeprecated}" select="onDeprecatedFlagChange"/><List\n\t\t\t\t\t\t\t\tid="allList"\n\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\tupdateFinished="onAllLoadMore"\n\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\tpath: \'searchData>/matches/data\',\n\t\t\t\t\t\t\t\t\tgroupHeaderFactory: \'.getGroupHeader\'\n\t\t\t\t\t\t\t\t}"><FeedListItem\n\t\t\t\t\t\t\t\t\tsender="{searchData>title}"\n\t\t\t\t\t\t\t\t\ttext="{searchData>summary}"\n\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\tapp:path="{searchData>path}"\n\t\t\t\t\t\t\t\t\tapp:external="{searchData>external}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection id="apiref" title="{\n\t\t\t\t\tparts: [\n\t\t\t\t\t\t\'i18n>SEARCH_PAGE_API_SECTION_TITLE\',\n\t\t\t\t\t\t\'searchData>/matches/APILength\'\n\t\t\t\t\t],\n\t\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t\t}"\n\t\t\t\tvisible="{=!!${searchData>/matches/APILength}}"\n\t\t\t\tapp:category="apiref"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{\n\t\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\t\'i18n>SEARCH_PAGE_API_SECTION_TABLE_TITLE\',\n\t\t\t\t\t\t\t\t\t\t\t\'searchView>/visibleAPILength\',\n\t\t\t\t\t\t\t\t\t\t\t\'searchData>/matches/APILength\'\n\t\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\t\tformatter: \'.formatTableTitle\'\n\t\t\t\t\t\t\t\t\t}"/></OverflowToolbar><CheckBox text="{i18n>API_MASTER_DEPRECATED_CB}" class="sapUiNoMarginBegin" selected="{searchData>/includeDeprecated}" select="onDeprecatedFlagChange"/><List\n\t\t\t\t\t\t\t\t\tid="apiList"\n\t\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\t\tupdateFinished="onAPILoadMore"\n\t\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\t\tpath: \'searchData>/matches/aDataAPI\'\n\t\t\t\t\t\t\t\t\t}"><FeedListItem\n\t\t\t\t\t\t\t\t\t\tvisible="{path:\'searchData>category\', formatter:\'.categoryAPIFormatter\'}"\n\t\t\t\t\t\t\t\t\t\tsender="{searchData>title}"\n\t\t\t\t\t\t\t\t\t\ttext="{searchData>summary}"\n\t\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\t\tapp:path="{searchData>path}"\n\t\t\t\t\t\t\t\t\t\tapp:external="{searchData>external}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection id="topics" title="{\n\t\t\t\t\tparts: [\n\t\t\t\t\t\t\'i18n>SEARCH_PAGE_DOCUMENTATION_SECTION_TITLE\',\n\t\t\t\t\t\t\'searchData>/matches/DocLength\'\n\t\t\t\t\t],\n\t\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t\t}"\n\t\t\t\tvisible="{=!!${searchData>/matches/DocLength}}"\n\t\t\t\tapp:category="topics"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{\n\t\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\t\'i18n>SEARCH_PAGE_DOCUMENTATION_SECTION_TABLE_TITLE\',\n\t\t\t\t\t\t\t\t\t\t\t\'searchView>/visibleDocLength\',\n\t\t\t\t\t\t\t\t\t\t\t\'searchData>/matches/DocLength\'\n\t\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\t\tformatter: \'.formatTableTitle\'\n\t\t\t\t\t\t\t\t\t}"/></OverflowToolbar><List\n\t\t\t\t\t\t\t\t\tid="documentationList"\n\t\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\t\tupdateFinished="onDocLoadMore"\n\t\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\t\tpath: \'searchData>/matches/aDataDoc\'\n\t\t\t\t\t\t\t\t\t}"><FeedListItem\n\t\t\t\t\t\t\t\t\t\tvisible="{path:\'searchData>category\', formatter:\'.categoryDocFormatter\'}"\n\t\t\t\t\t\t\t\t\t\tsender="{searchData>title}"\n\t\t\t\t\t\t\t\t\t\ttext="{searchData>summary}"\n\t\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\t\tapp:path="{searchData>path}"\n\t\t\t\t\t\t\t\t\t\tapp:external="{searchData>external}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection id="samples" title="{\n\t\t\t\t\tparts: [\n\t\t\t\t\t\t\'i18n>SEARCH_PAGE_SAMPLES_SECTION_TITLE\',\n\t\t\t\t\t\t\'searchData>/matches/ExploredLength\'\n\t\t\t\t\t],\n\t\t\t\t\tformatter: \'.formatMessage\'\n\t\t\t\t}"\n\t\t\t\tvisible="{=!!${searchData>/matches/ExploredLength}}"\n\t\t\t\tapp:category="entity"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{\n\t\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\t\'i18n>SEARCH_PAGE_SAMPLES_SECTION_TABLE_TITLE\',\n\t\t\t\t\t\t\t\t\t\t\t\'searchView>/visibleExploredLength\',\n\t\t\t\t\t\t\t\t\t\t\t\'searchData>/matches/ExploredLength\'\n\t\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\t\tformatter: \'.formatTableTitle\'\n\t\t\t\t\t\t\t\t\t}"/></OverflowToolbar><CheckBox text="{i18n>API_MASTER_DEPRECATED_CB}" class="sapUiNoMarginBegin" selected="{searchData>/includeDeprecated}" select="onDeprecatedFlagChange"/><List\n\t\t\t\t\t\t\t\t\tid="samplesList"\n\t\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\t\tupdateFinished="onExploredLoadMore"\n\t\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\t\tpath: \'searchData>/matches/aDataExplored\'\n\t\t\t\t\t\t\t\t\t}"><FeedListItem\n\t\t\t\t\t\t\t\t\t\tvisible="{path:\'searchData>category\', formatter:\'.categoryExploredFormatter\'}"\n\t\t\t\t\t\t\t\t\t\tsender="{searchData>title}"\n\t\t\t\t\t\t\t\t\t\ttext="{searchData>summary}"\n\t\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\t\tapp:path="{searchData>path}"\n\t\t\t\t\t\t\t\t\t\tapp:external="{searchData>external}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection></op:sections></op:ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/Sitemap.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Sitemap"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\t><Page\n\t\tid="sitemapPage"\n\t\tshowSubHeader="false"\n\t\tshowFooter="false"\n\t\tshowNavButton="true"\n\t\ttitle="{i18n>SITEMAP_TITLE}"\n\t\ttitleAlignment="Center"\n\t\tnavButtonPress="onNavButtonPress"\n\t\tclass="sapUiDemoKitSitemapPage sapUiContentPadding"><content><l:HorizontalLayout class="sapUiDemoKitSitemapLinksWrapper sapUiResponsiveMargin" allowWrapping="true"><l:VerticalLayout width="100%"><Title titleStyle="H3" text="{i18n>APP_TABHEADER_ITEM_API_REFERENCE}"></Title></l:VerticalLayout><l:HorizontalLayout\n\t\t\t\t\tclass="sapUiDemoKitSitemapLinksWrapper"\n\t\t\t\t\tallowWrapping="true"\n\t\t\t\t\tcontent="{/api}"\n\t\t\t\t><l:VerticalLayout class="sapUiContentPadding sapUiDemoKitSitemapLink"><Link tooltip="{name}" href="{href}" text="{name}"></Link></l:VerticalLayout></l:HorizontalLayout></l:HorizontalLayout><l:HorizontalLayout class="sapUiDemoKitSitemapLinksWrapper sapUiResponsiveMargin" allowWrapping="true"><l:VerticalLayout width="100%"><Title titleStyle="H3" text="{i18n>APP_TABHEADER_ITEM_DOCUMENTATION}"></Title></l:VerticalLayout><l:HorizontalLayout\n\t\t\t\t\tclass="sapUiDemoKitSitemapLinksWrapper"\n\t\t\t\t\tallowWrapping="true"\n\t\t\t\t\tcontent="{/topic}"\n\t\t\t\t><l:VerticalLayout class="sapUiContentPadding sapUiDemoKitSitemapLink"><Link tooltip="{name}" href="{href}" text="{name}"></Link></l:VerticalLayout></l:HorizontalLayout></l:HorizontalLayout><l:HorizontalLayout class="sapUiDemoKitSitemapLinksWrapper sapUiResponsiveMargin" allowWrapping="true"><l:VerticalLayout width="100%"><Title titleStyle="H3" text="{i18n>APP_TABHEADER_ITEM_SAMPLES}"></Title></l:VerticalLayout><l:HorizontalLayout\n\t\t\t\t\tclass="sapUiDemoKitSitemapLinksWrapper"\n\t\t\t\t\tallowWrapping="true"\n\t\t\t\t\tcontent="{/entity}"\n\t\t\t\t><l:VerticalLayout class="sapUiContentPadding sapUiDemoKitSitemapLink"><Link tooltip="{name}" href="{href}" text="{name}"></Link></l:VerticalLayout></l:HorizontalLayout></l:HorizontalLayout><l:HorizontalLayout class="sapUiDemoKitSitemapLinksWrapper sapUiResponsiveMargin" allowWrapping="true"><l:VerticalLayout width="100%"><Title titleStyle="H3" text="{i18n>APP_TABHEADER_ITEM_DEMO_APPS}"></Title></l:VerticalLayout><l:HorizontalLayout\n\t\t\t\t\tclass="sapUiDemoKitSitemapLinksWrapper"\n\t\t\t\t\tallowWrapping="true"\n\t\t\t\t\tcontent="{/demoApps}"\n\t\t\t\t><l:VerticalLayout class="sapUiContentPadding sapUiDemoKitSitemapLink"><Link tooltip="{name}" href="{href}" text="{name}"></Link></l:VerticalLayout></l:HorizontalLayout></l:HorizontalLayout><l:HorizontalLayout class="sapUiDemoKitSitemapLinksWrapper sapUiResponsiveMargin" allowWrapping="true"><l:VerticalLayout width="100%"><Title titleStyle="H3" text="{i18n>APP_TABHEADER_ITEM_TOOLS}"></Title></l:VerticalLayout><l:HorizontalLayout\n\t\t\t\t\tclass="sapUiDemoKitSitemapLinksWrapper"\n\t\t\t\t\tallowWrapping="true"\n\t\t\t\t\tcontent="{/tools}"\n\t\t\t\t><l:VerticalLayout class="sapUiContentPadding sapUiDemoKitSitemapLink"><Link tooltip="{name}" href="{href}" text="{name}"></Link></l:VerticalLayout></l:HorizontalLayout></l:HorizontalLayout></content></Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/SubApiDetail.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.SubApiDetail"\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:custom="sap.ui.documentation"\n\t\txmlns:template="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"><m:Page\n\t\t\tid="apiDetailPage"\n\t\t\tshowHeader="false"\n\t\t\tshowSubHeader="false"\n\t\t\tshowFooter="false"\n\t\t\tclass="apiDetailPage"><m:content><ObjectPageLayout id="apiDetailObjectPage"\n\t\t\t\t\t\t\t  enableLazyLoading="true"\n\t\t\t\t\t\t\t  showAnchorBarPopover="true"\n\t\t\t\t\t\t\t  upperCaseAnchorBar="false"\n\t\t\t\t\t\t\t  busyIndicatorDelay="0"><headerTitle><ObjectPageHeader id="title" objectTitle="{/title}" objectSubtitle="{/subTitle}"><actions><ObjectPageHeaderActionButton id="apiDetailBackToSearch" text="Back to search results" hideIcon="true" hideText="false" press="backToSearch" visible="false"/><ObjectPageHeaderActionButton\n\t\t\t\t\t\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\t\t\t\t\t\tvisible="{device>/system/desktop}"\n\t\t\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\t\t\ttooltip="Show this sample in full screen mode"\n\t\t\t\t\t\t\t\t\tpress="onToggleFullScreen" /></actions></ObjectPageHeader><core:ExtensionPoint name="customTitle" /></headerTitle><headerContent><layout:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0"><layout:VerticalLayout width="98%" id="headerColumn0"/><layout:VerticalLayout width="100%" id="headerColumn1" visible="false"/><layout:VerticalLayout width="100%" id="headerColumn2" visible="false"/></layout:Grid></headerContent><sections><ObjectPageSection id="overview" title="Overview" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{=${data>/deprecatedText} !== undefined}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\ttext="{path : \'/deprecatedText\', formatter: \'.formatter.formatMessageStripLinks\'}"\n\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom sapUiSmallMarginTop"></m:MessageStrip></template:if><custom:JSDocText sanitizeContent="false" text="{/description}"/><template:if test="{=${data>/dnd/draggable} === true}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\ttext="This control can be a drag source."\n\t\t\t\t\t\t\t\t\t\t\t\ttype="Information"\n\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom sapUiSmallMarginTop"></m:MessageStrip></template:if><template:if test="{=${data>/dnd/droppable} === true}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\ttext="This control can be a drop target."\n\t\t\t\t\t\t\t\t\t\t\t\ttype="Information"\n\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom sapUiSmallMarginTop"></m:MessageStrip></template:if><template:if test="{data>/hasAnnotations}"><layout:HorizontalLayout class="sapUiTinyMarginTop sapUiDocumentationAnnotationsText"><m:Text text="A detailed description of the OData annotations handled by this control is available"/><m:Link text="here" press="onAnnotationsLinkPress"/><m:Text text="."/></layout:HorizontalLayout><layout:HorizontalLayout class="sapUiDocumentationAnnotationsText"><m:Label text="Annotation Restrictions:" design="Bold"/><m:Text text="Qualifier support for entity types is limited for this control."/></layout:HorizontalLayout></template:if><template:if test="{=${data>/experimental} !== undefined}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since version {/experimental/since} {/experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"></m:MessageStrip></template:if><template:if test="{= !!${data>/parameters} }"><custom:LightTable rows="{path: \'/parameters\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   columnTitles="Param,Type,Default Value,Description"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   columnCount="4"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   class="sapUiDocumentationParamsTable"><custom:Row><custom:ParamText text="{name}" phoneText="{phoneName}" depth="{depth}" optional="{optional}"/><m:Text text="{type}" wrapping="false"/><m:Text text="{defaultValue}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${data>/returnValue} !== undefined}"><custom:LightTable columnCount="2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   columnTitles="Returns,Description"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   class="sapUiDocumentation2ColumnsEqualTable"><custom:Row><m:Text text="{path: \'data>/returnValue/type\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{path: \'data>/returnValue/description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></custom:LightTable></template:if><template:if test="{data>/hasChildren}"><custom:LightTable\n\t\t\t\t\t\t\t\t\t\t\t\t rows="{path : \'/nodes\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t columnTitles="Namespaces &amp; Classes,Description"\n\t\t\t\t\t\t\t\t\t\t\t\t columnCount="2"\n\t\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop"><custom:Row><custom:ParamText text="{name}" href="{href}" deprecated="{deprecated}"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{data>/isFunction}"><template:repeat list="{data>/examples}" var="example"><custom:JSDocText sanitizeContent="false" text="{path: \'example>data\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></template:repeat></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection><template:if test="{data>/hasProperties}"><ObjectPageSection id="properties"\n\t\t\t\t\t\t\t\t\t\t   title="Fields"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path : \'/properties\'}"\n\t\t\t\t\t\t\t\t\t\t\t columnCount="3"\n\t\t\t\t\t\t\t\t\t\t\t columnTitles="Name,Type,Description"\n\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold sapUiDocumentationParamWrap" text="{name}" depth="{depth}" optional="{optional}" deprecated="{= ${deprecated} !== undefined }"/><layout:VerticalLayout content="{path: \'types\', templateShareable: false}" width="100%"><m:Link text="{path: \'value\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="{href}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${linkEnabled} }"/></layout:VerticalLayout><layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{description}"/><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${deprecated} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Deprecated as of version {deprecated/since}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {experimental/since} {experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:ObjectStatus text="Visibility: {parts : [{path : \'visibility\'}, {path : \'allowedFor\'}], formatter : \'sap.ui.documentation.sdk.model.formatter.formatVisibility\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{= ${visibility} === \'public\' ? \'Success\' : \'Warning\'}"/><m:ObjectStatus visible="{=${since} !== undefined}" text="Since: {since}" /><m:FormattedText visible="{=${borrowedFrom} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thtmlText="Borrowed from: &lt;a style=\'vertical-align:initial\' target=\'_self\' href=\'api/{borrowedFrom}\' &gt;{borrowedFrom}&lt;/a&gt;"></m:FormattedText></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data>/hasConstructor}"><ObjectPageSection id="constructor"\n\t\t\t\t\t\t\t\t\t\t   title="Constructor"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{/constructor/description}"/><layout:VerticalLayout visible="{= ${/constructor/examples} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   content="{path : \'/constructor/examples\', templateShareable: false}"><custom:JSDocText sanitizeContent="false" text="{data}"/></layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{/constructor/codeExample}"/><template:if test="{= !!${data>/constructor/parameters} }"><custom:LightTable rows="{path: \'/constructor/parameters\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Param,Type,Default Value,Description"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnCount="4"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentationParamsTable"><custom:Row><custom:ParamText text="{name}" phoneText="{phoneName}" depth="{depth}" optional="{optional}"/><layout:VerticalLayout content="{path: \'types\', templateShareable: false}" width="100%"><m:Link text="{name}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{name}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${linkEnabled} }"/></layout:VerticalLayout><m:Text text="{defaultValue}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${data>/constructor/throws} !== undefined}"><custom:LightTable rows="{path : \'/constructor/throws\', templateShareable: false}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Throws,Desktop"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnCount="2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentation2ColumnsEqualTable"><custom:Row><m:Link text="{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${linkEnabled} }"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data>/hasControlProperties}"><ObjectPageSection id="controlproperties"\n\t\t\t\t\t\t\t\t\t\t   title="Properties"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><m:CheckBox text="Show borrowed properties" visible="{/bHasBorrowedProps}" displayOnly="{=!${/bHasSelfProps}}" selected="{=${/bShowBorrowedProps}}" select="onBorrowedPropCheckboxClick"/><custom:LightTable rows="{path : \'/ui5-metadata/properties\'}"\n\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Name,Type,Default Value,Description"\n\t\t\t\t\t\t\t\t\t\t\tcolumnCount="4"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginTop"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Link text="{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{= ${type}.replace(\'[]\', \'\') }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${linkEnabled} }"/><m:Text text="{defaultValue}"/><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{description}"/><layout:HorizontalLayout width="100%"><m:ObjectStatus text="Visibility: {parts : [{path : \'visibility\'}, {path : \'allowedFor\'}], formatter : \'sap.ui.documentation.sdk.model.formatter.formatVisibility\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{= ${visibility} === \'public\' ? \'Success\' : \'Warning\'}"/><core:Icon\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://sys-help-2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolor="#286eb4"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentationVisibilityInformationIcon"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tpress="onVisibilityInformationClick"></core:Icon></layout:HorizontalLayout><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${deprecatedText} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{path : \'deprecatedText\', formatter: \'sap.ui.documentation.sdk.model.formatter.formatMessageStripLinks\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {experimental/since} {experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:FormattedText visible="{=${borrowedFrom} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thtmlText="Borrowed from: &lt;a style=\'vertical-align:initial\' target=\'_self\' href=\'api/{borrowedFrom}\' &gt;{borrowedFrom}&lt;/a&gt;"></m:FormattedText></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data>/hasAggregations}"><ObjectPageSection id="aggregations"\n\t\t\t\t\t\t\t\t\t\t   title="Aggregations"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><m:CheckBox text="Show borrowed aggregations" visible="{/bHasBorrowedAggr}" displayOnly="{=!${/bHasSelfAggr}}" selected="{/bShowBorrowedAggr}" select="onBorrowedAggrCheckboxClick"/><custom:LightTable rows="{path : \'/ui5-metadata/aggregations\'}"\n\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="{= ${data>/hasAggregationAltTypes} ? \'Name,Cardinality,Type,Alt types,Description\' : \'Name,Cardinality,Type,Description\'}"\n\t\t\t\t\t\t\t\t\t\t\tcolumnCount="{= ${data>/hasAggregationAltTypes} ? 5 : 4}"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginTop"><custom:Row visible="{= ${visibility} === \'public\'}"><custom:ParamText text="{name}" defaultFlag="{= ${/ui5-metadata/defaultAggregation} === ${path: \'name\'} }"/><m:Text text="{cardinality}" wrapping="false"/><m:Link text="{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${linkEnabled} }"/><template:if test="{data>/hasAggregationAltTypes}"><m:Text text="{path: \'altTypes\', formatter:\'.formatter.apiRefAggregationAltTypes\'}"/></template:if><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{description}"/><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${deprecatedText} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{path : \'deprecatedText\', formatter: \'sap.ui.documentation.sdk.model.formatter.formatMessageStripLinks\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {experimental/since} {experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${dnd/draggable} === true}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="This aggregation can be a drag source."\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Information"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom sapUiSmallMarginTop"></m:MessageStrip><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${dnd/droppable} === true}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="This aggregation can be a drop target."\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Information"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom sapUiSmallMarginTop"></m:MessageStrip><m:FormattedText visible="{=${borrowedFrom} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thtmlText="Borrowed from: &lt;a style=\'vertical-align:initial\' target=\'_self\' href=\'api/{borrowedFrom}\' &gt;{borrowedFrom}&lt;/a&gt;"></m:FormattedText></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data>/hasAssociations}"><ObjectPageSection id="associations"\n\t\t\t\t\t\t\t\t\t\t   title="Associations"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><m:CheckBox text="Show borrowed associations" visible="{/bHasBorrowedAssoc}" displayOnly="{=!${/bHasSelfAssoc}}" selected="{/bShowBorrowedAssoc}" select="onBorrowedAssocCheckboxClick"/><custom:LightTable rows="{path : \'/ui5-metadata/associations\'}"\n\t\t\t\t\t\t\t\t\t\t\tcolumnCount="4"\n\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Name,Cardinality,Type,Description"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginTop"><custom:Row visible="{visibility === \'public\'}"><custom:ParamText class="sapUiDocumentationParamBold" text="{name}" /><m:Text text="{cardinality}" wrapping="false"/><m:Link text="{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${linkEnabled} }"/><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{description}"/><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${deprecated} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Deprecated as of version {deprecated/since}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {experimental/since} {experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip><m:FormattedText visible="{=${borrowedFrom} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thtmlText="Borrowed from: &lt;a style=\'vertical-align:initial\' target=\'_self\' href=\'api/{borrowedFrom}\' &gt;{borrowedFrom}&lt;/a&gt;"></m:FormattedText></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data>/hasEvents}"><ObjectPageSection id="events"\n\t\t\t\t\t\t\t\t\t\t   title="Events"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection title="{= ${data>/hasEvents} &amp;&amp; !${data>/hasOwnEvents} ? \'Events\' : \'Summary\'}"><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{data>/hasOwnEvents}"><custom:LightTable columnCount="2" columnTitles="Event,Description"><template:repeat list="{data>/events}" var="event"><custom:Row><custom:ParamText text="{event>name}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{data>/name}#events/{event>name}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tdeprecated="{= ${event>deprecated} !== undefined }"/><custom:JSDocText sanitizeContent="false" text="{path: \'event>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${data>/borrowed/events/}.length > 0 }"><m:Title text="Borrowed from:" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle"/><layout:VerticalLayout width="100%" content="{path: \'/borrowed/events/\', templateShareable: false}"><m:Panel class="borrowedListPanel"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\texpandable="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\texpanded="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\theaderText="{name}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twidth="100%"><custom:BorrowedList list="{events}"/></m:Panel></layout:VerticalLayout></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data>/events}" var="event"><custom:ObjectPageSubSection title="{event>name}"><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{path: \'event>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><layout:HorizontalLayout width="100%"><m:ObjectStatus text="Visibility: {parts : [{path : \'event>visibility\'}, {path : \'event>allowedFor\'}], formatter : \'sap.ui.documentation.sdk.model.formatter.formatVisibility\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{= ${event>visibility} === \'public\' ? \'Success\' : \'Warning\'}" class="sapUiSmallMarginBottom"/><core:Icon\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://sys-help-2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolor="#286eb4"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentationVisibilityInformationIcon"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tpress="onVisibilityInformationClick"></core:Icon></layout:HorizontalLayout><template:if test="{=${event>deprecated} !== undefined}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{path : \'event>deprecatedText\', formatter: \'sap.ui.documentation.sdk.model.formatter.formatMessageStripLinks\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"></m:MessageStrip></template:if><template:if test="{=${event>experimental} !== undefined}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {event>experimental/since} {event>experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"></m:MessageStrip></template:if><template:if test="{= !!${event>parameters} &amp;&amp; ${event>parameters}.length > 0}"><custom:LightTable columnTitles="Param,Type,Description" columnCount="3"><template:repeat list="{event>parameters}" var="parameter"><custom:Row><custom:ParamText text="{parameter>name}" phoneText="{parameter>phoneName}" depth="{parameter>depth}" optional="{parameter>optional}"/><m:Link text="{parameter>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{parameter>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${parameter>linkEnabled} }"/><layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{path: \'parameter>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${parameter>deprecated} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{path : \'parameter>deprecatedText\', formatter: \'sap.ui.documentation.sdk.model.formatter.formatMessageStripLinks\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop"></m:MessageStrip></layout:VerticalLayout></custom:Row></template:repeat></custom:LightTable></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><template:if test="{data>/hasMethods}"><ObjectPageSection id="methods"\n\t\t\t\t\t\t\t\t\t   title="Methods"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false"\n\t\t\t\t\t\t\t\t\t   class="APIDetailMethodsSection"><subSections><custom:ObjectPageSubSection title="{= ${data>/hasMethods} &amp;&amp; !${data>/hasOwnMethods} ? \'Methods\' : \'Summary\'}"><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{data>/hasOwnMethods}"><custom:LightTable columnCount="2" columnTitles="Method,Description"><template:repeat list="{data>/methods}" var="method"><custom:Row><custom:ParamText text="{method>name}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="{method>href}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tdeprecated="{= ${method>deprecated} !== undefined }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t        experimental="{= ${method>experimental} !== undefined }"/><custom:JSDocText sanitizeContent="false" text="{path: \'method>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${data>/borrowed/methods/}.length > 0 }"><m:Title text="Borrowed from:" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle"/><layout:VerticalLayout width="100%" content="{path: \'/borrowed/methods/\', templateShareable: false}"><m:Panel class="borrowedListPanel"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\texpandable="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\texpanded="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\theaderText="{name}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twidth="100%"><custom:BorrowedList list="{methods}"/></m:Panel></layout:VerticalLayout></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data>/methods}" var="method"><custom:ObjectPageSubSection title="{method>name}" id="{method>placeholderId}"><custom:blocks><ObjectPageLazyLoader stashed="true" id="{method>subPlaceholderId}"><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{path: \'method>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><layout:VerticalLayout visible="{= ${method>examples} !== undefined}" width="100%"><template:repeat list="{method>examples}" var="example"><custom:JSDocText sanitizeContent="false" text="{path: \'example>data\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></template:repeat></layout:VerticalLayout><m:FlexBox class="sapUiTinyMarginBottom"><layout:HorizontalLayout width="100%"><m:ObjectStatus text="Visibility: {parts : [{path : \'method>visibility\'}, {path : \'method>allowedFor\'}], formatter : \'sap.ui.documentation.sdk.model.formatter.formatVisibility\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{= ${method>visibility} === \'public\' ? \'Success\' : \'Warning\'}"/><core:Icon\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://sys-help-2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolor="#286eb4"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentationVisibilityInformationIcon sapUiTinyMarginEnd"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tpress="onVisibilityInformationClick"></core:Icon><m:ObjectStatus visible="{=${method>since} !== undefined}" text="Since: {method>since}"/></layout:HorizontalLayout></m:FlexBox><template:if test="{=${method>deprecatedText} !== undefined}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{ path: \'method>deprecatedText\', formatter: \'sap.ui.documentation.sdk.model.formatter.formatMessageStripLinks\' }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"></m:MessageStrip></template:if><template:if test="{=${method>experimental} !== undefined}"><m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {method>experimental/since} {method>experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"></m:MessageStrip></template:if><custom:JSDocText text="{path: \'method>code\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}" /><template:if test="{= !!${method>parameters} &amp;&amp; ${method>parameters}.length > 0}"><custom:LightTable\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnCount="4"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Param,Type,Default Value,Description"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentationParamsTable"><template:repeat list="{method>parameters}" var="parameter"><custom:Row><custom:ParamText text="{parameter>name}" phoneText="{parameter>phoneName}" depth="{parameter>depth}" optional="{parameter>optional}"/><layout:VerticalLayout class="sapUiDocumentationOrList" width="100%"><template:repeat list="{parameter>types}" var="type"><template:if test="{= !!${type>linkEnabled} }"><template:then><m:Link text="{path: \'type>value\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="{type>href}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="true"/></template:then><template:else><m:Link text="{path: \'type>value\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}" enabled="false"/></template:else></template:if></template:repeat></layout:VerticalLayout><m:Text text="{parameter>defaultValue}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{path: \'parameter>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${method>returnValue} !== undefined}"><custom:LightTable columnCount="2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Returns,Description"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentation2ColumnsEqualTable"><custom:Row><layout:VerticalLayout class="sapUiDocumentationOrList" width="100%"><template:repeat list="{method>returnValue/types}" var="rtype"><m:Link text="{path: \'rtype>value\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="{rtype>href}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${rtype>linkEnabled} }"/></template:repeat></layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{path: \'method>returnValue/description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${method>throws} !== undefined}"><custom:LightTable\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Throws,Description"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tcolumnCount="2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiDocumentation2ColumnsEqualTable"><template:repeat list="{method>throws}" var="throws"><custom:Row><m:Link text="{throws>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{throws>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${throws>linkEnabled} }"/><custom:JSDocText sanitizeContent="false" text="{path: \'throws>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if></layout:VerticalLayout></ObjectPageLazyLoader></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><template:if test="{data>/hasSpecialSettings}"><ObjectPageSection id="specialsettings"\n\t\t\t\t\t\t\t\t\t\t   title="Special Settings"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path : \'/ui5-metadata/specialSettings\'}"\n\t\t\t\t\t\t\t\t\t\t\tcolumnCount="3"\n\t\t\t\t\t\t\t\t\t\t\tcolumnTitles="Name,Type,Description"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginTop sapUiDocumentationSpecialSettingsTable"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Link text="{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="api/{type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{= !!${linkEnabled} }"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data>/hasAnnotations}"><ObjectPageSection id="annotations"\n\t\t\t\t\t\t\t\t\t\t   title="Annotations"\n\t\t\t\t\t\t\t\t\t\t   titleUppercase="false"><subSections><custom:ObjectPageSubSection title="Summary"><custom:blocks><custom:LightTable columnCount="2" columnTitles="Annotation,Description"><template:repeat list="{data>/ui5-metadata/annotations}" var="annotation"><custom:Row><m:Link text="{= ${annotation>annotation} !== \'undefined\' ? ${annotation>annotation} : \'(\' + ${annotation>namespaceText} + \')\' }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twrapping="false"/><custom:JSDocText sanitizeContent="false" text="{path: \'annotation>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data>/ui5-metadata/annotations}" var="annotation"><custom:ObjectPageSubSection title="{= ${annotation>annotation} !== \'undefined\' ? ${annotation>annotation} : \'(\' + ${annotation>namespaceText} + \')\' }"><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{path: \'annotation>description\', formatter: \'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><custom:LightTable columnTitles="Namespace,Target Type,Applies To" columnCount="3"><custom:Row><custom:JSDocText sanitizeContent="false" text="{annotation>namespace}"/><custom:JSDocText sanitizeContent="false" text="{annotation>target}"/><custom:JSDocText sanitizeContent="false" text="{annotation>appliesTo}"/></custom:Row></custom:LightTable></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><template:if test="{data>/hasFAQ}"><ObjectPageSection id="faq" title="FAQ" class="faqContent"><subSections><custom:ObjectPageSubSection><custom:blocks><core:HTML id="parserId" content="{/faqContent}"/></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><core:ExtensionPoint name="customSections" /></sections></ObjectPageLayout></m:content></m:Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/SurveyPopover.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"><ResponsivePopover\n\t\tid="surveyPopover"\n\t\tplacement="Bottom"\n\t\tcontentWidth="24rem"\n\t\tshowHeader="false"><Title\n\t\t\ttext="{i18n>SURVEY_POPOVER_TITLE}"\n\t\t\tlevel="H5"\n\t\t\tclass="surveyPopoverTitle" /><VBox class="sapUiSmallMarginTopBottom surveyPopoverCustomPaddingBeginEnd" tooltip="{i18n>SURVEY_POPOVER_LONG_SURVEY_TITLE}"><items><VBox class="sapUiSmallMarginBottom"><items><HBox><items><Title\n\t\t\t\t\t\t\t\t\ttext="{i18n>SURVEY_POPOVER_LONG_SURVEY_TITLE}"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginEnd"\n\t\t\t\t\t\t\t\t\tlevel="H6" /><ObjectStatus\n\t\t\t\t\t\t\t\t\tclass="longSurveyBadge"\n\t\t\t\t\t\t\t\t\ttext="{i18n>SURVEY_POPOVER_LONG_SURVEY_BADGE}"\n\t\t\t\t\t\t\t\t\tstate="Information" inverted="true" /></items></HBox><Text\n\t\t\t\t\t\t\tclass="longSurveyAvailability"\n\t\t\t\t\t\t\ttext="{i18n>SURVEY_POPOVER_LONG_SURVEY_AVAILABILITY} {appView>/sLongSurveyLastDate}" /></items></VBox><Text\n\t\t\t\t\ttext="{i18n>SURVEY_POPOVER_LONG_SURVEY_DESC}"\n\t\t\t\t\tclass="surveyDescription sapUiSmallMarginBottom" /><Button\n\t\t\t\t\ttext="{i18n>SURVEY_POPOVER_LONG_SURVEY_BTN}"\n\t\t\t\t\ttooltip="{i18n>SURVEY_POPOVER_LONG_SURVEY_BTN_TOOLTIP}"\n\t\t\t\t\ticon="sap-icon://generate-shortcut"\n\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\tpress=".longSurveyRedirect" /></items></VBox><VBox\n\t\t\tclass="surveyPopoverCustomStylesTop surveyPopoverCustomPaddingBeginEnd surveyPopoverCustomPaddingBottom"\n\t\t\ttooltip="{i18n>SURVEY_POPOVER_DEFAULT_SURVEY_TITLE}"><items><Title text="{i18n>SURVEY_POPOVER_DEFAULT_SURVEY_TITLE}" level="H6" class="surveyTitle sapUiSmallMarginBottom" /><Text text="{i18n>SURVEY_POPOVER_DEFAULT_SURVEY_DESC}" class="surveyDescription sapUiSmallMarginBottom" /><Button text="{i18n>SURVEY_POPOVER_DEFAULT_SURVEY_BTN}" width="100%" press=".shortSurveyRedirect" /></items></VBox></ResponsivePopover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/TermsOfUse.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.TermsOfUse"\n          height="100%"\n          xmlns:mvc="sap.ui.core.mvc"\n          xmlns="sap.m"><Page showHeader="false"\n          showSubHeader="false"><Text id="termsOfUseText"\n              renderWhitespace="true"\n              class="sapUiTinyMarginBegin"/></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/Tools.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Tools"\n\t\txmlns="sap.m"\n\t\txmlns:f="sap.f"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"><Page showHeader="false"\n\t\t  class="sapUiNoContentPadding sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo\n\t\t\t\tcontentRole="Main"\n\t\t\t\tcontentLabel="Tools"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell toolsImageCell"><Image\n\t\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Tools_S_cropped.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{device>/system/phone}"/><Image\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Tools_M_and_L_cropped.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/><Text id="landingImageHeadline"\n\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\tclass="sapUiDocumentationToolsHeaderText"\n\t\t\t\t\t\t\ttext="Tools"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttextAlign="Left"/></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:Grid defaultSpan="XL3 L4 M4 S12" class="toolpageResponsiveMargins"><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/uiThemeDesigner/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/uiThemeDesigner/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\twrapping="true"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_2_TEXT}" /><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\thref="https://help.sap.com/viewer/09f6818d8e064537973102d6289e2aca/Cloud/en-US"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/ThemeDesigner.jpg" class="toolsPageImage" alt="{i18n>TOOLS_CARD_2_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/fioriTools/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/fioriTools/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_12_TEXT}" /><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\thref="https://help.sap.com/viewer/17d50220bcd848aa854c9c182d65b699/Latest/en-US"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/FioriTools.png" class="toolsPageImage" alt="{i18n>TOOLS_CARD_12_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/businessApplicationStudio/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/businessApplicationStudio/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_9_TEXT}" /><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\t\thref="https://help.sap.com/viewer/product/SAP%20Business%20Application%20Studio/Cloud/en-US"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/BusinessApplicationStudio.jpg" class="toolsPageImage" alt="{i18n>TOOLS_CARD_9_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/ui5Tooling/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/ui5Tooling/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_3_TEXT}" /><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd"><Link text="{i18n>TOOLS_CARD_3_LINK_1}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\thref="https://github.com/SAP/ui5-tooling#ui5-build-and-development-tooling"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><html:div class="sapUIDisclaimerLink"><Link text="{i18n>TOOLS_CARD_3_LINK_2}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\thref="https://github.com/SAP/ui5-cli#cli-usage"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/UI5EvoTooling.jpg" class="toolsPageImage"  alt="{i18n>TOOLS_CARD_3_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/ui5Inspector/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/ui5Inspector/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_4_TEXT}" /><HBox wrap="Wrap"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t\tclass="sapUiMediumMarginEnd"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\thref="{newWindowLinks>/inspectorHomeLink}"/><html:div class="sapUIDisclaimerLink"><Link text="{i18n>TOOLS_CARD_4_LINK_1}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\thref="https://github.com/SAP/ui5-inspector"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/UI5Inspector.jpg" class="toolsPageImage"  alt="{i18n>TOOLS_CARD_4_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="{/cardExplorer/text}"\n\t\t\t\t\t\t\t\t\thref="{/cardExplorer/href}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_5_TEXT}" /><HBox wrap="Wrap"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t      target="_blank"\n\t\t\t\t\t\t\t\t      href="test-resources/sap/ui/integration/demokit/cardExplorer/webapp/index.html"\n\t\t\t\t\t\t\t\t      class="sapUiMediumMarginEnd"/><Link text="{i18n>TOOLS_CARD_5_LINK_1}"\n\t\t\t\t\t\t\t\t      target="_blank"\n\t\t\t\t\t\t\t\t      href="test-resources/sap/ui/integration/demokit/cardExplorer/webapp/index.html#/explore/list"/></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/CardExplorer.jpg" class="toolsPageImage"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="{/supportAssistant/text}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\t\thref="{newWindowLinks>/supportAssistantHomeLink}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"/><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_6_TEXT}" /><HBox wrap="Wrap"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\thref="{newWindowLinks>/supportAssistantHomeLink}"/></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/SupportAssistant.jpg" class="toolsPageImage"  alt="{i18n>TOOLS_CARD_6_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="{/iconExplorer/text}"\n\t\t\t\t\t\t\t\thref="{/iconExplorer/href}"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_7_TEXT}" /><HBox wrap="Wrap"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\thref="{newWindowLinks>/iconExplorerHomeLink}"\n\t\t\t\t\t\t\t\t\tclass="sapUiMediumMarginEnd"/><Link text="{i18n>TOOLS_CARD_7_LINK_1}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\thref="test-resources/sap/m/demokit/iconExplorer/webapp/test/integration/opaTests1.qunit.html"\n\t\t\t\t\t\t\t\t\tclass="sapUiMediumMarginEnd"/><Link text="{i18n>TOOLS_CARD_7_LINK_2}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\thref="test-resources/sap/m/demokit/iconExplorer/webapp/test/unit/unitTests.qunit.html"/></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/IconExplorer.jpg" class="toolsPageImage"  alt="{i18n>TOOLS_CARD_7_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="{/themeParameterToolbox/text}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\t\thref="{/themeParameterToolbox/href}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"/><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_8_TEXT}" /></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/ThemeParameterToolbox.jpg" class="toolsPageImage" alt="{i18n>TOOLS_CARD_8_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/ui5WebComponents/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/ui5WebComponents/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_10_TEXT}" /><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd"><Link text="{i18n>TOOLS_CARD_10_LINK_1}"\n\t\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\t\thref="https://sap.github.io/ui5-webcomponents/playground"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><html:div class="sapUIDisclaimerLink"><Link text="{i18n>TOOLS_CARD_10_LINK_2}"\n\t\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\t\thref="https://github.com/SAP/ui5-webcomponents"/><Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/UI5WebComponents.jpg" class="toolsPageImage" alt="{i18n>TOOLS_CARD_10_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"\n\t\t\t\tvisible="{\n\t\t\t\t\tpath: \'/liveEditor\',\n\t\t\t\t\tformatter: \'.formatter.formatToolCardVisibility\'}"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/liveEditor/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/liveEditor/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_13_TEXT}" /></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/Tools_LiveEditor.jpg" class="toolsPageImage" alt="{i18n>TOOLS_CARD_13_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"\n\t\t\t\tvisible="{\n\t\t\t\t\t\tpath: \'/flexibleProgrammingModelExplorer\',\n\t\t\t\t\t\tformatter: \'.formatter.formatToolCardVisibility\'}"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/flexibleProgrammingModelExplorer/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/flexibleProgrammingModelExplorer/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_14_TEXT}" /></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/FlexibleProgrammingModelExplorer.jpg" class="toolsPageImage" alt="{i18n>TOOLS_CARD_14_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"\n\t\t\t\tvisible="{\n\t\t\t\t\t\t\tpath: \'/accessibilityGuide\',\n\t\t\t\t\t\t\tformatter: \'.formatter.formatToolCardVisibility\'}"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="{/accessibilityGuide/text}"\n\t\t\t\t\t\t\t\t\t\thref="{/accessibilityGuide/href}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/></html:div><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_15_TEXT}" /></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/AccessibilityGuide.png" class="toolsPageImage" alt="{i18n>TOOLS_CARD_15_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"\n\t\t\t\tvisible="{\n\t\t\t\t\t\t\tpath: \'/ui5TestRecorder\',\n\t\t\t\t\t\t\tformatter: \'.formatter.formatToolCardVisibility\'}"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="{/ui5TestRecorder/text}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\t\thref="{newWindowLinks>/ui5TestRecorderHomeLink}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"/><Text class="sapUiSmallMarginBottom" text="{i18n>TOOLS_CARD_16_TEXT}" /><HBox wrap="Wrap"><Link text="{i18n>TOOLS_VIEW_DOC}"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\thref="{newWindowLinks>/ui5TestRecorderHomeLink}"/></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/UI5TestRecorder.png" class="toolsPageImage"  alt="{i18n>TOOLS_CARD_16_IMG_ALT}"/></VBox></f:content></f:Card></l:Grid><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" /></Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/TopicDetail.view.xml":'<mvc:View\n\t\theight="100%"\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.TopicDetail"\n\t\txmlns="sap.f"\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"><DynamicPage\n\t\t\tid="topicDetailPage"\n\t\t\tpreserveHeaderStateOnScroll="true"\n\t\t\ttoggleHeaderOnTitleClick="{=${/bIsPhone} ? true : false}"\n\t\t\tfitContent="true"><title><DynamicPageTitle class="sapUiDocumentationDynamicPageTitle"><heading><m:Text text="{/topictitle1}" class="sapUiDocumentationTopicTitle" wrapping="true"/></heading><actions><m:Button\n\t\t\t\t\t\t\tid="topicDetailBackToSearch"\n\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_BACK_BTN}"\n\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\tpress="backToSearch"\n\t\t\t\t\t\t\tvisible="false"/><m:Button\n\t\t\t\t\t\t\tvisible="{= !${versionData>/isURLVersioned}}"\n\t\t\t\t\t\t\ticon="sap-icon://edit"\n\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_EDIT_GITHUB}"\n\t\t\t\t\t\t\ttooltip="{i18n>TOPIC_DETAIL_EDIT_GITHUB_TOOLTIP}"\n\t\t\t\t\t\t\tpress="onEditGitHubPress"/><m:Button\n\t\t\t\t\t\t\tvisible="{device>/system/desktop}"\n\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\ttooltip="{i18n>TOPIC_DETAIL_FULLSCREEN_TOOLTIP}"\n\t\t\t\t\t\t\tpress="onToggleFullScreen"/></actions></DynamicPageTitle></title><header><DynamicPageHeader pinnable="false"><content><m:FormattedText htmlText="{/shortdesc}" class="sapUiDocumentationTopicSubtitle"></m:FormattedText></content></DynamicPageHeader></header><content><l:HorizontalLayout id="staticContentLayout" class="topicWrapper"><core:HTML id="staticContent" preferDOM="false"/></l:HorizontalLayout></content></DynamicPage></mvc:View>\n',
	"sap/ui/documentation/sdk/view/TopicDetailInitial.view.xml":'<mvc:View\n\t\theight="100%"\n\t\twidth="100%"\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.TopicDetailInitial"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation"><Page id="topicDetailPage"\n\t\t  showHeader="false"\n\t\t  class="sapUiNoContentPadding sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo\n\t\t\t\tcontentRole="Main"\n\t\t\t\tcontentLabel="Documentation"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image\n\t\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Docu_S_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{device>/system/phone}"/><Image\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Docu_M_and_L_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/><l:VerticalLayout\n\t\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\t\tclass="sapUiDocumentationDocumentationHeading"\n\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\twidth="100%"><Text\n\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_DOCUMENTATION}"\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttextAlign="Left"/><l:HorizontalLayout><Button\n\t\t\t\t\t\t\t\t\t\tclass="actionButton"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_DOWNLOAD_BTN}"\n\t\t\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\t\t\tpress="onDownloadButtonPress"/><Button\n\t\t\t\t\t\t\t\t\t\tclass="actionButton sapUiSmallMarginBegin"\n\t\t\t\t\t\t\t\t\t\tvisible="{= ${versionData>/isOpenUI5}}"\n\t\t\t\t\t\t\t\t\t\ttext="GitHub"\n\t\t\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\t\t\tpress="onGitHubButtonPress"/></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow id="disclaimerBlock" visible="false"><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet9"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><MessageStrip\n\t\t\t\t\t\t\tid="disclaimerMessage"\n\t\t\t\t\t\t\tshowIcon="true"/></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow class="sapUiContentPadding"><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_1_TITLE}"\n\t\t\t\t\t\t\t\thref="topic/99ac68a5b1c3416ab5c84c99fefa250d"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_1_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_2_TITLE}"\n\t\t\t\t\t\t\t\thref="topic/167193ced54c41c3961d7df3479d7bbe"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_2_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\twidth="2"\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_3_TITLE}"\n\t\t\t\t\t\t\t\t\thref="topic/8b49fc198bf04b2d9800fc37fecbb218"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text text="{i18n>TOPIC_DETAIL_INIT_BLOCK_3_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\twidth="2"\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_4_TITLE}"\n\t\t\t\t\t\t\t\t\thref="topic/23cfd955f58142389fa7c9097e11559c"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text text="{i18n>TOPIC_DETAIL_INIT_BLOCK_4_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_5_TITLE}"\n\t\t\t\t\t\t\t\t\thref="topic/a264a9abf98d4caabbf9b027bc1005d8"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_5_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_6_TITLE}"\n\t\t\t\t\t\t\t\t\thref="topic/8dcab0011d274051808f959800cabf9f"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_6_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternA"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet9"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"\n\t\t\t\t\t\t\tvisible="{=!${versionData>/isOpenUI5}}"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="SAP Fiori Elements"\n\t\t\t\t\t\t\t\t\thref="topic/03265b0408e2432c9571d6b3feb6b1fd"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_7_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternC"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"\n\t\t\t\t\t\t\tvisible="{=!${versionData>/isOpenUI5}}"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_8_TITLE}"\n\t\t\t\t\t\t\t\t\thref="topic/1c457c53595a6655e10000000a423f68"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_8_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_9_TITLE}"\n\t\t\t\t\t\t\t\t\thref="topic/ec699e0817fb46a0817b0fa276a249f8"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text text="{i18n>TOPIC_DETAIL_INIT_BLOCK_9_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_10_TITLE}"\n\t\t\t\t\t\t\t\t\thref="topic/3ec6808ff0f34a75a9f40748cf9989b9"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>TOPIC_DETAIL_INIT_BLOCK_10_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" /></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/TopicMaster.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.TopicMaster"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:l="sap.ui.layout"\n        xmlns:custom="sap.ui.documentation"\n\t\tclass="sapContrast sapContrastPlus"><Page\n\t\t\tid="page"\n\t\t\tenableScrolling="true"\n\t\t\tshowFooter="false"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowNavButton="false"\n\t\t\tclass="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="{i18n>TOPIC_MASTER_FILTER_PLACEHOLDER}" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"/><Button icon="sap-icon://expand-all" press="onTreeExpandAll" tooltip="{i18n>TOPIC_MASTER_EXPAND_TOOLTIP}"/><Button icon="sap-icon://collapse-all" press="onTreeCollapseAll" tooltip="{i18n>TOPIC_MASTER_COLAPSE_TOOLTIP}"/></Toolbar></customHeader><content><l:FixFlex fixFirst="false"><l:flexContent><Tree\n\t\t\t\t\t\tid="tree"\n\t\t\t\t\t\tmode="SingleSelectMaster"\n\t\t\t\t\t\tselectionChange="onNodeSelect"\n\t\t\t\t\t\tnoDataText="{i18n>TOPIC_MASTER_NO_DATA_TEXT}"\n\t\t\t\t\t\titems="{ path: \'/\' }"><custom:DemokitTreeItem\n\t\t\t\t\t\t\t\ttitle="{text}"\n\t\t\t\t\t\t\t\ttarget="{key}"\n\t\t\t\t\t\t\t\tsection="topic"\n\t\t\t\t\t\t\t\tselected="{isSelected}"/></Tree></l:flexContent><l:fixContent><core:Fragment fragmentName="sap.ui.documentation.sdk.view.FooterMaster" type="XML" /></l:fixContent></l:FixFlex></content></Page></mvc:View>\n',
	"sap/ui/documentation/sdk/view/VersionInfo.view.xml":'<mvc:View\n\t\theight="100%"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"><core:HTML id="testHTML"\n\t\t\t   preferDOM="false"\n\t\t\t   content=\'&lt;div style="height:100%; overflow-x:auto;"&gt;&lt;iframe style="width:100%;height:99%;" name="content" src="versioninfo.html" frameborder="0""&gt;&lt;/iframe&gt;&lt;/div&gt;\'></core:HTML></mvc:View>',
	"sap/ui/documentation/sdk/view/VersionNotFound.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.VersionNotFound"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:f="sap.f"\n\t\txmlns="sap.m"><App><Page><customHeader><f:ShellBar\n\t\t\t\t\ttitle="HTTP Status 404 - Not Found"\n\t\t\t\t\thomeIcon="/resources/sap/ui/documentation/sdk/images/logo_ui5.png"\n\t\t\t\t\thomeIconPressed="onHomePress"\n\t\t\t\t></f:ShellBar></customHeader><MessagePage\n\t\t\t\t\tid="page"\n\t\t\t\t\ticon="sap-icon://document"\n\t\t\t\t\tdescription=""\n\t\t\t\t\tshowHeader="false"\n\t\t\t\t\ttext=""\n\t\t\t\t\tbusy="true"\n\t\t\t\t\t><buttons><Button\n\t\t\t\t\t\t\t\tid="readMoreButton"\n\t\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\t\ttext="Read More"\n\t\t\t\t\t\t\t\tpress="onReadMore"\n\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\twidth="100%" /><Button\n\t\t\t\t\t\t\t\tid="homePageButton"\n\t\t\t\t\t\t\t\tvisible="true"\n\t\t\t\t\t\t\t\ttext="Home Page"\n\t\t\t\t\t\t\t\tpress="onHomePress"\n\t\t\t\t\t\t\t\twidth="100%" /></buttons></MessagePage></Page></App></mvc:View>\n',
	"sap/ui/documentation/sdk/view/VisibilityInformation.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:layout="sap.ui.layout"><Popover\n\t\tid="visibilityInformationPopover"\n\t\tplacement="Right"\n\t\tshowHeader="false"><FormattedText class="sapUiDocumentationVisibilityInformationText"\n\t\t\thtmlText="For more information about different API types click &lt;a href=\'topic/b0d5fe2f1b0b497cbd67cd5a1d35fa4c\'&gt;here&lt;/a&gt;" /></Popover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Welcome.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Welcome"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:custom="sap.ui.documentation"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"><Page showHeader="false" class="sapUiHomePage"><landmarkInfo><PageAccessibleLandmarkInfo\n\t\t\t\tcontentRole="Main"\n\t\t\t\tcontentLabel="Get Started with UI5"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell welcomeImageCell"><Image\n\t\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Home_S_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{device>/system/phone}"/><Image\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Home_M_and_L_cropped_1.jpg"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/><l:VerticalLayout\n\t\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tclass="welcomeImageTextLayout"><Text class="welcomeImageTextHeadline"\n\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_1_TEXT_1}"\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttextAlign="Center"/><l:HorizontalLayout><Button\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_1_START_BTN}"\n\t\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\t\tpress="onGetStarted"\n\t\t\t\t\t\t\t\t\tclass="actionButton"/><Button\n\t\t\t\t\t\t\t\t\tclass="actionButton sapContrast sapContrastPlus sapUiSmallMarginBegin"\n\t\t\t\t\t\t\t\t\tvisible="{=${welcomeView>/isOpenUI5} !== undefined}"\n\t\t\t\t\t\t\t\t\tid="readMoreButton"\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_1_DOWNLOAD_BTN}"\n\t\t\t\t\t\t\t\t\tpress="onDownloadButtonPress"></Button></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel\taccessibleRole="Region"\n\t\t\t\tbackgroundDesign="Transparent"\n\t\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="{i18n>WELCOME_KEY_FEATURES}"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:Grid\n\t\t\t\t\t\t\t\tdefaultSpan="L6 M12 S12"\n\t\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\t\tvSpacing="0"><l:VerticalLayout\n\t\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\thref="topic/50eadaac8d2e49ee8996dc2b560cb76b"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_2_TITLE}"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Text text="{i18n>WELCOME_BLOCK_2_TEXT}"/></l:VerticalLayout><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Fiori_guidelines_image.png"\n\t\t\t\t\t\t\t\t\talt="{i18n>WELCOME_BLOCK_2_IMG_ALT}"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\twidth="100%"><layoutData><l:GridData span="L6 M12 S12"/></layoutData></Image></l:Grid></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_3_TITLE}"\n\t\t\t\t\t\t\t\thref="topic/23cfd955f58142389fa7c9097e11559c"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_3_TEXT_1}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_3_TEXT_2}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_3_TEXT_3}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_3_TEXT_4}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_3_TEXT_5}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_3_TEXT_6}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_3_TEXT_7}"/></HBox></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow visible="{= ${versionData>/isOpenUI5}}"><core:Fragment fragmentName="sap.ui.documentation.sdk.view.WelcomeCustomRowOpenUI5" type="XML" /></l:BlockLayoutRow><l:BlockLayoutRow visible="{= !${versionData>/isOpenUI5}}"><core:Fragment fragmentName="sap.ui.documentation.sdk.view.WelcomeCustomRowSAPUI5" type="XML" /></l:BlockLayoutRow></l:BlockLayout></Panel><Panel visible="{=! (${device>/system/phone} || ${device>/browser/msie}) }"\n\t\t\taccessibleRole="Region"\n\t\t\tbackgroundDesign="Transparent"\n\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="{i18n>WELCOME_START_CODING}"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\t\t\t   backgroundColorShade="ShadeA"><l:layoutData><l:BlockLayoutCellData sSize="1" mSize="2" lSize="3" xlSize="3"/></l:layoutData><HBox alignItems="Center" justifyContent="Center" width="100%" height="100%"><Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Home_laptop.png"\n\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBeginEnd"\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\talt="{i18n>WELCOME_BLOCK_7_ALT}"><layoutData><FlexItemData maxWidth="37.5rem" /></layoutData></Image></HBox></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\tclass="welcomeBlock"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:layoutData><l:BlockLayoutCellData sSize="1" mSize="2" lSize="3" xlSize="3"/></l:layoutData><HBox direction="Column" justifyContent="Center" width="100%" height="100%"><custom:TitleLink\n\t\t\t\t\t\t\thref="topic/8b49fc198bf04b2d9800fc37fecbb218"\n\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_6_TITLE}"\n\t\t\t\t\t\t\ttitleStyle="H2"/><Text class="sapUiMediumMarginTop" text="{i18n>WELCOME_BLOCK_6_TEXT_1}"/><HBox width="100%"><Text class="sapUiSmallMarginTop" text="{i18n>WELCOME_BLOCK_6_TEXT_2}"/><Link class="liveEditorLink sapUiSmallMarginTop" text="Live Editor" href="liveEditor" /></HBox></HBox></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel\taccessibleRole="Region"\n\t\t\tbackgroundDesign="Transparent"\n\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_7_TITLE}"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="topic/28fcd55b04654977b63dacbee0552712"\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_7_TITLE}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_7_TEXT_1}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Text text="{i18n>WELCOME_BLOCK_7_TEXT_2}" /></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><HBox alignItems="Center" justifyContent="Center" width="100%" height="100%"><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Evolution_demokit_illustration_single.png"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBeginEnd"\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\talt="{i18n>WELCOME_BLOCK_7_ALT}"><layoutData><FlexItemData maxWidth="37.5rem" /></layoutData></Image></HBox></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel\taccessibleRole="Region"\n\t\t\tbackgroundDesign="Transparent"\n\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="{i18n>WELCOME_CHOOSE_SCENARIO}"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\thref="https://www.sap.com/developer/tutorials/hcp-create-trial-account.html"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_8_TITLE}"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"/><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_8_TEXT_1}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_8_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_8_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\thref="https://ui5.sap.com/#/topic/91f346786f4d1014b6dd926db0e91070"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_9_TITLE}"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_9_TEXT_1}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_9_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_9_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\t\t\t\t\thref="http://openui5.org"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_10_TITLE}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H2"/><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_10_TEXT_1}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_10_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_10_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="topic/2d3eb2f322ea4a82983c1c62a33ec4ae"\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_11_TITLE}"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><Text\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_11_TEXT_1}"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/><HBox><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_11_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_11_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel\taccessibleRole="Region"\n\t\t\tbackgroundDesign="Transparent"\n\t\t\tclass="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%"\n\t\t\t\t\t\ttext="{i18n>WELCOME_JOIN_COMMUNITY}"\n\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\tclass="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="sapUiBlockCenteredCell communityLinkCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:HorizontalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://collaborate"\n\t\t\t\t\t\t\t\t\tsize="2.5rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="https://community.sap.com/topics/ui5"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_12_TITLE}"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\tclass="sapUiDisclaimerCommunityLink"\n\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="sapUiBlockCenteredCell communityLinkCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:HorizontalLayout><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_stackoverflow.png"\n\t\t\t\t\t\t\t\t\twidth="2.5rem"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="http://stackoverflow.com/search?q=sapui5"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\ttext="StackOverflow"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\tclass="sapUiDisclaimerCommunityLink"\n\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\t\tclass="sapUiBlockCenteredCell communityLinkCell"\n\t\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\t\tbackgroundColorShade="ShadeA"><l:HorizontalLayout><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_youtube.png"\n\t\t\t\t\t\t\t\t\twidth="2.5rem"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="https://youtube.com/openui5videos"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\ttext="YouTube"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\tclass="sapUiDisclaimerCommunityLink"\n\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiBlockCenteredCell communityLinkCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\tbackgroundColorShade="ShadeC"><l:HorizontalLayout><Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_twitter.png"\n\t\t\t\t\t\t\t\t\twidth="2.5rem"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="https://twitter.com/@openui5"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\ttext="Twitter"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-external.png"\n\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\tclass="sapUiDisclaimerCommunityLink"\n\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiBlockCenteredCell communityLinkCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\t\t\t\tbackgroundColorShade="ShadeB"><l:HorizontalLayout><core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://email"\n\t\t\t\t\t\t\t\t\tsize="2.5rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"/><custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="https://listserv.sap.com/mailman/listinfo/ui5.announce"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_13_TITLE}"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}"\n\t\t\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\t\t\tclass="sapUiDisclaimerCommunityLink"\n\t\t\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" /></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/WelcomeCustomRowOpenUI5.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:custom="sap.ui.documentation"\n\txmlns:html="http://www.w3.org/1999/xhtml"\n\txmlns:l="sap.ui.layout"><l:BlockLayoutCell\n\t\tbackgroundColorSet="ColorSet10"\n\t\tbackgroundColorShade="ShadeC"><l:VerticalLayout\n\t\t\twidth="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\thref="https://experience.sap.com/fiori-design/"\n\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_5_TITLE}"\n\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\ttarget="_blank"/><Image\n\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text\n\t\t\t\ttext="{i18n>WELCOME_BLOCK_5_TEXT}"\n\t\t\t\tclass="sapUiSmallMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\tbackgroundColorSet="ColorSet10"\n\t\tbackgroundColorShade="ShadeC"><HBox alignItems="Center" justifyContent="Center" width="100%" height="100%"><Image\n\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Fiori_design_examples.png"\n\t\t\t\tdensityAware="false"\n\t\t\t\tclass="sapUiTinyMarginBeginEnd"\n\t\t\t\twidth="100%"\n\t\t\t\talt="{i18n>WELCOME_BLOCK_5_IMG_ALT}"><layoutData><FlexItemData maxWidth="37.5rem" /></layoutData></Image></HBox></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/WelcomeCustomRowSAPUI5.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:custom="sap.ui.documentation"\n\txmlns:html="http://www.w3.org/1999/xhtml"\n\txmlns:l="sap.ui.layout"><l:BlockLayoutCell\n\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\tbackgroundColorShade="ShadeB"><l:VerticalLayout\n\t\t\t\twidth="100%"><custom:TitleLink\n\t\t\t\thref="topic/bf2d55eaa33b44a78ef95e7946d658e8"\n\t\t\t\ttext="{i18n>WELCOME_BLOCK_4_TITLE}"\n\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\ttitleStyle="H2"/><Text\n\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_4_TEXT_1}"\n\t\t\t\t\tclass="sapUiSmallMarginBottom"/><HBox><core:Icon\n\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_4_TEXT_2}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_4_TEXT_3}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_4_TEXT_4}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_4_TEXT_5}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_4_TEXT_6}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_4_TEXT_7}"/></HBox><HBox><core:Icon\n\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n>WELCOME_BLOCK_4_TEXT_8}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell\n\t\t\tbackgroundColorSet="ColorSet10"\n\t\t\tbackgroundColorShade="ShadeA"><l:Grid\n\t\t\t\tdefaultSpan="L6 M12 S12"\n\t\t\t\thSpacing="0"\n\t\t\t\tvSpacing="0"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom"><custom:TitleLink\n\t\t\t\t\t\thref="https://experience.sap.com/fiori-design/"\n\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_5_TITLE}"\n\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\ttarget="_blank"/><Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/link-sap.png"\n\t\t\t\t\t\ttooltip="{i18n>LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}"\n\t\t\t\t\t\twidth="1.25rem"\n\t\t\t\t\t\tpress="onDisclaimerLinkPress"/></html:div><Text\n\t\t\t\t\t\ttext="{i18n>WELCOME_BLOCK_5_TEXT}"\n\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/></l:VerticalLayout><Image\n\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Fiori_design_examples.png"\n\t\t\t\t\talt="{i18n>WELCOME_BLOCK_5_IMG_ALT}"\n\t\t\t\t\tdensityAware="false"\n\t\t\t\t\twidth="100%"><layoutData><l:GridData span="L6 M12 S12"/></layoutData></Image></l:Grid></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/appSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"><Dialog\n\t\t\ttitle="{i18n>APP_SETTINGS_DIALOG_TITLE}"\n\t\t\tclass="sapUiContentPadding"\n\t\t\tcontentWidth="350px"\n\t\t\tid="AppSettingsDialog"><content><VBox class="sapUiTinyMarginTop"><Label text="{i18n>APP_SETTINGS_DIALOG_THEME}" design="Standard" labelFor="ThemeSelect" /><Select id="ThemeSelect" width="100%" class="sapUiSmallMarginBottom"><core:Item key="sap_horizon" text="Morning Horizon (Light)"/><core:Item key="sap_horizon_dark" text="Evening Horizon (Dark)"/><core:Item key="sap_horizon_hcb" text="Horizon High Contrast Black"/><core:Item key="sap_horizon_hcw" text="Horizon High Contrast White"/><core:Item key="sap_fiori_3" text="Quartz Light"/><core:Item key="sap_fiori_3_dark" text="Quartz Dark"/><core:Item key="sap_fiori_3_hcb" text="Quartz High Contrast Black"/><core:Item key="sap_fiori_3_hcw" text="Quartz High Contrast White"/><core:Item key="sap_belize" text="Belize"/></Select><Label text="{i18n>APP_SETTINGS_DIALOG_DENSITY}" design="Standard"  labelFor="CompactModeSwitch" /><Select id="DensityModeSwitch" width="100%"><core:Item text="Cozy" key="cozy"/><core:Item text="Compact" key="compact"/><core:Item text="Condensed" key="condensed"/></Select><Link text="{i18n>APP_SETTINGS_DIALOG_READ_MORE}" href="topic/e54f729da8e3405fae5e4fe8ae7784c1" target="_blank" class="sapUiTinyMarginTop"/><HBox class="sapUiTinyMarginTop" alignItems="Center" justifyContent="SpaceBetween"><Label text="{i18n>APP_SETTINGS_DIALOG_RTL}" design="Standard" labelFor="RTLSwitch" /><Switch id="RTLSwitch" state="false" /></HBox></VBox></content><beginButton><Button text="{i18n>APP_SETTINGS_DIALOG_OK_BTN}" press="handleSaveAppSettings" type="Emphasized"/></beginButton><endButton><Button text="{i18n>APP_SETTINGS_DIALOG_CANCEL_BTN}" press="handleCloseAppSettings"/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/documentation/sdk/view/globalSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"><Dialog\n\t\t\ttitle="{i18n>APP_SETTINGS_DIALOG_TITLE}"\n\t\t\tclass="sapUiContentPadding"\n\t\t\tcontentWidth="350px"\n\t\t\tid="GlobalSettingsDialog"><content><VBox class="sapUiTinyMarginTop"><MessageStrip\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\ttext="{i18n>APP_SETTINGS_DIALOG_LANGUAGE_INFO}"/><Label text="{i18n>APP_SETTINGS_DIALOG_LANGUAGE}" labelFor="LanguageSelect" /><Select id="LanguageSelect"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\tbusy="{supportedLanguages>/selectBusy}"\n\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\tpath: \'supportedLanguages>/langs\'\n\t\t\t\t\t\t\t}"><core:Item key="{supportedLanguages>key}" text="{supportedLanguages>text}"/></Select></VBox></content><beginButton><Button text="{i18n>APP_SETTINGS_DIALOG_OK_BTN}" press="handleSaveAppSettings" type="Emphasized"/></beginButton><endButton><Button text="{i18n>APP_SETTINGS_DIALOG_CANCEL_BTN}" press="handleCloseAppSettings"/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/documentation/sdk/view/samplesInfo.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:l="sap.ui.layout"><Popover\n\t\t\ttitle="{i18n>SAMPLE_INFO_TOOLTIP}"\n\t\t\tplacement="Bottom"><content><l:VerticalLayout><l:content><FormattedText visible="{=${/description} !== undefined}" htmlText="{/description}" class="sapUiTinyMargin" /><FormattedText visible="{=${/details} !== undefined}" htmlText="{/details}" class="sapUiTinyMargin" /></l:content></l:VerticalLayout></content></Popover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/samplesWarning.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:l="sap.ui.layout"><Popover showHeader="false" placement="Bottom"><content><l:VerticalLayout><l:content><MessageStrip showIcon="true" type="Warning" text="{i18n>SAMPLE_EDITED_WARNING}" /></l:content></l:VerticalLayout></content></Popover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/viewSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"><ViewSettingsDialog\n\t\t\tid="viewSettingsDialog"\n\t\t\tconfirm="onConfirmViewSettings"><groupItems><ViewSettingsItem text="{i18n>VIEW_SETTINGS_DIALOG_ITEM_1}" key="name" selected="true" /><ViewSettingsItem text="{i18n>VIEW_SETTINGS_DIALOG_ITEM_2}" key="category" /><ViewSettingsItem text="{i18n>VIEW_SETTINGS_DIALOG_ITEM_3}" key="formFactors" /><ViewSettingsItem text="{i18n>VIEW_SETTINGS_DIALOG_ITEM_4}" key="namespace" /><ViewSettingsItem text="{i18n>VIEW_SETTINGS_DIALOG_ITEM_5}" key="since" /></groupItems><filterItems><ViewSettingsFilterItem\n\t\t\t\t\ttext="{i18n>VIEW_SETTINGS_DIALOG_ITEM_2}"\n\t\t\t\t\tkey="category"\n\t\t\t\t\tid="categoryFilter"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/category\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" ><items><ViewSettingsItem text="{filter>id}" key="{filter>id}" /></items></ViewSettingsFilterItem><ViewSettingsFilterItem\n\t\t\t\t\ttext="{i18n>VIEW_SETTINGS_DIALOG_ITEM_3}"\n\t\t\t\t\tkey="formFactors"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/formFactors\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" ><items><ViewSettingsItem text="{filter>id}" key="{filter>id}" /></items></ViewSettingsFilterItem><ViewSettingsFilterItem\n\t\t\t\t\ttext="{i18n>VIEW_SETTINGS_DIALOG_ITEM_4}"\n\t\t\t\t\tkey="namespace"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/namespace\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" ><items><ViewSettingsItem text="{filter>id}" key="{filter>id}" /></items></ViewSettingsFilterItem><ViewSettingsFilterItem\n\t\t\t\t\ttext="{i18n>VIEW_SETTINGS_DIALOG_ITEM_5}"\n\t\t\t\t\tkey="since"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/since\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" ><items><ViewSettingsItem text="{filter>id}" key="{filter>id}" /></items></ViewSettingsFilterItem></filterItems></ViewSettingsDialog></core:FragmentDefinition>'
});
//# sourceMappingURL=library-preload.js.map
