/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/core/CustomData","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/core/mvc/XMLView","sap/base/Log"],function(e,t,i,n,s,o,r){"use strict";return e.extend("sap.ui.documentation.sdk.controller.ApiDetail",{NOT_AVAILABLE:"N/A",NOT_FOUND:"Not found",onInit:function(){this.getRouter().getRoute("apiSpecialRoute").attachPatternMatched(this._onTopicMatched,this);this._oModel=new t;this._oModel.setSizeLimit(1e4);this._oContainerPage=this.getView().byId("apiDetailPageContainer")},_onTopicMatched:function(e){var t,i,s;t=this.getRouter()._decodeSpecialRouteArguments(e);i=this.getOwnerComponent();if(this._sTopicid===t.id){s=this._oView&&this._oView.getController();if(s){s.scrollToEntity(t.entityType,t.entityId)}return}this._sTopicid=t.id;this._sEntityType=t.entityType;this._sEntityId=t.entityId;if(this._oView&&!this._oView.bIsDestroyed){this._oView.destroy();this._oContainerPage.setBusy(true)}i.loadVersionInfo().then(function(){this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers")}.bind(this)).then(n.getIndexJsonPromise).then(this._processApiIndexAndLoadApiJson.bind(this)).then(this._findEntityInApiJsonData.bind(this)).then(this._addMissingNodesToControlData.bind(this)).then(this._buildBorrowedModel.bind(this)).then(this._createModelAndSubView.bind(this)).then(this._initSubView.bind(this)).catch(function(e){if(e===this.NOT_FOUND){this._oContainerPage.setBusy(false);this.onRouteNotFound()}else if(typeof e==="string"){r.error(e)}else if(e.name){r.error(e.name,e.message)}else if(e.message){r.error(e.message)}}.bind(this))},_initSubView:function(e){var t=e.getController();if(e.data("topicid")!==this._sTopicid){e.destroy();return}this._oView=e;this._oContainerPage.addContent(e);this._oContainerPage.setBusy(false);t.initiate({sTopicId:this._sTopicid,oModel:this._oModel,aApiIndex:this._aApiIndex,aAllowedMembers:this._aAllowedMembers,oEntityData:this._oEntityData,sEntityType:this._sEntityType,sEntityId:this._sEntityId,oOwnerComponent:this.getOwnerComponent(),oContainerView:this.getView(),oContainerController:this})},_createModelAndSubView:function(e){this._oControlData.borrowed=e;this._bindData(this._sTopicid);return o.create({height:"100%",customData:new i({key:"topicid",value:this._sTopicid}),viewName:"sap.ui.documentation.sdk.view.SubApiDetail",async:true,preprocessors:{xml:{models:{data:this._oModel}}}})},_buildBorrowedModel:function(e){this._oControlData=e;return this.buildBorrowedModel(e)},_addMissingNodesToControlData:function(e){var t,i,n,s,o;if(this._oEntityData.kind==="namespace"){o=Array.isArray(this._oEntityData.nodes)&&this._oEntityData.nodes;t=Array.isArray(e.nodes)&&e.nodes;if(o&&t&&o.length>t.length){t.sort(this._compareStringsCaseInsensitive);o.forEach(function(e,o){i=e.name;s=t[o]&&t[o].name;if(i!==s){n={};n.name=i;n.description="";n.href="api/"+i;if(e.deprecated){n.deprecated=true}t.splice(o,0,n)}})}}return e},_compareStringsCaseInsensitive:function(e,t){var i=e.name.toLowerCase(),n=t.name.toLowerCase();if(i<n){return-1}if(i>n){return 1}return 0},_filterEntityByVisibilityInApiJsonData:function(e){var t=this.getModel("versionData"),i=t.getProperty("/isInternal");if(!i){e=(e||[]).filter(function(e){return!e.hasOwnProperty("visibility")||e.visibility!=="restricted"})}return e},_findEntityInApiJsonData:function(e){var t,i,n;for(n=0,i=e.length;n<i;n++){t=e[n];if(t.name===this._sTopicid){if(t.visibility===undefined||this._aAllowedMembers.indexOf(t.visibility)>=0){return t}else{return Promise.reject(this.NOT_FOUND)}}}return Promise.reject(this.NOT_FOUND)},_processApiIndexAndLoadApiJson:function(e){var t,i,s=this._sTopicid;this._aApiIndex=e;function o(e){return e.some(function(e){var i=e.name===s;if(!i&&e.nodes){return o(e.nodes)}else if(i){t=e;return true}return false})}o(e);if(t){this._oEntityData=t;if(t.deprecated||t.bAllContentDeprecated){i=this.getOwnerComponent().getConfigUtil().getMasterView("apiId").getController();i.selectDeprecatedSymbol(this._sTopicid)}t.nodes=this._filterEntityByVisibilityInApiJsonData(t.nodes);return n.getLibraryElementsJSONPromise(t.lib).then(function(e){return Promise.resolve(e)})}return Promise.reject(this.NOT_FOUND)},_bindData:function(e){var t=this._oControlData,i,n,o=function(e,t){e=e.toLowerCase();t=t.toLowerCase();if(e>t){return 1}else if(e<t){return-1}return 0};n=t["ui5-metadata"];t.hasProperties=false;t.hasOwnMethods=false;t.hasControlProperties=false;t.hasAssociations=false;t.hasAggregations=false;t.hasSpecialSettings=false;t.hasAnnotations=false;var r=function(e){return this._aAllowedMembers.indexOf(e.visibility)>=0}.bind(this);var a=function(e){e.name&&(e.name=s.apiRefEntityName(e.name));e.code&&(e.code=s.apiRefEntityName(e.code));if(e.name){var t=e.name.replace(/[$#/]/g,".");e.placeholderId=t+"_method";e.subPlaceholderId=t+"__method"}return e};if(t.borrowed.properties.length){n=n||(t["ui5-metadata"]={});n.properties=(n.properties||[]).concat(t.borrowed.properties)}if(t.borrowed.aggregations.length){n=n||(t["ui5-metadata"]={});n.aggregations=(n.aggregations||[]).concat(t.borrowed.aggregations)}if(t.borrowed.associations.length){n=n||(t["ui5-metadata"]={});n.associations=(n.associations||[]).concat(t.borrowed.associations)}if(t.borrowed.fields.length){t.properties=(t.properties||[]).concat(t.borrowed.fields)}if(t.properties){t.properties=this.transformElements(t.properties,r,a);t.hasProperties=!!t.properties.length}if(t.methods){t.methods=this.transformElements(t.methods,r,a);t.hasOwnMethods=!!t.methods.length}if(t.events){t.events=this.transformElements(t.events,r,a);t.hasOwnevents=!!t.events.length}if(n){t.dnd=n.dnd;t.hasControlProperties=!!(n.properties&&n.properties.length);t.hasAssociations=!!(n.associations&&n.associations.length);t.hasAggregations=!!(n.aggregations&&n.aggregations.length);t.hasSpecialSettings=!!(n.specialSettings&&n.specialSettings.length);t.hasAnnotations=!!(n.annotations&&n.annotations.length);if(t.hasControlProperties){n.properties=this.transformElements(n.properties,r).sort(function(e,t){return o(e.name,t.name)})}if(t.hasAssociations){n.associations=this.transformElements(n.associations,r).sort(function(e,t){return o(e.name,t.name)})}if(t.hasAggregations){n.aggregations=this.transformElements(n.aggregations,r).sort(function(e,t){return o(e.name,t.name)});t.hasAggregationAltTypes=n.aggregations.some(function(e){return!!e.altTypes})}if(t.hasSpecialSettings){n.specialSettings=this.transformElements(n.specialSettings,r).sort(function(e,t){return o(e.name,t.name)})}if(t.hasAnnotations){n.annotations=n.annotations.sort(function(e,t){return o(e.annotation,t.annotation)})}}t.nodes=this.transformElements(t.nodes||[],r).sort(function(e,t){return o(e.name,t.name)});t.hasChildren=t.nodes&&!!t.nodes.length;t.hasConstructor=t.hasOwnProperty("constructor")&&!!t.constructor;t.hasOwnEvents=!!t.events;t.hasEvents=!!(t.hasOwnEvents||t.borrowed&&t.borrowed.events.length>0);t.hasMethods=!!(t.hasOwnMethods||t.borrowed&&t.borrowed.methods.length>0);if(t.implements&&t.implements.length){t.implementsParsed=t.implements.map(function(e,t,i){var n=e.split("."),s=n[n.length-1];return{href:e,name:s}});t.hasImplementsData=true}else{t.hasImplementsData=false}t.isFunction=t.kind==="function";t.isClass=t.kind==="class";t.isNamespace=t.kind==="namespace";t.isTypedef=t.kind==="typedef";t.isDerived=!!t.extends;t.extendsText=t.extends||this.NOT_AVAILABLE;t.sinceText=t.since||this.NOT_AVAILABLE;t.module=t.module||this.NOT_AVAILABLE;this._oModel.setData(t);if(this.extHookbindData){this.extHookbindData(e,i)}},buildBorrowedModel:function(e){var t,i,s,o,r,a,d,l,h,u,f,m,c,p,g,_,b,w,y,v=[],A;if(!e){return Promise.resolve({events:[],methods:[],properties:[],aggregations:[],associations:[],fields:[]})}l={methods:[],events:[],properties:[],aggregations:[],associations:[],fields:[]};d=e.extends;var E=function(e){return this._aAllowedMembers.indexOf(e.visibility)!==-1}.bind(this);h=e.methods||[];u=h.map(function(e){return e.name});f=e["ui5-metadata"]&&e["ui5-metadata"].properties||[];m=f.map(function(e){return e.name});c=e["ui5-metadata"]&&e["ui5-metadata"].aggregations||[];p=c.map(function(e){return e.name});g=e["ui5-metadata"]&&e["ui5-metadata"].associations||[];_=g.map(function(e){return e.name});b=e.properties||[];w=b.map(function(e){return e.name});var O=function(e){return u.indexOf(e.name)===-1};var C=function(e){return m.indexOf(e.name)===-1&&!e.borrowedFrom&&!l.properties.some(function(t){return t.name===e.name})};var D=function(e){return p.indexOf(e.name)===-1&&!e.borrowedFrom};var I=function(e){return _.indexOf(e.name)===-1&&!e.borrowedFrom};var T=function(e){return w.indexOf(e.name)===-1&&!e.borrowedFrom};function M(e,t){A=null;return e.some(function(e){var i=e.name===t;if(!i&&e.nodes){return M(e.nodes,t)}else if(i){A=e;return true}return false})}y=[d];while(d){M(this._aApiIndex,d);if(A){d=A.extends;if(d){y.push(d)}if(v.indexOf(A.lib)===-1){v.push(A.lib)}}else{d=false;break}}var P=v.map(function(e){return n.getLibraryElementsJSONPromise(e)});return Promise.all(P).then(function(n){var d=[],h;n.forEach(function(e){d=d.concat(e)});y.forEach(function(n){var u,f=d.length;while(f--){if(d[f].name===n){u=d[f];break}}var m=function(e){return{name:e.name,link:"api/"+n+"#methods/"+e.name}};var c=function(e){return{name:e.name,link:"api/"+n+"#events/"+e.name}};var p=function(e){return Object.assign({},e,{borrowedFrom:n})};if(u){h=u["ui5-metadata"]||[];if(e["ui5-metadata"]&&!e["ui5-metadata"].defaultAggregation&&h.defaultAggregation){e["ui5-metadata"].defaultAggregation=h.defaultAggregation}t=(u.methods||[]).filter(E).filter(O).map(m);if(t.length){l.methods.push({name:n,methods:t})}i=(u.events||[]).filter(E).map(c);if(i.length){l.events.push({name:n,events:i})}s=(h.properties||[]).filter(E).filter(C).map(p);if(s.length){l.properties=l.properties.concat(s)}o=(h.aggregations||[]).filter(E).filter(D).map(p);if(o.length){l.aggregations=l.aggregations.concat(o)}r=(h.associations||[]).filter(E).filter(I).map(p);if(r.length){l.associations=l.associations.concat(r)}a=(u.properties||[]).filter(E).filter(T).map(p);if(a.length){l.fields=l.fields.concat(a)}}});return l})},transformElements:function(e,t,i){var n,s=e.length,o=[],r;for(n=0;n<s;n++){r=e[n];if(t&&!t(r)){continue}if(i){i(r)}o.push(r)}return o}})});
//# sourceMappingURL=ApiDetail.controller.js.map