/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/m/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/Highlighter"],function(e,t,i,s,n,o,a,r){"use strict";var l=i.SplitAppMode;return t.extend("sap.ui.documentation.sdk.controller.ApiMaster",{onInit:function(){var e=this.getOwnerComponent();this._oRouter=this.getRouter();this._oRouter.getRoute("api").attachPatternMatched(this._onMatched,this);this._oRouter.getRoute("apiSpecialRoute").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("since").attachPatternMatched(this._onTopicMatched,this);this.bIsInitial=true;this._oTreeModel=new a;this._oTreeModel.setSizeLimit(1e4);this.setModel(this._oTreeModel,"treeData");this._bIncludeDeprecated=false;this._oTree=this.byId("tree");this._oDataLoadedPromise=e.loadVersionInfo().then(function(){this._aAllowedMembers=e.aAllowedMembers}.bind(this)).then(o.getIndexJsonPromise).then(this._bindTreeModel.bind(this)).then(function(){this.buildAndApplyFilters();this._initTreeUtil("name","nodes")}.bind(this))},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new r(this._oTree.getDomRef(),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false})}},onExit:function(){this.highlighter.destroy()},_bindTreeModel:function(e){var t=function(e,i){return e.filter(function(e){if(e.hasOwnProperty("nodes")){e.nodes=t(e.nodes,i)}return!e.hasOwnProperty("visibility")||i.indexOf(e.visibility.toLowerCase())>=0})};if(e.length>0){e.push({isSelected:false,name:"experimental",displayName:"Experimental APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"deprecated",displayName:"Deprecated APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"since",displayName:"Index by Version",bAllContentDeprecated:false,visibility:"public"})}e=t(e,this._aAllowedMembers);this._oTreeModel.setData(e,false)},selectDeprecatedSymbol:function(e){this._bIncludeDeprecated=true;this.byId("includeDeprecated").setSelected(true);this.buildAndApplyFilters();this._expandTreeToNode(e,this.getModel("treeData"))},_onTopicMatched:function(e){var t=decodeURIComponent(e.getParameter("arguments").id)||e.getParameter("name"),i;if(e.getParameter("name")==="apiSpecialRoute"){i=this._oRouter._decodeSpecialRouteArguments(e);t=i.id}if(this.bIsInitial){this.showMasterSide();this.bIsInitial=false}this._oDataLoadedPromise.then(function(){this._expandTreeToNode(t,this._oTreeModel)}.bind(this))},_onMatched:function(){var t=this.getView().getParent().getParent(),i=this._oTree.getSelectedItem();i&&i.setSelected(false);this._oDataLoadedPromise.then(function(){this._oTree.collapseAll().expand(0)}.bind(this));t.setMode(l.ShowHideMode);if(e.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus()}.bind(this),0)}},onNodeSelect:function(e){this._oRouter.navTo("apiId",{id:e.getParameter("listItem").getTarget()},false)},onTreeFilter:function(){t.prototype.onTreeFilter.apply(this,arguments);if(this.highlighter){this.highlighter.highlight(this._sFilter)}return this},buildAndApplyFilters:function(){var e=[];if(!this._bIncludeDeprecated){e.push(new s({path:"bAllContentDeprecated",operator:n.EQ,value1:false}))}if(this._sFilter){e.push(new s({and:false,filters:[new s({path:"name",operator:n.Contains,value1:this._sFilter}),new s({path:"name",operator:n.Contains,value1:this._sFilter.replace(/\s/g,"")})]}))}this._oTree.getBinding("items").filter(new s({and:true,filters:e}));return!!this._sFilter},onIncludeDeprecatedItemsChange:function(e){this._bIncludeDeprecated=e.getParameter("selected");this.buildAndApplyFilters()}})});
//# sourceMappingURL=ApiMaster.controller.js.map