/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/sdk/controller/Sample.controller","../model/ExploreSettingsModel","sap/ui/core/Component","sap/ui/core/HTML","sap/ui/Device","sap/base/util/restricted/_debounce","sap/ui/model/odata/v4/lib/_MetadataRequestor","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/model/formatter"],function(e,t,i,s,a,n,o,r,l){"use strict";return e.extend("sap.ui.documentation.sdk.controller.Code",{constructor:function(){this.onFileEditorFileChangeDebounced=n(this.onFileEditorFileChangeDebounced,500)},onInit:function(){e.prototype.onInit.call(this);this.getView().setModel(t,"settings");this._fileEditor=this.byId("fileEditor");this._fileEditor.attachBeforeFileChange(this.onBeforeFileChanged.bind(this));this._fileEditor.attachFileChange(this.onFileEditorFileChangeDebounced.bind(this));this._registerResize()},onExit:function(){this._deregisterResize()},onBeforeFileChanged:function(e){var t=e.getParameter("sFile");this._oChangedFile={sFile:t}},onFileEditorFileChangeDebounced:function(){var e=this.oModel.getData();if(this._oChangedFile){var i=sap.ui.require.toUrl(this._sId.replace(/\./g,"/"));var s=this._getChangedSamplesLocalStorage();if(!s){this._setChangedSamplesLocalStorage(JSON.stringify([this._sId]))}else{var a=JSON.parse(s);if(a.indexOf(this._sId)<0){a.push(this._sId);this._setChangedSamplesLocalStorage(JSON.stringify(a))}}e.showWarning=true;this.oModel.setData(e);this._updateFileContent(i,this._oChangedFile.sFile,true);this._oChangedFile=null}if(t.getProperty("/autoRun")){this._updateSample()}},onFileSwitch:function(e){t.setProperty("/editable",e.getParameter("editable"))},onRunPressed:function(e){this._updateSample()},onClearButtonPressed:function(e){var t=document.getElementById("sampleFrameEdit"),i=this._getChangedSamplesLocalStorage(),s=this.oModel.getData(),a=sap.ui.require.toUrl(this._sId.replace(/\./g,"/"));if(i){var n=JSON.parse(i);n.splice(n.indexOf(this._sId),1);this._setChangedSamplesLocalStorage(JSON.stringify(n))}s.showWarning=false;this.oModel.setData(s);this._getPage().setBusy(true);t.addEventListener("load",function(){this._getPage().setBusy(false)}.bind(this),{once:true});Promise.allSettled(this._oData.files.map(function(e){return fetch(e.url,{method:"DELETE"})})).then(function(){this._fileEditor._setClearButtonPressed(true);this._updateSample();this._fileEditor._fetchContents();this._oData.files.forEach(function(e){this._updateFileContent(a,e.name,true)},this)}.bind(this))},onChangeSplitterOrientation:function(e){t.setProperty("/splitViewVertically",!t.getProperty("/splitViewVertically"));var i=t.getProperty("/splitViewVertically");this.getView().byId("splitView").getRootPaneContainer().setOrientation(i?"Vertical":"Horizontal")},_attachPaternMatched:function(){this.oRouter.getRoute("code").attachPatternMatched(this._onRouteMatched,this);this.oRouter.getRoute("codeFile").attachPatternMatched(this._onRouteMatched,this)},_deregisterResize:function(){a.media.detachHandler(this._onResize,this)},_registerResize:function(){a.media.attachHandler(this._onResize,this);this._onResize()},_onResize:function(){var e=t.getProperty("/splitViewVertically"),i=a.media.getCurrentRange("StdExt").name;if(i=="Tablet"||i=="Phone"&&!e){t.setProperty("/splitViewVertically",true);this.getView().byId("splitView").getRootPaneContainer().setOrientation("Vertical")}},_onRouteMatched:function(e){var t=e.getParameter("arguments");this._sId=t.sampleId;this._sEntityId=t.entityId;this._sFileName=l.routeParamsToFilePath(t);this.byId("splitView").setBusy(true);r.loadData().then(function(e){return Promise.all([this._loadCode(e),this._loadSample(e)])}.bind(this)).then(function(e){this._showCode(e[0])}.bind(this))},_loadCode:function(e){var t=this._sFileName;var i=e.samples[this._sId];if(!i||i.contexts&&!i.contexts[this._sEntityId]){this.onRouteNotFound();return Promise.reject()}if(!this._oData||i.id!==this._oData.id){return this._createComponent().then(function(e){var s=e.getManifestEntry("/sap.ui5/config")||{},a=s.sample&&s.sample.additionalEditableFiles;this._oData={id:i.id,title:"Code: "+i.name,name:i.name,stretch:s.sample?s.sample.stretch:false,files:s.sample.files.map(function(e){return{key:e,name:e,editable:!!(e.endsWith(".xml")||e.endsWith(".js")||a&&a.indexOf(e)>-1),url:sap.ui.require.toUrl(i.id.replace(/\./g,"/"))+"/"+e}}),iframe:s.sample.iframe,fileName:t,includeInDownload:s.sample.additionalDownloadFiles,customIndexHTML:s.sample.customIndexHTML};return this._oData}.bind(this))}else{this._oData.fileName=t;return Promise.resolve(this._oData)}},_showCode:function(e){var i=!!e.useIFrame;this._oCurrSample=e;if(e.files){this._fileEditor.setFiles(e.files)}else{this.byId("splitView").setBusy(false)}t.setProperty("/useIFrame",i);this.oModel.setProperty("/sample",e);window.addEventListener("message",function(e){if(e.data==="sampleLoaded"){this.byId("splitView").setBusy(false)}}.bind(this))},_createHTMLControl:function(){return new s({id:"sampleFrameEdit",content:'<iframe src="'+this.sIFrameUrl+'" frameBorder="0" width="100%" height="100%"></iframe>'})},_getPage:function(){return this.byId("samplePageEdit")},onMessage:function(e){if(e.origin!==this.getOwnerComponent()._sSampleIframeOrigin){return}if(e.source!==(this._oHtmlControl.getDomRef()&&this._oHtmlControl.getDomRef().contentWindow)){return}if(e.data.type==="INIT"){this.fnMessageInit(e)}else if(e.data.type==="ERR"){this.fnMessageError(e)}else if(e.data.type==="LOAD"){this.fnMessageLoad(e)}},onNavBack:function(){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this._sId},false)},onPreviousSample:function(e){this.oRouter.navTo("code",{entityId:this.entityId,sampleId:this.oModel.getProperty("/previousSampleId")})},onNextSample:function(e){this.oRouter.navTo("code",{entityId:this.entityId,sampleId:this.oModel.getProperty("/nextSampleId")})},_updateSample:function(){var e=document.getElementById("sampleFrameEdit");if(e.contentWindow&&e.contentWindow.sap){e.contentWindow.location.reload()}},_createComponent:function(){var e="sampleComp-"+this._sId;var t=this._sId;var s=i.getComponentById(e);if(s){s.destroy()}return i.create({id:e,name:t})}})});
//# sourceMappingURL=Code.controller.js.map