/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/EntityInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute"],function(e,t,i,n,a,o,s,r,u,c,l){"use strict";return t.extend("sap.ui.documentation.sdk.controller.Entity",{onInit:function(){this.router=this.getRouter();this.router.getRoute("entity").attachPatternMatched(this.onRouteMatched,this);this._oObjectPage=this.byId("ObjectPageLayout");this.getView().setModel(new e)},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.getRouter().navTo("entity",{id:t},false)},onAPIRefPress:function(e){var t=e.getSource().data("name");this.getRouter().navTo("apiId",{id:t},false)},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true)},onNavToSample:function(e){var t=e.getSource().getBindingContext().getPath(),i=this.getView().getModel().getProperty(t);this.router.navTo("sample",{entityId:this._sNewId,sampleId:i.id})},_wrapInSpanTag:function(e){var t=o.formatTextBlock(e,{linkFormatter:function(e,t){var i="entity",n,a,o;t=t||e;if(e.match("://")){return'<a target="_blank" href="'+e+'">'+t+"</a>"}e=e.trim().replace(/\.prototype\./g,"#");o=e.indexOf("#");if(o===0){return"<code>"+e.slice(1)+"</code>"}else if(o>0){e=e.slice(0,o)}a=e.match(/^topic:(\w{32})$/);if(a){e=a[1];i="topic"}n=e.split("/");if(n.length>1&&["methods","events"].indexOf(n[1].toLowerCase())!==-1){i="api"}return'<a href="'+i+"/"+e+'">'+t+"</a>"}});return'<span class="sapUiJSD">'+t+"</span>"},_TAB_KEYS:["samples","about"],_loadSample:function(e){var t=this._sNewId;var i=e.entities.filter(function(e){return e.id===t});var a=i.length?i[0]:undefined;function o(){if(this._TAB_KEYS.indexOf(this._sNewTab)===-1){this._sNewTab="samples"}if(!s.show[this._sNewTab]){this._sNewTab="samples"}this._switchPageTab();setTimeout(function(){this._oObjectPage.setBusy(false)}.bind(this),0)}var s,r=this.getView();if(this._sId!==t){n.getEntityDocuAsync(t,a&&a.library).then(function(i){if(!a&&!i){this.onRouteNotFound();return}s=this._getViewData(t,i,a,e);this.getAPIReferenceCheckPromise(s.name).then(function(e){s.bHasAPIReference=e;this._buildHeaderLayout(s)}.bind(this));r.getModel().setData(s,false);this._sId=t;o.call(this);this.appendPageTitle(this.getModel().getProperty("/name"))}.bind(this))}else{s=this.getView().getModel().getData();o.call(this);this.appendPageTitle(this.getModel().getProperty("/name"))}},onRouteMatched:function(e){this._oObjectPage.setBusy(true);this._sNewId=e.getParameter("arguments").id;this._sNewTab=e.getParameter("arguments").sectionTab;i.loadData().then(function(e){this._loadSample(e)}.bind(this));this.searchResultsButtonVisibilitySwitch(this.byId("entityBackToSearch"))},onToggleFullScreen:function(e){a.updateMode(e,this.getView(),this)},_getViewData:function(e,t,i,n){var a=this._convertEntityInfo(e,t,n),o=false,s=0;a.show.introLink=false;if(i){if(!a.shortDescription&&i.description){a.shortDescription=i.description}if(!a.baseName){a.baseName=i.name}if(i.docuLink){a.show.introLink=true;a.docuLink=i.docuLink.replace("docs/guide","topic").replace(/\.html$/,"");a.docuLinkText=a.baseName}o=i.samples.length>0;s=i.samples.length}a.show.samples=o;a.count.samples=s;a.entity=i;if(t){if(t.docuLink){a.show.introLink=true;a.docuLink="topic/"+t.docuLink;a.docuLinkText=t.docuLinkText}a.uxGuidelinesLink=t.uxGuidelinesLink;a.uxGuidelinesLinkText=t.uxGuidelinesLinkText}return a},_convertEntityInfo:function(e,t,i){var n={name:e,deprecated:t?this._formatDeprecated(t.deprecation):null,deprecatedMark:t?this._createDeprecatedMark(t.deprecation):null,baseType:t?this._formatType(t.baseType):null,baseTypeText:t?this._formatTypeText(t.baseType):"-",baseTypeNav:t?this._formatTypeNav(t.baseType):null,shortDescription:t?this._formatDeprecatedDescription(t.deprecation):null,description:t?this._wrapInSpanTag(t.doc):null,docuLink:null,docuLinkText:null,uxGuidelinesLink:null,uxGuidelinesLinkText:null,values:t?t.values:[],show:{baseType:t?!!t.baseType:false,about:!!t,values:false,introActive:false},count:{samples:0},appComponent:this._getControlComponent(e,i)};if(!t){return n}n.show.values=Array.isArray(n.values)&&n.values.length>0;return n},_formatDeprecated:function(e){return e&&e.length>0?"true":"false"},_formatDeprecatedDescription:function(e){return e&&e.length>0?this._createDeprecatedMark(e)+": "+e:null},_formatType:function(e){if(!e){return null}else{return e.replace("[]","")}},_formatTypeText:function(e){if(!e){return null}else{e=e.replace("sap.ui.core.","");var t=e.lastIndexOf(".");return t!==-1?e.substr(t+1):e}},_createDeprecatedMark:function(e){var t=this.getModel("i18n").getResourceBundle();return e?t.getText("ENTITY_DEPRECATED"):""},_switchPageTab:function(){var e=this.byId(this._sNewTab);if(!e){return}if(this._oObjectPage){this._oObjectPage.attachEvent("onAfterRenderingDOMReady",function(){this._oObjectPage.setSelectedSection(e.getId())},this)}},_getHeaderLayoutUtil:function(){var e;if(!this._oHeaderLayoutUtil){var t=function(e,t){return new l({title:e,text:t}).addStyleClass("sapUiTinyMarginBottom")},i=function(e){return new r(e||{})},n=function(e){return new u(e||{})},a=function(e){return new s(e||{})},o=function(e,t){var i=new c(e||{});if(t){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom")}return i};e=this.getModel("i18n").getResourceBundle();this._oHeaderLayoutUtil={_getApiReferenceBlock:function(t){return o({items:[a({design:"Bold",text:e.getText("ENITITY_API")}),i({emphasized:true,text:t.name,href:"api/"+t.name})]},true)},_getDocumentationBlock:function(t){return o({items:[a({design:"Bold",text:e.getText("ENTITY_DOCUMENTATION")}),i({emphasized:true,text:t.docuLinkText,href:t.docuLink.replace(/^#\/?/,"")})]},true)},_getUXGuidelinesBlock:function(t){return o({items:[a({design:"Bold",text:e.getText("ENTITY_UX")}),i({emphasized:true,text:t.uxGuidelinesLinkText,href:t.uxGuidelinesLink,target:"_blank"})]},true)},_getExtendsBlock:function(t){return o({items:[a({text:e.getText("ENTITY_EXTENDS")}),i({text:t.baseTypeText,href:"entity/"+t.baseType,visible:!!t.baseTypeNav}),n({text:"N/A",visible:!t.baseTypeNav||!t.baseType})]},true)},_getApplicationComponentBlock:function(i){return t(e.getText("ENTITY_COMPONENT"),i.appComponent)},_getAvailableSinceBlock:function(i){return t(e.getText("ENTITY_SINCE"),i.entity.since)},_getCategoryBlock:function(i){return t(e.getText("ENTITY_CATEGORY"),i.entity.category)},_getContentDensityBlock:function(i){return t(e.getText("ENTITY_DENSITY"),i.entity.formFactors)}}}return this._oHeaderLayoutUtil},backToSearch:function(){this.onNavBack()},_buildHeaderLayout:function(e){var t=0,i=1,n=2,a=3,o=[[],[],[]],s=this._getHeaderLayoutUtil(),r=[{creator:"_getApiReferenceBlock",exists:e.bHasAPIReference},{creator:"_getDocumentationBlock",exists:e.show.introLink},{creator:"_getUXGuidelinesBlock",exists:!!e.uxGuidelinesLink},{creator:"_getExtendsBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getCategoryBlock",exists:true},{creator:"_getContentDensityBlock",exists:true}],u=function(){var u=0,c,l=function(e){if(e<=a){return t}else if(e<=a*2){return i}return n};r.forEach(function(t){var i;if(t.exists){i=s[t.creator].call(this,e);c=l(++u);o[c].push(i)}},this)}.bind(this);u();o.forEach(function(e,t){var i=this.byId("headerColumn"+t);i.removeAllContent();if(e.length>0){i.setVisible(true);e.forEach(i.addContent,i)}},this)},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string","Date","Object"],_formatTypeNav:function(e){return this._baseTypes.indexOf(e)===-1}})});
//# sourceMappingURL=Entity.controller.js.map