/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/sdk/controller/SampleBaseController","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/m/BusyDialog","sap/m/Text","sap/ui/core/HTML","sap/m/library","sap/base/Log","sap/ui/core/Core","sap/ui/core/Fragment","sap/ui/documentation/sdk/util/Resources","./config/sampleForwardingConfig","sap/base/strings/capitalize","sap/ui/core/Configuration"],function(e,t,i,n,s,o,a,r,l,h,d,m,u,p,c,g,f,_){"use strict";var I=d.URLHelper;var S=["sap-ui-rtl","sap-ui-language"];return e.extend("sap.ui.documentation.sdk.controller.Sample",{onInit:function(){var i=_;e.prototype.onInit.call(this);this.oRouter=this.getRouter();this._attachPaternMatched();this.oModel=new t({showNavButton:true,showNewTab:false,rtaLoaded:false,density:this.getOwnerComponent().getContentDensityClass(),rtl:i.getRTL(),theme:i.getTheme(),showWarning:false});this._sId=null;this._sEntityId=null;this.getView().setModel(this.oModel);this.bus=u.getEventBus();this.setDefaultSampleTheme();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this);this.getOwnerComponent()._sSampleIframeOrigin=c.getConfig()!=="."?c.getResourceOrigin():window.origin},_attachPaternMatched:function(){this.oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this)},_onSampleMatched:function(e){var t=new URLSearchParams(window.location.search).has("dk-sample-standalone");this._sId=e.getParameter("arguments").sampleId;this._sEntityId=e.getParameter("arguments").entityId;this.byId("page").setBusy(true);if(t){this._handleRedirect()}if(g[this._sId]){return this.oRouter.navTo("sample",{entityId:g[this._sId].entityId,sampleId:g[this._sId].sampleId},true)}this.getModel("appView").setProperty("/bHasMaster",false);o.loadData().then(this._loadSample.bind(this))},_loadSample:function(e){var t=this._getPage(),i=this.oModel.getData(),n=e.samples[this._sId],s;if(!n){setTimeout(function(){t.setBusy(false)},0);this.onRouteNotFound();return}this.entityId=this._sEntityId?this._sEntityId:n.entityId;this._sLib=n.library;i.sEntityId=this.entityId;if(n.previousSampleId||n.nextSampleId){i.previousSampleId=n.previousSampleId;i.nextSampleId=n.nextSampleId}if(n.contexts){s=n.contexts[this.entityId];if(s){i.previousSampleId=s.previousSampleId;i.nextSampleId=s.nextSampleId}else{this.onRouteNotFound();return}}i.title="Sample: "+n.name;i.showNewTab=true;i.id=n.id;i.name=n.name;i.details=n.details;i.description=n.description;i.showSettings=true;var o=this._getChangedSamplesLocalStorage();if(o&&JSON.parse(o).indexOf(n.id)>-1){i.showWarning=true}else{i.showWarning=false}this._createIframe().then(function(e){this.getOwnerComponent()._oCurrentOpenedSample=this._oHtmlControl;if(e){i.stretch=e.stretch;i.includeInDownload=e.additionalDownloadFiles;i.customIndexHTML=e.customIndexHTML;if(e.files){var s=sap.ui.require.toUrl(n.id.replace(/\./g,"/"));i.files=[];for(var o=0;o<e.files.length;o++){var a=e.files[o];i.files.push({name:a});this._updateFileContent(s,a)}}i.iframe=e.iframe||null;t.setProperty("enableScrolling",!!e.stretch,true)}this.getAPIReferenceCheckPromise(n.entityId).then(function(e){this.getView().byId("apiRefButton").setVisible(e)}.bind(this));this.oModel.setData(i);this.appendPageTitle(this.getModel().getProperty("/name"))}.bind(this)).catch(function(e){t.removeAllContent();t.addContent(new l({text:"Error while loading the sample: "+e}))}).finally(function(){setTimeout(function(){t.setBusy(false)},0)})},_handleRedirect:function(){this._initIframeURL();this._applySearchParamValueToIframeURL("sap-ui-theme",this._sDefaultSampleTheme);this.sIFrameUrl+="&dk-sample-standalone";I.redirect(this.sIFrameUrl,false)},_initIframeURL:function(){var e=c.getConfig(),t=c.getResourcesVersion(),i="";S.forEach(function(e,t){if(new URL(document.location.href).searchParams.get(e)){i+=(i===""?"?":"&")+e+"="+new URL(document.location.href).searchParams.get(e)}});i=(i===""?"?":i+"&")+"sap-ui-xx-sample-id="+this._sId+"&sap-ui-xx-sample-lib="+(this._sLib||"")+"&sap-ui-xx-sample-origin="+e+t+"&sap-ui-xx-dk-origin="+window.location.origin;this.sIFrameUrl=c.getResourceOrigin()+"/resources/sap/ui/documentation/sdk/index.html"+i},getSettingsDialog:function(){return new Promise(function(e,t){if(!this._oSettingsDialog){p.load({id:"sample",name:"sap.ui.documentation.sdk.view.appSettingsDialog",controller:this}).then(function(t){this._oSettingsDialog=t;this._oSettingsDialog.setModel(this._oMessageBundle,"i18n");e(this._oSettingsDialog)}.bind(this))}else{e(this._oSettingsDialog)}}.bind(this))},_getChangedSamplesLocalStorage:function(){return localStorage.getItem("dk_changed_samples")},_setChangedSamplesLocalStorage:function(e){localStorage.setItem("dk_changed_samples",e)},handleSettings:function(){if(!this._oMessageBundle){this._oMessageBundle=new i({bundleName:"sap.ui.documentation.messagebundle"})}this.getSettingsDialog().then(function(e){this.loadSampleSettings(this.applySampleSettings.bind(this));return e}.bind(this)).then(function(e){e.open()}).catch(function(e){m.error(e)})},applySampleSettings:function(e){if(e.data.type==="SETTINGS"){var t=u.byId("sample--ThemeSelect");t.setSelectedKey(e.data.data.theme);u.byId("sample--RTLSwitch").setState(e.data.data.RTL);u.byId("sample--DensityModeSwitch").setSelectedKey(this._presetDensity(e.data.data.density,true))}},loadSampleSettings:function(e){return new Promise(function(t,i){var n=this._oHtmlControl.getDomRef();n.contentWindow.postMessage({type:"SETTINGS",reason:"get"},this.getOwnerComponent()._sSampleIframeOrigin);window.addEventListener("message",s);function s(i){e(i);window.removeEventListener("message",s);t()}setTimeout(function(){i("The sample iframe is not loading settings")},3e3)}.bind(this))},handleCloseAppSettings:function(){this._oSettingsDialog.close()},handleSaveAppSettings:function(){var e=u.byId("sample--DensityModeSwitch").getSelectedKey(),t=u.byId("sample--ThemeSelect").getSelectedKey(),i=u.byId("sample--RTLSwitch").getState();this._oSettingsDialog.close();if(!this._oBusyDialog){this._oBusyDialog=new r;this._handleBusyDialog()}else{this._handleBusyDialog()}this._applyAppConfiguration(t,e,i);this._saveLocalSettings(t,e,i)},_saveLocalSettings:function(e,t,i){t=this._presetDensity(t);this.oModel.setData({theme:e,rtl:i,density:t},true)},_presetDensity:function(e,t){return t?e.slice(9).toLowerCase():"sapUiSize"+f(e)},_applyAppConfiguration:function(e,t,i){var n=this._oHtmlControl.getDomRef();t=this._presetDensity(t);n.contentWindow.postMessage({type:"SETTINGS",reason:"set",data:{density:t,RTL:i,theme:e}},this.getOwnerComponent()._sSampleIframeOrigin)},_handleBusyDialog:function(){this._oBusyDialog.open();setTimeout(function(){this._oBusyDialog.close()}.bind(this),1e3)},_updateFileContent:function(e,t,i){this.fetchSourceFile(e+"/"+t,undefined,i).then(function(e){var i=this.oModel.getProperty("/files");i.some(function(i){if(i.name===t){i.raw=e;return true}});this.oModel.setProperty("/files",i)}.bind(this))},onAPIRefPress:function(){this.oRouter.navTo("apiId",{id:this.entityId})},onNewTab:function(){if(this.oModel.getProperty("/iframe")){I.redirect(this.sIFrameUrl,true);return}this.loadSampleSettings(function(e){this._applySearchParamValueToIframeURL("sap-ui-theme",e.data.data.theme);this._applySearchParamValueToIframeURL("sap-ui-rtl",e.data.data.RTL);this._applySearchParamValueToIframeURL("sap-ui-density",e.data.data.density)}.bind(this)).then(function(){I.redirect(this.sIFrameUrl,true)}.bind(this)).catch(function(e){m.error(e)})},onPreviousSample:function(e){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/previousSampleId")})},onNextSample:function(e){this.oRouter.navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/nextSampleId")})},onInfoSample:function(e){var t=e.getSource();if(!this._oPopover){p.load({name:"sap.ui.documentation.sdk.view.samplesInfo",controller:this}).then(function(e){this.getView().addDependent(e);this._oPopover=e;this._oPopover.openBy(t)}.bind(this))}else{this._oPopover.openBy(t)}},onWarningSample:function(e){var t=e.getSource();if(!this._oWarningPopover){p.load({name:"sap.ui.documentation.sdk.view.samplesWarning",controller:this}).then(function(e){this.getView().addDependent(e);this._oWarningPopover=e;this._oWarningPopover.openBy(t)}.bind(this))}else{this._oWarningPopover.openBy(t)}},_resolveIframePath:function(e,t){var i=t.split("/"),n;for(n=0;n<i.length-1;n++){if(i[n]==".."){e=e.substring(0,e.lastIndexOf("."))}else{e+="."+i[n]}}return e},_createIframe:function(){return new Promise(function(e,t){this.fResolve=e;this.fReject=t;this._initIframeURL();if(this._oHtmlControl){this._oHtmlControl.destroy()}this._oHtmlControl=this._createHTMLControl().addEventDelegate({onBeforeRendering:function(){window.removeEventListener("message",this.onMessage.bind(this))}.bind(this)}).addEventDelegate({onAfterRendering:function(){window.addEventListener("message",this.onMessage.bind(this))}.bind(this)});this._getPage().removeAllContent();this._getPage().addContent(this._oHtmlControl)}.bind(this))},_createHTMLControl:function(){return new h({id:"sampleFrame",content:'<iframe src="'+this.sIFrameUrl+'" id="sampleFrame" frameBorder="0"></iframe>'})},_getPage:function(){return this.byId("page")},onMessage:function(e){if(e.origin!==this.getOwnerComponent()._sSampleIframeOrigin){return}if(e.source!==this._oHtmlControl.getDomRef().contentWindow){return}if(e.data.type==="INIT"){this.fnMessageInit(e)}else if(e.data.type==="ERR"){this.fnMessageError(e)}else if(e.data.type==="LOAD"){this.fnMessageLoad(e)}else if(e.data.type==="RTA"){this._loadRTA.call(this)}},fnMessageInit:function(e){var t,i="",n=/\/([^\/]*)$/,s=/\..+$/,o,a,r,l,h=this.oModel.getData();if(e.data.config&&e.data.config.sample&&e.data.config.sample.iframe){t=this._sId;l=e.data.config.sample.iframe;i=this._resolveIframePath(t,l);o=n.exec(l);a=o&&o.length>1?o[1]:l;r=s.exec(a)[0];var d=a.replace(s,"");this.sIFrameUrl=(sap.ui.require.toUrl((i+"/"+d).replace(/\./g,"/"))+r||".html")+"?sap-ui-theme="+_.getTheme();this._oHtmlControl.getDomRef().src=this.sIFrameUrl}this._oHtmlControl.getDomRef().contentWindow.postMessage({type:"SETTINGS",reason:"set",data:{density:h.density,RTL:h.rtl,theme:h.theme}},this.getOwnerComponent()._sSampleIframeOrigin);this.fResolve(e.data.config.sample)},fnMessageLoad:function(){m.info("Sample Iframe for sample "+this._sId+" is loaded")},fnMessageError:function(e){this.fReject(e.data.data.msg)},_createComponent:function(){var e="sampleComp-"+this._sId;var t=this._sId;var i=this.getOwnerComponent();var o=n.getComponentById(e);if(o){o.destroy()}return i.runAsOwner(function(){return n.create({id:e,name:t}).then(function(e){return new s({component:e})})})},setDefaultSampleTheme:function(){var e=c.getResourcesVersion();this._sDefaultSampleTheme=e&&parseInt(e.slice(3,5))<68?"sap_belize":_.getTheme()},onDemoKitThemeChanged:function(e,t,i){if(this._oHtmlControl&&this.getModel().getProperty("/iframe")){this._applySearchParamValueToIframeURL("sap-ui-theme",i.sThemeActive);this._oHtmlControl.getDomRef().src=this.sIFrameUrl}},onNavBack:function(e){this.oRouter.navTo("entity",{id:this.entityId})},onNavToCode:function(e){this.oRouter.navTo("code",{entityId:this.entityId,sampleId:this._sId},false)},onToggleFullScreen:function(e){a.updateMode(e,this.getView(),this)},_oRTA:null,_applySearchParamValueToIframeURL:function(e,t){var i=window.URL,n;try{n=new i(this.sIFrameUrl,document.location)}catch(e){m.warning("window.URL is not supported. The search param value won't be applied.");return}this.sIFrameUrl=this.sIFrameUrl.replace(n.search,"");n.searchParams.set(e,t);this.sIFrameUrl=this.sIFrameUrl+decodeURI(n.search)},_loadRTA:function(){var e=this.oModel.getData();e.rtaLoaded=true;this.oModel.setData(e,true);this.oRouter.attachRouteMatched(function(){if(this._oRTA){this._oRTA.destroy();this._oRTA=null}},this)},onToggleAdaptationMode:function(e){if(!this._oHtmlControl||!this._oHtmlControl.getDomRef()){return false}var t=this._oHtmlControl.getDomRef();t.contentWindow.postMessage({type:"RTA",data:{msg:"Start the RTA"}},this.getOwnerComponent()._sSampleIframeOrigin)},onRouteNotFound:function(){var e=this.getModel("i18n").getProperty("NOT_FOUND_SAMPLE_TITLE");this.oRouter.myNavToWithoutHash("sap.ui.documentation.sdk.view.SampleNotFound","XML",false);setTimeout(this.appendPageTitle.bind(this,e));return}})});
//# sourceMappingURL=Sample.controller.js.map