/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/model/json/JSONModel","sap/m/GroupHeaderListItem","sap/base/Log"],function(e,t,r,i,a,s){"use strict";return e.extend("sap.ui.documentation.sdk.controller.SearchPage",{onInit:function(){this.setModel(new i,"searchView");this.getRouter().getRoute("search").attachPatternMatched(this._onTopicMatched,this)},onAfterRendering:function(){var e={useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false};if(!this.highlighter){this.highlighter=new r(this.getView().getDomRef(),e)}},onExit:function(){this.highlighter.destroy()},_onTopicMatched:function(e){var r=decodeURIComponent(e.getParameter("arguments").searchParam),i=e.getParameter("arguments")["?options"],a=i&&i.category,o=this.byId("allList"),n=this._findSectionForCategory(a),c=n?n.getId():null,h=this.getModel("searchView").getProperty("/lastProcessedQuery"),l="";try{this.hideMasterSide()}catch(e){s.error(e)}if(r===h){this.getView().byId("searchPage").setSelectedSection(c);this._modifyLinks();return}this.getModel("searchData").setProperty("/query",r);o.setBusy(true);t.search(r,{includeDeprecated:this.getModel("searchData").getProperty("/includeDeprecated")}).then(function(e){this.getModel("searchView").setProperty("/lastProcessedQuery",r);this.getModel("searchData").setProperty("/matches",e.matches);this.getView().byId("searchPage").setSelectedSection(c);o.setBusy(false)}.bind(this));if(this.highlighter){this.highlighter.highlight(r)}l=this.getModel("i18n").getResourceBundle().getText("SEARCH_PAGE_TITLE",[r]);this.appendPageTitle(l)},formatTableTitle:function(e,t,r){var i=r>0?"1 - "+t:"0";return this.formatMessage(e,i,r)},onDeprecatedFlagChange:function(e){var r=e.getParameter("selected"),i=this.getModel("searchData").getProperty("/query");t.search(i,{includeDeprecated:r}).then(function(e){this.getModel("searchData").setProperty("/matches",e.matches)}.bind(this))},_findSectionForCategory:function(e){var t=this.getView().byId("searchPage").getSections().filter(function(t){return t.data("category")==e});return t.length&&t[0]},_modifyLinks:function(e){var t=this.getView(),r=[].concat(t.byId("allList").getItems(),t.byId("apiList").getItems(),t.byId("documentationList").getItems(),t.byId("samplesList").getItems()),i=r.length,a,s,o,n="_self",c,h=true;while(i--){a=r[i];if(a._getLinkSender){s=this.loadSearchResultLink(a,h);if(e){o=a.getCustomData()[0].getValue();c=a.getCustomData()[1].getValue();if(c){o=new URL(o,document.baseURI).href;n="_blank"}s.setHref(o);s.setTarget(n)}}}},loadSearchResultLink:function(e,t){var r;if(!e._getLinkSender){return null}if(t){r=!!e.getText()}return e._getLinkSender(r)},getGroupHeader:function(e){return new a({title:e.key,upperCase:false})},categoryAPIFormatter:function(e){return e==="API Reference"},categoryDocFormatter:function(e){return e==="Documentation"},categoryExploredFormatter:function(e){return e==="Samples"},onAllLoadMore:function(e){this.getModel("searchView").setProperty("/visibleAllLength",e.getParameter("actual"));this._modifyLinks(true)},onAPILoadMore:function(e){this.getModel("searchView").setProperty("/visibleAPILength",e.getParameter("actual"));this._modifyLinks(true)},onDocLoadMore:function(e){this.getModel("searchView").setProperty("/visibleDocLength",e.getParameter("actual"));this._modifyLinks(true)},onExploredLoadMore:function(e){this.getModel("searchView").setProperty("/visibleExploredLength",e.getParameter("actual"));this._modifyLinks(true)},onSwitchTab:function(e){var t=e.getParameter("section").data("category"),r={searchParam:this.getModel("searchView").getProperty("/lastProcessedQuery")};if(t){r["?options"]={category:t}}this.getRouter().navTo("search",r)}})});
//# sourceMappingURL=SearchPage.controller.js.map