/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Fragment","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/model/formatter","sap/m/Image","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute","sap/m/ObjectStatus","sap/m/Popover","sap/m/library","sap/ui/core/library","sap/m/CustomListItem","sap/m/List","sap/ui/dom/includeStylesheet","sap/ui/dom/includeScript"],function(jQuery,t,e,i,o,s,n,r,a,l,c,h,u,d,p,g,_,f,m){"use strict";var y=d.FlexWrap;var b=p.ValueState;return e.extend("sap.ui.documentation.sdk.controller.SubApiDetail",{NOT_AVAILABLE:"N/A",PUBLIC_GITHUB_FRAMEWORK_DOMAIN:"https://github.com/SAP/openui5/blob/master/src/",SECTION_MAP:{properties:"controlProperties",fields:"properties","special settings":"specialsettings"},EXTERNAL_BASE_TYPES:["Date","Object"],formatter:o,onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");if(!window.hljs){f("resources/sap/ui/documentation/sdk/thirdparty/highlight.js/styles.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/highlight.js/highlight.js"})}},initiate:function(t){var e,i,o,s=function(t){return!t.borrowedFrom};this._sTopicId=t.sTopicId;this._oModel=t.oModel;this._oControlData=this._oModel.getData();this._aApiIndex=t.aApiIndex;this._aAllowedMembers=t.aAllowedMembers;this._sEntityType=t.sEntityType;this._sEntityId=t.sEntityId!=="undefined"?t.sEntityId:undefined;this._oEntityData=t.oEntityData;this._oContainerController=t.oContainerController;this._oContainerView=t.oContainerView;this._oToggleFullScreenBtn=this.byId("toggleFullScreenBtn");this.getOwnerComponent=function(){return t.oOwnerComponent};this._oRouter=this.getRouter();this._allProperties=this._oModel.getProperty("/ui5-metadata/properties");this._allAggregations=this._oModel.getProperty("/ui5-metadata/aggregations");this._allAssociations=this._oModel.getProperty("/ui5-metadata/associations");if(this._allProperties){this._selfProperties=this._allProperties.filter(s);e=this._selfProperties.length>0;this._oModel.setProperty("/bShowBorrowedProps",!e);this._oModel.setProperty("/bHasSelfProps",e);this._oModel.setProperty("/bHasBorrowedProps",this._allProperties.length>this._selfProperties.length);this._oModel.setProperty("/ui5-metadata/properties",e?this._selfProperties:this._allProperties)}if(this._allAggregations){this._selfAggregations=this._allAggregations.filter(s);i=this._selfAggregations.length>0;this._oModel.setProperty("/bShowBorrowedAggr",!i);this._oModel.setProperty("/bHasSelfAggr",i);this._oModel.setProperty("/bHasBorrowedAggr",this._allAggregations.length>this._selfAggregations.length);this._oModel.setProperty("/ui5-metadata/aggregations",i?this._selfAggregations:this._allAggregations)}if(this._allAssociations){this._selfAssociations=this._allAssociations.filter(s);o=this._selfAssociations.length>0;this._oModel.setProperty("/bShowBorrowedAssoc",!o);this._oModel.setProperty("/bHasSelfAssoc",o);this._oModel.setProperty("/bHasBorrowedAssoc",this._allAssociations.length>this._selfAssociations.length);this._oModel.setProperty("/ui5-metadata/associations",o?this._selfAssociations:this._allAssociations)}if(this._oModel.getProperty("/hasFAQ")){var n=this._oEntityData.lib,r=n.replace(/\./g,"/"),a=this._oEntityData.name.replace(n,"").replace(/^[.]/,"").replace(/\./g,"/")+".html";jQuery.ajax({type:"GET",url:"./docs/api/"+r+"/demokit/faq/"+a,success:function(t){this._oModel.setProperty("/faqContent",t)}.bind(this)})}this.setModel(this._oModel);this._oEntityData.appComponent=this._oControlData.component||this.NOT_AVAILABLE;this._oEntityData.hasSample=this._oControlData.hasSample;this._oEntityData.sample=this._oControlData.hasSample?this._sTopicId:this.NOT_AVAILABLE;this._buildHeaderLayout(this._oControlData,this._oEntityData);setTimeout(function(){this._hljs();this._objectPage.attachEvent("subSectionEnteredViewPort",function(){if(this._sHljsDelayedCallID){clearTimeout(this._sHljsDelayedCallID)}this._sHljsDelayedCallID=setTimeout(function(){var t=this._objectPage.$().find("pre:not(.hljs)");if(t.length>0&&window.hljs){t.addClass("hljs");document.querySelectorAll("pre").forEach(function(t){window.hljs.highlightBlock(t)})}}.bind(this),200)},this);setTimeout(function(){if(this._sEntityType){this.scrollToEntity(this._sEntityType,this._sEntityId)}setTimeout(function(){this._objectPage.attachEvent("_sectionChange",function(t){var e=t.getParameter("section"),i=t.getParameter("subSection");if(this._oNavigatingTo){if(this._oNavigatingTo===i){this._oNavigatingTo=null}return}this._modifyURL(e,i,false)},this);this._objectPage.attachEvent("navigate",function(t){var e=t.getParameter("section"),i=t.getParameter("subSection");this._oNavigatingTo=i;this._modifyURL(e,i,true)},this)}.bind(this),500)}.bind(this),1e3)}.bind(this),0);this.searchResultsButtonVisibilitySwitch(this.byId("apiDetailBackToSearch"));this.appendPageTitle(this._oModel.getProperty("/displayName"))},onAfterRendering:function(){this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);i.updateControl(this._oToggleFullScreenBtn,this._oContainerView,this._oContainerController)},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this)},onToggleFullScreen:function(t){i.updateMode(t,this._oContainerView,this._oContainerController)},onBorrowedPropCheckboxClick:function(t){var e=t.getParameter("selected");this._oModel.setProperty("/bShowBorrowedProps",e);this._oModel.setProperty("/ui5-metadata/properties",e?this._allProperties:this._selfProperties)},onBorrowedAggrCheckboxClick:function(t){var e=t.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAggr",e);this._oModel.setProperty("/ui5-metadata/aggregations",e?this._allAggregations:this._selfAggregations)},onBorrowedAssocCheckboxClick:function(t){var e=t.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAssoc",e);this._oModel.setProperty("/ui5-metadata/associations",e?this._allAssociations:this._selfAssociations)},onJSDocLinkClick:function(t){var e=t.target.classList,i=e.contains("sapUISDKExternalLink");if(i){this.onDisclaimerLinkPress(t);return}},onVisibilityInformationClick:function(e){var i=e.getSource(),o=this.getView();if(!this._oPopover){this._oPopover=t.load({name:"sap.ui.documentation.sdk.view.VisibilityInformation",controller:this}).then(function(t){o.addDependent(t);return t})}this._oPopover.then(function(t){t.openBy(i)})},_modifyURL:function(t,e,i){var o=t.getTitle().toLowerCase(),s=e&&e.getTitle()!=="Overview"?e.getTitle():"";if(Object.keys(this.SECTION_MAP).indexOf(o)>=0){o=this.SECTION_MAP[o]}this._oRouter.navToChangeUrlOnly({id:this._sTopicId,entityType:o,entityId:s},i)},_hljs:function(){if(window.hljs){document.querySelectorAll("pre").forEach(function(t){window.hljs.highlightBlock(t)})}},scrollToEntity:function(t,e){var i,o,s;if(!t){return}t=t.toLowerCase();s=this.byId(t);if(!s){return}if(e){e=e.toLowerCase();o=s.getSubSections();i=o.filter(function(t){return t.getTitle().toLowerCase()===e});if(i.length){this._objectPage.scrollToSection(i[0].getId(),250)}}else{this._objectPage.scrollToSection(s.getId(),250)}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0)}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var t=function(t,e,i){var o=new c({title:t,text:e}).addStyleClass("sapUiTinyMarginBottom");if(i){o.setCustomContent(i)}return o},e=function(t,e){return new h({title:"Visibility",text:o.formatVisibility(t,e),state:b.Warning}).addStyleClass("sapUiTinyMarginBottom")},i=function(t){return new r(t||{})},u=function(t){return new a(t||{})},d=function(t){return new n(t||{})},p=function(t,e){var i=new l(t||{});if(e){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom")}return i};this._oHeaderLayoutUtil={_getControlSampleBlock:function(t,e){var o=t&&t["ui5-metadata"]&&t["ui5-metadata"].stereotype||"";if(typeof o==="string"&&o.length>0){o=o.charAt(0).toUpperCase()+o.slice(1)+" "}return p({items:[d({design:"Bold",text:o+"Sample:"}),i({emphasized:true,text:e.sample,visible:!!e.hasSample,href:"entity/"+t.name}),u({text:e.sample,visible:!e.hasSample})]},true)},_getControlGithub:function(t,e){return p({items:[d({design:"Bold",text:"GitHub:"}),i({emphasized:true,text:t.resource,visible:true,href:this.PUBLIC_GITHUB_FRAMEWORK_DOMAIN+e.lib+"/src/"+t.resource})]},true)},_getDocumentationBlock:function(t,e){return p({items:[d({design:"Bold",text:"Documentation:"}),i({emphasized:true,text:t.docuLinkText,href:"topic/"+t.docuLink})]},true)},_getUXGuidelinesBlock:function(t){return p({items:[d({design:"Bold",text:"UX Guidelines:"}),i({emphasized:true,text:t.uxGuidelinesLinkText,href:t.uxGuidelinesLink,target:"_blank"}),new s({src:"./resources/sap/ui/documentation/sdk/images/link-sap.png",tooltip:"Information published on SAP site",press:this.onDisclaimerLinkPress})]},true)},_getExtendsBlock:function(t,e){var o=t.isDerived&&!this.EXTERNAL_BASE_TYPES.includes(t.extendsText);return p({items:[d({text:"Extends:"}),i({text:t.extendsText,href:"api/"+t.extendsText,visible:o}),u({text:t.extendsText,visible:!o})]},true)},_getSubclassesBlock:function(t,e){var o=e.extendedBy||e.implementedBy,s;this._aSubClasses=o;if(o.length===1){s=i({text:o[0],href:"api/"+o[0]})}else{s=i({text:t.isClass?"View subclasses":"View implementations",press:this._openSubclassesImplementationsPopover.bind(this)});s.onclick=function(t){t.allowPreventDefault=true;r.prototype._handlePress.call(this,t)}}return p({items:[d({text:t.isClass?"Known direct subclasses:":"Known direct implementations:"}),s]},true)},_getImplementsBlock:function(t,e){var o=[d({text:"Implements:"})];t.implementsParsed.forEach(function(t){o.push(i({text:t.name,href:"api/"+t.href}))});return p({items:o,wrap:y.Wrap},true).addStyleClass("sapUiDocumentationCommaList")},_getModuleBlock:function(e,i){return t("Module",e.module)},_getLibraryBlock:function(e,i){return t("Library",i.lib)},_getVisibilityBlock:function(o,s){var n=o.visibility,r=s.allowedFor;if(n==="restricted"&&r){return r.length>1?t("Visibility",n,i({text:"restricted to",press:this._openVisibilityPopover.bind(this,r)})):e(n,r)}else{return t("Visibility",n)}},_getAvailableSinceBlock:function(e,i){return t("Available since",e.sinceText)},_getApplicationComponentBlock:function(e,i){return t("Application Component",i.appComponent)}}}return this._oHeaderLayoutUtil},_openSubclassesImplementationsPopover:function(t){var e=this._aSubClasses.map(function(t){return new g({content:[new r({text:t,href:"api/"+t}).addStyleClass("sapUiTinyMargin")]})}),i=this._addPopoverContent(e);i.openBy(t.getSource())},_openVisibilityPopover:function(t,e){var i=t.map(function(t){return new g({content:[new a({text:t}).addStyleClass("sapUiTinyMargin")]})}),o=this._addPopoverContent(i);o.openBy(e.getSource())},_addPopoverContent:function(t){var e=this._getPopover();if(e.getContent().length>0){e.destroyContent()}if(t&&t.length>0){var i=new _({items:t||[]});e.addContent(i)}return e},_getPopover:function(){if(!this._oPopover){this._oPopover=new u({placement:"Bottom",showHeader:false})}return this._oPopover},_buildHeaderLayout:function(t,e){var i=0,o=1,s=2,n=3,r=[[],[],[]],a=this._getHeaderLayoutUtil(),l=e.extendedBy||e.implementedBy||[],c=this.getModel("versionData").getProperty("/isOpenUI5"),h=[{creator:"_getControlSampleBlock",exists:t.isClass||t.isNamespace},{creator:"_getDocumentationBlock",exists:t.docuLink!==undefined},{creator:"_getControlGithub",exists:c&&t.resource&&e.lib},{creator:"_getUXGuidelinesBlock",exists:t.uxGuidelinesLink!==undefined},{creator:"_getExtendsBlock",exists:t.isClass||t.isTypedef&&t.isDerived},{creator:"_getSubclassesBlock",exists:l.length>0},{creator:"_getImplementsBlock",exists:t.hasImplementsData},{creator:"_getModuleBlock",exists:true},{creator:"_getLibraryBlock",exists:t.kind==="namespace"&&e.lib},{creator:"_getVisibilityBlock",exists:t.visibility},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true}],u=function(){var l=0,c,u=function(t){if(t<=n){return i}else if(t<=n*2){return o}return s};h.forEach(function(i){var o;if(i.exists){o=a[i.creator].call(this,t,e);c=u(++l);r[c].push(o)}},this)}.bind(this);u();r.forEach(function(t,e){var i=this.byId("headerColumn"+e);i.removeAllContent();if(t.length>0){i.setVisible(true);t.forEach(i.addContent,i)}},this)},onAnnotationsLinkPress:function(){this.scrollToEntity("annotations","Summary")},backToSearch:function(){this.onNavBack()}})});
//# sourceMappingURL=SubApiDetail.controller.js.map