/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/ui/core/Fragment","sap/ui/model/resource/ResourceModel","sap/ui/core/Core"],function(o,e,i,t,s){"use strict";return o.extend("sap.ui.documentation.sdk.cookieSettingsDialog.controller.CookieSettingsDialog",{constructor:function(){this._oCookiesUtil=null;this._oRootView=null;this._oInitOptions=null;this._oModel=new e},openCookieSettingsDialog:function(o,e,t){this._oInitOptions=o;this._oModel.setData(o,true);if(this._oCookieSettingsDialog){this._oCookieSettingsDialog.open()}else{this._initData(e,t);i.load({name:"sap.ui.documentation.sdk.cookieSettingsDialog.view.CookieSettingsDialog",controller:this}).then(this._initDialog.bind(this)).then(function(o){this._oCookieSettingsDialog=o;this._oCookieSettingsDialog.open()}.bind(this))}},_initDialog:function(o){var e=new t({bundleName:"sap.ui.documentation.sdk.cookieSettingsDialog.i18n.i18n"});o.setModel(this._oModel,"cookieData");o.setModel(e,"i18n");this._oRootView.addDependent(o);o.attachBeforeOpen(function(){this._oCookieSettingsDialog.toggleStyleClass("cookiesDetailedView",this._oModel.getProperty("/showCookieDetails"))},this);o.attachAfterOpen(function(){s.byId("btnSetPreferences").focus()});if(!this._bAlreadyRequestedCookiesApproval){o.attachEventOnce("afterClose",function(){this._bAlreadyRequestedCookiesApproval=true;this._oCookiesUtil.setCookie(this._oCookiesUtil.COOKIE_NAMES.APPROVAL_REQUESTED,"1")},this)}return o},formatCookieValue:function(o){return Boolean(Number(o))},onAcceptAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,true);this._oCookieSettingsDialog.close()},onRejectAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,false);this._oCookieSettingsDialog.close()},onSaveCookies:function(){var o=s.byId("requiredCookiesSwitch").getState();this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,o);this._oCookieSettingsDialog.close()},showCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",true);this._oCookieSettingsDialog.addStyleClass("cookiesDetailedView");this._focusButton(s.byId("btnSavePreferences"))},onCancelPress:function(){if(this._oInitOptions.showCookieDetails===true){this.onCancelEditCookies()}else{this.hideCookieDetails()}},hideCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",false);this._oCookieSettingsDialog.removeStyleClass("cookiesDetailedView");this._focusButton(s.byId("btnSetPreferences"))},onCancelEditCookies:function(){this._oCookieSettingsDialog.close();s.byId("requiredCookiesSwitch").setState(this._oCookiesUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1")},_saveCookiePreference:function(o,e){var i=e?"1":"0";this._oCookiesUtil.setCookie(o,i);this._oModel.setProperty("/"+o,i)},_initData:function(o,e){this._oCookiesUtil=e;this._oRootView=o;this._oCookieNames=this._oCookiesUtil.COOKIE_NAMES;this._bAlreadyRequestedCookiesApproval=this._oCookiesUtil.getCookieValue(this._oCookieNames.APPROVAL_REQUESTED)==="1";this._setInitialCookieValues()},_setInitialCookieValues:function(){var o={};if(!this._bAlreadyRequestedCookiesApproval){o[this._oCookieNames.ALLOW_REQUIRED_COOKIES]="1"}else{o[this._oCookieNames.ALLOW_REQUIRED_COOKIES]=this._oCookiesUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)}this._oModel.setData(o,true)},_focusButton:function(o){if(o.getDomRef()){o.focus();return}o.addEventDelegate({onAfterRendering:function(){o.focus();o.removeEventDelegate(this)}})}})});
//# sourceMappingURL=CookieSettingsDialog.controller.js.map