/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/util/merge","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/base/security/sanitizeHTML","sap/ui/documentation/sdk/controller/util/URLUtil","sap/base/strings/formatMessage"],function(t,e,r,i,n,o){"use strict";var a=/^p\d+$/;var s=t.extend("sap.ui.documentation.sdk.model.formatter"),u={crossLink:function(t){if(t[0]==="#"){t=document.location.href.substring(0,document.location.href.search("demoapps.html"))+t}return t},libraryLink:function(t){if(t&&t.search("sap\\.")===0){return this.formatter.crossLink("api/"+t)}else{return""}},libraryLinkEnabled:function(t){return!!this.formatter.libraryLink.bind(this)(t)},categoryName:function(t){var e=this.getModel("i18n").getResourceBundle();t=t.toUpperCase();return e.getText("DEMO_APPS_CATEGORY_"+t)},apiRefEntityName:function(t){if(t){return t.replace("module:","")}},apiRefAggregationAltTypes:function(t){return t&&t.join(", ")},formatVisibility:function(t,e){var r=t;if(e&&Array.isArray(e)){r+=" to "+e.join(", ")}return r},formatVersionTitle:function(t,e){if(e){return this.formatMessage(t,e)}return this.getModel("i18n").getResourceBundle().getText("API_DETAIL_NA_VERSION")},formatSenderLink:function(t,e,r){if(r==="methods"){return t+"#"+e}if(r==="events"){return t+"#events:"+e}if(r==="class"){return t}return""},formatIndexByVersionEntry:function(t,e,r,i,n){var o=this.formatSenderLink(t,e,r),a=this.formatApiHref(t,e,r,i),s=this.formatLinks(n);return'<a href="'+a+'" class="sapMLnk sapMLnkMaxWidth">'+o+"</a>"+s},formatApiHref:function(t,e,r,i){var n;if(i){e=t+"."+e}n="api/"+t;if(r!=="class"){n+="/"+r+"/"+e}return n},formatLinks:function(t){return r.formatTextBlock(t,{linkFormatter:function(t,e){var r;if(t.match("://")){return'<a target="_blank" href="'+t+'">'+(e||t)+"</a>"}t=t.trim().replace(/\.prototype\./g,"#");r=t.indexOf("#");e=e||t;if(r<0){var i=t.lastIndexOf("."),n=t.substring(0,i),o=t.substring(i+1),a=o;if(a){if(a.static===true){t=n+"/methods/"+n+"."+o}else{t=n+"/methods/"+o}}}if(r===0){return"<code>"+t.slice(1)+"</code>"}if(r>0){t=t.slice(0,r)+"/methods/"+t.slice(r+1)}return'<a href="api/'+t+'" target="_self">'+e+"</a>"}})},filePathToRouteParams:function(t){var e,r={};if(!t){return{}}e=t.split("/");e.forEach(function(t,e){r["p"+ ++e]=t});return r},routeParamsToFilePath:function(t){var e=Object.keys(t),r,i,n=[];for(var o=0;o<e.length;o++){r=a.test(e[o]);i=r&&t[e[o]];if(i){n.push(i)}if(r&&!i){break}}if(n.length){return n.join("/")}},formatHttpHrefForNewWindow:function(t){if(window["sap-ui-documentation-static"]&&!/^https?:\/\//.test(t)){t="#/"+t}return t},formatImportantMessage:function(t){var e=this._getUI5Distribution();return o(t,e)},formatMessageStripLinks:function(t){var e=window["sap-ui-documentation-static"];if(t){t=i(t,{uriRewriter:function(t){if(e&&n.hasSEOOptimizedFormat("/"+t)){t=n.convertToNonSEOFormat(t).replace(/^\//,"")}return t}})}return t},formatToolCardVisibility:function(t){if(!t){return false}if(t.hideOnPhone&&this.getOwnerComponent().getModel("device").getProperty("/system/phone")){return false}if(t.isDistributionScope&&this.getOwnerComponent().getModel("versionData").getProperty("/isOpenUI5")){return false}return true}};return e(s,u)});
//# sourceMappingURL=formatter.js.map