/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/routing/Router","sap/ui/core/routing/History","sap/ui/thirdparty/hasher","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/thirdparty/URI"],function(t,e,i,n,a){"use strict";i.raw=true;var o=t.extend("sap.ui.documentation.sdk.util.DocumentationRouter",{constructor:function(){t.prototype.constructor.apply(this,arguments);this._URLSeparator=window["sap-ui-documentation-static"]?"%23":"#";this._fnPopstateHandlerRef=this.popstateHandler.bind(this);this.getRoute("entitySamplesLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityAboutLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityPropertiesLegacyRoute").attachPatternMatched({entityType:"controlProperties"},this._forwardToAPIRef,this);this.getRoute("entityAggregationsLegacyRoute").attachPatternMatched({entityType:"aggregations"},this._forwardToAPIRef,this);this.getRoute("entityAssociationsLegacyRoute").attachPatternMatched({entityType:"associations"},this._forwardToAPIRef,this);this.getRoute("entityEventsLegacyRoute").attachPatternMatched({entityType:"events"},this._forwardToAPIRef,this);this.getRoute("entityMethodsLegacyRoute").attachPatternMatched({entityType:"methods"},this._forwardToAPIRef,this);this.getRoute("topicIdLegacyRoute").attachPatternMatched(this._onOldTopicRouteMatched,this);this.getRoute("apiIdLegacyRoute").attachPatternMatched(this._onOldApiRouteMatched,this);this.getRoute("sampleLegacyRoute").attachPatternMatched({routeName:"sample"},this._onOldSampleRouteMatched,this);this.getRoute("codeLegacyRoute").attachPatternMatched({routeName:"code"},this._onOldSampleRouteMatched,this);this.getRoute("codeFileLegacyRoute").attachPatternMatched({routeName:"codeFile"},this._onOldSampleRouteMatched,this);this.getRoute("ReleaseNotesLegacyRoute").attachPatternMatched(function(){this.navTo("releaseNotes")},this)},_removeNonStandardEncoding:function(t){return typeof t==="string"?t.replace(/[\[\]']+/g,""):t},_onOldEntityRouteMatched:function(t){this.navTo("entity",{id:t.getParameter("arguments").id},true)},_forwardToAPIRef:function(t,e){e||(e={});e["id"]=t.getParameter("arguments").id;this.navTo("apiId",e)},_onOldSampleRouteMatched:function(t,e){var i=t.getParameter("arguments"),a=i.id;n.loadData().then(function(t){var n=t.samples[a],o;if(!n){this.onRouteNotFound()}o={entityId:n.contexts?Object.keys(n.contexts)[0]:n.entityId,sampleId:a};if(e.routeName==="codeFile"){o["fileName"]=decodeURIComponent(i.fileName)}this.navTo(e.routeName,o,true)}.bind(this))},_onOldTopicRouteMatched:function(t){this.navTo("topicId",{id:t.getParameter("arguments").id.replace(/.html$/,"")},true)},_onOldApiRouteMatched:function(t){var e,i,n,a=t.getParameter("arguments").id;if(a){n=a.split("#");if(n.length===2){a=n[0];e=n[1];n=e.split(":");if(n.length===2){e=n[0];i=n[1]}}a=a.replace(/.html$/,"");if(e==="event"){e="events"}}this.navTo("apiId",{id:a,entityType:e,entityId:i},true)},myNavBack:function(t,i){var n=e.getInstance();var a=n.getPreviousHash();if(a!==undefined){window.history.go(-1)}else{var o=true;this.navTo(t,i,o)}},myNavToWithoutHash:function(t,e,i,n){var a=this._getOwnerComponent(),o=a.byId(a.getManifestEntry("/sap.ui5/rootView").id);o.loaded().then(function(a){var o=a.byId("splitApp"),r=this.getView(t,e);o.addPage(r,i);o.toDetail(r.getId(),"show",n)}.bind(this))},_getOwnerComponent:function(){return this._oOwner},_destroySampleComponent:function(){var t=this._getOwnerComponent()._oCurrentOpenedSample;if(t){t.getDomRef().contentWindow.postMessage({type:"EXIT",data:{msg:"Destroy the container"}},this._getOwnerComponent()._sSampleIframeOrigin)}}});o.prototype.linkClickHandler=function(t){if(t.defaultPrevented){t.preventDefault();return}var e=t.target,i,n,a=t.ctrlKey||t.metaKey,o;if(!e){return}if(a){return}i=r(e,true);if(!i){return}o=d(i);if(o==="javascript:void(0)"){return}n=/^blob:/.test(o)||/^https?:\/\//.test(o)||/^test-resources\//.test(o)||/^resources\//.test(o)||/^tel:/.test(o)||/^mailto:/.test(o);if(o&&!n){if(t.preventDefault){t.preventDefault()}this.parsePath(o)}};o.prototype.parsePath=function(t){if(t==="#"){t=""}if(window["sap-ui-documentation-static"]&&this.shouldConvertHash(t)){t=t.replace("#","%23")}t=this._removeNonStandardEncoding(t);this.parse(t);if(window["sap-ui-documentation-static"]){window.history.pushState({},undefined,"#/"+t)}else{window.history.pushState({},undefined,t)}};o.prototype.mouseDownClickHandler=function(t){var e=t.buttons,i=t.target,n=r(i),o=t.ctrlKey||t.metaKey,s,c,p;if(n){s=this._removeNonStandardEncoding(d(n));c=o||!h(n)}if(!s||(p=a(s)).is("absolute")||p.suffix()==="html"){return}if(e===2||e===4||c&&e===1){s=this.convertToStaticFormat(s);n.setAttribute("href",s)}};o.prototype.popstateHandler=function(){var t=!!window["sap-ui-documentation-static"],e=t?location.hash.replace(/^[#/]/,""):this._processPath(location.pathname);this.parse(e)};o.prototype.attachGlobalLinkHandler=function(){if(!this._bGlobalHandlerAttached){document.body.addEventListener("click",this.linkClickHandler.bind(this));window["sap-ui-documentation-static"]&&document.body.addEventListener("mousedown",this.mouseDownClickHandler.bind(this),true);this._bGlobalHandlerAttached=true}};o.prototype.attachPopstateHandler=function(){if(!this._bPopstateHandlerAttached){window.addEventListener("popstate",this._fnPopstateHandlerRef);this._bPopstateHandlerAttached=true}};o.prototype.detachPopstateHandler=function(){if(this._bPopstateHandlerAttached){window.removeEventListener("popstate",this._fnPopstateHandlerRef);this._bPopstateHandlerAttached=false}};o.prototype._decodeSpecialRouteArguments=function(t){var e=t.getParameters().arguments,i=[],n,a=[],o;if(e.p1===undefined){if(e.id.indexOf(this._URLSeparator)>-1){o=e.id.split(this._URLSeparator);e.id=o[0];e.p1=o[1]}return{id:decodeURIComponent(e.id),entityId:undefined,entityType:e.p1}}if(/^module:\S+$/.test(e.id)){Object.keys(e).forEach(function(t){var o=e[t],r;if(!o){return}if(!n&&o.indexOf(this._URLSeparator)!==-1){r=o.split(this._URLSeparator);i.push(r[0]);n=r[1];return}if(!n){i.push(o)}else{a.push(o)}}.bind(this));return{id:i.join("/"),entityId:a.length?a.join("/"):undefined,entityType:n}}if(e.id.indexOf(this._URLSeparator)!==-1){o=e.id.split(this._URLSeparator);e.p2=e.p1;e.id=o[0];e.p1=o[1]}return{id:decodeURIComponent(e.id),entityType:e.p1,entityId:e.p2?decodeURIComponent(e.p2):undefined}};o.prototype.navTo=function(t,e,i){var n;var a=i?"replaceState":"pushState";this._destroySampleComponent();if(t==="apiId"){if(e.id){e.id=encodeURIComponent(e.id)}if(e.entityId){e.entityId=encodeURIComponent(e.entityId)}}n=this.getURL(t,e);if(t==="apiId"){n=n.replace(/#$/,"");n=decodeURIComponent(n)}this.parse(n);if(window["sap-ui-documentation-static"]){window.history[a]({},undefined,"#/"+n.replace("#",this._URLSeparator))}else{window.history[a]({},undefined,n)}return this};if(!window["sap-ui-documentation-static"]){o.prototype._processPath=function(t){var e=document.querySelector("base[href]"),i=e?e.getAttribute("href"):"",n=i.slice(0,i.length-1),a=location.hash,o;if(t.startsWith(i)){t=t.replace(i,"")}else if(t.startsWith(n)){t=t.replace(n,"")}if(a){if(!t&&a.indexOf("module%3A")!==-1){o=a.split("/");a="#"+o[1]+"/"+decodeURIComponent(o[2])+(o[3]?"#"+o[3]:"")+(!o[3]?"/":"")+(o[4]?"/"+decodeURIComponent(o[4]):"")}t+=(t?"#":"")+a.slice(1)}return t};o.prototype.initialize=function(){var t=this._processPath(location.pathname);this.stop();this.parse(t);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this};o.prototype.navToChangeUrlOnly=function(t,e){var i;if(t.id){t.id=encodeURIComponent(t.id)}if(t.entityId){t.entityId=encodeURIComponent(t.entityId)}i=this.getURL("apiId",t);i=decodeURIComponent(i);if(e){window.history.pushState({},undefined,i)}else{window.history.replaceState({},undefined,i)}return this}}else{o.prototype.initialize=function(){this.getRoute("sample").attachPatternMatched(function(){if(new URLSearchParams(window.location.search).has("dk-sample-standalone")){document.body.style.visibility="hidden"}});t.prototype.initialize.apply(this,arguments);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this};o.prototype.navToChangeUrlOnly=function(t,e){var i;if(t.id){t.id=encodeURIComponent(t.id)}if(t.entityId){t.entityId=encodeURIComponent(t.entityId)}i=this.getURL("apiId",t);i=decodeURIComponent(i);i=i.replace("#",this._URLSeparator);this.stop();hasher.stop();this.detachPopstateHandler();if(e){hasher.setHash(i)}else{hasher.replaceHash(i)}hasher.init();this.initialize(true);this.attachPopstateHandler()}}o.prototype.shouldConvertHash=function(t){return this.getRoute("apiId").match(t)||this.getRoute("apiSpecialRoute").match(t)};o.prototype.convertToStaticFormat=function(t){var e=window.location,i=t;if(this.shouldConvertHash(t)){i=t.replace("#","%23")}i=e.origin+e.pathname+"#/"+i;return i};function r(t,e,i){var n=s(t,e),a=0;i||(i=3);while(!n&&a++<i){t=t&&t.parentElement;n=s(t,e)}return t}function s(t,e){if(t&&t.nodeName==="A"||t.nodeName==="AREA"){return e?h(t):true}return false}function d(t){return t.getAttribute("href")}function h(t){return t.getAttribute("target")!=="_blank"}return o});
//# sourceMappingURL=DocumentationRouter.js.map