/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_curry","sap/base/util/restricted/_difference","sap/base/util/includes","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/AggregationOverlay","sap/ui/dt/DesignTimeStatus","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementOverlay","sap/ui/dt/ElementUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/SelectionManager","sap/ui/dt/SelectionMode","sap/ui/dt/TaskManager","sap/ui/dt/TaskRunner","sap/ui/dt/Util"],function(e,t,a,r,n,i,s,o,l,g,d,c,h,y,u,p,m,v,f,E,O,_,b,S){"use strict";var I=l.extend("sap.ui.dt.DesignTime",{metadata:{library:"sap.ui.dt",properties:{designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},addPlugin:{parameters:{plugin:{type:"sap.ui.dt.Plugin"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayAdded:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayMoved:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayEditableChanged:{parameters:{id:{type:"string"},elementId:{type:"string"},editable:{type:"boolean"}}},elementPropertyChanged:{parameters:{id:{type:"string"},name:{type:"string"},oldValue:{type:"any"},value:{type:"any"}}},syncing:{},synced:{},syncFailed:{}}},constructor:function(...e){this._sStatus=c.SYNCED;this._mPendingOverlays={};this._oTaskManager=new _({complete:function(e){if(e.getSource().isEmpty()){this._registerElementOverlays();if(this._oTaskManager.isEmpty()&&this._sStatus!==c.SYNCED){this._sStatus=c.SYNCED;setTimeout(function(){if(this._sStatus===c.SYNCED){this.fireSynced()}}.bind(this),0)}}}.bind(this),add:function(e){if(e.getSource().count()===1){this._sStatus=c.SYNCING;this.fireSyncing()}}.bind(this)});this._oTaskRunner=new b({taskManager:this._oTaskManager,taskType:"applyStyles"}).run();this._oSelectionManager=new E;this._aOverlaysCreatedInLastBatch=[];l.apply(this,e);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(e){this._createOverlaysForRootElement(e.getParameter("element"))},this);this.getPlugins().forEach(function(e){e.attachEvent("processingStatusChange",this._onProcessingStatusChange,this)},this);this.attachEvent("addPlugin",function(e){var t=e.getParameter("plugin");t.attachEvent("processingStatusChange",this._onProcessingStatusChange,this)},this);this.attachEvent("enabledChanged",function(e){var t=e.getParameter("value");var a=m.getOverlayContainer();a[t?"show":"hide"]();this.getRootElements().forEach(function(e){var a=v.getOverlay(e);a.setVisible(t);if(t){this._oTaskManager.add({type:"applyStyles",callbackFn:a.applyStyles.bind(a,true),overlayId:a.getId()})}}.bind(this))},this)}});I.prototype._onProcessingStatusChange=function(e){if(e.getParameter("processing")){this._oTaskManager.add({type:"pluginInProcess",plugin:e.getSource().getMetadata().getName()})}else{this._oTaskManager.completeBy({type:"pluginInProcess",plugin:e.getSource().getMetadata().getName()})}};I.prototype._onApplyStylesRequired=function(e){var t=e.getParameters();var a=e.getSource();this._oTaskManager.add({type:"applyStyles",callbackFn:a.applyStyles.bind(a,t.bForceScrollbarSync,t.bSkipForceCalculation),overlayId:a.getId()},"overlayId")};I.prototype._removeOverlayFromSyncingBatch=function(e){var t=this._aOverlaysCreatedInLastBatch.indexOf(e);if(t!==-1){this._aOverlaysCreatedInLastBatch.splice(t,1)}};I.prototype._registerElementOverlays=function(){var e=this._aOverlaysCreatedInLastBatch.slice();if(!e.length){return}this._aOverlaysCreatedInLastBatch=[];var t=this._oTaskManager.add({type:"registerElementOverlays"});var a=this.getPlugins();e.forEach(function(e){v.register(e);e.attachBeforeDestroy(function(e){v.deregister(e.getSource())})});e.forEach(function(e){a.forEach(function(t){try{t.callElementOverlayRegistrationMethods(e)}catch(r){var a=S.propagateError(r,"DesignTime#_registerElementOverlays",`registerElementOverlay() method of the plugin ${t.getMetadata().getName()} has failed for overlay with id='${e.getId()}' (element id='${e.getElement().getId()}')`);o.error(S.errorToString(a))}})},this);e.forEach(function(e){try{this.fireElementOverlayCreated({elementOverlay:e})}catch(a){var t=S.propagateError(a,"DesignTime#_registerElementOverlays",`One of the listeners of elementOverlayCreated event failed while processing the overlay with id='${e.getId()}' for element with id='${e.getElement().getId()}'`);o.error(S.errorToString(t))}},this);this._oTaskManager.complete(t)};I.prototype.exit=function(){this._bDestroyPending=true;this.getPlugins().forEach(function(e){e.destroy()});this._oSelectionManager.destroy();this._oTaskManager.destroy();this._destroyAllOverlays();this._aOverlaysCreatedInLastBatch=[];delete this._bDestroyPending};I.prototype.getSelectionManager=function(){return this._oSelectionManager};I.prototype.getPlugins=function(){return this.getAggregation("plugins")||[]};I.prototype.getBusyPlugins=function(){return this.getPlugins().filter(function(e){return e.isBusy()})};I.prototype.waitForBusyPlugins=function(){var e=this.getBusyPlugins();return Promise.all(e.map(function(e){return e.waitForBusyAction()}))};I.prototype.addPlugin=function(e){this.addAggregation("plugins",e);this.fireAddPlugin({plugin:e});e.setDesignTime(this);return this};I.prototype.insertPlugin=function(e,t){this.insertAggregation("plugins",e,t);this.fireAddPlugin({plugin:e});e.setDesignTime(this);return this};I.prototype.removePlugin=function(e){this.getPlugins().forEach(function(t){if(t===e){e.setDesignTime(null);e.detachEvent("processingStatusChange",this._onProcessingStatusChange,this)}}.bind(this));this.removeAggregation("plugins",e);return this};I.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(e){e.setDesignTime(null);e.detachEvent("processingStatusChange",this._onProcessingStatusChange,this)}.bind(this));this.removeAllAggregation("plugins");return this};I.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(e){return u.getElementInstance(e)})};I.prototype.getDesignTimeMetadataFor=function(e){var t;if(typeof e==="string"){t=e;o.error("sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance")}else{t=e.getMetadata().getName()}return(this.getDesignTimeMetadata()||{})[t]};I.prototype.addRootElement=function(e){this.addAssociation("rootElements",e);this.fireAddRootElement({element:e})};I.prototype._createOverlaysForRootElement=function(e){var t=this._oTaskManager.add({type:"createOverlay",element:e,root:true});this.createOverlay({element:u.getElementInstance(e),root:true,visible:this.getEnabled()}).then(function(e){m.getOverlayContainer().append(e.render());this._oTaskManager.add({type:"applyStyles",callbackFn:e.applyStyles.bind(e),overlayId:e.getId()},"overlayId");this._oTaskManager.complete(t);return e}.bind(this),function(a){var r=S.propagateError(a,"DesignTime#_createOverlaysForRootElement",`Initialization failed for root element with id '${e.getId()}'`);o.error(S.errorToString(r));this._oTaskManager.cancel(t);this.fireSyncFailed({error:r})}.bind(this))};I.prototype.removeRootElement=function(e){this.removeAssociation("rootElements",e);this._destroyOverlaysForElement(u.getElementInstance(e));return this};I.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this};I.prototype.getElementOverlays=function(){var e=[];this._iterateRootElements(function(t){e=e.concat(this._getAllElementOverlaysIn(t))},this);return e};function T(e,t){if(e){t.setIsRoot(true)}}I.prototype.createOverlay=function(e){var t=Object.assign({},n(e)?e:{element:e});var a=this._oTaskManager.add({type:"createOverlay"});if(!t.element||!u.isElementValid(t.element)){this._oTaskManager.cancel(a);return this._rejectCreateOverlay(t.element)}var r=t.element.getId();var i=v.getOverlay(r);if(i){T(t.root,i);this._oTaskManager.complete(a);return Promise.resolve(i)}else if(r in this._mPendingOverlays){this._oTaskManager.complete(a);return this._mPendingOverlays[r]}if(typeof t.root==="undefined"){t.root=true}this._mPendingOverlays[r]=this._createElementOverlay(t).then(function(e){return this._createChildren(e,t).then(function(){this.attachEventOnce("synced",function(){delete this._mPendingOverlays[r]},this);if(this.bIsDestroyed){e.detachEvent("destroyed",this._onElementOverlayDestroyed,this);e.destroy();this._oTaskManager.cancel(a);return Promise.reject(S.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"))}else if(e.bIsDestroyed){this._oTaskManager.cancel(a);return Promise.reject(S.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"))}this._aOverlaysCreatedInLastBatch.push(e);this._oTaskManager.complete(a);return e}.bind(this))}.bind(this)).catch(function(e){var t=S.propagateError(e,"DesignTime#createOverlay",`Failed attempt to create overlay for element '${r}'`);delete this._mPendingOverlays[r];this._oTaskManager.cancel(a);return Promise.reject(t)}.bind(this));return this._mPendingOverlays[r]};I.prototype._rejectCreateOverlay=function(e){var t;if(!e){t="Cannot create overlay — no element is specified."}else if(e.bIsDestroyed){t="Cannot create overlay — the element is already destroyed."}else if(e instanceof l&&!u.isElementInTemplate(e)){t=`Element is in a bound aggregation, but not found in the binding template. Skipping overlay creation for element with id='${e.getId()}'. Please report to CA-UI5-FL-RTA component.`}else{t=`Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${S.getObjectType(e)} was given`}return Promise.reject(S.createError("DesignTime#createOverlay",t))};I.prototype._createAggregationOverlay=function(e,t,a,r){return new d({aggregationName:e,element:t,visible:!r,isPartOfTemplate:r,designTimeMetadata:new g({data:a}),init:function(e){var t=e.getSource();t.attachEvent("destroyed",this._onAggregationOverlayDestroyed,this);t.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this)}.bind(this),beforeDestroy:function(e){var t=e.getSource();v.deregister(t);t.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this)}.bind(this)})};I.prototype._createElementOverlay=function(t){var a=t.element;function r(e){return new y(e)}return new Promise(function(n,o){r({element:a,isRoot:t.root,visible:typeof t.visible!=="boolean"||t.visible,isPartOfTemplate:t.isPartOfTemplate,metadataScope:this.getScope(),designTimeMetadata:this.getDesignTimeMetadataFor(a)instanceof h?this.getDesignTimeMetadataFor(a):e(function(e,t,a,r){r=i({},r,e);this._mMetadataOriginal=r;if(t){r=p.propagateMetadataToElementOverlay(r,t,a)}return r})(this.getDesignTimeMetadataFor(a),t.parentMetadata,a),init:function(e){var t=e.getSource();n(e.getSource());t.attachEvent("destroyed",this._onElementOverlayDestroyed,this);t.attachEvent("elementDestroyed",this._onElementDestroyed,this);t.attachEvent("selectionChange",this._onElementOverlaySelectionChange,this);t.attachEvent("elementModified",this._onElementModified,this);t.attachEvent("editableChange",this._onEditableChanged,this);t.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this);if(s.get(["actions","actionsFromResponsibleElement"],t.getDesignTimeMetadata().getData())){var a=this.getSelectionManager().getConnectedElements();var r=t.getElement();var i=t.getDesignTimeMetadata().getResponsibleElement(r);a[r.getId()]=i.getId();a[i.getId()]=r.getId();this.getSelectionManager().setConnectedElements(a)}}.bind(this),initFailed:function(e,t){var a=t.getSource();var r=S.propagateError(t.getParameter("error"),"DesignTime#_createElementOverlay",`Error creating overlay (id='${a.getId()}') for '${e}'`);a.detachEvent("destroyed",this._onElementOverlayDestroyed,this);a.detachEvent("elementDestroyed",this._onElementDestroyed,this);a.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this);a.destroy();o(r)}.bind(this,a.getId())})}.bind(this))};function M(e,t){var a=e.getElement();return t.reduce(function(e,t){var r=u.getAggregationBindingTemplate(a,t);if(r){e[t]=r}return e},{})}I.prototype._createChildren=function(e,a){var n=e.getAggregationNames();var i=a.parentMetadata;var s=M(e,n);var o=Object.keys(s);var l=a.isPartOfTemplate!==undefined;var g=!r(s);var d=g&&!l;var c=d?true:a.isPartOfTemplate;var h=d?false:a.isPartOfTemplate;if(g&&c&&!d){n=t(n,o)}return this._createChildrenOverlays(e,i,o,c,s).then(this._createChildrenOverlays.bind(this,e,i,n,h))};I.prototype._createChildrenOverlays=function(e,t,a,n,i){var s=!r(i);if(s&&!n){return Promise.resolve()}return Promise.all(a.map(function(a){var r=e.getElement();var l=r.getMetadata().getName();var g=p.propagateMetadataToAggregationOverlay(e.getDesignTimeMetadata().getAggregation(a),r,t);var d=this._createAggregationOverlay(a,r,g,s);v.register(d);var c;if(s){c=[i[a]]}else{c=u[d.isAssociation()?"getAssociationInstances":"getAggregation"](r,a)}return Promise.all(c.map(function(t,i){return this.createOverlay({element:i,root:false,parentMetadata:g,isPartOfTemplate:n}).catch(function(n){var s=this._enrichChildCreationError(n,i,t,a);if(!r.isDestroyed()&&!e.isDestroyed()){o[s.severity](s.message)}return s.errorObject}.bind(this))}.bind(this,l))).then(function(e){e.map(function(e){if(e instanceof y&&!e.bIsDestroyed&&!e.getParent()){d.addChild(e,true)}},this);return d}.bind(this))},this)).then(function(t){t.forEach(function(t){if(e.bIsDestroyed){t.destroy()}else if(s){e.addAggregationBindingTemplateOverlay(t)}else{e.addChild(t,true)}})})};I.prototype._enrichChildCreationError=function(e,t,a,r){var n="error";var i=S.errorToString(e);if(e.message.includes("Cannot create overlay without a valid element")){n="warning";e=S.createError("DesignTime#_createChildren",`Child element in aggregation '${r}' of ${a} must be a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${S.getObjectType(t)} was given. Consider ignoring aggregation ${r} in the .designtime configuration of the control.`);i=e.toString()}else if(e.message.startsWith("Element is in a bound aggregation")){n="error";i=e.toString()}return{errorObject:e,severity:n,message:i}};I.prototype._destroyOverlaysForElement=function(e){var t=v.getOverlay(e);if(t){t.destroy()}};I.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(e){this._destroyOverlaysForElement(e)},this)};I.prototype._onElementOverlayDestroyed=function(e){if(this._bDestroyPending){return}var t=e.getSource();this._oTaskManager.cancelBy({type:"applyStyles",overlayId:t.getId()},"overlayId");this._removeOverlayFromSyncingBatch(t);var a=t.getAssociation("element");if(a in this._mPendingOverlays){delete this._mPendingOverlays[a];return}if(!v.hasOverlays()){m.destroyMutationObserver();m.removeOverlayContainer()}if(t.isSelected()){this.getSelectionManager().remove(t)}this.fireElementOverlayDestroyed({elementOverlay:t})};I.prototype._onElementDestroyed=function(e){var t=e.getParameter("targetId");this.removeRootElement(t)};I.prototype._onAggregationOverlayDestroyed=function(e){this._oTaskManager.cancelBy({type:"applyStyles",overlayId:e.getSource().getId()},"overlayId");if(!v.hasOverlays()){m.removeOverlayContainer()}};I.prototype._onElementOverlaySelectionChange=function(e){var t=e.getSource();var r=e.getParameter("selected");if(r){if(this.getSelectionManager().getSelectionMode()===O.Multi){this.getSelectionManager().add(t)}else{this.getSelectionManager().set(t)}if(!a(this.getSelectionManager().get(),t)){t.setSelected(false)}}else{this.getSelectionManager().remove(t)}};I.prototype._onElementModified=function(e){var t=i({},e.getParameters());var a=e.getSource();t.type=!t.type?e.getId():t.type;switch(t.type){case"addOrSetAggregation":case"insertAggregation":this._onAddAggregation(t.value,t.target,t.name);break;case"setParent":setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(t.target)}}.bind(this),0);break;case"propertyChanged":t.id=e.getSource().getId();delete t.type;delete t.target;if(this.getStatus()===c.SYNCING){this.attachEventOnce("synced",t,function(...e){if(!a.bIsDestroyed){this.fireElementPropertyChanged(e[1])}},this)}else{this.fireElementPropertyChanged(t)}break;default:break}};I.prototype._onEditableChanged=function(e){var t=i({},e.getParameters());var a=e.getSource();t.id=a.getId();if(this.getStatus()===c.SYNCING){this.attachEventOnce("synced",t,function(...e){if(!a.bIsDestroyed){this.fireElementOverlayEditableChanged(e[1])}},this)}else{this.fireElementOverlayEditableChanged(t)}};I.prototype._onAddAggregation=function(e,t,a){if(u.isElementValid(e)){var r=v.getOverlay(t);var n=r&&r.getAggregationOverlay(a);if(!n){var i=function(r){var n=r.getParameter("elementOverlay");if(n.getElement().getId()===t.getId()){var s=n.getAggregationOverlay(a);this.detachElementOverlayCreated(i,this);this._addAggregation(e,s)}};this.attachElementOverlayCreated(i,this)}else{this._addAggregation(e,n)}}};I.prototype._addAggregation=function(e,t){var a=v.getOverlay(e);if(!a&&t&&t.getElement()){var r=this._oTaskManager.add({type:"createChildOverlay",element:e});this.createOverlay({element:e,root:false,parentMetadata:t.getDesignTimeMetadata().getData()}).then(function(e){var a=t.insertChild(null,e);if(a===true){this._oTaskManager.add({type:"applyStyles",callbackFn:e.applyStyles.bind(e),overlayId:e.getId()},"overlayId");var n=t.indexOfAggregation("children",e);this.attachEventOnce("synced",e,function(){if(!e.bIsDestroyed){this.fireElementOverlayAdded({id:e.getId(),targetIndex:n,targetId:t.getId(),targetAggregation:t.getAggregationName()})}},this)}this._oTaskManager.complete(r)}.bind(this)).catch(function(a,n,i){this._oTaskManager.cancel(r);var s=S.propagateError(i,"DesignTime#_onAddAggregation",`Failed to add new element overlay (elementId='${a}') into aggregation overlay (id='${n}')`);if(!e.bIsDestroyed&&!t.bIsDestroyed){o.error(S.errorToString(s))}}.bind(this,e.getId(),t.getId()))}else{if(a&&!this._isElementInRootElements(a)&&a.isRoot()){a.setIsRoot(false)}if(t){t.insertChild(null,a)}else{o.error("No parentAggregationOverlay exists during addAggregation");return}a.setDesignTimeMetadata(p.propagateMetadataToElementOverlay(a._mMetadataOriginal,t.getDesignTimeMetadata().getData(),e));this.fireElementOverlayMoved({id:a.getId(),targetIndex:t.indexOfAggregation("children",a),targetId:t.getId(),targetAggregation:t.getAggregationName()})}};I.prototype._checkIfOverlayShouldBeDestroyed=function(e){var t=v.getOverlay(e);if(!e.bIsDestroyed&&t&&(!this._isElementInRootElements(e)||e.sParentAggregationName==="dependents")){t.destroy()}};I.prototype._isElementInRootElements=function(e){var t=false;this._iterateRootElements(function(a){if(u.hasAncestor(e,a)){t=true;return false}return undefined});return t};I.prototype._iterateRootElements=function(e,t){var a=this.getRootElements();a.forEach(function(a){var r=u.getElementInstance(a);e.call(t||this,r)},this)};I.prototype._getAllElementOverlaysIn=function(e){var t=[];var a=v.getOverlay(e);if(a){f.iterateOverlayElementTree(a,function(e){if(e.getDesignTimeMetadata()){t.push(e)}})}return t};I.prototype.setEnabled=function(e){e=!!e;if(this.getEnabled()!==e){this.setProperty("enabled",e);this.fireEnabledChanged({value:e})}};I.prototype.getStatus=function(){return this._sStatus};return I});
//# sourceMappingURL=DesignTime.js.map