/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/ControlObserver","sap/ui/dt/ManagedObjectObserver","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/Util","sap/ui/core/Control","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/restricted/_intersection","sap/base/util/restricted/_max"],function(e,t,i,r,a,s,n,o,l,d,h,jQuery,g,p,u,f,c){"use strict";var y="sapUiDtOverlayScrollContainer";var v=t.extend("sap.ui.dt.ElementOverlay",{metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},aggregations:{aggregationBindingTemplateOverlays:{type:"sap.ui.dt.Overlay",multiple:true,defaultValue:[]}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"},ignoreEnterKeyUpOnce:{type:"boolean",defaultValue:false}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},constructor:function(...e){this._aMetadataEnhancers=[];t.apply(this,e)}});v.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this.attachEvent("elementModified",function(e){var t=e.getParameters();var i=t.name;if(t.type==="propertyChanged"){if(i==="visible"){this.setRelevantOverlays([])}}else if(i){this.setRelevantOverlays([])}},this);this._initMutationObserver();this._initControlObserver()}.bind(this))};v.prototype._updateScrollContainer=function(e){if(this.getShouldBeDestroyed()||this.bIsDestroyed){return}var t=e.index;var i=this.getScrollContainerById(t);var r=this.getScrollContainers(true)[t];var a=[].concat(r.aggregations);var s=i.find(">:not(.sapUiDtDummyScrollContainer)").toArray();s.forEach(function(e){var t=e.getAttribute("data-sap-ui-dt-aggregation");if(r.aggregations.includes(t)){a.splice(a.indexOf(t),1)}else{i.get(0).removeChild(e);l.appendChild(this.getChildrenDomRef(),e)}}.bind(this));a.forEach(function(e){var t=this.getAggregationOverlay(e).getDomRef();this.getChildrenDomRef().removeChild(t);l.appendChild(i.get(0),t)}.bind(this))};v.prototype._onRootChanged=function(e){var t=e.getParameter("value");this._subscribeToMutationObserver(t)};v.prototype._initMutationObserver=function(){this._subscribeToMutationObserver(this.isRoot());this.attachEvent("isRootChanged",this._onRootChanged,this)};v.prototype._subscribeToMutationObserver=function(e){var i=t.getMutationObserver();var r=this.getAssociatedDomRef();this._sObservableNodeId=r&&r.get(0)&&r.get(0).id;if(this._sObservableNodeId){i.registerHandler(this._sObservableNodeId,this._domChangedCallback.bind(this),e);if(r.get(0).shadowRoot){i.addNode(r.get(0).shadowRoot)}}else if(e){g.error("sap.ui.dt.ElementOverlay#_subscribeToMutationObserver: please provide a root control with proper domRef and id to ensure that RTA is working properly")}};v.prototype._unsubscribeFromMutationObserver=function(){if(this._sObservableNodeId){var e=t.getMutationObserver();e.deregisterHandler(this._sObservableNodeId);delete this._sObservableNodeId}};v.prototype._initControlObserver=function(){if(this.getElement()instanceof h){this._oObserver=new a({target:this.getElement(),aggregations:this.getAggregationNames()})}else{this._oObserver=new s({target:this.getElement(),aggregations:this.getAggregationNames()})}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this)};v.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy()}};v.prototype._getAttributes=function(...e){return u({},t.prototype._getAttributes.apply(this,e),{"data-sap-ui-dt-for":this.getElement().getId(),draggable:this.getMovable()})};v.prototype.render=function(...e){this.addStyleClass("sapUiDtElementOverlay");return t.prototype.render.apply(this,e)};v.prototype.exit=function(...e){this._unsubscribeFromMutationObserver();this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest)}t.prototype.exit.apply(this,e)};v.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(e){var t=this.getElement();if(!t||t.bIsDestroyed){throw d.createError("ElementOverlay#loadDesignTimeMetadata","Can't set metadata to overlay which element has been destroyed already")}this.setDesignTimeMetadata(e)}.bind(this)).catch(function(e){throw d.propagateError(e,"ElementOverlay#loadDesignTimeMetadata",`Can't load designtime metadata data for overlay with id='${this.getId()}', element id='${this.getAssociation("element")}': ${d.wrapError(e).message}`)}.bind(this))};v.prototype._setPosition=function(...e){const[,,,i]=e;t.prototype._setPosition.apply(this,e);this.getScrollContainers().forEach(function(e,r){var a=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),e.domRef)||jQuery();var s=this.getScrollContainerById(r);if(a.length){var n=a.get(0);var o=l.getGeometry(n);this._ensureVisibility(s);this._setSize(s,o);t.prototype._setPosition.call(this,s,o,this.$());this._handleOverflowScroll(o,s,this,i);this._setZIndex(o,s);this._setClipPath(s,a)}else{s.css("display","none")}},this)};v.prototype._applySizes=function(...e){return t.prototype._applySizes.apply(this,e).then(function(){this._sortChildren(this.getChildrenDomRef());if(!this.bIsDestroyed){this.getScrollContainers().forEach(function(e,t){var i=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),e.domRef)||jQuery();var r=this.getScrollContainerById(t);if(i.length){this._sortChildren(r.get(0))}},this)}}.bind(this))};v.prototype._sortChildren=function(e){function t(e,t){var i=l.getGeometry(e);var r=l.getGeometry(t);var a=i&&i.position;var s=r&&r.position;if(a&&s){var n=a.top+i.size.height;var o=s.top+r.size.height;if(a.top<s.top){if(n>=o&&s.left<a.left){return 1}return-1}else if(a.top===s.top){if(a.left===s.left){if(i.size.height<r.size.height||i.size.width<r.size.width){return-1}else if(i.size.height>r.size.height||i.size.width>r.size.width){return 1}return 0}else if(a.left<s.left){return-1}return 1}else if(n<=o&&s.left>a.left){return-1}return 1}return 0}var i=jQuery(e).find(">:not(.sapUiDtDummyScrollContainer)").toArray();var r=i.slice().sort(t);var a=i.some(function(e,t){return e!==r[t]});if(a){r.forEach(function(t){l.appendChild(e,t)})}};v.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){t.getOverlayContainer().append(this.render());this.applyStyles()}else{g.error("sap.ui.dt.ElementOverlay: overlay is already rendered and can't be placed in overlay container. Isn't it already there?")}}else{g.error("sap.ui.dt.ElementOverlay: it's not possible to place overlay inside overlay container while it's part of some hierarchy")}}else{g.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens')}};v.prototype.setDesignTimeMetadata=function(e){var i=this.getDesignTimeMetadata();var r;if(typeof e==="function"){if(!i){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(e)}else{i.setData(e(u({},i.getData())));return}}else if(e instanceof n){i=e}else if(p(e)){r=e;var a;while(a=this._aMetadataEnhancers.shift()){r=a.call(this,r)}i=new n({data:r})}if(i){t.prototype.setDesignTimeMetadata.call(this,i)}};v.prototype.getScrollContainers=function(e){return this.getDesignTimeMetadata().getScrollContainers(this.getElement(),e,this._updateScrollContainer.bind(this))};v.prototype._renderChildren=function(...e){var i=t.prototype._renderChildren.apply(this,e);this.getScrollContainers().forEach(function(e,t){var r=jQuery("<div></div>",{class:y,"data-sap-ui-dt-scrollContainerIndex":t});if(e.aggregations){f(e.aggregations,this.getAggregationNames()).forEach(function(e){var a=this.getAggregationOverlay(e);var s=i.indexOf(a.$());a.setScrollContainerId(t);r.append(i[s]);i.splice(s,1)},this)}i.push(r)},this);return i};v.prototype.getScrollContainerById=function(e){return jQuery(this.getChildrenDomRef()).find(`>.${y}[data-sap-ui-dt-scrollcontainerindex="${e}"]`)};v.prototype.getAssociatedDomRef=function(){var e=this.getDesignTimeMetadata();var t=e?.getDomRef();var i=e?.getAssociatedDomRef(this.getElement(),t);i||=o.getDomRef(this.getElement());if(i){return jQuery(i)}return undefined};v.prototype.setSelectable=function(e){e=!!e;if(e!==this.isSelectable()){if(!e){this.setSelected(false)}this.toggleStyleClass("sapUiDtOverlaySelectable",e);this.setProperty("selectable",e);this.fireSelectableChange({selectable:e})}this.setFocusable(e);return this};v.prototype.setSelected=function(e){e=!!e;if(this.isSelectable()&&e!==this.isSelected()){this.setProperty("selected",e);this.toggleStyleClass("sapUiDtOverlaySelected",e);var t=r.getClosestBoundControl(this);if(t.overlayId){var a=i.getOverlay(t.overlayId);b(t,a)}this.fireSelectionChange({selected:e})}return this};function b(e,t,i){i=i===undefined?e.stack.length-1:i;var r=e.stack[i];var a=i===0;var s=e.stack.length===1;if(r){t.getChildren().forEach(function(t){if(t.getAggregationName()===r.aggregation){t.getChildren().some(function(t,n){if(a&&s){t.toggleStyleClass("sapUiDtOverlayHighlighted")}else if(a&&n===r.index){t.toggleStyleClass("sapUiDtOverlayHighlighted");return true}else if(!a){b(e,t,i-1)}return undefined})}})}}v.prototype.setMovable=function(e){e=!!e;if(this.getMovable()!==e){this.toggleStyleClass("sapUiDtOverlayMovable",e);this.setProperty("movable",e);this.fireMovableChange({movable:e});this.$()[e?"attr":"removeAttr"]("draggable",e)}return this};v.prototype.setEditable=function(e){e=!!e;if(this.getEditable()!==e){this.toggleStyleClass("sapUiDtOverlayEditable",e);this.setProperty("editable",e);this.fireEditableChange({editable:e})}return this};v.prototype.getAggregationNames=function(){var e=this.getElement();var t=this.getDesignTimeMetadata();var i=e.getMetadata().getAllAggregations();return[].concat(Object.keys(i),Object.keys(t.getAggregations())).filter(function(i,r,a){return r===a.indexOf(i)&&!t.isAggregationIgnored(e,i)})};v.prototype._onChildAdded=function(e){var t=e.getSource();if(this.isRendered()&&!t.isRendered()){var i=d.isInteger(t.getScrollContainerId())?this.getScrollContainerById(t.getScrollContainerId()):jQuery(this.getChildrenDomRef());i.append(t.render())}};v.prototype.addChild=function(...e){const[i]=e;i.detachChildAdded(this._onChildAdded,this);i.attachChildAdded(this._onChildAdded,this);t.prototype.addChild.apply(this,e)};v.prototype._onElementModified=function(e){if(e.getParameters().type==="afterRendering"){this._subscribeToMutationObserver(this.isRoot());this._oScrollbarSynchronizers.forEach(function(e){e.refreshListeners()})}this.fireElementModified(e.getParameters())};v.prototype._domChangedCallback=function(e){e.targetOverlay=this;if(this.isReady()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest)}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.getGeometry(true);e.bSkipForceCalculation=true;this.fireApplyStylesRequired(e);delete this._iApplyStylesRequest}.bind(this))}};v.prototype._onElementDestroyed=function(e){var t=e.getSource().getTarget();this.fireElementDestroyed({targetId:t});if(this._bInit){this.destroy()}else{this._bShouldBeDestroyed=true}};v.prototype.getAggregationOverlay=function(e,t){var i=`get${t||"Children"}`;return this[i]().filter(function(t){return t.getAggregationName()===e}).pop()};v.prototype.getParentElementOverlay=function(){var e=this.getParentAggregationOverlay();if(e){return e.getParent()}return undefined};v.prototype.getParentAggregationOverlay=function(){var t=this.getParent();return e.isObjectA(t,"sap.ui.dt.AggregationOverlay")?t:null};v.prototype.isSelected=function(){return this.getSelected()};v.prototype.isSelectable=function(){return this.getSelectable()};v.prototype.isMovable=function(){return this.getMovable()};v.prototype.isEditable=function(){return this.getEditable()};v.prototype._getElementInstanceVisible=function(){var e=this.getElement();if(e){var t=this.getGeometry();return t&&t.visible}return false};v.prototype.getElementVisibility=function(){var e=this.getElement();if(e instanceof h){return e.getVisible()}var t=this.getDesignTimeMetadata();var i=t&&t.getData().isVisible;if(!i){return undefined}return i(this.getElement())};v.prototype.isElementVisible=function(){var e=this.getElement();var t=false;var i=this.getDesignTimeMetadata();var r=i.getData();if(i.isIgnored(e)){t=false}else if(typeof r.isVisible==="function"){t=r.isVisible(e)}else{var a=this.getGeometry();if(a){t=a.visible}else if(e instanceof h){t=!!e.getDomRef()&&e.getVisible()}}return t};v.prototype.isVisible=function(...e){return t.prototype.isVisible.apply(this,e)&&this.isElementVisible()};v.prototype.getRelevantContainer=function(e){var t=this.getDesignTimeMetadata();if(t&&t.getData().relevantContainer){return t.getData().relevantContainer}else if(e){return this.getElement()}var i=this.getParentElementOverlay();return i?i.getElement():undefined};v.prototype._hasSameSize=function(e,t){var i=this.getScrollContainers();var r;if(i.length){r=c(i.map(function(e,i){var r=l.getGeometry(this.getScrollContainerById(i).get(0));return r.size[t]},this))}else{r=this.getGeometry().size[t]}return e.size[t]===r};return v});
//# sourceMappingURL=ElementOverlay.js.map