/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/isPlainObject","sap/ui/base/Object","sap/ui/core/Component","sap/ui/core/Element","sap/ui/core/UIArea","sap/ui/dt/DOMUtil","sap/ui/dt/Util"],function(e,t,n,r,i,a,g){"use strict";var o={};o.iterateOverAllPublicAggregations=function(e,t){var n=e.getMetadata().getAllAggregations();var r=Object.keys(n);r.forEach(function(r){var i=n[r];var a=this.getAggregation(e,r);t(i,a)},this)};o.getElementInstance=function(e){if(typeof e==="string"){var t=r.getElementById(e);return t||n.getComponentById(e)}return e};o.hasAncestor=function(e,t){t=this.fixComponentContainerElement(t);var n;while(e&&e!==t){n=this.fixComponentParent(e);if(e===n){e=e.getParent()}else{e=n}}return!!e};o.getClosestElementForNode=function(e){var t=e.closest("[data-sap-ui]");return t?r.getElementById(t.getAttribute("data-sap-ui")):undefined};o.fixComponentParent=function(e){if(t.isObjectA(e,"sap.ui.core.UIComponent")){var n=e.oContainer;if(n){return n.getParent()}}else{return e}};o.fixComponentContainerElement=function(e){if(t.isObjectA(e,"sap.ui.core.ComponentContainer")){if(!e.getComponentInstance()){return undefined}return e.getComponentInstance().getRootControl()}return e};o.getDomRef=function(e){if(e){var t;if(e.getDomRef){t=e.getDomRef()}if(!t&&e.getRenderedDomRef){t=e.getRenderedDomRef()}return t}};o.findAllSiblingsInContainer=function(e,t){var n=e&&e.getParent();if(!n){return[]}if(n!==t){var r=o.findAllSiblingsInContainer(n,t);return r.map(function(t){return o.getAggregation(t,e.sParentAggregationName)}).reduce(function(e,t){return e.concat(t)},[])}return o.getAggregation(n,e.sParentAggregationName)};o.getAggregationAccessors=function(e,t){var n=e.getMetadata();n.getJSONKeys();var r=n.getAggregation(t);if(r){var i=r._sGetter;if(r.altTypes&&r.altTypes.length&&e[`${r._sGetter}Control`]){i=`${r._sGetter}Control`}return{get:i,add:r._sMutator,remove:r._sRemoveMutator,insert:r._sInsertMutator,removeAll:r._sRemoveAllMutator}}return{}};o.getAggregation=function(e,t){var n;var r=this.getAggregationAccessors(e,t).get;if(r){n=e[r]()}else{n=e.getAggregation(t)}n=n&&n.splice?n:n?[n]:[];return n};o.getIndexInAggregation=function(e,t,n){return this.getAggregation(t,n).indexOf(e)};o.addAggregation=function(e,t,n){if(this.hasAncestor(e,n)){throw new Error("Trying to add an element to itself or its successors")}var r=this.getAggregationAccessors(e,t).add;if(r){e[r](n)}else{e.addAggregation(t,n)}};o.removeAggregation=function(e,t,n,r){var i=this.getAggregationAccessors(e,t).remove;if(i){e[i](n,r)}else{e.removeAggregation(t,n,r)}};o.insertAggregation=function(e,t,n,r){if(this.hasAncestor(e,n)){throw new Error("Trying to add an element to itself or its successors")}if(this.getIndexInAggregation(n,e,t)!==-1){n.__bSapUiDtSupressParentChangeEvent=true;try{this.removeAggregation(e,t,n,true)}finally{delete n.__bSapUiDtSupressParentChangeEvent}}var i=this.getAggregationAccessors(e,t).insert;if(i){e[i](n,r)}else{e.insertAggregation(t,n,r)}};o.isValidForAggregation=function(e,n,r){var i=e.getMetadata().getAggregation(n);if(this.hasAncestor(e,r)){return false}if(i){var a=i.type;if(i.multiple===false&&this.getAggregation(e,n)&&this.getAggregation(e,n).length>0){return false}return t.isObjectA(r,a)||this.hasInterface(r,a)}};o.getAssociationAccessors=function(e,t){var n=e.getMetadata();n.getJSONKeys();var r=n.getAssociation(t);if(r){return{get:r._sGetter,add:r._sMutator,remove:r._sRemoveMutator,insert:r._sInsertMutator,removeAll:r._sRemoveAllMutator}}return{}};o.getAssociation=function(e,t){var n;var r=this.getAssociationAccessors(e,t).get;if(r){n=e[r]()}return n};o.getIndexInAssociation=function(e,t,n){return this.getAssociationInstances(t,n).indexOf(e)};o.getAssociationInstances=function(e,t){var n=g.castArray(this.getAssociation(e,t));return n.map(function(e){return this.getElementInstance(e)},this)};o.hasInterface=function(e,t){var n=e.getMetadata().getInterfaces();return n.indexOf(t)!==-1};o.isElementInTemplate=function(e){var t=o.getAggregationInformation(e);if(t.templateId){var n=o.extractTemplateId(t);if(!n){return false}}return true};o.isElementDirectTemplateChild=function(e){var t=o.getAggregationInformation(e);if(t.templateId){var n=o.extractTemplateId(t);if(n&&t.stack.length===1){return true}}return false};o.isElementValid=function(e){var t=(e instanceof r||e instanceof n)&&!e.bIsDestroyed&&o.isElementInTemplate(e);return t};o.getParent=function(e){return t.isObjectA(e,"sap.ui.core.Component")?e.oContainer:e.getParent()};o.getLabelForElement=function(e,t){if(!o.isElementValid(e)){throw g.createError("ElementUtil#getLabelForElement","A valid managed object instance should be passed as parameter","sap.ui.dt")}if(typeof t==="function"){return t(e)}function n(e){var t=typeof e.getText==="function"&&e.getText()||typeof e.getLabelText==="function"&&e.getLabelText()||typeof e.getLabel==="function"&&e.getLabel()||typeof e.getTitle==="function"&&e.getTitle()||typeof e.getHeading==="function"&&e.getHeading()||typeof e.getDataSourceLabel==="function"&&e.getDataSourceLabel();if(o.isElementValid(t)){return n(t)}return t}var r=n(e);return typeof r!=="string"?e.getId():r};o.extractTemplateId=function(t){if(e(t)&&t.templateId){if(t.stack.length>1){var n;var i=r.getElementById(t.templateId);var a;var g;for(var s=t.stack.length-2;s>=0;s--){a=t.stack[s].aggregation;g=t.stack[s].index;n=o.getAggregation(i,a)[g];if(!n){return undefined}i=n}return i.getId()}else if(t.stack.length===1){return t.templateId}}else{return undefined}};o.getAggregationInformation=function(e){var t=[];return this._evaluateBinding(e,t)};o._evaluateBinding=function(e,t){var n;var r;var a;var g;var{aAPIParentInfos:s}=e;if(s&&s.length>0){g=s.some(function(t){a=t.parent;n=t.aggregationName;r=o.getAggregation(a,n).indexOf(e);return a.getBinding(n)})}if(!g){a=e.getParent();if(a){n=e.sParentAggregationName;r=o.getAggregation(a,n).indexOf(e)}else{r=-1}}t.push({element:e.getId(),type:e.getMetadata().getName(),aggregation:n,index:r});if(n&&a.getBinding(n)){var u=a.getBindingInfo(n);var f=u&&u.template;return{elementId:a.getId(),aggregation:n,templateId:f?f.getId():undefined,stack:t}}return!a||a instanceof i?{elementId:undefined,aggregation:undefined,templateId:undefined,stack:t}:this._evaluateBinding(a,t)};o.getAggregationBindingTemplate=function(e,t){var n=e&&e.getBindingInfo(t);return n&&n.template};o.adjustIndexForMove=function(e,t,n,r){if(e===t&&n<r&&n>-1){return r-1}return r};o.checkTargetZone=function(e,t,n){var r=e.getGeometry();var i=r&&r.size.height>0&&r.size.width>0;var g=e.getElement();var s=t.getElement();var u=e.getAggregationName();if(!s||!o.isValidForAggregation(g,u,s)){return Promise.resolve(false)}function f(e,t){var n=e.getDomRef();var r=a.isVisible(n);if(!n){return r}var i=t&&t.getDomRef&&t.getDomRef();var g=i?a.isVisible(i):true;return r||g}if(n&&!i||!n&&!f(e,g)||!(g&&g.getVisible&&g.getVisible())||!g.getParent()){return Promise.resolve(false)}return Promise.resolve(true)};return o},true);
//# sourceMappingURL=ElementUtil.js.map