/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Element","sap/ui/dt/MutationObserver","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/ui/dt/ScrollbarSynchronizer","sap/ui/dt/Util","sap/base/Log","sap/ui/dt/util/ZIndexManager"],function(jQuery,e,t,i,r,s,o,n,a,l){"use strict";var h="overlay-container";var d;var c;var y=e.extend("sap.ui.dt.Overlay",{metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},focusable:{type:"boolean",defaultValue:false},isRoot:{type:"boolean",defaultValue:false},isPartOfTemplate:{type:"boolean",defaultValue:false}},associations:{element:{type:"sap.ui.base.ManagedObject"}},aggregations:{children:{type:"sap.ui.dt.Overlay",multiple:true,defaultValue:[]},designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",altTypes:["function","object"],multiple:false}},events:{init:{},initFailed:{},afterRendering:{},beforeDestroy:{},destroyed:{parameters:{}},visibleChanged:{parameters:{visible:"boolean"}},geometryChanged:{},childAdded:{},scrollSynced:{},isRootChanged:{parameters:{value:{type:"boolean"}}},beforeGeometryChanged:{},applyStylesRequired:{parameters:{type:{type:"string"},targetOverlay:{type:"sap.ui.dt.ElementOverlay"}}}}},constructor:function(...t){this._aStyleClasses=this._aStyleClasses.slice(0);this._oScrollbarSynchronizers=new Map;this._aBindParameters=[];e.apply(this,t);if(!this.getElement()){throw n.createError("Overlay#constructor",`Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${n.getObjectType(t[0].element)} was given`)}this.asyncInit().then(function(){if(this._bShouldBeDestroyed){this.fireInitFailed({error:n.createError("Overlay#asyncInit",`ElementOverlay is destroyed during initialization ('${this.getId()}')`)})}else{this._bInit=true;this.fireInit()}}.bind(this)).catch(function(e){var t=n.propagateError(e,"Overlay#asyncInit",`Error initializing overlay (id='${this.getId()}'). Original error: ${n.wrapError(e).message}`);this.fireInitFailed({error:t})}.bind(this));this.attachEventOnce("afterRendering",function(e){var t=jQuery(e.getParameter("domRef"));this._aBindParameters.forEach(function(e){t.on(e.sEventType,e.fnProxy)})},this)},_bInit:false,_bRendered:false,_$DomRef:null,_aStyleClasses:["sapUiDtOverlay"],_bShouldBeDestroyed:false,_aBindParameters:null});y.getOverlayContainer=function(){d||=jQuery("<div></div>").attr("id",h).appendTo("body");return d};y.removeOverlayContainer=function(){if(d){d.remove()}d=undefined};y.getMutationObserver=function(){c||=new t;return c};y.destroyMutationObserver=function(){if(c){c.destroy();c=null}};y.prototype.asyncInit=function(){return Promise.resolve()};y.prototype._getAttributes=function(){return{id:this.getId(),"data-sap-ui":this.getId(),class:this._aStyleClasses.join(" "),tabindex:this.isFocusable()?0:null}};y.prototype._renderChildren=function(){return this.getChildren().map(function(e){return e.isRendered()?e.$():e.render()})};y.prototype.render=function(e){if(this.isRendered()){return this.getDomRef()}this._$DomRef=jQuery("<div></div>").attr(this._getAttributes());this._$Children=jQuery("<div></div>").attr({class:"sapUiDtOverlayChildren"}).appendTo(this._$DomRef);this._$Children.append(this._renderChildren());this._bRendered=true;if(!e){this.fireAfterRendering({domRef:this._$DomRef.get(0)})}return this._$DomRef};y.prototype.isInit=function(){return this._bInit};y.prototype.isRendered=function(){return this._bRendered};y.prototype.isReady=function(){return this.isInit()&&this.isRendered()};y.prototype.addStyleClass=function(e){if(!this.hasStyleClass(e)){this._aStyleClasses.push(e);if(this.isReady()){this.$().addClass(e)}}};y.prototype.hasStyleClass=function(e){return this._aStyleClasses.indexOf(e)!==-1};y.prototype.removeStyleClass=function(e){if(this.hasStyleClass(e)){this._aStyleClasses=this._aStyleClasses.filter(function(t){return t!==e});if(this.isReady()){this.$().removeClass(e)}}};y.prototype.toggleStyleClass=function(e){this[`${this.hasStyleClass(e)?"remove":"add"}StyleClass`](e)};y.prototype.setElement=function(e){if(!this.getElement()){this.setAssociation("element",e);if(this._designTimeMetadataCache){this.setDesignTimeMetadata(this._designTimeMetadataCache);delete this._designTimeMetadataCache}}};y.prototype.destroy=function(...t){if(this.bIsDestroyed){a.error(`FIXME: Do not destroy overlay twice (overlayId = ${this.getId()})!`);return}this.fireBeforeDestroy();e.prototype.destroy.apply(this,t)};y.prototype.exit=function(){this._oScrollbarSynchronizers.forEach(function(e){e.destroy()});this._oScrollbarSynchronizers.clear();this.$().remove();delete this._bInit;delete this._bShouldBeDestroyed;delete this._$DomRef;delete this._oScrollbarSynchronizers;this.fireDestroyed()};y.prototype.setDesignTimeMetadata=function(e){if(!this.getElement()){this._designTimeMetadataCache=e}else{this.setAggregation("designTimeMetadata",e)}};y.prototype.getDomRef=function(){return this.$().get(0)};y.prototype.getChildrenDomRef=function(){return this._$Children.get(0)};y.prototype.$=function(){return this._$DomRef||jQuery()};y.prototype.getAssociatedDomRef=function(){throw new Error("This method is abstract and needs to be implemented")};y.prototype.getElement=function(){return i.getElementInstance(this.getAssociation("element"))};y.prototype.hasFocus=function(){return document.activeElement===this.getDomRef()};y.prototype.focus=function(){this.$().trigger("focus")};y.prototype.setFocusable=function(e){e=!!e;if(this.getFocusable()!==e){this.setProperty("focusable",e);this.toggleStyleClass("sapUiDtOverlayFocusable");this.$().attr("tabindex",e?0:null)}};y.prototype.isFocusable=function(){return this.getFocusable()};y.prototype._getRenderingParent=function(){return this.isRoot()?null:this.getParent().$()};y.prototype.applyStyles=function(e,t){var i;this.fireBeforeGeometryChanged();if(!this.isRendered()||this._bIsBeingDestroyed||this.getShouldBeDestroyed()){return Promise.resolve()}if(this.getVisible()){i=this.getGeometry(!t)}var r=Promise.resolve();if(this.isVisible()){if(i&&i.visible){this._ensureVisibility(this.$());this._setSize(this.$(),i);var s=this._getRenderingParent();if(!this.isRoot()){var o=[];this.getParent()._oScrollbarSynchronizers.forEach(function(e){if(e.isSyncing()){o.push(new Promise(function(t){e.attachEventOnce("synced",t);e.attachEventOnce("destroyed",t)}))}});if(o.length){r=Promise.all(o).then(function(){return this._applySizes(i,s,e)}.bind(this))}else{r=this._applySizes(i,s,e)}}else{r=this._applySizes(i,s,e)}}else{this.$().css("display","none")}}else{this.$().css("display","none")}return r.catch(function(e){a.error(n.createError("Overlay#applyStyles",`An error occurred during applySizes calculation: ${e}`))}).then(function(){this.fireGeometryChanged()}.bind(this))};y.prototype._applySizes=function(e,t,i){this._setPosition(this.$(),e,t,i);if(e.domRef){this._setZIndex(e,this.$())}var r=this.getChildren().filter(function(e){return e.isRendered()}).map(function(e){var t={};t.bForceScrollbarSync=i;return new Promise(function(i){e.attachEventOnce("geometryChanged",i);e.fireApplyStylesRequired(t)})});return Promise.all(r)};y.prototype._setZIndex=function(e,t){var i=e.domRef;var r=s.getZIndex(i);if(n.isInteger(r)){t.css("z-index",r)}else if(this.isRoot()){this._iZIndex||=l.getZIndexBelowPopups();t.css("z-index",this._iZIndex)}};y.prototype._ensureVisibility=function(e){e.css("display","block")};y.prototype._setSize=function(e,t){var i=t.size;e.css("width",`${i.width}px`);e.css("height",`${i.height}px`)};y.prototype._setPosition=function(e,t,i){var r=s.getOffsetFromParent(t,i?i.get(0):null);e.css("transform",`translate(${r.left}px, ${r.top}px)`)};y.prototype._setClipPath=function(e,t){var i=t.css("clip-path");e.css("clip-path",i)};y.prototype.attachBrowserEvent=function(e,t,i){if(e&&typeof e==="string"){if(typeof t==="function"){this._aBindParameters||=[];i||=this;var r=t.bind(i);this._aBindParameters.push({sEventType:e,fnHandler:t,oListener:i,fnProxy:r});this.$().on(e,r)}}return this};y.prototype.detachBrowserEvent=function(e,t,i){if(e&&typeof e==="string"){if(typeof t==="function"){i||=this;if(this._aBindParameters){var r=this.$();var s;for(var o=this._aBindParameters.length-1;o>=0;o--){s=this._aBindParameters[o];if(s.sEventType===e&&s.fnHandler===t&&s.oListener===i){this._aBindParameters.splice(o,1);r.off(e,s.fnProxy)}}}}}return this};y.prototype._deleteDummyContainer=function(e,t,i){if(this._oDummyScrollContainer.length){var r=this._oScrollbarSynchronizers.get(e.get(0));this._oDummyScrollContainer.remove();this._oDummyScrollContainer=jQuery();r.attachEventOnce("synced",function(){r.destroy();this._oScrollbarSynchronizers.delete(e.get(0));if(t._oScrollbarSynchronizers.size===0&&!t.getChildren().some(function(e){return e._oScrollbarSynchronizers.size>0})){t.removeStyleClass("sapUiDtOverlayWithScrollBar");t.removeStyleClass("sapUiDtOverlayWithScrollBarVertical");t.removeStyleClass("sapUiDtOverlayWithScrollBarHorizontal")}}.bind(this));r.sync(i,true)}};y.prototype._handleOverflowScroll=function(e,t,i,r){var n=e.domRef;var a=e.size;var l=s.getOverflows(n);t.css("overflow-x",l.overflowX);t.css("overflow-y",l.overflowY);var h=n.scrollHeight;var d=n.scrollWidth;this._oDummyScrollContainer=t.find("> .sapUiDtDummyScrollContainer");if(h>Math.ceil(a.height)||d>Math.ceil(a.width)){var c;if(!this._oDummyScrollContainer.length){this._oDummyScrollContainer=jQuery("<div class='sapUiDtDummyScrollContainer'></div>");this._oDummyScrollContainer.height(h);this._oDummyScrollContainer.width(d);if(i&&s.hasVerticalScrollBar(n)&&i._hasSameSize(e,"height")){i.addStyleClass("sapUiDtOverlayWithScrollBar");i.addStyleClass("sapUiDtOverlayWithScrollBarVertical")}if(i&&s.hasHorizontalScrollBar(n)&&i._hasSameSize(e,"width")){i.addStyleClass("sapUiDtOverlayWithScrollBar");i.addStyleClass("sapUiDtOverlayWithScrollBarHorizontal")}t.append(this._oDummyScrollContainer);c=new o({synced:this.fireScrollSynced.bind(this)});c.addTarget(n,t.get(0));this._oScrollbarSynchronizers.set(t.get(0),c)}else{this._oDummyScrollContainer.css({height:h,width:d});c=this._oScrollbarSynchronizers.get(t.get(0));if(!c.hasTarget(n)){c.addTarget(n)}}if(r){c.sync(n,true)}}else{this._deleteDummyContainer(t,i,n)}};y.prototype.getGeometry=function(e){if(e||!this._mGeometry){var t=this.getAssociatedDomRef();var i;if(t){var o=this.isRoot();i=jQuery.makeArray(t).map(function(e){return s.getGeometry(e,o)})}else{i=this.getChildren().map(function(e){return e.getGeometry(true)})}if(i.length){this._mGeometry=i.length>1?r.getGeometry(i):i[0]}else{delete this._mGeometry}}return this._mGeometry};y.prototype.setVisible=function(e){e=!!e;if(this.getVisible()!==e){this.setProperty("visible",e);this.$().css("visibility",e?"":"hidden");this.fireVisibleChanged({visible:e})}};y.prototype.isVisible=function(){return this.getVisible()&&(this.isRoot()?true:this.getParent().isVisible())};y.prototype.setIsRoot=function(e){e=!!e;if(this.getIsRoot()!==e){this.setProperty("isRoot",e);this.fireIsRootChanged({value:e})}};y.prototype.isRoot=function(){return this.getIsRoot()};y.prototype.getShouldBeDestroyed=function(){return this._bShouldBeDestroyed};return y});
//# sourceMappingURL=Overlay.js.map