//@ui5-bundle sap/ui/dt/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/AggregationDesignTimeMetadata", ["sap/ui/dt/DesignTimeMetadata"],function(t){"use strict";var e=t.extend("sap.ui.dt.AggregationDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});e.prototype.getLabel=function(...e){const[,a]=e;return t.prototype.getLabel.apply(this,e)||a};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/AggregationOverlay", ["sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/base/util/merge"],function(e,t,i,r,n){"use strict";var a=e.extend("sap.ui.dt.AggregationOverlay",{metadata:{library:"sap.ui.dt",properties:{aggregationName:{type:"string"},targetZone:{type:"boolean",defaultValue:false},scrollContainerId:{type:"int"}},events:{targetZoneChange:{parameters:{targetZone:{type:"boolean"}}}}}});a.prototype._getAttributes=function(...t){return n({},e.prototype._getAttributes.apply(this,t),{"data-sap-ui-dt-aggregation":this.getAggregationName()})};a.prototype._getChildIndex=function(e){var t=this.getChildren();var i;var r=t.indexOf(e)-1;while(r>0){i=t[r];if(i.isRendered()){break}r--}return r<0?0:r+1};a.prototype.insertChild=function(e,n){if(!r.isInteger(e)){e=this.isAssociation()?t.getIndexInAssociation:i.getIndexInAggregation(n.getElement(),this.getElement(),this.getAggregationName())}var a=this.indexOfAggregation("children",n);if(a!==e){if(a>-1){this.removeAggregation("children",n)}this.insertAggregation("children",n,e);if(this.isRendered()){var o=this._getChildIndex(n);var g=n.isRendered();if(!g){var s=n.render(true);s=s.jquery?s.get(0):s}var d=g?n.getDomRef():s;var l=this.getChildrenDomRef().children;var h=[].indexOf.call(l,d);var p;if(h!==o){if(o>0){p=h>-1&&h<o?o:o-1;l[p].after(d)}else{p=o;this.getChildrenDomRef().prepend(d)}}if(!g){n.fireAfterRendering({domRef:d})}}this.fireChildAdded();return true}return false};a.prototype.addChild=function(e,t){this.insertChild(this.getChildren().length,e);if(!t){this.fireChildAdded()}};a.prototype.render=function(...t){if(this.getChildren().length>0||this.getDesignTimeMetadata().getDomRef()){this.addStyleClass("sapUiDtAggregationOverlay");return e.prototype.render.apply(this,t)}return undefined};a.prototype._getRenderingParent=function(...t){if(r.isInteger(this.getScrollContainerId())){return this.getParent().getScrollContainerById(this.getScrollContainerId())}return e.prototype._getRenderingParent.apply(this,t)};a.prototype._setPosition=function(...t){const[,i,,n]=t;e.prototype._setPosition.apply(this,t);if(i.domRef&&!r.isInteger(this.getScrollContainerId())){this._handleOverflowScroll(i,this.$(),this.getParent(),n)}};a.prototype.getAssociatedDomRef=function(){var e=this.getElement();var t=this.getAggregationName();var i=this.getDesignTimeMetadata();return i.getAssociatedDomRef(e,i.getDomRef(),t)};a.prototype.setTargetZone=function(e){if(this.getTargetZone()!==e){this.setProperty("targetZone",e);this.toggleStyleClass("sapUiDtOverlayTargetZone",e);this.fireTargetZoneChange({targetZone:e})}return this};a.prototype.isTargetZone=function(){return this.getTargetZone()};a.prototype.isAssociation=function(){return!!this.getDesignTimeMetadata().getData().aggregationLike};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/ControlObserver", ["sap/ui/dt/ManagedObjectObserver"],function(e){"use strict";var t=e.extend("sap.ui.dt.ControlObserver",{metadata:{library:"sap.ui.dt",properties:{},associations:{target:{type:"sap.ui.core.Control"}}}});t.prototype.init=function(...t){e.prototype.init.apply(this,t);this._oControlDelegate={onAfterRendering:this._onAfterRendering}};t.prototype.observe=function(...t){const[o]=t;e.prototype.observe.apply(this,t);o.addEventDelegate(this._oControlDelegate,this)};t.prototype.unobserve=function(...t){var o=this.getTargetInstance();if(o){o.removeDelegate(this._oControlDelegate,this)}e.prototype.unobserve.apply(this,t)};t.prototype._onAfterRendering=function(){this.fireModified({type:"afterRendering"})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/DOMUtil", ["sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/dom/jquery/zIndex","sap/ui/dom/jquery/scrollLeftRTL"],function(e,t,jQuery,r){"use strict";var o={};o.getOffset=function(e){var t=e.getBoundingClientRect();var r=document.documentElement;return{top:t.top+window.scrollY-r.clientTop,left:t.left+window.scrollX-r.clientLeft}};o.getParents=function(e,t){var r=[];while((e=e.parentNode)&&e!==document){if(!t||e.matches(t)){r.unshift(e)}}return r};o.getSize=function(e){var t=e.getBoundingClientRect();return{width:t.width,height:t.height}};o.getOffsetFromParent=function(t,n){var l=n?n.scrollTop:null;var i=n?o.getScrollLeft(n):null;var a=n?this.getOffset(n):null;var s={left:t.position.left,top:t.position.top};if(a){s.left-=a.left-(i||0);s.top-=a.top-(l||0)}if(e.getRTL()){var f=n?n.offsetWidth:window.innerWidth;if(r.browser.safari&&!r.browser.mobile&&o.hasVerticalScrollBar(n)){s.left-=o.getScrollbarWidth()}s.left=s.left-(f-t.size.width)}return s};o.getScrollLeft=function(t){if(!e.getRTL()||!o.hasHorizontalScrollBar(t)){return t.scrollLeft}var r=jQuery(t).scrollLeftRTL();var n=t.scrollWidth-t.clientWidth;return r-n};o.getZIndex=function(e){let r=null;let o=e;do{r=window.getComputedStyle(o).getPropertyValue("z-index");o=o.parentElement;if(!o||o.id&&t.getElementById(o.id)){break}}while(isNaN(r));return isNaN(r)?r:+r};o._getElementDimensions=function(e,t,r){var o=e[0]||e;var n=o[`offset${t}`];var l=0;for(var i=0;i<2;i++){var a=window.getComputedStyle(o,null)[`border${r[i]}${t}`];l-=a?parseInt(a.slice(0,-2)):0}return n+l};o._getElementWidth=function(e){return o._getElementDimensions(e,"Width",["Right","Left"])};o._getElementHeight=function(e){return o._getElementDimensions(e,"Height",["Top","Bottom"])};o.hasVerticalScrollBar=function(e){if(e){var t=window.getComputedStyle(e)["overflow-y"]==="auto"||window.getComputedStyle(e)["overflow-y"]==="scroll";return t&&e.scrollHeight>o._getElementHeight(e)}return false};o.hasHorizontalScrollBar=function(e){if(e){var t=window.getComputedStyle(e)["overflow-x"]==="auto"||window.getComputedStyle(e)["overflow-x"]==="scroll";return t&&e.scrollWidth>o._getElementWidth(e)}return false};o.hasScrollBar=function(e){return o.hasVerticalScrollBar(e)||o.hasHorizontalScrollBar(e)};o.getScrollbarWidth=function(){if(typeof o.getScrollbarWidth._cache==="undefined"){var e=document.createElement("div");e.style.position="absolute";e.style.top="-9999px";e.style.left="-9999px";e.style.width="100px";document.body.append(e);var t=e.offsetWidth;e.style.overflow="scroll";var r=document.createElement("div");r.style.width="100%";e.append(r);var n=r.offsetWidth;e.remove();o.getScrollbarWidth._cache=t-n}return o.getScrollbarWidth._cache};o.getOverflows=function(e){return{overflowX:window.getComputedStyle(e)["overflow-x"],overflowY:window.getComputedStyle(e)["overflow-y"]}};o.getGeometry=function(e,t){if(e){var r=this.getOffset(e);if(t){r.left=r.left-window.scrollX;r.top=r.top-window.scrollY}return{domRef:e,size:this.getSize(e),position:r,visible:this.isVisible(e)}}return undefined};o.syncScroll=function(e,t){var r=t.scrollTop;var o=t.scrollLeft;var n=e.scrollTop;var l=e.scrollLeft;if(n!==r){t.scrollTop=n}if(l!==o){t.scrollLeft=l}};o.getDomRefForCSSSelector=function(e,t){if(t&&e){var r=jQuery(e);if(t===":sap-domref"){return r}if(t.indexOf(":sap-domref")>-1){return r.find(t.replace(/:sap-domref/g,""))}return r.find(t)}return jQuery()};o.isVisible=function(e){if(e){var t=e.getBBox&&e.getBBox();var r=t?t.width:e.offsetWidth;var o=t?t.height:e.offsetHeight;return r>0&&o>0}return false};o.setDraggable=function(e,t){e.setAttribute("draggable",t)};o.getDraggable=function(e){switch(e.getAttribute("draggable")){case"true":return true;case"false":return false;default:return undefined}};o._copyStylesTo=function(e,t){var r="";var o="";var n=e.length;for(var l=0;l<n;l++){o=e[l];r=`${r+o}:${e.getPropertyValue(o)};`}t.style.cssText=r};o._copyPseudoElement=function(e,t,r){var n=window.getComputedStyle(t,e);var l=n.getPropertyValue("content");if(l&&l!=="none"){l=String(l).trim();if(l.indexOf("attr(")===0){l=l.replace("attr(","");if(l.length){l=l.substring(0,l.length-1)}l=t.getAttribute(l)||""}var i=jQuery("<span></span>");if(e===":after"){i.appendTo(r)}else{i.prependTo(r)}i.text(l.replace(/(^['"])|(['"]$)/g,""));o._copyStylesTo(n,i.get(0));i.css("display","inline")}};o.copyComputedStyle=function(e,t){var r=window.getComputedStyle(e);if(r.getPropertyValue("display")==="none"){t.style.display="none";return}o._copyStylesTo(r,t);this._copyPseudoElement(":after",e,t);this._copyPseudoElement(":before",e,t)};o.copyComputedStyles=function(e,t){for(var r=0;r<e.children.length;r++){this.copyComputedStyles(e.children[r],t.children[r])}t.removeAttribute("class");t.setAttribute("id","");t.setAttribute("role","");t.setAttribute("data-sap-ui","");t.setAttribute("for","");t.setAttribute("tabindex",-1);this.copyComputedStyle(e,t)};o.cloneDOMAndStyles=function(e,t){var r=e.cloneNode(true);this.copyComputedStyles(e,r);t.append(r)};o.contains=function(e,t){var r=document.getElementById(e);return!!r&&r.contains(t)};o.appendChild=function(e,t){var r=t.scrollTop;var o=t.scrollLeft;e.appendChild(t);t.scrollTop=r;t.scrollLeft=o};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/DesignTime", ["sap/base/util/restricted/_curry","sap/base/util/restricted/_difference","sap/base/util/includes","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/AggregationOverlay","sap/ui/dt/DesignTimeStatus","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementOverlay","sap/ui/dt/ElementUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/SelectionManager","sap/ui/dt/SelectionMode","sap/ui/dt/TaskManager","sap/ui/dt/TaskRunner","sap/ui/dt/Util"],function(e,t,a,r,n,i,s,o,l,g,d,c,h,y,u,p,m,v,f,E,O,_,b,S){"use strict";var I=l.extend("sap.ui.dt.DesignTime",{metadata:{library:"sap.ui.dt",properties:{designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},addPlugin:{parameters:{plugin:{type:"sap.ui.dt.Plugin"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayAdded:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayMoved:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayEditableChanged:{parameters:{id:{type:"string"},elementId:{type:"string"},editable:{type:"boolean"}}},elementPropertyChanged:{parameters:{id:{type:"string"},name:{type:"string"},oldValue:{type:"any"},value:{type:"any"}}},syncing:{},synced:{},syncFailed:{}}},constructor:function(...e){this._sStatus=c.SYNCED;this._mPendingOverlays={};this._oTaskManager=new _({complete:function(e){if(e.getSource().isEmpty()){this._registerElementOverlays();if(this._oTaskManager.isEmpty()&&this._sStatus!==c.SYNCED){this._sStatus=c.SYNCED;setTimeout(function(){if(this._sStatus===c.SYNCED){this.fireSynced()}}.bind(this),0)}}}.bind(this),add:function(e){if(e.getSource().count()===1){this._sStatus=c.SYNCING;this.fireSyncing()}}.bind(this)});this._oTaskRunner=new b({taskManager:this._oTaskManager,taskType:"applyStyles"}).run();this._oSelectionManager=new E;this._aOverlaysCreatedInLastBatch=[];l.apply(this,e);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(e){this._createOverlaysForRootElement(e.getParameter("element"))},this);this.getPlugins().forEach(function(e){e.attachEvent("processingStatusChange",this._onProcessingStatusChange,this)},this);this.attachEvent("addPlugin",function(e){var t=e.getParameter("plugin");t.attachEvent("processingStatusChange",this._onProcessingStatusChange,this)},this);this.attachEvent("enabledChanged",function(e){var t=e.getParameter("value");var a=m.getOverlayContainer();a[t?"show":"hide"]();this.getRootElements().forEach(function(e){var a=v.getOverlay(e);a.setVisible(t);if(t){this._oTaskManager.add({type:"applyStyles",callbackFn:a.applyStyles.bind(a,true),overlayId:a.getId()})}}.bind(this))},this)}});I.prototype._onProcessingStatusChange=function(e){if(e.getParameter("processing")){this._oTaskManager.add({type:"pluginInProcess",plugin:e.getSource().getMetadata().getName()})}else{this._oTaskManager.completeBy({type:"pluginInProcess",plugin:e.getSource().getMetadata().getName()})}};I.prototype._onApplyStylesRequired=function(e){var t=e.getParameters();var a=e.getSource();this._oTaskManager.add({type:"applyStyles",callbackFn:a.applyStyles.bind(a,t.bForceScrollbarSync,t.bSkipForceCalculation),overlayId:a.getId()},"overlayId")};I.prototype._removeOverlayFromSyncingBatch=function(e){var t=this._aOverlaysCreatedInLastBatch.indexOf(e);if(t!==-1){this._aOverlaysCreatedInLastBatch.splice(t,1)}};I.prototype._registerElementOverlays=function(){var e=this._aOverlaysCreatedInLastBatch.slice();if(!e.length){return}this._aOverlaysCreatedInLastBatch=[];var t=this._oTaskManager.add({type:"registerElementOverlays"});var a=this.getPlugins();e.forEach(function(e){v.register(e);e.attachBeforeDestroy(function(e){v.deregister(e.getSource())})});e.forEach(function(e){a.forEach(function(t){try{t.callElementOverlayRegistrationMethods(e)}catch(r){var a=S.propagateError(r,"DesignTime#_registerElementOverlays",`registerElementOverlay() method of the plugin ${t.getMetadata().getName()} has failed for overlay with id='${e.getId()}' (element id='${e.getElement().getId()}')`);o.error(S.errorToString(a))}})},this);e.forEach(function(e){try{this.fireElementOverlayCreated({elementOverlay:e})}catch(a){var t=S.propagateError(a,"DesignTime#_registerElementOverlays",`One of the listeners of elementOverlayCreated event failed while processing the overlay with id='${e.getId()}' for element with id='${e.getElement().getId()}'`);o.error(S.errorToString(t))}},this);this._oTaskManager.complete(t)};I.prototype.exit=function(){this._bDestroyPending=true;this.getPlugins().forEach(function(e){e.destroy()});this._oSelectionManager.destroy();this._oTaskManager.destroy();this._destroyAllOverlays();this._aOverlaysCreatedInLastBatch=[];delete this._bDestroyPending};I.prototype.getSelectionManager=function(){return this._oSelectionManager};I.prototype.getPlugins=function(){return this.getAggregation("plugins")||[]};I.prototype.getBusyPlugins=function(){return this.getPlugins().filter(function(e){return e.isBusy()})};I.prototype.waitForBusyPlugins=function(){var e=this.getBusyPlugins();return Promise.all(e.map(function(e){return e.waitForBusyAction()}))};I.prototype.addPlugin=function(e){this.addAggregation("plugins",e);this.fireAddPlugin({plugin:e});e.setDesignTime(this);return this};I.prototype.insertPlugin=function(e,t){this.insertAggregation("plugins",e,t);this.fireAddPlugin({plugin:e});e.setDesignTime(this);return this};I.prototype.removePlugin=function(e){this.getPlugins().forEach(function(t){if(t===e){e.setDesignTime(null);e.detachEvent("processingStatusChange",this._onProcessingStatusChange,this)}}.bind(this));this.removeAggregation("plugins",e);return this};I.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(e){e.setDesignTime(null);e.detachEvent("processingStatusChange",this._onProcessingStatusChange,this)}.bind(this));this.removeAllAggregation("plugins");return this};I.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(e){return u.getElementInstance(e)})};I.prototype.getDesignTimeMetadataFor=function(e){var t;if(typeof e==="string"){t=e;o.error("sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance")}else{t=e.getMetadata().getName()}return(this.getDesignTimeMetadata()||{})[t]};I.prototype.addRootElement=function(e){this.addAssociation("rootElements",e);this.fireAddRootElement({element:e})};I.prototype._createOverlaysForRootElement=function(e){var t=this._oTaskManager.add({type:"createOverlay",element:e,root:true});this.createOverlay({element:u.getElementInstance(e),root:true,visible:this.getEnabled()}).then(function(e){m.getOverlayContainer().append(e.render());this._oTaskManager.add({type:"applyStyles",callbackFn:e.applyStyles.bind(e),overlayId:e.getId()},"overlayId");this._oTaskManager.complete(t);return e}.bind(this),function(a){var r=S.propagateError(a,"DesignTime#_createOverlaysForRootElement",`Initialization failed for root element with id '${e.getId()}'`);o.error(S.errorToString(r));this._oTaskManager.cancel(t);this.fireSyncFailed({error:r})}.bind(this))};I.prototype.removeRootElement=function(e){this.removeAssociation("rootElements",e);this._destroyOverlaysForElement(u.getElementInstance(e));return this};I.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this};I.prototype.getElementOverlays=function(){var e=[];this._iterateRootElements(function(t){e=e.concat(this._getAllElementOverlaysIn(t))},this);return e};function T(e,t){if(e){t.setIsRoot(true)}}I.prototype.createOverlay=function(e){var t=Object.assign({},n(e)?e:{element:e});var a=this._oTaskManager.add({type:"createOverlay"});if(!t.element||!u.isElementValid(t.element)){this._oTaskManager.cancel(a);return this._rejectCreateOverlay(t.element)}var r=t.element.getId();var i=v.getOverlay(r);if(i){T(t.root,i);this._oTaskManager.complete(a);return Promise.resolve(i)}else if(r in this._mPendingOverlays){this._oTaskManager.complete(a);return this._mPendingOverlays[r]}if(typeof t.root==="undefined"){t.root=true}this._mPendingOverlays[r]=this._createElementOverlay(t).then(function(e){return this._createChildren(e,t).then(function(){this.attachEventOnce("synced",function(){delete this._mPendingOverlays[r]},this);if(this.bIsDestroyed){e.detachEvent("destroyed",this._onElementOverlayDestroyed,this);e.destroy();this._oTaskManager.cancel(a);return Promise.reject(S.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"))}else if(e.bIsDestroyed){this._oTaskManager.cancel(a);return Promise.reject(S.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"))}this._aOverlaysCreatedInLastBatch.push(e);this._oTaskManager.complete(a);return e}.bind(this))}.bind(this)).catch(function(e){var t=S.propagateError(e,"DesignTime#createOverlay",`Failed attempt to create overlay for element '${r}'`);delete this._mPendingOverlays[r];this._oTaskManager.cancel(a);return Promise.reject(t)}.bind(this));return this._mPendingOverlays[r]};I.prototype._rejectCreateOverlay=function(e){var t;if(!e){t="Cannot create overlay — no element is specified."}else if(e.bIsDestroyed){t="Cannot create overlay — the element is already destroyed."}else if(e instanceof l&&!u.isElementInTemplate(e)){t=`Element is in a bound aggregation, but not found in the binding template. Skipping overlay creation for element with id='${e.getId()}'. Please report to CA-UI5-FL-RTA component.`}else{t=`Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${S.getObjectType(e)} was given`}return Promise.reject(S.createError("DesignTime#createOverlay",t))};I.prototype._createAggregationOverlay=function(e,t,a,r){return new d({aggregationName:e,element:t,visible:!r,isPartOfTemplate:r,designTimeMetadata:new g({data:a}),init:function(e){var t=e.getSource();t.attachEvent("destroyed",this._onAggregationOverlayDestroyed,this);t.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this)}.bind(this),beforeDestroy:function(e){var t=e.getSource();v.deregister(t);t.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this)}.bind(this)})};I.prototype._createElementOverlay=function(t){var a=t.element;function r(e){return new y(e)}return new Promise(function(n,o){r({element:a,isRoot:t.root,visible:typeof t.visible!=="boolean"||t.visible,isPartOfTemplate:t.isPartOfTemplate,metadataScope:this.getScope(),designTimeMetadata:this.getDesignTimeMetadataFor(a)instanceof h?this.getDesignTimeMetadataFor(a):e(function(e,t,a,r){r=i({},r,e);this._mMetadataOriginal=r;if(t){r=p.propagateMetadataToElementOverlay(r,t,a)}return r})(this.getDesignTimeMetadataFor(a),t.parentMetadata,a),init:function(e){var t=e.getSource();n(e.getSource());t.attachEvent("destroyed",this._onElementOverlayDestroyed,this);t.attachEvent("elementDestroyed",this._onElementDestroyed,this);t.attachEvent("selectionChange",this._onElementOverlaySelectionChange,this);t.attachEvent("elementModified",this._onElementModified,this);t.attachEvent("editableChange",this._onEditableChanged,this);t.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this);if(s.get(["actions","actionsFromResponsibleElement"],t.getDesignTimeMetadata().getData())){var a=this.getSelectionManager().getConnectedElements();var r=t.getElement();var i=t.getDesignTimeMetadata().getResponsibleElement(r);a[r.getId()]=i.getId();a[i.getId()]=r.getId();this.getSelectionManager().setConnectedElements(a)}}.bind(this),initFailed:function(e,t){var a=t.getSource();var r=S.propagateError(t.getParameter("error"),"DesignTime#_createElementOverlay",`Error creating overlay (id='${a.getId()}') for '${e}'`);a.detachEvent("destroyed",this._onElementOverlayDestroyed,this);a.detachEvent("elementDestroyed",this._onElementDestroyed,this);a.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this);a.destroy();o(r)}.bind(this,a.getId())})}.bind(this))};function M(e,t){var a=e.getElement();return t.reduce(function(e,t){var r=u.getAggregationBindingTemplate(a,t);if(r){e[t]=r}return e},{})}I.prototype._createChildren=function(e,a){var n=e.getAggregationNames();var i=a.parentMetadata;var s=M(e,n);var o=Object.keys(s);var l=a.isPartOfTemplate!==undefined;var g=!r(s);var d=g&&!l;var c=d?true:a.isPartOfTemplate;var h=d?false:a.isPartOfTemplate;if(g&&c&&!d){n=t(n,o)}return this._createChildrenOverlays(e,i,o,c,s).then(this._createChildrenOverlays.bind(this,e,i,n,h))};I.prototype._createChildrenOverlays=function(e,t,a,n,i){var s=!r(i);if(s&&!n){return Promise.resolve()}return Promise.all(a.map(function(a){var r=e.getElement();var l=r.getMetadata().getName();var g=p.propagateMetadataToAggregationOverlay(e.getDesignTimeMetadata().getAggregation(a),r,t);var d=this._createAggregationOverlay(a,r,g,s);v.register(d);var c;if(s){c=[i[a]]}else{c=u[d.isAssociation()?"getAssociationInstances":"getAggregation"](r,a)}return Promise.all(c.map(function(t,i){return this.createOverlay({element:i,root:false,parentMetadata:g,isPartOfTemplate:n}).catch(function(n){var s=this._enrichChildCreationError(n,i,t,a);if(!r.isDestroyed()&&!e.isDestroyed()){o[s.severity](s.message)}return s.errorObject}.bind(this))}.bind(this,l))).then(function(e){e.map(function(e){if(e instanceof y&&!e.bIsDestroyed&&!e.getParent()){d.addChild(e,true)}},this);return d}.bind(this))},this)).then(function(t){t.forEach(function(t){if(e.bIsDestroyed){t.destroy()}else if(s){e.addAggregationBindingTemplateOverlay(t)}else{e.addChild(t,true)}})})};I.prototype._enrichChildCreationError=function(e,t,a,r){var n="error";var i=S.errorToString(e);if(e.message.includes("Cannot create overlay without a valid element")){n="warning";e=S.createError("DesignTime#_createChildren",`Child element in aggregation '${r}' of ${a} must be a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${S.getObjectType(t)} was given. Consider ignoring aggregation ${r} in the .designtime configuration of the control.`);i=e.toString()}else if(e.message.startsWith("Element is in a bound aggregation")){n="error";i=e.toString()}return{errorObject:e,severity:n,message:i}};I.prototype._destroyOverlaysForElement=function(e){var t=v.getOverlay(e);if(t){t.destroy()}};I.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(e){this._destroyOverlaysForElement(e)},this)};I.prototype._onElementOverlayDestroyed=function(e){if(this._bDestroyPending){return}var t=e.getSource();this._oTaskManager.cancelBy({type:"applyStyles",overlayId:t.getId()},"overlayId");this._removeOverlayFromSyncingBatch(t);var a=t.getAssociation("element");if(a in this._mPendingOverlays){delete this._mPendingOverlays[a];return}if(!v.hasOverlays()){m.destroyMutationObserver();m.removeOverlayContainer()}if(t.isSelected()){this.getSelectionManager().remove(t)}this.fireElementOverlayDestroyed({elementOverlay:t})};I.prototype._onElementDestroyed=function(e){var t=e.getParameter("targetId");this.removeRootElement(t)};I.prototype._onAggregationOverlayDestroyed=function(e){this._oTaskManager.cancelBy({type:"applyStyles",overlayId:e.getSource().getId()},"overlayId");if(!v.hasOverlays()){m.removeOverlayContainer()}};I.prototype._onElementOverlaySelectionChange=function(e){var t=e.getSource();var r=e.getParameter("selected");if(r){if(this.getSelectionManager().getSelectionMode()===O.Multi){this.getSelectionManager().add(t)}else{this.getSelectionManager().set(t)}if(!a(this.getSelectionManager().get(),t)){t.setSelected(false)}}else{this.getSelectionManager().remove(t)}};I.prototype._onElementModified=function(e){var t=i({},e.getParameters());var a=e.getSource();t.type=!t.type?e.getId():t.type;switch(t.type){case"addOrSetAggregation":case"insertAggregation":this._onAddAggregation(t.value,t.target,t.name);break;case"setParent":setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(t.target)}}.bind(this),0);break;case"propertyChanged":t.id=e.getSource().getId();delete t.type;delete t.target;if(this.getStatus()===c.SYNCING){this.attachEventOnce("synced",t,function(...e){if(!a.bIsDestroyed){this.fireElementPropertyChanged(e[1])}},this)}else{this.fireElementPropertyChanged(t)}break;default:break}};I.prototype._onEditableChanged=function(e){var t=i({},e.getParameters());var a=e.getSource();t.id=a.getId();if(this.getStatus()===c.SYNCING){this.attachEventOnce("synced",t,function(...e){if(!a.bIsDestroyed){this.fireElementOverlayEditableChanged(e[1])}},this)}else{this.fireElementOverlayEditableChanged(t)}};I.prototype._onAddAggregation=function(e,t,a){if(u.isElementValid(e)){var r=v.getOverlay(t);var n=r&&r.getAggregationOverlay(a);if(!n){var i=function(r){var n=r.getParameter("elementOverlay");if(n.getElement().getId()===t.getId()){var s=n.getAggregationOverlay(a);this.detachElementOverlayCreated(i,this);this._addAggregation(e,s)}};this.attachElementOverlayCreated(i,this)}else{this._addAggregation(e,n)}}};I.prototype._addAggregation=function(e,t){var a=v.getOverlay(e);if(!a&&t&&t.getElement()){var r=this._oTaskManager.add({type:"createChildOverlay",element:e});this.createOverlay({element:e,root:false,parentMetadata:t.getDesignTimeMetadata().getData()}).then(function(e){var a=t.insertChild(null,e);if(a===true){this._oTaskManager.add({type:"applyStyles",callbackFn:e.applyStyles.bind(e),overlayId:e.getId()},"overlayId");var n=t.indexOfAggregation("children",e);this.attachEventOnce("synced",e,function(){if(!e.bIsDestroyed){this.fireElementOverlayAdded({id:e.getId(),targetIndex:n,targetId:t.getId(),targetAggregation:t.getAggregationName()})}},this)}this._oTaskManager.complete(r)}.bind(this)).catch(function(a,n,i){this._oTaskManager.cancel(r);var s=S.propagateError(i,"DesignTime#_onAddAggregation",`Failed to add new element overlay (elementId='${a}') into aggregation overlay (id='${n}')`);if(!e.bIsDestroyed&&!t.bIsDestroyed){o.error(S.errorToString(s))}}.bind(this,e.getId(),t.getId()))}else{if(a&&!this._isElementInRootElements(a)&&a.isRoot()){a.setIsRoot(false)}if(t){t.insertChild(null,a)}else{o.error("No parentAggregationOverlay exists during addAggregation");return}a.setDesignTimeMetadata(p.propagateMetadataToElementOverlay(a._mMetadataOriginal,t.getDesignTimeMetadata().getData(),e));this.fireElementOverlayMoved({id:a.getId(),targetIndex:t.indexOfAggregation("children",a),targetId:t.getId(),targetAggregation:t.getAggregationName()})}};I.prototype._checkIfOverlayShouldBeDestroyed=function(e){var t=v.getOverlay(e);if(!e.bIsDestroyed&&t&&(!this._isElementInRootElements(e)||e.sParentAggregationName==="dependents")){t.destroy()}};I.prototype._isElementInRootElements=function(e){var t=false;this._iterateRootElements(function(a){if(u.hasAncestor(e,a)){t=true;return false}return undefined});return t};I.prototype._iterateRootElements=function(e,t){var a=this.getRootElements();a.forEach(function(a){var r=u.getElementInstance(a);e.call(t||this,r)},this)};I.prototype._getAllElementOverlaysIn=function(e){var t=[];var a=v.getOverlay(e);if(a){f.iterateOverlayElementTree(a,function(e){if(e.getDesignTimeMetadata()){t.push(e)}})}return t};I.prototype.setEnabled=function(e){e=!!e;if(this.getEnabled()!==e){this.setProperty("enabled",e);this.fireEnabledChanged({value:e})}};I.prototype.getStatus=function(){return this._sStatus};return I});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/DesignTimeMetadata", ["sap/base/util/includes","sap/base/util/merge","sap/base/util/ObjectPath","sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/thirdparty/jquery"],function(t,e,r,a,n,i,o,jQuery){"use strict";function u(t,e){if(typeof t==="function"){t=t(e)}if(typeof t==="string"){return{changeType:t}}return t}var s=a.extend("sap.ui.dt.DesignTimeMetadata",{metadata:{library:"sap.ui.dt",properties:{data:{type:"any",defaultValue:{}}}}});s.prototype.setData=function(t){this.setProperty("data",e({},this.getDefaultData(),t));return this};s.prototype.getDefaultData=function(){return{ignore:false,domRef:undefined}};s.prototype.isIgnored=function(t){var e=this.getData().ignore;if(!e||e&&typeof e==="function"&&!e(t)){return false}return true};s.prototype.markedAsNotAdaptable=function(){var t=this.getData().actions;return t==="not-adaptable"};s.prototype.getDomRef=function(){return this.getData().domRef};s.prototype.getAssociatedDomRef=function(...t){const[e,r,a]=t;if(e){var n=i.getDomRef(e);var u=[];u.push(e);if(a){u.push(a)}if(typeof r==="function"){try{var s=r(...t);return s&&jQuery(s)}catch(t){return undefined}}else if(n&&typeof r==="string"){return o.getDomRefForCSSSelector(n,r)}}return undefined};s.prototype.getAction=function(t,e,a){var n=this.getData();var i=["actions",t];if(a){i.push(a)}return u(r.get(i,n),e)};s.prototype.getCommandName=function(t,r,a){var n=this.getData();var i=e({},a&&n.aggregations[a]?n.aggregations[a].actions:{},n.actions);function o(e){return Object.keys(e).map(function(a){var n=e[a];if(a==="add"&&!n.changeType){return{delegate:"addDelegateProperty",custom:"customAdd"}[o(n)]}try{var i=u(n,r);return i&&i.changeType===t&&a}catch(t){return undefined}}).filter(Boolean)[0]}return o(i)};s.prototype.getLibraryText=function(t,e,r){var a=t.getMetadata();return this._lookForLibraryTextInHierarchy(a,e,r)};s.prototype._lookForLibraryTextInHierarchy=function(t,e,r){var a;var n;var i;a=t.getLibraryName();i=this._getTextFromLibrary(a,e,r);if(!i){n=t.getParent();if(n&&n.getLibraryName){i=this._lookForLibraryTextInHierarchy(n,e,r)}else{i=e}}return i};s.prototype._getTextFromLibrary=function(t,e,r){var a=n.getResourceBundleFor(`${t}.designtime`);if(a&&a.hasText(e)){return a.getText(e,r)}a=n.getResourceBundleFor(t);if(a&&a.hasText(e)){return a.getText(e,r)}return undefined};s.prototype.getLabel=function(...t){var e=this.getData().getLabel;return typeof e==="function"?e.apply(this,t):undefined};s.prototype.getControllerExtensionTemplate=function(){return this.getData().controllerExtensionTemplate};s.prototype.getResponsibleElement=function(t){var e=this.getData();var a=r.get(["actions","getResponsibleElement"],e);if(a){return a(t)}return undefined};s.prototype.isResponsibleActionAvailable=function(e){var a=this.getData();var n=r.get(["actions","actionsFromResponsibleElement"],a);if(n){return t(n,e)}return false};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/DesignTimeStatus", [],function(){"use strict";return{SYNCING:"syncing",SYNCED:"synced"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/ElementDesignTimeMetadata", ["sap/ui/dt/DesignTimeMetadata","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/ElementUtil"],function(t,e,a){"use strict";var r=t.extend("sap.ui.dt.ElementDesignTimeMetadata",{metadata:{library:"sap.ui.dt"}});r.prototype.getDefaultData=function(...e){var a=t.prototype.getDefaultData.apply(this,e);a.aggregations={layout:{ignore:true},dependents:{ignore:true},customData:{ignore:true},layoutData:{ignore:true},tooltip:{ignore:true},dragDropConfig:{ignore:true}};return a};r.prototype.hasAggregation=function(t){return!!this.getAggregations()[t]};r.prototype.getAggregation=function(t){return this.getAggregations()[t]};r.prototype.createAggregationDesignTimeMetadata=function(t){return new e({data:t})};r.prototype.getAggregations=function(){var t=this.getData().aggregations||{};var e=this.getData().associations||{};Object.keys(e).forEach(function(a){var r=e[a];if(r.aggregationLike){t[a]=r}});return t};r.prototype.getAggregationNamesWithAction=function(t){var e=this.getAggregations();return Object.keys(e).filter(function(a){return e[a].actions&&e[a].actions[t]})};r.prototype.getActionDataFromAggregations=function(t,e,a,r){var i;var n=this.getAggregations();var g=[];for(var o in n){if(n[o].actions&&n[o].actions[t]){i=n[o].actions[t];if(r){i=i[r]}if(typeof i==="function"){var s=[e];if(a){s=s.concat(a)}i=i(...s)}if(typeof i==="string"){i={changeType:i}}if(i){i.aggregation=o;g.push(i)}}}return g};r.prototype._getText=function(t,e){if(typeof e==="function"){return e()}return this.getLibraryText(t,e)};r.prototype.getAggregationDescription=function(t,e){var a=this.getAggregation(t).childNames;if(typeof a==="function"){a=a(e)}if(a){return{singular:this._getText(e,a.singular),plural:this._getText(e,a.plural)}}};r.prototype.getAggregationDisplayName=function(t,e){var a=this.getAggregation(t)&&this.getAggregation(t).displayName;if(typeof a==="function"){a=a(e)}if(a){return{singular:this._getText(e,a.singular),plural:this._getText(e,a.plural)}}};r.prototype.getName=function(t){var e=this.getData().name;if(typeof e==="function"){e=e(t)}if(e){return{singular:this._getText(t,e.singular),plural:this._getText(t,e.plural)}}};r.prototype.getToolHooks=function(){return this.getData().tool||{start(){},stop(){}}};r.prototype.isAggregationIgnored=function(t,e){var a=this.getAggregations();var r=a[e];var i=r?r.ignore:false;if(!i||i&&typeof i==="function"&&!i(t)){return false}return true};r.prototype.getScrollContainers=function(t,e,a){var r=this.getData().scrollContainers||[];r.forEach(function(r){if(typeof r.aggregations==="function"){r.aggregationsFunction=r.aggregations;r.aggregations=r.aggregations(t,a)}else if(e&&r.aggregationsFunction){r.aggregations=r.aggregationsFunction(t,a)}});return r};r.prototype.getLabel=function(...e){const[r]=e;return t.prototype.getLabel.apply(this,e)||a.getLabelForElement(r)};r.prototype.getStableElements=function(t){var e=t.getElement();var a;var r=this.getData().getStableElements;if(r){a=r(e)}else{a=[e]}if(!a||!Array.isArray(a)){a=[]}return a};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/ElementOverlay", ["sap/ui/base/Object","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/ControlObserver","sap/ui/dt/ManagedObjectObserver","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/Util","sap/ui/core/Control","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/restricted/_intersection","sap/base/util/restricted/_max"],function(e,t,i,r,a,s,n,o,l,d,h,jQuery,g,p,u,f,c){"use strict";var y="sapUiDtOverlayScrollContainer";var v=t.extend("sap.ui.dt.ElementOverlay",{metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},aggregations:{aggregationBindingTemplateOverlays:{type:"sap.ui.dt.Overlay",multiple:true,defaultValue:[]}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"},ignoreEnterKeyUpOnce:{type:"boolean",defaultValue:false}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},constructor:function(...e){this._aMetadataEnhancers=[];t.apply(this,e)}});v.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this.attachEvent("elementModified",function(e){var t=e.getParameters();var i=t.name;if(t.type==="propertyChanged"){if(i==="visible"){this.setRelevantOverlays([])}}else if(i){this.setRelevantOverlays([])}},this);this._initMutationObserver();this._initControlObserver()}.bind(this))};v.prototype._updateScrollContainer=function(e){if(this.getShouldBeDestroyed()||this.bIsDestroyed){return}var t=e.index;var i=this.getScrollContainerById(t);var r=this.getScrollContainers(true)[t];var a=[].concat(r.aggregations);var s=i.find(">:not(.sapUiDtDummyScrollContainer)").toArray();s.forEach(function(e){var t=e.getAttribute("data-sap-ui-dt-aggregation");if(r.aggregations.includes(t)){a.splice(a.indexOf(t),1)}else{i.get(0).removeChild(e);l.appendChild(this.getChildrenDomRef(),e)}}.bind(this));a.forEach(function(e){var t=this.getAggregationOverlay(e).getDomRef();this.getChildrenDomRef().removeChild(t);l.appendChild(i.get(0),t)}.bind(this))};v.prototype._onRootChanged=function(e){var t=e.getParameter("value");this._subscribeToMutationObserver(t)};v.prototype._initMutationObserver=function(){this._subscribeToMutationObserver(this.isRoot());this.attachEvent("isRootChanged",this._onRootChanged,this)};v.prototype._subscribeToMutationObserver=function(e){var i=t.getMutationObserver();var r=this.getAssociatedDomRef();this._sObservableNodeId=r&&r.get(0)&&r.get(0).id;if(this._sObservableNodeId){i.registerHandler(this._sObservableNodeId,this._domChangedCallback.bind(this),e);if(r.get(0).shadowRoot){i.addNode(r.get(0).shadowRoot)}}else if(e){g.error("sap.ui.dt.ElementOverlay#_subscribeToMutationObserver: please provide a root control with proper domRef and id to ensure that RTA is working properly")}};v.prototype._unsubscribeFromMutationObserver=function(){if(this._sObservableNodeId){var e=t.getMutationObserver();e.deregisterHandler(this._sObservableNodeId);delete this._sObservableNodeId}};v.prototype._initControlObserver=function(){if(this.getElement()instanceof h){this._oObserver=new a({target:this.getElement(),aggregations:this.getAggregationNames()})}else{this._oObserver=new s({target:this.getElement(),aggregations:this.getAggregationNames()})}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this)};v.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy()}};v.prototype._getAttributes=function(...e){return u({},t.prototype._getAttributes.apply(this,e),{"data-sap-ui-dt-for":this.getElement().getId(),draggable:this.getMovable()})};v.prototype.render=function(...e){this.addStyleClass("sapUiDtElementOverlay");return t.prototype.render.apply(this,e)};v.prototype.exit=function(...e){this._unsubscribeFromMutationObserver();this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest)}t.prototype.exit.apply(this,e)};v.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(e){var t=this.getElement();if(!t||t.bIsDestroyed){throw d.createError("ElementOverlay#loadDesignTimeMetadata","Can't set metadata to overlay which element has been destroyed already")}this.setDesignTimeMetadata(e)}.bind(this)).catch(function(e){throw d.propagateError(e,"ElementOverlay#loadDesignTimeMetadata",`Can't load designtime metadata data for overlay with id='${this.getId()}', element id='${this.getAssociation("element")}': ${d.wrapError(e).message}`)}.bind(this))};v.prototype._setPosition=function(...e){const[,,,i]=e;t.prototype._setPosition.apply(this,e);this.getScrollContainers().forEach(function(e,r){var a=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),e.domRef)||jQuery();var s=this.getScrollContainerById(r);if(a.length){var n=a.get(0);var o=l.getGeometry(n);this._ensureVisibility(s);this._setSize(s,o);t.prototype._setPosition.call(this,s,o,this.$());this._handleOverflowScroll(o,s,this,i);this._setZIndex(o,s);this._setClipPath(s,a)}else{s.css("display","none")}},this)};v.prototype._applySizes=function(...e){return t.prototype._applySizes.apply(this,e).then(function(){this._sortChildren(this.getChildrenDomRef());if(!this.bIsDestroyed){this.getScrollContainers().forEach(function(e,t){var i=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),e.domRef)||jQuery();var r=this.getScrollContainerById(t);if(i.length){this._sortChildren(r.get(0))}},this)}}.bind(this))};v.prototype._sortChildren=function(e){function t(e,t){var i=l.getGeometry(e);var r=l.getGeometry(t);var a=i&&i.position;var s=r&&r.position;if(a&&s){var n=a.top+i.size.height;var o=s.top+r.size.height;if(a.top<s.top){if(n>=o&&s.left<a.left){return 1}return-1}else if(a.top===s.top){if(a.left===s.left){if(i.size.height<r.size.height||i.size.width<r.size.width){return-1}else if(i.size.height>r.size.height||i.size.width>r.size.width){return 1}return 0}else if(a.left<s.left){return-1}return 1}else if(n<=o&&s.left>a.left){return-1}return 1}return 0}var i=jQuery(e).find(">:not(.sapUiDtDummyScrollContainer)").toArray();var r=i.slice().sort(t);var a=i.some(function(e,t){return e!==r[t]});if(a){r.forEach(function(t){l.appendChild(e,t)})}};v.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){t.getOverlayContainer().append(this.render());this.applyStyles()}else{g.error("sap.ui.dt.ElementOverlay: overlay is already rendered and can't be placed in overlay container. Isn't it already there?")}}else{g.error("sap.ui.dt.ElementOverlay: it's not possible to place overlay inside overlay container while it's part of some hierarchy")}}else{g.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens')}};v.prototype.setDesignTimeMetadata=function(e){var i=this.getDesignTimeMetadata();var r;if(typeof e==="function"){if(!i){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(e)}else{i.setData(e(u({},i.getData())));return}}else if(e instanceof n){i=e}else if(p(e)){r=e;var a;while(a=this._aMetadataEnhancers.shift()){r=a.call(this,r)}i=new n({data:r})}if(i){t.prototype.setDesignTimeMetadata.call(this,i)}};v.prototype.getScrollContainers=function(e){return this.getDesignTimeMetadata().getScrollContainers(this.getElement(),e,this._updateScrollContainer.bind(this))};v.prototype._renderChildren=function(...e){var i=t.prototype._renderChildren.apply(this,e);this.getScrollContainers().forEach(function(e,t){var r=jQuery("<div></div>",{class:y,"data-sap-ui-dt-scrollContainerIndex":t});if(e.aggregations){f(e.aggregations,this.getAggregationNames()).forEach(function(e){var a=this.getAggregationOverlay(e);var s=i.indexOf(a.$());a.setScrollContainerId(t);r.append(i[s]);i.splice(s,1)},this)}i.push(r)},this);return i};v.prototype.getScrollContainerById=function(e){return jQuery(this.getChildrenDomRef()).find(`>.${y}[data-sap-ui-dt-scrollcontainerindex="${e}"]`)};v.prototype.getAssociatedDomRef=function(){var e=this.getDesignTimeMetadata();var t=e?.getDomRef();var i=e?.getAssociatedDomRef(this.getElement(),t);i||=o.getDomRef(this.getElement());if(i){return jQuery(i)}return undefined};v.prototype.setSelectable=function(e){e=!!e;if(e!==this.isSelectable()){if(!e){this.setSelected(false)}this.toggleStyleClass("sapUiDtOverlaySelectable",e);this.setProperty("selectable",e);this.fireSelectableChange({selectable:e})}this.setFocusable(e);return this};v.prototype.setSelected=function(e){e=!!e;if(this.isSelectable()&&e!==this.isSelected()){this.setProperty("selected",e);this.toggleStyleClass("sapUiDtOverlaySelected",e);var t=r.getClosestBoundControl(this);if(t.overlayId){var a=i.getOverlay(t.overlayId);b(t,a)}this.fireSelectionChange({selected:e})}return this};function b(e,t,i){i=i===undefined?e.stack.length-1:i;var r=e.stack[i];var a=i===0;var s=e.stack.length===1;if(r){t.getChildren().forEach(function(t){if(t.getAggregationName()===r.aggregation){t.getChildren().some(function(t,n){if(a&&s){t.toggleStyleClass("sapUiDtOverlayHighlighted")}else if(a&&n===r.index){t.toggleStyleClass("sapUiDtOverlayHighlighted");return true}else if(!a){b(e,t,i-1)}return undefined})}})}}v.prototype.setMovable=function(e){e=!!e;if(this.getMovable()!==e){this.toggleStyleClass("sapUiDtOverlayMovable",e);this.setProperty("movable",e);this.fireMovableChange({movable:e});this.$()[e?"attr":"removeAttr"]("draggable",e)}return this};v.prototype.setEditable=function(e){e=!!e;if(this.getEditable()!==e){this.toggleStyleClass("sapUiDtOverlayEditable",e);this.setProperty("editable",e);this.fireEditableChange({editable:e})}return this};v.prototype.getAggregationNames=function(){var e=this.getElement();var t=this.getDesignTimeMetadata();var i=e.getMetadata().getAllAggregations();return[].concat(Object.keys(i),Object.keys(t.getAggregations())).filter(function(i,r,a){return r===a.indexOf(i)&&!t.isAggregationIgnored(e,i)})};v.prototype._onChildAdded=function(e){var t=e.getSource();if(this.isRendered()&&!t.isRendered()){var i=d.isInteger(t.getScrollContainerId())?this.getScrollContainerById(t.getScrollContainerId()):jQuery(this.getChildrenDomRef());i.append(t.render())}};v.prototype.addChild=function(...e){const[i]=e;i.detachChildAdded(this._onChildAdded,this);i.attachChildAdded(this._onChildAdded,this);t.prototype.addChild.apply(this,e)};v.prototype._onElementModified=function(e){if(e.getParameters().type==="afterRendering"){this._subscribeToMutationObserver(this.isRoot());this._oScrollbarSynchronizers.forEach(function(e){e.refreshListeners()})}this.fireElementModified(e.getParameters())};v.prototype._domChangedCallback=function(e){e.targetOverlay=this;if(this.isReady()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest)}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.getGeometry(true);e.bSkipForceCalculation=true;this.fireApplyStylesRequired(e);delete this._iApplyStylesRequest}.bind(this))}};v.prototype._onElementDestroyed=function(e){var t=e.getSource().getTarget();this.fireElementDestroyed({targetId:t});if(this._bInit){this.destroy()}else{this._bShouldBeDestroyed=true}};v.prototype.getAggregationOverlay=function(e,t){var i=`get${t||"Children"}`;return this[i]().filter(function(t){return t.getAggregationName()===e}).pop()};v.prototype.getParentElementOverlay=function(){var e=this.getParentAggregationOverlay();if(e){return e.getParent()}return undefined};v.prototype.getParentAggregationOverlay=function(){var t=this.getParent();return e.isObjectA(t,"sap.ui.dt.AggregationOverlay")?t:null};v.prototype.isSelected=function(){return this.getSelected()};v.prototype.isSelectable=function(){return this.getSelectable()};v.prototype.isMovable=function(){return this.getMovable()};v.prototype.isEditable=function(){return this.getEditable()};v.prototype._getElementInstanceVisible=function(){var e=this.getElement();if(e){var t=this.getGeometry();return t&&t.visible}return false};v.prototype.getElementVisibility=function(){var e=this.getElement();if(e instanceof h){return e.getVisible()}var t=this.getDesignTimeMetadata();var i=t&&t.getData().isVisible;if(!i){return undefined}return i(this.getElement())};v.prototype.isElementVisible=function(){var e=this.getElement();var t=false;var i=this.getDesignTimeMetadata();var r=i.getData();if(i.isIgnored(e)){t=false}else if(typeof r.isVisible==="function"){t=r.isVisible(e)}else{var a=this.getGeometry();if(a){t=a.visible}else if(e instanceof h){t=!!e.getDomRef()&&e.getVisible()}}return t};v.prototype.isVisible=function(...e){return t.prototype.isVisible.apply(this,e)&&this.isElementVisible()};v.prototype.getRelevantContainer=function(e){var t=this.getDesignTimeMetadata();if(t&&t.getData().relevantContainer){return t.getData().relevantContainer}else if(e){return this.getElement()}var i=this.getParentElementOverlay();return i?i.getElement():undefined};v.prototype._hasSameSize=function(e,t){var i=this.getScrollContainers();var r;if(i.length){r=c(i.map(function(e,i){var r=l.getGeometry(this.getScrollContainerById(i).get(0));return r.size[t]},this))}else{r=this.getGeometry().size[t]}return e.size[t]===r};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/ElementUtil", ["sap/base/util/isPlainObject","sap/ui/base/Object","sap/ui/core/Component","sap/ui/core/Element","sap/ui/core/UIArea","sap/ui/dt/DOMUtil","sap/ui/dt/Util"],function(e,t,n,r,i,a,g){"use strict";var o={};o.iterateOverAllPublicAggregations=function(e,t){var n=e.getMetadata().getAllAggregations();var r=Object.keys(n);r.forEach(function(r){var i=n[r];var a=this.getAggregation(e,r);t(i,a)},this)};o.getElementInstance=function(e){if(typeof e==="string"){var t=r.getElementById(e);return t||n.getComponentById(e)}return e};o.hasAncestor=function(e,t){t=this.fixComponentContainerElement(t);var n;while(e&&e!==t){n=this.fixComponentParent(e);if(e===n){e=e.getParent()}else{e=n}}return!!e};o.getClosestElementForNode=function(e){var t=e.closest("[data-sap-ui]");return t?r.getElementById(t.getAttribute("data-sap-ui")):undefined};o.fixComponentParent=function(e){if(t.isObjectA(e,"sap.ui.core.UIComponent")){var n=e.oContainer;if(n){return n.getParent()}}else{return e}};o.fixComponentContainerElement=function(e){if(t.isObjectA(e,"sap.ui.core.ComponentContainer")){if(!e.getComponentInstance()){return undefined}return e.getComponentInstance().getRootControl()}return e};o.getDomRef=function(e){if(e){var t;if(e.getDomRef){t=e.getDomRef()}if(!t&&e.getRenderedDomRef){t=e.getRenderedDomRef()}return t}};o.findAllSiblingsInContainer=function(e,t){var n=e&&e.getParent();if(!n){return[]}if(n!==t){var r=o.findAllSiblingsInContainer(n,t);return r.map(function(t){return o.getAggregation(t,e.sParentAggregationName)}).reduce(function(e,t){return e.concat(t)},[])}return o.getAggregation(n,e.sParentAggregationName)};o.getAggregationAccessors=function(e,t){var n=e.getMetadata();n.getJSONKeys();var r=n.getAggregation(t);if(r){var i=r._sGetter;if(r.altTypes&&r.altTypes.length&&e[`${r._sGetter}Control`]){i=`${r._sGetter}Control`}return{get:i,add:r._sMutator,remove:r._sRemoveMutator,insert:r._sInsertMutator,removeAll:r._sRemoveAllMutator}}return{}};o.getAggregation=function(e,t){var n;var r=this.getAggregationAccessors(e,t).get;if(r){n=e[r]()}else{n=e.getAggregation(t)}n=n&&n.splice?n:n?[n]:[];return n};o.getIndexInAggregation=function(e,t,n){return this.getAggregation(t,n).indexOf(e)};o.addAggregation=function(e,t,n){if(this.hasAncestor(e,n)){throw new Error("Trying to add an element to itself or its successors")}var r=this.getAggregationAccessors(e,t).add;if(r){e[r](n)}else{e.addAggregation(t,n)}};o.removeAggregation=function(e,t,n,r){var i=this.getAggregationAccessors(e,t).remove;if(i){e[i](n,r)}else{e.removeAggregation(t,n,r)}};o.insertAggregation=function(e,t,n,r){if(this.hasAncestor(e,n)){throw new Error("Trying to add an element to itself or its successors")}if(this.getIndexInAggregation(n,e,t)!==-1){n.__bSapUiDtSupressParentChangeEvent=true;try{this.removeAggregation(e,t,n,true)}finally{delete n.__bSapUiDtSupressParentChangeEvent}}var i=this.getAggregationAccessors(e,t).insert;if(i){e[i](n,r)}else{e.insertAggregation(t,n,r)}};o.isValidForAggregation=function(e,n,r){var i=e.getMetadata().getAggregation(n);if(this.hasAncestor(e,r)){return false}if(i){var a=i.type;if(i.multiple===false&&this.getAggregation(e,n)&&this.getAggregation(e,n).length>0){return false}return t.isObjectA(r,a)||this.hasInterface(r,a)}};o.getAssociationAccessors=function(e,t){var n=e.getMetadata();n.getJSONKeys();var r=n.getAssociation(t);if(r){return{get:r._sGetter,add:r._sMutator,remove:r._sRemoveMutator,insert:r._sInsertMutator,removeAll:r._sRemoveAllMutator}}return{}};o.getAssociation=function(e,t){var n;var r=this.getAssociationAccessors(e,t).get;if(r){n=e[r]()}return n};o.getIndexInAssociation=function(e,t,n){return this.getAssociationInstances(t,n).indexOf(e)};o.getAssociationInstances=function(e,t){var n=g.castArray(this.getAssociation(e,t));return n.map(function(e){return this.getElementInstance(e)},this)};o.hasInterface=function(e,t){var n=e.getMetadata().getInterfaces();return n.indexOf(t)!==-1};o.isElementInTemplate=function(e){var t=o.getAggregationInformation(e);if(t.templateId){var n=o.extractTemplateId(t);if(!n){return false}}return true};o.isElementDirectTemplateChild=function(e){var t=o.getAggregationInformation(e);if(t.templateId){var n=o.extractTemplateId(t);if(n&&t.stack.length===1){return true}}return false};o.isElementValid=function(e){var t=(e instanceof r||e instanceof n)&&!e.bIsDestroyed&&o.isElementInTemplate(e);return t};o.getParent=function(e){return t.isObjectA(e,"sap.ui.core.Component")?e.oContainer:e.getParent()};o.getLabelForElement=function(e,t){if(!o.isElementValid(e)){throw g.createError("ElementUtil#getLabelForElement","A valid managed object instance should be passed as parameter","sap.ui.dt")}if(typeof t==="function"){return t(e)}function n(e){var t=typeof e.getText==="function"&&e.getText()||typeof e.getLabelText==="function"&&e.getLabelText()||typeof e.getLabel==="function"&&e.getLabel()||typeof e.getTitle==="function"&&e.getTitle()||typeof e.getHeading==="function"&&e.getHeading()||typeof e.getDataSourceLabel==="function"&&e.getDataSourceLabel();if(o.isElementValid(t)){return n(t)}return t}var r=n(e);return typeof r!=="string"?e.getId():r};o.extractTemplateId=function(t){if(e(t)&&t.templateId){if(t.stack.length>1){var n;var i=r.getElementById(t.templateId);var a;var g;for(var s=t.stack.length-2;s>=0;s--){a=t.stack[s].aggregation;g=t.stack[s].index;n=o.getAggregation(i,a)[g];if(!n){return undefined}i=n}return i.getId()}else if(t.stack.length===1){return t.templateId}}else{return undefined}};o.getAggregationInformation=function(e){var t=[];return this._evaluateBinding(e,t)};o._evaluateBinding=function(e,t){var n;var r;var a;var g;var{aAPIParentInfos:s}=e;if(s&&s.length>0){g=s.some(function(t){a=t.parent;n=t.aggregationName;r=o.getAggregation(a,n).indexOf(e);return a.getBinding(n)})}if(!g){a=e.getParent();if(a){n=e.sParentAggregationName;r=o.getAggregation(a,n).indexOf(e)}else{r=-1}}t.push({element:e.getId(),type:e.getMetadata().getName(),aggregation:n,index:r});if(n&&a.getBinding(n)){var u=a.getBindingInfo(n);var f=u&&u.template;return{elementId:a.getId(),aggregation:n,templateId:f?f.getId():undefined,stack:t}}return!a||a instanceof i?{elementId:undefined,aggregation:undefined,templateId:undefined,stack:t}:this._evaluateBinding(a,t)};o.getAggregationBindingTemplate=function(e,t){var n=e&&e.getBindingInfo(t);return n&&n.template};o.adjustIndexForMove=function(e,t,n,r){if(e===t&&n<r&&n>-1){return r-1}return r};o.checkTargetZone=function(e,t,n){var r=e.getGeometry();var i=r&&r.size.height>0&&r.size.width>0;var g=e.getElement();var s=t.getElement();var u=e.getAggregationName();if(!s||!o.isValidForAggregation(g,u,s)){return Promise.resolve(false)}function f(e,t){var n=e.getDomRef();var r=a.isVisible(n);if(!n){return r}var i=t&&t.getDomRef&&t.getDomRef();var g=i?a.isVisible(i):true;return r||g}if(n&&!i||!n&&!f(e,g)||!(g&&g.getVisible&&g.getVisible())||!g.getParent()){return Promise.resolve(false)}return Promise.resolve(true)};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/ManagedObjectObserver", ["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/base/util/includes"],function(t,e,i){"use strict";var a=t.extend("sap.ui.dt.ManagedObjectObserver",{metadata:{abstract:true,library:"sap.ui.dt",properties:{aggregations:{type:"array",defaultValue:null}},associations:{target:{type:"sap.ui.base.ManagedObject"}},events:{modified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},destroyed:{}}}});a.prototype.init=function(){this._fnFireModified=function(t){var e=t.getParameters();if(t.sId==="_change"){t.sId="propertyChanged"}this.fireModified({type:t.sId,name:e.name,value:e.newValue,oldValue:e.oldValue,target:t.getSource()})}.bind(this)};a.prototype.exit=function(){this.unobserve();delete this._fnFireModified};a.prototype.setTarget=function(t){this.unobserve();this.setAssociation("target",t);var e=this.getTargetInstance();if(e){this.observe(e)}return this};a.prototype.observe=function(t){this._bIsObserved=true;t.attachEvent("_change",this._fnFireModified,this);this._fnOriginalDestroy=t.destroy;t.destroy=function(...e){this.unobserve(t);var i=t.destroy(...e);this.fireDestroyed();return i}.bind(this);this._fnOriginalBindProperty=t.bindProperty;t.bindProperty=function(...e){var i=this._fnOriginalBindProperty.apply(t,e);this.fireModified();return i}.bind(this);this._fnOriginalUnBindProperty=t.unbindProperty;t.unbindProperty=function(...e){var i=this._fnOriginalUnBindProperty.apply(t,e);this.fireModified();return i}.bind(this);this._fnOriginalBindAggregation=t.bindAggregation;t.bindAggregation=function(...e){const[i]=e;var a=this._fnOriginalBindAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified()}return a}.bind(this);this._fnOriginalUnBindAggregation=t.unbindAggregation;t.unbindAggregation=function(...e){const[i]=e;var a=this._fnOriginalUnBindAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified()}return a}.bind(this);this._fnOriginalSetParent=t.setParent;t.setParent=function(...e){const[i,a]=e;var n=false;if(!t._bInSetParent){n=true;t._bInSetParent=true}var r=t.getParent();var s=this._fnOriginalSetParent.apply(t,e);if(n){t._bInSetParent=false;if(!t.__bSapUiDtSupressParentChangeEvent&&(r!==i||a==="dependents")){this.fireModified({type:"setParent",value:i,oldValue:r,target:t})}}return s}.bind(this);this._fnOriginalAddAggregation=t.addAggregation;t.addAggregation=function(...e){const[i,a]=e;this._sAddOrSetAggregationCall=i;var n=this._fnOriginalAddAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalSetAggregation=t.setAggregation;t.setAggregation=function(...e){const[i,a]=e;this._sAddOrSetAggregationCall=i;var n=this._fnOriginalSetAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAggregation=t.removeAggregation;t.removeAggregation=function(...e){const[i,a]=e;this._sRemoveAggregationCall=i;var n=this._fnOriginalRemoveAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalInsertAggregation=t.insertAggregation;t.insertAggregation=function(...e){const[i,a]=e;this._sInsertAggregationCall=i;var n=this._fnOriginalInsertAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"insertAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAllAggregation=t.removeAllAggregation;t.removeAllAggregation=function(...e){const[i]=e;this._sRemoveAllAggregationCall=i;var a=t.getAggregation(i);var n=this._fnOriginalRemoveAllAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAllAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalDestroyAggregation=t.destroyAggregation;t.destroyAggregation=function(...e){const[i]=e;this._sDestroyAggregationCall=i;var a=t.getAggregation(i);var n=this._fnOriginalDestroyAggregation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"destroyAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalAddAssociation=t.addAssociation;t.addAssociation=function(...e){const[i,a]=e;this._sAddOrSetAssociationCall=i;var n=this._fnOriginalAddAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalSetAssociation=t.setAssociation;t.setAssociation=function(...e){const[i,a]=e;this._sAddOrSetAssociationCall=i;var n=this._fnOriginalSetAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"addOrSetAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAssociation=t.removeAssociation;t.removeAssociation=function(...e){const[i,a]=e;this._sRemoveAssociationCall=i;var n=this._fnOriginalRemoveAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAggregation",name:i,value:a,target:t})}return n}.bind(this);this._fnOriginalRemoveAllAssociation=t.removeAllAssociation;t.removeAllAssociation=function(...e){const[i]=e;this._sRemoveAllAssociationCall=i;var a=t.getAssociation(i);var n=this._fnOriginalRemoveAllAssociation.apply(t,e);if(this._isAggregationObservable(i)){this.fireModified({type:"removeAllAggregation",name:i,value:a,target:t})}return n}.bind(this);this._aOriginalAddMutators={};this._aOriginalInsertMutators={};this._aOriginalRemoveMutators={};this._aOriginalRemoveAllMutators={};this._aOriginalDestructors={};var e=t.getMetadata().getAllAggregations();Object.keys(e).forEach(function(i){var a=e[i];var n=t[a._sMutator];this._aOriginalAddMutators[a.name]=n;t[a._sMutator]=function(...e){const[i]=e;delete this._sAddOrSetAggregationCall;var r=n.apply(t,e);if((!this._sAddOrSetAggregationCall||this._sAddOrSetAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"addOrSetAggregation",name:a.name,value:i,target:t})}return r}.bind(this);var r=t[a._sInsertMutator];this._aOriginalInsertMutators[a.name]=r;t[a._sInsertMutator]=function(...e){const[i]=e;delete this._sInsertAggregationCall;var n=r.apply(t,e);if((!this._sInsertAggregationCall||this._sInsertAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"insertAggregation",name:a.name,value:i,target:t})}return n}.bind(this);var s=t[a._sRemoveMutator];this._aOriginalRemoveMutators[a.name]=s;t[a._sRemoveMutator]=function(...e){const[i]=e;delete this._sRemoveAggregationCall;var n=s.apply(t,e);if((!this._sRemoveAggregationCall||this._sRemoveAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAggregation",name:a.name,value:i,target:t})}return n}.bind(this);var g=t[a._sRemoveAllMutator];this._aOriginalRemoveAllMutators[a.name]=g;t[a._sRemoveAllMutator]=function(...e){delete this._sRemoveAllAggregationCall;var n=this.getAggregation(i);var r=g.apply(t,e);if((!this._sRemoveAllAggregationCall||this._sRemoveAllAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAllAggregation",name:a.name,value:n,target:t})}return r}.bind(this);var o=t[a._sDestructor];this._aOriginalDestructors[a.name]=o;t[a._sDestructor]=function(...e){delete this._sDestroyAggregationCall;var n=this.getAggregation(i);var r=o.apply(t,e);if((!this._sDestroyAggregationCall||this._sDestroyAggregationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"destroyAggregation",name:a.name,value:n,target:t})}return r}.bind(this)}.bind(this),this);var i=t.getMetadata().getAllAssociations();Object.keys(i).forEach(function(e){var a=i[e];var n=t[a._sMutator];this._aOriginalAddMutators[a.name]=n;t[a._sMutator]=function(...e){const[i]=e;delete this._sAddOrSetAssociationCall;var r;r=n.apply(t,e);if((!this._sAddOrSetAssociationCall||this._sAddOrSetAssociationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"addOrSetAggregation",name:a.name,value:i,target:t})}return r}.bind(this);var r=t[a._sRemoveMutator];this._aOriginalRemoveMutators[a.name]=r;t[a._sRemoveMutator]=function(...e){const[i]=e;delete this._sRemoveAssociationCall;var n=r.apply(t,e);if((!this._sRemoveAssociationCall||this._sRemoveAssociationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAggregation",name:a.name,value:i,target:t})}return n}.bind(this);var s=t[a._sRemoveAllMutator];this._aOriginalRemoveAllMutators[a.name]=s;t[a._sRemoveAllMutator]=function(...i){delete this._sRemoveAllAssociationCall;var n=this.getAssociation(e);var r=s.apply(t,i);if((!this._sRemoveAllAssociationCall||this._sRemoveAllAssociationCall!==a.name)&&this._isAggregationObservable(a.name)){this.fireModified({type:"removeAllAggregation",name:a.name,value:n,target:t})}return r}.bind(this)}.bind(this),this)};a.prototype.unobserve=function(t){t||=this.getTargetInstance();if(this._bIsObserved&&t){this._bIsObserved=false;t.destroy=this._fnOriginalDestroy;t.bindProperty=this._fnOriginalBindProperty;t.unbindProperty=this._fnOriginalUnBindProperty;t.bindAggregation=this._fnOriginalBindAggregation;t.unbindAggregation=this._fnOriginalUnBindAggregation;t.setParent=this._fnOriginalSetParent;t.addAggregation=this._fnOriginalAddAggregation;t.removeAggregation=this._fnOriginalRemoveAggregation;t.insertAggregation=this._fnOriginalInsertAggregation;t.setAggregation=this._fnOriginalSetAggregation;t.removeAllAggregation=this._fnOriginalRemoveAllAggregation;t.destroyAggregation=this._fnOriginalDestroyAggregation;t.addAssociation=this._fnOriginalAddAssociation;t.removeAssociation=this._fnOriginalRemoveAssociation;t.setAssociation=this._fnOriginalSetAssociation;t.removeAllAssociation=this._fnOriginalRemoveAllAssociation;var e=t.getMetadata().getAllAggregations();Object.keys(e).forEach(function(i){var a=e[i];t[a._sMutator]=this._aOriginalAddMutators[a.name];t[a._sInsertMutator]=this._aOriginalInsertMutators[a.name];t[a._sRemoveMutator]=this._aOriginalRemoveMutators[a.name];t[a._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[a.name];t[a._sDestructor]=this._aOriginalDestructors[a.name]},this);var i=t.getMetadata().getAllAssociations();Object.keys(i).forEach(function(e){var a=i[e];t[a._sMutator]=this._aOriginalAddMutators[a.name];t[a._sRemoveMutator]=this._aOriginalRemoveMutators[a.name];t[a._sRemoveAllMutator]=this._aOriginalRemoveAllMutators[a.name]},this);t.detachEvent("_change",this._fnFireModified,this)}delete this._fnOriginalDestroy;delete this._fnOriginalBindProperty;delete this._fnOriginalUnBindProperty;delete this._fnOriginalBindAggregation;delete this._fnOriginalUnBindAggregation;delete this._fnOriginalSetParent;delete this._fnOriginalAddAggregation;delete this._fnOriginalRemoveAggregation;delete this._fnOriginalInsertAggregation;delete this._fnOriginalSetAggregation;delete this._fnOriginalRemoveAllAggregations;delete this._fnOriginalDestroyAggregation;delete this._aOriginalAddMutators;delete this._aOriginalInsertMutators;delete this._aOriginalRemoveMutators;delete this._aOriginalRemoveAllMutators;delete this._aOriginalDestructors};a.prototype.getTargetInstance=function(){return e.getElementInstance(this.getTarget())};a.prototype._isAggregationObservable=function(t){return this.getAggregations()===null||i(this.getAggregations(),t)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/MetadataPropagationUtil", ["sap/ui/dt/Util","sap/base/util/merge","sap/base/util/isEmptyObject"],function(t,n,e){"use strict";var a={};a._getParentPropagationInfo=function(t){if(!t||!t.propagationInfos){return false}return Object.assign([],t.propagationInfos)};a._getCurrentRelevantContainerPropagation=function(n,e){const a={};const r=typeof n.propagateRelevantContainer;if(!n.propagateRelevantContainer){return a}else if(r==="function"){a.relevantContainerFunction=n.propagateRelevantContainer;a.relevantContainerElement=e}else if(r==="boolean"){a.relevantContainerFunction=function(){return true};a.relevantContainerElement=e}else{const n=t.wrapError(`Wrong type: it should be either a function or a boolean value and it is:${r}`);const e="sap.ui.dt.MetadataPropagationUtil#_getCurrentRelevantContainerPropagation";n.name=`Error in ${e}`;n.message=`${e} / ${n.message}`;throw n}return a};a._getCurrentDesigntimePropagation=function(n,e){const a={};const r=typeof n.propagateMetadata;if(!n.propagateMetadata){return a}else if(r==="function"){a.relevantContainerElement=e;a.metadataFunction=n.propagateMetadata}else{const n=t.wrapError(`Wrong type: it should be a function and it is:${r}`);const e="sap.ui.dt.MetadataPropagationUtil#_getCurrentDesigntimePropagation";n.name=`Error in ${e}`;n.message=`${e} / ${n.message}`;throw n}return a};a._setPropagationInfo=function(t,n,a){if(!a&&e(n)){return false}t.propagationInfos=a||[];if(!e(n)){t.propagationInfos.push(n)}return t};a.propagateMetadataToAggregationOverlay=function(t,n,r){var o;var i;var g;var s=Object.assign({},t);var u=a._getParentPropagationInfo(r);if(s&&!e(s)){g=a._getCurrentRelevantContainerPropagation(s,n);i=a._getCurrentDesigntimePropagation(s,n)}if(u||!e(g)||!e(i)){o=Object.assign({},g,i);return a._setPropagationInfo(s,o,u)}return s};a.getRelevantContainerForPropagation=function(t,n){var e=false;if(!t||!t.propagationInfos){return false}t.propagationInfos.some(function(t){if(t.relevantContainerFunction&&t.relevantContainerFunction(n)){e=t.relevantContainerElement;return true}});return e||false};a.getMetadataForPropagation=function(t,a){var r={};if(!t||!t.propagationInfos){return false}var o=t.propagationInfos.slice().reverse();r=o.reduce(function(t,e){if(e.metadataFunction){var r=e.metadataFunction(a,e.relevantContainerElement);return n(t,r)}return t},r);return e(r)?false:r};a.propagateMetadataToElementOverlay=function(t,e,r){var o=a.getRelevantContainerForPropagation(e,r);var i=a.getMetadataForPropagation(e,r);if(!o&&!i){return t}var g=n({},t);if(o){g.relevantContainer=o}if(i){if(i.actions===null||i.actions==="not-adaptable"){var s=r.getMetadata().getAllAggregations();var u=Object.keys(s);if(g.aggregations){u=u.concat(Object.keys(g.aggregations).filter(function(t){return u.indexOf(t)<0}))}else{g.aggregations={}}u.forEach(function(t){if(g.aggregations[t]&&g.aggregations[t].actions){g.aggregations[t].actions=i.actions}})}return n(g,i)}return g};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/MutationObserver", ["sap/base/util/restricted/_intersection","sap/base/util/restricted/_uniq","sap/ui/core/StaticArea","sap/ui/base/ManagedObject","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/thirdparty/jquery"],function(t,e,i,n,o,r,jQuery){"use strict";var a=n.extend("sap.ui.dt.MutationObserver",{metadata:{library:"sap.ui.dt",events:{domChanged:{parameters:{type:{type:"string"},targetNodes:{type:"element[]"}}}}}});a.prototype.init=function(){this._mutationOnTransitionend=this._callDomChangedCallback.bind(this,"MutationOnTransitionend");this._mutationOnAnimationEnd=this._callDomChangedCallback.bind(this,"MutationOnAnimationEnd");this._fireDomChangeOnScroll=this._fireDomChangeOnScroll.bind(this);this._mutationOnResize=this._callDomChangedOnResizeWithRoot.bind(this,"MutationOnResize");window.addEventListener("transitionend",this._mutationOnTransitionend,true);window.addEventListener("animationend",this._mutationOnAnimationEnd,true);window.addEventListener("scroll",this._fireDomChangeOnScroll,true);jQuery(window).on("resize",this._mutationOnResize);this._aIgnoredMutations=[];this._bHandlerRegistered=false;this._mMutationHandlers={};this._aRootIds=[];this._startMutationObserver()};a.prototype.exit=function(){this._stopMutationObserver();window.removeEventListener("transitionend",this._mutationOnTransitionend,true);window.removeEventListener("animationend",this._mutationOnAnimationEnd,true);window.removeEventListener("scroll",this._fireDomChangeOnScroll,true);jQuery(window).off("resize",this._mutationOnResize);this._aIgnoredMutations=[];this._bHandlerRegistered=false;this._mMutationHandlers={}};a.prototype.ignoreOnce=function(t){this._aIgnoredMutations.push(t)};a.prototype.registerHandler=function(t,e,i){if(!this._mMutationHandlers[t]){this._mMutationHandlers[t]=[];this._bHandlerRegistered=true}this._mMutationHandlers[t].push(e);if(i&&this._aRootIds.indexOf(t)===-1){this._aRootIds.push(t)}};a.prototype.deregisterHandler=function(t){delete this._mMutationHandlers[t];if(Object.keys(this._mMutationHandlers).length===0){this._bHandlerRegistered=false}this._aRootIds=this._aRootIds.filter(function(e){return e!==t})};a.prototype._hasScrollbar=function(t,e){return t||o.hasScrollBar(e)};a.prototype._getIdsWhenRegistered=function(t,e,i){var n;if(e&&this._mMutationHandlers[e]){n=e;i.closestElementInWhitlist||=e}i.result=t?n:i.closestElementInWhitlist;return i};a.prototype._getClosestParentIdForNodeRegisteredWithScrollbar=function(t,e){var i={closestElementInWhitlist:undefined,result:undefined};var n=false;var o=jQuery(e);var r=t;do{n=this._hasScrollbar(n,o);i=this._getIdsWhenRegistered(n,r,i);o=o.parent();r=o.attr("data-sap-ui")}while(!(i.result&&n)&&o.length&&o[0]!==document);return i.result||i.closestElementInWhitlist};a.prototype._isNodeOverlayRelated=function(t,e){var i="overlay-container";if(o.contains(i,t)){return true}if(t===document.body){return e&&e.addedNodes&&e.addedNodes[0]&&e.addedNodes[0].getAttribute&&e.addedNodes[0].getAttribute("id")===i}return false};a.prototype._getRelevantElementId=function(t,e){var n=t&&t.getAttribute&&t.getAttribute("id");var r;if(!this._isNodeOverlayRelated(t,e)&&document.body.contains(t)&&n!==i.STATIC_UIAREA_ID&&!o.contains("sap-ui-preserve",t)){var a=0;while(this._aRootIds.length>a&&!r){if(o.contains(this._aRootIds[a],t)||t.contains(document.getElementById(this._aRootIds[a]))){r=this._aRootIds[a]}a++}}return r};a.prototype._getRelevantElementIdsFromStaticArea=function(e){return e.target.id===i.STATIC_UIAREA_ID&&t([].concat(Array.prototype.slice.call(e.addedNodes),Array.prototype.slice.call(e.removedNodes)).map(function(t){return t.id}),Object.keys(this._mMutationHandlers))};a.prototype._ignoreMutation=function(t){return this._aIgnoredMutations.some(function(e,i,n){if(e.target===t.target&&(!e.type||e.type===t.type)){n.splice(i,1);return true}return false})};a.prototype._getTargetNode=function(t){var e=t.type==="characterData"?t.target.parentNode:t.target;if(e&&e.getRootNode()&&e.getRootNode().host){return e.getRootNode().host}return e};a.prototype._callRelevantCallbackFunctions=function(t,i){t=e(t);t.forEach(function(t){(this._mMutationHandlers[t]||[]).forEach(function(t){t({type:i})})}.bind(this))};function s(t){this._oMutationObserver.observe(t,{childList:true,subtree:true,attributes:true,attributeFilter:["style","class","width","height","border"],characterData:true})}a.prototype._startMutationObserver=function(){this._oMutationObserver=new window.MutationObserver(function(t){if(this._bHandlerRegistered){var e=t.reduce(function(t,e){var i=[];var n=this._getTargetNode(e);var o=this._getRelevantElementId(n,e);if(o){i.push(o)}else{i=this._getRelevantElementIdsFromStaticArea(e)}if(i.length&&!this._ignoreMutation(e)){return t.concat(i)}return t}.bind(this),[]);if(e.length){this._callRelevantCallbackFunctions(e,"MutationObserver")}}}.bind(this));s.call(this,window.document)};a.prototype.addNode=function(t){s.call(this,t)};a.prototype._stopMutationObserver=function(){if(this._oMutationObserver){this._oMutationObserver.disconnect();delete this._oMutationObserver}};a.prototype._callDomChangedCallback=function(t,e){var i=e.target;if(this._bHandlerRegistered&&i!==window){var n=this._getRelevantElementId(i);if(n){this._callRelevantCallbackFunctions([n],t)}}};a.prototype._callDomChangedOnResizeWithRoot=function(t){if(this._aRootIds.length){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest)}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this._callRelevantCallbackFunctions(this._aRootIds,t);delete this._iApplyStylesRequest}.bind(this))}};a.prototype._fireDomChangeOnScroll=function(t){var e=t.target;var n=[];if(this._bHandlerRegistered&&e!==document){var o=this._getRelevantElementId(e);if(o){n.push(o)}else if(e.getAttribute("id")!==i.STATIC_UIAREA_ID){n=this._aRootIds.filter(function(t){return e.contains(document.getElementById(t))})}if(n.length&&!r.getClosestOverlayForNode(e)){this._callRelevantCallbackFunctions(n,"MutationOnScroll")}}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/Overlay", ["sap/ui/thirdparty/jquery","sap/ui/core/Element","sap/ui/dt/MutationObserver","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/ui/dt/ScrollbarSynchronizer","sap/ui/dt/Util","sap/base/Log","sap/ui/dt/util/ZIndexManager"],function(jQuery,e,t,i,r,s,o,n,a,l){"use strict";var h="overlay-container";var d;var c;var y=e.extend("sap.ui.dt.Overlay",{metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},focusable:{type:"boolean",defaultValue:false},isRoot:{type:"boolean",defaultValue:false},isPartOfTemplate:{type:"boolean",defaultValue:false}},associations:{element:{type:"sap.ui.base.ManagedObject"}},aggregations:{children:{type:"sap.ui.dt.Overlay",multiple:true,defaultValue:[]},designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",altTypes:["function","object"],multiple:false}},events:{init:{},initFailed:{},afterRendering:{},beforeDestroy:{},destroyed:{parameters:{}},visibleChanged:{parameters:{visible:"boolean"}},geometryChanged:{},childAdded:{},scrollSynced:{},isRootChanged:{parameters:{value:{type:"boolean"}}},beforeGeometryChanged:{},applyStylesRequired:{parameters:{type:{type:"string"},targetOverlay:{type:"sap.ui.dt.ElementOverlay"}}}}},constructor:function(...t){this._aStyleClasses=this._aStyleClasses.slice(0);this._oScrollbarSynchronizers=new Map;this._aBindParameters=[];e.apply(this,t);if(!this.getElement()){throw n.createError("Overlay#constructor",`Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but ${n.getObjectType(t[0].element)} was given`)}this.asyncInit().then(function(){if(this._bShouldBeDestroyed){this.fireInitFailed({error:n.createError("Overlay#asyncInit",`ElementOverlay is destroyed during initialization ('${this.getId()}')`)})}else{this._bInit=true;this.fireInit()}}.bind(this)).catch(function(e){var t=n.propagateError(e,"Overlay#asyncInit",`Error initializing overlay (id='${this.getId()}'). Original error: ${n.wrapError(e).message}`);this.fireInitFailed({error:t})}.bind(this));this.attachEventOnce("afterRendering",function(e){var t=jQuery(e.getParameter("domRef"));this._aBindParameters.forEach(function(e){t.on(e.sEventType,e.fnProxy)})},this)},_bInit:false,_bRendered:false,_$DomRef:null,_aStyleClasses:["sapUiDtOverlay"],_bShouldBeDestroyed:false,_aBindParameters:null});y.getOverlayContainer=function(){d||=jQuery("<div></div>").attr("id",h).appendTo("body");return d};y.removeOverlayContainer=function(){if(d){d.remove()}d=undefined};y.getMutationObserver=function(){c||=new t;return c};y.destroyMutationObserver=function(){if(c){c.destroy();c=null}};y.prototype.asyncInit=function(){return Promise.resolve()};y.prototype._getAttributes=function(){return{id:this.getId(),"data-sap-ui":this.getId(),class:this._aStyleClasses.join(" "),tabindex:this.isFocusable()?0:null}};y.prototype._renderChildren=function(){return this.getChildren().map(function(e){return e.isRendered()?e.$():e.render()})};y.prototype.render=function(e){if(this.isRendered()){return this.getDomRef()}this._$DomRef=jQuery("<div></div>").attr(this._getAttributes());this._$Children=jQuery("<div></div>").attr({class:"sapUiDtOverlayChildren"}).appendTo(this._$DomRef);this._$Children.append(this._renderChildren());this._bRendered=true;if(!e){this.fireAfterRendering({domRef:this._$DomRef.get(0)})}return this._$DomRef};y.prototype.isInit=function(){return this._bInit};y.prototype.isRendered=function(){return this._bRendered};y.prototype.isReady=function(){return this.isInit()&&this.isRendered()};y.prototype.addStyleClass=function(e){if(!this.hasStyleClass(e)){this._aStyleClasses.push(e);if(this.isReady()){this.$().addClass(e)}}};y.prototype.hasStyleClass=function(e){return this._aStyleClasses.indexOf(e)!==-1};y.prototype.removeStyleClass=function(e){if(this.hasStyleClass(e)){this._aStyleClasses=this._aStyleClasses.filter(function(t){return t!==e});if(this.isReady()){this.$().removeClass(e)}}};y.prototype.toggleStyleClass=function(e){this[`${this.hasStyleClass(e)?"remove":"add"}StyleClass`](e)};y.prototype.setElement=function(e){if(!this.getElement()){this.setAssociation("element",e);if(this._designTimeMetadataCache){this.setDesignTimeMetadata(this._designTimeMetadataCache);delete this._designTimeMetadataCache}}};y.prototype.destroy=function(...t){if(this.bIsDestroyed){a.error(`FIXME: Do not destroy overlay twice (overlayId = ${this.getId()})!`);return}this.fireBeforeDestroy();e.prototype.destroy.apply(this,t)};y.prototype.exit=function(){this._oScrollbarSynchronizers.forEach(function(e){e.destroy()});this._oScrollbarSynchronizers.clear();this.$().remove();delete this._bInit;delete this._bShouldBeDestroyed;delete this._$DomRef;delete this._oScrollbarSynchronizers;this.fireDestroyed()};y.prototype.setDesignTimeMetadata=function(e){if(!this.getElement()){this._designTimeMetadataCache=e}else{this.setAggregation("designTimeMetadata",e)}};y.prototype.getDomRef=function(){return this.$().get(0)};y.prototype.getChildrenDomRef=function(){return this._$Children.get(0)};y.prototype.$=function(){return this._$DomRef||jQuery()};y.prototype.getAssociatedDomRef=function(){throw new Error("This method is abstract and needs to be implemented")};y.prototype.getElement=function(){return i.getElementInstance(this.getAssociation("element"))};y.prototype.hasFocus=function(){return document.activeElement===this.getDomRef()};y.prototype.focus=function(){this.$().trigger("focus")};y.prototype.setFocusable=function(e){e=!!e;if(this.getFocusable()!==e){this.setProperty("focusable",e);this.toggleStyleClass("sapUiDtOverlayFocusable");this.$().attr("tabindex",e?0:null)}};y.prototype.isFocusable=function(){return this.getFocusable()};y.prototype._getRenderingParent=function(){return this.isRoot()?null:this.getParent().$()};y.prototype.applyStyles=function(e,t){var i;this.fireBeforeGeometryChanged();if(!this.isRendered()||this._bIsBeingDestroyed||this.getShouldBeDestroyed()){return Promise.resolve()}if(this.getVisible()){i=this.getGeometry(!t)}var r=Promise.resolve();if(this.isVisible()){if(i&&i.visible){this._ensureVisibility(this.$());this._setSize(this.$(),i);var s=this._getRenderingParent();if(!this.isRoot()){var o=[];this.getParent()._oScrollbarSynchronizers.forEach(function(e){if(e.isSyncing()){o.push(new Promise(function(t){e.attachEventOnce("synced",t);e.attachEventOnce("destroyed",t)}))}});if(o.length){r=Promise.all(o).then(function(){return this._applySizes(i,s,e)}.bind(this))}else{r=this._applySizes(i,s,e)}}else{r=this._applySizes(i,s,e)}}else{this.$().css("display","none")}}else{this.$().css("display","none")}return r.catch(function(e){a.error(n.createError("Overlay#applyStyles",`An error occurred during applySizes calculation: ${e}`))}).then(function(){this.fireGeometryChanged()}.bind(this))};y.prototype._applySizes=function(e,t,i){this._setPosition(this.$(),e,t,i);if(e.domRef){this._setZIndex(e,this.$())}var r=this.getChildren().filter(function(e){return e.isRendered()}).map(function(e){var t={};t.bForceScrollbarSync=i;return new Promise(function(i){e.attachEventOnce("geometryChanged",i);e.fireApplyStylesRequired(t)})});return Promise.all(r)};y.prototype._setZIndex=function(e,t){var i=e.domRef;var r=s.getZIndex(i);if(n.isInteger(r)){t.css("z-index",r)}else if(this.isRoot()){this._iZIndex||=l.getZIndexBelowPopups();t.css("z-index",this._iZIndex)}};y.prototype._ensureVisibility=function(e){e.css("display","block")};y.prototype._setSize=function(e,t){var i=t.size;e.css("width",`${i.width}px`);e.css("height",`${i.height}px`)};y.prototype._setPosition=function(e,t,i){var r=s.getOffsetFromParent(t,i?i.get(0):null);e.css("transform",`translate(${r.left}px, ${r.top}px)`)};y.prototype._setClipPath=function(e,t){var i=t.css("clip-path");e.css("clip-path",i)};y.prototype.attachBrowserEvent=function(e,t,i){if(e&&typeof e==="string"){if(typeof t==="function"){this._aBindParameters||=[];i||=this;var r=t.bind(i);this._aBindParameters.push({sEventType:e,fnHandler:t,oListener:i,fnProxy:r});this.$().on(e,r)}}return this};y.prototype.detachBrowserEvent=function(e,t,i){if(e&&typeof e==="string"){if(typeof t==="function"){i||=this;if(this._aBindParameters){var r=this.$();var s;for(var o=this._aBindParameters.length-1;o>=0;o--){s=this._aBindParameters[o];if(s.sEventType===e&&s.fnHandler===t&&s.oListener===i){this._aBindParameters.splice(o,1);r.off(e,s.fnProxy)}}}}}return this};y.prototype._deleteDummyContainer=function(e,t,i){if(this._oDummyScrollContainer.length){var r=this._oScrollbarSynchronizers.get(e.get(0));this._oDummyScrollContainer.remove();this._oDummyScrollContainer=jQuery();r.attachEventOnce("synced",function(){r.destroy();this._oScrollbarSynchronizers.delete(e.get(0));if(t._oScrollbarSynchronizers.size===0&&!t.getChildren().some(function(e){return e._oScrollbarSynchronizers.size>0})){t.removeStyleClass("sapUiDtOverlayWithScrollBar");t.removeStyleClass("sapUiDtOverlayWithScrollBarVertical");t.removeStyleClass("sapUiDtOverlayWithScrollBarHorizontal")}}.bind(this));r.sync(i,true)}};y.prototype._handleOverflowScroll=function(e,t,i,r){var n=e.domRef;var a=e.size;var l=s.getOverflows(n);t.css("overflow-x",l.overflowX);t.css("overflow-y",l.overflowY);var h=n.scrollHeight;var d=n.scrollWidth;this._oDummyScrollContainer=t.find("> .sapUiDtDummyScrollContainer");if(h>Math.ceil(a.height)||d>Math.ceil(a.width)){var c;if(!this._oDummyScrollContainer.length){this._oDummyScrollContainer=jQuery("<div class='sapUiDtDummyScrollContainer'></div>");this._oDummyScrollContainer.height(h);this._oDummyScrollContainer.width(d);if(i&&s.hasVerticalScrollBar(n)&&i._hasSameSize(e,"height")){i.addStyleClass("sapUiDtOverlayWithScrollBar");i.addStyleClass("sapUiDtOverlayWithScrollBarVertical")}if(i&&s.hasHorizontalScrollBar(n)&&i._hasSameSize(e,"width")){i.addStyleClass("sapUiDtOverlayWithScrollBar");i.addStyleClass("sapUiDtOverlayWithScrollBarHorizontal")}t.append(this._oDummyScrollContainer);c=new o({synced:this.fireScrollSynced.bind(this)});c.addTarget(n,t.get(0));this._oScrollbarSynchronizers.set(t.get(0),c)}else{this._oDummyScrollContainer.css({height:h,width:d});c=this._oScrollbarSynchronizers.get(t.get(0));if(!c.hasTarget(n)){c.addTarget(n)}}if(r){c.sync(n,true)}}else{this._deleteDummyContainer(t,i,n)}};y.prototype.getGeometry=function(e){if(e||!this._mGeometry){var t=this.getAssociatedDomRef();var i;if(t){var o=this.isRoot();i=jQuery.makeArray(t).map(function(e){return s.getGeometry(e,o)})}else{i=this.getChildren().map(function(e){return e.getGeometry(true)})}if(i.length){this._mGeometry=i.length>1?r.getGeometry(i):i[0]}else{delete this._mGeometry}}return this._mGeometry};y.prototype.setVisible=function(e){e=!!e;if(this.getVisible()!==e){this.setProperty("visible",e);this.$().css("visibility",e?"":"hidden");this.fireVisibleChanged({visible:e})}};y.prototype.isVisible=function(){return this.getVisible()&&(this.isRoot()?true:this.getParent().isVisible())};y.prototype.setIsRoot=function(e){e=!!e;if(this.getIsRoot()!==e){this.setProperty("isRoot",e);this.fireIsRootChanged({value:e})}};y.prototype.isRoot=function(){return this.getIsRoot()};y.prototype.getShouldBeDestroyed=function(){return this._bShouldBeDestroyed};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/OverlayRegistry", ["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/Util","sap/base/util/isEmptyObject"],function(e,t,a,r){"use strict";var i={};var n="sap.ui.dt.ElementOverlay";var s="sap.ui.dt.AggregationOverlay";var g={};var l={};i.getOverlay=function(e){var a=typeof e==="string"?e:t.getElementInstance(e)&&t.getElementInstance(e).getId();return g[a]||l[a]};i.getOverlays=function(){return Object.values(g)};i.register=function(e){if(!u(e)){var t="sap.ui.dt.OverlayRegistry#register";var a=new Error(`${t} / Attempt to register illegal overlay`);a.name=t;throw a}g[e.getId()]=e;if(e.getMetadata().getName()===n){l[e.getAssociation("element")]=e}};i.deregister=function(e){if(!u(e)){var t="sap.ui.dt.OverlayRegistry#deregister";var a=new Error(`${t} / Attempt to deregister illegal overlay`);a.name=t;throw a}delete g[e.getId()];if(e.getMetadata().getName()===n){delete l[e.getAssociation("element")]}};i.hasOverlays=function(){return!r(g)};function u(t){return t instanceof e&&[n,s].indexOf(t.getMetadata().getName())>-1}return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/OverlayUtil", ["sap/ui/core/UIArea","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry"],function(e,r,n,t){"use strict";var i={};i.isInTargetZoneAggregation=function(e){var r=e.getParent();return!!r&&r.isTargetZone()};i.getParentInformation=function(e){var r=e.getParentElementOverlay();if(r){var t=r.getElement();var i=e.getParentAggregationOverlay().getAggregationName();var a=n.getAggregation(t,i);var g=e.getElement();var l=a.indexOf(g);return{parent:t,aggregation:i,index:l}}return{parent:null,aggregation:"",index:-1}};i.getClosestOverlayFor=function(e){if(!e){return null}var r=e;var n=t.getOverlay(r);while(r&&!n){r=r.getParent();n=t.getOverlay(r)}return n};i.getGeometry=function(e){var r;var n;var t;var i;e.forEach(function(e){if(e&&e.visible){if(!r||e.position.left<r){r=e.position.left}if(!t||e.position.top<t){t=e.position.top}var a=e.position.left+e.size.width;if(!n||a>n){n=a}var g=e.position.top+e.size.height;if(!i||g>i){i=g}}});if(typeof r==="number"){return{size:{width:n-r,height:i-t},position:{left:r,top:t},visible:true}}};i.getFirstDescendantByCondition=function(e,r){if(!r){throw new Error("expected condition is 'undefined' or not a function")}var n=i.getAllChildOverlays(e);for(var t=0,a=n.length;t<a;t++){var g=n[t];if(r(g)){return g}var l=this.getFirstDescendantByCondition(g,r);if(l){return l}}return undefined};i.getLastDescendantByCondition=function(e,r){if(!r){throw new Error("expected condition is 'undefined' or not a function")}var n=i.getAllChildOverlays(e);for(var t=n.length-1,a=-1;t>a;t--){var g=n[t];if(r(g)){return g}var l=this.getLastDescendantByCondition(g,r);if(l){return l}}return undefined};i.getAllChildOverlays=function(e){var r=[];var n=[];if(!e){return r}var t=e.getChildren();for(var i=0;i<t.length;i++){n=t[i].getChildren();if(n&&n.length>0){r=r.concat(n)}}return r};i.getFirstChildOverlay=function(e){var r=this.getAllChildOverlays(e);if(r.length){return r[0]}return undefined};i.getLastChildOverlay=function(e){var r=this.getAllChildOverlays(e);if(r.length){return r[r.length-1]}return undefined};i.getNextSiblingOverlay=function(e){if(!e){return undefined}var r=e.getParentAggregationOverlay();if(r){var n=r.getChildren();var t=n.indexOf(e);if(t!==n.length-1){return n[t+1]}else if(t===n.length-1){var i=e.getParentElementOverlay();n=i.getChildren();for(t=n.indexOf(r)+1;t<n.length;t++){var a=n[t].getChildren();if(a.length){return a[0]}}}}};i.getPreviousSiblingOverlay=function(e){if(!e){return undefined}var r=e.getParentAggregationOverlay();if(r){var n=r.getChildren();var t=n.indexOf(e);if(t>0){return n[t-1]}else if(t===0){var i=e.getParentElementOverlay();n=i.getChildren();for(t=n.indexOf(r)-1;t>=0;t--){var a=n[t].getChildren();if(a.length){return a[a.length-1]}}}}};i.getNextOverlay=function(e){if(!e){return undefined}var r=this.getFirstChildOverlay(e);if(r){return r}var n=this.getNextSiblingOverlay(e);if(n){return n}do{e=e.getParentElementOverlay();n=this.getNextSiblingOverlay(e)}while(e&&!n);return n};i.getPreviousOverlay=function(e){if(!e){return undefined}var r=e.getParentAggregationOverlay();if(!r){return undefined}var n=this.getPreviousSiblingOverlay(e);if(n){var t=n;do{n=t;t=this.getLastChildOverlay(n)}while(t);return n}return e.getParentElementOverlay()};i.iterateOverlayElementTree=function(e,r){r(e);e.getChildren().forEach(function(e){e.getChildren().forEach(function(e){this.iterateOverlayElementTree(e,r)},this)},this)};i.getClosestOverlayForNode=function(e){var r=n.getClosestElementForNode(e);return i.getClosestOverlayFor(r)};i.setFirstParentMovable=function(e,r){if(!r){const r=this.getFirstMovableParentOverlay(e);if(r){e._firstMovableParentOverlay=r;r.setMovable(false)}}else if(e._firstMovableParentOverlay){e._firstMovableParentOverlay.setMovable(true);delete e._firstMovableParentOverlay}};i.findAllSiblingOverlaysInContainer=function(e,r){var n=e.getParentElementOverlay();var t=[];if(n){if(n!==r){var a=i.findAllSiblingOverlaysInContainer(n,r);t=a.map(function(r){var n=r.getAggregationOverlay(e.getParentAggregationOverlay().getAggregationName());return n?n.getChildren():[]}).reduce(function(e,r){return e.concat(r)},[])}else{var g=e.getParentAggregationOverlay().getAggregationName();var l=n.getAggregationOverlay(g);t=l&&l.getChildren()||[]}}t=t.filter(function(e){return e.getDesignTimeMetadata()});return t};i.findAllOverlaysInContainer=function(e,r){var n=e.getRelevantContainer()||e.getElement();var a=t.getOverlay(n);var g=[];if(!a){return g}var l=i._findAllSiblingsAndParents(e,a,0,r);if(l[0]){for(var o in l){g=g.concat(l[o])}var f=[];var v=r?g:l[0];v.forEach(function(e){f=f.concat(i._findAllChildrenInContainer(e,n))});g=g.concat(f)}else{g=i._findAllChildrenInContainer(e,n)}g.push(a);g=g.filter(function(e){return e.getDesignTimeMetadata()});return g};i._findAllSiblingsAndParents=function(e,r,n,t){var a=e.getParentElementOverlay();if(!a){return[]}function g(e){var r=e.getAggregationNames();var n=[];r.forEach(function(r){var t=e.getAggregationOverlay(r);var i=t?t.getChildren():[];n=i.concat(n)});return n}if(a!==r){var l;var o;l=i._findAllSiblingsAndParents(a,r,n+1,t);if(t){var f=[];l[n+1].forEach(function(e){f.concat(g(e))});l[n]=f;return l}o=l[n+1].map(function(r){var n=e.getParentAggregationOverlay().getAggregationName();var t=r.getAggregationOverlay(n);return t?t.getChildren():[]}).reduce(function(e,r){return e.concat(r)},[]);l[n]=o;return l}var v=[];if(t){v=g(a)}else{var u=e.getParentAggregationOverlay().getAggregationName();v=e.getParentElementOverlay().getAggregationOverlay(u).getChildren()}var d={};d[n]=v;return d};i._findAllChildrenInContainer=function(e,r,n){n||=[];if(e.getChildren().length>0){e.getChildren().forEach(function(e){e.getChildren().forEach(function(e){if(e.getRelevantContainer()===r){n.push(e);i._findAllChildrenInContainer(e,r,n)}})})}return n};i.findAllUniqueAggregationOverlaysInContainer=function(e,r){var n=i.findAllSiblingOverlaysInContainer(e,r);return n.map(function(e){return e.getParentAggregationOverlay()}).filter(function(e,r,n){return n.indexOf(e)===r})};i.getIndexInAggregation=function(e,r,i){var a=n.getAggregation(r,i).filter(function(r){return!!t.getOverlay(r)||r===e});return a.indexOf(e)};function a(r,n){var t;var i;var g=r.getParent();var l=false;if(r.isA("sap.ui.dt.ElementOverlay")){var o=r.getParentElementOverlay();if(g){t=g.getAggregationName();i=g.getChildren().indexOf(r);l=o&&o.getAggregationOverlay(t,"AggregationBindingTemplateOverlays")}else{i=-1}n.push({overlayId:r.getId(),aggregation:t,index:i});if(l){return{overlayId:o.getId(),aggregation:t,stack:n}}}if(!g||g instanceof e){return{overlayId:undefined,aggregation:undefined,stack:n}}return a(g,n)}i.getClosestBoundControl=function(e){return a(e,[])};i.findParentOverlaysWithScrollbar=function(e){var r=[];function n(e){if(e._oScrollbarSynchronizers.size>0){r.push(e)}if(!e.getParent()){return r}return n(e.getParent())}return n(e)};i.getFirstMovableParentOverlay=function(e){function r(e){if(e.isMovable()){return e}if(!e.getParentElementOverlay()){return undefined}return r(e.getParentElementOverlay())}const n=e.getParentElementOverlay();if(n){return r(n)}return undefined};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/Plugin", ["sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/dt/OverlayRegistry"],function(e,t,i){"use strict";var r=e.extend("sap.ui.dt.Plugin",{metadata:{abstract:true,library:"sap.ui.dt",properties:{designTime:{type:"object",multiple:false},busy:{type:"boolean",defaultValue:false}},events:{processingStatusChange:{parameters:{processing:{type:"boolean"}}}}}});r.prototype._bProcessingCounter=0;r.prototype._oBusyPromise={};r.prototype.init=function(){};r.prototype.exit=function(){this.setDesignTime(null)};r.prototype.setDesignTime=function(e){var t=this.getDesignTime();if(t){this._deregisterOverlays(t)}this.setProperty("designTime",e);if(e){this._registerOverlays(e)}return this};r.prototype._registerOverlays=function(e){if(this.registerElementOverlay||this.registerAggregationOverlay){var t=e.getElementOverlays();this.setProcessingStatus(true);t.forEach(this.callElementOverlayRegistrationMethods.bind(this));this.setProcessingStatus(false)}};r.prototype._deregisterOverlays=function(e){if(this.deregisterElementOverlay||this.deregisterAggregationOverlay){var t=e.getElementOverlays();t.forEach(this._callElementOverlayDeregestrationMethods.bind(this))}};r.prototype.callAggregationOverlayRegistrationMethods=function(e){if(this.registerAggregationOverlay){var t=e.getChildren();t.forEach(this.registerAggregationOverlay.bind(this))}};r.prototype.callElementOverlayRegistrationMethods=function(e){if(this.registerElementOverlay){this.registerElementOverlay(e)}this.callAggregationOverlayRegistrationMethods(e)};r.prototype._callElementOverlayDeregestrationMethods=function(e){if(this.deregisterElementOverlay){this.deregisterElementOverlay(e)}if(this.deregisterAggregationOverlay){var t=e.getChildren();t.forEach(this.deregisterAggregationOverlay.bind(this))}};r.prototype._onElementOverlayCreated=function(e){var t=e.getParameter("elementOverlay");this.callElementOverlayRegistrationMethods(t)};r.prototype.getMenuItems=function(){return[]};r.prototype.getActionName=function(){};r.prototype.isBusy=r.prototype.getBusy;r.prototype.setBusy=function(e){if(e&&!this.getBusy()){this._oBusyPromise.promise=new Promise(function(e){this._oBusyPromise.resolveFunction=e}.bind(this))}else if(!e&&this.getBusy()&&this._oBusyPromise.resolveFunction){this._oBusyPromise.resolveFunction()}this.setProperty("busy",e);return this};r.prototype.waitForBusyAction=function(){return this._oBusyPromise.promise||Promise.resolve()};r.prototype.setProcessingStatus=function(e){this._bProcessingCounter=e?this._bProcessingCounter+1:this._bProcessingCounter-1;if(e===true&&this._bProcessingCounter===1||e===false&&this._bProcessingCounter===0){this.fireProcessingStatusChange({processing:e})}};r.prototype.getAction=function(e){return e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getAction(this.getActionName(),e.getElement()):null};r.prototype.getSelectedOverlays=function(){return this.getDesignTime().getSelectionManager().get()};r.prototype.getActionText=function(e,i,r){var n=i.name;var s=e.getElement();if(n){if(typeof n==="function"){return n(s)}return e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getLibraryText(s,n):""}return t.getResourceBundleFor("sap.ui.rta").getText(r)};r.prototype.isAvailable=function(){return false};r.prototype.handler=function(){};r.prototype.isEnabled=function(e){if(!Array.isArray(e)||e.length>1){return false}var t=e[0];var i=this.getAction(t);if(!i){return false}var r=t.getElement();if(i.isEnabled===undefined){return true}if(typeof i.isEnabled==="function"){return i.isEnabled(r)}return i.isEnabled};r.prototype._getMenuItems=function(e,t){var i=this.enhanceItemWithResponsibleElement({id:t.pluginId,handler:this.handler.bind(this),enabled:this.isEnabled.bind(this),rank:t.rank,icon:t.icon,group:t.group},e);var r=i.responsible||e;var n=r[0];var s=this.getAction(n);if(!s||!this.isAvailable(r)){return[]}i.text=this.getActionText(n,s,t.pluginId);return[i]};r.prototype.isResponsibleElementActionAvailable=function(e,t){var i=e.getDesignTimeMetadata();if(i){return i.isResponsibleActionAvailable(t||this.getActionName())}return false};r.prototype.getResponsibleElementOverlay=function(e){var t=e.getElement();var r=e.getDesignTimeMetadata();if(r){var n=r.getResponsibleElement(t);if(n){try{return i.getOverlay(n)}catch(t){return e}}}return e};r.prototype.enhanceItemWithResponsibleElement=function(e,t,i){var r=[];var n=i||[this.getActionName()];var s=n.some(function(e){if(this.isResponsibleElementActionAvailable(t[0],e)){r=t.map(this.getResponsibleElementOverlay.bind(this));return true}}.bind(this));return Object.assign(e,s&&{responsible:r})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/ScrollbarSynchronizer", ["sap/ui/base/ManagedObject","sap/ui/dt/DOMUtil","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";var r=t.extend("sap.ui.dt.ScrollbarSynchronizer",{metadata:{library:"sap.ui.dt",properties:{scrollTop:{type:"float"},scrollLeft:{type:"float"},targets:{type:"any[]",defaultValue:[]}},events:{synced:{},destroyed:{}}},_bSyncing:false,constructor:function(...e){this._scrollEventHandler=this._scrollEventHandler.bind(this);t.apply(this,e)}});r.prototype.getTargets=function(){return this.getProperty("targets").slice(0)};r.prototype.setTargets=function(t){var e=Array.isArray(t)?t:[t];this.getTargets().forEach(this.removeTarget.bind(this));this.addTarget(...e)};r.prototype.removeTarget=function(t){this._detachScrollEvent(t);this.setProperty("targets",this.getTargets().filter(function(e){return e!==t}))};r.prototype.addTarget=function(...t){var e=Array.prototype.slice.call(t);if(!e.length){return}this._removeDeadNodes();e.forEach(this._attachScrollEvent,this);var r=this.getTargets().concat(e);this.setProperty("targets",r);this.sync(r[0])};r.prototype.hasTarget=function(t){return this.getTargets().indexOf(t)>-1};r.prototype._removeDeadNodes=function(){this.getTargets().forEach(function(t){if(!document.body.contains(t)){this.removeTarget(t)}},this)};r.prototype._attachScrollEvent=function(t){jQuery(t).on("scroll",this._scrollEventHandler)};r.prototype._detachScrollEvent=function(t){jQuery(t).off("scroll",this._scrollEventHandler)};r.prototype._scrollEventHandler=function(t){this.sync(t.target)};r.prototype.sync=function(t,r){if(r||this.getScrollTop()!==t.scrollTop||this.getScrollLeft()!==jQuery(t).scrollLeft()){this.setScrollTop(t.scrollTop);this.setScrollLeft(jQuery(t).scrollLeft());if(this._bSyncing){this._abortSync()}this._bSyncing=true;this.animationFrame=window.requestAnimationFrame(function(){this.getTargets().filter(function(e){return t!==e}).forEach(function(r){e.syncScroll(t,r)});this._bSyncing=false;this.fireSynced()}.bind(this))}};r.prototype._abortSync=function(){window.cancelAnimationFrame(this.animationFrame);this._bSyncing=false};r.prototype.destroy=function(...e){this.getTargets().forEach(function(t){this.removeTarget(t)},this);this._abortSync();this.fireDestroyed();t.prototype.destroy.apply(this,e)};r.prototype.isSyncing=function(){return this._bSyncing};r.prototype.refreshListeners=function(){this.getTargets().forEach(function(t){this._detachScrollEvent(t);this._attachScrollEvent(t)},this)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/SelectionManager", ["sap/ui/base/ManagedObject","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/dt/SelectionMode","sap/ui/dt/ElementOverlay","sap/base/util/includes"],function(t,e,i,r,n,a){"use strict";var o=t.extend("sap.ui.dt.SelectionManager",{metadata:{events:{change:{parameters:{selection:{type:"sap.ui.dt.ElementOverlay[]"}}}},properties:{connectedElements:{type:"object",defaultValue:{}}}}});function s(t){return i.castArray(t).map(function(t){if(t instanceof n){return t}var i=e.getOverlay(t);if(i){return i}}).filter(function(t,e,i){return t&&i.indexOf(t)===e})}function l(t){return t.every(function(t){return t.isSelectable()})}function u(t,i){var r=this.getConnectedElements()[t.getAssociation("element")];var n=e.getOverlay(r);if(n){var a=i?"addStyleClass":"removeStyleClass";n[a]("sapUiDtOverlaySelected")}}o.prototype.init=function(){this._aSelection=[];this._aValidators=[];this.addValidator(l)};o.prototype.exit=function(){delete this._aSelection;delete this._aValidators};o.prototype.getSelectionMode=function(){return this._aSelection.length>1?r.Multi:r.Single};o.prototype.get=function(){return this._aSelection.slice()};o.prototype.set=function(t){var e=s(t);var i=false;if(this._validate(e)){var r=this.get().filter(function(t){return!a(e,t)});i=this._remove(r)||i;i=this._add(e)||i;if(i){this.fireChange({selection:this.get()})}}return i};o.prototype._validate=function(t){return this.getValidators().every(function(e){return e(t)})};o.prototype._add=function(t){var e=this.get();t=t.filter(function(t){return!a(e,t)});if(t.length){var i=e.concat(t);if(this._validate(i)){this._aSelection=i;t.forEach(function(t){t.setSelected(true);u.call(this,t,true)}.bind(this));return true}}return false};o.prototype.add=function(t){if(this._add(s(t))){this.fireChange({selection:this.get()});return true}return false};o.prototype._remove=function(t){var e=this.get();var i=e.filter(function(e){return!a(t,e)});if(i.length!==e.length){this._aSelection=i;t.forEach(function(t){t.setSelected(false);u.call(this,t,false)}.bind(this));return true}return false};o.prototype.remove=function(t){if(this._remove(s(t))){this.fireChange({selection:this.get()});return true}return false};o.prototype.reset=function(){return this.remove(this.get())};o.prototype.addValidator=function(t){if(typeof t==="function"&&!a(this._aValidators,t)){this._aValidators=this._aValidators.concat(t)}};o.prototype.removeValidator=function(t){this._aValidators=this._aValidators.filter(function(e){return t!==e})};o.prototype.getValidators=function(){return this._aValidators.slice()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/SelectionMode", function(){"use strict";return{Multi:"Multi",Single:"Single"}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/TaskManager", ["sap/ui/base/ManagedObject","sap/base/util/isPlainObject"],function(t,e){"use strict";var s=t.extend("sap.ui.dt.TaskManager",{metadata:{library:"sap.ui.dt",properties:{suppressEvents:{type:"boolean",defaultValue:false}},events:{add:{parameters:{taskId:"int"}},complete:{parameters:{taskId:"array"}}}},constructor:function(...e){t.apply(this,e);this._mQueuedTasks={};this._mPendingTasks={}},_iNextId:0,_iTaskCounter:0});function i(t){if(!e(t)||!t.type||typeof t.type!=="string"){throw new Error("Invalid task specified")}}function n(t){var e;if(typeof t==="string"){e=function(e){return e[t]}}else if(typeof t==="function"){e=t}else{throw new Error("Validator needs to be a function or a string")}return e}function r(t,e,s){if(t(s)===e){this._iTaskCounter--;return false}return true}s.prototype._removeTasksByIdentifier=function(t,e,s){if(e){var i=n(e);var u=i(t);if(this[s][t.type]&&u){this[s][t.type]=this[s][t.type].filter(r.bind(this,i,u))}}};s.prototype._removeTaskById=function(t,e){Object.keys(this[e]).forEach(function(s){this[e][s]=this[e][s].filter(function(e){if(e.id===t){this._iTaskCounter--;return false}return true}.bind(this))},this)};s.prototype._addTask=function(t){var e=this._iNextId++;this._mQueuedTasks[t.type]||=[];this._mQueuedTasks[t.type].push(Object.assign({},t,{id:e}));this._iTaskCounter++;if(!this.getSuppressEvents()){this.fireAdd({taskId:e})}return e};s.prototype.add=function(t,e){i(t);this._removeTasksByIdentifier(t,e,"_mQueuedTasks");return this._addTask(t)};s.prototype.complete=function(t){this._removeTaskById(t,"_mQueuedTasks");this._removeTaskById(t,"_mPendingTasks");if(!this.getSuppressEvents()){this.fireComplete({taskId:[t]})}};s.prototype.completeBy=function(t){i(t);var e=[];var s=function(s){return(s||[]).filter(function(s){var i=Object.keys(t).every(function(e){return s[e]&&s[e]===t[e]});if(i){this._iTaskCounter--;e.push(s.id);return false}return true}.bind(this))}.bind(this);this._mQueuedTasks[t.type]=s(this._mQueuedTasks[t.type]);this._mPendingTasks[t.type]=s(this._mPendingTasks[t.type]);if(!this.getSuppressEvents()){this.fireComplete({taskId:e})}};s.prototype.cancel=function(t){this.complete(t)};s.prototype.cancelBy=function(t,e){this._removeTasksByIdentifier(t,e,"_mQueuedTasks");this._removeTasksByIdentifier(t,e,"_mPendingTasks")};s.prototype.isEmpty=function(){return this._iTaskCounter===0};s.prototype.count=function(t){return this.getList(t).length};s.prototype._markAsPending=function(t,e){this._mPendingTasks[t]=(this._mPendingTasks[t]||[]).concat(e);this._mQueuedTasks[t]=[]};s.prototype._getTypedList=function(t,e){var s=[];if(this._mQueuedTasks[t]){s=this._mQueuedTasks[t].slice(0)}if(e){this._markAsPending(t,s)}else if(this._mPendingTasks[t]){s=s.concat(this._mQueuedTasks[t].slice(0))}return s};s.prototype._getAllTasks=function(t){var e=[];e=Object.keys(this._mQueuedTasks).reduce(function(e,s){e=e.concat(this._mQueuedTasks[s]);if(t){this._markAsPending(s,this._mQueuedTasks[s])}return e}.bind(this),[]);if(!t){e=e.concat(Object.keys(this._mPendingTasks).reduce(function(t,e){return t.concat(this._mPendingTasks[e])}.bind(this),[]))}return e};s.prototype.getList=function(t){if(t){return this._getTypedList(t,false)}return this._getAllTasks(false)};s.prototype.getQueuedTasks=function(t){if(t){return this._getTypedList(t,true)}return this._getAllTasks(true)};s.prototype.destroy=function(...e){this.setSuppressEvents(true);this.getList().forEach(function(t){this.cancel(t.id)},this);t.prototype.destroy.apply(this,e)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/TaskRunner", ["sap/ui/dt/TaskManager","sap/ui/dt/Util","sap/base/Log"],function(s,t,e){"use strict";var a=function(e){if(!e||!e.taskManager||!(e.taskManager instanceof s)){throw t.createError("TaskRunner#constructor","sap.ui.dt.TaskRunner: TaskManager required")}this._oTaskManager=e.taskManager;this._sInitialTaskType=e.taskType;this._sObservedTaskType=e.taskType;this._iRequestId=undefined;this.bIsStopped=true;this._oTaskPromise=Promise.resolve()};a.prototype._shouldObserveBreak=function(){if(this.bIsStopped||!this._oTaskManager||this._oTaskManager.bIsDestroyed){this.bIsStopped=true;return true}return false};a.prototype._observe=function(s){this._oTaskPromise=this._oTaskPromise.then(function(){if(this._shouldObserveBreak()){this.stop()}else{this._runTasksFromManager(s)}}.bind(this))};a.prototype._runTasksFromManager=function(){var s=this._oTaskManager.getQueuedTasks(this._sObservedTaskType);if(s.length){this._runTasks(s)}};a.prototype._runTasks=function(s){s.forEach(function(s){if(s.callbackFn){s.callbackFn().then(function(){this._oTaskManager.complete(s.id)}.bind(this)).catch(function(a){this._oTaskManager.complete(s.id);e.error(`${t.errorToString(a)} / related task: ${JSON.stringify(s)}`)}.bind(this))}}.bind(this))};a.prototype.run=function(s){this._sObservedTaskType=s||this._sInitialTaskType;this.bIsStopped=false;this._oTaskManager.attachAdd(this._observe,this);this._observe()};a.prototype.stop=function(){this.bIsStopped=true;this._oTaskManager.detachAdd(this._observe,this)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/Util", ["sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/dt/DesignTimeStatus"],function(r,e,n){"use strict";var t={};var i="sap.ui.dt";function o(r){return!isNaN(parseFloat(r))&&isFinite(r)}t.wrapError=function(r){var e=r instanceof Error&&r||new Error;if(typeof r==="string"){e.message=r}return e};t.isForeignError=function(r,e){if(r instanceof Error){return r.name.indexOf(e||i)===-1}throw t.createError("Util#isForeignError","Wrong parameter specified")};t.createError=function(r,e,n){var t=new Error;var o=(n||i)+(r?`.${r}`:"");t.name=`Error in ${o}`;t.message=e;return t};t.errorToString=function(r){if(typeof r==="string"){return r}else if(r instanceof Error){var e=r.toString();if(r.stack){e+=`\n${r.stack.replace(e,"").trim()}`}return e}throw t.createError("Util#errorToString","Wrong parameter specified")};t.propagateError=function(r,e,n,o){var a=t.wrapError(r);if(t.isForeignError(a,o)){var s=`${o||i}.${e}`;var u=[a.name,a.message].join(" - ");a.name=`Error in ${s}`;a.message=`${n}. Original error: ${u||"¯\\_(ツ)_/¯"}`}return a};t.getObjectType=function(r){if(r instanceof e){return`${r.getMetadata().getName()} (id = '${r.getId()}')`}return typeof r};t.isInteger=function(r){return o(r)&&Math.ceil(r)===r};t.castArray=function(r){var e=[];if(r){if(!Array.isArray(r)){e.push(r)}else{e=r}}return e};t.wrapIntoPromise=function(r){if(typeof r!=="function"){throw t.createError("Util#wrapIntoPromise",`Invalid argument specified. Function is expected, but '${typeof r}' is given`,"sap.ui.dt")}return function(...e){return Promise.resolve().then(function(){return r(...e)})}};t.isWebkit=function(){return r.browser.webkit&&(r.browser.safari||r.browser.chrome&&r.browser.mobile)};t.waitForSynced=function(r,e){return function(...t){e||=function(){};return new Promise(function(i,o){if(r.getStatus()===n.SYNCING){r.attachEventOnce("synced",function(){i(e(...t))});r.attachEventOnce("syncFailed",o)}else{i(e(...t))}})}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/ElementEnablementTest", ["sap/ui/dt/enablement/Test","sap/ui/dt/DesignTime","sap/ui/dt/enablement/Util","sap/base/Log","sap/base/util/ObjectPath","sap/ui/dt/ElementOverlay","sap/ui/qunit/utils/waitForThemeApplied","sap/ui/thirdparty/sinon-4"],function(e,t,i,r,s,n,o,a){"use strict";var d=e.extend("sap.ui.dt.test.ElementEnablementTest",{metadata:{library:"sap.ui.dt",properties:{type:{type:"string"},create:{type:"any"},timeout:{type:"int",defaultValue:0},groupPostfix:{type:"string"}}}});var l=0;var h;d.prototype.init=function(){this._aAggregatedTestResult=null;this._aAggregatedInfoResult=null;this._sAggregation=null;this._$TestAreaDomRef=null;if(l===0){h=a.stub(n.prototype,"_subscribeToMutationObserver")}l++};d.prototype.exit=function(){if(this._oDesignTime){this._oDesignTime.destroy()}l--;if(l===0){h.restore()}window.clearTimeout(this._iTimeout);this._oElement.destroy();if(this._$TestAreaDomRef){this._$TestAreaDomRef.remove();delete this._$TestAreaDomRef}};d.prototype.run=function(){return this._setup().then(function(){this._mResult=this.createSuite("Element Enablement Test");var e=this.addGroup(this._mResult.children,this.getType(),`Given that a DesignTime is created for ${this.getType()}`);this._testAggregations(e.children);this._mResult=this.aggregate(this._mResult);return this._mResult}.bind(this))};d.prototype._createElement=function(){var e=this.getType();var t=this.getCreate();return new Promise(function(i){if(t){i(t());return}sap.ui.require([e.replace(/\./g,"/")],function(e){i(new e)},function(){r.warning(`[Deprecated] Control ${e} could only be loaded via global name`);var t=s.get(e||"");i(new t)})}).then(function(e){if(e.addStyleClass){e.addStyleClass("minSize")}return e})};d.prototype._getTestArea=function(){if(!this._oTestAreaDomRef){this._oTestAreaDomRef=document.createElement("div");this._oTestAreaDomRef.id=`${this.getId()}--testArea`;this._oTestAreaDomRef.style.height="500px";this._oTestAreaDomRef.style.width="1000px";document.body.append(this._oTestAreaDomRef)}return this._oTestAreaDomRef};d.prototype._setup=function(){window.clearTimeout(this._iTimeout);this._bNoRenderer=false;this._bErrorDuringRendering=false;return new Promise(function(e){o().then(function(){return this._createElement()}.bind(this)).then(function(i){this._oElement=i;try{this._oElement.getRenderer()}catch(e){this._bNoRenderer=true}if(!this._bNoRenderer){try{this._oElement.placeAt(this._getTestArea())}catch(e){this._bErrorDuringRendering=true}if(!this._bErrorDuringRendering){this._oDesignTime=new t({rootElements:[this._oElement]});this._oDesignTime.attachEventOnce("synced",function(){if(this.getTimeout()){this._iTimeout=window.setTimeout(function(){e()},this.getTimeout())}else{e()}},this)}else{e()}}else{e()}}.bind(this))}.bind(this))};d.prototype._testAggregations=function(t){var r=this.addGroup(t,"Aggregations","Each aggregation needs to be ignored or has a visible domRef maintained in the metadata",this.getGroupPostfix());if(this._bNoRenderer){this.addTest(r.children,true,"Control has no renderer","Control has no renderer, not supported by the element test (requires a special element test)",e.STATUS.UNKNOWN)}else if(this._bErrorDuringRendering){this.addTest(r.children,true,"Error during rendering","Element can't be rendered, not supported by the DesignTime (please, provide a create method for this element)",e.STATUS.ERROR)}else{var s=i.getAggregationsInfo(this._oElement);for(var n in s){var o=s[n];var a=this.addGroup(r.children,n,o.ignored?"Aggregation ignored":"Aggregation tests");if(!o.ignored){this.addTest(a.children,o.overlayVisible,"Overlay Visible","Overlay domRef is visible in DOM");if(o.domRefDeclared){this.addTest(a.children,o.domRefDeclared,"Dom Ref Declared","DomRef is declared in design time metadata");this.addTest(a.children,o.domRefFound,"Dom Ref Found","Declared DomRef is found in DOM");this.addTest(a.children,o.domRefVisible,"Dom Ref Visible","Declared DomRef is visible")}else if(o.overlayVisible){this.addTest(a.children,o.overlayGeometryCalculatedByChildren,"Overlay Geometry calculated by children","Control might work based on DT Heuristic, but safer with domRefDeclared",e.STATUS.PARTIAL_SUPPORTED)}else{this.addTest(a.children,false,"Overlay Dom Ref","Overlay domRef is not declared and aggregation overlay is not visible (please, declare domRef for this aggregation)",e.STATUS.PARTIAL_SUPPORTED)}if(o.overlayTooSmall){this.addTest(a.children,false,"Overlay too small","Aggregation Overlay is too small to be accessible, please ensure to render it big enough that it can be reach by a user. If content is needed, provide a create method for this element",e.STATUS.PARTIAL_SUPPORTED)}}}}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/Test", ["sap/ui/base/ManagedObject"],function(t){"use strict";var e=t.extend("sap.ui.dt.test.Test",{metadata:{abstract:true}});e.STATUS={SUPPORTED:{key:"SUPPORTED",text:"supported",value:3},PARTIAL_SUPPORTED:{key:"PARTIAL_SUPPORTED",text:"partial supported",value:2},NOT_SUPPORTED:{key:"NOT_SUPPORTED",text:"not supported",value:1},ERROR:{key:"ERROR",text:"error",value:0},UNKNOWN:{key:"UNKNOWN",text:"unknown",value:0}};e.TYPE={TEST:"Test",GROUP:"Group",SUITE:"Suite"};e.prototype.createSuite=function(t,s){return this.add(null,false,t,s,null,e.TYPE.SUITE)};e.prototype.addGroup=function(t,s,r,u){return this.add(t,true,s+(u?` (${u})`:""),r,null,e.TYPE.GROUP)};e.prototype.addTest=function(t,s,r,u,a){return this.add(t,s,r,u,a,e.TYPE.TEST)};e.prototype.add=function(t,s,r,u,a,i){if(!a){if(s){a=e.STATUS.SUPPORTED}else{a=e.STATUS.NOT_SUPPORTED}}var n={name:r,message:u,result:s,status:a,type:i,statistic:{},children:[]};if(t){t.push(n)}return n};e.prototype.run=function(){throw new Error("Abstract method")};e.prototype.aggregate=function(t){if(t.type!==e.TYPE.TEST&&t.children.length>0){var s=t.children;var r=s.map(function(t){var e=this.aggregate(t);return{result:e.result,status:e.status}},this);if(r.length===1){r.push(r[0])}var u=r.reduce(function(t,e){return{result:this._getResult(t,e),status:this._getStatus(t,e),statistic:this._getStatistic(t,e)}}.bind(this));t.result=u.result;t.status=u.status;t.statistic=u.statistic}return t};e.prototype._getResult=function(t,e){return!t.result?false:e.result};e.prototype._getStatus=function(t,e){return t.status.value<e.status.value?t.status:e.status};e.prototype._getStatistic=function(t,e){var s=this._getStatisticObjectForEntry(t);if(t!==e){s[e.status.key]++}return s};e.prototype._getStatisticObjectForEntry=function(t){var s={};if(!t.statistic){for(var r in e.STATUS){s[r]=0}s[t.status.key]++}else{s=t.statistic}return s};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/Util", ["sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayRegistry"],function(e,a,t){"use strict";var i=5;var r={};r.getInfo=function(e){var a=e.getMetadata();var i=t.getOverlay(e);return{metadata:a,overlay:i}};r.getAggregationInfo=function(e,t){var r={ignored:true,domRefDeclared:false,domRefFound:false,domRefVisible:false,overlayTooSmall:false,overlayGeometryCalculatedByChildren:false,overlayVisible:false};var o;var l=this.getInfo(e);var n=l.overlay.getAggregationOverlay(t);if(n){o=n.getDesignTimeMetadata()}if(o&&!o.isIgnored(e)){r.ignored=false;r.domRefDeclared=!!o.getDomRef();var g=n.getAssociatedDomRef();if(g){r.domRefFound=true;r.domRefVisible=a.isVisible(g.get(0))}var f=n.getGeometry();if(f){var s=f.size;r.overlayTooSmall=s.width<=i||s.height<=i;r.overlayGeometryCalculatedByChildren=!f.domRef;r.overlayVisible=f.visible}}return r};r.getAggregationsInfo=function(a){var t={};e.iterateOverAllPublicAggregations(a,function(e){t[e.name]=this.getAggregationInfo(a,e.name)}.bind(this));return t};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/elementDesigntimeTest", ["sap/ui/dt/enablement/report/QUnitReport","sap/ui/dt/enablement/ElementEnablementTest"],function(e,n){"use strict";var t=function(t){var r=new n(t);return r.run().then(function(n){var t=new e({data:n});r.destroy();t.destroy()})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/libraryTest", ["sap/ui/core/Lib","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel"],function(e,t,n){"use strict";var i=[];var r=[];var a={};var s;function o(e,t){return t.hasText(e)||t.getText(e,[],true)!==undefined}var u=function(o){return new Promise(function(u){e.load({name:o}).then(function(l){var d=l.controls.concat(l.elements);s=o;sap.ui.require(d.map(function(e){return e.replace(/\./g,"/")}),function(...s){var l=e.all();try{var d=new t({bundleUrl:sap.ui.require.toUrl(o,"messagebundle.properties"),bundleLocale:"en"});var f=new t({bundleUrl:sap.ui.require.toUrl(`${o}.designtime`,"messagebundle.properties"),bundleLocale:"en"});a.runtime=d.getResourceBundle();a.designtime=f.getResourceBundle();Object.keys(l).forEach(function(e){if(o!==e){d.enhance({bundleUrl:sap.ui.require.toUrl(e,"messagebundle.properties"),bundleLocale:"en"});f.enhance({bundleUrl:sap.ui.require.toUrl(`${e}.designtime`,"messagebundle.properties"),bundleLocale:"en"})}})}catch(e){}var p=[];var m=[];for(var g=0;g<s.length;g++){if(s[g].getMetadata()._oDesignTime){p.push(s[g].getMetadata().loadDesignTime());m.push(s[g].getMetadata())}}Promise.all(p).then(function(e){var t=0;i=e;r=i.map(function(e){var i=new n(e);i._oControlMetadata=m[t];t++;return i});c();u()})})})})};u.version=2;var l={"/":{optional:false,check(e,t,n){e.strictEqual(typeof t,"object",`${n} is an object`)}},"/designtimeModule":{optional:false,check(e,t,n){e.strictEqual(typeof t,"string",`${n} defines /designtimeModule : ${t}`)}},"/actions":{optional:true,check(e,t,n){Object.keys(t).forEach(function(i){if(t[i].changeType){e.strictEqual(typeof t[i].changeType,"string",`${n} defines ${i} with changetype:${t[i].changeType}`)}else if(typeof t[i]==="string"){e.strictEqual(typeof t[i],"string",`${n} defines ${i} as string`)}else if(i==="settings"&&typeof t[i]==="object"){l["/actions"].check(e,t[i],n)}else{e.strictEqual(typeof t[i],"function",`${n} defines ${i} as function`)}})}},"/name":{optional:true,check(e,t,n){if(typeof t==="string"&&t.indexOf("{")===0&&t.indexOf("}")===t.length-1){return true}var i=["singular","plural"];i.forEach(function(i){if(typeof t[i]==="function"){e.strictEqual(typeof t[i],"function",`${n} defines mandatory entry /name/${i}`)}else{e.strictEqual(typeof t[i],"string",`${n} defines mandatory entry /name/${i}`)}});i.forEach(function(i){var r=false;if(typeof t[i]==="function"){e.strictEqual(typeof t[i],"function",`${n} defines function for translation of entry /name/${i}`);e.strictEqual(typeof t[i](),"string",`Assuming that ${i} with ${t[i].toString()} returns a translation at runtime`);return}if(t[i].toUpperCase()!==t[i]){e.ok(true,`Assuming that ${i} with ${t[i]} needs currently no translation`);return}if(a.designtime){r=o(t[i],a.designtime);e.strictEqual(r,true,`${t[i]} found in designtime message bundle`)}if(a.runtime){if(r){e.strictEqual(o(t[i],a.runtime),false,`${t[i]} found in runtime message bundle and designtime message bundle, please delete the entry from the runtime message bundle (messagebundle.properties + messagebundle_en.properties)`)}else{e.strictEqual(o(t[i],a.runtime),true,`${t[i]} found in runtime message bundle only, consider to move this text to the designtime message bundle`)}}});return undefined}},"/palette":{optional:true,check(e,t,n){var i=["ACTION","DISPLAY","LAYOUT","LIST","INPUT","CONTAINER","CHART","TILE","DIALOG"];e.strictEqual(typeof t,"object",`${n} defines optional entry /palette/`);e.strictEqual(i.indexOf(t.group)>-1,true,`palette entry defines valid group ${t.group}`);if(t.icons){return Promise.all(Object.keys(t.icons).map(function(n){var i=t.icons[n];e.strictEqual(typeof i,"string",`palette/icons/${n} entry defines icon path ${i}`);return new Promise(function(t,n){var r=new XMLHttpRequest;r.open("GET",`${sap.ui.require.toUrl(i)}`,true);r.onload=function(){if(r.readyState===4){if(r.status===200){if(i.indexOf(".svg")===i.length-4){e.equal(r.responseXML.documentElement&&r.responseXML.documentElement.tagName,"svg",`File ${i} starts with a svg node`)}t()}else{n()}}};r.send()})}))}return undefined}},"/templates":{optional:true,check(e,t){if(t.create){var n=t.create;e.strictEqual(typeof n,"string",`templates/create entry defines fragment path to ${n}`);return new Promise(function(t,i){var r=new XMLHttpRequest;r.open("GET",`${sap.ui.require.toUrl(n)}`,true);r.onload=function(){if(r.readyState===4){if(r.status===200){e.ok(r.responseXML.documentElement&&r.responseXML.documentElement.localName==="FragmentDefinition",`File ${n} exists and starts with a FragmentDefinition node`);t()}else{i()}}};r.send()})}return undefined}}};function c(){QUnit.test("Checking library.designtime.js",function(t){var n=e.all()[s];if(n.designtime){var i=t.async();sap.ui.require([n.designtime],function(e){t.ok(e!==null,`${n.designtime} loaded successfully`);i()})}else{t.ok(true,`No library.designtime.js ${s}`)}});QUnit.test("Checking loaded designtime data",function(e){i.forEach(function(t){e.strictEqual(t!==null,true,"Designtime data found and loaded successful");e.strictEqual(typeof t,"object","Designtime data returned an object")})});r.forEach(function(e){var t=e._oControlMetadata;var n=t.getName();QUnit.test(`${n}: Checking entries in designtime data`,function(t){return Promise.all(Object.keys(l).map(function(i){var r=l[i];var a=e.getProperty(i);if(a===undefined&&!r.optional){t.equal(false,true,`${n} does not define mandatory entry ${i}`);return Promise.resolve()}else if(a!==undefined&&r.optional){t.equal(true,true,`${n} does define optional entry ${i}`);return r.check(t,a,n)}else if(a!==undefined&&!r.optional){t.equal(true,true,`${n} does define mandatory entry ${i}`);return r.check(t,a,n)}return undefined}))})})}return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/report/LibraryReport", ["sap/ui/core/Lib","sap/ui/dt/enablement/Test","sap/ui/dt/enablement/ElementEnablementTest"],function(e,t,r){"use strict";var a=t.extend("sap.ui.dt.enablement.report.LibraryReport",{metadata:{library:"sap.ui.dt",properties:{libraryName:{type:"string"},testData:{type:"object"}}}});a.prototype.run=function(){this._aResult=[];var t=this.getTestData()||{};var a=this.getLibraryName();var n=[];var i=e.all()[a];if(i){var s=i.controls;s.forEach(function(e){var a=t[e];if(!a&&a!==false){a={}}if(a!==false){a.type=e;var i=null;if(a.create){i=Object.assign({},a);delete i.create;a.groupPostfix="with create method"}n.push(new r(a));if(i){n.push(new r(i))}}})}var u=[];var c=function(e){if(e){u.push(e)}var t=n.shift();if(t){return t.run().then(function(e){t.destroy();return c(e)})}return Promise.resolve(u)};return c().then(function(e){var t=this.createSuite("Library Enablement Test");e.forEach(function(e){var r=e.children[0];var a=t.children[t.children.length-1];if(a&&r.name===a.name){a.children=a.children.concat(r.children)}else{t.children.push(r)}});t=this.aggregate(t);return t}.bind(this))};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/report/QUnitReport", ["sap/ui/base/ManagedObject"],function(e){"use strict";var t=e.extend("sap.ui.dt.enablement.report.QUnitReport",{metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}}},init(){if(!QUnit){throw new Error("QUnit is required for this report.")}},setData(e){if(e){var t=e.children;t.forEach(function(e){this._createModule(e)},this)}this.setProperty("data",e)},_createModule(e){QUnit.module(e.message);e.children.forEach(function(e){this._createTest(e)},this)},_createTest(e){QUnit.test(`${e.name}: ${e.message}`,function(t){e.children.forEach(function(e){this._createAssertion(t,e)},this)}.bind(this))},_createAssertion(e,t){if(t.children.length>0){t.children.forEach(function(i){e.ok(i.result,`${t.name}: ${i.message}`)})}else{e.ok(true,`${t.name}: ${t.message}`)}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/report/Statistic", ["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/layout/form/SimpleForm","sap/m/Label","sap/m/Text","./StatisticRenderer"],function(t,e,o,r,i,s){"use strict";var a=t.extend("sap.ui.dt.enablement.report.Statistic",{metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}},aggregations:{_form:{type:"sap.ui.layout.form.SimpleForm",hidden:true,multiple:false}}},init(){this._oModel=null;this.setAggregation("_form",this._createForm())},exit(){this.setData(null)},setData(t){if(this._oModel){this._oModel.destroy();delete this._oModel}if(t){this._oModel=new e(t);this._getForm().setModel(this._oModel)}else{this._getForm().setModel(null)}this.setProperty("data",t)},_createForm(){var t=new o(`${this.getId()}--form`,{editable:false,layout:"ResponsiveGridLayout",title:"Statistics",content:[new r(`${this.getId()}--form-supported-label`,{text:"Supported"}),new i(`${this.getId()}--form-supported-value`,{text:"{/statistic/SUPPORTED}"}),new r(`${this.getId()}--form-partial-supported-label`,{text:"Partial Supported"}),new i(`${this.getId()}--form-partial-supported-value`,{text:"{/statistic/PARTIAL_SUPPORTED}"}),new r(`${this.getId()}--form-not-supported-label`,{text:"Not Supported"}),new i(`${this.getId()}--form-not-supported-value`,{text:"{/statistic/NOT_SUPPORTED}"}),new r(`${this.getId()}--form-unknown-label`,{text:"Unknown"}),new i(`${this.getId()}--form-unknown-value`,{text:"{/statistic/UNKNOWN}"}),new r(`${this.getId()}--form-error-label`,{text:"Error"}),new i(`${this.getId()}--form-error-value`,{text:"{/statistic/ERROR}"})]});return t},_getForm(){return this.getAggregation("_form")},renderer:s});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/report/StatisticRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(e,t){e.openStart("div",t);e.class("sapUiDtStatisticReport");e.openEnd();e.renderControl(t._getForm());e.close("div")};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/report/Table", ["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/table/TreeTable","sap/ui/table/Column","sap/ui/table/rowmodes/Fixed","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/SearchField","sap/m/Label","sap/m/Text","sap/m/RatingIndicator","./TableRenderer"],function(e,t,a,l,s,i,r,o,n,u,d,h,b){"use strict";var m=e.extend("sap.ui.dt.enablement.report.Table",{metadata:{library:"sap.ui.dt",properties:{data:{type:"object"}},aggregations:{_table:{type:"sap.ui.table.TreeTable",hidden:true,multiple:false}}},init(){this.setAggregation("_table",this._createTable())},exit(){clearTimeout(this._iFilterTimeout);this.setData(null)},setData(e){if(this._oModel){this._oModel.destroy();delete this._oModel}if(e){this._oModel=new t(e);this._getTable().setModel(this._oModel)}else{this._getTable().setModel(null)}this.setProperty("data",e)},filter(e){var t=this._getTable().getModel();if(t){if(e.length>0){var a=this.getData();var l=a.children.filter(function(t){if(e.indexOf("status=")!==-1){return t.status.value===e.substring(e.indexOf("=")+1)}return t.name.toLowerCase().indexOf(e.toLowerCase())!==-1});t.setData(l)}else{t.setData(this.getData())}}},_createTable(){var e=new a(`${this.getId()}--table`,{selectionMode:"MultiToggle",rowMode:new s({rowCount:20}),enableSelectAll:false,ariaLabelledBy:"title",extension:this._createToolbar(),rows:"{path:'/', parameters: {arrayNames:['children']}}",columns:[this._createTextColumn("name","Name","{name}"),this._createRatingIndicatorColumn("value","Status Values","{status/value}","{status/text} ({status/value})"),this._createTextColumn("status","Status","{status/text}"),this._createTextColumn("message","Message","{message}")]});return e},_createToolbar(){return new i(`${this.getId()}--toolbar`,{content:[new r(`${this.getId()}--toolbar-spacer`),new o(`${this.getId()}--toolbar-collapse-button`,{text:"Collapse all",press:this._onCollapseAll.bind(this)}),new o(`${this.getId()}--toolbar-expand-button`,{text:"Expand",press:this._onExpandSecondLevel.bind(this)}),new n(`${this.getId()}--toolbar-search-field`,{liveChange:this._onSearch.bind(this)})]})},_onSearch(e){var t=e.getParameter("newValue");clearTimeout(this._iFilterTimeout);this._iFilterTimeout=setTimeout(function(){this.filter(t)}.bind(this),100)},_createTextColumn(e,t,a){return this._createColumn(e,t,new d({text:a}))},_createRatingIndicatorColumn(e,t,a,l){return this._createColumn(e,t,new h({maxValue:3,value:a,enabled:false,tooltip:l}))},_createColumn(e,t,a){return new l(`${this.getId()}--table-column-${e}`,{label:new u({text:t}),width:"13em",template:a})},_getTable(){return this.getAggregation("_table")},_onCollapseAll(){var e=this._getTable();e.collapseAll()},_onExpandSecondLevel(){var e=this._getTable();e.expandToLevel(2)},renderer:b});return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/enablement/report/TableRenderer", function(){"use strict";var e={apiVersion:2};e.render=function(e,n){e.openStart("div",n);e.class("sapUiDtTableReport");e.openEnd();e.renderControl(n._getTable());e.close("div")};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/library", ["sap/ui/base/ManagedObjectMetadata","sap/ui/core/Lib","sap/ui/dt/SelectionMode","sap/ui/core/library"],function(e,i){"use strict";var t=i.init({name:"sap.ui.dt",version:"1.120.31",dependencies:["sap.ui.core"],types:["sap.ui.dt.SelectionMode"],interfaces:[],controls:[],elements:[]});e.setDesignTimeDefaultMapping({"not-adaptable":"sap/ui/dt/designtime/notAdaptable.designtime","not-adaptable-tree":"sap/ui/dt/designtime/notAdaptableTree.designtime","not-adaptable-visibility":"sap/ui/dt/designtime/notAdaptableVisibility.designtime","not-removable":"sap/ui/dt/designtime/notAdaptableVisibility.designtime"});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/ContextMenu", ["sap/ui/dt/Plugin","sap/m/Menu","sap/m/MenuItem","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/dt/util/_createPromise","sap/ui/Device","sap/base/assert","sap/ui/events/KeyCodes"],function(e,t,n,o,i,r,s,u,a){"use strict";var h=e.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{library:"sap.ui.dt",properties:{contextElement:{type:"object"},openOnClick:{type:"boolean",defaultValue:true}},events:{openedContextMenu:{},closedContextMenu:{}}}});var c="sapUiDtContextMenu";var l="sapUiDtContextMiniMenu";h.prototype.init=function(){this.oContextMenuControl=new t;this.oContextMenuControl.attachItemSelected(this._onItemSelected,this);this.oContextMenuControl.attachClosed(this._contextMenuClosed,this);this.oContextMenuControl.addStyleClass(c);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[]};h.prototype.exit=function(){delete this._aMenuItems;if(this.oContextMenuControl){this.oContextMenuControl.destroy()}};h.prototype.addMenuItem=function(e,t,n){var o={menuItem:e,fromPlugin:!!t,bPersistOneTime:n};this._aMenuItems.push(o)};h.prototype.registerElementOverlay=function(e){e.attachBrowserEvent("click",this._openContextMenu,this);e.attachBrowserEvent("touchstart",this._openContextMenu,this);e.attachBrowserEvent("contextmenu",this._openContextMenu,this);e.attachBrowserEvent("keydown",this._onKeyDown,this);e.attachBrowserEvent("keyup",this._onKeyUp,this)};h.prototype.deregisterElementOverlay=function(e){e.detachBrowserEvent("click",this._openContextMenu,this);e.detachBrowserEvent("touchstart",this._openContextMenu,this);e.detachBrowserEvent("contextmenu",this._openContextMenu,this);e.detachBrowserEvent("keydown",this._onKeyDown,this);e.detachBrowserEvent("keyup",this._onKeyUp,this)};h.prototype.open=function(e,t,i,s){var u;function a(o,i){i.forEach(function(i,r){var s=typeof i.text==="function"?i.text(e):i.text;var h=typeof i.enabled==="function"?i.enabled(u):i.enabled;var c;if(!t){c=s}o.addItem(new n({key:i.id,icon:i.icon,text:s,enabled:h}).setTooltip(c));if(i.submenu){a(o.getItems()[r],i.submenu)}})}this._bContextMenu=!!t;if(this._bContextMenu){this.oContextMenuControl.removeStyleClass(l)}else{this.oContextMenuControl.addStyleClass(l)}var h=e.getElement();if(this._fnCancelMenuPromise){if(this.getContextElement()===h){return}this._fnCancelMenuPromise();delete this._fnCancelMenuPromise}this.setContextElement(h);this.getDesignTime().getSelectionManager().attachChange(this._onSelectionChanged,this);u=this.getSelectedOverlays().filter(function(t){return t!==e});u.unshift(e);this._aMenuItems=this._aMenuItems.filter(function(e){if(e.bPersistOneTime){e.bPersistOneTime=false;return true}return!e.fromPlugin});this.oContextMenuControl.destroyItems();var c=Promise.resolve();if(!i){var p=r(function(e,t){o.waitForSynced(this.getDesignTime())().then(e).catch(t)}.bind(this));this._fnCancelMenuPromise=p.cancel;c=p.promise.then(function(){this._aGroupedItems=[];this._aSubMenus=[];var e=[];var t=this.getDesignTime().getPlugins();t.forEach(function(t){var n=t.getMenuItems(u);if(!(n instanceof Promise)){n=Promise.resolve(n)}e.push(n)});var n=r(function(t,n){Promise.all(e).then(t).catch(n)});this._fnCancelMenuPromise=n.cancel;return n.promise}.bind(this)).then(function(e){return e.reduce(function(e,t){return e.concat(t)})}).then(function(e){e.forEach(function(e){var n=typeof e.enabled==="function"?e.enabled(u):e.enabled;if(!n&&!t){return}if(e.group!==undefined&&!t){this._addMenuItemToGroup(e)}else if(e.submenu!==undefined){this._addSubMenu(e)}else{this.addMenuItem(e,true)}}.bind(this));this._addItemGroupsToMenu();delete this._fnCancelMenuPromise}.bind(this))}c.then(function(){var t=this._aMenuItems.map(function(e){return e.menuItem});if(t.length>0){t=this._sortMenuItems(t);a(this.oContextMenuControl,t);this.oContextMenuControl.openAsContextMenu(s,e)}this.fireOpenedContextMenu()}.bind(this)).catch(function(e){throw o.createError("ContextMenu#open",`An error occurred during calling getMenuItems: ${e}`)})};h.prototype._sortMenuItems=function(e){return e.sort(function(e,t){if(!e.rank&&!t.rank){return 0}if(!e.rank&&t.rank){return-1}if(e.rank&&!t.rank){return 1}return e.rank-t.rank})};h.prototype._onItemSelected=function(e){this._ensureSelection(this._oCurrentOverlay);function t(e,t){var n=e.responsible||this.getSelectedOverlays()||[];u(n.length>0,"sap.ui.rta - Opening context menu, with empty selection - check event order");var o={};o.eventItem=t;o.contextElement=this.getContextElement();e.handler(n,o)}var n=e.getParameter("item").getKey();this._aMenuItems.some(function(o){var i=o.menuItem;if(n===o.menuItem.id){t.apply(this,[i,e]);return true}else if(i.submenu){i.submenu.some(function(o){if(n===o.id){t.apply(this,[o,e]);return true}}.bind(this))}},this)};h.prototype._onKeyUp=function(e){var t=i.getOverlay(e.currentTarget.id);if(e.keyCode===a.ENTER&&t.getIgnoreEnterKeyUpOnce()){t.setIgnoreEnterKeyUpOnce(false);e.stopPropagation();e.preventDefault();return}if((e.keyCode===a.SPACE||e.keyCode===a.ENTER)&&e.shiftKey===false&&e.altKey===false&&e.ctrlKey===false){if(!this._checkForPluginLock()){this._openContextMenu(e);e.stopPropagation();e.preventDefault()}}if(e.keyCode===a.F10&&e.shiftKey===true&&e.altKey===false&&e.ctrlKey===false){if(!this._checkForPluginLock()){this._openContextMenu(e);e.stopPropagation();e.preventDefault()}}};h.prototype._onKeyDown=function(e){var t=i.getOverlay(e.currentTarget.id);if(e.keyCode===a.SPACE&&e.shiftKey===false&&e.altKey===false&&e.ctrlKey===false){if(t&&t.isSelectable()&&!this._checkForPluginLock()){t.setSelected(true);e.stopPropagation();e.preventDefault()}}};h.prototype._openContextMenu=function(e){var t=i.getOverlay(e.currentTarget.id);if(t&&t.isSelectable()&&t.getSelected()){this._oCurrentOverlay=t;var n=e.type==="contextmenu"||e.keyCode===a.F10;this.open(t,n,undefined,e)}};h.prototype._contextMenuClosed=function(){this.oContextMenuControl.removeStyleClass(l);this.fireClosedContextMenu()};h.prototype._onSelectionChanged=function(){this.getDesignTime().getSelectionManager().detachChange(this._onSelectionChanged,this)};h.prototype._ensureSelection=function(e){if(e&&!e.isSelected()){e.setSelected(true)}};h.prototype._checkForPluginLock=function(){if(s.os.ios){return false}if(this.getDesignTime().getBusyPlugins().length){return true}return false};h.prototype._addMenuItemToGroup=function(e){var t=this._aGroupedItems.some(function(t){if(t.sGroupName===e.group){t.aGroupedItems.push(e);return true}});if(!t){this._aGroupedItems.push({sGroupName:e.group,aGroupedItems:[e]})}};h.prototype._addSubMenu=function(e){e.submenu.forEach(function(t){t.handler||=e.handler});this._aSubMenus.push({sSubMenuId:e.id,aSubMenuItems:e.submenu});this.addMenuItem(e,true)};h.prototype._addItemGroupsToMenu=function(){this._aGroupedItems.forEach(function(e){if(e.aGroupedItems.length===1){this.addMenuItem(e.aGroupedItems[0],true)}else{this.addMenuItem({id:`${e.sGroupName}-groupItem`,enabled:true,text:e.sGroupName,icon:e.aGroupedItems[0].icon,rank:e.aGroupedItems[0].rank,submenu:e.aGroupedItems},true)}}.bind(this))};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/ControlDragDrop", ["sap/ui/dt/plugin/DragDrop","sap/ui/dt/plugin/ElementMover","sap/ui/dt/ElementUtil"],function(e,t,r){"use strict";var o=e.extend("sap.ui.dt.plugin.ControlDragDrop",{metadata:{library:"sap.ui.dt",properties:{draggableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"},insertAfterElement:{type:"boolean",defaultValue:false}},associations:{}}});var i="sapUiDtOverlayDropZone";o.prototype.init=function(...r){e.prototype.init.apply(this,r);this.setElementMover(new t)};o.prototype.setElementMover=function(e){var t=this.getElementMover();if(t!==e){if(t){t.destroy()}this.setProperty("elementMover",e)}};o.prototype.setDraggableTypes=function(e){this.getElementMover().setMovableTypes(e);return this.setProperty("draggableTypes",e)};o.prototype.registerElementOverlay=function(t){var r=t.getElement();this.getElementMover().checkMovable(t).then(function(o){if(this.getElementMover().isMovableType(r)&&o){t.setMovable(true)}if(this.oDraggedElement){this.getElementMover().activateTargetZonesFor(t,i)}e.prototype.registerElementOverlay.call(this,t)}.bind(this))};o.prototype.deregisterElementOverlay=function(...t){const[r]=t;e.prototype.deregisterElementOverlay.apply(this,t);r.setMovable(false);if(this.oDraggedElement){this.getElementMover().deactivateTargetZonesFor(r,i)}};o.prototype.getDraggedOverlay=function(){return this._oDraggedOverlay};o.prototype.onDragStart=function(e){this._oDraggedOverlay=e;this.getElementMover().setMovedOverlay(e);this.getElementMover().activateAllValidTargetZones(this.getDesignTime(),i)};o.prototype.onDragEnd=function(){delete this._oPreviousTarget;this.getElementMover().deactivateAllTargetZones(this.getDesignTime(),i);delete this._oDraggedOverlay;this.getElementMover().setMovedOverlay(null)};o.prototype.onDragEnter=function(e){var t=this.getDraggedOverlay();if(e.getElement()!==t.getElement()&&e!==this._oPreviousTarget){this.getElementMover().repositionOn(t,e)}this._oPreviousTarget=e};o.prototype.onAggregationDragEnter=function(e){var t=e.getAggregationName();var o=e.getElement();if(r.getAggregation(o,t).length===0){delete this._oPreviousTarget;var i=this.getDraggedOverlay();this.getElementMover().insertInto(i,e,this.getInsertAfterElement())}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/CutPaste", ["sap/ui/dt/Plugin","sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/ui/Device"],function(e,t,r,o,n,i,s){"use strict";var a=true;var l=e.extend("sap.ui.dt.plugin.CutPaste",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"}},associations:{}}});l.prototype.init=function(){this.setElementMover(new t)};l.prototype.registerElementOverlay=function(e){var t=e.getElement();this.getElementMover().checkMovable(e).then(function(r){e.attachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().isMovableType(t)&&r){e.setMovable(true)}if(this.getElementMover().getMovedOverlay()){this.getElementMover().activateTargetZonesFor(this.getElementMover().getMovedOverlay())}}.bind(this)).catch(function(e){throw o.createError("CutPaste#registerElementOverlay",`An error occurred during checkMovable: ${e}`)})};l.prototype.deregisterElementOverlay=function(e){e.setMovable(false);e.detachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().getMovedOverlay()){this.getElementMover().deactivateTargetZonesFor(this.getElementMover().getMovedOverlay())}};l.prototype.setMovableTypes=function(e){this.getElementMover().setMovableTypes(e);return this.setProperty("movableTypes",e)};l.prototype.setElementMover=function(e){e.setMovableTypes(this.getMovableTypes());return this.setProperty("elementMover",e)};l.prototype.getCuttedOverlay=function(){return this.getElementMover().getMovedOverlay()};l.prototype.isElementPasteable=function(e){var t=this._getTargetZoneAggregation(e);if(t||r.isInTargetZoneAggregation(e)){return true}return false};l.prototype._onKeyDown=function(e){var t=n.getOverlay(e.currentTarget.id);var r=s.os.macintosh?e.metaKey:e.ctrlKey;if(e.keyCode===i.X&&e.shiftKey===false&&e.altKey===false&&r===true){this.cut(t);e.stopPropagation()}else if(e.keyCode===i.V&&e.shiftKey===false&&e.altKey===false&&r===true){if(this.getElementMover().getMovedOverlay()){this.paste(t)}e.stopPropagation()}else if(e.keyCode===i.ESCAPE){this.stopCutAndPaste();e.stopPropagation()}};l.prototype.cut=function(e){this.stopCutAndPaste();if(e.isMovable()){this.getElementMover().setMovedOverlay(e);e.addStyleClass("sapUiDtOverlayCutted");return this.getElementMover().activateAllValidTargetZones(this.getDesignTime()).then(function(){e.focus()})}return Promise.resolve(undefined)};l.prototype._executePaste=function(e){var t=this.getElementMover().getMovedOverlay();if(!t){return false}var o=false;if(!this._isForSameElement(t,e)){var n=this._getTargetZoneAggregation(e);if(n){this.getElementMover().insertInto(t,n);o=true}else if(r.isInTargetZoneAggregation(e)){this.getElementMover().repositionOn(t,e,a);o=true}}if(o){t.setSelected(true);setTimeout(function(){t.focus()},0)}return o};l.prototype.paste=function(e){var t=this._executePaste(e);if(t===true){this.stopCutAndPaste()}};l.prototype.stopCutAndPaste=function(){var e=this.getElementMover().getMovedOverlay();if(e){e.removeStyleClass("sapUiDtOverlayCutted");this.getElementMover().setMovedOverlay(null);this.getElementMover().deactivateAllTargetZones(this.getDesignTime())}};l.prototype._isForSameElement=function(e,t){return t.getElement()===e.getElement()};l.prototype._getTargetZoneAggregation=function(e){var t=e.getChildren();var r=t.filter(function(e){return e.isTargetZone()});if(r.length>0){return r[0]}return null};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/DragDrop", ["sap/ui/base/Object","sap/ui/core/Element","sap/ui/dt/Plugin","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/OverlayRegistry","sap/ui/thirdparty/jquery","sap/ui/Device"],function(t,e,r,a,o,n,jQuery,i){"use strict";var g=r.extend("sap.ui.dt.plugin.DragDrop",{metadata:{abstract:true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});var s=7;var h=false;var c;g.prototype._preventScrollOnTouch=function(t){if(h){t.preventDefault()}};g.prototype.init=function(...t){r.prototype.init.apply(this,t);document.addEventListener("touchmove",this._preventScrollOnTouch,true);this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={}};g.prototype.exit=function(...t){r.prototype.exit.apply(this,t);document.removeEventListener("touchmove",this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler};g.prototype.registerElementOverlay=function(t){t.attachEvent("movableChange",this._onMovableChange,this);if(t.isMovable()){this._attachDragEvents(t)}t.attachBrowserEvent("dragover",this._onDragOver,this);t.attachBrowserEvent("dragenter",this._onDragEnter,this);t.attachBrowserEvent("dragleave",this._onDragLeave,this)};g.prototype.registerAggregationOverlay=function(t){t.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!i.browser.webkit){this._attachDragScrollHandler(t)}};g.prototype.deregisterElementOverlay=function(t){t.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(t);t.detachBrowserEvent("dragover",this._onDragOver,this);t.detachBrowserEvent("dragenter",this._onDragEnter,this);t.detachBrowserEvent("dragleave",this._onDragLeave,this)};g.prototype.deregisterAggregationOverlay=function(t){t.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!i.browser.webkit){this._removeDragScrollHandler(t);if(t.getDomRef()){this._clearScrollIntervalFor(t.getDomRef().getAttribute("id"))}}};g.prototype._attachDragEvents=function(t){t.attachBrowserEvent("dragstart",this._onDragStart,this);t.attachBrowserEvent("drag",this._onDrag,this);t.attachBrowserEvent("dragend",this._onDragEnd,this);t.attachBrowserEvent("touchstart",this._onTouchStart,this)};g.prototype._detachDragEvents=function(t){t.detachBrowserEvent("dragstart",this._onDragStart,this);t.detachBrowserEvent("drag",this._onDrag,this);t.detachBrowserEvent("dragend",this._onDragEnd,this);t.detachBrowserEvent("touchstart",this._onTouchStart,this)};g.prototype.onMovableChange=function(){};g.prototype.onDragStart=function(){};g.prototype.onDragEnd=function(){};g.prototype.onDrag=function(){};g.prototype.onDragEnter=function(){};g.prototype.onDragLeave=function(){};g.prototype.onDragOver=function(){};g.prototype.onAggregationDragEnter=function(){};g.prototype.onAggregationDragOver=function(){};g.prototype.onAggregationDragLeave=function(){};g.prototype.onAggregationDrop=function(){};g.prototype._onMovableChange=function(t){var e=t.getSource();if(e.isMovable()){this._attachDragEvents(e)}else{this._detachDragEvents(e)}this.onMovableChange(e)};g.prototype._onDragStart=function(t){var e=n.getOverlay(t.currentTarget.id);t.stopPropagation();if(i.browser.firefox&&t&&t.originalEvent&&t.originalEvent.dataTransfer&&t.originalEvent.dataTransfer.setData){t.originalEvent.dataTransfer.setData("text/plain","")}this.setBusy(true);this.showGhost(e,t);this.onDragStart(e)};g.prototype._attachTouchDragEvents=function(t){t.attachBrowserEvent("touchmove",this._onTouchMove,this);t.attachBrowserEvent("touchend",this._onTouchEnd,this)};g.prototype._detachTouchDragEvents=function(t){t.detachBrowserEvent("touchmove",this._onTouchMove,this);t.detachBrowserEvent("touchend",this._onTouchEnd,this)};g.prototype._onTouchStart=function(t){var e=t.touches[0].pageX;var r=t.touches[0].pageY;var a=n.getOverlay(t.currentTarget.id);function o(){a.detachBrowserEvent("touchmove",g,this);a.detachBrowserEvent("touchend",c,this);a.detachBrowserEvent("contextmenu",c,this)}function i(t,a){var o=e-t;var n=r-a;return Math.sqrt(o*o+n*n)}function g(t){var e=t.touches[0].pageX;var r=t.touches[0].pageY;var n=i(e,r);if(n>s){this.onDragStart(a);o.call(this);this._attachTouchDragEvents(a)}}function c(){o.call(this);h=false}h=true;t.stopPropagation();a.attachBrowserEvent("touchmove",g,this);a.attachBrowserEvent("contextmenu",c,this);a.attachBrowserEvent("touchend",c,this)};g.prototype._getTargetOverlay=function(e){if(t.isObjectA(e,"sap.ui.dt.Overlay")){var r;if(t.isObjectA(e,"sap.ui.dt.AggregationOverlay")&&e.getTargetZone()){r=e}else if(t.isObjectA(e,"sap.ui.dt.ElementOverlay")&&o.isInTargetZoneAggregation(e)){r=e}return r||this._getTargetOverlay(e.getParent())}};g.prototype._findTargetOverlayFromCoordinates=function(t,r){var a=document.elementFromPoint(t,r);var o=a?e.getElementById(a.id):undefined;return this._getTargetOverlay(o)};g.prototype._onTouchMove=function(e){var r=n.getOverlay(e.currentTarget.id);this.onDrag(r);var a=e.touches||e.changedTouches;var{pageX:o}=a[0];var{pageY:i}=a[0];var g=this._findTargetOverlayFromCoordinates(o,i);if(!g){return}if(g!==c){if(c){if(t.isObjectA(c,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(c)}else{this.onDragLeave(c)}}c=g;if(t.isObjectA(g,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(g)}else{this.onDragEnter(g)}}if(t.isObjectA(g,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(g)}else{this.onDragOver(g)}e.stopPropagation()};g.prototype._getValidTargetZoneAggregationOverlay=function(e){if(t.isObjectA(e,"sap.ui.dt.AggregationOverlay")&&e.getTargetZone()){return e}return this._getValidTargetZoneAggregationOverlay(e.getParent())};g.prototype._onTouchEnd=function(t){var e=n.getOverlay(t.currentTarget.id);var r=this._getValidTargetZoneAggregationOverlay(e);if(r){this.onAggregationDrop(r)}this.onDragEnd(e);this._detachTouchDragEvents(e);c=undefined;h=false};g.prototype.showGhost=function(t,e){if(e&&e.originalEvent&&e.originalEvent.dataTransfer){if(e.originalEvent.dataTransfer.setDragImage){this._oGhost=this.createGhost(t,e);document.getElementById("overlay-container").append(this._oGhost);setTimeout(function(){this._removeGhost()}.bind(this),0);e.originalEvent.dataTransfer.setDragImage(this._oGhost,e.originalEvent.pageX-a.getOffset(t.getDomRef()).left,e.originalEvent.pageY-a.getOffset(t.getDomRef()).top)}}};g.prototype._removeGhost=function(){this.removeGhost();delete this._oGhost};g.prototype.removeGhost=function(){var t=this.getGhost();if(t){t.remove()}};g.prototype.createGhost=function(t){var e=t.getAssociatedDomRef();var r;if(!e){e=this._getAssociatedDomCopy(t);r=e.get(0)}else{r=document.createElement("div");[].slice.call(e).forEach(function(t){a.cloneDOMAndStyles(t,r)})}var o=document.createElement("div");o.classList.add("sapUiDtDragGhostWrapper");r.classList.add("sapUiDtDragGhost");o.append(r);return o};g.prototype._getAssociatedDomCopy=function(t){var e=document.createElement("div");t.getChildren().forEach(function(t){t.getChildren().forEach(function(t){var r=t.getAssociatedDomRef();if(r){a.cloneDOMAndStyles(r,e)}else{a.cloneDOMAndStyles(this._getAssociatedDomCopy(t).get(0),e)}},this)},this);return jQuery(e)};g.prototype.getGhost=function(){return this._oGhost};g.prototype._onDragEnd=function(t){this.setBusy(false);var e=n.getOverlay(t.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(e);t.stopPropagation()};g.prototype._onDrag=function(t){var e=n.getOverlay(t.currentTarget.id);this.onDrag(e);t.stopPropagation()};g.prototype._onDragEnter=function(t){var e=n.getOverlay(t.currentTarget.id);if(o.isInTargetZoneAggregation(e)){if(!this.onDragEnter(e)){t.stopPropagation()}}t.preventDefault()};g.prototype._onDragLeave=function(t){var e=n.getOverlay(t.currentTarget.id);if(o.isInTargetZoneAggregation(e)){if(!this.onDragLeave(e)){t.stopPropagation()}}else{t.stopPropagation()}t.preventDefault()};g.prototype._onDragOver=function(t){var e=n.getOverlay(t.currentTarget.id);if(o.isInTargetZoneAggregation(e)){if(!this.onDragOver(e)){t.stopPropagation()}}else{t.stopPropagation()}t.preventDefault()};g.prototype._onAggregationTargetZoneChange=function(t){var e=t.getSource();var r=t.getParameter("targetZone");if(r){this._attachAggregationOverlayEvents(e)}else{this._detachAggregationOverlayEvents(e)}};g.prototype._attachAggregationOverlayEvents=function(t){t.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);t.attachBrowserEvent("dragover",this._onAggregationDragOver,this);t.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);t.attachBrowserEvent("drop",this._onAggregationDrop,this)};g.prototype._detachAggregationOverlayEvents=function(t){t.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);t.detachBrowserEvent("dragover",this._onAggregationDragOver,this);t.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);t.detachBrowserEvent("drop",this._onAggregationDrop,this)};g.prototype._onAggregationDragEnter=function(t){var e=n.getOverlay(t.currentTarget.id);this.onAggregationDragEnter(e);t.preventDefault();t.stopPropagation()};g.prototype._onAggregationDragOver=function(t){var e=n.getOverlay(t.currentTarget.id);this.onAggregationDragOver(e);t.preventDefault();t.stopPropagation()};g.prototype._onAggregationDragLeave=function(t){var e=n.getOverlay(t.currentTarget.id);this.onAggregationDragLeave(e);t.preventDefault();t.stopPropagation()};g.prototype._onAggregationDrop=function(t){var e=n.getOverlay(t.currentTarget.id);this.onAggregationDrop(e);t.preventDefault();t.stopPropagation()};var l=100;var v=20;var p=50;g.prototype._clearScrollInterval=function(t,e){if(this._mScrollIntervals[t]){window.clearInterval(this._mScrollIntervals[t][e]);delete this._mScrollIntervals[t][e]}};g.prototype._clearScrollIntervalFor=function(t){if(this._mScrollIntervals[t]){Object.keys(this._mScrollIntervals[t]).forEach(function(e){this._clearScrollInterval(t,e)},this)}};g.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this))};g.prototype._checkScroll=function(t,e,r){var a;var o;var n=1;if(e==="top"||e==="bottom"){a=t.outerHeight();o=t.scrollTop.bind(t)}else{a=t.outerWidth();o=t.scrollLeft.bind(t)}if(e==="top"||e==="left"){n=-1}var i=Math.floor(a/4);var g=l;if(i<l){g=i}if(r<g){this._mScrollIntervals[t.attr("id")]=this._mScrollIntervals[t.attr("id")]||{};if(!this._mScrollIntervals[t.attr("id")][e]){this._mScrollIntervals[t.attr("id")][e]=window.setInterval(function(){var t=o();o(t+n*v)},p)}}else{this._clearScrollInterval(t.attr("id"),e)}};g.prototype._dragLeave=function(t){var e=n.getOverlay(t.currentTarget.id);this._clearScrollIntervalFor(e.$().attr("id"))};g.prototype._dragScroll=function(t){var e=n.getOverlay(t.currentTarget.id);var r=e.$();var a=t.clientX;var o=t.clientY;var i=r.offset();var g=r.height();var s=r.width();var h=i.top;var c=i.left;var l=h+g;var v=c+s;this._checkScroll(r,"bottom",l-o);this._checkScroll(r,"top",o-h);this._checkScroll(r,"right",v-a);this._checkScroll(r,"left",a-c)};g.prototype._attachDragScrollHandler=function(e){var r;if(t.isObjectA(e,"sap.ui.dt.AggregationOverlay")){r=e}else{r=e.srcControl}var o=r.getDomRef();if(o&&Object.keys(o).length>0&&a.hasScrollBar(o)){o.addEventListener("dragover",this._dragScrollHandler,true);o.addEventListener("dragleave",this._dragLeaveHandler,true)}};g.prototype._removeDragScrollHandler=function(e){var r;if(t.isObjectA(e,"sap.ui.dt.AggregationOverlay")){r=e}else{r=e.srcControl}var a=r.getDomRef();if(a){a.removeEventListener("dragover",this._dragScrollHandler,true)}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/ElementMover", ["sap/ui/base/Object","sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/Util"],function(e,t,r,a,n){"use strict";var o=t.extend("sap.ui.dt.plugin.ElementMover",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{validTargetZonesActivated:{}}}});o.prototype._getMovableTypes=function(){return this.getProperty("movableTypes")||[]};o.prototype.isMovableType=function(t){var r=this._getMovableTypes();return r.some(function(r){return e.isObjectA(t,r)})};o.prototype.checkMovable=function(){return Promise.resolve(true)};o.prototype.getMovedOverlay=function(){return this._oMovedOverlay};o.prototype.setMovedOverlay=function(e){if(e){this._source=a.getParentInformation(e)}else{delete this._source}this._oMovedOverlay=e};o.prototype._getSource=function(){return this._source};o.prototype.activateAllValidTargetZones=function(e,t){return this._iterateAllAggregations(e,this._activateValidTargetZone.bind(this),t,true).then(function(){this.fireValidTargetZonesActivated()}.bind(this))};o.prototype._activateValidTargetZone=function(e,t){return this.checkTargetZone(e).then(function(r){if(r){e.setTargetZone(true);if(t){e.addStyleClass(t)}}}).catch(function(e){throw n.createError("ElementMover#_activateValidTargetZone",`An error occurred during activation of valid target zones: ${e}`)})};o.prototype.checkTargetZone=function(e,t,a){var n=t||this.getMovedOverlay();return r.checkTargetZone(e,n,a)};o.prototype._deactivateTargetZone=function(e,t){e.setTargetZone(false);if(t){e.removeStyleClass(t)}};o.prototype.activateTargetZonesFor=function(e,t){return this._iterateOverlayAggregations(e,this._activateValidTargetZone.bind(this),t,true).then(function(){this.fireValidTargetZonesActivated()}.bind(this))};o.prototype.deactivateTargetZonesFor=function(e,t){this._iterateOverlayAggregations(e,this._deactivateTargetZone.bind(this),t)};o.prototype.deactivateAllTargetZones=function(e,t){this._iterateAllAggregations(e,this._deactivateTargetZone.bind(this),t)};o.prototype._iterateAllAggregations=function(e,t,r,a){var n=e.getElementOverlays();var o=n.map(function(e){return this._iterateOverlayAggregations(e,t,r,a)},this);if(a){return Promise.all(o)}};o.prototype._iterateOverlayAggregations=function(e,t,r,a){var n=e.getChildren();var o=n.map(function(e){return t(e,r)});if(a){return Promise.all(o)}};o.prototype.repositionOn=function(e,t,n){var o=e.getElement();var i=a.getParentInformation(t);var g=a.getParentInformation(e);var s;var v=e.getParentAggregationOverlay();var f=e.getRelevantContainer();var u=e.getParentElementOverlay();if(v&&u){var l=v.getAggregationName();s=u.getDesignTimeMetadata().getAggregation(l)}if(i.index!==-1){if(s&&s.beforeMove){s.beforeMove(f,o)}if(n){i.index++;if(g.aggregation===i.aggregation){i.index=r.adjustIndexForMove(g.parent,i.parent,g.index,i.index)}}r.insertAggregation(i.parent,i.aggregation,o,i.index);if(s&&s.afterMove){s.afterMove(f,o)}this._setSourceAndTargetParentInformation()}};o.prototype.insertInto=function(e,t,a){var n=e.getElement();var o=t.getElement();var i;var g=e.getParentAggregationOverlay();var s=e.getRelevantContainer();var v=e.getParentElementOverlay();if(g&&v){var f=g.getAggregationName();i=v.getDesignTimeMetadata().getAggregation(f)}var u=r.getAggregation(t.getElement(),t.getAggregationName());var l=u.indexOf(n);var c=a?u.length:0;if(!(l>-1&&l===(c===0?c:c-1))){if(i&&i.beforeMove){i.beforeMove(s,n)}var d=t.getAggregationName();r.insertAggregation(o,d,n,c);if(i&&i.afterMove){i.afterMove(s,n)}this._setSourceAndTargetParentInformation()}};o.prototype._compareSourceAndTarget=function(e,t){var r;for(r in e){switch(typeof e[r]){case"object":if(e[r].getId()!==t[r].getId()){return false}break;default:if(e[r]!==t[r]){return false}}}return true};o.prototype._setSourceAndTargetParentInformation=function(){var e=this.getMovedOverlay();if(!e){delete this._mSourceParentInformation;delete this._mTargetParentInformation;return}var t=this._getSource();if(t){this._mSourceParentInformation={};Object.assign(this._mSourceParentInformation,t)}else{delete this._mSourceParentInformation}var r=a.getParentInformation(e);if(r){this._mTargetParentInformation=r}else{delete this._mTargetParentInformation}};o.prototype.getSourceAndTargetParentInformation=function(){return{sourceParentInformation:this._mSourceParentInformation,targetParentInformation:this._mTargetParentInformation}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/MouseSelection", ["sap/ui/dt/Plugin"],function(t){"use strict";var e=t.extend("sap.ui.dt.plugin.MouseSelection",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});e.prototype.init=function(...e){t.prototype.init.apply(this,e)};e.prototype.registerElementOverlay=function(t){t.setSelectable(true);t.attachBrowserEvent("click",this._onClick,t)};e.prototype.deregisterElementOverlay=function(t){t.detachBrowserEvent("click",this._onClick,t)};e.prototype._onClick=function(t){this.setSelected(!this.getSelected());t.preventDefault();t.stopPropagation()};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/TabHandling", ["sap/ui/dt/Plugin","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dom/jquery/Selectors"],function(t,e,i){"use strict";var a=t.extend("sap.ui.dt.plugin.TabHandling",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});a.prototype.registerElementOverlay=function(t){if(t.isRoot()){this.removeTabIndex()}};a.prototype.deregisterElementOverlay=function(t){if(t.isRoot()){this.restoreTabIndex()}};a.prototype.setDesignTime=function(...i){const[a]=i;t.prototype.setDesignTime.apply(this,i);if(a){if(!this._oMutationObserver){this._oMutationObserver=e.getMutationObserver();this._oMutationObserver.attachDomChanged(this._onDomChanged,this)}}else{if(this._oMutationObserver){this._oMutationObserver.detachDomChanged(this._onDomChanged,this);delete this._oMutationObserver}this.restoreTabIndex()}};a.prototype.removeTabIndex=function(){var t=this._getRootOverlays();t.forEach(function(t){var e=t.getAssociatedDomRef();if(e){e.find(":focusable:not([tabIndex=-1], #overlay-container *)").each(function(t,e){e.setAttribute("data-sap-ui-dt-tabindex",e.tabIndex);e.setAttribute("tabindex",-1)})}})};a.prototype.removeOverlayTabIndex=function(){var t=this._getRootOverlays();t.forEach(function(t){var e=t.getDomRef();if(e){e.querySelectorAll("[tabindex]:not([tabindex='-1'])").forEach(function(t){t.setAttribute("data-sap-ui-overlay-tabindex",t.tabIndex);t.setAttribute("tabindex",-1)})}})};a.prototype._getRootOverlays=function(){var t=this.getDesignTime();var e=t.getRootElements();return e.map(function(t){return i.getOverlay(t)})};a.prototype.restoreTabIndex=function(){document.querySelectorAll("[data-sap-ui-dt-tabindex]").forEach(function(t){t.setAttribute("tabindex",t.getAttribute("data-sap-ui-dt-tabindex"));t.removeAttribute("data-sap-ui-dt-tabindex")})};a.prototype.restoreOverlayTabIndex=function(){document.querySelectorAll("[data-sap-ui-overlay-tabindex]").forEach(function(t){t.setAttribute("tabindex",t.getAttribute("data-sap-ui-overlay-tabindex"));t.removeAttribute("data-sap-ui-overlay-tabindex")})};a.prototype._onDomChanged=function(){if(this.getDesignTime().getEnabled()){this.removeTabIndex()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/plugin/ToolHooks", ["sap/ui/dt/Plugin"],function(e){"use strict";var t=e.extend("sap.ui.dt.plugin.ToolHooks",{metadata:{library:"sap.ui.dt",properties:{},associations:{},events:{}}});t.prototype.registerElementOverlay=function(e){e.getDesignTimeMetadata().getToolHooks().start(e.getElement())};t.prototype.deregisterElementOverlay=function(e){e.getDesignTimeMetadata().getToolHooks().stop(e.getElement())};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/util/ZIndexManager", ["sap/ui/core/Popup","sap/ui/core/BusyIndicator","sap/base/Log","sap/ui/dt/Util","sap/m/InstanceManager","sap/base/util/includes","sap/base/util/restricted/_max","sap/base/util/restricted/_min"],function(e,t,n,r,i,a,u,o){"use strict";var p=10;var s=3;var c=[];var l=[];function d(){return i.getOpenDialogs().concat(i.getOpenPopovers(),t.oPopup&&t.oPopup.isOpen()?[t.oPopup]:[])}function f(e,t,r){if(++e<=t){if(a(r,e)){return f(e,t,r)}return e}n.error(`sap.ui.dt.util.ZIndexManager: z-index limit has been exceeded, therefore all following calls receive the same z-Index = ${t}`);return t}function v(e){return e.map(function(e){return e._iZIndex||e.oPopup._iZIndex})}var x={getNextZIndex(){var t=d();var n=[];var r=[];t.forEach(function(e){var t=l.every(function(t){return t(e)});t&&l.length>0?n.push(e):r.push(e)});var i=n.length>0?u(v(n)):-1;var a=r.length>0?o(v(r)):-1;if(i<a){return this._getNextMinZIndex(a)}return e.getNextZIndex()},getZIndexBelowPopups(){var t=d();var n;if(t.length>0){n=Math.min.apply(null,v(t))}if(!r.isInteger(n)){return e.getNextZIndex()}return this._getNextMinZIndex(n)},addPopupFilter(e){if(typeof e==="function"){l=l.concat([e])}},removePopupFilter(e){l=l.filter(function(t){return t===e})},_getNextMinZIndex(e){var t=e-s;var n=e-p;var r=f(n,t,c);c.push(r);return r}};return x});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dt/util/_createPromise", function(){"use strict";return function(i){var n=false;var e;var r;var t;var s=new Promise(function(e,s){i(function(...i){if(!n){e.apply(this,i)}else if(r){r.apply(this,i)}},function(...i){if(!n){s.apply(this,i)}else if(t){t.apply(this,i)}})});return{promise:s,cancel(){n=true;e||=new Promise(function(i,n){r=i;t=n});return e}}}});
sap.ui.require.preload({
	"sap/ui/dt/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.dt","type":"library","embeds":[],"applicationVersion":{"version":"1.120.31"},"title":"SAP UI library: sap.ui.dt (by SAP, Author)","description":"SAP UI library: sap.ui.dt (by SAP, Author)","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.31"}}},"library":{"i18n":false,"content":{"controls":[],"elements":[],"types":["sap.ui.dt.SelectionMode"],"interfaces":[]}}}}'
});
//# sourceMappingURL=library-preload.js.map
