/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/Plugin","sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/ui/Device"],function(e,t,r,o,n,i,s){"use strict";var a=true;var l=e.extend("sap.ui.dt.plugin.CutPaste",{metadata:{library:"sap.ui.dt",properties:{movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]},elementMover:{type:"any"}},associations:{}}});l.prototype.init=function(){this.setElementMover(new t)};l.prototype.registerElementOverlay=function(e){var t=e.getElement();this.getElementMover().checkMovable(e).then(function(r){e.attachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().isMovableType(t)&&r){e.setMovable(true)}if(this.getElementMover().getMovedOverlay()){this.getElementMover().activateTargetZonesFor(this.getElementMover().getMovedOverlay())}}.bind(this)).catch(function(e){throw o.createError("CutPaste#registerElementOverlay",`An error occurred during checkMovable: ${e}`)})};l.prototype.deregisterElementOverlay=function(e){e.setMovable(false);e.detachBrowserEvent("keydown",this._onKeyDown,this);if(this.getElementMover().getMovedOverlay()){this.getElementMover().deactivateTargetZonesFor(this.getElementMover().getMovedOverlay())}};l.prototype.setMovableTypes=function(e){this.getElementMover().setMovableTypes(e);return this.setProperty("movableTypes",e)};l.prototype.setElementMover=function(e){e.setMovableTypes(this.getMovableTypes());return this.setProperty("elementMover",e)};l.prototype.getCuttedOverlay=function(){return this.getElementMover().getMovedOverlay()};l.prototype.isElementPasteable=function(e){var t=this._getTargetZoneAggregation(e);if(t||r.isInTargetZoneAggregation(e)){return true}return false};l.prototype._onKeyDown=function(e){var t=n.getOverlay(e.currentTarget.id);var r=s.os.macintosh?e.metaKey:e.ctrlKey;if(e.keyCode===i.X&&e.shiftKey===false&&e.altKey===false&&r===true){this.cut(t);e.stopPropagation()}else if(e.keyCode===i.V&&e.shiftKey===false&&e.altKey===false&&r===true){if(this.getElementMover().getMovedOverlay()){this.paste(t)}e.stopPropagation()}else if(e.keyCode===i.ESCAPE){this.stopCutAndPaste();e.stopPropagation()}};l.prototype.cut=function(e){this.stopCutAndPaste();if(e.isMovable()){this.getElementMover().setMovedOverlay(e);e.addStyleClass("sapUiDtOverlayCutted");return this.getElementMover().activateAllValidTargetZones(this.getDesignTime()).then(function(){e.focus()})}return Promise.resolve(undefined)};l.prototype._executePaste=function(e){var t=this.getElementMover().getMovedOverlay();if(!t){return false}var o=false;if(!this._isForSameElement(t,e)){var n=this._getTargetZoneAggregation(e);if(n){this.getElementMover().insertInto(t,n);o=true}else if(r.isInTargetZoneAggregation(e)){this.getElementMover().repositionOn(t,e,a);o=true}}if(o){t.setSelected(true);setTimeout(function(){t.focus()},0)}return o};l.prototype.paste=function(e){var t=this._executePaste(e);if(t===true){this.stopCutAndPaste()}};l.prototype.stopCutAndPaste=function(){var e=this.getElementMover().getMovedOverlay();if(e){e.removeStyleClass("sapUiDtOverlayCutted");this.getElementMover().setMovedOverlay(null);this.getElementMover().deactivateAllTargetZones(this.getDesignTime())}};l.prototype._isForSameElement=function(e,t){return t.getElement()===e.getElement()};l.prototype._getTargetZoneAggregation=function(e){var t=e.getChildren();var r=t.filter(function(e){return e.isTargetZone()});if(r.length>0){return r[0]}return null};return l});
//# sourceMappingURL=CutPaste.js.map