/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/Version","sap/ui/core/Element","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave","sap/ui/events/ControlEvents","sap/ui/Device","sap/ui/events/TouchToMouseMapping","sap/ui/thirdparty/jquery","sap/ui/thirdparty/jquery-mobile-custom"],function(e,t,n,o,a,s,i,jQuery){"use strict";var u={};var r=e(jQuery.fn.jquery);u.aAdditionalControlEvents=[];u.aAdditionalPseudoEvents=[];u._createSimulatedEvent=function(e,t,n){var o="__"+e+"Handler";var a="sap"+e;this.aAdditionalControlEvents.push(a);this.aAdditionalPseudoEvents.push({sName:e,aTypes:[a],fnCheck:function(e){return true}});jQuery.event.special[a]={add:function(o){var s=this,i=jQuery(this),u={domRef:s,eventName:e,sapEventName:a,eventHandle:o};var r=function(e){n(e,u)};o.__sapSimulatedEventHandler=r;for(var c=0;c<t.length;c++){i.on(t[c],r)}},remove:function(e){var n=jQuery(this);var a=e.__sapSimulatedEventHandler;n.removeData(o+e.guid);for(var s=0;s<t.length;s++){jQuery.event.remove(this,t[s],a)}}}};u._handleMouseToTouchEvent=function(e,n){if(e.isMarked("delayedMouseEvent")){return}var a=jQuery(n.domRef),s=t.closestTo(e.target),i=a.data("__touchstart_control"),u=i&&window.document.getElementById(i);if(e.type==="mouseout"&&!o(e,n.domRef)&&(!u||!o(e,u))){return}var r=jQuery.event.fix(e.originalEvent||e);r.type=n.sapEventName;if(r.isMarked("firstUIArea")){r.setMark("handledByUIArea",false)}var c=[{identifier:1,pageX:r.pageX,pageY:r.pageY,clientX:r.clientX,clientY:r.clientY,screenX:r.screenX,screenY:r.screenY,target:r.target,radiusX:1,radiusY:1,rotationAngle:0}];switch(n.eventName){case"touchstart":if(s){a.data("__touchstart_control",s.getId())}case"touchmove":r.touches=r.changedTouches=r.targetTouches=c;break;case"touchend":r.changedTouches=c;r.touches=r.targetTouches=[];break}if(n.eventName==="touchstart"||a.data("__touch_in_progress")){a.data("__touch_in_progress","X");if(e.type==="mouseout"){r.setMarked("fromMouseout")}if(n.eventName!=="touchstart"&&(!s||s.getId()!==i)){r.setMark("scopeCheckId",i)}if(e.type!=="dragstart"){n.eventHandle.handler.call(n.domRef,r)}if((n.eventName==="touchend"||e.type==="dragstart")&&!r.isMarked("fromMouseout")){a.removeData("__touch_in_progress");a.removeData("__touchstart_control")}}};u._initTouchEventSimulation=function(){this._createSimulatedEvent("touchstart",["mousedown"],this._handleMouseToTouchEvent);this._createSimulatedEvent("touchend",["mouseup","mouseout"],this._handleMouseToTouchEvent);this._createSimulatedEvent("touchmove",["mousemove","dragstart"],this._handleMouseToTouchEvent)};u._initContextMenuSimulation=function(){var e=function(e,t){var n=jQuery.event.fix(e.originalEvent||e);n.type=t.sapEventName;if(!window.getSelection||!window.getSelection()||window.getSelection().toString()===""){t.eventHandle.handler.call(t.domRef,n)}};this._createSimulatedEvent("contextmenu",["taphold"],e)};u._initMouseEventSimulation=function(){var e=false,t=jQuery.vmouse.moveDistanceThreshold,n,o,a,s;var i=function(e,t,n){var o=jQuery.event.fix(e.originalEvent||e);o.type=t.sapEventName;delete o.touches;delete o.changedTouches;delete o.targetTouches;o.screenX=n.screenX;o.screenY=n.screenY;o.clientX=n.clientX;o.clientY=n.clientY;o.ctrlKey=n.ctrlKey;o.altKey=n.altKey;o.shiftKey=n.shiftKey;o.button=0;return o};var u=function(a,s){if(a.isMarked("handledByTouchToMouse")){return}a.setMarked("handledByTouchToMouse");if(!e){var u=a.originalEvent.touches[0];e=Math.abs(u.pageX-n)>t||Math.abs(u.pageY-o)>t}var r=i(a,s,a.touches[0]);setTimeout(function(){r.setMark("handledByUIArea",false);s.eventHandle.handler.call(s.domRef,r)},0)};var r=function(t,u){if(t.isMarked("handledByTouchToMouse")){return}t.setMarked("handledByTouchToMouse");var r,c,d;function l(){return i(t,u,u.eventName==="mouseup"?t.changedTouches[0]:t.touches[0])}if(t.type==="touchstart"){var h=t.originalEvent.touches[0];e=false;n=h.pageX;o=h.pageY;a=Math.round(h.pageX-jQuery(t.target).offset().left);s=Math.round(h.pageY-jQuery(t.target).offset().top);r=l();setTimeout(function(){r.setMark("handledByUIArea",false);u.eventHandle.handler.call(u.domRef,r)},0)}else if(t.type==="touchend"){c=l();d=!e;setTimeout(function(){c.setMark("handledByUIArea",false);u.eventHandle.handler.call(u.domRef,c);if(d){c.type="click";c.getPseudoTypes=jQuery.Event.prototype.getPseudoTypes;c.setMark("handledByUIArea",false);c.offsetX=a;c.offsetY=s;u.eventHandle.handler.call(u.domRef,c)}},0)}};this._createSimulatedEvent("mousedown",["touchstart"],r);this._createSimulatedEvent("mousemove",["touchmove"],u);this._createSimulatedEvent("mouseup",["touchend","touchcancel"],r)};u._init=function(e){this.aAdditionalControlEvents.push("swipe","tap","swipeleft","swiperight","scrollstart","scrollstop");this.aAdditionalPseudoEvents.push({sName:"swipebegin",aTypes:["swipeleft","swiperight"],fnCheck:function(e){var t=sap.ui.getCore().getConfiguration().getRTL();return t&&e.type==="swiperight"||!t&&e.type==="swipeleft"}});this.aAdditionalPseudoEvents.push({sName:"swipeend",aTypes:["swipeleft","swiperight"],fnCheck:function(e){var t=sap.ui.getCore().getConfiguration().getRTL();return!t&&e.type==="swiperight"||t&&e.type==="swipeleft"}});if(r.compareTo("1.9.1")<0){e=e.concat(this.aAdditionalControlEvents)}else{e=this.aAdditionalControlEvents.concat(e)}for(var t=0;t<this.aAdditionalPseudoEvents.length;t++){n.addEvent(this.aAdditionalPseudoEvents[t])}return e};if(s.browser.webkit&&/Mobile/.test(navigator.userAgent)&&s.support.touch){i.init(window.document);u.disableTouchToMouseHandling=i.disableTouchToMouseHandling}if(!u.disableTouchToMouseHandling){u.disableTouchToMouseHandling=function(){}}if(s.support.touch){a.events.push("touchstart","touchend","touchmove","touchcancel")}(function e(){u.touchEventMode="SIM";if(s.support.touch){u.touchEventMode="ON";if(r.compareTo("3.0.0")<0){jQuery.event.props.push("touches","targetTouches","changedTouches")}}u._initTouchEventSimulation();if(s.os.ios){u._initContextMenuSimulation()}if(s.support.touch){u.disableTouchToMouseHandling();u._initMouseEventSimulation()}a.events=u._init(a.events)})();return u});
//# sourceMappingURL=EventSimulation.js.map