/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/strings/formatMessage","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/Utils"],function(e,n,r,t,a,o,i,s){"use strict";var l=s.FakePromise?new s.FakePromise:Promise.resolve();function c(r,t,a,o){var i=t.join(" ");i=n(i,a);e[r](i,o||"")}function u(e,n){var r=e.getSelector&&e.getSelector();if(!r||!r.id&&!r.name){return Promise.reject(Error("No selector in change found or no selector ID."))}function t(e){if(s.indexOfObject(n.failedSelectors,e)>-1){throw Error("A change depending on that control already failed, so the current change is skipped")}}return n.modifier.bySelectorTypeIndependent(r,n.appComponent,n.view).then(function(a){if(!a){throw Error("A flexibility change tries to change a nonexistent control.")}t(r);var o=e.getDependentControlSelectorList();o.forEach(function(e){var r=n.modifier.bySelector(e,n.appComponent,n.view);if(!r){throw new Error("A dependent selector control of the flexibility change is not available.")}t(e)});return a})}function f(e){return e.modifier.targets==="xmlTree"}function d(e,n,r,t,i){var s=o.getControlIfTemplateAffected(n,e,i).control;var l=i.modifier;var c=s&&!!a.getAppliedCustomDataValue(s,n,l);var u=s&&a.hasChangeApplyFinishedCustomData(s,n,l);var d=n.isApplyProcessFinished();var g=i.appComponent;if(d&&!u){if(!f(i)){var p=o.checkIfDependencyIsStillValid.bind(null,g,l,r);t._oChangePersistence.copyDependenciesFromInitialChangesMap(n,p,g)}n.setInitialApplyState()}else if(!d&&u){if(c){n.setRevertData(a.getParsedRevertDataFromCustomData(s,n,l));n.markSuccessful()}else{n.markFailed()}}else if(d&&u){n.markSuccessful()}}function g(e,n){var r;if(f(n)&&e.getJsOnly()){r="Change cannot be applied in XML. Retrying in JS."}if(r){e.setInitialApplyState();throw Error(r)}}function p(e,n,t,o){return Promise.resolve().then(function(){if(t instanceof r){n.control=t}if(n.control){return o.modifier.updateAggregation(n.originalControl,e.getContent().boundAggregation)}return undefined}).then(function(){return a.addAppliedCustomData(n.control,e,o,f(o))}).then(function(){var n={success:true};e.markSuccessful(n);return n})}function h(e,n,r,t){var o=f(t);var i={success:false,error:e};var s=n.getId();var l="Change ''{0}'' could not be applied.";var u=e instanceof Error;var d=a.getCustomDataIdentifier(false,u,o);switch(d){case a.notApplicableChangesCustomDataKey:c("info",[l,e.message],[s]);break;case a.failedChangesCustomDataKeyXml:c("warning",[l,"Merge error detected while processing the XML tree."],[s],e.stack);break;case a.failedChangesCustomDataKeyJs:c("error",[l,"Merge error detected while processing the JS control tree."],[s],e.stack);break;default:}return a.addFailedCustomData(r.control,n,t,d).then(function(){if(o){n.setInitialApplyState()}else{n.markFailed(i)}return i})}function m(n,r){var t=r.getChangeType();var a=r.getSelector().id;var o=`${r.getNamespace()+r.getId()}.${r.getFileType()}`;var i="A flexibility change could not be applied.";i+="\nThe displayed UI might not be displayed as intedend.";if(n.message){i+=`\n   occurred error message: '${n.message}'`}i+=`\n   type of change: '${t}'`;i+=`\n   LRep location of the change: ${o}`;i+=`\n   id of targeted control: '${a}'.`;e.warning(i,undefined,"sap.ui.fl.apply._internal.changes.Applier")}function v(e,n,r){var a={appComponent:r,modifier:t};var o=t.bySelector(e.originalSelectorToBeAdjusted,r);var i=n.getBindingInfo(e.getContent().boundAggregation).template;if(o.getParent()){var s=[];var l=o;do{s.push({aggregation:l.sParentAggregationName,index:l.getParent().getAggregation(l.sParentAggregationName).indexOf(l)});l=l.getParent()}while(l.getParent());s.reverse();s.forEach(function(e){i=i.getAggregation(e.aggregation)[e.index]})}e.addDependentControl(i,"originalSelector",a)}function C(e,n,r){var t=e.findIndex(function(e){return e.handler===n});if(t<0){t=e.length;e.push({handler:n,controls:[]})}if(!e[t].controls.includes(r)){e[t].controls.push(r)}}var y={addPreConditionForInitialChangeApplying(e){l=l.then(function(){return e})},applyChangeOnControl(e,n,r){var t=o.getControlIfTemplateAffected(e,n,r);var a=r.changeHandler?Promise.resolve(r.changeHandler):o.getChangeHandler(e,t,r);return a.then(function(n){g(e,r);return n}).then(function(n){if(e.hasApplyProcessStarted()){return e.addPromiseForApplyProcessing().then(function(n){e.markSuccessful();return n})}else if(!e.isApplyProcessFinished()){return(s.FakePromise?new s.FakePromise:Promise.resolve()).then(function(){e.startApplying();return n.applyChange(e,t.control,r)}).then(function(n){return p(e,t,n,r)}).catch(function(n){return h(n,e,t,r)})}var a={success:true};e.markSuccessful(a);return a}).catch(function(e){return{success:false,error:e}})},applyAllChangesForControl(e,n,r,a){var o=e();var c=a.getId();var u=o.mChanges[c]||[];var f={modifier:t,appComponent:n,view:s.getViewForControl(a)};u.forEach(function(e){d(a,e,o,r,f);if(!e.isApplyProcessFinished()&&!e._ignoreOnce){e.setQueuedForApply()}});l=l.then(function(e,r){var t=[];var a=e.getId();var l=o.mChanges[a]||[];var c;if(o.mControlsWithDependencies[a]){i.removeControlsDependencies(o,a);c=true}l.forEach(function(s){if(s.originalSelectorToBeAdjusted){v(s,e,n);delete s.originalSelectorToBeAdjusted}if(s._ignoreOnce){delete s._ignoreOnce}else if(s.isApplyProcessFinished()){i.resolveDependenciesForChange(o,s.getId(),a)}else if(!o.mDependencies[s.getId()]){t.push(function(){return y.applyChangeOnControl(s,e,r).then(function(){i.resolveDependenciesForChange(o,s.getId(),a)})})}else{var l=y.applyChangeOnControl.bind(y,s,e,r);i.addChangeApplyCallbackToDependency(o,s.getId(),l)}});if(l.length||c){return s.execPromiseQueueSequentially(t).then(function(){return i.processDependentQueue(o,n,a)})}return undefined}.bind(null,a,f));return l},applyAllChangesForXMLView(n,r){if(!Array.isArray(r)){var t=`No list of changes was passed for processing the flexibility on view: ${n.view}.`;e.error(t,undefined,"sap.ui.fl.apply._internal.changes.Applier");r=[]}var a=[];n.failedSelectors=[];return r.reduce(function(e,r){var t;return e.then(u.bind(null,r,n)).then(function(e){t=e;var a=o.getControlIfTemplateAffected(r,t,n);return o.getChangeHandler(r,a,n)}).then(function(e){n.changeHandler=e;r.setQueuedForApply();d(t,r,undefined,undefined,n);if(!r.isApplyProcessFinished()){if(typeof n.changeHandler.onAfterXMLChangeProcessing==="function"){C(a,n.changeHandler,t)}return y.applyChangeOnControl(r,t,n)}return{success:true}}).then(function(e){if(!e.success){throw Error(e.error)}}).catch(function(e){r.getDependentSelectorList().forEach(function(e){if(s.indexOfObject(n.failedSelectors,e)===-1){n.failedSelectors.push(e)}});m(e,r)})},s.FakePromise?new s.FakePromise:Promise.resolve()).then(function(){delete n.failedSelectors;a.forEach(function(r){r.controls.forEach(function(t){try{r.handler.onAfterXMLChangeProcessing(t,n)}catch(n){e.error("Error during onAfterXMLChangeProcessing",n)}})});return n.view})}};return y});
//# sourceMappingURL=Applier.js.map