//@ui5-bundle sap/ui/fl/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/VersionInfo", ["sap/base/util/LoaderExtensions"],function(n){"use strict";var e={};e.load=function(n){n=n||{};n.async=true;return e._load(n)};var r=null;var i;var a;var t;function s(n){i=n;a=null;t=null}Object.defineProperty(sap.ui,"versioninfo",{configurable:true,enumerable:true,get:function(){return i},set:function(n){s(n)}});e._load=function(a){if(typeof a!=="object"){a={library:a}}a.async=a.async===true;a.failOnError=a.failOnError!==false;if(!i){if(a.async&&r instanceof Promise){return r.then(function(){return e._load(a)})}var t=function(n){r=null;if(n===null){return undefined}s(n);return e._load(a)};var o=function(n){r=null;throw n};var f=n.loadResource("sap-ui-version.json",{async:a.async,failOnError:a.async||a.failOnError});if(f instanceof Promise){r=f;return f.then(t,o)}else{return t(f)}}else{var u;if(typeof a.library!=="undefined"){var c=i.libraries;if(c){for(var l=0,d=c.length;l<d;l++){if(c[l].name===a.library){u=c[l];break}}}}else{u=i}return a.async?Promise.resolve(u):u}};function o(){if(i){if(i.libraries&&!a){a={};i.libraries.forEach(function(n,e){a[n.name]={};var r=n.manifestHints&&n.manifestHints.dependencies&&n.manifestHints.dependencies.libs;for(var i in r){if(!r[i].lazy){a[n.name][i]=true}}})}if(i.components&&!t){t={};Object.keys(i.components).forEach(function(n){var e=i.components[n];t[n]={library:e.library,hasOwnPreload:e.hasOwnPreload||false,dependencies:[]};var r=e.manifestHints&&e.manifestHints.dependencies&&e.manifestHints.dependencies.libs;for(var a in r){if(!r[a].lazy){t[n].dependencies.push(a)}}})}}}e._getTransitiveDependencyForLibraries=function(n){o();if(a){var e=n.reduce(function(n,e){n[e]=true;return Object.assign(n,a[e])},{});n=Object.keys(e)}return n};e._getTransitiveDependencyForComponent=function(n){o();if(t){return t[n]}};e._reset=function(){s()};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/ChangePersistence", ["sap/base/util/restricted/_union","sap/base/util/includes","sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Component","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/performance/Measurement"],function(e,t,n,a,r,i,s,o,c,h,p,l,u,f,g,d,C,m,y,_,v,D){"use strict";const S=new u({id:"variantIndependentUIChanges",parentDataSelector:f.getFlexObjectsDataSelector(),executeFunction(e){return e.filter(function(e){const t=e.isA("sap.ui.fl.apply._internal.flexObjects.UIChange");const n=e.isA("sap.ui.fl.apply._internal.flexObjects.ControllerExtensionChange");const a=e.getFileType()==="change"||e.getFileType()==="codeExt";return(t||n)&&a&&!e.getVariantReference()&&!e.getSelector().persistencyKey})}});var b=function(e){this._mComponent=e;this._mChanges=p.createEmptyDependencyMap();this._bChangesMapCreated=false;this._mChangesInitial=n({},this._mChanges);if(!this._mComponent||!this._mComponent.name){a.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.")}this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};S.clearCachedResult({reference:this._mComponent.name})};async function F(e,t,n){try{if(n){await f.update(t)}await f.getStorageResponse(e)}catch(e){a.error("Error during ChangePersistence.prototype.getChangesForComponent")}}b.prototype.getChangesForComponent=async function(e,t){e||={};await F(this._mComponent.name,e,t);const n=f.getFlexObjectsDataSelector().get({reference:this._mComponent.name});if(!n.length){return[]}let a=S.get({reference:this._mComponent.name});if(!e.includeCtrlVariants){a=a.concat(l.getInitialChanges({reference:this._mComponent.name}))}else{a=a.concat(l.getVariantDependentFlexObjects(this._mComponent.name))}if(e.currentLayer){a=_.filterChangeOrChangeDefinitionsByCurrentLayer(a,e.currentLayer)}a.forEach(function(e){this._mChangesEntries[e.getId()]=e}.bind(this));return a};b.prototype.loadChangesMapForComponent=function(e){return this.getChangesForComponent({component:e}).then(t.bind(this));function t(t){D.start("fl.createDependencyMap","Measurement of creating initial dependency map");this._mChanges=p.createEmptyDependencyMap();t.forEach(this.addChangeAndUpdateDependencies.bind(this,e));this._mChangesInitial=n({},this._mChanges);D.end("fl.createDependencyMap","Measurement of creating initial dependency map");this._bChangesMapCreated=true;return this.getChangesMapForComponent.bind(this)}};b.prototype.getOpenDependentChangesForControl=function(e,t){return p.getOpenDependentChangesForControl(this._mChanges,r.getControlIdBySelector(e,t),t)};function I(e){var t=n({},this._mChangesInitial.mDependencies);return t[e.getId()]}function O(e,n,a,i){var s;var o=[];e.controlsDependencies.forEach(function(e){if(!r.bySelector(e,a)){s=r.getControlIdBySelector(e,a);o.push(e);this._mChanges.mControlsWithDependencies[s]||=[];if(!t(this._mChanges.mControlsWithDependencies[s],i.getId())){this._mChanges.mControlsWithDependencies[s].push(i.getId())}}}.bind(this));e.dependencies=n;e.controlsDependencies=o;if(n.length||o.length){this._mChanges.mDependencies[i.getId()]=e}}b.prototype.copyDependenciesFromInitialChangesMap=function(e,t,n){var a=I.call(this,e);if(a){var r=[];a.dependencies.forEach(function(n){if(t(n)){this._mChanges.mDependentChangesOnMe[n]||=[];this._mChanges.mDependentChangesOnMe[n].push(e.getId());r.push(n)}}.bind(this));O.call(this,a,r,n,e)}return this._mChanges};b.prototype.addChangeAndUpdateDependencies=function(e,t,n){t.setInitialApplyState();if(n){p.insertChange(t,this._mChanges,n)}p.addChangeAndUpdateDependencies(t,e,this._mChanges)};b.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(e,t){p.addRuntimeChangeAndUpdateDependencies(t,e,this._mChanges,this._mChangesInitial)};b.prototype.getChangesMapForComponent=function(){return this._mChanges};b.prototype.getAllUIChanges=function(t){var n=e(this.getChangesMapForComponent().aChanges,t.includeDirtyChanges&&this.getDirtyChanges()).filter(function(e){return Boolean(e)&&e.getFileType()==="change"&&_.compareAgainstCurrentLayer(e.getLayer(),t.layer)===0});return n};b.prototype.isChangeMapCreated=function(){return this._bChangesMapCreated};b.prototype.getChangesForView=function(e){return this.getChangesForComponent(e).then(function(t){return t.filter(o.filterChangeByView.bind(undefined,e))})};function x(e,t){this._addRunTimeCreatedChangeAndUpdateDependencies(t,e);this._mChangesEntries[e.getId()]=e;this._addPropagationListener(t)}b.prototype.addChange=function(e,t){var n=this.addDirtyChange(e);x.call(this,n,t);return n};b.prototype.addChanges=function(e,t){var n=this.addDirtyChanges(e);n.forEach(function(e){x.call(this,e,t)}.bind(this));return n};b.prototype.addDirtyChange=function(e,t){var n;if(typeof e.isA==="function"&&e.isA("sap.ui.fl.apply._internal.flexObjects.FlexObject")){n=e}else{n=c.createFromFileContent(e)}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);if(!t){f.addDirtyFlexObject(this._mComponent.name,n)}}return n};b.prototype.addDirtyChanges=function(e){var t=e.map(function(e){return this.addDirtyChange(e,true)}.bind(this));f.addDirtyFlexObjects(this._mComponent.name,t);return t};b.prototype._addPropagationListener=function(e){var t=v.getAppComponentForControl(e);if(t instanceof i){var n=function(e){return!e._bIsSapUiFlFlexControllerApplyChangesOnControl};var a=t.getPropagationListeners().every(n);if(a){var r=sap.ui.require("sap/ui/fl/FlexControllerFactory");var o=r.create(this._mComponent.name);var c=s.applyAllChangesForControl.bind(s,this.getChangesMapForComponent.bind(this),t,o);c._bIsSapUiFlFlexControllerApplyChangesOnControl=true;t.addPropagationListener(c)}}};b.prototype._deleteNotSavedChanges=function(e,t,n){e.filter(function(e){return!t.some(function(t){return e.getId()===t.getId()})}).forEach(function(e){if(n){this.removeChange(e);f.updateStorageResponse(this._mComponent.name,[{flexObject:e.convertToFileContent(),type:"delete"}])}else{this.deleteChange(e)}}.bind(this))};function E(e,t){var n=e.map(function(e){return e[t]()});var a=n.filter(function(e,t,n){return n.indexOf(e)===t});return a.length===1}function L(e,t,n){var a=false;if(!e||t.length<2||!E(t,"getLayer")){return false}if(n){a=true}else{var r=t[0].getLayer();if([y.CUSTOMER,y.USER].includes(r)){a=true}}var i=new URLSearchParams(window.location.search);if(i.has("sap-ui-xx-condense-changes")){a=i.get("sap-ui-xx-condense-changes")==="true"}return a}function M(e){var t=d.getInstanceOrUndef()&&d.getInstanceOrUndef().isCondensingEnabled();if(t&&!E(e,"getNamespace")){t=false}return t}function T(e,t,n,a){this._massUpdateCacheAndDirtyState(t,n);this._deleteNotSavedChanges(e,t,a)}function U(e,t,n,a){if(!e.length&&!n){return[]}var r=this._mChanges.aChanges.filter(function(e){if(a===y.CUSTOMER&&t){return e.getState()===h.LifecycleState.PERSISTED&&t.includes(e.getId())}return e.getState()===h.LifecycleState.PERSISTED&&_.compareAgainstCurrentLayer(e.getLayer(),a)===0});return r.concat(e)}function A(e){if(e.length){var t=w(e);var n=true;if(d.getInstanceOrUndef()&&d.getInstanceOrUndef().hasPersoConnector()){var a=P(e);n=a.length===1}return t.length===1&&n}return true}function j(e,t,n,a,r,i){var s=[];var o=Promise.resolve();var c=i.filter(function(e){if(e.getState()===h.LifecycleState.DELETED){s.push(e);return false}return true});if(s.length){o=this.saveSequenceOfDirtyChanges(s,a,n)}return o.then(function(){if(c.length){return m.write({layer:e,flexObjects:V(c),transport:t,isLegacyVariant:false,parentVersion:n}).then(function(e){e?.response?.forEach(function(e){c.find(function(t){return t.getId()===e.fileName}).update(e)});T.call(this,r,c,a);return e}.bind(this))}return this._deleteNotSavedChanges(r,i)}.bind(this))}b.prototype.saveDirtyChanges=function(e,t,n,a,r,i,s){var o=n||this._aDirtyChanges;var c=o.length&&o[0].getLayer()||s;var h=U.call(this,o,r,i,c);var p=M(h)&&L(e,h,i);var l=p?h:o;var u=l.slice(0);var f=w(o);if(A(o)){var g=Promise.resolve(u);if(L(e,u,i)){g=C.condense(e,u)}return g.then(function(e){var n=f[0];if(p){return m.condense({allChanges:l,condensedChanges:e,layer:c,transport:n,isLegacyVariant:false,parentVersion:a}).then(function(n){T.call(this,l,e,t,true);return n}.bind(this))}return j.call(this,c,n,a,t,l,e)}.bind(this))}return this.saveSequenceOfDirtyChanges(o,t,a)};b.prototype.saveSequenceOfDirtyChanges=function(e,t,n){var a;if(n){var r=e.filter(function(e){return e.getState()===h.LifecycleState.NEW});a=[].concat(r).shift()}return e.reduce(function(e,r){return e.then(R.bind(undefined,r,a,n)).then(this._updateCacheAndDirtyState.bind(this,r,t))}.bind(this),Promise.resolve())};function R(e,t,n){switch(e.getState()){case h.LifecycleState.NEW:if(n!==undefined){n=e===t?n:g.Number.Draft}return m.write({layer:e.getLayer(),flexObjects:[e.convertToFileContent()],transport:e.getRequest(),parentVersion:n});case h.LifecycleState.DELETED:return m.remove({flexObject:e.convertToFileContent(),layer:e.getLayer(),transport:e.getRequest(),parentVersion:n});default:return Promise.resolve()}}b.prototype._updateCacheAndDirtyState=function(e,t){this._aDirtyChanges=this._aDirtyChanges.filter(function(t){return e.getId()!==t.getId()});if(!t){switch(e.getState()){case h.LifecycleState.NEW:f.updateStorageResponse(this._mComponent.name,[{type:"add",flexObject:e.convertToFileContent()}]);break;case h.LifecycleState.DELETED:f.updateStorageResponse(this._mComponent.name,[{type:"delete",flexObject:e.convertToFileContent()}]);break;case h.LifecycleState.DIRTY:f.updateStorageResponse(this._mComponent.name,[{type:"update",flexObject:e.convertToFileContent()}]);break;default:}}};b.prototype._massUpdateCacheAndDirtyState=function(e,t){e.forEach(function(e){this._updateCacheAndDirtyState(e,t)},this)};function w(e){var t=[];e.forEach(function(e){var n=e.getRequest();if(t.indexOf(n)===-1){t.push(n)}});return t}function P(e){var t=[];e.forEach(function(e){var n=e.getLayer();if(t.indexOf(n)===-1){t.push(n)}});return t}function V(e){var t=[];e.forEach(function(e){t.push(e.convertToFileContent())});return t}b.prototype.getDirtyChanges=function(){return this._aDirtyChanges};b.prototype.deleteChange=function(e,t,n){var a=this._aDirtyChanges.indexOf(e);if(a>-1){if(e.getState()===h.LifecycleState.DELETED){return}this._aDirtyChanges.splice(a,1);if(!n){f.removeDirtyFlexObject(this._mComponent.name,e)}this._deleteChangeInMap(e,t);return}e.markForDeletion();this.addDirtyChange(e);this._deleteChangeInMap(e,t)};b.prototype.deleteChanges=function(e,t){e.forEach(function(e){this.deleteChange(e,t,true)}.bind(this));f.removeDirtyFlexObjects(this._mComponent.name,e)};b.prototype.removeChange=function(e){var t=this._aDirtyChanges.indexOf(e);if(t>-1){this._aDirtyChanges.splice(t,1);f.removeDirtyFlexObject(this._mComponent.name,e)}this._deleteChangeInMap(e)};b.prototype._deleteChangeInMap=function(e,t){var n=e.getId();p.removeChangeFromMap(this._mChanges,n);p.removeChangeFromDependencies(t?this._mChangesInitial:this._mChanges,n)};function N(e,t){return(t.getRequest()==="$TMP"||t.getRequest()==="")&&t.getLayer()===e}function q(e,t){return t.getState()===h.LifecycleState.PERSISTED&&t.getLayer()===e}function B(){var e=[];var t=f.getCompVariantsMap(this._mComponent.name);for(var n in t){for(var a in t[n].byId){e.push(t[n].byId[a])}}return e}b.prototype.transportAllUIChanges=function(e,t,n,a){return this.getChangesForComponent({currentLayer:n,includeCtrlVariants:true}).then(function(e){var r=B.call(this);e=e.concat(r.filter(N.bind(this,n)));return m.publish({transportDialogSettings:{styleClass:t},layer:n,reference:this._mComponent.name,localChanges:e,appVariantDescriptors:a})}.bind(this))};b.prototype._getChangesFromMapByNames=function(e){return this._mChanges.aChanges.filter(function(t){return e.indexOf(t.getId())!==-1})};b.prototype.removeDirtyChanges=function(e,t,n,a,i){var s=[].concat(e||[]);var o=this._aDirtyChanges;var c=o.filter(function(e){var o=true;if(s.length&&!s.includes(e.getLayer())){return false}if(a&&e.getSupportInformation().generator!==a){return false}if(n){var c=e.getSelector();o=n.getId()===r.getControlIdBySelector(c,t)}if(i){o&&=i.indexOf(e.getChangeType())!==-1}return o});f.removeDirtyFlexObjects(this._mComponent.name,c);c.forEach(function(e){var t=o.indexOf(e);o.splice(t,1)});return Promise.resolve(c)};b.prototype.resetChanges=async function(e,t,n,a){const r=n&&n.length>0;const i=a&&a.length>0;const s=d.getInstanceOrUndef()&&d.getInstanceOrUndef().isPublicLayerAvailable();const o=t===undefined&&n===undefined&&a===undefined;const c=s&&o?B.call(this).filter(q.bind(this,e)):[];const h=await this.getChangesForComponent({currentLayer:e,includeCtrlVariants:true});const p=h.concat(c);const l={reference:this._mComponent.name,layer:e,changes:p};if(t){l.generator=t}if(r){l.selectorIds=n}if(i){l.changeTypes=a}const u=await m.reset(l);if(n||a){const e=[];if(u&&u.response&&u.response.length>0){u.response.forEach(function(t){e.push(t.fileName)})}const t=this._getChangesFromMapByNames(e);f.updateStorageResponse(this._mComponent.name,t.map(e=>({flexObject:e.convertToFileContent(),type:"delete"})));return t}return[]};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/ChangePersistenceFactory", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/ChangePersistence"],function(e,n){"use strict";var t={};t._instanceCache={};t.getChangePersistenceForComponent=function(e){var r=t._instanceCache[e];if(!r){var a={name:e};r=new n(a);t._instanceCache[e]=r}return r};t.getChangePersistenceForControl=function(n){var r;r=e.getFlexReferenceForControl(n);return t.getChangePersistenceForComponent(r)};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FlexController", ["sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/write/_internal/Versions","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/base/Log"],function(e,n,t,r,i,a,o,s,h,p,u,c){"use strict";function f(e,n,t){return Promise.resolve().then(function(){if(t.length!==0){t.reverse();return a.revertMultipleChanges(t,{appComponent:e,modifier:p,flexController:this})}return undefined}.bind(this)).then(function(){if(e){var r=e.getModel(h.getVariantModelName());if(r){if(!n){o.update({parameters:[],updateURL:true,updateHashEntry:true,model:r})}}}return t})}var l=function(e){this._oChangePersistence=undefined;this._sComponentName=e||"";if(this._sComponentName){this._oChangePersistence=t.getChangePersistenceForComponent(this._sComponentName)}};l.prototype.setVariantSwitchPromise=function(e){this._oVariantSwitchPromise=e};l.prototype.waitForVariantSwitch=function(){this._oVariantSwitchPromise||=Promise.resolve();return this._oVariantSwitchPromise};function d(n,t,r,i,a){var o=g(n,i);if(!o){return[]}a.push(n);var s=n.getId();var h=t[s]&&t[s].dependencies||[];for(var p=0,u=h.length;p<u;p++){var c=e.getChangeFromChangesMap(r,h[p]);o=d(c,t,r,i,a);if(o.length===0){a=[];break}delete t[s]}return a}function g(e,n){var t=e.getDependentControlSelectorList();t.push(e.getSelector());return!t.some(function(e){return!p.bySelector(e,n)})}l.prototype.waitForChangesToBeApplied=function(e,n){var t=e.map(function(e){return this._waitForChangesToBeApplied(e,n)}.bind(this));return Promise.all(t).then(function(){return undefined})};l.prototype._waitForChangesToBeApplied=function(n,t){function r(e){return!e.isCurrentProcessFinished()&&(n.changeTypes.length===0||n.changeTypes.includes(e.getChangeType()))}n.changeTypes||=[];var i=n.selector.id&&u.getElementById(n.selector.id)||n.selector;var a=this._oChangePersistence.getChangesMapForComponent();var o=[];var s=Object.assign({},a.mDependencies);var{mChanges:h}=a;var p=h[i.getId()]||[];var c=p.filter(r);var f=n.selector.appComponent||e.getAppComponentForControl(i);var l=[];c.forEach(function(e){var n=d(e,s,a.mChanges,f,[]);n.forEach(function(e){if(l.indexOf(e)===-1){l.push(e)}})});l.forEach(function(e){o=o.concat(e.addChangeProcessingPromises())},this);if(!t){o.push(this.waitForVariantSwitch())}return Promise.all(o)};l.prototype._removeOtherLayerChanges=function(e,t,r){if(r&&t){var i=Object.values(n).filter(function(e){return e!==t});return this.removeDirtyChanges(i,e,undefined,undefined,undefined,true)}return Promise.resolve()};l.prototype.saveAll=function(e,t,i,a,o,s){var h;var p;if(i){var u=r.getVersionsModel({reference:this._sComponentName,layer:n.CUSTOMER});h=u.getProperty("/persistedVersion");p=u.getProperty("/draftFilenames")}return this._removeOtherLayerChanges(e,a,o).then(this._oChangePersistence.saveDirtyChanges.bind(this._oChangePersistence,e,t,undefined,h,p,s,a)).then(function(e){if(i&&e&&e.response){var n=e.response;var t=[];if(Array.isArray(n)){n.forEach(function(e){t.push(e.fileName)});[n]=n}r.onAllChangesSaved({reference:n.reference,layer:n.layer,draftFilenames:t})}return e})};l.prototype.resetChanges=function(e,n,t,r,i){return this._oChangePersistence.resetChanges(e,n,r,i).then(f.bind(this,t,undefined))};l.prototype.removeDirtyChanges=function(e,n,t,r,i,a){return this._oChangePersistence.removeDirtyChanges(e,n,t,r,i).then(f.bind(this,n,a))};l.prototype.applyVariantChanges=function(n,t){var r;return n.reduce(function(e,n){return e.then(function(){var e={modifier:p,appComponent:t};this._oChangePersistence._addRunTimeCreatedChangeAndUpdateDependencies(t,n);r=e.modifier.bySelector(n.getSelector(),t);if(r){return i.applyChangeOnControl(n,r,e)}c.error("A flexibility change tries to change a nonexistent control.");return undefined}.bind(this))}.bind(this),e.FakePromise?new e.FakePromise:Promise.resolve())};l.prototype.saveSequenceOfDirtyChanges=function(e,n){return this._oChangePersistence.saveDirtyChanges(n,false,e).then(function(n){e.forEach(function(e){e.setState(s.LifecycleState.PERSISTED)});return n})};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FlexControllerFactory", ["sap/base/Log","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/FlexController","sap/ui/fl/Utils"],function(e,r,t,n){"use strict";var a={};a._instanceCache={};a.create=function(e){var r=a._instanceCache[e];if(!r){r=new t(e);a._instanceCache[e]=r}return r};a.createForControl=function(t){try{var o=n.getAppComponentForControl(t);var c=r.getFlexReferenceForControl(o||t);return a.create(c)}catch(r){e.error(r.message,undefined,"sap.ui.fl.FlexControllerFactory")}};a.createForSelector=function(e){var t=r.getFlexReferenceForSelector(e);return a.create(t)};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/Layer", [],function(){"use strict";return{USER:"USER",PUBLIC:"PUBLIC",CUSTOMER:"CUSTOMER",CUSTOMER_BASE:"CUSTOMER_BASE",PARTNER:"PARTNER",VENDOR:"VENDOR",BASE:"BASE"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/LayerUtils", ["sap/ui/thirdparty/hasher","sap/ui/fl/Layer","sap/ui/fl/initial/_internal/FlexInfoSession"],function(e,r,a){"use strict";var t=[r.BASE,r.VENDOR,r.PARTNER,r.CUSTOMER_BASE,r.CUSTOMER,r.PUBLIC,r.USER];var n={};t.forEach(function(e,r){n[e]=r});function i(e){return new URLSearchParams(window.location.search).get(e)}var s={_mLayersIndex:n,_sTopLayer:t[t.length-1],FL_MAX_LAYER_PARAM:"sap-ui-fl-max-layer",isValidLayer(e){return Object.keys(r).some(function(r){return r===e})},isVendorLayer(){return this.getCurrentLayer()===r.VENDOR},isCustomerDependentLayer(e){return[r.PUBLIC,r.CUSTOMER,r.CUSTOMER_BASE].indexOf(e)>-1},isDeveloperLayer(e){return s.compareAgainstCurrentLayer(e,r.CUSTOMER)===-1},doesCurrentLayerRequirePackage(){var e=this.getCurrentLayer();return e===r.VENDOR||e===r.PARTNER||e===r.CUSTOMER_BASE},getMaxLayer(r){var a=s.getMaxLayerTechnicalParameter(e.getHash(),r);return a||i(this.FL_MAX_LAYER_PARAM)||s._sTopLayer},getLayerIndex(e){return this._mLayersIndex[e]},isOverMaxLayer(e,r){return this.isOverLayer(e,this.getMaxLayer(r))},isOverLayer(e,r){return this.getLayerIndex(e)>this.getLayerIndex(r)},compareAgainstCurrentLayer(e,r){var a=r||s.getCurrentLayer();if(this.getLayerIndex(a)>this.getLayerIndex(e)||!e){return-1}else if(this.getLayerIndex(a)===this.getLayerIndex(e)){return 0}return 1},isLayerFilteringRequired(e){var r=a.getByReference(e);var t=r&&r.maxLayer?r.maxLayer:s._sTopLayer;return this._sTopLayer!==t},isSapUiLayerParameterProvided(){return!!i("sap-ui-layer")},getCurrentLayer(){var e=i("sap-ui-layer")||"";return e.toUpperCase()||r.CUSTOMER},filterChangeDefinitionsByMaxLayer(e,r){return e.filter(function(e){return!e.layer||!s.isOverMaxLayer(e.layer,r)})},filterChangeOrChangeDefinitionsByCurrentLayer(e,r){if(!r){return e}return e.filter(function(e){var a=e.getLayer&&e.getLayer()||e.layer;return r===a})},getMaxLayerTechnicalParameter(e,r){if(r){var a=r.parseShellHash(e)||{};if(a.params&&a.params.hasOwnProperty(this.FL_MAX_LAYER_PARAM)){return a.params[this.FL_MAX_LAYER_PARAM][0]}}return undefined}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/Scenario", [],function(){"use strict";return{AppVariant:"APP_VARIANT",VersionedAppVariant:"VERSIONED_APP_VARIANT",AdaptationProject:"ADAPTATION_PROJECT",FioriElementsFromScratch:"FE_FROM_SCRATCH",UiAdaptation:"UI_ADAPTATION"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/Utils", ["sap/base/i18n/Localization","sap/base/util/isPlainObject","sap/base/util/uid","sap/base/util/restricted/_isEqual","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/base/ManagedObject","sap/ui/core/util/reflection/BaseTreeModifier","sap/ui/core/Component","sap/ui/core/Element","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/Scenario","sap/ui/thirdparty/hasher","sap/ui/core/mvc/View"],function(e,t,r,n,o,i,a,s,p,u,c,l,f,g){"use strict";function m(e){if(e?.getEntry){return e.getEntry?.("sap.app")?.type}return e?.["sap.app"]?.type}function h(e,t){if(e?.startupParameters&&t&&Array.isArray(e.startupParameters[t])){return e.startupParameters[t][0]}}let d=false;const P={isVariantByStartupParameter(e){const t=this.getAppComponentForControl(e);if(t?.getComponentData){return!!h(t.getComponentData(),"sap-app-id")}return false},getAppDescriptor(e){return this.getAppComponentForControl(e)?.getMetadata?.()?.getManifestObject?.().getJson()},isBinding(e){return typeof e==="string"&&!!a.bindingParser(e)||t(e)&&((e.hasOwnProperty("path")||e.hasOwnProperty("parts"))&&!e.hasOwnProperty("ui5object"))},getComponentForControl(e){function t(e){const r=p.getOwnerIdFor(e);if(!r){if(typeof e?.getParent==="function"){const r=e.getParent();if(r){return t(r)}}}return r||""}if(e){const r=t(e);if(r){return p.getComponentById(r)}}},getAppComponentForControl(e){let t=e instanceof p?e:P.getComponentForControl(e);if(t?.getAppComponent?.()instanceof p){return t.getAppComponent()}if(t?.oComponentData?.appComponent){return t.oComponentData.appComponent}if(t?.getManifestEntry){var r=t.getManifestEntry("sap.app");if(r?.type&&r.type!=="application"){if(t instanceof p){t=P.getComponentForControl(t)}return this.getAppComponentForControl(t)}}return t},getAppComponentForSelector(e){return e.appComponent||P.getAppComponentForControl(e)},getViewForControl(e){if(e instanceof g){return e}if(typeof e?.getParent==="function"){e=e.getParent();return P.getViewForControl(e)}},getClient(){return new URLSearchParams(window.location.search).get("sap-client")},getLrepUrl(){const e=c.getFlexibilityServices();const t=e.find(e=>e.connector==="LrepConnector");return t?.url||""},getCurrentLanguage(){const t=e.getLanguage();if(typeof t!=="string"){return""}const r=t.indexOf("-");if(r<0&&t.length<=2){return t.toUpperCase()}if(r>0&&r<=2){return t.substring(0,r).toUpperCase()}return""},getControlType(e){return e?.getMetadata?.()?.getElementName?.()},checkControlId(e,t){if(!t){e=e instanceof a?e:u.getElementById(e);t=P.getAppComponentForControl(e)}return s.checkControlId(e,t)},hasLocalIdSuffix:s.hasLocalIdSuffix,getParsedURLHash(e){return e?.parseShellHash(f.getHash())||{}},getUrlParameter(e){return new URLSearchParams(window.location.search).get(e)},getUshellContainer(){const e=sap.ui.require("sap/ushell/Container");if(e&&!d){try{e.getLogonSystem();d=true}catch(e){return undefined}}return e},createDefaultFileName(e){const t=r().replace(/-/g,"_");return e?`${t}_${e}`:t},createNamespace(e,t){const r=t==="ctrl_variant"?"variants":"changes";const n=e.reference.replace(".Component","");return`apps/${n}/${r}/`},buildLrepRootNamespace(e,t,r){const n="apps";const o="Error in sap.ui.fl.Utils#buildLrepRootNamespace:";if(!e){throw new Error(`${o} for every scenario you need a base ID`)}switch(t){case l.VersionedAppVariant:case l.AppVariant:if(!r){throw new Error(`${o} in the ${t} scenario you additionally need a project ID`)}return`${n}/${e}/appVariants/${r}/`;case l.AdaptationProject:if(!r){throw new Error(`${o} in the ${t} scenario you additionally need a project ID`)}return`${n}/${e}/adapt/${r}/`;case l.FioriElementsFromScratch:case l.UiAdaptation:default:return`${n}/${e}/`}},isApplication(e){return m(e)==="application"},isApplicationComponent(e){return e instanceof p&&P.isApplication(e.getManifestObject())},isEmbeddedComponent(e){const t=P.getAppComponentForControl(e);return!!(e instanceof p&&m(e.getManifestObject())==="component"&&t&&P.isApplicationComponent(t))},indexOfObject(e,t){return e.findIndex(e=>n(e,t))},execPromiseQueueSequentially(e,t,r){if(e.length===0){if(r){return Promise.resolve()}return P.FakePromise?new P.FakePromise:Promise.resolve()}var n=e.shift();if(typeof n==="function"){var i;try{i=n()}catch(e){i=Promise.reject(e)}return i.then(function(){if(!r&&i instanceof Promise){r=true}}).catch(function(e){var r="Error during execPromiseQueueSequentially processing occurred";r+=e?`: ${e.message}`:"";o.error(r,e);if(t){throw new Error(r)}}).then(function(){return this.execPromiseQueueSequentially(e,t,r)}.bind(this))}o.error("Changes could not be applied, promise not wrapped inside function.");return this.execPromiseQueueSequentially(e,t,r)},FakePromise:function(e,t,r){P.FakePromise.fakePromiseIdentifier="sap.ui.fl.Utils.FakePromise";this.vValue=e;this.vError=t;this.bContinueWithFakePromise=arguments.length<3||r===P.FakePromise.fakePromiseIdentifier;var n=function(e,t){try{var r=t(e,P.FakePromise.fakePromiseIdentifier);if(i.isThenable(r)){return r}return new P.FakePromise(r)}catch(e){var n=e;return new P.FakePromise(undefined,n)}};P.FakePromise.prototype.then=function(e,t){if(!this.bContinueWithFakePromise){return Promise.resolve(e(this.vValue))}if(!this.vError){return n(this.vValue,e)}else if(t){return n(this.vError,t)}return this};P.FakePromise.prototype.catch=function(e){if(!this.bContinueWithFakePromise){return Promise.reject(e(this.vError))}if(this.vError){return n(this.vError,e)}return this};if(this.vValue instanceof Promise||this.vValue instanceof P.FakePromise){return this.vValue}},getChangeFromChangesMap(e,t){let r;Object.values(e).some(e=>{r=e.find(e=>e.getId()===t);return r});return r},handleUrlParameters(e,t,r,n){if(P.hasParameterAndValue(t,r,n)){if(e.startsWith("?")){e=e.substr(1,e.length)}const n=e.split("&").filter(e=>e!==`${t}=${r}`);e="";if(n.length>0){e=`?${n.join("&")}`}}else{e+=`${(e.length>0?"&":"?")+t}=${r}`}return e},hasParameterAndValue(e,t,r){return P.getParameter(e,r)===t},getParameter(e,t){return P.getParsedURLHash(t)?.params?.[e]?.[0]||P.getUrlParameter(e)},findAggregation(e,t){return e?.getMetadata?.()?.getAllAggregations?.()?.[t]},getAggregation(e,t){const r=P.findAggregation(e,t);if(r){return e[r._sGetter]()}return undefined},getProperty(e,t){const r=e.getMetadata().getPropertyLikeSetting(t)?._sGetter;return e[r]()},getUShellService(e){if(e){const t=this.getUshellContainer();if(t){return t.getServiceAsync(e)}}return Promise.resolve()},async getUShellServices(e){const t={};for(const r of e){t[r]=await this.getUShellService(r)}return t}};return P});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/DelegateMediator", ["sap/base/Log","sap/base/util/merge","sap/base/util/restricted/_pick","sap/ui/fl/requireAsync","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,t,r,n,a){"use strict";var i={};i._mDefaultDelegateItems={};i.types={READONLY:"readonly",WRITEONLY:"writeonly",COMPLETE:"complete"};function o(e,t){if(t){return t}if(e.getModel){var r=e.getModel();if(!r){return undefined}return r.getMetadata().getName()}return undefined}function u(e,t){t=o(e,t);var r=i._mDefaultDelegateItems[t];return(r||[]).map(function(e){e.payload={};return e})}function l(t,r,a){if(!a.length){return Promise.resolve([])}var i=[];a.forEach(function(a){i.push(function(i){return n(a.name).then(function(e){a.instance=e||{};i.push(a);return i}).catch(function(n){e.error(`Failed to load the delegate for the control ${t.getId(r)}\n\t\t\t\t\t${n.message}`);return i})})});return i.reduce(function(e,t){return e.then(t)},Promise.resolve([]))}function s(e){return e&&typeof e==="function"}function f(e){return e.delegateType===i.types.COMPLETE||s(e.instance.getPropertyInfo)&&(s(e.instance.createLabel)||s(e.instance.createLayout))}function c(e){return e.delegateType===i.types.READONLY||s(e.instance.getPropertyInfo)}function d(e){return e.delegateType===i.types.WRITEONLY||s(e.instance.createLabel)||s(e.instance.createLayout)}function p(e,t){e.names.push(t.name);if(t.requiredLibraries){e.requiredLibraries=Object.assign(e.requiredLibraries||{},t.requiredLibraries)}if(t.payload&&!e.payload){e.payload=t.payload}if(t.delegateType){e.delegateType=t.delegateType}return e}function g(e,n){e=p(e,n);return t(e,{instance:r(n.instance,["getPropertyInfo","getRepresentedProperties"])})}function y(e,n){e=p(e,n);return t(e,{instance:r(n.instance,["createLabel","createControlForProperty","createLayout"])})}function m(e,n){e=p(e,n);return t(e,r(n,"instance"))}function T(e){var t={names:[],instance:{},modelType:e.length&&e[0].modelType};var r=true;var n=true;for(var a=e.length-1;a>=0;a--){var i=e[a];if(f(i)){if(r&&n){t=m(t,i)}else if(r){t=g(t,i)}else if(n){t=y(t,i)}break}else if(c(i)&&r){t=g(t,i);r=false}else if(d(i)&&n){t=y(t,i);n=false}}return e.length?t:undefined}function h(e,t){return new Promise(function(r,n){if(!e){n(new Error("The control parameter is missing"))}if(!t){n(new Error("The modifier parameter is missing"))}if(!e){n(new Error("The input control should be available"))}if(t===a&&(!e.isA||!e.isA("sap.ui.base.ManagedObject"))){n(new Error("The input control should be a managed object"))}r()})}function D(e){return Object.values(i.types).some(function(t){return t===e.delegateType})}function b(e){var t=i._mDefaultDelegateItems[e.modelType]||[];var r=t.map(function(e){return e.delegateType});return r.indexOf(i.types.COMPLETE)>-1||r.indexOf(e.delegateType)>-1||e.delegateType===i.types.COMPLETE&&r.length}i.getKnownDefaultDelegateLibraries=function(){return["sap.ui.comp"]};i.getRequiredLibrariesForDefaultDelegate=function(e,t,r){r=o(t,r);var n=i._mDefaultDelegateItems[r]||[];return n.reduce(function(t,r){var n=e.indexOf(r.name)>-1;return t.concat(Object.keys(n&&r.requiredLibraries||{}))},[])};i.isDelegateRegistered=function(e){return!!i._mDefaultDelegateItems[e]};i.registerDefaultDelegate=function(e){if(!(e.modelType&&e.delegate)){throw new Error("'modelType' and 'delegate' properties are required for registration!")}e.delegateType||=i.types.COMPLETE;if(e.delegateType&&!D(e)){throw new Error(`default 'delegateType': ${e.delegateType} is invalid!`)}if(b(e)){throw new Error(`modelType ${e.modelType}is already defined!`)}i._mDefaultDelegateItems[e.modelType]||=[];i._mDefaultDelegateItems[e.modelType].push({name:e.delegate,requiredLibraries:e.requiredLibraries,delegateType:e.delegateType,modelType:e.modelType})};i.getDelegateForControl=function(e,t,r,n){return h(e,t).then(function(){return t.getFlexDelegate(e)}).then(function(a){var i=n&&u(e,r)||[];if(a){i.push(a)}return l(t,e,i)}).then(T.bind(this))};i.clear=function(){i._mDefaultDelegateItems={}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/Applier", ["sap/base/Log","sap/base/strings/formatMessage","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/Utils"],function(e,n,r,t,a,o,i,s){"use strict";var l=s.FakePromise?new s.FakePromise:Promise.resolve();function c(r,t,a,o){var i=t.join(" ");i=n(i,a);e[r](i,o||"")}function u(e,n){var r=e.getSelector&&e.getSelector();if(!r||!r.id&&!r.name){return Promise.reject(Error("No selector in change found or no selector ID."))}function t(e){if(s.indexOfObject(n.failedSelectors,e)>-1){throw Error("A change depending on that control already failed, so the current change is skipped")}}return n.modifier.bySelectorTypeIndependent(r,n.appComponent,n.view).then(function(a){if(!a){throw Error("A flexibility change tries to change a nonexistent control.")}t(r);var o=e.getDependentControlSelectorList();o.forEach(function(e){var r=n.modifier.bySelector(e,n.appComponent,n.view);if(!r){throw new Error("A dependent selector control of the flexibility change is not available.")}t(e)});return a})}function f(e){return e.modifier.targets==="xmlTree"}function d(e,n,r,t,i){var s=o.getControlIfTemplateAffected(n,e,i).control;var l=i.modifier;var c=s&&!!a.getAppliedCustomDataValue(s,n,l);var u=s&&a.hasChangeApplyFinishedCustomData(s,n,l);var d=n.isApplyProcessFinished();var g=i.appComponent;if(d&&!u){if(!f(i)){var p=o.checkIfDependencyIsStillValid.bind(null,g,l,r);t._oChangePersistence.copyDependenciesFromInitialChangesMap(n,p,g)}n.setInitialApplyState()}else if(!d&&u){if(c){n.setRevertData(a.getParsedRevertDataFromCustomData(s,n,l));n.markSuccessful()}else{n.markFailed()}}else if(d&&u){n.markSuccessful()}}function g(e,n){var r;if(f(n)&&e.getJsOnly()){r="Change cannot be applied in XML. Retrying in JS."}if(r){e.setInitialApplyState();throw Error(r)}}function p(e,n,t,o){return Promise.resolve().then(function(){if(t instanceof r){n.control=t}if(n.control){return o.modifier.updateAggregation(n.originalControl,e.getContent().boundAggregation)}return undefined}).then(function(){return a.addAppliedCustomData(n.control,e,o,f(o))}).then(function(){var n={success:true};e.markSuccessful(n);return n})}function h(e,n,r,t){var o=f(t);var i={success:false,error:e};var s=n.getId();var l="Change ''{0}'' could not be applied.";var u=e instanceof Error;var d=a.getCustomDataIdentifier(false,u,o);switch(d){case a.notApplicableChangesCustomDataKey:c("info",[l,e.message],[s]);break;case a.failedChangesCustomDataKeyXml:c("warning",[l,"Merge error detected while processing the XML tree."],[s],e.stack);break;case a.failedChangesCustomDataKeyJs:c("error",[l,"Merge error detected while processing the JS control tree."],[s],e.stack);break;default:}return a.addFailedCustomData(r.control,n,t,d).then(function(){if(o){n.setInitialApplyState()}else{n.markFailed(i)}return i})}function m(n,r){var t=r.getChangeType();var a=r.getSelector().id;var o=`${r.getNamespace()+r.getId()}.${r.getFileType()}`;var i="A flexibility change could not be applied.";i+="\nThe displayed UI might not be displayed as intedend.";if(n.message){i+=`\n   occurred error message: '${n.message}'`}i+=`\n   type of change: '${t}'`;i+=`\n   LRep location of the change: ${o}`;i+=`\n   id of targeted control: '${a}'.`;e.warning(i,undefined,"sap.ui.fl.apply._internal.changes.Applier")}function v(e,n,r){var a={appComponent:r,modifier:t};var o=t.bySelector(e.originalSelectorToBeAdjusted,r);var i=n.getBindingInfo(e.getContent().boundAggregation).template;if(o.getParent()){var s=[];var l=o;do{s.push({aggregation:l.sParentAggregationName,index:l.getParent().getAggregation(l.sParentAggregationName).indexOf(l)});l=l.getParent()}while(l.getParent());s.reverse();s.forEach(function(e){i=i.getAggregation(e.aggregation)[e.index]})}e.addDependentControl(i,"originalSelector",a)}function C(e,n,r){var t=e.findIndex(function(e){return e.handler===n});if(t<0){t=e.length;e.push({handler:n,controls:[]})}if(!e[t].controls.includes(r)){e[t].controls.push(r)}}var y={addPreConditionForInitialChangeApplying(e){l=l.then(function(){return e})},applyChangeOnControl(e,n,r){var t=o.getControlIfTemplateAffected(e,n,r);var a=r.changeHandler?Promise.resolve(r.changeHandler):o.getChangeHandler(e,t,r);return a.then(function(n){g(e,r);return n}).then(function(n){if(e.hasApplyProcessStarted()){return e.addPromiseForApplyProcessing().then(function(n){e.markSuccessful();return n})}else if(!e.isApplyProcessFinished()){return(s.FakePromise?new s.FakePromise:Promise.resolve()).then(function(){e.startApplying();return n.applyChange(e,t.control,r)}).then(function(n){return p(e,t,n,r)}).catch(function(n){return h(n,e,t,r)})}var a={success:true};e.markSuccessful(a);return a}).catch(function(e){return{success:false,error:e}})},applyAllChangesForControl(e,n,r,a){var o=e();var c=a.getId();var u=o.mChanges[c]||[];var f={modifier:t,appComponent:n,view:s.getViewForControl(a)};u.forEach(function(e){d(a,e,o,r,f);if(!e.isApplyProcessFinished()&&!e._ignoreOnce){e.setQueuedForApply()}});l=l.then(function(e,r){var t=[];var a=e.getId();var l=o.mChanges[a]||[];var c;if(o.mControlsWithDependencies[a]){i.removeControlsDependencies(o,a);c=true}l.forEach(function(s){if(s.originalSelectorToBeAdjusted){v(s,e,n);delete s.originalSelectorToBeAdjusted}if(s._ignoreOnce){delete s._ignoreOnce}else if(s.isApplyProcessFinished()){i.resolveDependenciesForChange(o,s.getId(),a)}else if(!o.mDependencies[s.getId()]){t.push(function(){return y.applyChangeOnControl(s,e,r).then(function(){i.resolveDependenciesForChange(o,s.getId(),a)})})}else{var l=y.applyChangeOnControl.bind(y,s,e,r);i.addChangeApplyCallbackToDependency(o,s.getId(),l)}});if(l.length||c){return s.execPromiseQueueSequentially(t).then(function(){return i.processDependentQueue(o,n,a)})}return undefined}.bind(null,a,f));return l},applyAllChangesForXMLView(n,r){if(!Array.isArray(r)){var t=`No list of changes was passed for processing the flexibility on view: ${n.view}.`;e.error(t,undefined,"sap.ui.fl.apply._internal.changes.Applier");r=[]}var a=[];n.failedSelectors=[];return r.reduce(function(e,r){var t;return e.then(u.bind(null,r,n)).then(function(e){t=e;var a=o.getControlIfTemplateAffected(r,t,n);return o.getChangeHandler(r,a,n)}).then(function(e){n.changeHandler=e;r.setQueuedForApply();d(t,r,undefined,undefined,n);if(!r.isApplyProcessFinished()){if(typeof n.changeHandler.onAfterXMLChangeProcessing==="function"){C(a,n.changeHandler,t)}return y.applyChangeOnControl(r,t,n)}return{success:true}}).then(function(e){if(!e.success){throw Error(e.error)}}).catch(function(e){r.getDependentSelectorList().forEach(function(e){if(s.indexOfObject(n.failedSelectors,e)===-1){n.failedSelectors.push(e)}});m(e,r)})},s.FakePromise?new s.FakePromise:Promise.resolve()).then(function(){delete n.failedSelectors;a.forEach(function(r){r.controls.forEach(function(t){try{r.handler.onAfterXMLChangeProcessing(t,n)}catch(n){e.error("Error during onAfterXMLChangeProcessing",n)}})});return n.view})}};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/FlexCustomData", ["sap/ui/fl/Utils","sap/base/Log","sap/ui/core/CustomData"],function(a,t){"use strict";var e={};e.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";e.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";e.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";e.notApplicableChangesCustomDataKey="sap.ui.fl.notApplicableChanges";function u(a,t,e,u){var s=u.modifier.getCustomDataInfo(a,t);if(!s.customData){return u.modifier.createAndAddCustomData(a,t,e,u.appComponent)}return Promise.resolve(u.modifier.setProperty(s.customData,"value",e))}function s(a,t){var e=t.getRevertData();if(a&&e!==undefined){return JSON.stringify(e)}return"true"}e.getAppliedCustomDataValue=function(a,t,u){var s=u.getCustomDataInfo(a,e._getCustomDataKey(t,e.appliedChangesCustomDataKey));return s.customDataValue};e.getParsedRevertDataFromCustomData=function(a,u,s){var o=e.getAppliedCustomDataValue(a,u,s);try{return o&&JSON.parse(o)}catch(a){t.error("Could not parse revert data from custom data",o);return undefined}};e.hasChangeApplyFinishedCustomData=function(a,t,u){var s=u.getCustomDataInfo(a,e._getCustomDataKey(t,e.appliedChangesCustomDataKey));if(s.customData){return true}var o=u.getCustomDataInfo(a,e._getCustomDataKey(t,e.failedChangesCustomDataKeyJs));if(o.customData){return true}var r=u.getCustomDataInfo(a,e._getCustomDataKey(t,e.notApplicableChangesCustomDataKey));if(r.customData){return true}return false};e.addAppliedCustomData=function(a,t,o,r){var n=s(r,t);var i=e._getCustomDataKey(t,e.appliedChangesCustomDataKey);return u(a,i,n,o)};e.addFailedCustomData=function(a,t,s,o){var r=e._getCustomDataKey(t,o);return u(a,r,"true",s)};e.destroyAppliedCustomData=function(a,t,u){var s=e._getCustomDataKey(t,e.appliedChangesCustomDataKey);var o=u.getCustomDataInfo(a,s);if(o.customData){u.destroy(o.customData)}};e.getCustomDataIdentifier=function(a,t,u){if(a){return e.appliedChangesCustomDataKey}if(!t){return e.notApplicableChangesCustomDataKey}if(u){return e.failedChangesCustomDataKeyXml}return e.failedChangesCustomDataKeyJs};e._getCustomDataKey=function(a,t){return`${t}.${a.getId()}`};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/Reverter", ["sap/base/Log","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/Utils"],function(e,r,n,t,o){"use strict";var i={};function a(e){if(!e.isApplyProcessFinished()&&e.hasApplyProcessStarted()){return e.addPromiseForApplyProcessing().then(function(r){if(r&&r.error){e.markRevertFinished(r.error);throw Error(r.error)}})}return Promise.resolve()}function l(e,r,t,o){return i.revertChangeOnControl(e,r,t).then(function(t){n.destroyAppliedCustomData(t||r,e,o.modifier);if(t){o.flexController._oChangePersistence._deleteChangeInMap(e)}})}i.revertChangeOnControl=function(r,n,o){var i=t.getControlIfTemplateAffected(r,n,o);var l;return t.getChangeHandler(r,i,o).then(function(e){l=e}).then(a.bind(null,r)).then(function(){if(r.isSuccessfullyApplied()){r.startReverting();return l.revertChange(r,i.control,o)}throw Error("Change was never applied")}).then(function(){i.control=o.modifier.bySelector(r.getSelector(),o.appComponent,o.view);if(i.bTemplateAffected){return o.modifier.updateAggregation(i.control,r.getContent().boundAggregation)}return undefined}).then(function(){r.markRevertFinished();return i.control}).catch(function(n){var t=`Change could not be reverted: ${n.message}`;e.error(t);r.markRevertFinished(t);return false})};i.revertMultipleChanges=function(n,t){var i=[];n.forEach(function(r){r.setQueuedForRevert();i.push(function(){var n=r.getSelector&&r.getSelector();var i=t.modifier.bySelector(n,t.appComponent);if(!i){e.warning(`A flexibility change tries to revert changes on a nonexistent control with id ${n.id}`);return o.FakePromise?new o.FakePromise:Promise.resolve()}var a={modifier:t.modifier,appComponent:t.appComponent,view:o.getViewForControl(i)};return l(r,i,a,t)})});const a=o.execPromiseQueueSequentially(i);r.addPreConditionForInitialChangeApplying(a);return a};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/Utils", ["sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage","sap/ui/fl/requireAsync","sap/ui/fl/Utils"],function(e,r,t,n){"use strict";function a(e,r){if(r||e.hasApplyProcessStarted()){return false}return true}var i={getControlIfTemplateAffected(e,r,t){var n=t.modifier;var a={originalControl:r};var i=e.getOriginalSelector();if(e.getContent().boundAggregation&&i){a.control=n.bySelector(i,t.appComponent,t.view);a.controlType=n.getControlType(a.control);a.bTemplateAffected=true}else{a.control=r;a.controlType=n.getControlType(r);a.bTemplateAffected=false}return a},getChangeHandler(e,n,a){var i=a.modifier.getLibraryName(n.control);return Promise.all([t("sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration"),i]).then(function(e){return e[0].waitForChangeHandlerRegistration(e[1])}).then(function(){var t=e.getChangeType();var i=e.getLayer();return r.getChangeHandler(t,n.controlType,n.control,a.modifier,i)})},checkIfDependencyIsStillValid(r,t,i,l){var o=n.getChangeFromChangesMap(i.mChanges,l);if(!o){return false}var f=t.bySelector(o.getSelector(),r);if(!f){return true}var g=e.hasChangeApplyFinishedCustomData(f,o,t);return a(o,g)},filterChangeByView(e,r){var t=e.modifier;var n=e.appComponent;var a=r.getSelector();if(!a){return false}if(a.viewSelector){var i=t.getControlIdBySelector(a.viewSelector,n);return i===e.viewId}var l=a.id;if(l){var o;if(r.getSelector().idIsLocal){if(n){o=n.getLocalId(e.viewId)}}else{o=e.viewId}var f=0;var g;do{f=l.indexOf("--",f);g=l.slice(0,f);f++}while(g!==o&&f>0);return g===o}return false}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/Applier", ["sap/base/util/isEmptyObject","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory"],function(e,t){"use strict";var n="$sap.ui.fl.changes";function r(e){var r=e&&e.getEntry&&e.getEntry(n)&&e.getEntry(n).descriptor||[];return r.map(function(e){return t.createAppDescriptorChange(e)})}var a={applyChanges(t,n,r){return r.registry().then(function(e){var t=n.map(function(t){return e[t.getChangeType()]&&e[t.getChangeType()]()});return Promise.all(t)}).then(function(a){a.forEach(function(a,s){try{var i=n[s];t=a.applyChange(t,i);if(!a.skipPostprocessing&&!e(i.getTexts())){t=r.processTexts(t,i.getTexts())}}catch(e){r.handleError(e)}});return t})},applyChangesIncludedInManifest(e,t){var a=r(e);var s=e.getJson();delete s[n];if(a.length>0){return this.applyChanges(s,a,t).then(function(){return})}return Promise.resolve()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory", ["sap/ui/fl/requireAsync","sap/base/Log"],function(r,e){"use strict";function t(r,e){const n=Array.isArray(r)?[...r]:{...r};Object.entries(n).forEach(([r,s])=>{if(typeof s==="object"&&s!==null){n[r]=t(s,e)}else if(typeof s==="string"){n[r]=s.replaceAll(/{{.*?}}/g,r=>{const t=r.slice(2,-2);const n=e[t];return n||r})}});return n}var n={registry(){return r("sap/ui/fl/apply/_internal/changes/descriptor/Registration")},handleError(r){e.error(r)},processTexts(r,n){const s={};Object.entries(n).forEach(([r,{value:t}])=>{if(t[""]){s[r]=t[""];return}e.error("Text change has to contain default language")});return t(r,s)}};var s={getRuntimeStrategy(){return n}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/changes/descriptor/Preprocessor", ["sap/ui/fl/apply/_internal/changes/descriptor/Applier","sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/performance/Measurement","sap/ui/fl/Utils"],function(e,t,n,a,i,r){"use strict";var s={preprocessManifest(s,p){if(!r.isApplication(s,true)||!p.id){return Promise.resolve(s)}i.start("flexStateInitialize","Initialization of flex state",["sap.ui.fl"]);var l=p.componentData||{};var f=a.getFlexReference({manifest:s,componentData:l});if(!a.getChangeManifestFromAsyncHints(p.asyncHints)){n.initialize({componentData:l,asyncHints:p.asyncHints,rawManifest:s,componentId:p.id,reference:f,partialFlexState:true}).then(i.end.bind(undefined,"flexStateInitialize"));return Promise.resolve(s)}return n.initialize({componentData:l,asyncHints:p.asyncHints,rawManifest:s,componentId:p.id,reference:f,partialFlexState:true}).then(function(){i.end("flexStateInitialize");i.start("flexAppDescriptorMerger","Client side app descriptor merger",["sap.ui.fl"]);var a=Object.assign({},s);var r=n.getAppDescriptorChanges(f);return e.applyChanges(a,r,t.getRuntimeStrategy())}).then(function(e){i.end("flexAppDescriptorMerger");return e})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/controlVariants/URLHandler", ["sap/ui/core/Component","sap/base/Log","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/hasher","sap/base/util/includes","sap/ui/fl/apply/_internal/controlVariants/Utils"],function(e,a,r,t,n,o,i,s,l,p){"use strict";var m={};var c={};function d(e,a){var r=[];return e.reduce(function(e,t){var n=a.getVariantManagementReference(t).variantManagementReference;if(n){if(l(r,n)){e.updateRequired=true;return e}r.push(n)}if(n&&a.oData[n].currentVariant!==t){e.updateRequired=true;if(a.oData[n].currentVariant!==a.oData[n].defaultVariant){e.parameters.push(a.oData[n].currentVariant)}}else{e.parameters.push(t)}return e},{updateRequired:false,parameters:[]})}function u(e,a){var r=n.get(["params",p.VARIANT_TECHNICAL_PARAMETER],e);if(r){var t=d(r,a);if(t.updateRequired){c.update({updateURL:!a._bDesignTimeMode,parameters:t.parameters,updateHashEntry:true,model:a})}}}function f(e,r){try{var t=e.getUShellService("URLParsing");if(t){var n=t.parseShellHash(r);u(n,e)}}catch(e){a.error(e.message)}var o=e.getUShellService("ShellNavigation");return o&&o.NavigationFilterStatus.Continue}function v(e){var a=e.getUShellService("ShellNavigation");if(!m[e.sFlexReference]){m[e.sFlexReference]=f.bind(null,e);if(a){a.registerNavigationFilter(m[e.sFlexReference])}}}function A(e){var a=e.getUShellService("ShellNavigation");if(a){a.unregisterNavigationFilter(m[e.sFlexReference]);delete m[e.sFlexReference]}}function h(e){var t=e.model;var n=t.getUShellService("URLParsing");var o=t.getUShellService("CrossApplicationNavigation");var i=n&&n.parseShellHash(s.getHash());if(i&&i.params){var l=Object.assign({},i.params);var m=t.oAppComponent&&t.oAppComponent.getComponentData&&t.oAppComponent.getComponentData()&&t.oAppComponent.getComponentData().technicalParameters;if(!m){a.warning("Component instance not provided, so technical parameters in component data and browser history remain unchanged")}if(e.parameters.length===0){delete i.params[p.VARIANT_TECHNICAL_PARAMETER];m&&delete m[p.VARIANT_TECHNICAL_PARAMETER]}else{i.params[p.VARIANT_TECHNICAL_PARAMETER]=e.parameters;m&&(m[p.VARIANT_TECHNICAL_PARAMETER]=e.parameters)}if(e.silent){s.changed.active=false;s.replaceHash(n.constructShellHash(i));s.changed.active=true}else if(!r(l,i.params)){o.toExternal({target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false})}}}function R(e){var a={index:-1};var r=e.model;var n=r.getUShellService("URLParsing");var i=n&&n.parseShellHash(s.getHash()).params;if(i){a.parameters=[];if(r._bDesignTimeMode){i[p.VARIANT_TECHNICAL_PARAMETER]=c.getStoredHashParams(e)}if(Array.isArray(i[p.VARIANT_TECHNICAL_PARAMETER])){i[p.VARIANT_TECHNICAL_PARAMETER]=i[p.VARIANT_TECHNICAL_PARAMETER].map(decodeURIComponent);i[p.VARIANT_TECHNICAL_PARAMETER].some(function(t,n){if(!o(r.getVariant(t,e.vmReference))){a.index=n;return true}return false})}}return t(a,i&&i[p.VARIANT_TECHNICAL_PARAMETER]&&{parameters:i[p.VARIANT_TECHNICAL_PARAMETER]})}function g(e){var a=e.getUShellService("URLParsing");var r=a&&a.parseShellHash(s.getHash());return r&&r.params&&r.params[p.VARIANT_TECHNICAL_PARAMETER]}c.variantTechnicalParameterName="sap-ui-fl-control-variant-id";c.initialize=function(e){var a=e.model;var r=a.getUShellService("URLParsing");var t=r&&r.parseShellHash(s.getHash());var n=t&&t.params&&t.params[p.VARIANT_TECHNICAL_PARAMETER];c.attachHandlers(e);c.update({model:a,parameters:n,updateHashEntry:Array.isArray(n)&&n.length>0});u(t,a)};c.updateVariantInURL=function(e){var a=c.removeURLParameterForVariantManagement(e);if(!a.parameters){return}var r=a.parameters||[];var t=a.index;var n=e.newVReference===e.model.oData[e.vmReference].defaultVariant;if(!n){if(t===-1){r=r.concat([e.newVReference])}else{r=r.slice(0,t).concat([e.newVReference],r.slice(t))}}if(!n||t>-1){c.update({parameters:r,updateURL:!e.model._bDesignTimeMode,updateHashEntry:true,model:e.model})}};c.removeURLParameterForVariantManagement=function(e){var a=R(e);if(a.index>-1){a.parameters.splice(a.index,1)}return a};c.attachHandlers=function(a){function r(){return a.model._oVariantSwitchPromise.then(function(){a.model._oHashData.controlPropertyObservers.forEach(function(e){e.destroy()});A(a.model);a.model.destroy();a.model.oComponentDestroyObserver.unobserve(a.model.oAppComponent,{destroy:true});a.model.oComponentDestroyObserver.destroy()})}v(a.model);if(!a.model.oComponentDestroyObserver&&a.model.oAppComponent instanceof e){a.model.oComponentDestroyObserver=new i(r.bind(null));a.model.oComponentDestroyObserver.observe(a.model.oAppComponent,{destroy:true})}};c.registerControl=function(e){if(e.updateURL){e.model._oHashData.variantControlIds.push(e.vmReference)}};c.update=function(e){e.model._oHashData||={hashParams:[],controlPropertyObservers:[],variantControlIds:[]};if(!e||!Array.isArray(e.parameters)){a.info("Variant URL parameters could not be updated since invalid parameters were received");return}if(e.updateURL){h(e)}if(e.updateHashEntry&&!o(e.model)){e.model._oHashData.hashParams=e.parameters}};c.getStoredHashParams=function(e){return Array.prototype.slice.call(e.model._oHashData.hashParams)};c.handleModelContextChange=function(e){var a="modelContextChange";function r(a,r){var t=r.model.getVariantManagementReferenceForControl(a.getSource());var n=r.model._oHashData.variantControlIds;var o=n.indexOf(t);if(o>-1){n.slice(o).forEach(function(a){if(R({vmReference:a,model:e.model}).index===-1){r.model.switchToDefaultForVariantManagement(a)}})}}var t=new i(function(t){if(t.current===true&&t.old===false){t.object.attachEvent(a,{model:e.model},r)}else if(t.current===false&&t.old===true){t.object.detachEvent(a,r)}});t.observe(e.vmControl,{properties:["resetOnContextChange"]});e.model._oHashData.controlPropertyObservers.push(t);if(e.vmControl.getResetOnContextChange()!==false){e.vmControl.attachEvent(a,{model:e.model},r)}};c.clearAllVariantURLParameters=function(e){if(g(e.model)){c.update({updateURL:true,parameters:[],updateHashEntry:false,model:e.model})}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/controlVariants/Utils", ["sap/ui/core/Element","sap/ui/core/StaticArea","sap/ui/fl/Utils"],function(e,t,r){"use strict";function n(e,t){if(!t){return undefined}if(e.indexOf(t.getId())>-1){return t.getId()}return n(e,t.getParent())}function a(e,n){var a=r.getAppComponentForControl(e);var o=a.getRootControl();var i=[];if(!n&&o.getDomRef()){i=Array.from(o.getDomRef().querySelectorAll(".sapUiFlVarMngmt"))}if(n||i.length===0){i=Array.from(t.getDomRef().querySelectorAll(".sapUiFlVarMngmt"))}return i.map(function(e){return e.id})}var o={DEFAULT_AUTHOR:"SAP",VARIANT_TECHNICAL_PARAMETER:"sap-ui-fl-control-variant-id",compareVariants(e,t){if(e.getName().toLowerCase()<t.getName().toLowerCase()){return-1}else if(e.getName().toLowerCase()>t.getName().toLowerCase()){return 1}return 0},getIndexToSortVariant(e,t){var r=e.length;e.some(function(e,n){if(o.compareVariants(t.instance,e.instance)<0){r=n;return true}});return r},getRelevantVariantManagementControlId(t,r,o){var i={};if(!r||!r.length){r=a(t,o)}var u=r.reduce(function(t,r){var n=e.getElementById(r);if(n){var a=n.getFor();a.forEach(function(e){i[e]=r});t=t.concat(a)}return t},[]);var g=n(u,t);return i[g]},belongsToVariantManagement(e){var t=a(e);return!!o.getRelevantVariantManagementControlId(e,t)},getAllVariantManagementControlIds(e){return a(e)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/AppDescriptorChange", ["sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(e){"use strict";var t=e.extend("sap.ui.fl.apply._internal.flexObjects.AppDescriptorChange",{metadata:{properties:{appDescriptorChange:{type:"boolean",defaultValue:true}}}});t.getMappingInfo=function(){return Object.assign(e.getMappingInfo(),{appDescriptorChange:"appDescriptorChange"})};t.prototype.getMappingInfo=function(){return t.getMappingInfo()};t.prototype.getSelector=function(){return{}};t.prototype.isValidForDependencyMap=function(){return false};t.prototype.getVariantReference=function(){return undefined};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/CompVariant", ["sap/base/util/restricted/_pick","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/Variant","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(t,e,r,i,n,a,s){"use strict";var o=r.extend("sap.ui.fl.apply._internal.flexObjects.CompVariant",{metadata:{properties:{persisted:{type:"boolean",defaultValue:true},persistencyKey:{type:"string"}},aggregations:{revertData:{type:"sap.ui.base.ManagedObject",multiple:true,singularName:"revertData"},changes:{type:"sap.ui.base.ManagedObject",multiple:true}}},constructor:function(...t){const[e]=t;r.apply(this,t);this.setFileType("variant");if(e.favorite!==undefined){this.setFavorite(!!e.favorite)}else if(e.layer===n.VENDOR||e.layer===n.CUSTOMER_BASE){this.setFavorite(true)}}});o.STANDARD_VARIANT_ID="*standard*";o.getMappingInfo=function(){return Object.assign(r.getMappingInfo(),{persistencyKey:"selector.persistencyKey",standardVariant:"standardVariant",variantId:"variantId"})};o.prototype.getMappingInfo=function(){return o.getMappingInfo()};function p(t){var e=a.getInstanceOrUndef();var r=e&&e.getUserId();return!r||!t||r.toUpperCase()===t.toUpperCase()}function u(t,e,r){if(e){return t===e}else if(t===n.USER){return true}var s=a.getInstanceOrUndef();if(i.isSapUiLayerParameterProvided()){e=i.getCurrentLayer()}else{e||=s.isPublicLayerAvailable()?n.PUBLIC:n.CUSTOMER}var o=t===e;var u=s.isKeyUser()||p(r);return o&&u}function c(t){return!t||s.getCurrentLanguage()===t}function l(t,e){var r=a.getInstanceOrUndef();if(!r){return true}if(!t||!e){return true}var i=r.getSystem();var n=r.getClient();return i===t&&e===n}o.prototype.getPackage=function(){return this.getFlexObjectMetadata().packageName};o.prototype.isVariant=function(){return true};o.prototype.isRenameEnabled=function(t){return!this.getStandardVariant()&&this.isEditEnabled(t)&&c(this.getSupportInformation().originalLanguage)};o.prototype.isEditEnabled=function(t){var e=t&&i.isDeveloperLayer(t);var r=l(this.getSupportInformation().sourceSystem,this.getSupportInformation().sourceClient);var n=u(this.getLayer(),t,this.getOwnerId());return e||r&&n};o.prototype.isDeleteEnabled=function(t){var e=l(this.getSupportInformation().sourceSystem,this.getSupportInformation().sourceClient);return e&&u(this.getLayer(),t,this.getOwnerId())&&!this.getStandardVariant()};o.prototype.storeFavorite=function(t){if(t!==this.getFavorite()){this.setState(e.LifecycleState.DIRTY);this.setFavorite(t)}};o.prototype.storeVisible=function(t){if(t!==this.getVisible()){this.setState(e.LifecycleState.DIRTY);this.setVisible(t)}};o.prototype.getOwnerId=function(){return this.getSupportInformation().user||""};o.prototype.storeContent=function(t){this.setContent(t)};o.prototype.storeExecuteOnSelection=function(t){if(t!==this.getExecuteOnSelection()){this.setState(e.LifecycleState.DIRTY);this.setExecuteOnSelection(t)}};o.prototype.storeName=function(t){this.setName(t)};o.prototype.storeContexts=function(t){this.setContexts(t);this.setState(e.LifecycleState.DIRTY)};o.prototype.cloneFileContentWithNewId=function(...t){var e=r.prototype.cloneFileContentWithNewId.apply(this,t);e.variantId=e.fileName;return e};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/CompVariantRevertData", ["sap/ui/fl/apply/_internal/flexObjects/RevertData"],function(e){"use strict";return e.extend("sap.ui.fl.apply._internal.flexObjects.CompVariantRevertData",{metadata:{properties:{change:{type:"object"}}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/ControllerExtensionChange", ["sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(e){"use strict";var t=e.extend("sap.ui.fl.apply._internal.flexObjects.ControllerExtensionChange",{metadata:{properties:{controllerName:{type:"string"}}}});t.getMappingInfo=function(){return Object.assign(e.getMappingInfo(),{controllerName:"selector.controllerName"})};t.prototype.getMappingInfo=function(){return t.getMappingInfo()};t.prototype.getSelector=function(){return{controllerName:this.getControllerName()}};t.prototype.getVariantReference=function(){return undefined};t.prototype.isValidForDependencyMap=function(){return false};t.prototype.setInitialApplyState=function(){};t.prototype.getModuleName=function(){return this.getFlexObjectMetadata().moduleName};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/FlVariant", ["sap/ui/core/Core","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/Variant"],function(e,t,n){"use strict";var i=n.extend("sap.ui.fl.apply._internal.flexObjects.FlVariant",{metadata:{properties:{variantReference:{type:"string"},variantManagementReference:{type:"string"}}},constructor:function(...e){let[i,a]=e;if(typeof i!=="string"&&i!==undefined){a=i;i=a&&a.id}a.fileType="ctrl_variant";if(a.favorite===undefined){a.favorite=true}n.apply(this,e);if(!this.getName()&&a.content&&a.content.title){this.setName(a.content.title)}var r=this.getSupportInformation();if(this.getId()===this.getVariantManagementReference()){this.setStandardVariant(true);if(!r.user){r.user=t.DEFAULT_AUTHOR;this.setSupportInformation(r)}}}});i.getMappingInfo=function(){return Object.assign(n.getMappingInfo(),{variantReference:"variantReference",variantManagementReference:"variantManagementReference"})};i.prototype.getMappingInfo=function(){return i.getMappingInfo()};i.prototype.cloneFileContentWithNewId=function(...e){var t=n.prototype.cloneFileContentWithNewId.apply(this,e);return t};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/FlexObject", ["sap/base/util/deepClone","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/util/restricted/_omit","sap/ui/base/ManagedObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(t,e,a,n,r,o,i,s,p,u){"use strict";var c=o.extend("sap.ui.fl.apply._internal.flexObjects.FlexObject",{metadata:{properties:{adaptationId:{type:"string"},state:{type:"string",defaultValue:i.LifecycleState.NEW},fileType:{type:"string",defaultValue:"change"},layer:{type:"string"},flexObjectMetadata:{type:"object",defaultValue:{}},supportInformation:{type:"object",defaultValue:{}},content:{type:"any",defaultValue:{}},texts:{type:"object",defaultValue:{}}}},constructor:function(...t){o.apply(this,t);var e=this.getFlexObjectMetadata();var a=e.reference;if(a){e.reference=a.endsWith(".Component")?a.replace(/\.Component(?!.*\.Component)/,""):a;e.namespace||=u.createNamespace({reference:a},this.getFileType());e.projectId||=a}this.setFlexObjectMetadata(e);var n=this.getSupportInformation();n.originalLanguage||=u.getCurrentLanguage();this.setSupportInformation(n)}});c.getMappingInfo=function(){return Object.assign({},{"flexObjectMetadata.changeType":"changeType","flexObjectMetadata.reference":"reference","flexObjectMetadata.namespace":"namespace","flexObjectMetadata.creation":"creation","flexObjectMetadata.projectId":"projectId","flexObjectMetadata.packageName":"packageName","flexObjectMetadata.moduleName":"moduleName","supportInformation.generator":"support.generator","supportInformation.clonedFrom":"support.clonedFrom","supportInformation.service":"support.service","supportInformation.sourceSystem":"sourceSystem","supportInformation.sourceClient":"sourceClient","supportInformation.user":"support.user","supportInformation.sapui5Version":"support.sapui5Version","supportInformation.sourceChangeFileName":"support.sourceChangeFileName","supportInformation.compositeCommand":"support.compositeCommand","supportInformation.command":"support.command","supportInformation.oDataInformation":"oDataInformation","supportInformation.originalLanguage":"originalLanguage",adaptationId:"adaptationId",layer:"layer",fileType:"fileType",id:"fileName",content:"content",texts:"texts"})};c.prototype.getMappingInfo=function(){return c.getMappingInfo()};c.prototype.setContent=function(t,e){this.setProperty("content",t);if(!e){this.setState(i.LifecycleState.DIRTY)}return this};c.prototype.getFlexObjectMetadata=function(){return Object.assign({},this.getProperty("flexObjectMetadata"))};c.prototype.getSupportInformation=function(){return Object.assign({},this.getProperty("supportInformation"))};function f(t,e){if(!Object.values(i.LifecycleState).includes(t)){return false}if(e===i.LifecycleState.NEW&&t===i.LifecycleState.DIRTY){return false}return true}c.prototype.setState=function(t){var e=this.getState();if(e!==t&&f(t,e)){this._sPreviousState=e;this.setProperty("state",t)}return this};c.prototype.isPersisted=function(){return this.getState()===i.LifecycleState.PERSISTED};c.prototype.markForDeletion=function(){this.setState(i.LifecycleState.DELETED)};c.prototype.restorePreviousState=function(){if(this._sPreviousState){this.setState(this._sPreviousState);delete this._sPreviousState}};c.prototype.isChangeFromOtherSystem=function(){var t=this.getSupportInformation().sourceSystem;var e=this.getSupportInformation().sourceClient;if(!t||!e){return false}var a=p.getInstanceOrUndef();if(!a){return true}var n=a.getSystem();var r=a.getClient();if(!n||!r){return false}return t!==n||e!==r};c.prototype.getNamespace=function(){return this.getFlexObjectMetadata().namespace};c.prototype.getChangeType=function(){return this.getFlexObjectMetadata().changeType};c.prototype.isUserDependent=function(){return this.getLayer()===s.USER};c.prototype.getText=function(t){var e=this.getTexts()[t]||{};return e.value||""};c.prototype.setText=function(t,e,a,n){var r=Object.assign({},this.getTexts());var o={value:e};if(a){o.type=a}r[t]=Object.assign({},r[t],o);this.setTexts(r);if(!n){this.setState(i.LifecycleState.DIRTY)}return this};c.prototype.setRequest=function(t){this._sRequest=t};c.prototype.getRequest=function(){return this._sRequest||""};c.prototype.getDefinition=function(){return this.convertToFileContent()};c.prototype.getCreation=function(){return this.getFlexObjectMetadata().creation};c.prototype.setCreation=function(t){var e=this.getFlexObjectMetadata();e.creation=t;this.setFlexObjectMetadata(e)};function l(t){return t.length?t.charAt(0).toUpperCase()+t.slice(1):t}function g(t){return typeof this[t]==="function"?this[t].bind(this):function(){throw new Error(`${t} is not a valid mutator`)}}function h(e){var a=e.split(".");a[0]=l(a[0]);var r=a.shift();var o=g.call(this,`get${r}`);var i=g.call(this,`set${r}`);return{getValue(){var e=t(o());if(a.length>0){return n.get(a,e)}return e},setValue:function(e){var r=t(o());if(a.length>0){n.set(a,e,r)}else{r=e}i(r);return this}.bind(this)}}c.prototype.convertToFileContent=function(){var t={};Object.entries(this.getMappingInfo()).forEach(function(e){var a=h.call(this,e[0]).getValue();if(a!==undefined){n.set(e[1],a,t)}}.bind(this));return t};function y(t,e){var a=h.call(this,t);var n=a.getValue();if(n!==e){a.setValue(e)}}c.mapFileContent=function(e,n){var r=Object.values(n);var o={};var i=function(t,e,s){var p=s?`${s}.${t}`:t;var u=r.indexOf(p);if(u>=0){var c=Object.keys(n)[u];o[c]=e}else if(a(e)){Object.entries(e).forEach(function(t){i(t[0],t[1],p)})}};Object.entries(t(e,15)).forEach(function(t){i(t[0],t[1])});return o};c.prototype.update=function(t){var e=r(t,["fileName"]);var a=c.mapFileContent(e,this.getMappingInfo());Object.entries(a).forEach(function(t){y.call(this,t[0],t[1])}.bind(this))};c.prototype.setResponse=function(t){if(!t||e(t)){return}this.update(t);this.setState(i.LifecycleState.PERSISTED)};c.prototype.cloneFileContentWithNewId=function(){var t=this.convertToFileContent();t.fileName=u.createDefaultFileName(t.fileName.split("_").pop());t.support.clonedFrom=this.getId();return t};return c});
/* !
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory", ["sap/base/util/restricted/_pick","sap/base/util/ObjectPath","sap/ui/core/Core","sap/ui/fl/apply/_internal/flexObjects/AppDescriptorChange","sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/ControllerExtensionChange","sap/ui/fl/apply/_internal/flexObjects/FlexObject","sap/ui/fl/apply/_internal/flexObjects/FlVariant","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/UIChange","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,t,n,a,r,i,c,o,s,l,p,u,f,O){"use strict";var g={BASE_FLEX_OBJECT:c,COMP_VARIANT_OBJECT:r,FL_VARIANT_OBJECT:o,CONTROLLER_EXTENSION:i,APP_DESCRIPTOR_CHANGE:a,UI_CHANGE:l};function y(e){if(e.fileType==="variant"){return g.COMP_VARIANT_OBJECT}else if(e.fileType==="ctrl_variant"){return g.FL_VARIANT_OBJECT}else if(e.changeType==="codeExt"){return g.CONTROLLER_EXTENSION}else if(e.appDescriptorChange){return g.APP_DESCRIPTOR_CHANGE}return g.UI_CHANGE}function C(e){const t=e.type||e.changeType;const n=e.fileName||e.id||O.createDefaultFileName(t);const a=e.user||(!f.isDeveloperLayer(e.layer)?p.getInstanceOrUndef()&&p.getInstanceOrUndef().getUserId():undefined);return{id:n,adaptationId:e.adaptationId,layer:e.layer,content:e.content,texts:e.texts,supportInformation:{service:e.ODataService,oDataInformation:e.oDataInformation,command:e.command,compositeCommand:e.compositeCommand,generator:e.generator,sourceChangeFileName:e.support&&e.support.sourceChangeFileName,sourceSystem:e.sourceSystem,sourceClient:e.sourceClient,originalLanguage:e.originalLanguage,user:a},flexObjectMetadata:{changeType:t,reference:e.reference,packageName:e.packageName,projectId:e.projectId}}}var m={};m.createFromFileContent=function(e,n,a){var r=Object.assign({},e);var i=n||y(r);if(!i){throw new Error("Unknown file type")}r.support=Object.assign({generator:"FlexObjectFactory.createFromFileContent"},r.support||{});var o=i.getMappingInfo();var l=c.mapFileContent(r,o);var p=Object.entries(l).reduce(function(e,n){t.set(n[0].split("."),n[1],e);return e},{});var u=new i(p);if(a){u.setProperty("state",s.LifecycleState.PERSISTED)}return u};m.createUIChange=function(e){e.packageName||="$TMP";var t=C(e);t.layer||=e.isUserDependent?u.USER:f.getCurrentLayer();t.selector=e.selector;t.jsOnly=e.jsOnly;t.variantReference=e.variantReference;t.isChangeOnStandardVariant=e.isChangeOnStandardVariant;t.fileType=e.fileType||"change";return new l(t)};m.createAppDescriptorChange=function(e){e.compositeCommand||=e.support&&e.support.compositeCommand;var t=C(e);return new a(t)};m.createControllerExtensionChange=function(e){e.generator||="FlexObjectFactory.createControllerExtensionChange";e.changeType="codeExt";e.content={codeRef:e.codeRef};var t=C(e);t.flexObjectMetadata.moduleName=e.moduleName;t.controllerName=e.controllerName;return new i(t)};m.createFlVariant=function(e){e.generator||="FlexObjectFactory.createFlVariant";var t=C(e);t.variantManagementReference=e.variantManagementReference;t.variantReference=e.variantReference;t.contexts=e.contexts;t.texts={variantName:{value:e.variantName,type:"XFLD"}};return new o(t)};m.createCompVariant=function(e){e.generator||="FlexObjectFactory.createCompVariant";e.user=t.get("support.user",e);var n=C(e);n.variantId=e.variantId||n.id;n.contexts=e.contexts;n.favorite=e.favorite;n.persisted=e.persisted;n.persistencyKey=e.persistencyKey||t.get("selector.persistencyKey",e);if(e.layer===u.VENDOR||e.layer===u.CUSTOMER_BASE){n.favorite=true}if(e.executeOnSelection!==undefined){n.executeOnSelection=e.executeOnSelection}else{n.executeOnSelection=n.content&&(n.content.executeOnSelect||n.content.executeOnSelection)}return new r(n)};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/RevertData", ["sap/ui/base/ManagedObject"],function(e){"use strict";return e.extend("sap.ui.fl.apply._internal.flexObjects.RevertData",{metadata:{properties:{type:{type:"string"},content:{type:"object"}}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/States", [],function(){"use strict";return{LifecycleState:{NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"},ApplyState:{INITIAL:"initial",APPLYING:"applying",REVERTING:"reverting",REVERT_FINISHED:"revert finished",APPLY_SUCCESSFUL:"apply successful",APPLY_FAILED:"apply failed"},Operations:{APPLY:"apply",REVERT:"revert"}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/UIChange", ["sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/ui/fl/apply/_internal/flexObjects/FlexObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/Utils"],function(e,t,s,r,o){"use strict";var n=s.extend("sap.ui.fl.apply._internal.flexObjects.UIChange",{metadata:{properties:{selector:{type:"object",defaultValue:{}},dependentSelectors:{type:"object",defaultValue:{}},applyState:{type:"string",defaultValue:r.ApplyState.NEW},jsOnly:{type:"boolean"},variantReference:{type:"string"},isChangeOnStandardVariant:{type:"boolean"},savedToVariant:{type:"boolean"},revertData:{type:"any",defaultValue:null}},aggregations:{},associations:{},events:{}},constructor:function(...e){s.apply(this,e);this._oChangeProcessingPromises={};this.setInitialApplyState()}});n.getMappingInfo=function(){return Object.assign(s.getMappingInfo(),{selector:"selector",dependentSelectors:"dependentSelector",jsOnly:"jsOnly",variantReference:"variantReference",isChangeOnStandardVariant:"isChangeOnStandardVariant"})};n.prototype.getMappingInfo=function(){return n.getMappingInfo()};n.prototype.setQueuedForRevert=function(){if(this._aQueuedProcesses[this._aQueuedProcesses.length-1]!==r.Operations.REVERT){this._aQueuedProcesses.unshift(r.Operations.REVERT)}};n.prototype.isQueuedForRevert=function(){return this._aQueuedProcesses.indexOf(r.Operations.REVERT)>-1};n.prototype.setQueuedForApply=function(){if(this._aQueuedProcesses[this._aQueuedProcesses.length-1]!==r.Operations.APPLY){this._aQueuedProcesses.unshift(r.Operations.APPLY)}};n.prototype.isQueuedForApply=function(){return this._aQueuedProcesses.indexOf(r.Operations.APPLY)>-1};n.prototype.setInitialApplyState=function(){this._aQueuedProcesses=[];delete this._ignoreOnce;this.setApplyState(r.ApplyState.INITIAL);this._oChangeProcessedPromise={};this._oChangeProcessedPromise.promise=new Promise(function(e){this._oChangeProcessedPromise.resolveFunction={resolve:e}}.bind(this))};n.prototype.isInInitialState=function(){return this._aQueuedProcesses.length===0&&this.getApplyState()===r.ApplyState.INITIAL};n.prototype.isValidForDependencyMap=function(){return!!this.getSelector().id};n.prototype.startApplying=function(){this.setApplyState(r.ApplyState.APPLYING)};n.prototype.markFinished=function(e,t){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(r.Operations.APPLY,e);var s=t!==false?r.ApplyState.APPLY_SUCCESSFUL:r.ApplyState.APPLY_FAILED;this.setApplyState(s)};n.prototype.markSuccessful=function(e){this.markFinished(e,true)};n.prototype.markFailed=function(e){this.markFinished(e,false)};n.prototype.startReverting=function(){this.setApplyState(r.ApplyState.REVERTING)};n.prototype.markRevertFinished=function(e){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(r.Operations.REVERT,e);this.setApplyState(r.ApplyState.REVERT_FINISHED)};n.prototype.hasApplyProcessStarted=function(){return this.getApplyState()===r.ApplyState.APPLYING};n.prototype.isSuccessfullyApplied=function(){return this.getApplyState()===r.ApplyState.APPLY_SUCCESSFUL};n.prototype.hasApplyProcessFailed=function(){return this.getApplyState()===r.ApplyState.APPLY_FAILED};n.prototype.isApplyProcessFinished=function(){return this.isSuccessfullyApplied()||this.hasApplyProcessFailed()};n.prototype.hasRevertProcessStarted=function(){return this.getApplyState()===r.ApplyState.REVERTING};n.prototype.isRevertProcessFinished=function(){return this.getApplyState()===r.ApplyState.REVERT_FINISHED};n.prototype.isCurrentProcessFinished=function(){return this._aQueuedProcesses.length===0&&this.getApplyState()!==r.ApplyState.INITIAL};n.prototype.addChangeProcessingPromise=function(e){if(!this._oChangeProcessingPromises[e]){this._oChangeProcessingPromises[e]={};this._oChangeProcessingPromises[e].promise=new Promise(function(t){this._oChangeProcessingPromises[e].resolveFunction={resolve:t}}.bind(this))}return this._oChangeProcessingPromises[e].promise};n.prototype.addChangeProcessingPromises=function(){var e=[];if(this.getApplyState()===r.ApplyState.INITIAL&&this._oChangeProcessedPromise){e.push(this._oChangeProcessedPromise.promise)}this._aQueuedProcesses.forEach(function(t){e.push(this.addChangeProcessingPromise(t))},this);return e};n.prototype.addPromiseForApplyProcessing=function(){return this.addChangeProcessingPromise(r.Operations.APPLY)};n.prototype._resolveChangeProcessingPromiseWithError=function(e,t){if(this._oChangeProcessingPromises[e]){this._oChangeProcessingPromises[e].resolveFunction.resolve(t);delete this._oChangeProcessingPromises[e]}if(this._oChangeProcessedPromise){this._oChangeProcessedPromise.resolveFunction.resolve(t);this._oChangeProcessedPromise=null}};n.prototype.hasRevertData=function(){return this.getRevertData()!==null};n.prototype.resetRevertData=function(){this.setRevertData(null)};n.prototype.setDependentSelectors=function(e){this.setProperty("dependentSelectors",e);delete this._aDependentSelectorList};n.prototype.addDependentControl=function(t,s,r,o){if(!t){throw new Error("Parameter vControl is mandatory")}if(!s){throw new Error("Parameter sAlias is mandatory")}if(!r||e(r)){throw new Error("Parameter mPropertyBag is mandatory")}var n=Object.assign({},this.getDependentSelectors());if(n[s]){throw new Error(`Alias '${s}' already exists in the change.`)}var i=r.modifier;var a=r.appComponent;if(Array.isArray(t)){var p=[];t.forEach(function(e){p.push(i.getSelector(e,a,o))});n[s]=p}else{n[s]=i.getSelector(t,a,o)}this.setDependentSelectors(n);delete this._aDependentSelectorList};n.prototype.getDependentControl=function(e,t){var s=[];if(!e){throw new Error("Parameter sAlias is mandatory")}if(!t){throw new Error("Parameter mPropertyBag is mandatory")}var r=t.modifier;var o=t.appComponent;var n=this.getDependentSelectors()[e];if(Array.isArray(n)){n.forEach(function(e){s.push(r.bySelector(e,o,t.view))});return s}return r.bySelector(n,o,t.view)};n.prototype.getDependentSelectorList=function(){var e=[this.getSelector()];if(!this._aDependentSelectorList){if(!this.getOriginalSelector()){Object.entries(this.getDependentSelectors()).some(function(t){var s=t[1];if(!Array.isArray(s)){s=[s]}s.forEach(function(t){if(t&&o.indexOfObject(e,t)===-1){e.push(t)}})})}this._aDependentSelectorList=e}return this._aDependentSelectorList};n.prototype.getDependentControlSelectorList=function(){var e=this.getDependentSelectorList().concat();if(e.length>0){var t=this.getSelector();var s=o.indexOfObject(e,t);if(s>-1){e.splice(s,1)}}return e};n.prototype.getOriginalSelector=function(){return this.getDependentSelectors().originalSelector};n.prototype.setExtensionPointInfo=function(e){this._oExtensionPointInfo=e};n.prototype.getExtensionPointInfo=function(){if(t(this._oExtensionPointInfo)){return Object.assign({},this._oExtensionPointInfo)}return this._oExtensionPointInfo};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/UpdatableChange", ["sap/ui/fl/apply/_internal/flexObjects/UIChange"],function(e){"use strict";var t=e.extend("sap.ui.fl.apply._internal.flexObjects.UpdatableChange",{metadata:{aggregations:{revertInfo:{type:"sap.ui.base.ManagedObject",multiple:true,singularName:"revertInfo"}}}});t.getMappingInfo=function(){return Object.assign(e.getMappingInfo(),{})};t.prototype.popLatestRevertInfo=function(){var e=this.getRevertInfo().pop();this.removeRevertInfo(e);return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexObjects/Variant", ["sap/ui/fl/apply/_internal/flexObjects/FlexObject"],function(t){"use strict";var e=t.extend("sap.ui.fl.apply._internal.flexObjects.Variant",{metadata:{properties:{favorite:{type:"boolean",defaultValue:false},visible:{type:"boolean",defaultValue:true},executeOnSelection:{type:"boolean",defaultValue:false},standardVariant:{type:"boolean",defaultValue:false},contexts:{type:"object",defaultValue:{}},variantId:{type:"string"}}},constructor:function(...e){t.apply(this,e);if(!this.getVariantId()){this.setVariantId(this.getId())}}});e.getMappingInfo=function(){return Object.assign(t.getMappingInfo(),{favorite:"favorite",executeOnSelection:"executeOnSelection",contexts:"contexts"})};e.prototype.getMappingInfo=function(){return e.getMappingInfo()};e.prototype.getName=function(){return this.getText("variantName")};e.prototype.setName=function(t,e){this.setText("variantName",t,"XFLD",e)};e.prototype.hasContexts=function(){var t=this.getContexts();var e=Object.keys(t);return e.some(function(e){return t[e].length>0})};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/DataSelector", ["sap/base/util/merge","sap/base/util/ObjectPath","sap/ui/base/ManagedObject"],function(t,e,a){"use strict";var i=a.extend("sap.ui.fl.apply._internal.flexState.DataSelector",{metadata:{properties:{parentDataSelector:{type:"object"},cachedResult:{type:"any"},parameterKey:{type:"string"},initFunction:{type:"function"},executeFunction:{type:"function"},updateListeners:{type:"function[]",defaultValue:[]},checkInvalidation:{type:"function",defaultValue(){return true}}}},constructor:function(...t){a.apply(this,t);this._mInitialized={};if(this.getParameterKey()){this.setCachedResult({})}var e=this.getParentDataSelector();if(e){this.onParentSelectorUpdate=this.checkUpdate.bind(this);e.addUpdateListener(this.onParentSelectorUpdate)}}});const r="DataSelector_no_parameter";function n(t,e){const a=[];let i=t;do{a.unshift(i.getParameterKey()?e[i.getParameterKey()]:r);i=i.getParentDataSelector()}while(i);return a}i.prototype.addUpdateListener=function(t){var e=this.getUpdateListeners();if(!e.includes(t)){this.setUpdateListeners([].concat(e,t))}};i.prototype.removeUpdateListener=function(t){var e=this.getUpdateListeners();this.setUpdateListeners(e.filter(function(e){return e!==t}))};i.prototype.exit=function(){var t=this.getParentDataSelector();if(t){t.removeUpdateListener(this.onParentSelectorUpdate)}};i.prototype._getParameterizedCachedResult=function(t){const a=n(this,t);return e.get(a,this.getCachedResult())};i.prototype._setParameterizedCachedResult=function(a,i){const r=n(this,a);const s={};e.set(r,i,s);return this.setCachedResult(t({},this.getCachedResult(),s))};i.prototype._clearCache=function(t){if(t){this._setParameterizedCachedResult(t,null)}else{var e=!!this.getParameterKey();this.setCachedResult(e?{}:null)}};i.prototype.clearCachedResult=function(t){this._clearCache(t);this.getUpdateListeners().forEach(function(t){t()})};i.prototype.get=function(t){var e=this.getParameterKey();if(e&&!(t||{})[e]){throw new Error(`Parameter '${e}' is missing`)}var a=this._getParameterizedCachedResult(t);if(a!==null&&a!==undefined){return a}var i=this.getParentDataSelector();var r=i&&i.get(t);var n=(t||{})[e];if(!this._mInitialized[n]&&this.getInitFunction()){this.getInitFunction()(r,n);this._mInitialized[n]=true}var s=this.getExecuteFunction()(r,n);this._setParameterizedCachedResult(t,s);return s};i.prototype.checkUpdate=function(t){if(this.getCheckInvalidation()(t)===true){this._clearCache(t);this.getUpdateListeners().forEach(function(t){t()})}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/FlexState", ["sap/base/util/restricted/_omit","sap/base/util/Deferred","sap/base/util/each","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/Component","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/appDescriptorChanges/prepareAppDescriptorMap","sap/ui/fl/apply/_internal/flexState/changes/prepareChangesMap","sap/ui/fl/apply/_internal/flexState/compVariants/prepareCompVariantsMap","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexState/InitialPrepareFunctions","sap/ui/fl/apply/_internal/flexState/Loader","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/LayerUtils","sap/ui/fl/requireAsync"],function(e,n,t,a,r,i,c,s,o,f,p,u,l,m,g,d,h,v,x){"use strict";var b={};var O={};var R={};var j;var y={appDescriptorChanges:{prepareFunction:f,pathInResponse:[]},changes:{initialPreparationFunctionName:"uiChanges",prepareFunction:p,pathInResponse:["changes"]},variants:{initialPreparationFunctionName:"variants",pathInResponse:["variants","variantChanges","variantDependentControlChanges","variantManagementChanges"]},compVariants:{prepareFunction:u,pathInResponse:["comp.variants","comp.standardVariants","comp.defaultVariants","comp.changes"]}};var I={compVariants:{},flexObjects:{}};function C(e,n){var t={comp(){return Object.values(n).reduce(function(e,n){return e.concat(n)},[])},variants(){return n.map(function(e){var t=e.variantReference===e.variantManagementReference||n.some(function(n){return n.variantManagementReference===e.variantManagementReference&&n.fileName===e.variantReference});if(!t){return Object.assign({},e,{variantReference:e.variantManagementReference})}return e})}}[e];if(t){return t()}return Array.isArray(n)?n:[]}function D(e){var n=c.getComponentById(e.componentId);e.componentData||=n&&n.getComponentData()||{};e.manifest||=e.rawManifest||n&&n.getManifestObject()||{};e.reference||=d.getFlexReference(e)}function S(e){var n=[];t(e.changes,function(e,t){C(e,t).forEach(function(e){n.push(s.createFromFileContent(e,null,true))})});return n}function F(e,n){var t=y[e].initialPreparationFunctionName;var a=m[t];if(a){return a(n)}return undefined}function P(e,n,t){var a=F(e,n);if(a){V(t,a)}}var w=new l({id:"flexObjects",parameterKey:"reference",executeFunction(e,n){if(!O[n]){return[]}var t=O[n].runtimePersistence;return t.flexObjects.concat(t.runtimeOnlyData.flexObjects||[],I.flexObjects[n][O[n].componentId]||[])}});function _(e,n){if(!O[e]){throw new Error("State is not yet initialized")}if(!O[e].preparedMaps[n]){var t={unfilteredStorageResponse:O[e].unfilteredStorageResponse,storageResponse:O[e].storageResponse,componentId:O[e].componentId,componentData:O[e].componentData,reference:e,runtimePersistence:O[e].runtimePersistence};O[e].preparedMaps[n]=b.callPrepareFunction(n,t);P(n,t,e)}return O[e].preparedMaps[n]}function V(e,n){O[e]=a(O[e],n);w.checkUpdate({reference:e})}function M(e){return _(e,"appDescriptorChanges")}function k(e){return _(e,"changes")}function z(e){return _(e,"compVariants")}function N(e,n){var t={flexObjects:S(e),runtimeOnlyData:{flexObjects:[]}};Object.keys(y).forEach(function(r){var i=F(r,{storageResponse:e,externalData:n});if(i){t=a(t,i)}});return t}function U(e,n,a){var r=a.flexObjects.slice();var i=r.length;var c;var s=[];t(n.changes,function(e,n){C(e,n).forEach(function(e){s.push(e)})});O[e].runtimePersistence=Object.assign(a,{flexObjects:s.map(function(e){var n;var t=r.find(function(t,a){n=a;return t.getId()===e.fileName});if(t){r.splice(n,1);if(t.getState()!==o.LifecycleState.PERSISTED){t.setResponse(e);c=true}return t}throw new Error("Error updating runtime persistence: storage returned unknown flex objects")})});if(i!==O[e].runtimePersistence.flexObjects.length){c=true}return c}function E(e){var n=e.reference;var t=false;if(!O[n].componentData){var a=c.getComponentById(e.componentId);O[n].componentData=a?a.getComponentData():e.componentData;t=true}if(!O[n].storageResponse){O[n].storageResponse=L(n,O[n].unfilteredStorageResponse);delete O[n].runtimePersistence;t=true}if(!r.get(["flexObjects",n,e.componentId],I)){r.set(["flexObjects",n,e.componentId],[],I)}if(!O[n].runtimePersistence){O[n].runtimePersistence=N(O[n].storageResponse,I.flexObjects[n][e.componentId]||[]);t=true}if(t){w.checkUpdate({reference:n})}}function L(e,n){const i=a({},n);const c=i.changes;if(v.isLayerFilteringRequired(e)){const n=h.getByReference(e);t(y,function(e,t){t.pathInResponse.forEach(function(e){const t=r.get(e,c).filter(function(e){return!e.layer||!v.isOverLayer(e.layer,n.maxLayer)});r.set(e,t,c)})})}return i}async function A(e){const n=await g.loadFlexData(e);q(e.reference,n);return n}function B(e,n){O[n.reference]=a({},{unfilteredStorageResponse:e,preparedMaps:{},componentId:n.componentId,componentData:n.componentData,partialFlexState:n.partialFlexState});Object.freeze(O[n.reference].storageResponse);Object.freeze(O[n.reference].unfilteredStorageResponse)}function q(e,n){var t=n&&n.changes||{};var a=h.getByReference(e);if(a===null){a={}}if(t.info!==undefined){a=Object.assign(a,t.info)}h.setByReference(a,e)}function K(e){var n=O[e.reference];if(n.partialFlexState===true&&e.partialFlexState!==true){n.partialFlexState=false;e.partialFlexData=a({},n.unfilteredStorageResponse.changes);e.reInitialize=true}return e}function T(e){var n=O[e.reference].componentId;if(!e.reInitialize&&n!==e.componentId){e.reInitialize=true}return e}function $(){return x("sap/ui/fl/ChangePersistenceFactory").then(function(e){j=e}).catch(function(e){i.error(`Error loading modules: ${e.message}`)})}b.initialize=async function(e){const t=a({},e);D(t);const r=t.reference;const i=R[r];const c=new n;R[r]=c;await $();if(i){await i.promise;K(t);T(t);if(t.reInitialize){const e=await A(t);B(e,t)}}else{const e=await A(t);B(e,t)}E(t);c.resolve()};b.isInitialized=function(e){var n=e.reference?e.reference:d.getFlexReferenceForControl(e.control);return!!O[n]};b.clearAndInitialize=function(e){D(e);b.clearState(e.reference);return b.initialize(e)};b.update=async function(e){D(e);var t=e.reference;var a=O[t].runtimePersistence;if(j&&(j._instanceCache||{}).hasOwnProperty(t)){j._instanceCache[t].removeDirtyChanges()}const r=R[t].promise;const i=new n;R[t]=i;await r;const c=await A(e);B(c,e);O[t].storageResponse=L(t,O[t].unfilteredStorageResponse);const s=U(t,O[t].storageResponse,a);if(s){w.checkUpdate({reference:t})}i.resolve()};function G(e){switch(e.fileType){case"change":if(e.selector&&e.selector.persistencyKey){return["comp","changes"]}if(e.variantReference){return"variantDependentControlChanges"}return"changes";case"ctrl_variant":return"variants";case"ctrl_variant_change":return"variantChanges";case"ctrl_variant_management_change":return"variantManagementChanges";case"variant":return["comp","variants"];default:return""}}b.updateStorageResponse=function(e,n){n.forEach(n=>{if(n.type==="ui2"){O[e].unfilteredStorageResponse.changes.ui2personalization=n.newData}else{const t=G(n.flexObject);const a=n.flexObject.fileName;const i=r.get(t,O[e].unfilteredStorageResponse.changes);const c=r.get(t,O[e].storageResponse.changes);switch(n.type){case"add":i.push(n.flexObject);c.push(n.flexObject);break;case"delete":c.splice(c.findIndex(e=>e.fileName===a),1);i.splice(i.findIndex(e=>e.fileName===a),1);break;case"update":c.splice(c.findIndex(e=>e.fileName===a),1,n.flexObject);i.splice(i.findIndex(e=>e.fileName===a),1,n.flexObject);break;default:}}})};b.clearState=function(e){if(e){delete O[e];delete R[e];w.clearCachedResult({reference:e});if(j&&(j._instanceCache||{}).hasOwnProperty(e)){j._instanceCache[e].removeDirtyChanges()}}else{O={};R={};w.clearCachedResult()}};b.setInitialNonFlCompVariantData=function(e,n,t,a,r){I.compVariants[e]||={};I.compVariants[e][n]={};I.compVariants[e][n].standardVariant=t;I.compVariants[e][n].variants=a;I.compVariants[e][n].controlId=r};b.getInitialNonFlCompVariantData=function(e){return I.compVariants[e]};b.resetInitialNonFlCompVariantData=function(e){delete I.compVariants[e]};b.addRuntimeSteadyObject=function(e,n,t){I.flexObjects[e]||={};I.flexObjects[e][n]||=[];I.flexObjects[e][n].push(t);w.checkUpdate({reference:e})};b.clearRuntimeSteadyObjects=function(e,n){if(I.flexObjects[e]){delete I.flexObjects[e][n];w.clearCachedResult({reference:e})}};b.rebuildFilteredResponse=function(e){if(O[e]){O[e].preparedMaps={};O[e].storageResponse=L(e,O[e].unfilteredStorageResponse);O[e].runtimePersistence=N(O[e].storageResponse,I.flexObjects[e][O[e].componentId]||[]);w.checkUpdate({reference:e})}};b.addDirtyFlexObject=function(e,n){if(O[e]){O[e].runtimePersistence.flexObjects.push(n);w.checkUpdate({reference:e})}};b.addDirtyFlexObjects=function(e,n){if(n.length>0&&O[e]){O[e].runtimePersistence.flexObjects=O[e].runtimePersistence.flexObjects.concat(n);w.checkUpdate({reference:e})}};b.removeDirtyFlexObject=function(e,n){if(O[e]){var t=O[e].runtimePersistence.flexObjects;var a=t.indexOf(n);t.splice(a,1);w.checkUpdate({reference:e})}};b.removeDirtyFlexObjects=function(e,n){if(O[e]&&n.length>0){var t=O[e].runtimePersistence.flexObjects;n.forEach(function(e){var n=t.indexOf(e);t.splice(n,1)});w.checkUpdate({reference:e})}};b.getFlexObjectsDataSelector=function(){return w};b.getUIChanges=function(e){return k(e).changes};b.getAppDescriptorChanges=function(e){return M(e).appDescriptorChanges};b.getUI2Personalization=function(e){return a({},O[e].unfilteredStorageResponse.changes.ui2personalization)};b.getCompVariantsMap=function(e){return z(e)};b.callPrepareFunction=function(e,n){return y[e].prepareFunction(n)};b.getStorageResponse=function(e){if(R[e]){return R[e].promise.then(function(){return O[e].unfilteredStorageResponse})}return Promise.resolve()};b.getComponentData=function(e){return O[e]&&O[e].componentData};return b});
/*
 * ! OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/InitialPrepareFunctions", ["sap/base/util/includes","sap/ui/core/Lib","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/Layer"],function(e,a,n,r,t){"use strict";var i={};i.variants=function(i){var s=(i.storageResponse.changes.variants||[]).map(function(e){return e.fileName}).concat(i.externalData.filter(function(e){return e.getFileType()==="ctrl_variant"}).map(function(e){return e.getId()}));var c={runtimeOnlyData:{flexObjects:[]}};var u=i.storageResponse.changes.variants;var l=i.storageResponse.changes.variantDependentControlChanges.filter(function(e){var a=e.isChangeOnStandardVariant;if(a!==undefined&&a!==null){return a}return!/id_\d{13}_\d*_flVariant/.test(e.variantReference)});var f=u.concat(l);f.forEach(function(i){var u=i.fileType==="ctrl_variant"?i.variantManagementReference:i.variantReference;if(u&&!e(s,u)){var l=a.getResourceBundleFor("sap.ui.fl");var f=r.createFlVariant({id:u,variantManagementReference:u,variantName:l.getText("STANDARD_VARIANT_TITLE"),layer:t.BASE,user:n.DEFAULT_AUTHOR,reference:i.reference});c.runtimeOnlyData.flexObjects.push(f);s.push(u)}});return c};i.uiChanges=function(){};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/Loader", ["sap/base/util/ObjectPath","sap/ui/base/ManagedObject","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/Storage"],function(e,t,n,a){"use strict";function r(e){if(typeof e==="string"){e={id:e}}e.idIsLocal=true;return e}function i(e,t){if(e){[t.changes,t.variantChanges,t.variantDependentControlChanges,t.variantManagementChanges].flat().filter(e=>e.selector&&!e.selector.idIsLocal).forEach(function(e){e.selector=r(e.selector);if(e.dependentSelector){Object.keys(e.dependentSelector).forEach(t=>{const n=e.dependentSelector[t];if(Array.isArray(n)){e.dependentSelector[t]=n.map(r)}else{e.dependentSelector[t]=r(n)}})}})}return t}function s(n){["appDescriptorChanges","annotationChanges","changes","comp.changes","comp.changes","comp.defaultVariants","comp.standardVariants","variants","variantChanges","variantDependentControlChanges","variantManagementChanges"].forEach(function(a){const r=e.get(a,n);if(r){e.set(a,r.filter(e=>{let n;try{n=new t(e.fileName)}catch(e){return false}n.destroy();return true}),n)}});return n}function c(e){return e&&!!n.getOvpEntry(e)}function o(e){return{changes:e,cacheKey:e.cacheKey}}function l(e){if(e&&e.startupParameters&&Array.isArray(e.startupParameters.hcpApplicationId)){return e.startupParameters.hcpApplicationId[0]}}return{loadFlexData(e){var t=n.getBaseComponentNameFromManifest(e.manifest);if(e.partialFlexData){return a.completeFlexData({reference:e.reference,componentName:t,partialFlexData:e.partialFlexData}).then(o)}var r=e.reInitialize?undefined:n.getCacheKeyFromAsyncHints(e.reference,e.asyncHints);return a.loadFlexData({preview:n.getPreviewSectionFromAsyncHints(e.asyncHints),reference:e.reference,componentName:t,cacheKey:r,siteId:l(e.componentData),appDescriptor:e.manifest.getRawJson?e.manifest.getRawJson():e.manifest,version:e.version,allContexts:e.allContexts,adaptationId:e.adaptationId}).then(s.bind()).then(i.bind(undefined,c(e.manifest))).then(o)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/ManifestUtils", ["sap/ui/fl/Utils"],function(e){"use strict";function t(e,t){if(e&&e.requests&&Array.isArray(e.requests)){return e.requests.find(function(e){return e.name==="sap.ui.fl.changes"&&(!t||e.reference===t)})}}function r(e){var t=e.manifest;var r=e.componentData||{};if(r.startupParameters){if(Array.isArray(r.startupParameters["sap-app-id"])){return r.startupParameters["sap-app-id"][0]}}var a=t.getEntry?t.getEntry("sap.ui5"):t["sap.ui5"];if(a){if(a.appVariantId){return a.appVariantId}if(a.componentName){return a.componentName}}return n(t)}function n(e){if(e){var t="${pro"+"ject.art"+"ifactId}";var r=e.getEntry?e.getEntry("sap.app"):e["sap.app"];var n=r&&r.id;if(n===t){if(e.getComponentName){return e.getComponentName()}if(e.name){return e.name}}return n}throw new Error("No Manifest received, descriptor changes are not possible")}var a={getAppIdFromManifest:n,getFlexReference:r,getFlexReferenceForControl(t){var n=e.getAppComponentForControl(t);return n&&r({manifest:n.getManifestObject(),componentData:n.getComponentData()})},getFlexReferenceForSelector(e){if(e.appId){return e.appId}return a.getFlexReferenceForControl(e.appComponent||e)},getOvpEntry(e){return e.getEntry?e.getEntry("sap.ovp"):e["sap.ovp"]},getCacheKeyFromAsyncHints(e,r){var n=t(r,e);if(n){return n.cachebusterToken||"<NO CHANGES>"}},getPreviewSectionFromAsyncHints(e){var r=t(e);if(r){return r.preview}},getChangeManifestFromAsyncHints(e){var r=t(e);if(r){return false}return true},getBaseComponentNameFromManifest(e){var t=e.getEntry?e.getEntry("sap.ui5"):e["sap.ui5"];return t&&t.componentName||n(e)},isFlexExtensionPointHandlingEnabled(t){var r=e.getAppComponentForControl(t);return!!(r&&r.getManifestEntry("sap.ui5")&&r.getManifestEntry("sap.ui5").flexExtensionPointEnabled)}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/appDescriptorChanges/prepareAppDescriptorMap", ["sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory"],function(e){"use strict";return function(n){var r=n.storageResponse.changes.appDescriptorChanges||[];var t=r.map(function(n){return e.createFromFileContent(n)});return{appDescriptorChanges:t}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler", ["sap/base/util/includes","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(e,n,t){"use strict";var d="sap.ui.fl:PendingChange";var i={};function c(e,t){return n.getControlIdBySelector(e,t)}function s(e){return{changeObject:e,dependencies:[],controlsDependencies:[],dependentIds:[]}}function o(e,n,t){r(t,n,e);a(t,n)}function a(n,t){if(!e(n.aChanges,t)){n.aChanges.push(t)}}function r(n,t,d){n.mChanges[d]||=[];if(!e(n.mChanges[d],t)){n.mChanges[d].push(t)}}function p(e,n,t){var d=e.getSelector();if(d){if(d.id){o(c(d,n),e,t)}else{a(t,e)}}return t.aChanges}function f(e,n){return e.some(function(e){return e.id===n.id&&e.idIsLocal===n.idIsLocal})}function u(e,n,t,d,i,s,o){var a=t.getDependentSelectorList();n.some(function(n){if(f(a,n)){var r=c(n,i);var p=d&&s.indexOf(e)<s.indexOf(t);if(p){l(t,e,r,o,true)}else{l(e,t,r,o)}return true}})}function h(e,n,t,d){if(e.isValidForDependencyMap()){var i=e.getDependentSelectorList();g(e,i,n,d);var c=t.indexOf(e);var s=c<t.length-1;var o=t.slice();o.splice(c,1);o.reverse().forEach(function(c){if(c.isValidForDependencyMap()){u(e,i,c,s,n,t,d)}})}}function g(e,n,t,d){if(n.length){var i=n.map(function(e){return c(e,t)});if(!d.mDependencies[e.getId()]){d.mDependencies[e.getId()]=s(e)}d.mDependencies[e.getId()].controlsDependencies=i;i.forEach(function(n){d.mControlsWithDependencies[n]||=[];d.mControlsWithDependencies[n].push(e.getId())})}}function l(n,t,d,i,c){if(m(n,t,d,i,c)){i.mDependencies[n.getId()].dependencies.push(t.getId());if(!e(i.mDependencies[n.getId()].dependentIds,d)){i.mDependencies[n.getId()].dependentIds.push(d)}if(!i.mDependentChangesOnMe[t.getId()]){i.mDependentChangesOnMe[t.getId()]=[]}i.mDependentChangesOnMe[t.getId()].push(n.getId())}}function m(n,t,d,i,c){var s=!c&&e(i.mDependencies[n.getId()].dependentIds,d);var o=false;if(i.mDependentChangesOnMe[t.getId()]){i.mDependentChangesOnMe[t.getId()].some(function(t){o=e(i.mDependencies[n.getId()].dependencies,t);return o})}return!s&&!o}function D(e,n){var c=[];var s=[];var o=[];if(e.dependencyRemovedInLastBatch[n]){e.dependencyRemovedInLastBatch[n].forEach(function(n){var t=e.mDependencies[n];if(t&&t.dependencies.length===0&&!(t.controlsDependencies&&t.controlsDependencies.length)){s.push(n);c.push(t.changeObject.getId());if(t[d]){o.push(function(){return t[d]()})}}})}return t.execPromiseQueueSequentially(o).then(function(n,t,d){delete e.dependencyRemovedInLastBatch[d];t.forEach(function(n){delete e.mDependencies[n]});n.forEach(function(n){i.resolveDependenciesForChange(e,n,d)});return!!n.length}.bind(undefined,c,s,n))}i.createEmptyDependencyMap=function(){return{aChanges:[],mChanges:{},mDependencies:{},mDependentChangesOnMe:{},mControlsWithDependencies:{},dependencyRemovedInLastBatch:{}}};i.addChangeAndUpdateDependencies=function(e,n,t){var d=p(e,n,t);h(e,n,d,t)};i.insertChange=function(e,n,t){var d=n&&n.aChanges&&n.aChanges.indexOf(t);if(d>-1){n.aChanges.splice(d+1,0,e)}};i.addRuntimeChangeAndUpdateDependencies=function(e,n,t,d){var i=p(e,n,t);h(e,n,i,d)};i.processDependentQueue=function(e,n,t){return D(e,t).then(function(t,d){if(d){return i.processDependentQueue(e,n,t)}}.bind(undefined,t))};i.addChangeApplyCallbackToDependency=function(e,n,t){e.mDependencies[n][d]=t};i.removeControlsDependencies=function(n,t){var d=n.mControlsWithDependencies[t];if(d){d.forEach(function(d){var i=n.mDependencies[d];if(i&&i.controlsDependencies&&i.controlsDependencies.length){var c=i.controlsDependencies.indexOf(t);if(c>-1){i.controlsDependencies.splice(c,1);delete n.mControlsWithDependencies[t];n.dependencyRemovedInLastBatch[t]||=[];if(!e(n.dependencyRemovedInLastBatch[t],d)){n.dependencyRemovedInLastBatch[t].push(d)}}}});delete n.mControlsWithDependencies[t]}};i.resolveDependenciesForChange=function(n,t,d){var i=n.mDependentChangesOnMe[t];if(i){i.forEach(function(i){var c=n.mDependencies[i];var s=c?c.dependencies.indexOf(t):-1;if(s>-1){c.dependencies.splice(s,1);n.dependencyRemovedInLastBatch[d]||=[];if(!e(n.dependencyRemovedInLastBatch[d],i)){n.dependencyRemovedInLastBatch[d].push(i)}}});delete n.mDependentChangesOnMe[t]}};i.removeChangeFromMap=function(e,n){Object.keys(e.mChanges).some(function(t){var d=e.mChanges[t];var i=d.map(function(e){return e.getId()}).indexOf(n);if(i!==-1){d.splice(i,1);return true}});var t=e.aChanges.map(function(e){return e.getId()}).indexOf(n);if(t!==-1){e.aChanges.splice(t,1)}};i.removeChangeFromDependencies=function(e,n,t){i.resolveDependenciesForChange(e,n,t);delete e.mDependencies[n]};i.getOpenDependentChangesForControl=function(e,t,d){var i=[];Object.keys(e.mDependencies).forEach(function(c){e.mDependencies[c].changeObject.getDependentSelectorList().forEach(function(s){if(n.getControlIdBySelector(s,d)===t){i.push(e.mDependencies[c].changeObject)}})});return i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/changes/prepareChangesMap", [],function(){"use strict";return function(){}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger", ["sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/compVariants/Utils","sap/base/Log"],function(e,t,n,a){"use strict";var i={addFavorite(e){e.setFavorite(true)},removeFavorite(e){e.setFavorite(false)},updateVariant(e,t){var n=t.getContent();if(n.executeOnSelection!==undefined){e.setExecuteOnSelection(n.executeOnSelection)}if(n.favorite!==undefined){e.setFavorite(n.favorite)}if(n.contexts){e.setContexts(n.contexts)}if(n.visible!==undefined){e.setVisible(n.visible)}if(n.variantContent){e.setContent(n.variantContent,true)}var a=t.getText("variantName");if(a){e.setName(a,true)}},standardVariant(e,t){e.setExecuteOnSelection(t.getContent().executeOnSelect)}};function r(e){var t={};e.changes.forEach(function(e){var n=e.getSelector().variantId||e.getContent().key;t[n]||=[];t[n].push(e)});return t}function o(e,t){a.error(`No change handler for change with the ID '${t.getId()}' and type '${t.getChangeType()}' defined.\n\t\t\tThe variant '${e.getId()}'was not modified'`)}function d(n,a){var i={fileName:a.fileName,variantId:a.id||e.STANDARD_VARIANT_ID,persisted:a.persisted,content:a.content||{},texts:{variantName:{value:a.name||""}},selector:{persistencyKey:n}};if(a.favorite!==undefined){i.favorite=a.favorite}if(a.executeOnSelection!==undefined){i.executeOnSelection=a.executeOnSelection}if(a.adaptationId!==undefined){i.adaptationId=a.adaptationId}return t.createCompVariant(i)}function f(e,t){var n=i[t.getChangeType()]||o;n(e,t);e.addChange(t)}function s(e,t){var n=t.getVariantId();if(e[n]){e[n].forEach(function(e){f(t,e)})}}return{merge(e,t,a){var i=t.nonPersistedVariants.concat(t.variants);var o=r(t);var f;i.forEach(function(e){if(e.getContent()&&e.getContent().standardvariant){f=e}});if(!f){f=d(e,a)}else{i=i.filter(function(e){return!e.getContent()||!e.getContent().standardvariant})}i.forEach(s.bind(undefined,o));i=i.filter(function(e){var n=e.getVisible();if(!n){var a=e.getId();delete o[a];delete t.byId[a]}return n});f.setFavorite(true);f.setStandardVariant(true);t.byId[f.getVariantId()]=f;var c=t.standardVariantChange;if(c){o[f.getVariantId()]=o[f.getVariantId()]||[];o[f.getVariantId()].push(c);o[f.getVariantId()].sort(function(e,t){if(e.getCreation()<t.getCreation()){return-1}if(e.getCreation()>t.getCreation()){return 1}return 0})}s(o,f);t.standardVariant=f;const u=n.getDefaultVariantId(t);i.some(e=>{if(!e.getFavorite()&&e.getId()===u){e.setFavorite(true)}});return{standardVariant:f,variants:i}},createVariant(e,t){return d(e,t)},applyChangeOnVariant:f}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/compVariants/Utils", [],function(){"use strict";var e={};e.getPersistencyKey=e=>{if(e){var t=e.getVariantManagement&&e.getVariantManagement()||e;if(t.getPersonalizableControlPersistencyKey){return t.getPersonalizableControlPersistencyKey()}return t.getPersistencyKey&&t.getPersistencyKey()}return undefined};e.getDefaultVariantId=e=>{const t=e.defaultVariants;const n=[...t].reverse().find(t=>{if(t?.getContent().defaultVariantName==="*standard*"){return true}return e.variants.some(e=>t?.getContent().defaultVariantName===e.getId())});return n?.getContent().defaultVariantName||""};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/compVariants/prepareCompVariantsMap", ["sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/UpdatableChange","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger"],function(e,a,n,t){"use strict";function r(e,a){e[a]||={byId:{},variants:[],nonPersistedVariants:[],changes:[],defaultVariants:[],standardVariantChange:undefined,standardVariant:undefined};return e[a]}function i(e,a,n,i){n||=[];var s=r(e,a);s.controlId=i;s.nonPersistedVariants.forEach(function(e){delete s.byId[e.getId()]});s.nonPersistedVariants=n.map(function(e){var n=Object.assign({id:e.id,persisted:false},e);n=t.createVariant(a,n);s.byId[e.id]=n;return n});return s}function s(t,i,s){var d=t[i].map(function(t){var r;if(i==="variants"){r=e.createCompVariant(t)}else{r=e.createFromFileContent(t,n)}r.setState(a.LifecycleState.PERSISTED);return r});d.forEach(function(e){var a=e.getPersistencyKey?e.getPersistencyKey():e.getSelector().persistencyKey;r(s,a).byId[e.getId()]=e;switch(i){case"standardVariants":r(s,a).standardVariantChange=e;break;default:r(s,a)[i].push(e)}})}return function(e){var a={};a._getOrCreate=r.bind(undefined,a);a._initialize=i.bind(undefined,a);if(e.storageResponse.changes.comp){["variants","changes","defaultVariants","standardVariants"].forEach(function(n){s(e.storageResponse.changes.comp,n,a)})}return a}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher", ["sap/base/util/restricted/_pick","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/changes/Reverter"],function(e,n,r){"use strict";function t(r){var t=n.getControlChangesForVariant(Object.assign(e(r,["vmReference","variantsMap","reference"]),{vReference:r.currentVReference}));var a=n.getControlChangesForVariant(Object.assign(e(r,["vmReference","variantsMap","reference"]),{vReference:r.newVReference}));var i=Object.keys(r.changesMap).reduce(function(e,n){return e.concat(r.changesMap[n])},[]);var s=i.map(function(e){return e.getId()});var c=t.reduce(function(e,n){var r=s.indexOf(n.getId());if(r>-1){e=e.concat(i[r])}return e},[]);var o=[];if(a.length>0){o=c.slice();c.some(function(e){if(a[0]&&e.getId()===a[0].getId()){a.shift();o.shift()}else{return true}})}else{o=c}var l={changesToBeReverted:o.reverse(),changesToBeApplied:a};return l}var a={switchVariant(e){return Promise.resolve().then(function(){e.changesMap=e.flexController._oChangePersistence.getChangesMapForComponent().mChanges;var a=t(e);return r.revertMultipleChanges(a.changesToBeReverted,e).then(e.flexController.applyVariantChanges.bind(e.flexController,a.changesToBeApplied,e.appComponent)).then(n.setCurrentVariant.bind(null,e))})}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState", ["sap/base/util/restricted/_omit","sap/base/util/restricted/_pick","sap/base/util/ObjectPath","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,t,n,r,a,i,c,f,s,u){"use strict";var o={};var l={};function g(e,t,r){var i=f.getComponentData(e);var c=n.get(["technicalParameters",a.VARIANT_TECHNICAL_PARAMETER],i)||[];var s=r.filter(e=>e.visible).map(e=>e.key);var u=s.find(e=>c.includes(e));if(u){return u}return t.slice().reverse().map(e=>e.getContent().defaultVariant).find(e=>s.includes(e))}function v(e,t,n){var r=(l[t]||{})[n];return{defaultVariant:n,currentVariant:r,variants:[],variantManagementChanges:e.filter(function(e){return e.getFileType()==="ctrl_variant_management_change"&&e.getSelector().id===n})}}function d(e,t){return e.find(e=>e.getId()===t)}function p(e,t){const n=[];let r=t;let a;do{a=d(e,r.getVariantReference());if(a){n.push(a);r=a}}while(a);return n.map(e=>e.getId())}function m(e,t){var n=p(e,t);return{instance:t,variantChanges:e.filter(function(e){return e.getFileType()==="ctrl_variant_change"&&e.getSelector().id===t.getId()}),controlChanges:e.filter(function(e){var r=e.isA("sap.ui.fl.apply._internal.flexObjects.UIChange");if(!r){return false}var a=e.getVariantReference()===t.getId();var i=n.indexOf(e.getVariantReference())>-1;var c=s.compareAgainstCurrentLayer(e.getLayer(),t.getLayer())===-1;return a||i&&c}),key:t.getId(),title:t.getName(),layer:t.getLayer(),favorite:t.getFavorite(),executeOnSelect:t.getExecuteOnSelection(),visible:t.getVisible(),author:t.getSupportInformation().user,contexts:t.getContexts(),isStandardVariant:t.getStandardVariant()}}function V(e,t){switch(t.getChangeType()){case"setTitle":e.title=t.getText("title");break;case"setFavorite":e.favorite=t.getContent().favorite;break;case"setExecuteOnSelect":e.executeOnSelect=t.getContent().executeOnSelect;break;case"setVisible":e.visible=t.getContent().visible;break;case"setContexts":e.contexts=t.getContent().contexts;break;default:throw Error("Unknown ctrl_variant_change type")}}function h(e,t){var n=t.getContent().defaultVariant;e.variants.forEach(t=>{if(t.key===n&&t.visible){e.defaultVariant=n}})}function y(e){const t=e[0]?.getFlexObjectMetadata().reference;const r=e.filter(e=>e.getFileType()==="ctrl_variant");const a={};r.forEach(n=>{var r=n.getVariantManagementReference();a[r]||=v(e,t,r);a[r].variants.push(m(e,n))});e.filter(e=>e.getFileType()==="ctrl_variant_change").forEach(e=>{const n=C(a,e);if(n){V(n,e,t,a)}});const i=e.filter(e=>e.getFileType()==="ctrl_variant_management_change");i.forEach(e=>{const t=a[e.getSelector().id];if(t){h(t,e)}});Object.keys(a).forEach(e=>{const r=a[e];if(!r.currentVariant||!r.variants.some(e=>e.key===r.currentVariant)){const a=g(t,i,r.variants)||e;r.currentVariant=a;n.set([t,e],a,l)}r.variants.sort((e,t)=>{if(e.isStandardVariant){return-1}if(t.isStandardVariant){return 1}return e.title.toLowerCase()<t.title.toLowerCase()?-1:1});var c=r.variants.find(e=>e.key===r.currentVariant).controlChanges;r.modified=c.some(e=>!e.isPersisted()&&!e.getSavedToVariant());r.variants.some(e=>{if(!e.favorite&&e.key===r.defaultVariant){e.favorite=true;return true}return false})});return a}function C(e,t){var n;Object.values(e).some(function(e){return e.variants.some(function(e){if(t.getSelector().id===e.key){n=e;return true}return false})});return n}var R=new i({id:"variantManagementMap",parentDataSelector:f.getFlexObjectsDataSelector(),executeFunction:y});var b=new i({id:"variantManagements",parameterKey:"variantManagementReference",parentDataSelector:R,executeFunction(e,t){return e[t]}});var S=new i({id:"variants",parameterKey:"variantReference",parentDataSelector:b,executeFunction(e,t){return e.variants.find(function(e){return e.instance.getId()===t})}});var x=new i({id:"variantDependentFlexObjects",parentDataSelector:f.getFlexObjectsDataSelector(),executeFunction(e){return e.filter(function(e){const t=e.getVariantReference?.();const n=["ctrl_variant","ctrl_variant_change","ctrl_variant_management_change"].indexOf(e.getFileType())>-1;return n||t})}});o.getVariantDependentFlexObjects=function(e){return x.get({reference:e})};o.resetCurrentVariantReference=function(e){delete l[e];R.checkUpdate({reference:e})};o.getVariantManagementMap=function(){return R};o.addRuntimeSteadyObject=function(e,t,n){f.addRuntimeSteadyObject(e,t,n)};o.clearRuntimeSteadyObjects=function(e,t){f.clearRuntimeSteadyObjects(e,t)};o.getControlChangesForVariant=function(e){var t=[];var n=o.getVariant(e);if(n){t=n.controlChanges.filter(function(t){return e.includeDirtyChanges!==false||t.getState()===c.LifecycleState.PERSISTED})}return t};o.getVariantChangesForVariant=function(e){var t=o.getVariant(e);return t&&t.variantChanges||{}};o.getVariant=function(e){var t=e.vReference||b.get({variantManagementReference:e.vmReference,reference:e.reference}).defaultVariant;return S.get({variantManagementReference:e.vmReference,variantReference:t,reference:e.reference})};o.getCurrentVariantReference=function(e){var t=b.get({variantManagementReference:e.vmReference,reference:e.reference});return t.currentVariant};o.getAllCurrentVariants=function(e){const t=R.get({reference:e});return Object.entries(t).map(t=>{const n=o.getVariant({vmReference:t[0],vReference:t[1].currentVariant,reference:e}).instance;return n})};o.getVariantManagementReferences=function(e){var t=R.get({reference:e});return Object.keys(t)};o.getAllVariants=function(e){var t=R.get({reference:e});return Object.keys(t).reduce(function(e,n){return e.concat(t[n].variants)},[])};o.getInitialChanges=function(e){var t=R.get({reference:e.reference});return Object.keys(t).reduce(function(n,r){if(e.vmReference&&e.vmReference===r||!e.vmReference){var a=Object.assign({},e,{vmReference:r,vReference:t[r].currentVariant,includeDirtyChanges:false});return n.concat(o.getControlChangesForVariant(a))}return n},[])};o.setCurrentVariant=function(e){n.set([e.reference,e.vmReference],e.newVReference,l);R.checkUpdate({reference:e.reference})};o.waitForInitialVariantChanges=function(e){var t=o.getInitialChanges({vmReference:e.vmReference,reference:e.reference});var n=t.reduce(function(t,n){var a=n.getSelector();var i=r.bySelector(a,e.appComponent);if(i&&u.indexOfObject(t,{selector:i})===-1){t.push({selector:i})}return t},[]);return n.length?e.flexController.waitForChangesToBeApplied(n,true):Promise.resolve()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/ComponentLifecycleHooks", ["sap/base/Log","sap/ui/core/Lib","sap/ui/fl/apply/_internal/changes/descriptor/Applier","sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/variants/VariantModel","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement"],function(e,t,n,o,r,a,i,s,l,p,c,u,d,f){"use strict";var m={};m._componentInstantiationPromises=new WeakMap;var g={};function h(n,o){if(u.getUshellContainer()){return Promise.resolve(n)}var r=window.sessionStorage.getItem(`sap.ui.rta.restart.${c.CUSTOMER}`);if(r){var a=i.getFlexReferenceForControl(o);if(r!==a&&r!=="true"){e.error(`an application component was started which does not match the component for which the restart was triggered:\n\t\t\t\t\tTriggering component: ${r}\n\t\t\t\t\tStarted component: ${a}`);return Promise.resolve(n)}return new Promise(function(e,r){Promise.all([t.load({name:"sap.ui.rta"}),o.rootControlLoaded()]).then(function(){sap.ui.require(["sap/ui/rta/api/startKeyUserAdaptation"],function(t){t({rootControl:o});e(n)})}).catch(function(e){r(e)})})}return Promise.resolve(n)}function C(e){const t=i.getFlexReferenceForControl(e);const n=a.getStorageResponse(t);if(n.messagebundle&&!e.getModel("i18nFlexVendor")&&n.changes?.changes?.some(e=>e.layer===c.VENDOR)){e.setModel(new d(n.messagebundle),"i18nFlexVendor")}}function y(e){var t=p.createForControl(e);var n;return t._oChangePersistence.loadChangesMapForComponent(e).then(function(o){var a=r.applyAllChangesForControl.bind(r,o,e,t);a._bIsSapUiFlFlexControllerApplyChangesOnControl=true;e.addPropagationListener(a);n=m._createVariantModel(t,e);return n.initialize()}).then(function(){e.setModel(n,s.getVariantModelName());f.end("flexProcessing");return n}).then(function(t){return h(t,e)})}function M(e,t){if(u.isApplicationComponent(e)){var n=e.getId();a.rebuildFilteredResponse(i.getFlexReferenceForControl(e));var o=a.initialize({componentId:n,asyncHints:t.asyncHints}).then(y.bind(this,e)).then(C.bind(this,e)).then(function(){if(g[n]){g[n].forEach(function(t){var n=e.getModel(s.getVariantModelName());t.setModel(n,s.getVariantModelName())});delete g[n]}});m._componentInstantiationPromises.set(e,o);return o}else if(u.isEmbeddedComponent(e)){var r=u.getAppComponentForControl(e);if(m._componentInstantiationPromises.has(r)){return m._componentInstantiationPromises.get(r).then(function(){var t=r.getModel(s.getVariantModelName());e.setModel(t,s.getVariantModelName())})}g[r.getId()]=g[r.getId()]||[];g[r.getId()].push(e);return Promise.resolve()}return Promise.resolve()}function v(e,t){if(!u.isApplication(t)||!e.id){return Promise.resolve()}a.initialize({componentData:e.componentData||e.settings&&e.settings.componentData,asyncHints:e.asyncHints,manifest:t,componentId:e.id});return n.applyChangesIncludedInManifest(t,o.getRuntimeStrategy())}m._createVariantModel=function(e,t){return new l({},{flexController:e,appComponent:t})};m.instanceCreatedHook=function(...e){return M(...e)};m.componentLoadedHook=function(...e){return v(...e)};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/ControllerExtension", ["sap/ui/core/Component","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils","sap/base/Log"],function(e,n,t,o,r){"use strict";var i=function(){};function s(e){return e.getChangeType()==="codeExt"}function a(e,n){var t=n.getSelector().controllerName;return e===t}function u(e){if(e.length===0){return Promise.resolve([])}return new Promise(function(n){sap.ui.require(e,function(...e){n(e)},function(e){r.error("Code Extension not found",e.message);n([])})})}i.prototype.getControllerExtensions=function(i,f,c){if(c){if(!f){r.warning("No component ID for determining the anchor of the code extensions was passed.");return Promise.resolve([])}var p=e.getComponentById(f);var l=o.getAppComponentForControl(p);if(!l){r.warning("No application component for determining the anchor of the code extensions was identified.");return Promise.resolve([])}if(!o.isApplication(l.getManifestObject())){return Promise.resolve([])}var g=n.getFlexReferenceForControl(l);var m=t.getChangePersistenceForComponent(g);return m.getChangesForComponent().then(function(e){var n=e.filter(function(e){return s(e)&&a(i,e)}).map(function(e){return e.getModuleName()});return u(n)})}r.warning("Synchronous extensions are not supported via UI5 Flexibility");return[]};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/EventHistory", ["sap/ui/core/EventBus"],function(n){"use strict";var e=function(){};e._aEventIds=["ControlForPersonalizationRendered"];e._aUnsubscribedEventIds=[];e._oHistory={};e.start=function(){e._aEventIds.forEach(function(s){if(e._aUnsubscribedEventIds.indexOf(s)===-1){n.getInstance().subscribe("sap.ui",s,e.saveEvent);e._oHistory[s]=[]}})};e.saveEvent=function(n,s,t){var r={channelId:n,eventId:s,parameters:t.getId()};if(e._oHistory[s]){var i=e._oHistory[s].some(function(n){return n.channelId===r.channelId&&n.eventId===r.eventId&&n.parameters===r.parameters});if(!i){e._oHistory[s].push(r)}}};e.getHistoryAndStop=function(s){n.getInstance().unsubscribe("sap.ui",s,e.saveEvent);e._addUnsubscribedEvent(s);return e._oHistory[s]||[]};e._addUnsubscribedEvent=function(n){if(e._aUnsubscribedEventIds.indexOf(n)===-1){e._aUnsubscribedEventIds.push(n)}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/RegistrationDelegator", ["sap/ui/core/mvc/Controller","sap/ui/core/mvc/XMLView","sap/ui/core/Component","sap/ui/core/ExtensionPoint","sap/ui/fl/apply/_internal/changes/descriptor/Preprocessor","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/preprocessors/EventHistory","sap/ui/fl/apply/_internal/preprocessors/ComponentLifecycleHooks","sap/ui/fl/apply/_internal/DelegateMediator","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration","sap/ui/base/DesignTime","sap/ui/fl/apply/_internal/preprocessors/ControllerExtension","sap/ui/fl/apply/_internal/preprocessors/XmlPreprocessor"],function(e,n,r,i,s,a,t,o,l,p,c,f){"use strict";var u={};function d(){r._fnOnInstanceCreated=o.instanceCreatedHook}function g(){c.registerPredefinedChangeHandlers();c.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs()}function y(){r._fnLoadComponentCallback=o.componentLoadedHook}function P(){e.registerExtensionProvider("sap/ui/fl/apply/_internal/preprocessors/ControllerExtension")}function _(){if(n.registerPreprocessor){n.registerPreprocessor("viewxml","sap.ui.fl.apply._internal.preprocessors.XmlPreprocessor")}}function m(){t.start()}function C(){r._fnPreprocessManifest=s.preprocessManifest}function x(e){if(a.isFlexExtensionPointHandlingEnabled(e)){return"sap/ui/fl/apply/_internal/extensionPoint/Processor"}if(f.isDesignModeEnabled()){return"sap/ui/fl/write/_internal/extensionPoint/Processor"}return undefined}function D(){i.registerExtensionProvider(x)}function E(){p.registerDefaultDelegate({modelType:"sap.ui.model.odata.v4.ODataModel",delegate:"sap/ui/fl/write/_internal/delegates/ODataV4ReadDelegate",delegateType:l.types.READONLY})}u.registerAll=function(){m();g();y();P();d();_();C();D();E()};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/_internal/preprocessors/XmlPreprocessor", ["sap/base/util/merge","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils","sap/base/Log"],function(e,t,n,a,i,r,o,s,p,l){"use strict";var c=function(){};c.NOTAG="<NoTag>";c.process=async function(i,r){try{r.viewId=r.id;var o=n.getComponentById(r.componentId);if(!o){l.warning("View is generated without a component. Flexibility features are not possible.");return i}var c=p.getAppComponentForControl(o);if(!p.isApplication(c.getManifestObject())){return i}const f=e({appComponent:c,modifier:t,view:i},r);var u=s.getChangePersistenceForControl(c);const g=await u.getChangesForView(f);await a.applyAllChangesForXMLView(f,g);l.debug(`flex processing view ${r.id} finished`);return i}catch(e){var f=`view ${r.id}: ${e}`;l.info(f);return i}};function u(e,t){if(!t){return e}return e.concat("-",t)}function f(e){return e.replace(/(^W\/|")/g,"")}c.getCacheKey=async function(e){const t=n.getComponentById(e.componentId);const a=p.getAppComponentForControl(t);if(p.isVariantByStartupParameter(a)){return undefined}const s=o.getFlexReferenceForControl(a);let l=c.NOTAG;if(s){const e=await r.getStorageResponse(s);if(e?.cacheKey){l=f(e.cacheKey);const t=i.getAllCurrentVariants(s).filter(e=>!e.getStandardVariant()).map(e=>e.getId());l=u(l,t.join("-"))}}return l};return c},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/ControlVariantApplyAPI", ["sap/base/Log","sap/ui/core/Component","sap/ui/core/Element","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/Utils"],function(e,t,n,r,a){"use strict";var o="$FlexVariants";function i(e){var t=e.getModel(o);if(t){return Promise.resolve(t)}return new Promise(function(n){function r(){t=e.getModel(o);if(t){e.detachModelContextChange(r);n(t)}}e.attachModelContextChange(r)})}var l={getVariantModelName(){return o},getVariantModel(e){return i(e)},clearVariantParameterInURL(t){var n;var i=a.getAppComponentForControl(t.control);var l=i&&i.getModel(o);if(!l){e.error("Variant model could not be found on the provided control");return}if(t.control.isA("sap.ui.fl.variants.VariantManagement")){var c=l.getLocalId(t.control.getId(),i);var d=r.removeURLParameterForVariantManagement({model:l,vmReference:c});n=d.parameters}r.update({parameters:n||[],updateURL:true,updateHashEntry:!!l,model:l||{},silent:!l})},activateVariant(r){function i(t){e.error(t);return Promise.reject(t)}var l;if(typeof r.element==="string"){l=t.getComponentById(r.element);if(!(l instanceof t)){l=n.getElementById(r.element);if(!(l instanceof n)){return i(Error("No valid component or control found for the provided ID"))}}}else if(r.element instanceof t||r.element instanceof n){l=r.element}var c=a.getAppComponentForControl(l);if(!c){return i(Error("A valid variant management control or component (instance or ID) should be passed as parameter"))}var d=c.getModel(o);if(!d){return i(Error("No variant management model found for the passed control or application component"))}var p=d.getVariantManagementReference(r.variantReference).variantManagementReference;if(!p){return i(Error("A valid control or component, and a valid variant/ID combination are required"))}return d.waitForVMControlInit(p).then(function(){return d.updateCurrentVariant({variantManagementReference:p,newVariantReference:r.variantReference,appComponent:c})}).catch(function(t){e.error(t);throw t})},attachVariantApplied(e){var t=e.selector.id&&n.getElementById(e.selector.id)||e.selector;var r=a.getAppComponentForControl(t);i(r).then(function(n){n.attachVariantApplied({vmControlId:e.vmControlId,control:t,callback:e.callback,callAfterInitialVariant:e.callAfterInitialVariant})})},detachVariantApplied(e){var t=e.selector.id&&n.getElementById(e.selector.id)||e.selector;var r=a.getAppComponentForControl(t);i(r).then(function(n){n.detachVariantApplied(e.vmControlId,t.getId())})}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/DelegateMediatorAPI", ["sap/ui/fl/apply/_internal/DelegateMediator"],function(e){"use strict";var t={types:{READONLY:e.types.READONLY,WRITEONLY:e.types.WRITEONLY,COMPLETE:e.types.COMPLETE},registerDefaultDelegate(t){e.registerDefaultDelegate(t)},getDelegateForControl(t){return e.getDelegateForControl(t.control,t.modifier,t.modelType,t.supportsDefault)},getKnownDefaultDelegateLibraries(){return e.getKnownDefaultDelegateLibraries()},getRequiredLibrariesForDefaultDelegate(t){return e.getRequiredLibrariesForDefaultDelegate(t.delegateName,t.control,t.modelType)}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/apply/api/FlexRuntimeInfoAPI", ["sap/base/util/includes","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(e,t,r,n,o,l,i,s,a,c){"use strict";var u={isPersonalized(n){function o(e){t.error(e);return Promise.reject(e)}function l(e){return e.getFileType()==="change"}function s(t,n,o){var l=n.map(function(e){return e.id||e.getId()});var i=o.getSelector();var s=r.getControlIdBySelector(i,t);return e(l,s)}function u(t,r){return Array.isArray(t)&&t.length>0?e(t,r.getChangeType()):true}if(!n.selectors||n.selectors.length===0){return o("At least one control ID has to be provided as a parameter")}const p=n.selectors[0].appComponent||c.getAppComponentForControl(n.selectors[0]);if(!p){return o("App Component could not be determined")}const f=i.getChangePersistenceForControl(p);return f.getChangesForComponent({currentLayer:a.USER,includeCtrlVariants:true}).then(function(e){return e.filter(l).filter(s.bind(this,p,n.selectors)).filter(u.bind(this,n.changeTypes)).length>0}.bind(this))},waitForChanges(e){var t;var r;if(e.element){t=[{selector:e.element}];r=e.element}else if(e.selectors){t=e.selectors.map(function(e){return{selector:e}});[r]=e.selectors}else if(e.complexSelectors){t=e.complexSelectors;r=e.complexSelectors[0].selector}return s.createForSelector(r).waitForChangesToBeApplied(t)},isFlexSupported(e){return!!c.getAppComponentForControl(e.element)},hasVariantManagement(e){return n.belongsToVariantManagement(e.element)},getFlexReference(e){return o.getFlexReferenceForControl(e.element)},getConfiguredFlexServices(){return l.getFlexibilityServices()}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/AddIFrame", ["sap/ui/fl/changeHandler/common/revertAddedControls","sap/ui/fl/changeHandler/common/getTargetAggregationIndex","sap/ui/fl/changeHandler/common/createIFrame","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t,n,r){"use strict";var a={};a.applyChange=function(e,r,a){var o=a.modifier;var i=e.getContent();var g=a.view;var c=i.targetAggregation;var s;var f;return Promise.resolve().then(o.findAggregation.bind(o,r,c)).then(function(n){if(!n){throw new Error(`The given Aggregation is not available in the given control: ${o.getId(r)}`)}return t(e,r,a)}).then(function(t){s=t;return n(e,a,i.selector)}).then(function(e){f=e;return o.insertAggregation(r,c,f,s,g)}).then(function(){e.setRevertData([o.getId(f)])})};a.revertChange=e;a.completeChangeContent=function(e,t,n){var r=n.modifier;var a=n.appComponent;["targetAggregation","baseId","url"].forEach(function(e){if(!Object.hasOwn(t.content,e)){throw new Error(`Attribute missing from the change specific content '${e}'`)}});var o=Object.assign({},t.content);o.selector=r.getSelector(o.baseId,a);e.setContent(o)};a.getChangeVisualizationInfo=function(e){return{affectedControls:[e.getContent().selector]}};a.getCondenserInfo=function(e){var t=e.getContent();return{classification:r.Create,uniqueKey:"iFrame",affectedControl:t.selector,targetContainer:e.getSelector(),targetAggregation:t.targetAggregation,setTargetIndex(e,t){e.getContent().index=t},getTargetIndex(e){return e.getContent().index},update(e,t){Object.assign(e.getContent(),t)}}};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/AddXML", ["sap/ui/fl/changeHandler/BaseAddXml"],function(e){"use strict";var t={};t.applyChange=function(t,n,r){var g=t.getContent();var a={aggregationName:g.targetAggregation,index:g.index};return e.applyChange(t,n,r,a)};t.revertChange=e.revertChange;t.completeChangeContent=function(t,n){var r={};if(n.targetAggregation){r.targetAggregation=n.targetAggregation}else{e._throwMissingAttributeError("targetAggregation")}if(n.index!==undefined){r.index=n.index}else{e._throwMissingAttributeError("index")}e.completeChangeContent(t,n,r)};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/AddXMLAtExtensionPoint", ["sap/ui/fl/changeHandler/BaseAddXml","sap/ui/fl/write/api/ExtensionPointRegistryAPI"],function(e,n){"use strict";var t={};function i(e){var n=e.index;if(e.referencedExtensionPoint){n+=i(e.referencedExtensionPoint)}return n}t.applyChange=function(t,r,o){var a=o.view;var s=o.modifier;var d=o.viewId||s.getId(a);var u=t.getSelector();var f;return Promise.resolve().then(function(){var e=t.getExtensionPointInfo&&t.getExtensionPointInfo();if(!e){return s.getExtensionPointInfo(u.name,a)}return e}).then(function(n){f=n;if(!f){throw new Error(`AddXMLAtExtensionPoint-Error: Either no Extension-Point found by name '${u&&u.name}' or multiple Extension-Points available with the given name in the view (view.id='${d}'). Multiple Extension-points with the same name in one view are not supported!`)}(f.defaultContent||[]).forEach(function(e){if(e){s.destroy(e)}});f.defaultContent=[];f.index=i(f);if(s.targets==="xmlTree"){f.skipAdjustIndex=true}return e.applyChange(t,r,o,f)}).then(function(e){if(f.ready){f.ready(e)}n.addCreatedControlsToExtensionPointInfo({name:u.name,viewId:d,createdControlsIds:e.map(e=>s.getId(e))});return true})};t.revertChange=e.revertChange;t.completeChangeContent=function(n,t){e.completeChangeContent(n,t)};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/Base", ["sap/base/util/LoaderExtensions"],function(e){"use strict";var t={setTextInChange(e,t,n,r){e.texts||={};e.texts[t]||={};e.texts[t].value=n;e.texts[t].type=r},instantiateFragment(t,n){var r=t.getFlexObjectMetadata();var a=r.moduleName;if(!a){return Promise.reject(new Error("The module name of the fragment is not set. This should happen in the backend"))}var o=n.viewId?`${n.viewId}--`:"";var i=r.projectId||"";var s=t.getExtensionPointInfo&&t.getExtensionPointInfo()&&t.getExtensionPointInfo().fragmentId||"";var u=i&&s?".":"";var v=o+i+u+s;var d=n.modifier;var m=n.view;return Promise.resolve().then(function(){var t=e.loadResource(a,{dataType:"text"});return d.instantiateFragment(t,v,m).catch(function(e){throw new Error(`The following XML Fragment could not be instantiated: ${t} Reason: ${e.message}`)})})},markAsNotApplicable(e,t){var n={message:e};if(!t){throw n}return Promise.reject(n)}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/BaseAddViaDelegate", ["sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/changeHandler/Base","sap/ui/fl/requireAsync","sap/base/util/merge","sap/base/util/ObjectPath"],function(e,t,n,o,r){"use strict";function a(e){return typeof e==="function"}function i(e){if(e.modelType){return e.modelType}else if(e.oDataServiceVersion){return"sap.ui.model.odata.v2.ODataModel"}return undefined}const l={createAddViaDelegateChangeHandler(l){function c(e){return e+l.fieldSuffix}function d(e,t){if(a(l[t])){return!!l[t](e)}return!!l[t]}function s(e){return d(e,"skipCreateLabel")}function p(e){return d(e,"skipCreateLayout")}async function f(e,t){const o=t.modifier.bySelector(e.getSelector(),t.appComponent);const r=i(e.getContent());const c=await n("sap/ui/fl/apply/api/DelegateMediatorAPI");const d=await c.getDelegateForControl({control:o,modifier:t.modifier,modelType:r,supportsDefault:l.supportsDefault});const s=!a(d.instance.createLayout);return s||p(e.getSupportInformation().oDataInformation)}async function g(e,t,n){const r=o({},t);r.fieldSelector.id=c(r.fieldSelector.id);const a=await n.createControlForProperty(r);if(s(e)){return a}const i=t.modifier.getId(a.control);t.labelFor=i;const l=await n.createLabel(t);return{label:l,control:a.control,valueHelp:a.valueHelp}}async function u(e,t,n,i){const c=o({aggregationName:l.aggregationName,payload:t.payload||{},parentSelector:e.parentId},n);const d=t.instance;let s;if(a(d.createLayout)&&!p(i)){s=await d.createLayout(c)}if(r.get("control",s)){s.layoutControl=true;return s}return g(i,c,d)}return{async applyChange(e,r,a){const c=a.appComponent;const d=e.getContent();const s=e.getSupportInformation().oDataInformation;const p=d.newFieldSelector;const f={appComponent:a.appComponent,view:a.view,fieldSelector:p,bindingPath:d.bindingPath,modifier:a.modifier,element:r};if(a.modifier.bySelector(p,c,a.view)){await t.markAsNotApplicable(`Control to be created already exists:${p.id||p}`,true);return}const g={newFieldSelector:p};e.setRevertData(g);const C=i(d);const m=await n("sap/ui/fl/apply/api/DelegateMediatorAPI");const w=await m.getDelegateForControl({control:r,modifier:a.modifier,modelType:C,supportsDefault:l.supportsDefault});const y=await u(d,w,f,s);const I=o({},{control:r,innerControls:y,change:e},a);await l.addProperty(I);if(y.valueHelp){const t=a.modifier.getSelector(a.modifier.getId(y.valueHelp),c);const n=e.getRevertData();n.valueHelpSelector=t;e.setRevertData(n)}},async revertChange(e,t,n){const r=n.appComponent;const i=n.modifier;const c=e.getRevertData().newFieldSelector;const d=e.getRevertData().valueHelpSelector;const s=i.bySelector(c,r);const p=e.getDependentControl(l.parentAlias,n)||t;await i.removeAggregation(p,l.aggregationName,s);await i.destroy(s);if(d){const e=i.bySelector(d,r);await i.removeAggregation(p,"dependents",e);await i.destroy(e)}const f=o({},{control:t,change:e},n);if(a(l.revertAdditionalControls)){await l.revertAdditionalControls(f);e.resetRevertData()}},completeChangeContent(e,t,n){const o=n.appComponent;const r={};if(t.parentId){if(a(l.mapParentIdIntoChange)){l.mapParentIdIntoChange(e,t,n)}else{e.addDependentControl(t.parentId,l.parentAlias,n)}try{r.parentId=n.modifier.getSelector(t.parentId,o)}catch(e){}}else{throw new Error("mSpecificChangeInfo.parentId attribute required")}if(t.bindingPath){r.bindingPath=t.bindingPath}else{throw new Error("mSpecificChangeInfo.bindingPath attribute required")}if(t.newControlId){r.newFieldSelector=n.modifier.getSelector(t.newControlId,o)}else{throw new Error("mSpecificChangeInfo.newControlId attribute required")}if(t.index===undefined){throw new Error("mSpecificChangeInfo.targetIndex attribute required")}else{r.newFieldIndex=t.index}if(t.oDataServiceVersion){r.oDataServiceVersion=t.oDataServiceVersion}if(t.modelType&&l.supportsDefault){r.modelType=t.modelType}e.setContent(r)},getChangeVisualizationInfo(e){const t=e.getRevertData();if(t&&t.labelSelector){return{affectedControls:[t.labelSelector]}}return{affectedControls:[e.getContent().newFieldSelector]}},async getCondenserInfo(t,n){const o=await f(t,n);if(!o){return undefined}if(!t.getContent().newFieldSelector||!t.getContent().parentId||!l.aggregationName){return undefined}return{affectedControl:t.getContent().newFieldSelector,classification:e.Create,targetContainer:t.getContent().parentId,targetAggregation:l.aggregationName,setTargetIndex(e,t){const n=e.getContent();n.newFieldIndex=t;e.setContent(n)},getTargetIndex(e){return e.getContent().newFieldIndex}}}}}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/BaseAddXml", ["sap/ui/fl/changeHandler/Base","sap/base/util/LoaderExtensions","sap/ui/fl/changeHandler/common/revertAddedControls","sap/ui/fl/Utils"],function(e,t,r,n){"use strict";var a={};a.applyChange=function(r,o,i,u){var s=i.modifier;var c=i.view;var g=u.aggregationName;var f;var h=u.index;var l=[];var d=r.getFlexObjectMetadata().moduleName;var m;var v;var p=function(){var e=[];v.forEach(function(t,r){var n=function(){return Promise.resolve().then(s.insertAggregation.bind(s,o,g,t,h+r,c,u.skipAdjustIndex)).then(function(){l.push({id:s.getId(t),aggregationName:g})})};e.push(n)});return n.execPromiseQueueSequentially(e,true,true).then(function(){r.setRevertData(l);return v})};return Promise.resolve().then(s.findAggregation.bind(s,o,g)).then(function(e){f=e;if(!f){return Promise.reject(new Error(`The given Aggregation is not available in the given control: ${s.getId(o)}`))}return t.loadResource(d,{dataType:"text"})}).then(function(t){m=t;return e.instantiateFragment(r,i)}).then(function(e){v=e;var t=[];v.forEach(function(e,r){var n=function(){return Promise.resolve().then(s.validateType.bind(s,e,f,o,m,r)).then(function(e){if(!e){a._destroyArrayOfControls(v);return Promise.reject(new Error(`The content of the xml fragment does not match the type of the targetAggregation: ${f.type}`))}})};t.push(n)});return n.execPromiseQueueSequentially(t,true,true).then(p)})};a.revertChange=r;a._throwMissingAttributeError=function(e){throw new Error(`Attribute missing from the change specific content '${e}'`)};a._destroyArrayOfControls=function(e){e.forEach(function(e){if(e.destroy){e.destroy()}})};a.completeChangeContent=function(e,t,r){r||={};if(t.fragmentPath){r.fragmentPath=t.fragmentPath}else{a._throwMissingAttributeError("fragmentPath")}e.setContent(r);var n=e.getFlexObjectMetadata().reference.replace(/\.Component/g,"").replace(/\./g,"/");n+="/changes/";n+=r.fragmentPath;var o=e.getFlexObjectMetadata();o.moduleName=n;e.setFlexObjectMetadata(o)};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/BaseRename", ["sap/ui/fl/changeHandler/condenser/Classification"],function(e){"use strict";const t={createRenameChangeHandler(t){t.changePropertyName||="newText";return{async applyChange(e,r,n){const o=n.modifier;const a=t.propertyName;const i=e.getText(t.changePropertyName);if(i){const t=await o.getPropertyBindingOrProperty(r,a);e.setRevertData(t);await o.setPropertyBindingOrProperty(r,a,i)}},revertChange(e,r,n){const o=n.modifier;const a=t.propertyName;const i=e.getRevertData();if(i||i===""){o.setPropertyBindingOrProperty(r,a,i);e.resetRevertData();return}throw new Error("Change without sufficient information to be reverted. It probably didn't go through applyChange.")},async completeChangeContent(e,r,n){const o=t.changePropertyName;const a=t.translationTextType;const i=await n.modifier.bySelector(e.getSelector(),n.appComponent);e.setContent({originalControlType:n.modifier.getControlType(i)});if(typeof r.value==="string"){e.setText(o,r.value,a)}else if(typeof r.content.value==="string"){e.setText(o,r.content.value,a)}else{throw new Error("oSpecificChangeInfo.value attribute required")}},getCondenserInfo(r){return{affectedControl:r.getSelector(),classification:e.LastOneWins,uniqueKey:t.propertyName||t.changePropertyName}},getChangeVisualizationInfo(e){const r=e.getTexts()&&e.getTexts()[t.changePropertyName];return{descriptionPayload:{originalLabel:e.getRevertData(),newLabel:r&&r.value}}}}}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/BaseTreeModifier", ["sap/ui/core/util/reflection/BaseTreeModifier"],function(e){"use strict";return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/HideControl", ["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,t,n){"use strict";var r="visible";var i={};i.applyChange=function(e,t,n){var r=n.modifier;return Promise.resolve().then(r.getVisible.bind(r,t)).then(function(n){e.setRevertData({originalValue:n});r.setVisible(t,false)})};i.revertChange=function(t,n,r){var i=t.getRevertData();return Promise.resolve().then(function(){if(i){r.modifier.setVisible(n,i.originalValue);t.resetRevertData()}else{e.error("Attempt to revert an unapplied change.")}})};i.completeChangeContent=function(){};i.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.Reverse,uniqueKey:r}};i.getChangeVisualizationInfo=function(e,t){var r=e.getSelector();var i=n.bySelector(r,t);return{affectedControls:[r],displayControls:[i.getParent().getId()]}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/MoveControls", ["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";var r={};r.SOURCE_ALIAS="source";r.TARGET_ALIAS="target";r.MOVED_ELEMENTS_ALIAS="movedElements";function o(e,t,r,o){if(!e){throw new Error("No change instance")}var n=e.getContent();if(!n||!n.movedElements||n.movedElements.length===0){throw new Error("Change format invalid")}if(!n.source||!n.source.selector){throw new Error("No source supplied for move")}if(!n.target||!n.target.selector){throw new Error("No target supplied for move")}if(!t.bySelector(n.source.selector,o,r)){throw new Error("Move source parent not found")}if(!t.bySelector(n.target.selector,o,r)){throw new Error("Move target parent not found")}if(!n.source.selector.aggregation){throw new Error("No source aggregation supplied for move")}if(!n.target.selector.aggregation){throw new Error("No target aggregation supplied for move")}}async function n(e,t,r,o){if(!e.selector&&!e.id){throw new Error("Change format invalid - moveElements element has no id attribute")}if(typeof e.targetIndex!=="number"){throw new Error(`Missing targetIndex for element with id '${e.selector.id}' in movedElements supplied`)}const n=await t.bySelector(e.selector||e.id,r,o);if(!n){throw new Error(`Control to move was not found. Id: '${e.selector.id}'`)}return n}function a(e){if(!e.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required")}if(e.movedElements.length===0){throw new Error("MovedElements array is empty")}e.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute")}if(typeof e.sourceIndex!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number")}if(typeof e.targetIndex!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number")}})}async function g(e,t,r){delete t.source.publicAggregation;delete t.target.publicAggregation;const o=t.source.parent||await e.bySelector(t.source.id,r);const n=t.target.parent||await e.bySelector(t.target.id,r);var a=t.source.aggregation;var g=t.target.aggregation;var s={aggregation:t.source.aggregation,type:e.getControlType(o)};var i={aggregation:t.target.aggregation,type:e.getControlType(n)};var c={source:{id:o.getId(),aggregation:a,type:s.type,selector:e.getSelector(t.source.id,r,s)},target:{id:n.getId(),aggregation:g,type:i.type,selector:e.getSelector(t.target.id,r,i)},movedElements:t.movedElements};return c}r.applyChange=async function(e,t,r){const a=r.modifier;const g=r.view;const s=r.appComponent;const i=e.getContent();const c=[];let l=false;o(e,a,g,s);for(const e of i.movedElements){const t=await n(e,a,s,g);let o=a.getParent(t);let d=r.sourceAggregation||await a.getParentAggregationName(t,o);const u=await a.bySelector(i.target.selector,s,g);const m=r.targetAggregation||i.target.selector.aggregation;let f=await a.findIndexInParentAggregation(t);const v=e.targetIndex;if(f>-1){if(f===v&&d===m&&a.getParent(t)===u){f=e.sourceIndex;d=r.sourceAggregation||i.source.selector.aggregation;l=true;o=await a.bySelector(i.source.selector,s,g)||o}}if(f>-1){c.unshift({index:f,aggregation:d,sourceParent:a.getSelector(o,s)})}if(!l){await a.moveAggregation(o,d,u,m,t,v,g)}}e.setRevertData(c)};r.revertChange=async function(e,t,r){var a=r.modifier;var g=r.view;var s=r.appComponent;var i=e.getContent();o(e,a,g,s);let c=await a.bySelector(i.source.selector,s,g);const l=await a.bySelector(i.target.selector,s,g);let d=i.source.selector.aggregation;const u=i.target.selector.aggregation;const m=e.getRevertData();i.movedElements.reverse();let f=0;for(const e of i.movedElements){const t=await n(e,a,s,g);if(!t){throw new Error("Element to move not found")}let r=e.sourceIndex;if(m){var v=m[f];d=v.aggregation;r=v.index;c=await a.bySelector(v.sourceParent,s,g)||c}await a.moveAggregation(l,u,c,d,t,r,g);f++}e.resetRevertData()};r.completeChangeContent=async function(e,t,o){var n=o.modifier;var s=o.appComponent;a(t);const i=await g(n,t,s);var c={movedElements:[],source:{selector:i.source.selector},target:{selector:i.target.selector}};for(const t of i.movedElements){const a=t.element||await n.bySelector(t.id,s);c.movedElements.push({selector:n.getSelector(a,s),sourceIndex:t.sourceIndex,targetIndex:t.targetIndex});e.addDependentControl(i.source.id,r.SOURCE_ALIAS,o);e.addDependentControl(i.target.id,r.TARGET_ALIAS,o);e.addDependentControl(i.movedElements.map(function(e){return e.id}),r.MOVED_ELEMENTS_ALIAS,o)}e.setContent(c)};r.getCondenserInfo=function(e){var r=e.getContent();var o=e.getRevertData()[0];return{affectedControl:r.movedElements[0].selector,classification:t.Move,sourceContainer:o.sourceParent,targetContainer:r.target.selector,sourceIndex:o.index,sourceAggregation:o.aggregation,targetAggregation:r.target.selector.aggregation,setTargetIndex(e,t){var r=e.getContent();r.movedElements[0].targetIndex=t;e.setContent(r)},getTargetIndex(e){return e.getContent().movedElements[0].targetIndex},setIndexInRevertData(e,t){var r=e.getRevertData();r[0].index=t;e.setRevertData(r)}}};r.getChangeVisualizationInfo=function(e){var t=e.getContent();var r=e.getRevertData()[0];return{affectedControls:[t.movedElements[0].selector],dependentControls:[t.source.selector],descriptionPayload:{sourceContainer:r.sourceParent,targetContainer:t.target.selector}}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/MoveElements", [],function(){"use strict";var e={};e.CHANGE_TYPE="moveElements";function t(e,t,r,o){if(!e){throw new Error("No change instance")}var n=e.getContent();if(!n||!n.movedElements||n.movedElements.length===0){throw new Error("Change format invalid")}if(!e.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move")}if(!n.target||!n.target.selector){throw new Error("No target supplied for move")}if(!t.bySelector(n.target.selector,o,r)){throw new Error("Move target parent not found")}if(!n.target.selector.aggregation){throw new Error("No target aggregation supplied for move")}}async function r(e,t,r,o){if(!e.selector&&!e.id){throw new Error("Change format invalid - moveElements element has no id attribute")}if(typeof e.targetIndex!=="number"){throw new Error(`Missing targetIndex for element with id '${e.selector.id}' in movedElements supplied`)}return await t.bySelector(e.selector||e.id,r,o)}e.applyChange=async function(e,o,n){var a=n.modifier;var g=n.view;var i=n.appComponent;var s=e.getContent();t(e,a,g,i);const c=e.getSelector().aggregation;const l=s.target.selector.aggregation;const d=await a.bySelector(s.target.selector,i,g);for(const e of s.movedElements){const t=await r(e,a,i,g);if(!t){throw new Error("Element to move not found")}await a.moveAggregation(o,c,d,l,t,e.targetIndex,g)}};e.completeChangeContent=function(){throw new Error("Using deprecated change handler. Please consider using 'MoveControls' instead")};e.getSpecificChangeInfo=function(e,t){var r=t.source.parent||e.bySelector(t.source.id);var o=t.target.parent||e.bySelector(t.target.id);var n=t.source.aggregation;var a=t.target.aggregation;var g={source:{id:r.getId(),aggregation:n,type:e.getControlType(r)},target:{id:o.getId(),aggregation:a,type:e.getControlType(o)},movedElements:t.movedElements};return g};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/PropertyBindingChange", ["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";var n={};n.applyChange=function(e,t,n){var r=e.getContent();var i=r.property;var o=r.newBinding;var a=n.modifier;return Promise.resolve().then(a.getPropertyBindingOrProperty.bind(a,t,i)).then(function(n){e.setRevertData({originalValue:n});a.setPropertyBinding(t,i,o)})};n.revertChange=function(t,n,r){var i=t.getRevertData();if(i){var o=t.getContent();var a=o.property;var s=i.originalValue;var p=r.modifier;p.setPropertyBindingOrProperty(n,a,s);t.resetRevertData()}else{e.error("Attempt to revert an unapplied change.")}};n.completeChangeContent=function(e,t){if(!t.content){throw new Error("oSpecificChangeInfo attribute required")}e.setContent(t.content)};n.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.LastOneWins,uniqueKey:e.getContent().property}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/PropertyChange", ["sap/ui/fl/Utils","sap/ui/fl/changeHandler/condenser/Classification","sap/base/Log","sap/base/util/isPlainObject"],function(e,t,n,r){"use strict";var i={};function a(t){return e.isBinding(t)||r(t)}function o(e,t,n,r){try{if(a(n)){r.setPropertyBinding(e,t,n)}else{r.setProperty(e,t,n)}}catch(e){throw new Error(`Applying property changes failed: ${e}`)}}i.applyChange=function(e,t,n){var r=e.getContent();var i=r.property;var a=r.newValue;var s=n.modifier;return Promise.resolve().then(s.getPropertyBindingOrProperty.bind(s,t,i)).then(function(n){e.setRevertData({originalValue:n});o(t,i,a,s)})};i.revertChange=function(e,t,r){var i=e.getRevertData();if(i){var a=e.getContent();var s=a.property;var c=i.originalValue;var p=r.modifier;o(t,s,c,p);e.resetRevertData()}else{n.error("Attempt to revert an unapplied change.")}};i.completeChangeContent=function(e,t){if(!t.content){throw new Error("oSpecificChangeInfo attribute required")}e.setContent(t.content)};i.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.LastOneWins,uniqueKey:e.getContent().property}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/StashControl", ["sap/ui/fl/LayerUtils","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,t,n){"use strict";var a={};a.applyChange=async function(t,n,a){var i=a.modifier;const r=await i.getStashed(n);const o=await i.findIndexInParentAggregation(n);this.setChangeRevertData(t,r,o);if(e.isDeveloperLayer(t.getLayer())){return i.setStashed(n,true)}return i.setVisible(n,false)};a.revertChange=async function(t,n,a){const i=t.getRevertData();const r=a.modifier;if(e.isDeveloperLayer(t.getLayer())){const e=r.setStashed(n,i.originalValue,a.appComponent);if(e){const t=await r.findIndexInParentAggregation(e);if(t!==i.originalIndex){const t=r.getParent(e);const n=await r.getParentAggregationName(e);await r.moveAggregation(t,n,t,n,e,i.originalIndex)}}}r.setVisible(n,!i.originalValue);t.resetRevertData()};a.completeChangeContent=function(){};a.setChangeRevertData=function(e,t,n){e.setRevertData({originalValue:t,originalIndex:n})};a.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.Reverse,uniqueKey:"stashed"}};a.getChangeVisualizationInfo=function(e,t){const a=e.getSelector();const i=n.bySelector(a,t);return{affectedControls:[a],displayControls:[i.getParent().getId()]}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/UnhideControl", ["sap/base/Log","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";var n="visible";var r={};r.applyChange=function(e,t,r){var i=r.modifier;return Promise.resolve().then(i.getProperty.bind(i,t,n)).then(function(n){e.setRevertData({originalValue:n});r.modifier.setVisible(t,true)})};r.revertChange=function(t,n,r){var i=t.getRevertData();if(i){r.modifier.setVisible(n,i.originalValue);t.resetRevertData()}else{e.error("Attempt to revert an unapplied change.")}};r.completeChangeContent=function(){};r.getCondenserInfo=function(e){return{affectedControl:e.getSelector(),classification:t.Reverse,uniqueKey:n}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/UnstashControl", ["sap/ui/fl/changeHandler/condenser/Classification"],function(e){"use strict";var t={};t.applyChange=async function(e,t,n){const a=e.getContent();const o=n.modifier;const i=await o.getStashed(t);e.setRevertData({originalValue:i});const r=o.setStashed(t,false,n.appComponent)||t;if(a.parentAggregationName){const e=a.parentAggregationName;const t=o.getParent(r);await o.moveAggregation(t,e,t,e,r,a.index,n.view)}return r};t.revertChange=function(e,t,n){var a=e.getRevertData();n.modifier.setStashed(t,a.originalValue);e.resetRevertData()};t.completeChangeContent=function(e,t){if(t.content){e.setContent(t.content)}};t.getCondenserInfo=function(t){return{affectedControl:t.getSelector(),classification:e.Reverse,uniqueKey:"stashed"}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/UpdateIFrame", ["sap/base/util/extend","sap/ui/fl/changeHandler/condenser/Classification"],function(e,t){"use strict";var n={};const r=["width","height","url","useLegacyNavigation","_settings","advancedSettings"];function i(e,t){var n={};var i=[];r.forEach(function(r){var o=Promise.resolve().then(e.getProperty.bind(e,t,r)).then(function(e){n[r]=e});i.push(o)});return Promise.all(i).then(function(){return n})}function o(t,n,r){var i=e({_settings:r},r);return Promise.resolve().then(t.applySettings.bind(t,n,i))}n.applyChange=function(e,t,n){var r=n.modifier;return r.getControlMetadata(t).then(function(e){if(e.getName()!=="sap.ui.fl.util.IFrame"){return Promise.reject(new Error("UpdateIFrame only for sap.ui.fl.util.IFrame"))}return i(r,t)}).then(function(n){e.setRevertData({originalSettings:n});return o(r,t,e.getContent())})};n.revertChange=function(e,t,n){var r=e.getRevertData();return Promise.resolve().then(function(){if(r){if(r.originalSettings._settings&&r.originalSettings._settings.url){r.originalSettings.url=r.originalSettings._settings.url}return o(n.modifier,t,r.originalSettings)}return Promise.reject(new Error("Attempt to revert an unapplied change."))}).then(function(){e.resetRevertData()})};n.completeChangeContent=function(e,t){if(!t.content||!Object.keys(t.content).some(function(e){return r.indexOf(e)!==-1})){throw new Error("oSpecificChangeInfo attribute required")}e.setContent(t.content)};n.getCondenserInfo=function(e){return{classification:t.Update,affectedControl:e.getSelector(),uniqueKey:"iFrame",updateContent:e.getContent()}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/ChangeCategories", [],function(){"use strict";return{ADD:"add",MOVE:"move",RENAME:"rename",COMBINESPLIT:"combinesplit",REMOVE:"remove",OTHER:"other"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/createIFrame", ["sap/ui/fl/util/IFrame"],function(){"use strict";return function(e,t,a,n){var i=t.modifier;var s=e.getContent();var r=t.view;var g=t.appComponent;var o={_settings:{}};["url","width","height"].forEach(function(e){var t=s[e];o[e]=t;o._settings[e]=t});o.useLegacyNavigation=!!s.useLegacyNavigation;o._settings.useLegacyNavigation=!!s.useLegacyNavigation;if(s?.advancedSettings){o.advancedSettings=s.advancedSettings;o._settings.advancedSettings=s?.advancedSettings}if(n){o.renameInfo=n;o.asContainer=true}return Promise.resolve().then(function(){return i.createControl("sap.ui.fl.util.IFrame",g,r,a,o,false)})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/getTargetAggregationIndex", [],function(){"use strict";return function(e,n,r){var t=r.modifier;var i=e.getContent();var o=i.targetAggregation;var g=i.index;if(g===undefined){return Promise.resolve().then(t.getAggregation.bind(t,n,o)).then(function(e){return e.length})}return Promise.resolve(g)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/common/revertAddedControls", ["sap/ui/fl/Utils"],function(e){"use strict";return function(t,r,n){var o=n.modifier;var i=t.getContent().targetAggregation;var a=n.view||e.getViewForControl(r);var u=n.appComponent;var g=t.getRevertData()||[];return g.reduce(function(e,t){return e.then(function(){var e;if(typeof t==="string"){e=t}else{e=t.id;i||=t.aggregationName}return o.bySelector(e,u,a)||a&&a.createId&&o.bySelector(a.createId(e))}).then(function(e){if(e.destroy){return e.destroy()}return o.removeAggregation(r,i,e)})},Promise.resolve()).then(function(){t.resetRevertData()})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/changeHandler/condenser/Classification", [],function(){"use strict";return{LastOneWins:"lastOneWins",Reverse:"reverse",Move:"move",Create:"create",Destroy:"destroy",Update:"update"}});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/initial/_internal/FlexConfiguration", ["sap/base/config"],e=>{"use strict";const i=e.getWritableInstance();const t={getFlexibilityServices(){const e=[{url:"/sap/bc/lrep",connector:"LrepConnector"}];const t=i.get({name:"sapUiFlexibilityServices",type:i=>{if(typeof i==="string"){if(i===""){return[]}if(i[0]==="/"){e[0].url=i;i=e}else{i=JSON.parse(i)}}return i||[]},defaultValue:e,external:false});return t},setFlexibilityServices(e){i.set("sapUiFlexibilityServices",e.slice())}};return t});
/*
 * ! OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/FlexInfoSession", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils"],function(e){"use strict";var n={};var t="sap.ui.fl.info.";function r(e){return t+(e||"true")}n.get=function(t){var r=e.getFlexReferenceForControl(t);return n.getByReference(r)};n.getByReference=function(e){return JSON.parse(window.sessionStorage.getItem(r(e)))};n.set=function(t,r){if(t){var o=e.getFlexReferenceForControl(r);n.setByReference(t,o)}};n.setByReference=function(e,n){if(e){window.sessionStorage.setItem(r(n),JSON.stringify(e))}};n.remove=function(n){var t=e.getFlexReferenceForControl(n);window.sessionStorage.removeItem(r(t))};n.removeByReference=function(e){window.sessionStorage.removeItem(r(e))};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/Storage", ["sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/initial/_internal/storageResultDisassemble","sap/ui/fl/initial/_internal/StorageResultMerger","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/initial/api/Version","sap/ui/fl/Utils"],function(e,n,r,t,i,a){"use strict";function l(e,n,r){if(!n.layers||n.layers[0]!=="ALL"&&n.layers.indexOf("CUSTOMER")===-1){delete e.version;return e}if(o(r.reference)){e.allContexts=true}if(r.version!==undefined){e.version=r.version;return e}var t=a.getUrlParameter(i.UrlParameter);if(t===null){delete e.version}else{e.version=parseInt(t)}return e}function o(n){var r=e.getByReference(n);return r&&r.initialAllContexts}function s(e,n){var r=n.map(function(n){var r=Object.assign({},e,{url:n.url,path:n.path});r=l(r,n,e);return n.loadConnectorModule.loadFlexData(r).then(function(e){return e||t.getEmptyFlexDataResponse()}).catch(t.logAndResolveDefault.bind(undefined,t.getEmptyFlexDataResponse(),n,"loadFlexData"))});return Promise.all(r)}function u(e){var n=[];e.forEach(function(e){if(Array.isArray(e)){n=n.concat(e)}else{n.push(e)}});return n}function f(e){return e.map(function(e){return n(e)})}function c(e){return Promise.resolve(e).then(u).then(f).then(u).then(r.merge)}function d(e){return t.getStaticFileConnector().then(s.bind(this,e))}var p={};p.completeFlexData=function(e){if(!e||!e.reference){return Promise.reject("No reference was provided")}return Promise.all([d(e),e.partialFlexData]).then(c)};p.loadFlexData=function(e){if(!e||!e.reference){return Promise.reject("No reference was provided")}return t.getLoadConnectors().then(s.bind(this,e)).then(c)};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/StorageResultMerger", ["sap/base/util/merge","sap/base/util/ObjectPath"],function(n,a){"use strict";var e={};function r(n,e){var r=n.reduce(function(n,r){if(a.get(e,r)){return n.concat(a.get(e,r))}return n},[]);var t=[];return r.filter(function(n){var a=n.fileName;var e=t.indexOf(a)!==-1;if(e){return false}t.push(a);return true})}function t(a){return a.reduce(function(a,e){return n({},a,e.ui2personalization)},{})}function i(n){return n.reduce(function(n,a){return a.cacheKey?n+=a.cacheKey:n},"")||null}e.merge=function(n){var a={appDescriptorChanges:r(n,"appDescriptorChanges"),changes:r(n,"changes"),ui2personalization:t(n),comp:{variants:r(n,"comp.variants"),changes:r(n,"comp.changes"),defaultVariants:r(n,"comp.defaultVariants"),standardVariants:r(n,"comp.standardVariants")},variants:r(n,"variants"),variantChanges:r(n,"variantChanges"),variantDependentControlChanges:r(n,"variantDependentControlChanges"),variantManagementChanges:r(n,"variantManagementChanges"),cacheKey:i(n)};var e=r(n,"info");if(e.length>0){[a.info]=e}return a};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/StorageUtils", ["sap/base/Log","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/base/util/isEmptyObject"],function(e,n,t,r,a){"use strict";var o={load:{LrepConnector:"sap/ui/fl/initial/_internal/connectors/LrepConnector",NeoLrepConnector:"sap/ui/fl/initial/_internal/connectors/NeoLrepConnector",PersonalizationConnector:"sap/ui/fl/initial/_internal/connectors/PersonalizationConnector",KeyUserConnector:"sap/ui/fl/initial/_internal/connectors/KeyUserConnector",BtpServiceConnector:"sap/ui/fl/initial/_internal/connectors/BtpServiceConnector",StaticFileConnector:"sap/ui/fl/initial/_internal/connectors/StaticFileConnector",ObjectStorageConnector:"sap/ui/fl/apply/_internal/connectors/ObjectStorageConnector",JsObjectConnector:"sap/ui/fl/write/_internal/connectors/JsObjectConnector",ObjectPathConnector:"sap/ui/fl/write/_internal/connectors/ObjectPathConnector",LocalStorageConnector:"sap/ui/fl/write/_internal/connectors/LocalStorageConnector",SessionStorageConnector:"sap/ui/fl/write/_internal/connectors/SessionStorageConnector"},write:{LrepConnector:"sap/ui/fl/write/_internal/connectors/LrepConnector",NeoLrepConnector:"sap/ui/fl/write/_internal/connectors/NeoLrepConnector",PersonalizationConnector:"sap/ui/fl/write/_internal/connectors/PersonalizationConnector",KeyUserConnector:"sap/ui/fl/write/_internal/connectors/KeyUserConnector",BtpServiceConnector:"sap/ui/fl/write/_internal/connectors/BtpServiceConnector",StaticFileConnector:"sap/ui/fl/write/_internal/connectors/StaticFileConnector",JsObjectConnector:"sap/ui/fl/write/_internal/connectors/JsObjectConnector",ObjectPathConnector:"sap/ui/fl/write/_internal/connectors/ObjectPathConnector",LocalStorageConnector:"sap/ui/fl/write/_internal/connectors/LocalStorageConnector",SessionStorageConnector:"sap/ui/fl/write/_internal/connectors/SessionStorageConnector"}};var i="sap/ui/fl/initial/_internal/connectors/";var c={connector:"StaticFileConnector"};function s(e,n){var t=[];if(!e){t=n}else{t=e.filter(function(e){return n.indexOf(e)!==-1||n[0]==="ALL"})}return t}function l(e,n,t){return t.map(function(e){var t=e.connector;var r;if(!e.loadConnector&&!e.applyConnector&&!e.loadConnector){r=n?o.load[t]:o.write[t]}else if(n){r=e.loadConnector||e.applyConnector}else{r=e.writeConnector||"sap/ui/fl/write/connectors/BaseConnector"}return r})}function p(e,n,t){var r=l(e,n,t);return new Promise(function(e){sap.ui.require(r,function(...r){r.forEach(function(e,r){if(!t[r].layers){t[r].layers=e.layers}else{t[r].layers=s(t[r].layers,e.layers)}if(n){t[r].loadConnectorModule=e}else{t[r].writeConnectorModule=e}});e(t)})})}return{getConnectors(e,t){var r=n.getFlexibilityServices();var a=[];if(t){a=[c]}a=a.concat(r);return p(e,t,a)},getLoadConnectors(){return this.getConnectors(i,true)},getStaticFileConnector(){return p(i,true,[c])},logAndResolveDefault(n,t,r,a){e.error(`Connector (${t.connector}) failed call '${r}': ${a}\n\t\t\t\tApplication startup continues without data from this storage.`);return n},filterAndSortResponses(e){var n=[];Object.keys(e).forEach(function(t){n.push(e[t])});n=n.filter(function(e){return e.changes.length>0||e.appDescriptorChanges.length>0||e.variants.length>0||e.variantChanges.length>0||e.variantManagementChanges.length>0||e.variantDependentControlChanges.length>0||e.comp.variants.length>0||e.comp.changes.length>0||e.comp.defaultVariants.length>0||e.comp.standardVariants.length>0});n.sort(function(e,n){return e.index-n.index});return n},sortFlexObjects(e){e.sort(function(e,n){return new Date(e.creation)-new Date(n.creation)})},getGroupedFlexObjects(e){this.sortFlexObjects(e);var n={};Object.keys(t).forEach(function(e){n[e]=this.getEmptyFlexDataResponse();n[e].index=r.getLayerIndex(e)}.bind(this));e.forEach(function(e){var t=e.layer;if(e.fileType==="ctrl_variant"&&e.variantManagementReference){n[t].variants.push(e)}else if(e.fileType==="ctrl_variant_change"){n[t].variantChanges.push(e)}else if(e.fileType==="ctrl_variant_management_change"){n[t].variantManagementChanges.push(e)}else if(e.fileType==="variant"){n[t].comp.variants.push(e)}else if(e.fileType==="change"){if(e.variantReference){n[t].variantDependentControlChanges.push(e)}else if(e.appDescriptorChange){n[t].appDescriptorChanges.push(e)}else{switch(e.changeType){case"addFavorite":case"removeFavorite":case"updateVariant":n[t].comp.changes.push(e);break;case"defaultVariant":n[t].comp.defaultVariants.push(e);break;case"standardVariant":n[t].comp.standardVariants.push(e);break;default:n[t].changes.push(e)}}}});return n},getEmptyFlexDataResponse(){return Object.assign({},{appDescriptorChanges:[],changes:[],comp:{variants:[],changes:[],defaultVariants:[],standardVariants:[]},variants:[],variantChanges:[],variantDependentControlChanges:[],variantManagementChanges:[],ui2personalization:{}})},isStorageResponseFilled(e){return Object.keys(e||{}).some(function(n){if(Array.isArray(e[n])){return e[n].length!==0}return!a(e[n])})}}});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerRegistration", ["sap/ui/core/Lib","sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage","sap/ui/fl/changeHandler/AddXML","sap/ui/fl/changeHandler/AddXMLAtExtensionPoint","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/UnstashControl"],function(e,n,a,r,t,i,s,o,l,d,h,g){"use strict";var f={hideControl:t,moveElements:s,moveControls:i,stashControl:d,unhideControl:h,unstashControl:g};var u={addXML:a,addXMLAtExtensionPoint:r,propertyBindingChange:o,propertyChange:l};var c={};function C(e,n){c[e]=n;n.catch(function(){}).then(function(){delete c[e]})}function p(e){return n.registerChangeHandlersForLibrary(e)}function H(e){if(e.getParameter("operation")==="add"){var n=e.getParameter("metadata");var a=n.sName;var r=n&&n.extensions&&n.extensions.flChangeHandlers;if(r){var t=p(r);C(a,t)}}}var v={getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs(){var n=e.all();e.attachLibraryChanged(H);var a=[];Object.values(n).forEach(function(e){if(e.extensions&&e.extensions.flChangeHandlers){a.push(p(e.extensions.flChangeHandlers))}});return Promise.all(a)},waitForChangeHandlerRegistration(e){if(c[e]){return c[e].catch(function(){})}return Promise.resolve()},registerPredefinedChangeHandlers(){n.registerPredefinedChangeHandlers(f,u)}};return v});
/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/initial/_internal/changeHandlers/ChangeHandlerStorage", ["sap/base/util/each","sap/base/Log","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/requireAsync"],function(e,n,r,a,t){"use strict";var o={};var i={};var l={};var s={};function u(e){if(!e.changeHandler){n.error("sap.ui.fl.registry.ChangeRegistryStorage: changeHandler required");return false}return true}function f(e){if(typeof e.changeHandler==="string"){return t(e.changeHandler.replace(/\./g,"/")).then(function(n){e.changeHandler=n;return e.changeHandler})}return e.changeHandler}function c(e,n){var r={};if(!n||!n.changeHandler){r.changeHandler=n}else{r=n}if(r.changeHandler==="default"){r.changeHandler=s.defaultChangeHandlers[e]}else if(Object.keys(s.developerChangeHandlers||{}).includes(e)){throw Error(`You can't use a custom change handler for the following Developer Mode change type: ${e}. Please use 'default' instead.`)}return r}function g(n){l={};e(n,function(e,n){var r={controlType:"defaultActiveForAll",changeHandler:n,layers:a.getDeveloperModeLayerPermissions(),changeType:e};l[e]=r})}function h(n,r,t){t=c(r,t);var o=Object.assign({},a.getDefaultLayerPermissions());if(t.layers){e(t.layers,function(e,n){if(o[e]===undefined){throw Error(`The Layer '${e}' is not supported. Please only use supported layers`)}o[e]=n})}var i={controlType:n,changeHandler:t.changeHandler,layers:o,changeType:r};return u(i)?i:undefined}function d(e,n,r){var a=h(e,n,r);if(a){i[e]||={};i[e][n]=a}}function y(r,a){var o=Promise.resolve(a);var i="ChangeHandlerStorage.registerChangeHandlersForControl.skip_next_then";if(typeof a==="string"){o=t(`${a}.flexibility`).catch(function(e){n.error(`Flexibility change handler registration failed.\nControlType: ${r}\n${e.message}`);return Promise.resolve(i)})}return o.then(function(n){if(n!==i){e(n,function(e,n){d(r,e,n)})}}).catch(function(e){n.error(e.message)})}function p(e,n,a){var t=i[e]&&i[e][n]||l[n];if(!t){throw Error("No Change handler registered for the Control and Change type")}a=a===r.PUBLIC?r.USER:a;if(!t.layers[a]){throw Error(`Change type ${n} not enabled for layer ${a}`)}return t}function v(e,r,a,o){var i=o.getChangeHandlerModulePath(a);if(typeof i!=="string"){return Promise.resolve(undefined)}return t(i).then(function(n){var a=n[e];if(a){return h(r,e,a)}}).catch(function(e){n.error(`Flexibility registration for control ${o.getId(a)} failed to load module ${i}\n${e.message}`)})}o.getChangeHandler=function(e,n,r,a,t){return v(e,n,r,a).then(function(r){var a=r||p(n,e,t);return f(a)}).then(function(e){if(typeof e.completeChangeContent!=="function"||typeof e.applyChange!=="function"||typeof e.revertChange!=="function"){throw new Error("The ChangeHandler is either not available or does not have all required functions")}return e})};o.registerPredefinedChangeHandlers=function(e,n){s.defaultChangeHandlers=e;s.developerChangeHandlers=n;g(n)};o.registerChangeHandlersForLibrary=function(n){var r=[];e(n,function(e,n){r.push(y(e,n))});return Promise.all(r)};o.clearAll=function(){i={};l={};s={}};o.registerChangeHandlersForControl=function(e,n){return y(e,n)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/BackendConnector", ["sap/ui/fl/initial/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(e,n){"use strict";return{xsrfToken:undefined,settings:undefined,sendRequest(t){var s=n(t,["version","allContexts"]);if(this.isLanguageInfoRequired){e.addLanguageInfo(s)}var i=e.getUrl(this.ROUTES.DATA,t,s);return e.sendRequest(i,"GET",{initialConnector:this,xsrfToken:this.xsrfToken,cacheable:t.cacheable}).then(function(e){var n=e.response;if(e.etag){n.cacheKey=e.etag}if(n.settings){this.settings=n.settings}return n}.bind(this))},loadFlexData(e){e.cacheable=true;return this.sendRequest(e).then(function(e){e.changes=e.changes.concat(e.compVariants||[]);return e})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/BtpServiceConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/KeyUserConnector","sap/ui/fl/Layer"],function(e,a,n){"use strict";var s="/flex/all";var t="/v3";const i=`${s}${t}`;const r=e({},a,{layers:[n.CUSTOMER,n.PUBLIC,n.USER],ROOT:i,ROUTES:{DATA:`${i}/data`,SETTINGS:`${i}/settings`}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/KeyUserConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(e,n,a){"use strict";var t="/flex/keyuser";var c="/v2";var r=e({},n,{layers:[a.CUSTOMER,a.PUBLIC],API_VERSION:c,ROUTES:{DATA:`${t+c}/data/`},isLanguageInfoRequired:true,loadFlexData(e){e.cacheable=true;return n.sendRequest.call(this,e).then(function(e){e.contents.map(function(e,n,a){a[n].changes=(e.changes||[]).concat(e.compVariants)});e.contents.cacheKey=e.cacheKey;return e.contents})}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/LrepConnector", ["sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/Utils","sap/ui/dom/includeScript","sap/base/util/restricted/_pick"],function(e,t,i,s){"use strict";var a={DATA:"/flex/data/",MODULES:"/flex/modules/"};return{layers:["ALL"],xsrfToken:undefined,settings:undefined,_loadModules(e){return new Promise(function(t,s){i(e,undefined,t,s)})},_addClientInfo(e){var i=t.getUrlParameter("sap-client");if(!e&&i){e={}}if(i){e["sap-client"]=i}},loadFlexData(t){if(t.cacheKey==="<NO CHANGES>"){return Promise.resolve()}var i=s(t,["version","allContexts","adaptationId"]);this._addClientInfo(i);e.addSAPLogonLanguageInfo(i);var n;if(t.appDescriptor&&t.appDescriptor["sap.app"]){n=t.appDescriptor["sap.app"].id}if(t.preview){t.reference=t.preview.reference;i.upToLayerType=t.preview.maxLayer}var r=e.getUrl(a.DATA,t,i);return e.sendRequest(r,"GET",{initialConnector:this,xsrfToken:this.xsrfToken,siteId:t.siteId,cacheable:true,sAppDescriptorId:n}).then(function(s){var n=s.response;if(s.etag){n.cacheKey=s.etag}else if(t.cacheKey){n.cacheKey=t.cacheKey}n.changes=n.changes.concat(n.compVariants||[]);if(n.settings){this.settings=n.settings;this.settings.isVariantAdaptationEnabled=!!this.settings.isPublicLayerAvailable;this.settings.isContextSharingEnabled=true;this.settings.isLocalResetEnabled=true}if(!n.loadModules){return n}var r=e.getUrl(a.MODULES,t,i);return this._loadModules(r).then(function(){return n})}.bind(this))}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/NeoLrepConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/LrepConnector"],function(e,n){"use strict";return e({},n,{})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/PersonalizationConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(a,e,n){"use strict";var i="/flex/personalization";var r="/v1";var t=a({},e,{layers:[n.USER],ROUTES:{DATA:`${i+r}/data/`}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/StaticFileConnector", ["sap/base/Log","sap/base/util/LoaderExtensions","sap/ui/core/Component","sap/ui/core/Supportability"],function(e,r,a,n){"use strict";function o(o,i){var t=`${o.replace(/\./g,"/")}/changes/${i}.json`;var s=!!sap.ui.loader._.getModuleState(t);if(s||n.isDebugModeEnabled()||a.getComponentPreloadMode()==="off"){try{return r.loadResource(t)}catch(r){if(r.name.includes("SyntaxError")){e.error(r)}e.warning(`flexibility did not find a ${i}.json for the application: ${o}`)}}}return{loadFlexData(e){var r=e.componentName;r||=e.reference.replace(/.Component/g,"");var a=o(r,"flexibility-bundle");if(a){a.changes=a.changes.concat(a.compVariants);delete a.compVariants;return Promise.resolve(a)}var n=o(r,"changes-bundle");if(n){return Promise.resolve({changes:n})}return Promise.resolve()}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/Utils", ["sap/ui/core/Lib","sap/base/i18n/Localization","sap/base/security/encodeURLParameters"],function(e,s,t){"use strict";var r=2e4;var n=function(e,s){var t=new Error(e.statusText);t.status=e.status;t.userMessage=s;return t};var a=function(s){return e.getResourceBundleFor("sap.ui.fl").getText(s)};const o=(e,s)=>{if(e.slice(-1)!=="/"&&s.charAt(0)!=="/"){e+="/"}return e+s};return{addLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getLanguage()},addSAPLogonLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getSAPLogonLanguage()},getUrl(e,s,r){if(!e||!s.url){throw new Error("Not all necessary parameters were passed")}let n=o(s.url,e);if(s.cacheKey){n=o(n,`~${s.cacheKey}~`)}if(s.reference){n=o(n,s.reference)}else if(s.fileName){n=o(n,s.fileName)}if(r){Object.keys(r).forEach(function(e){if(r[e]===undefined){delete r[e]}});var a=t(r);if(a.length>0){n+=`?${a}`}}return n},sendRequest(e,s,t){s||="GET";s=s.toUpperCase();return new Promise(function(o,i){var p=new XMLHttpRequest;p.open(s,e);p.timeout=r;if((s==="GET"||s==="HEAD")&&(!t||(!t.initialConnector||!t.initialConnector.xsrfToken)&&!t.cacheable)){p.setRequestHeader("X-CSRF-Token","fetch")}if((s==="POST"||s==="PUT"||s==="DELETE")&&t&&t.initialConnector&&t.initialConnector.xsrfToken){p.setRequestHeader("X-CSRF-Token",t.initialConnector.xsrfToken)}if(t&&t.contentType){p.setRequestHeader("Content-Type",t.contentType)}if(t&&t.siteId){p.setRequestHeader("X-LRep-Site-Id",t.siteId)}if(t&&t.sAppDescriptorId){p.setRequestHeader("X-LRep-AppDescriptor-Id",t.sAppDescriptorId)}if(t&&t.dataType){p.responseType=t.dataType}p.onload=function(){if(p.status>=200&&p.status<400){try{var e={};if(p.status!==204&&p.status!==205){if(!p.response&&p.responseText){p.response=p.responseText}e.response=p.response;if(e.response&&typeof e.response==="string"&&p.getResponseHeader("content-type")&&p.getResponseHeader("content-type").indexOf("json")>0){e.response=JSON.parse(e.response)}}e.status=p.status;if(p.getResponseHeader("X-CSRF-Token")){e.xsrfToken=p.getResponseHeader("X-CSRF-Token");if(t&&t.initialConnector){t.initialConnector.xsrfToken=e.xsrfToken}}if(p.getResponseHeader("Etag")){e.etag=p.getResponseHeader("Etag")}o(e)}catch(e){e.userMessage=a("MSG_LOADING_SERVER_RESPONSE_ERROR");i(e)}}else{var s="";try{var r=typeof p.response==="string"?JSON.parse(p.response):p.response;if(Array.isArray(r.messages)&&r.messages.length){s=r.messages.reduce(function(e,s){return e.concat(s.severity==="Error"?`${s.text}\n`:"")},s)}}catch(e){}i(n(p,s))}};p.ontimeout=function(){i(n(p,a("MSG_CONNECTION_TIMEOUT_ERROR")))};p.onerror=function(){i(n(p,a("MSG_NETWORK_ERROR")))};p.addEventListener("error",function(){i(n(p,a("MSG_NETWORK_ERROR")))});if(t&&t.payload){p.send(t.payload)}else{p.send()}})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/storageResultDisassemble", ["sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/merge","sap/base/util/isEmptyObject"],function(a,e,n){"use strict";function t(a,e){if(e.content.fileName!==e.content.variantManagementReference){a.push(e.content)}e.controlChanges.forEach(function(e){a.push(e)});for(var n in e.variantChanges){a=a.concat(e.variantChanges[n])}return a}function r(a){var e=true;if(a){Object.keys(a).some(function(n){if(a[n].length){e=false;return true}})}return e}return function(i){var s;if(!n(i.variantSection)){s=i.changes||[];for(var c in i.variantSection){var o=i.variantSection[c];for(var u in o.variantManagementChanges){s=s.concat(o.variantManagementChanges[u])}s=o.variants.reduce(t,s)}var f=a.getGroupedFlexObjects(s);var v=a.filterAndSortResponses(f);delete i.changes;delete i.variantSection;e(v[0]||{},i);return v}if(r(i.comp)){s=i.changes||[];i.comp={variants:[],changes:[],defaultVariants:[],standardVariants:[]};s.slice().reverse().forEach(function(a,e,n){var t=false;if(a.fileType==="variant"){i.comp.variants.unshift(a);t=true}else{switch(a.changeType){case"addFavorite":case"removeFavorite":case"updateVariant":i.comp.changes.unshift(a);t=true;break;case"defaultVariant":i.comp.defaultVariants.unshift(a);t=true;break;case"standardVariant":i.comp.standardVariants.unshift(a);t=true;break;default:break}}if(t){var r=n.length-1-e;i.changes.splice(r,1)}})}return[i]}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/api/Version", [],function(){"use strict";return{Number:{Original:"-1",Draft:"0"},UrlParameter:"sap-ui-fl-version",Type:{Active:"active",Draft:"draft",Inactive:"inactive"}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/interfaces/BaseLoadConnector", [],function(){"use strict";var e={loadFlexData(){return Promise.reject("loadFlexData is not implemented")}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/interfaces/Delegate", [],function(){"use strict";return{getPropertyInfo(){return Promise.reject("not implemented")},getRepresentedProperties(){return Promise.reject("not implemented")},createLabel(){return Promise.reject("not implemented")},createControlForProperty(){return Promise.reject("not implemented")},createLayout(){return Promise.reject("not implemented")}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/library", ["sap/ui/core/Lib","sap/ui/fl/apply/_internal/preprocessors/RegistrationDelegator","sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/Scenario","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/core/library","sap/m/library"],function(e,i,a,r,n,s,l){"use strict";var t=e.init({name:"sap.ui.fl",version:"1.120.31",controls:["sap.ui.fl.variants.VariantManagement","sap.ui.fl.util.IFrame"],dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/fl/designtime/library.designtime",extensions:{flChangeHandlers:{"sap.ui.fl.util.IFrame":"sap/ui/fl/util/IFrame"},"sap.ui.support":{publicRules:true}}});t.condenser={Classification:l};t.Scenario=s;i.registerAll();function o(){var e=r.getUshellContainer();if(e){return e.getLogonSystem().isTrial()}return false}if(o()){a.setFlexibilityServices([{connector:"LrepConnector",url:"/sap/bc/lrep",layers:[]},{connector:"LocalStorageConnector",layers:[n.CUSTOMER,n.PUBLIC,n.USER]}])}return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/registry/Settings", ["sap/ui/fl/write/_internal/Storage","sap/ui/fl/Utils","sap/base/Log"],function(t,e,n){"use strict";function r(t){if(t&&t.logonUser){return Promise.resolve(t.logonUser)}var r=e.getUshellContainer();if(r){return e.getUShellService("UserInfo").then(function(t){var e=t.getUser();return e&&e.getId()}).catch(function(t){n.error(`Error getting service from Unified Shell: ${t.message}`)})}return Promise.resolve()}var o=function(t){if(!t){throw new Error("no flex settings provided")}this._oSettings=t};o.attachEvent=function(t,e){o._oEventProvider.attachEvent(t,e)};o.detachEvent=function(t,e){o._oEventProvider.detachEvent(t,e)};o.getInstance=function(){if(o._instance){return Promise.resolve(o._instance)}if(o._oLoadSettingsPromise){return o._oLoadSettingsPromise}return o._loadSettings()};o._loadSettings=function(){var e;var i=t.loadFeatures().then(function(t){e=t;return r(e)}).then(function(t){if(!e){n.error("The request for flexibility settings failed; A default response is generated and returned to consuming APIs");e={isKeyUser:false,isKeyUserTranslationEnabled:false,isVariantSharingEnabled:false,isVariantPersonalizationEnabled:true,isAtoAvailable:false,isAtoEnabled:false,isAppVariantSaveAsEnabled:false,isContextSharingEnabled:true,isContextBasedAdaptationEnabled:false,isCondensingEnabled:false,isProductiveSystem:true,isPublicLayerAvailable:false,isLocalResetEnabled:false,isVariantAdaptationEnabled:false,versioning:{},_bFlexChangeMode:false,_bFlexibilityAdaptationButtonAllowed:false}}e.userId=t;return o._storeInstance(e)});o._oLoadSettingsPromise=i;return i};o._storeInstance=function(t){o._instance||=new o(t);return o._instance};o.getInstanceOrUndef=function(){return o._instance};o.getDefaultLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:true,PUBLIC:false,USER:false}};o.getDeveloperModeLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:false,PUBLIC:false,USER:false}};o.prototype._getBooleanProperty=function(t){return this._oSettings[t]||false};o.prototype.isKeyUser=function(){return this._getBooleanProperty("isKeyUser")};o.prototype.isKeyUserTranslationEnabled=function(){return this._getBooleanProperty("isKeyUserTranslationEnabled")};o.prototype.isPublicLayerAvailable=function(){return this._getBooleanProperty("isPublicLayerAvailable")};o.prototype.isVariantAdaptationEnabled=function(){return this._getBooleanProperty("isVariantAdaptationEnabled")};o.prototype.isAppVariantSaveAsEnabled=function(){return!this.isContextBasedAdaptationEnabled()&&this._getBooleanProperty("isAppVariantSaveAsEnabled")};o.prototype.isContextBasedAdaptationEnabled=function(){var t=new URLSearchParams(window.location.search);var e=t.get("sap-ui-xx-rta-adaptations");return e==="true"||this._getBooleanProperty("isContextBasedAdaptationEnabled")};o.prototype.isVersioningEnabled=function(t){return!!(this._oSettings.versioning[t]||this._oSettings.versioning.ALL)};o.prototype.isModelS=function(){return this._getBooleanProperty("isAtoAvailable")};o.prototype.isAtoEnabled=function(){return this._getBooleanProperty("isAtoEnabled")};o.prototype.isAtoAvailable=function(){return this._getBooleanProperty("isAtoAvailable")};o.prototype.isProductiveSystem=function(){return this._getBooleanProperty("isProductiveSystem")};o.prototype.isVariantSharingEnabled=function(){return this._getBooleanProperty("isVariantSharingEnabled")};o.prototype.isPublicFlVariantEnabled=function(){return this._getBooleanProperty("isPublicFlVariantEnabled")};o.prototype.isContextSharingEnabled=function(){return this._getBooleanProperty("isContextSharingEnabled")};o.prototype.isVariantPersonalizationEnabled=function(){return this._getBooleanProperty("isVariantPersonalizationEnabled")};o.prototype.isCondensingEnabled=function(){return this._getBooleanProperty("isCondensingEnabled")};o.prototype.hasPersoConnector=function(){return this._getBooleanProperty("hasPersoConnector")};o.prototype.isSystemWithTransports=function(){return!!(this._oSettings.system&&this._oSettings.client)};o.prototype.isPublishAvailable=function(){return!!this._oSettings.isPublishAvailable};o.prototype.isProductiveSystemWithTransports=function(){return this.isProductiveSystem()&&this.isSystemWithTransports()};o.prototype.isLocalResetEnabled=function(){return this._getBooleanProperty("isLocalResetEnabled")};o.prototype.getSystem=function(){return this._oSettings.system};o.prototype.getClient=function(){return this._oSettings.client};o.prototype._getHostname=function(){return document.location.hostname};o.prototype.isCustomerSystem=function(){var t=this._oSettings.systemType;var e={CUSTOMER:true,SAP:false}[t];var n=this._getHostname();return e!==undefined?e:!(n==="localhost"||n==="127.0.0.1")};o.prototype.getUserId=function(){return this._oSettings.userId};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/requireAsync", [],function(){"use strict";return function(e){var i=sap.ui.require(e);if(i){return Promise.resolve(i)}return new Promise(function(i,n){sap.ui.require([e],function(e){i(e)},function(e){n(e)})})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/IFrame", ["sap/base/util/uid","sap/ui/core/Control","sap/ui/model/json/JSONModel","./getContainerUserInfo","sap/base/util/extend","sap/base/util/restricted/_CancelablePromise","sap/base/security/URLListValidator","sap/base/Log","./IFrameRenderer","../library","sap/ui/core/library"],function(e,t,i,o,r,s,a,n,l){"use strict";function u(e){if(e.parts&&e.formatter){return e.formatter.apply(null,e.parts.map(function(e){if(e.model){return`{${e.model}>${e.path}}`}return`{${e.path}}`}))}return e}var p=t.extend("sap.ui.fl.util.IFrame",{metadata:{library:"sap.ui.fl",properties:{url:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"50vh"},title:{type:"string",group:"Misc",defaultValue:undefined},asContainer:{type:"boolean",group:"Misc",defaultValue:undefined},renameInfo:{type:"object",group:"Data",defaultValue:null},useLegacyNavigation:{type:"boolean",defaultValue:false},advancedSettings:{type:"object",defaultValue:{allowForms:true,allowPopups:true,allowScripts:true,allowModals:true,allowSameOrigin:true,additionalSandboxParameters:[]}},_settings:{type:"object",group:"Data",defaultValue:null}},designtime:"sap/ui/fl/designtime/util/IFrame.designtime"},init(...e){if(t.prototype.init){t.prototype.init.apply(this,e)}this._oInitializePromise=o().then(function(e){this._oUserModel=new i(e);this.setModel(this._oUserModel,"$user")}.bind(this))},waitForInit(){return this._oInitializePromise?this._oInitializePromise:Promise.reject()},_setUrlLegacy(e){if(this._oSetUrlPromise){this._oSetUrlPromise.cancel();delete this._oSetUrlPromise}this.setProperty("url","");this._oSetUrlPromise=new s(function(e,t,i){i.shouldReject=false;setTimeout(e,0)});this._oSetUrlPromise.then(function(){delete this._oSetUrlPromise;this.setProperty("url",e)}.bind(this))},setUrl(t){var i=decodeURI(t)===t?encodeURI(t):t;if(p.isValidUrl(i)){if(this.getUseLegacyNavigation()){this._setUrlLegacy(i)}else{const t=p._toUrl(i);const o=p._toUrl(this.getUrl()||"about:blank");if(o.searchParams.has("sap-ui-xx-fl-forceEmbeddedContentRefresh")){t.searchParams.set("sap-ui-xx-fl-forceEmbeddedContentRefresh",e().substring(3))}else if(o.origin===t.origin&&o.pathname===t.pathname&&o.search===t.search&&o.hash!==t.hash){t.searchParams.append("sap-ui-xx-fl-forceEmbeddedContentRefresh",e().substring(3))}this.setProperty("url",t.toString())}}else{n.error("Provided URL is not valid as an IFrame src")}return this},_replaceIframeLocation(e){this.getDomRef().contentWindow.location.replace(e)},onAfterRendering(){if(!this.getUseLegacyNavigation()){this._replaceIframeLocation(this.getUrl());this._oLastContentWindow=this.getDomRef().contentWindow;this.getDomRef().addEventListener("load",()=>{if(!this.getDomRef()){return}if(this._oLastContentWindow!==this.getDomRef().contentWindow){this._oLastContentWindow=this.getDomRef().contentWindow;this._replaceIframeLocation(this.getUrl())}})}},applySettings(e,...i){const{url:o,...s}=e||{};t.prototype.applySettings.apply(this,[s,...i]);t.prototype.applySettings.apply(this,[{url:o},...i]);if(e){const t={...this.getProperty("_settings")||{}};if(e._settings){r(t,e._settings)}else{Object.keys(e).filter(function(t){return e[t]!==undefined}).forEach(function(i){t[i]=u(e[i])})}this.setProperty("_settings",{...t})}},exit(){if(this._oUserModel){this._oUserModel.destroy();delete this._oUserModel}},renderer:l});p._getDocumentLocation=function(){return document.location};p._toUrl=function(e){const t=p._getDocumentLocation();return new URL(e,t.href)};p.isValidUrl=function(e){try{const t=p._toUrl(e);return!/javascript/i.test(t.protocol)&&(!/http(?!s)/.test(t.protocol)||/http(?!s)/.test(p._getDocumentLocation().protocol))&&a.validate(e)}catch{return false}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/IFrameRenderer", [],function(){"use strict";function t(t,e,n){if(n!==""||n.toLowerCase()==="auto"){t.style(e,n)}}function e(t){return Object.keys(t).filter(e=>t[e]).map(t=>t.replace(/[A-Z]/g,"-$&").toLowerCase()).join(" ")}var n={apiVersion:2};n.render=function(n,a){n.openStart("iframe",a);t(n,"width",a.getWidth());t(n,"height",a.getHeight());n.style("display","block");n.style("border","none");const i=a.getAdvancedSettings();const{additionalSandboxParameters:r,...o}=i;const s=r?.join(" ");const c=e(o);const l=s?`${c} ${s}`:c;n.attr("sandbox",l);if(a.getUseLegacyNavigation()){n.attr("src",a.getUrl())}else{n.attr("src","about:blank")}var d=a.getTitle();if(d){n.attr("title",d)}n.openEnd();n.close("iframe")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/ManagedObjectModel", ["sap/ui/core/Element","sap/ui/model/base/ManagedObjectModel"],function(e,t){"use strict";function a(e){return e.charAt(0).toUpperCase()+e.slice(1)}var o=e.extend("sap.ui.fl.util.ManagedObjectModel",{metadata:{library:"sap.ui.fl",properties:{data:{type:"object"},name:{type:"string",defaultValue:"$sap.ui.fl.ManagedObjectModel"}},associations:{object:{type:"sap.ui.core.Element"}}},constructor:function(...o){e.apply(this,o);this._oManagedObjectModel=new t(e.getElementById(this.getObject()),this.getData());["data","name","object"].forEach(function(e){this[`set${a(e)}`]=function(){throw new Error(`sap.ui.fl.util.ManagedObjectModel: Can't change the value of \`${e}\` after the object is `+`initialized. Please recreate the object with correct values in the constructor.`)}},this)}});o.prototype.setParent=function(...t){const[a]=t;const o=this.getParent();if(o){o.setModel(null,this.getName())}if(a){a.setModel(this._oManagedObjectModel,this.getName())}e.prototype.setParent.apply(this,t)};o.prototype.exit=function(){this._oManagedObjectModel.destroy()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/getContainerUserInfo", ["sap/ui/fl/Utils","sap/base/Log"],function(e,r){"use strict";function t(e){if(!e){return""}return e}return function(){var n=e.getUshellContainer();if(n){return e.getUShellService("UserInfo").then(function(e){if(!e){return{}}var r=e.getUser();if(!r){return{}}var n=t(r.getEmail());var i;if(n){i=t(/@(.*)/.exec(n)[1])}else{i=""}return{fullName:t(r.getFullName()),firstName:t(r.getFirstName()),lastName:t(r.getLastName()),email:n,domain:i}}).catch(function(e){r.error(`Unexpected exception when reading shell user info: ${e.toString()}`);return{}})}return Promise.resolve({})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/variants/VariantManagement", ["sap/ui/model/Context","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VariantItem","sap/m/VariantManagement","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/registry/Settings","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/base/Log"],function(t,e,a,n,i,o,r,s,l,h,p){"use strict";var{TitleLevel:c}=h;var d=s.extend("sap.ui.fl.variants.VariantManagement",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl"],library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false},resetOnContextChange:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:""},editable:{type:"boolean",group:"Misc",defaultValue:true},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},executeOnSelectionForStandardDefault:{type:"boolean",group:"Misc",defaultValue:false},displayTextForExecuteOnSelectionForStandardVariant:{type:"string",group:"Misc",defaultValue:""},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:c.Auto},titleStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:c.Auto},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},events:{initialized:{},save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},public:{type:"boolean"},def:{type:"boolean"},tile:{type:"boolean"}}},cancel:{},manage:{parameters:{renamed:{type:"object[]"},deleted:{type:"string[]"},exe:{type:"object[]"},def:{type:"string"}}},select:{parameters:{key:{type:"string"}}}},associations:{for:{type:"sap.ui.core.Control",multiple:true}},aggregations:{_embeddedVM:{type:"sap.m.VariantManagement",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2,render(t,e){t.openStart("div",e);t.style("max-width",e.getMaxWidth());t.openEnd();t.renderControl(e._oVM);t.close("div")}}});d.prototype.init=function(){s.prototype.init.apply(this);this.addStyleClass("sapUiFlVarMngmt");this._oRb=l.getResourceBundleFor("sap.ui.fl");this.setModelName(o.getVariantModelName());this.attachModelContextChange(this._setModel,this);this._oVM=new i(`${this.getId()}-vm`);this.setAggregation("_embeddedVM",this._oVM,true);this._aCancelEventHandlers=[];this._aSaveEventHandlers=[];this._aManageEventHandlers=[];this._aSelectEventHandlers=[];this._oVM.attachManage(this._fireManage,this);this._oVM.attachCancel(this._fireCancel,this);this._oVM.attachSave(this._fireSave,this);this._oVM.attachSelect(this._fireSelect,this);this._updateWithSettingsInfo()};d.prototype.getOverflowToolbarConfig=function(){return{canOverflow:false,invalidationEvents:["save","manage","select"]}};d.prototype.attachCancel=function(t,e,a){this.attachEvent("cancel",t,e,a);return this};d.prototype._findCallback=function(t,e,a){var n=-1;t.some(function(t,i){if(t.fCallback===e&&t.oObj===a){n=i}return n>=0});return n};d.prototype.detachCancel=function(t,e){var a=this._findCallback(this._aCancelEventHandlers,t,e);if(a>=0){this.detachEvent("cancel",t,e);this._aCancelEventHandlers.splice(a,1)}return this};d.prototype.fireManage=function(t){this._oVM.fireManage(t)};d.prototype.fireSave=function(t){this._oVM.fireSave(t)};d.prototype._fireCancel=function(t){for(var e=0;e<this._aCancelEventHandlers.length;e++){t.oSource=this;this._aCancelEventHandlers[e].fCallbackBound(t,this._aCancelEventHandlers[e].mProps)}};d.prototype.attachSave=function(t,e,a){this.attachEvent("save",t,e,a);return this};d.prototype.detachSave=function(t,e){var a=this._findCallback(this._aSaveEventHandlers,t,e);if(a>-1){this.detachEvent("save",t,e);this._aSaveEventHandlers.splice(a,1)}return this};d.prototype._fireSave=function(t){this._handleAllListeners(t,this._aSaveEventHandlers)};d.prototype.hasListeners=function(...t){const[e]=t;const a=["save","select","cancel","manage"];if(a.indexOf(e)>-1){var n=null;if(e==="select"){n=this._aSelectEventHandlers}else if(e==="save"){n=this._aSaveEventHandlers}else if(e==="manage"){n=this._aManageEventHandlers}else if(e==="cancel"){n=this._aCancelEventHandlers}return n.length>0}return s.prototype.hasListeners.apply(this,t)};d.prototype.attachEvent=function(...t){const[e,,a]=t;let[,n,,i]=t;const o=["save","select","cancel","manage"];if(o.indexOf(e)>-1){var r=null;var l=a;if(typeof n==="function"){l=n;i=a;n=undefined}i=i===this?undefined:i;if(e==="select"){r=this._aSelectEventHandlers}else if(e==="save"){r=this._aSaveEventHandlers}else if(e==="manage"){r=this._aManageEventHandlers}else if(e==="cancel"){r=this._aCancelEventHandlers}r.push({fCallback:l,fCallbackBound:i?l.bind(i):l,oObj:i,mProps:n})}else{s.prototype.attachEvent.apply(this,t)}};d.prototype.attachEventOnce=function(...t){const[e,a,n,i]=t;var o;if(e==="manage"){o=this._findCallback(this._aManageEventHandlers,n,i);if(o>-1&&this._aManageEventHandlers[o].bOnce){this._aManageEventHandlers.splice(o,1)}this.attachManage(a,n,i);o=this._findCallback(this._aManageEventHandlers,n,i);if(o>-1){this._aManageEventHandlers[o].bOnce=true}}else if(e==="save"){o=this._findCallback(this._aSaveEventHandlers,n,i);if(o>-1&&this._aSaveEventHandlers[o].bOnce){this._aSaveEventHandlers.splice(o,1)}this.attachSave(a,n,i);o=this._findCallback(this._aSaveEventHandlers,n,i);if(o>-1){this._aSaveEventHandlers[o].bOnce=true}}else if(e==="select"){o=this._findCallback(this._aSelectEventHandlers,n,i);if(o>-1&&this._aSelectEventHandlers[o].bOnce){this._aSelectEventHandlers.splice(o,1)}this.attachSelect(a,n,i);o=this._findCallback(this._aSelectEventHandlers,n,i);if(o>-1){this._aSelectEventHandlers[o].bOnce=true}}else{s.prototype.attachEventOnce.apply(this,t)}};d.prototype.attachManage=function(t,e,a){this.attachEvent("manage",t,e,a);return this};d.prototype._handleAllListeners=function(t,e){var a=0;var n=[];while(a<e.length){t.oSource=this;e[a].fCallbackBound(t,e[a].mProps);if(e[a]){if(e[a].hasOwnProperty("bOnce")&&e[a].bOnce){n.push(a)}a+=1}}for(a=n.length-1;a>-1;a--){e.splice(n[a],1)}};d.prototype._fireManage=function(t){this._handleAllListeners(t,this._aManageEventHandlers)};d.prototype.detachManage=function(t,e){var a=this._findCallback(this._aManageEventHandlers,t,e);if(a>-1){this.detachEvent("manage",t,e);this._aManageEventHandlers.splice(a,1)}return this};d.prototype.attachSelect=function(t,e,a){this.attachEvent("select",t,e,a);return this};d.prototype._fireSelect=function(t){this._handleAllListeners(t,this._aSelectEventHandlers)};d.prototype.detachSelect=function(t,e){var a=this._findCallback(this._aSelectEventHandlers,t,e);if(a>-1){this.detachEvent("select",t,e);this._aSelectEventHandlers.splice(a,1)}return this};d.prototype._createSaveAsDialog=function(){this._oVM._createSaveAsDialog()};d.prototype._handleVariantSaveAs=function(t){this._oVM._handleVariantSaveAs(t)};d.prototype.getFocusDomRef=function(){if(this._oVM){return this._oVM.oVariantPopoverTrigger.getFocusDomRef()}return null};d.prototype.getManageDialog=function(){if(this._oVM){return this._oVM.oManagementDialog}return null};d.prototype.getVariants=function(){return this._oVM?this._oVM.getItems():[]};d.prototype.getVariantByKey=function(t){return this._oVM?this._oVM._getItemByKey(t):null};d.prototype.getTitle=function(){return this._oVM.getTitle()};d.prototype.refreshTitle=function(){this._oVM.refreshTitle()};d.prototype.setPopoverTitle=function(t){this._oVM.setPopoverTitle(t);return this};d.prototype.setHeaderLevel=function(t){this.setProperty("headerLevel",t);this._oVM.setLevel(t);return this};d.prototype.setTitleStyle=function(t){this.setProperty("titleStyle",t);this._oVM.setTitleStyle(t);return this};d.prototype.setShowAsText=function(t){this._oVM.setShowAsText(t);return this};d.prototype.getShowAsText=function(){return this._oVM.getShowAsText()};d.prototype.setEditable=function(t){this.setProperty("editable",t);this._oVM.setShowFooter(t);return this};d.prototype.setShowExecuteOnSelection=function(t){this._oVM.setSupportApplyAutomatically(t);return this};d.prototype.setShowSetAsDefault=function(t){this.setProperty("showSetAsDefault",t);this._oVM.setSupportDefault(t);return this};d.prototype.setDisplayTextForExecuteOnSelectionForStandardVariant=function(t){this.setProperty("displayTextForExecuteOnSelectionForStandardVariant",t);this._oVM.setDisplayTextForExecuteOnSelectionForStandardVariant(t);return this};d.prototype.setInErrorState=function(t){this.setProperty("inErrorState",t);this._oVM.setInErrorState(t);return this};d.prototype._setStandardVariantKey=function(t){this._oVM.setStandardVariantKey(t)};d.prototype.openManagementDialog=function(t,e,a){this._oVM.openManagementDialog(t,e,a)};d.prototype.openSaveAsDialogForKeyUser=function(t,e){this._oVM.openSaveAsDialog(t,e)};d.prototype.setEditable=function(t){this._oVM.setProperty("showFooter",t);return this};d.prototype.setCurrentVariantKey=function(t){this._oVM.setSelectedKey(t)};d.prototype.getCurrentVariantKey=function(){return this._oVM.getSelectedKey()};d.prototype.setDefaultVariantKey=function(t){this._oVM.setDefaultKey(t)};d.prototype.getDefaultVariantKey=function(){return this._oVM.getDefaultKey()};d.prototype.enteringDesignMode=function(){this._oVM.setDesignMode(true)};d.prototype.leavingDesignMode=function(){this._oVM.setDesignMode(false)};d.prototype.getModified=function(){return this._oVM.getModified()};d.prototype.setModified=function(t){this._oVM.setModified(t)};d.prototype.getStandardVariantKey=function(){return this._oVM.getStandardVariantKey()};d.prototype._getEmbeddedVM=function(){return this._oVM};d.prototype._updateWithSettingsInfo=function(){r.getInstance().then(function(t){if(this._oVM){this._oVM.setShowSaveAs(t.isVariantPersonalizationEnabled());this._oVM.setSupportPublic(t.isPublicFlVariantEnabled())}}.bind(this)).catch(function(t){p.error(t)})};d.prototype.getModelName=function(){return this.getProperty("modelName")};d.prototype.setModelName=function(t){if(this.getModelName()){this.oContext=null;this._aCancelEventHandlers=[];this._aSaveEventHandlers=[];this._aManageEventHandlers=[];this._aSelectEventHandlers=[]}this.setProperty("modelName",t);return this};d.prototype._setModel=function(){this._setBindingContext()};d.prototype._setBindingContext=function(){var e;var a;var n=this.getModelName();if(!this.oContext){e=this.getModel(n);if(e){a=this._getLocalId(e);if(a){this.oContext=new t(e,`/${a}`);this.setBindingContext(this.oContext,n);if(e.registerToModel){e.registerToModel(this)}this.fireInitialized();this._oVM.setModel(e,n);this._oVM.setSupportDefault(true);this._createItemsModel(n);this._oVM.bindProperty("selectedKey",{path:`${this.oContext}/currentVariant`,model:n});this._oVM.bindProperty("defaultKey",{path:`${this.oContext}/defaultVariant`,model:n});this._oVM.bindProperty("modified",{path:`${this.oContext}/modified`,model:n});this._oVM.bindProperty("supportFavorites",{path:`${this.oContext}/showFavorites`,model:n});this._oVM.bindProperty("supportApplyAutomatically",{path:`${this.oContext}/showExecuteOnSelection`,model:n});this._oVM.bindProperty("showFooter",{path:`${this.oContext}/variantsEditable`,model:n});this._oVM.setPopoverTitle(this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS"));this._setStandardVariantKey(a)}}}};d.prototype._createItemsModel=function(t){var i=new n({key:`{${t}>key}`,title:`{${t}>title}`,sharing:`{${t}>sharing}`,remove:`{${t}>remove}`,favorite:`{${t}>favorite}`,executeOnSelect:`{${t}>executeOnSelect}`,rename:`{${t}>rename}`,visible:`{${t}>visible}`,changeable:`{${t}>change}`,author:`{${t}>author}`,contexts:`{${t}>contexts}`});this._oVM.bindAggregation("items",{path:`${this.oContext}/variants`,model:t,template:i,filters:new e({path:"visible",operator:a.EQ,value1:true})})};d.prototype._getLocalId=function(t){var e=this.getModelName();if(!e){return null}if(e!==o.getVariantModelName()){return this.getId()}return t.getVariantManagementReferenceForControl(this)};d.prototype._getInnerItems=function(){var t=[];if(this.oContext&&this.oContext.getObject()){t=this.oContext.getObject().variants.filter(function(t){if(!t.hasOwnProperty("visible")){return true}return t.visible})}return t};d.prototype._getInnerItemByKey=function(t){var e=null;var a=this._getInnerItems();a.some(function(a){if(a.key===t){e=a}return e!==null});return e};d.prototype.registerApplyAutomaticallyOnStandardVariant=function(t){this._fRegisteredApplyAutomaticallyOnStandardVariant=t;return this};d.prototype.getApplyAutomaticallyOnVariant=function(t){var e=false;if(t){e=t.executeOnSelect;if(this._fRegisteredApplyAutomaticallyOnStandardVariant&&this.getDisplayTextForExecuteOnSelectionForStandardVariant()&&t.key===this._oVM.getStandardVariantKey()){try{e=this._fRegisteredApplyAutomaticallyOnStandardVariant(t)}catch(t){p.error("callback for determination of apply automatically on standard variant failed")}}}return e};d.prototype.exit=function(...t){this._oVM.detachManage(this._fireManage,this);this._oVM.detachCancel(this._fireCancel,this);this._oVM.detachSelect(this._fireSelect,this);this._oVM.detachSave(this._fireSave,this);s.prototype.exit.apply(this,t);this._oVM=undefined;this._fRegisteredApplyAutomaticallyOnStandardVariant=null;this.oContext=undefined;this._oRb=undefined;this._aCancelEventHandlers=undefined;this._aSaveEventHandlers=undefined;this._aManageEventHandlers=undefined;this._aSelectEventHandlers=undefined};d.prototype.addFor=function(t){this.addAssociation("for",t);return this};d.prototype._getToolbarInteractive=function(){return true};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/variants/VariantModel", ["sap/base/util/restricted/_omit","sap/base/util/restricted/_isEqual","sap/base/util/each","sap/base/util/includes","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel"],function(e,t,a,n,r,i,o,s,c,l,h,f,u,p,g,d,v,m,C,V,y,R,D,b,S,x,I){"use strict";var F={};function M(e,t){return E(function(e,t){var a=t.model;var n=t.vmReference;var r=false;var i=o.get([n,"modified"],a.oData);var s=e.key;var c=e.key;return Promise.resolve().then(function(){if(o.get([n,"currentVariant"],a.oData)&&a.oData[n].currentVariant!==s){c=a.oData[n].currentVariant;r=true;return a.updateCurrentVariant({variantManagementReference:n,newVariantReference:s,appComponent:a.oAppComponent,internallyCalled:true})}}).then(function(){if(i){var e=m.getControlChangesForVariant({reference:a.sFlexReference,vmReference:n,vReference:c});return P({changes:e,vmReference:n,vReference:c,revert:!r,model:a})}return Promise.resolve()}).then(function(){if(!r){a.callVariantSwitchListeners(n,a.oData[n].currentVariant)}})}.bind(null,e.getParameters(),t),t.model)}function P(e){var t=e.model._getDirtyChangesFromVariantChanges(e.changes);t=t.reverse();return Promise.resolve().then(function(){if(e.revert){return p.revertMultipleChanges(t,{appComponent:e.model.oAppComponent,modifier:c,flexController:e.model.oFlexController})}return undefined}).then(function(){e.model.oChangePersistence.deleteChanges(t)})}function E(e,t){t._oVariantSwitchPromise=t._oVariantSwitchPromise.catch(function(){}).then(e);t.oFlexController.setVariantSwitchPromise(t._oVariantSwitchPromise);return t._oVariantSwitchPromise}function _(e,t){F[e]=t}function U(e,t){return v.switchVariant(e).then(function(){if(this.oData[e.vmReference].updateVariantInURL){g.updateVariantInURL({vmReference:e.vmReference,newVReference:e.newVReference,model:this})}this.callVariantSwitchListeners(e.vmReference,e.newVReference,undefined,t)}.bind(this))}function L(e){var t=b.getInstanceOrUndef();if(t&&!t.isVariantPersonalizationEnabled()){e.remove=false;e.rename=false;e.change=false}}function w(e){var t=b.getInstanceOrUndef();var a=t&&(t.isKeyUser()||!t.getUserId()||t.isPublicFlVariantEnabled()&&t.getUserId().toUpperCase()===e.author.toUpperCase());e.remove=a;e.rename=a;e.change=a}function A(e,t,a){var n=a?R.getCurrentLayer():y.USER;if(e.layer===n&&e.key!==t){return true}return false}function T(e){return new Promise(function(t){if(e.getDomRef()){t()}else{e.addEventDelegate({onAfterRendering(){t()}})}})}function O(){var e=D.getUshellContainer();if(e){var t=[D.getUShellService("UserInfo"),D.getUShellService("URLParsing"),D.getUShellService("CrossApplicationNavigation"),D.getUShellService("ShellNavigation")];return Promise.all(t).then(function(e){_("UserInfo",e[0]);_("URLParsing",e[1]);_("CrossApplicationNavigation",e[2]);_("ShellNavigation",e[3])}).catch(function(e){throw new Error(`Error getting service from Unified Shell: ${e}`)})}}function k(e,t){return i({},e.find(function(e){return e.key===t}))}function B(e,t,a){var n={layer:e,control:t,reference:a};var r=S.hasAdaptationsModel(n);return r&&S.getDisplayedAdaptationId(n)}var N=I.extend("sap.ui.fl.variants.VariantModel",{constructor:function(e,t){this.pSequentialImportCompleted=Promise.resolve();I.apply(this,[e]);this.sharing={PRIVATE:"private",PUBLIC:"public"};this.oFlexController=t.flexController;this.oChangePersistence=this.oFlexController._oChangePersistence;this.sFlexReference=C.getFlexReferenceForControl(t.appComponent);this.oAppComponent=t.appComponent;this._oResourceBundle=f.getResourceBundleFor("sap.ui.fl");this._oVariantSwitchPromise=Promise.resolve();this._oVariantAppliedListeners={};this.fnUpdateListener=this.updateData.bind(this);this.oDataSelector=m.getVariantManagementMap();this.oDataSelector.addUpdateListener(this.fnUpdateListener);this.updateData();this.setDefaultBindingMode(x.OneWay)}});N.prototype.updateData=function(){var e=this.oDataSelector.get({reference:this.sFlexReference});var t=Object.assign({},this.getData());Object.entries(e).forEach(function(e){var a=e[0];var n=Object.assign({},e[1]);t[a]||={};t[a].variants=n.variants.map(function(e){var n=(t[a].variants||[]).find(function(t){return t.key===e.key});return Object.assign({},n||{},e)});t[a].currentVariant=n.currentVariant;t[a].defaultVariant=n.defaultVariant;t[a].modified=n.modified});this.setData(t);this.refresh(true)};N.prototype.invalidateMap=function(){this.oDataSelector.checkUpdate({reference:this.sFlexReference})};N.prototype.initialize=function(){return Promise.all([b.getInstance(),O()]).then(function(){g.initialize({model:this})}.bind(this))};N.prototype.updateCurrentVariant=function(e){var t={vmReference:e.variantManagementReference,currentVReference:this.getCurrentVariantReference(e.variantManagementReference),newVReference:e.newVariantReference,flexController:this.oFlexController,appComponent:e.appComponent||this.oAppComponent,modifier:c,reference:this.sFlexReference};if(e.internallyCalled){return U.call(this,t,e.scenario)}return E(U.bind(this,t,e.scenario),this)};N.prototype.getCurrentVariantReference=function(e){return this.oData[e].currentVariant};N.prototype.getVariantManagementReference=function(e){var t="";var a=-1;Object.keys(this.oData).some(function(n){return this.oData[n].variants.some(function(r,i){if(r.key===e){t=n;a=i;return true}})}.bind(this));return{variantManagementReference:t,variantIndex:a}};N.prototype.getVariant=function(e,t){var a=t||this.getVariantManagementReference(e).variantManagementReference;return k(this.oData[a].variants,e)};N.prototype.getVariantTitle=function(e,t){return k(this.oData[t].variants,e).title};function j(e,t){var a=m.getVariantChangesForVariant({vmReference:e,reference:this.sFlexReference});var n=this.oData[e].defaultVariant;if(t.getExecuteOnSelectionForStandardDefault()&&n===e&&!a.setExecuteOnSelect){var r=k(this.oData[e].variants,e);r.instance.setExecuteOnSelection(true);this.oData[e].variants[0].executeOnSelect=true;return true}return false}N.prototype.attachVariantApplied=function(e){var t=h.getElementById(e.vmControlId);var a=this.getVariantManagementReferenceForControl(t);return this.waitForVMControlInit(a).then(function(e,a){this._oVariantAppliedListeners[e]||={};var n=j.call(this,e,t);if(a.callAfterInitialVariant||n){var r={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:e,flexController:this.oFlexController};m.waitForInitialVariantChanges(r).then(function(){var t=this.oData[e].currentVariant;this.callVariantSwitchListeners(e,t,a.callback)}.bind(this))}return T(a.control).then(function(){if(V.getRelevantVariantManagementControlId(a.control,this.getVariantManagementControlIds())===a.vmControlId){this.oData[e].showExecuteOnSelection=true;this.checkUpdate(true);this._oVariantAppliedListeners[e][a.control.getId()]=a.callback}else{s.error("Error in attachVariantApplied: The passed VariantManagement ID does not match the "+"responsible VariantManagement control")}}.bind(this))}.bind(this,a,e))};N.prototype.callVariantSwitchListeners=function(e,t,n,r){if(this._oVariantAppliedListeners[e]){var i=k(this.oData[e].variants,t);if(r){i.createScenario=r}if(n){n(i)}else{a(this._oVariantAppliedListeners[e],function(e,t){t(i)})}}};N.prototype.detachVariantApplied=function(e,t){var a=this.getVariantManagementReferenceForControl(h.getElementById(e));if(this._oVariantAppliedListeners[a]){delete this._oVariantAppliedListeners[a][t]}};N.prototype.eraseDirtyChangesOnVariant=function(e,t){var a=m.getControlChangesForVariant({reference:this.sFlexReference,vmReference:e,vReference:t});var n=this._getDirtyChangesFromVariantChanges(a);return P({changes:a,vmReference:e,vReference:t,model:this,revert:true}).then(function(){return n})};N.prototype.addAndApplyChangesOnVariant=function(e){this.oChangePersistence.addChanges(e,this.oAppComponent);return e.reduce(function(e,t){return e.then(function(){var e=h.getElementById(c.getControlIdBySelector(t.getSelector(),this.oAppComponent));return u.applyChangeOnControl(t,e,{modifier:c,appComponent:this.oAppComponent,view:D.getViewForControl(e)}).then(e=>{if(!e.success){var a=e.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(t,true);throw a}})}.bind(this))}.bind(this),Promise.resolve())};N.prototype._getVariantTitleCount=function(e,t){var a=this.getData();return a[t].variants.reduce(function(t,a){if(e.toLowerCase()===a.title.toLowerCase()&&a.visible){t++}return t},0)};function H(e,t){var a={id:t.newVariantReference,variantName:t.title,contexts:t.contexts,layer:t.layer,adaptationId:t.adaptationId,reference:e.getFlexObjectMetadata().reference,generator:t.generator,variantManagementReference:t.variantManagementReference};if(t.layer===y.VENDOR){a.user="SAP"}if(t.currentVariantComparison===1){if(t.sourceVariantSource.instance.getLayer()===t.layer){a.variantReference=t.sourceVariantSource.instance.getVariantReference()}else{a.variantReference=e.getVariantReference()}}else if(t.currentVariantComparison===0){a.variantReference=e.getVariantReference()}else if(t.currentVariantComparison===-1){a.variantReference=t.sourceVariantReference}return d.createFlVariant(a)}N.prototype._duplicateVariant=function(e){var t=e.sourceVariantReference;var a=e.variantManagementReference;var n=this.getVariant(t);var r=m.getControlChangesForVariant({vmReference:a,vReference:t,reference:this.sFlexReference}).map(function(e){return e.convertToFileContent()});e.currentVariantComparison=R.compareAgainstCurrentLayer(n.instance.getLayer(),e.layer);if(e.currentVariantComparison===1){e.sourceVariantSource=this.getVariant(n.instance.getVariantReference())}var o={instance:H(n.instance,e),controlChanges:r,variantChanges:{}};r=o.controlChanges.slice();var s={};o.controlChanges=r.reduce(function(t,a){if(R.compareAgainstCurrentLayer(a.layer,e.layer)>=0){s=i({},a);s.layer=e.layer;s.variantReference=o.instance.getId();s.support||={};s.support.sourceChangeFileName=a.fileName;s.packageName="$TMP";s.fileName=D.createDefaultFileName(s.changeType);t.push(d.createFromFileContent(s))}return t},[]);return o};N.prototype.copyVariant=function(e){var t=this._duplicateVariant(e);t.generator=e.generator;this.oData[e.variantManagementReference].variants.push({key:t.instance.getId(),rename:true,change:true,remove:true,sharing:e.layer===y.USER?this.sharing.PRIVATE:this.sharing.PUBLIC});var a=[];if(e.layer===y.PUBLIC){t.instance.setFavorite(false);var n={selector:c.getSelector(e.newVariantReference,e.appComponent),changeType:"setFavorite",fileType:"ctrl_variant_change",generator:e.generator,layer:y.USER,reference:this.sFlexReference,content:{favorite:true}};a.push(d.createUIChange(n))}a=this.oChangePersistence.addDirtyChanges(a.concat([t.instance].concat(t.controlChanges).concat(e.additionalVariantChanges)));return this.updateCurrentVariant({variantManagementReference:e.variantManagementReference,newVariantReference:t.instance.getId(),appComponent:e.appComponent,internallyCalled:true,scenario:"saveAs"}).then(function(){return a})};N.prototype.removeVariant=function(e){var t=this.oChangePersistence.getDirtyChanges().filter(function(t){return t.getVariantReference&&t.getVariantReference()===e.variant.getId()||t.getId()===e.variant.getId()});return this.updateCurrentVariant({variantManagementReference:e.variantManagementReference,newVariantReference:e.sourceVariantReference,appComponent:e.component}).then(function(){this.oChangePersistence.deleteChanges(t)}.bind(this))};N.prototype._collectModelChanges=function(e,t,a){const n=this.getData()[e];const r=n.variants;const i=[];const o=b.getInstanceOrUndef();const s=e=>r.find(t=>t.key===e);const c=(e,a,n)=>{const r=["setTitle","setExecuteOnSelect","setVisible"].includes(a);const s=r&&o?.isPublicFlVariantEnabled()&&e.layer===y.PUBLIC?y.PUBLIC:t;i.push({variantReference:e.key,changeType:a,layer:s,...n})};a.getParameter("renamed")?.forEach(({key:e,name:t})=>{const a=s(e);c(a,"setTitle",{title:t,originalTitle:a.title})});a.getParameter("fav")?.forEach(({key:e,visible:t})=>{const a=s(e);c(a,"setFavorite",{favorite:t,originalFavorite:a.favorite})});a.getParameter("exe")?.forEach(({key:e,exe:t})=>{const a=s(e);c(a,"setExecuteOnSelect",{executeOnSelect:t,originalExecuteOnSelect:a.executeOnSelect})});a.getParameter("deleted")?.forEach(e=>{const t=s(e);c(t,"setVisible",{visible:false})});a.getParameter("contexts")?.forEach(({key:e,contexts:t})=>{const a=s(e);c(a,"setContexts",{contexts:t,originalContexts:a.contexts})});const l=a.getParameter("def");if(l){i.push({variantManagementReference:e,changeType:"setDefault",defaultVariant:l,originalDefaultVariant:n.defaultVariant,layer:t})}return i};N.prototype.manageVariants=function(e,t,a,n,r){return new Promise(function(i){e.attachEventOnce("manage",{resolve:i,variantManagementReference:t,layer:a},this.fnManageClickRta,this);e.openManagementDialog(true,n,r)}.bind(this))};N.prototype.createVariantChange=function(e,t){var a=this.setVariantProperties(e,t);var n={changeType:t.changeType,layer:t.layer,generator:t.generator,reference:this.sFlexReference};if(t.adaptationId!==undefined){n.adaptationId=t.adaptationId}else{n.adaptationId=B(t.layer,t.appComponent,this.sFlexReference)}if(t.changeType==="setDefault"){n.fileType="ctrl_variant_management_change";n.selector=c.getSelector(e,t.appComponent)}else{n.fileType="ctrl_variant_change";n.selector=c.getSelector(t.variantReference,t.appComponent)}var r=d.createUIChange(n);r.setContent(a);if(t.changeType==="setTitle"){r.setText("title",t.title,"XFLD")}return r};N.prototype.addVariantChange=function(e,t){var a=this.createVariantChange(e,t);this.oChangePersistence.addDirtyChange(a);return a};N.prototype.addVariantChanges=function(e,t){var a=t.map(function(t){return this.createVariantChange(e,t)}.bind(this));this.oChangePersistence.addDirtyChanges(a);return a};N.prototype.deleteVariantChange=function(e,t,a){this.setVariantProperties(e,t);this.oChangePersistence.deleteChange(a)};N.prototype.setVariantProperties=function(e,t){var a=this.getData();var n=this.getVariant(t.variantReference,e).instance;var r={};switch(t.changeType){case"setTitle":n.setName(t.title,true);break;case"setFavorite":r.favorite=t.favorite;n.setFavorite(t.favorite);break;case"setExecuteOnSelect":r.executeOnSelect=t.executeOnSelect;n.setExecuteOnSelection(t.executeOnSelect);break;case"setVisible":r.visible=t.visible;r.createdByReset=false;n.setVisible(t.visible);break;case"setContexts":r.contexts=t.contexts;n.setContexts(t.contexts);break;case"setDefault":r.defaultVariant=t.defaultVariant;var i=g.getStoredHashParams({model:this});if(i){if(a[e].defaultVariant!==a[e].currentVariant&&i.indexOf(a[e].currentVariant)===-1){g.update({parameters:i.concat(a[e].currentVariant),updateURL:!this._bDesignTimeMode&&this.oData[e].updateVariantInURL,updateHashEntry:true,model:this})}else if(a[e].defaultVariant===a[e].currentVariant&&i.indexOf(a[e].currentVariant)>-1){i.splice(i.indexOf(a[e].currentVariant),1);g.update({parameters:i,updateURL:!this._bDesignTimeMode&&this.oData[e].updateVariantInURL,updateHashEntry:true,model:this})}}break;default:break}return r};N.prototype._ensureStandardVariantExists=function(t){var a=this.getData();var n=a[t]||{};var i=e(n,["initPromise"]);if(!a[t]||r(i)){var o=d.createFlVariant({id:t,variantManagementReference:t,variantName:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),user:V.DEFAULT_AUTHOR,layer:y.BASE,reference:this.sFlexReference});m.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),o)}};N.prototype.setModelPropertiesForControl=function(e,t,a){this.oData[e].showFavorites=true;var n=this._bDesignTimeMode;if(n!==t){this._bDesignTimeMode=t;if(t){g.clearAllVariantURLParameters({model:this})}else if(n){g.update({parameters:g.getStoredHashParams({model:this}),updateURL:this.oData[e].updateVariantInURL,updateHashEntry:false,model:this})}}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents()}a.detachManage(this.fnManageClick,this);if(t&&this.oData[e]._isEditable){this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(a){a.rename=true;a.change=true;a.sharing=this.sharing.PUBLIC;a.remove=A(a,e,t)}.bind(this))}else if(this.oData[e]._isEditable){a.attachManage({variantManagementReference:e},this.fnManageClick,this);this.oData[e].variantsEditable=true;this.oData[e].variants.forEach(function(a){a.remove=A(a,e,t);switch(a.layer){case y.USER:a.rename=true;a.change=true;a.sharing=this.sharing.PRIVATE;L(a);break;case y.PUBLIC:a.sharing=this.sharing.PUBLIC;w(a);break;default:a.rename=false;a.change=false;a.sharing=this.sharing.PUBLIC}}.bind(this))}else{this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(e){e.remove=false;e.rename=false;e.change=false})}};N.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,t){var a=this._collectModelChanges(t.variantManagementReference,t.layer,e);t.resolve(a)};this.fnManageClick=function(e,t){(async()=>{if(!this.oFlexController||!this.getData()){return}var a=this._collectModelChanges(t.variantManagementReference,y.USER,e);if(a.some(e=>e.visible===false&&e.variantReference===this.getCurrentVariantReference(t.variantManagementReference))){await this.updateCurrentVariant({variantManagementReference:t.variantManagementReference,newVariantReference:t.variantManagementReference})}var n=[];a.forEach(function(e){e.appComponent=this.oAppComponent}.bind(this));n=n.concat(this.addVariantChanges(t.variantManagementReference,a));this.oChangePersistence.saveDirtyChanges(this.oAppComponent,false,n)})()}};function z(e,t,a,n){if(!this._bDesignTimeMode){return e.saveSequenceOfDirtyChanges(t,n).then(function(e){if(e){const t=e.response.find(e=>e.fileType==="ctrl_variant");const n=this.oData[a].variants.find(e=>e.key===t.fileName);const r=n.instance.getSupportInformation();r.user=t.support.user;n.instance.setSupportInformation(r)}this.invalidateMap()}.bind(this))}return Promise.resolve()}N.prototype._handleSaveEvent=function(e){if(!this._bDesignTimeMode){var t=e.getSource();var a=e.getParameters();return this._handleSave(t,a)}return Promise.resolve()};N.prototype._handleSave=function(e,t){var a=D.getAppComponentForControl(e);var n=this.getLocalId(e.getId(),a);var r;return E(function(e,t,a){var n=this.getCurrentVariantReference(e);var o=m.getControlChangesForVariant({reference:this.sFlexReference,vmReference:e,vReference:n});if(a.overwrite){r=this._getDirtyChangesFromVariantChanges(o);if(this.getVariant(n,e).layer===y.PUBLIC){r.forEach(e=>e.setLayer(y.PUBLIC))}return this.oFlexController.saveSequenceOfDirtyChanges(r,t).then(function(e){this.invalidateMap();return e}.bind(this))}var s=a.layer||(a.public?y.PUBLIC:y.USER);var l=a.layer||y.USER;var h=a.newVariantReference||D.createDefaultFileName("flVariant");var f={variantManagementReference:e,appComponent:t,layer:s,title:a.name,contexts:a.contexts,sourceVariantReference:n,newVariantReference:h,generator:a.generator,additionalVariantChanges:[],adaptationId:B(l,t,this.sFlexReference)};var u={content:{},reference:this.sFlexReference,generator:f.generator,layer:l,adaptationId:f.adaptationId};if(a.def){var p=i({changeType:"setDefault",content:{defaultVariant:h},fileType:"ctrl_variant_management_change",selector:c.getSelector(e,f.appComponent)},u);f.additionalVariantChanges.push(d.createUIChange(p))}if(a.execute){var g=i({changeType:"setExecuteOnSelect",content:{executeOnSelect:true},fileType:"ctrl_variant_change",selector:c.getSelector(f.newVariantReference,f.appComponent)},u);f.additionalVariantChanges.push(d.createUIChange(g))}return this.copyVariant(f).then(function(a){r=a;return P({changes:o,vmReference:e,vReference:n,model:this}).then(z.bind(this,this.oFlexController,r,e,t))}.bind(this))}.bind(this,n,a,t),this).then(function(){return r})};N.prototype.getLocalId=function(e,t){return c.getSelector(e,t).id};N.prototype.getVariantManagementReferenceForControl=function(e){var t=e.getId();var a=D.getAppComponentForControl(e);return a&&a.getLocalId(t)||t};N.prototype.switchToDefaultForVariantManagement=function(e){if(this.oData[e].currentVariant!==this.oData[e].defaultVariant){l.show(200);this.updateCurrentVariant({variantManagementReference:e,newVariantReference:this.oData[e].defaultVariant}).then(function(){l.hide()})}};N.prototype.switchToDefaultForVariant=function(e){Object.keys(this.oData).forEach(function(t){if(!e||this.oData[t].currentVariant===e){this.switchToDefaultForVariantManagement(t)}}.bind(this))};function q(e,t){this.oData[t].variants.forEach(function(a){var n=a.title&&a.title.match(/{(\w+)>(\w.+)}/);if(n){var r=n[1];var i=n[2];var o=e.getModel(r);if(o){var s=o.getResourceBundle().getText(i);var c={variantReference:a.key,changeType:"setTitle",title:s,layer:a.layer,appComponent:this.oAppComponent};var l=this.createVariantChange(t,c);m.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),l)}else{e.attachEventOnce("modelContextChange",q.bind(this,e,t))}}}.bind(this))}N.prototype.registerToModel=function(e){var t=this.getVariantManagementReferenceForControl(e);this._ensureStandardVariantExists(t);this.oData[t]._isEditable=e.getEditable();this.oData[t].showExecuteOnSelection=false;q.call(this,e,t);e.attachEvent("select",{vmReference:t,model:this},M);e.attachSave(this._handleSaveEvent,this);this.setModelPropertiesForControl(t,false,e);var a=e.getUpdateVariantInURL();this.oData[t].updateVariantInURL=a;g.registerControl({vmReference:t,updateURL:!!a,model:this});g.handleModelContextChange({model:this,vmControl:e});if(this.oData[t].initPromise){this.oData[t].initPromise.resolveFunction();delete this.oData[t].initPromise}this.oData[t].init=true;var n={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:t,flexController:this.oFlexController};this._oVariantSwitchPromise=this._oVariantSwitchPromise.then(m.waitForInitialVariantChanges.bind(undefined,n))};N.prototype.waitForVMControlInit=function(e){if(!this.oData[e]){this.oData[e]={}}else if(this.oData[e].init){return Promise.resolve()}this.oData[e].initPromise={};this.oData[e].initPromise.promise=new Promise(function(t){this.oData[e].initPromise.resolveFunction=t}.bind(this));return this.oData[e].initPromise.promise};N.prototype._getDirtyChangesFromVariantChanges=function(e){var t=e.map(function(e){return e.getId()});return this.oChangePersistence.getDirtyChanges().filter(function(e){return n(t,e.getId())&&!e.getSavedToVariant()})};N.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(e,t){return e.concat([this.oData[t].currentVariant])}.bind(this),[])};N.prototype.getVariantManagementControlIds=function(){var e;return Object.keys(this.oData||{}).reduce(function(t,a){if(this.oAppComponent.byId(a)){e=this.oAppComponent.createId(a)}else{e=a}t.push(e);return t}.bind(this),[])};N.prototype.destroy=function(){this.oDataSelector.removeUpdateListener(this.fnUpdateListener);m.clearRuntimeSteadyObjects(this.sFlexReference,this.oAppComponent.getId());m.resetCurrentVariantReference(this.sFlexReference);I.prototype.destroy.apply(this)};N.prototype.getUShellService=function(e){return D.getUshellContainer()&&F[e]};return N});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/Storage", ["sap/base/util/ObjectPath","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/write/_internal/StorageFeaturesMerger","sap/ui/VersionInfo"],function(e,t,n,r,a){"use strict";var i="sap/ui/fl/write/_internal/connectors/";function o(){return n.getConnectors(i,false)}function s(e,t){var n=t.filter(function(t){return t.layers.indexOf("ALL")!==-1||t.layers.indexOf(e)!==-1});if(n.length===1){return n[0]}if(n.length===0){throw new Error(`No Connector configuration could be found to write into layer: ${e}`)}if(n.length>1){throw new Error(`sap.ui.core.Configuration 'flexibilityServices' has a misconfiguration: Multiple `+`Connector configurations were found to write into layer: ${e}`)}return undefined}function u(e){var t=e.map(function(e){return e.writeConnectorModule.loadFeatures({url:e.url}).then(function(t){return{features:t,layers:e.layers}}).catch(n.logAndResolveDefault.bind(null,{features:{},layers:e.layers},e,"loadFeatures"))});return Promise.all(t)}function c(e){if(!e){return Promise.reject("No layer was provided")}return o().then(s.bind(this,e))}function d(e){if(e.draft){return new Promise(function(t,n){sap.ui.require(["sap/ui/fl/write/api/FeaturesAPI"],function(r){r.isVersioningEnabled(e.layer).then(function(r){if(r){t()}else{n(`Draft is not supported for the given layer: ${e.layer}`)}})})})}return Promise.resolve()}function l(e,n){var r=n.filter(function(n){return n.getState()===t.LifecycleState.NEW&&n.getFileType()===e.getFileType()});var a=r.findIndex(function(t){return t.getId()===e.getId()});return a}async function f(e){var n;if(e.allChanges&&e.allChanges.length&&e.condensedChanges){await g(e.condensedChanges);n={namespace:e.allChanges[0].convertToFileContent().namespace,layer:e.layer};var r=0;var a=false;e.allChanges.forEach(function(i,o){var s=i.getFileType();var u=l(i,e.condensedChanges);if(i.condenserState){var c=false;if(i.condenserState==="delete"){if(i.getState()===t.LifecycleState.PERSISTED||i.getState()===t.LifecycleState.DELETED){n.delete||={};n.delete[s]||=[];n.delete[s].push(i.getId())}r++}else if(e.condensedChanges.length){c=e.allChanges[o].getId()!==e.condensedChanges[o-r].getId()}if((i.condenserState==="select"&&i.getState()!==t.LifecycleState.NEW||i.condenserState==="update")&&c&&!a){var d=e.condensedChanges.slice(o-r).map(function(e){return e.getId()});n.reorder||={};n.reorder[s]||=[];n.reorder[s]=d;a=true}if(i.condenserState==="select"&&i.getState()===t.LifecycleState.NEW){n.create||={};n.create[s]||=[];n.create[s][u]={};n.create[s][u][i.getId()]=i.convertToFileContent()}else if(i.condenserState==="update"){n.update||={};n.update[s]||=[];var f=n.update[s].length;n.update[s][f]={};n.update[s][f][i.getId()]={content:i.getContent()}}delete i.condenserState}else if(i.getState()===t.LifecycleState.NEW){n.create||={};n.create[s]||=[];n.create[s][u]={};n.create[s][u][i.getId()]=i.convertToFileContent()}})}return n}async function g(e){const t=await a.load();const n=t.version;e.forEach(e=>{if(e.isA&&e.isA("sap.ui.fl.apply._internal.flexObjects.FlexObject")){const t=e.getSupportInformation();t.sapui5Version||=n;e.setSupportInformation(t)}else{e.support||={};e.support.sapui5Version||=n}})}function p(t,n){return d(n).then(c.bind(undefined,n.layer)).then(function(r){n.url=r.url;var a=e.get(t,r.writeConnectorModule);return a.call(r.writeConnectorModule,n)})}var h={};h.write=async function(e){await g(e.flexObjects);return p("write",e)};h.condense=async function(e){const t=Object.assign({},e);const n=await f(t);if(!n){return Promise.reject("No changes were provided")}if(n.create||n.reorder||n.update||n.delete){var r=[];if(n.create){r=(n.create.change?n.create.change:[]).concat(n.create.ctrl_variant?n.create.ctrl_variant:[])}t.flexObjects=n;const e=await p("condense",t);if(e&&e.status&&e.status===205&&r.length){var a=r.map(function(e){return Object.values(e).pop()});e.response=a}return e}return undefined};h.remove=function(e){return p("remove",e)};h.update=function(e){return p("update",e)};h.reset=function(e){return p("reset",e)};h.getFlexInfo=function(e){return p("getFlexInfo",e)};h.getContexts=function(e){return p("getContexts",e)};h.loadContextDescriptions=function(e){return p("loadContextDescriptions",e)};h.isContextSharingEnabled=function(e){return p("isContextSharingEnabled",e)};h.loadFeatures=function(){return o().then(u).then(r.mergeResults)};h.publish=function(e){return p("publish",e)};h.contextBasedAdaptation={create(e){return o().then(p.bind(undefined,"contextBasedAdaptation.create",e))},reorder(e){return o().then(p.bind(undefined,"contextBasedAdaptation.reorder",e))},update(e){return o().then(p.bind(undefined,"contextBasedAdaptation.update",e))},load(e){return o().then(p.bind(undefined,"contextBasedAdaptation.load",e))},remove(e){return o().then(p.bind(undefined,"contextBasedAdaptation.remove",e))}};h.versions={load(e){return o().then(p.bind(undefined,"versions.load",e))},activate(e){return o().then(p.bind(undefined,"versions.activate",e))},discardDraft(e){return o().then(p.bind(undefined,"versions.discardDraft",e))},publish(e){return o().then(p.bind(undefined,"versions.publish",e))}};h.translation={getSourceLanguages(e){return o().then(p.bind(undefined,"translation.getSourceLanguages",e))},getTexts(e){return o().then(p.bind(undefined,"translation.getTexts",e))},postTranslationTexts(e){return o().then(p.bind(undefined,"translation.postTranslationTexts",e))}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/StorageFeaturesMerger", ["sap/base/util/merge"],function(e){"use strict";var n={isKeyUser:false,isKeyUserTranslationEnabled:false,isVariantSharingEnabled:false,isPublicFlVariantEnabled:false,isVariantPersonalizationEnabled:true,isContextSharingEnabled:true,isAtoAvailable:false,isAtoEnabled:false,versioning:{},isProductiveSystem:true,isPublicLayerAvailable:false,isLocalResetEnabled:false,isZeroDowntimeUpgradeRunning:false,system:"",client:""};function i(e){var n={};var i=!!e.features.isVersioningEnabled;e.layers.forEach(function(e){n[e]=i});return n}return{mergeResults(a){var s=n;a.forEach(function(n){Object.keys(n.features).forEach(function(e){if(e!=="isVersioningEnabled"){s[e]=n.features[e]}});s.versioning=e(s.versioning,i(n));if(n.isContextSharingEnabled!==undefined){s.isContextSharingEnabled=n.isContextSharingEnabled}});return s}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/Versions", ["sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/Storage","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode"],function(e,r,t,n,i,s,a){"use strict";var o={};var f=9;var l=f+1;function d(e,r){return c(e,r).then(function(e){e.setDefaultBindingMode(a.OneWay);e.setSizeLimit(f);e.setDirtyChanges=function(r){e.setProperty("/dirtyChanges",r);e.updateDraftVersion();e.updateBindings(true)};e.updateDraftVersion=function(){var r=e.getProperty("/versions");var n=e.getProperty("/versioningEnabled");var i=e.getProperty("/dirtyChanges");var s=e.getProperty("/backendDraft");var a=n&&(i||s);e.setProperty("/draftAvailable",a);if(i){e.setProperty("/displayedVersion",t.Number.Draft)}if(!y(r)&&a){r.splice(0,0,{version:t.Number.Draft,type:t.Type.Draft,filenames:[],isPublished:false})}if(y(r)&&!a){r.shift();e.setProperty("/displayedVersion",e.getProperty("/persistedVersion"))}var o=e.getProperty("/displayedVersion")!==e.getProperty("/activeVersion");e.setProperty("/activateEnabled",o)};return e})}function u(e,r){if(r!==t.Number.Original&&r!==t.Number.Draft){return e.some(function(e){return e.version===r&&e.isPublished===false})}return false}function c(e,n,i){var a;var o=t.Number.Original;var f=y(n);var l=[];if(n.length>0){a=n[0].version}else{a=t.Number.Original}n.forEach(function(e){if(e.version===t.Number.Draft){e.type=t.Type.Draft;e.isPublished=false;l=e.filenames}else{if(o===t.Number.Original){e.type=t.Type.Active;o=e.version}else{e.type=t.Type.Inactive}}});if(i){i.setProperty("/publishVersionEnabled",u(n,a));i.setProperty("/versioningEnabled",e);i.setProperty("/versions",n);i.setProperty("/backendDraft",f);i.setProperty("/dirtyChanges",false);i.setProperty("/draftAvailable",f);i.setProperty("/activateEnabled",f);i.setProperty("/activeVersion",o);i.setProperty("/persistedVersion",a);i.setProperty("/displayedVersion",a);i.setProperty("/draftFilenames",l);i.updateBindings(true)}else{i=r.getUShellService("URLParsing").then(function(i){var d=r.getParameter(t.UrlParameter,i);return new s({publishVersionEnabled:u(n,d||a),versioningEnabled:e,versions:n,backendDraft:f,dirtyChanges:false,draftAvailable:f,activateEnabled:f,activeVersion:o,persistedVersion:d||a,displayedVersion:d||a,draftFilenames:l})})}return i}function p(e,r){var t=[];var n=r.changePersistences;n.forEach(function(e){t=e.getDirtyChanges().concat();e.deleteChanges(t,true)});return t.length>0}function v(r){var t={dirtyChangesExist:false,changePersistences:[]};if(r.reference){var n=e.getChangePersistenceForComponent(r.reference);if(n.getDirtyChanges().length>0){t.dirtyChangesExist=true;t.changePersistences.push(n)}}if(r.nonNormalizedReference){var i=e.getChangePersistenceForComponent(r.nonNormalizedReference);if(i.getDirtyChanges().length>0){t.dirtyChangesExist=true;t.changePersistences.push(i)}}return t}function y(e){return e.some(function(e){return e.version===t.Number.Draft})}function g(e,r){e.setProperty("/backendDraft",false);e.setProperty("/dirtyChanges",false);e.setProperty("/draftAvailable",false);e.setProperty("/activateEnabled",false);e.setProperty("/displayedVersion",r);e.setProperty("/persistedVersion",r);e.updateBindings(true)}var h={};h.initialize=function(e){var r=e.reference;var t=e.layer;e.limit=l;return n.getInstance().then(function(n){var s=n.isVersioningEnabled(t);if(o&&o[r]&&o[r][t]){return o[r][t]}var a=s?i.versions.load(e):Promise.resolve([]);return a.then(function(e){return d(s,e)}).then(function(e){o[r]||={};o[r][t]||={};o[r][t]=e;return o[r][t]})})};h.getVersionsModel=function(e){var r=e.reference;var t=e.layer;if(!h.hasVersionsModel(e)){throw Error(`Versions Model for reference '${r}' and layer '${t}' were not initialized.`)}var n=v(e);if(n.dirtyChangesExist){o[r][t].updateDraftVersion(e)}return o[r][t]};h.hasVersionsModel=function(e){var r=e.reference;var t=e.layer;return!!(o[r]&&o[r][t])};h.clearInstances=function(){o={}};h.updateModelFromBackend=function(e){if(h.hasVersionsModel(e)&&h.getVersionsModel(e).getProperty("/versioningEnabled")){e.limit=l;return i.versions.load(e).then(function(r){var t=h.getVersionsModel(e);return c(t.getProperty("/versioningEnabled"),r,t)})}return undefined};h.onAllChangesSaved=function(e){var r=h.getVersionsModel(e);var n=r.getProperty("/versioningEnabled");var i=r.getProperty("/dirtyChanges");var s=r.getProperty("/draftFilenames");r.setProperty("/draftFilenames",s.concat(e.draftFilenames));r.setProperty("/dirtyChanges",true);r.setProperty("/backendDraft",n&&i||!!e.contextBasedAdaptation);r.updateDraftVersion();r.setProperty("/persistedVersion",t.Number.Draft);r.updateBindings(true)};h.activate=function(e){var r=h.getVersionsModel(e);var n=r.getProperty("/versions");var s=y(n);var a=r.getProperty("/activeVersion");if(e.displayedVersion===a){return Promise.reject("Version is already active")}e.version=e.displayedVersion;var o=v(e);var f=o.changePersistences;var l=f.some(function(e){return e.getDirtyChanges().length>0});if(l){return Promise.reject("unsaved changes exists")}return i.versions.activate(e).then(function(e){n.forEach(function(e){e.type=t.Type.Inactive});e.type=t.Type.Active;e.isPublished=false;if(s){n.shift()}n.splice(0,0,e);r.setProperty("/activeVersion",e.version);r.setProperty("/publishVersionEnabled",true);r.setProperty("/draftFilenames",[]);g(r,e.version)})};h.discardDraft=function(e){var r=h.getVersionsModel(e);var t=v(e);var n=r.getProperty("/backendDraft");var s=n?i.versions.discardDraft(e):Promise.resolve();return s.then(function(){var i=r.getProperty("/versions");i.shift();g(r,r.getProperty("/activeVersion"));var s=p(e,t);return{backendChangesDiscarded:n,dirtyChangesDiscarded:s}})};h.publish=function(e){var r=h.getVersionsModel({reference:e.reference,layer:e.layer});return i.versions.publish(e).then(function(t){if(t!=="Error"&&t!=="Cancel"){r.setProperty("/publishVersionEnabled",false);var n=r.getProperty("/versions");var i=false;n.forEach(function(r){if(r.isPublished){return}if(r.version===e.version){i=true}if(i&&!r.isPublished){r.isPublished=true}})}return t})};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/Condenser", ["sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexObjects/UIChange","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/write/_internal/condenser/classifications/LastOneWins","sap/ui/fl/write/_internal/condenser/classifications/Reverse","sap/ui/fl/write/_internal/condenser/classifications/Update","sap/ui/fl/write/_internal/condenser/UIReconstruction","sap/ui/fl/write/_internal/condenser/Utils","sap/ui/fl/Utils","sap/ui/performance/Measurement","sap/base/util/restricted/_isEqual"],function(e,n,t,r,a,i,o,s,c,f,u,d,l,p,g,h,C,v){"use strict";var E={};var S="unclassified";var y={lastOneWins:u,reverse:d,update:l};var _=["affectedControl","sourceContainer","targetContainer","updateControl"];function I(e,n){var t=e[o.Move];return n.classification===o.Create&&t&&t[t.length-1].targetContainer===n.targetContainer}function N(e,n){return n.classification===o.Move&&e[o.Destroy]}function m(e,n){return n.classification===o.Create&&e[o.Destroy]}function T(e,n,t,r){if(!N(e,t)&&!m(e,t)){var a=t.classification;if(!e[a]){t.change=r;r.condenserState="select";e[a]=[t]}else{r.condenserState="delete"}e[a][0].updateChange=r}else{r.condenserState="delete"}if(I(e,t)||m(e,t)){if(e[o.Move]){e[o.Move].forEach(function(e){e.change.condenserState="delete"});delete e[o.Move]}if(e[o.Destroy]){e[o.Destroy].forEach(function(e){e.change.condenserState="delete"});delete e[o.Destroy]}}return p.addChange(n,t)}function D(e,n,t){e[n.classification]||={};var r=e[n.classification];y[n.classification].addToChangesMap(r,n,t);return Promise.resolve()}function O(e,n,t,r,a){e[r.type]||={};var i=e[r.type];if(r.type===g.NOT_INDEX_RELEVANT){return D(i,r,a)}t.push(a);i[r.targetAggregation]||={};return T(i[r.targetAggregation],n,r,a)}function A(e,n,t){e[n]||=[];e[n].push(t);t.condenserState="select"}function R(e,n){var t=a.getControlIdBySelector(n.getSelector(),e);var r=i.getElementById(t);if(r){var o={modifier:a,appComponent:e,view:h.getViewForControl(r)};var c=s.getControlIfTemplateAffected(n,r,o);return Promise.resolve(s.getChangeHandler(n,c,o)).then(function(e){if(e&&typeof e.getCondenserInfo==="function"){return e.getCondenserInfo(n,o)}return undefined}).then(function(e){if(e&&c.bTemplateAffected){L(e,n)}return e}).catch(function(){return undefined})}return Promise.resolve()}function L(e,n){var t=n.getOriginalSelector();var r=n.getSelector();_.forEach(function(n){if(e[n]&&e[n]===r){e[n]=t}})}function x(e,n,r,i){var s=n!==undefined?n.affectedControl:a.getControlIdBySelector(r.getSelector(),i);e[s]||={};if(n&&n.updateControl){var c=n.updateControl;var f=[g.NOT_INDEX_RELEVANT,o.Update,n.uniqueKey];var u=t.get(f,e[c]);if(u){t.set(f,u,e[s]);delete e[c][g.NOT_INDEX_RELEVANT][o.Update][n.uniqueKey]}}return e[s]}function b(e,n,t,r,a){return a.reduce(function(a,i){return a.then(M.bind(this,e,n,t,r,i))}.bind(this),Promise.resolve())}function M(e,n,t,r,a){return R(e,a).then(function(i){w(i,e);var o=x(n,i,a,e);if(i!==undefined){U(i);return O(o,t,r,i,a).then(function(){if(i.update){V(o,i,a)}})}A(o,S,a);n[S]=true;return undefined})}function U(e){if(y[e.classification]){e.type=g.NOT_INDEX_RELEVANT}else{e.type=g.INDEX_RELEVANT}}function w(e,n){_.forEach(function(t){if(e&&e[t]){e[t]=a.getControlIdBySelector(e[t],n)}})}function V(e,n,r){var a=[g.NOT_INDEX_RELEVANT,o.Update,n.uniqueKey];var i=t.get(a,e);if(i){i.change.condenserState="delete";if(r.condenserState==="delete"){return}if(r.isPersisted()){r.condenserState="update"}n.update(r,i.updateContent);r.setState(f.LifecycleState.DIRTY);delete e[g.NOT_INDEX_RELEVANT][o.Update][n.uniqueKey]}}function P(t,r){e(t,function(e,a){if(y[e]&&y[e].getChangesFromMap){y[e].getChangesFromMap(t,e).forEach(function(e){r.push(e)})}else if(n(a)){return P(a,r)}else if(Array.isArray(a)){a.forEach(function(e){if(e instanceof c){r.push(e)}else{r.push(e.change)}})}});return r}function X(e){return P(e,[])}function q(t,r){e(t,function(e,t){if(n(t)){q(t,r)}else if(Array.isArray(t)){t.forEach(function(e){if(!(e instanceof c)){r.push(e)}})}});return r}function j(e,n){n.sort(function(n,t){return e.indexOf(n)-e.indexOf(t)})}function B(e,n){n.sort(function(n,t){return e.indexOf(n.change)-e.indexOf(t.change)})}function K(e,n){var t=e.map(function(e){return e.getId()});n.forEach(function(n){if(t.indexOf(n.getId())===-1){e.push(n)}})}function F(e,n,t){e.forEach(function(e){var r=e.updateChange;if(r&&!v(r.getContent(),e.change.getContent())&&r.getState()!==f.LifecycleState.NEW){var a=e.change;if(r.getId()!==a.getId()){var i=a.getContent();r.setContent(i);r.setRevertData(a.getRevertData());a.condenserState="delete";n=n.map(function(e){if(e.getId()===a.getId()){return r}return e});t.forEach(function(e,n){t[n]=e.map(function(e){if(e.getId()===a.getId()){return r}return e})})}else{r.setState(f.LifecycleState.DIRTY)}r.condenserState="update"}});return n}E.condense=function(e,n){C.start("Condenser_overall","Condenser overall - CondenserClass",["sap.ui.fl","Condenser"]);var t={};var a={};var i=[];var o=[];var s=[];n.slice(0).reverse().forEach(function(e){if(e instanceof c){if(e.getState()===f.LifecycleState.DELETED){e.condenserState="delete"}else if(e.isSuccessfullyApplied()){s.push(e)}else{o.push(e)}}else{o.push(e)}});C.start("Condenser_defineMaps","defining of maps - CondenserClass",["sap.ui.fl","Condenser"]);return b(e,t,a,i,s).then(function(){C.end("Condenser_defineMaps");var e=t[S];if(!e){p.compareAndUpdate(t,a)}var s=X(t);if(e){i.forEach(function(e){if(e.condenserState!=="update"){e.condenserState="select"}});K(s,i)}s=s.concat(o);j(n,s);if(!e){C.start("Condenser_handleIndexRelatedChanges","handle index related changes - CondenserClass",["sap.ui.fl","Condenser"]);var c=true;var f=q(t,[]);B(n,f);var u;try{C.start("Condenser_sort","sort index related changes - CondenserClass",["sap.ui.fl","Condenser"]);u=p.sortIndexRelatedChanges(a,f)}catch(e){r.error(`Error during Condensing: ${e.message}`,"No Condensing performed for index-relevant changes.");c=false}C.end("Condenser_sort");if(c){s=s.filter(function(e){return e.condenserState!=="delete"});f=f.filter(function(e){return e.change.condenserState!=="delete"});s=F(f,s,u);j(n,s);u.forEach(function(e){p.swapChanges(e,s)})}else{i.forEach(function(e){e.condenserState="select"});K(s,i);j(n,s)}C.end("Condenser_handleIndexRelatedChanges")}C.end("Condenser_overall");return s})};return E});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/UIReconstruction", ["sap/base/util/restricted/_isEqual","sap/base/util/each","sap/base/util/ObjectPath","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/write/_internal/condenser/classifications/Create","sap/ui/fl/write/_internal/condenser/classifications/Destroy","sap/ui/fl/write/_internal/condenser/classifications/Move","sap/ui/fl/write/_internal/condenser/Utils"],function(n,e,t,r,i,a,c,o){"use strict";var f={};var s={create:i,destroy:a,move:c};function u(n,t){e(n,function(n,r){e(r,function(e,i){t(r,n,i,e)})})}function l(n,e,t){n.splice(t,0,n.splice(e,1)[0])}function h(n,e){var t={};u(n,function(n,r,i,a){var c=i[o.TARGET_UI];var f=i[o.INITIAL_UI];e.forEach(function(n){var e=c.indexOf(n.affectedControl)>-1||f.indexOf(n.affectedControl)>-1;if(a===n.targetAggregation&&e){t[r]||={};var i=t[r];i[a]||=[];var o=i[a];o.push(n)}})});return t}function d(n){return!n.some(function(n){return n.classification!==r.Create})}function v(n){return!n.some(function(n){return o.isUnknown(n)})}function g(n){return n.getTargetIndex(n.change)}function I(n){n.sort(function(n,e){var t=g(n);var r=g(e);return t-r})}function E(n){return!n.some(function(n){return!o.isUnknown(n)})}function T(e,t){var r;if(e.length<t.length){r=t.slice(e.length);if(!E(r)){return false}t=t.slice(0,e.length)}else if(e.length>t.length){r=e.slice(t.length,e.length);if(!E(r)){return false}e=e.slice(0,t.length)}return n(e,t)}function p(n,e,t,r,i){var a={};i.forEach(function(n){var r=n.targetContainer;a[r]||={};var i=a[r];i[e]||=o.initializeArrayWithPlaceholders(0,t.length-1);s[n.classification].simulate(i[e],n,t)});var c=a[n][e];if(T(r,c)){i.forEach(function(n){if(n.sameIndex){n.change.condenserState="delete"}});return true}return false}function _(n,e){function t(n,e){if(g(e)!==n){var t=e.change.getState();e.setTargetIndex(e.change,n);e.change.setState(t);if(e.change.isPersisted()){e.change.condenserState="update"}}}function i(e,i,a){a[o.TARGET_UI].forEach(function(e,i){if(!o.isUnknown(e)){var a=n[e];var c=a[o.INDEX_RELEVANT];u(c,function(n,e,a,c){if(c!==r.Destroy){a.forEach(t.bind(this,i))}})}})}u(e,i)}function A(n,e){u(e,function(e,t,r,i){var a=r[o.INITIAL_UI];var c=r[o.TARGET_UI];if(T(a,c)){c.forEach(function(e){var t=n[e];if(t!==undefined){u(t[o.INDEX_RELEVANT],function(n,e,t){t.forEach(function(n){n.change.condenserState="delete"})});delete t[o.INDEX_RELEVANT]}});delete e[i]}})}function U(n,e){u(e,function(e,r,i,a){var c=i[o.INITIAL_UI];var f=i[o.TARGET_UI];c.forEach(function(e,r){var i=n[e];if(!i||!t.get([o.INDEX_RELEVANT,a],i)){var c=o.PLACEHOLDER+r;var s=f.indexOf(e);if(s>=0){f[s]=c}}})})}f.swapChanges=function(n,e){var t=n.map(function(n){return e.indexOf(n)}).sort();n.forEach(function(n){e[t.shift()]=n})};f.sortIndexRelatedChanges=function(n,e){var t=[];var r=h(n,e);u(r,function(e,r,i,a){var c=n[r][a][o.TARGET_UI];var f=n[r][a][o.INITIAL_UI];var s=true;if(v(c)||d(i)){I(i);s=p(r,a,f,c,i)}else if(!p(r,a,f,c,i)){s=false;var u=i.length;while(u!==0&&!s){var h=0;var g=1;while(g<i.length&&!s){l(i,h,g);s=p(r,a,f,c,i);h++;g++}u--}}if(!s){throw Error(`no correct sorting found for the container: ${r}`)}i=i.filter(function(n){return n.change.condenserState!=="delete"});t.push(i.map(function(n){if(n.revertIndex>-1){n.setIndexInRevertData(n.change,n.revertIndex);n.sourceIndex=n.revertIndex}return n.change}))});return t};f.addChange=function(n,e){return s[e.classification].addToReconstructionMap(n,e)};f.compareAndUpdate=function(n,e){A(n,e);U(n,e);_(n,e)};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/Utils", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element"],function(e,n){"use strict";var t={};t.TARGET_UI="targetUI";t.INITIAL_UI="initialUI";t.PLACEHOLDER="X";t.INDEX_RELEVANT="indexRelevant";t.NOT_INDEX_RELEVANT="notIndexRelevant";function r(e,n){return(Math.max(e,n)||0)+1}t.getInitialUIContainerElementIds=function(e,n,r,i){e[n]||={};var a=e[n];a[r]||={};var l=a[r];l[t.TARGET_UI]||=i;l[t.INITIAL_UI]||=i.slice(0);return l[t.INITIAL_UI]};t.getContainerElementIds=function(t,r,i,a){var l=n.getElementById(t);return Promise.resolve(i||e.getAggregation(l,r)).then(function(e){return e.map(function(e){return a?e[a]:e.getId()})})};t.initializeArrayWithPlaceholders=function(e,n){var i=r(n,e);return Array(i).fill(t.PLACEHOLDER).map(function(e,n){return e+n})};t.extendArrayWithPlaceholders=function(e,n,i){var a=r(n,i);if(e.length<a){var l;for(var f=e.length;f<=a;f++){l=t.PLACEHOLDER+e.length;e.splice(e.length,0,l)}}};t.extendElementsArray=function(e,n,r,i){t.extendArrayWithPlaceholders(e,n,r);var a=e.indexOf(i);var l=e.indexOf(t.PLACEHOLDER+n);if(a!==n&&n!==undefined){if(a>=0){t.shiftElement(e,a,n)}else if(l>-1){e[l]=i}else if(t.isUnknown(e[n])){e[n]=i}}};t.shiftElement=function(e,n,t){e.splice(t,0,e.splice(n,1)[0])};t.isUnknown=function(e){if(e!==undefined&&e.indexOf(t.PLACEHOLDER)===0){var n=e.slice(1,e.length);var r=parseInt(n);if(isNaN(r)){return false}return true}return false};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Create", ["sap/ui/core/Element","sap/ui/fl/write/_internal/condenser/Utils"],function(e,t){"use strict";return{addToReconstructionMap(n,r){var a=e.getElementById(r.affectedControl);var i=r.targetAggregation||a&&a.sParentAggregationName;return t.getContainerElementIds(r.targetContainer,i,r.customAggregation,r.affectedControlIdProperty).then(function(e){var a=t.getInitialUIContainerElementIds(n,r.targetContainer,r.targetAggregation,e);var i=a.indexOf(r.affectedControl);if(i>-1){a.splice(i,1)}})},simulate(e,t){e.splice(t.getTargetIndex(t.change),0,t.affectedControl)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Destroy", ["sap/ui/fl/write/_internal/condenser/Utils"],function(e){"use strict";return{addToReconstructionMap(t,n){return e.getContainerElementIds(n.targetContainer,n.targetAggregation,n.customAggregation,n.affectedControlIdProperty).then(function(r){var i=e.getInitialUIContainerElementIds(t,n.targetContainer,n.targetAggregation,r);if(i.length-1<n.sourceIndex){while(i.length-1<n.sourceIndex){var o=i.length;i.splice(i.length,0,e.PLACEHOLDER+o)}i[n.sourceIndex]=n.affectedControl}else{i.splice(n.sourceIndex,0,n.affectedControl)}})},simulate(t,n,r){var i=t.indexOf(n.affectedControl);if(i===-1){var o=e.PLACEHOLDER+r.indexOf(n.affectedControl);i=t.indexOf(o)}n.revertIndex=i;if(i>-1){t.splice(i,1)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/LastOneWins", [],function(){"use strict";return{addToChangesMap(e,n,t){if(!e[n.uniqueKey]){e[n.uniqueKey]=[t];t.condenserState="select"}else{t.condenserState="delete"}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Move", ["sap/ui/fl/write/_internal/condenser/Utils"],function(e){"use strict";return{addToReconstructionMap(t,n){return Promise.all([e.getContainerElementIds(n.sourceContainer,n.sourceAggregation,n.customAggregation,n.affectedControlIdProperty),e.getContainerElementIds(n.targetContainer,n.targetAggregation,n.customAggregation,n.affectedControlIdProperty)]).then(function(r){var a=r[0];var i=r[1];var o;var g;if(n.targetContainer===n.sourceContainer&&n.targetAggregation===n.sourceAggregation){o=e.getInitialUIContainerElementIds(t,n.targetContainer,n.targetAggregation,i);g=o.indexOf(n.affectedControl);e.shiftElement(o,g,n.sourceIndex)}else{o=e.getInitialUIContainerElementIds(t,n.targetContainer,n.targetAggregation,i);g=o.indexOf(n.affectedControl);o.splice(g,1);o=e.getInitialUIContainerElementIds(t,n.sourceContainer,n.sourceAggregation,a);o.splice(n.sourceIndex,0,n.affectedControl)}})},simulate(t,n,r){var a=n.affectedControl;var i=r.indexOf(a);e.extendElementsArray(t,i,undefined,a);var o=t.indexOf(a);var g=n.getTargetIndex(n.change);if(i===-1){t.splice(g,0,a)}else{t.splice(g,0,t.splice(o,1)[0])}n.sameIndex=o===g;n.revertIndex=o}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Reverse", ["sap/base/util/each"],function(e){"use strict";return{addToChangesMap(e,n,t){e[n.uniqueKey]||=[];e[n.uniqueKey].push(t)},getChangesFromMap(n,t){var a=[];e(n[t],function(e,n){n.reverse();var t;n.forEach(function(e,a){if(t&&t.getChangeType()!==e.getChangeType()){t=null;n[a].condenserState="delete";n[a-1].condenserState="delete"}else{t=e;if(a>0){n[a-1].condenserState="delete"}n[a].condenserState="select"}});if(t){a.push(t)}});return a}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/condenser/classifications/Update", ["sap/base/util/each"],function(e){"use strict";return{addToChangesMap(e,n,a){if(!e[n.uniqueKey]){n.change=a;e[n.uniqueKey]=n;a.condenserState="select"}else{a.condenserState="delete"}},getChangesFromMap(n,a){var t=[];e(n[a],function(e,n){t.push(n.change)});return t}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/extensionPoint/Registry", ["sap/ui/base/ManagedObjectObserver","sap/ui/fl/Utils"],function(e,t){"use strict";var n={};var r={};var a={};var o={};var i={};function g(e){var t=e.object.getId();a[t].forEach(function(e){o[e.view.getId()][e.name].bParentIsDestroyed=true})}function s(e){var n=e.object.getId();a[n].forEach(function(n){var r=n.aggregationName;if(r===e.name){var a=t.getAggregation(e.object,r);var o=[].concat(a||[]).map(function(e){return e.getId()});if(e.mutation==="insert"){if(o.indexOf(e.child.getId())<n.index){n.index++}}else{if(Array.isArray(n.defaultContent)){n.defaultContent=n.defaultContent.filter(function(t){return t.getId()!==e.child.getId()})}if(Array.isArray(n.createdControls)){n.createdControls=n.createdControls.filter(function(t){return t!==e.child.getId()})}if(n.aggregation.indexOf(e.child.getId())<n.index){n.index--}}n.aggregation=o}})}function d(e){if(e.type==="destroy"){g(e)}else{s(e)}}function c(t,n){var a=t.getId();if(!r[a]){var o=new e(d.bind(this));o.observe(t,{aggregations:[n],destroy:true});r[a]={observer:o,aggregations:[n]}}else{var i=r[a].observer.isObserved(t,{aggregations:[n]});if(!i){r[a].aggregations.push(n);r[a].observer.observe(t,{aggregations:r[a].aggregations,destroy:true})}}}function f(e,n,r){var g=r.view.getId();var s=t.getAggregation(e,n);var d=[].concat(s||[]).map(function(e){return e.getId()});var c=e.getId();a[c]||=[];o[g]||={};r.aggregation=d;if(i[g]&&i[g][r.name]){r.createdControls=i[g][r.name];delete i[g][r.name]}a[c].push(r);o[g][r.name]=r}n.registerExtensionPoint=function(e){var t=e.targetControl;var n=e.aggregationName;c(t,n);f(t,n,e)};n.getExtensionPointInfo=function(e,t){return o[t.getId()]&&o[t.getId()][e]};n.getExtensionPointInfoByViewId=function(e){return o[e]||{}};n.getExtensionPointInfoByParentId=function(e){return a[e]||[]};n.clear=function(){Object.keys(r).forEach(function(e){r[e].observer.disconnect();r[e].observer.destroy()});r={};a={};o={}};n.addCreatedControls=function(e,t,n){var r;if(o[t]&&o[t][e]){r=o[t][e].createdControls||[];o[t][e].createdControls=r.concat(n)}else{i[t]||={};r=i[t][e]||[];i[t][e]=r.concat(n)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/flexState/FlexObjectState", ["sap/base/util/restricted/_omit","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/Versions","sap/ui/fl/FlexControllerFactory","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,t,r,n,a,i,o,l,c,s,f,u,p){"use strict";var g={};function y(e){e.reference=i.getFlexReferenceForControl(e.selector);return a.initialize({componentId:e.componentId||p.getAppComponentForControl(e.selector).getId(),reference:e.reference,componentData:{},manifest:{}})}function C(e){var t=a.getCompVariantsMap(e.reference);var n=[];if(e.invalidateCache){var i=a.getInitialNonFlCompVariantData(e.reference);if(i){Object.keys(i).forEach(function(e){t._initialize(e,i[e].variants,i[e].controlId);r.merge(e,t[e],i[e].standardVariant)})}}for(var o in t){var l=t[o];for(var c in l.byId){n.push(l.byId[c])}}return u.filterChangeOrChangeDefinitionsByCurrentLayer(n,e.currentLayer)}function h(e){var t=i.getFlexReferenceForControl(e.selector);return l.persistAll(t)}function v(e){e.reference||=i.getFlexReferenceForSelector(e.selector);return f.getChangePersistenceForComponent(e.reference)}function d(e,t){var r=p.getAppComponentForControl(t);var a=r.getModel(o.getVariantModelName());var i;if(a){var l=a&&a.sFlexReference;i=n.getVariantManagementReferences(l)}else{i=[]}if(i.length===0){return e}var c=i.map(function(e){return a.getCurrentVariantReference(e)});return e.filter(function(e){return e.getFileType()!=="change"||c.some(function(t){return e.getVariantReference()===t||!e.getVariantReference()})})}function F(t){var r=v(t);return r.getChangesForComponent(e(t,["invalidateCache","selector"]),t.invalidateCache).then(function(e){var n=[];if(t.includeDirtyChanges){n=r.getDirtyChanges();if(t.currentLayer){n=n.filter(function(e){return e.getLayer()===t.currentLayer})}}var a=e.concat(n);if(t.onlyCurrentVariants){return d(a,t.selector)}return a})}function m(e,t){var r=s.createForSelector(e.selector);return r.saveAll(t,e.skipUpdateCache,e.draft,e.layer,e.removeOtherLayerChanges,e.condenseAnyLayer)}g.getFlexObjects=function(e){return y(e).then(function(){return F(e)}).then(function(t){return C(e).concat(t)})};g.getDirtyFlexObjects=function(e){e.includeDirtyChanges=true;var r=v(e);var n=r.getDirtyChanges();var a=C(e);return n.concat(a).filter(function(e){return e.getState()!==t.LifecycleState.PERSISTED})};g.hasDirtyFlexObjects=function(e){var t=i.getFlexReferenceForSelector(e.selector);if(f.getChangePersistenceForComponent(t).getDirtyChanges().length>0){return true}return l.hasDirtyChanges(t)};g.saveFlexObjects=function(t){var r=p.getAppComponentForSelector(t.selector);t.reference=i.getFlexReferenceForControl(t.selector);return h(t).then(m.bind(this,t,r)).then(function(){if(t.version!==undefined&&c.hasVersionsModel(t)){var n=c.getVersionsModel(t);t.version=n.getProperty("/displayedVersion")}if(t.layer){t.currentLayer=t.layer}t.componentId=r.getId();t.invalidateCache=true;return g.getFlexObjects(e(t,"skipUpdateCache"))})};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState", ["sap/base/util/restricted/_omit","sap/base/util/restricted/_pick","sap/ui/core/Core","sap/ui/core/Element","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/flexObjects/CompVariant","sap/ui/fl/apply/_internal/flexObjects/CompVariantRevertData","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/RevertData","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexObjects/UpdatableChange","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/_internal/Versions"],function(e,t,n,a,r,i,o,s,c,p,u,f,l,d,v,g,y,C){"use strict";function S(e,t){var n=h("/draftFilenames",t);if(n){return e.getState()===u.LifecycleState.NEW||n.includes(e.getId())}return true}function h(e,t){var t={reference:t.reference,layer:t.layer};if(C.hasVersionsModel(t)){return C.getVersionsModel(t).getProperty(e)}return undefined}function m(e,t){var n=e.getFlexObjectMetadata?e.getFlexObjectMetadata().changeType:e.getChangeType();if(!["defaultVariant","updateVariant"].includes(n)){return false}var a=e.getLayer()===t.layer;var r=e.getFlexObjectMetadata().packageName;var i=!r||r==="$TMP";return a&&i&&S(e,t)}function V(e,t){if(t.isVariant&&t.isVariant()){return e.variants}var n=t.getChangeType();switch(n){case"defaultVariant":return e.defaultVariants;case"standardVariant":return e.standardVariants;default:return e.changes}}function x(e,t){for(var n=0;n<e.length;n++){if(e[n].fileName===t.fileName){e.splice(n,1,t);break}}}function O(e,t,n){return y.update({flexObject:e.convertToFileContent(),layer:e.getLayer(),transport:e.getRequest(),parentVersion:n}).then(function(t){if(t&&t.response){e.setResponse(t.response);if(n){C.onAllChangesSaved({reference:t.response.reference,layer:t.response.layer,draftFilenames:t.response.fileName})}}else{e.setState(u.LifecycleState.PERSISTED)}}).then(function(){var n=V(t.changes.comp,e);var a=e.convertToFileContent();x(n,a);return a})}function I(e,t){for(var n=e.length-1;n>=0;n--){var a=e[n].fileName||e[n].getId()&&e[n].getId();if((a||e[n].getId())===t){e.splice(n,1);break}}}function b(e,t){delete t.byId[e.getId()];if(e.getChangeType()==="standardVariant"){t.standardVariantChange=undefined}else{I(V(t,e),e.getId())}}function D(e,t,n,a){var r=e.convertToFileContent();return y.remove({flexObject:r,layer:e.getLayer(),transport:e.getRequest(),parentVersion:a}).then(function(){b(e,t)}).then(C.updateModelFromBackend.bind(this,{reference:r.reference,layer:r.layer})).then(function(){I(V(n.changes.comp,e),r.fileName);return r})}function T(e){var t={};if(typeof e.texts==="object"){Object.keys(e.texts).forEach(function(n){t[n]={value:e.texts[n],type:"XFLD"}})}return t}function E(e){return e&&[u.LifecycleState.NEW,u.LifecycleState.DIRTY,u.LifecycleState.DELETED].includes(e.getState())}function U(e){return e.variants.concat(e.changes).concat(e.defaultVariants).concat(e.standardVariantChange)}function R(e){if(e.layer){return e.layer}if(e.isUserDependent){return r.USER}var t=new URLSearchParams(window.location.search).get("sap-ui-layer")||"";t=t.toUpperCase();if(t){return t}if(!e.fileType==="variant"){return r.CUSTOMER}var n=g.getInstanceOrUndef().isPublicLayerAvailable();return n?r.PUBLIC:r.CUSTOMER}function F(e){var t=d.getCompVariantsMap(e.reference)._getOrCreate(e.persistencyKey);return t.byId[e.id]}function N(e){if(e instanceof o){e.removeAllRevertData()}}function L(e,t){e.storeExecuteOnSelection(t.executeOnSelection);e.storeFavorite(t.favorite);e.storeContexts(t.contexts);e.storeName(t.name);e.storeContent(t.content||e.getContent());return e}function j(e,t){e.setExecuteOnSelection(t.executeOnSelection);e.setFavorite(t.favorite);e.setContexts(t.contexts);e.setName(t.name);e.setContent(t.content||e.getContent());return e}function A(e){if(e&&e.getRevertData().length){let t;e.getRevertData().reverse().some(e=>{t=e.getContent();return t.previousAction===_.updateActionType.SAVE});L(e,Object.assign({name:t.previousName,content:t.previousContent,favorite:t.previousFavorite,executeOnSelection:t.previousExecuteOnSelection,contexts:t.previousContexts}));e.setState(t.previousState)}}function M(e){if(e.layer===r.VENDOR){e.support={user:"SAP"}}else if(g.getInstanceOrUndef()&&g.getInstanceOrUndef().getUserId()){e.support={user:g.getInstanceOrUndef().getUserId()}}}function w(e){const t=d.getCompVariantsMap(e);const n=[];if(t){Object.values(t).forEach(function(e){const t=e.controlId&&a.getElementById(e.controlId);if(t){n.push(t)}})}return n}var _={};_.checkSVMControlsForDirty=function(e){return w(e).some(e=>e.getModified())};_.setDefault=function(e){var t={defaultVariantName:e.defaultVariantId};e.layer||=new URLSearchParams(window.location.search).get("sap-ui-layer")||r.USER;var n=d.getCompVariantsMap(e.reference)._getOrCreate(e.persistencyKey);var a="defaultVariant";var o=n.defaultVariants;var s=o[o.length-1];if(!s||!m(s,e)){var u={fileName:i.createDefaultFileName(a),fileType:"change",changeType:a,layer:e.layer,content:t,namespace:i.createNamespace(e,"changes"),reference:e.reference,selector:{persistencyKey:e.persistencyKey},support:e.support||{}};u.adaptationId=e.changeSpecificData?.adaptationId;u.support.generator||=`CompVariantState.${a}`;s=c.createFromFileContent(u,f);n.defaultVariants.push(s);n.byId[s.getId()]=s;s.addRevertInfo(new p({type:_.operationType.NewChange}));d.addDirtyFlexObject(e.reference,s)}else{s.addRevertInfo(new p({type:_.operationType.ContentUpdate,content:{previousState:s.getState(),previousContent:s.getContent()}}));s.setContent(t)}return s};_.revertSetDefaultVariantId=function(e){var t=d.getCompVariantsMap(e.reference)._getOrCreate(e.persistencyKey);var n=t.defaultVariants;var a=n[n.length-1];var r=a.popLatestRevertInfo();if(r.getType()===_.operationType.ContentUpdate){a.setContent(r.getContent().previousContent);a.setState(r.getContent().previousState)}else{a.setState(u.LifecycleState.DELETED);t.defaultVariants.pop()}};_.addVariant=function(t){if(!t){return undefined}var n=t.changeSpecificData;n.layer=R(n);n.changeType=n.type;n.texts=T(n);M(n);var a=Object.assign({},n,e(t,"changeSpecificData"));var i=c.createCompVariant(a);var o=d.getCompVariantsMap(t.reference);var s=o._getOrCreate(t.persistencyKey);s.variants.push(i);s.byId[i.getId()]=i;d.addDirtyFlexObject(t.reference,i);if(n.layer!==r.USER&&n.layer!==r.PUBLIC){t.id=t.control.getCurrentVariantId();A(F(t))}return i};_.updateVariant=function(e){function n(t,n){var a=t.getLayer()===n;var r=t.getFlexObjectMetadata().packageName;var i=!r||r==="$TMP";var o=t.getChanges().some(function(e){return e.getLayer()===n});return t.getPersisted()&&a&&i&&!o&&S(t,e)}function a(t){return t.getChanges().reverse().find(function(t){return t.getChangeType()==="updateVariant"&&m(t,e)})}function i(e,t,n,a){var r={type:n,change:a,content:{previousState:t.getState(),previousContent:t.getContent(),previousFavorite:t.getFavorite(),previousVisible:t.getVisible(),previousExecuteOnSelection:t.getExecuteOnSelection(),previousContexts:t.getContexts(),previousName:t.getName(),previousAction:e.action}};t.addRevertData(new s(r))}function o(e,t){i(e,t,_.operationType.ContentUpdate);if(e.executeOnSelection!==undefined){t.storeExecuteOnSelection(e.executeOnSelection)}if(e.layer===r.PUBLIC){t.storeFavorite(false)}else if(e.favorite!==undefined){t.storeFavorite(e.favorite)}if(e.visible!==undefined){t.storeVisible(e.visible)}if(e.contexts){t.storeContexts(e.contexts)}if(e.name){t.storeName(e.name)}if(e.transportId){t.setRequest(e.transportId)}t.storeContent(e.content||t.getContent())}function p(e,n,a){var r=a.getRevertData()||[];var o=Object.assign({},a.getContent());var s={previousContent:Object.assign({},o),previousState:a.getState(),change:t(Object.assign({},e),["favorite","visible","executeOnSelection","contexts","content","name"])};r.push(s);a.setRevertData(r);if(e.executeOnSelection!==undefined){o.executeOnSelection=e.executeOnSelection}if(e.favorite!==undefined){o.favorite=e.favorite}if(e.visible!==undefined){o.visible=e.visible}if(e.contexts){o.contexts=e.contexts}if(e.content){o.variantContent=e.content}if(e.adaptationId){a.setAdaptationId(e.adaptationId)}if(e.name){a.setText("variantName",e.name)}a.setContent(o);if(e.transportId){a.setRequest(e.transportId)}i(e,n,_.operationType.UpdateVariantViaChangeUpdate,a);l.applyChangeOnVariant(n,a)}function u(e,t){function n(t){var n=d.getCompVariantsMap(e.reference);var a=t.getSelector().persistencyKey;n[a].changes.push(t);n[a].byId[t.getId()]=t;d.addDirtyFlexObject(e.reference,t)}var a={};["favorite","visible","executeOnSelection","contexts"].forEach(function(t){if(e[t]!==undefined){a[t]=e[t]}});if(e.content!==undefined){a.variantContent=e.content}var r=c.createUIChange({changeType:"updateVariant",layer:v,fileType:"change",reference:e.reference,packageName:e.packageName,content:a,selector:{persistencyKey:e.persistencyKey,variantId:t.getVariantId()}});if(e.adaptationId!==undefined){r.setAdaptationId(e.adaptationId)}else if(e.changeSpecificData&&e.changeSpecificData.adaptationId!==undefined){r.setAdaptationId(e.changeSpecificData.adaptationId)}if(e.name){r.setText("variantName",e.name,"XFLD",true)}if(e.transportId){r.setRequest(e.transportId)}n(r);i(e,t,_.operationType.NewChange,r);l.applyChangeOnVariant(t,r)}var f=F(e);var v=R(e);if(e.forceCreate){u(e,f)}else if(n(f,v)){o(e,f)}else{var g=a(f);if(g){p(e,f,g)}else{u(e,f)}}return f};_.discardVariantContent=function(e){var t=F(e);var n=t.getRevertData();if(n.length!==0){var a=n.slice().reverse().some(function(t){if(t.getContent().previousAction===_.updateActionType.SAVE){e.content=t.getContent().previousContent;e.action=_.updateActionType.DISCARD;return true}});if(!a){e.content=n[0].getContent().previousContent;e.action=_.updateActionType.DISCARD}_.updateVariant(e)}return t};_.updateActionType={UPDATE:"update",SAVE:"save",DISCARD:"discard",UPDATE_METADATA:"update_metadata"};_.operationType={StateUpdate:"StateUpdate",ContentUpdate:"ContentUpdate",NewChange:"NewChange",UpdateVariantViaChange:"UpdateVariantViaChange",UpdateVariantViaChangeUpdate:"UpdateVariantViaChangeUpdate"};_.removeVariant=function(e){var t=F(e);var n=t.getState();if(!e.revert){var a=new s({type:_.operationType.StateUpdate,content:{previousState:n}});t.addRevertData(a)}if(n===u.LifecycleState.NEW){var r=d.getCompVariantsMap(e.reference);var i=r._getOrCreate(e.persistencyKey);b(t,i);return t}t.markForDeletion();return t};_.revert=function(e){function n(t){var n=t.getSelector().persistencyKey;var a=d.getCompVariantsMap(e.reference);delete a[n].byId[t.getId()];a[n].changes=a[n].changes.filter(function(e){return e!==t});d.removeDirtyFlexObject(e.reference,t)}var a=F(e);var r=a.getRevertData().pop();a.removeRevertData(r);var i=r.getContent();var o;switch(r.getType()){case _.operationType.ContentUpdate:L(a,Object.assign({name:i.previousName,content:i.previousContent,favorite:i.previousFavorite,executeOnSelection:i.previousExecuteOnSelection,contexts:i.previousContexts},t(e,["reference","persistencyKey","id"])));break;case _.operationType.NewChange:o=r.getChange();a.removeChange(o);n(o);j(a,Object.assign({name:i.previousName,content:i.previousContent,favorite:i.previousFavorite,executeOnSelection:i.previousExecuteOnSelection,contexts:i.previousContexts},t(e,["reference","persistencyKey","id"])));break;case _.operationType.UpdateVariantViaChangeUpdate:o=r.getChange();j(a,Object.assign({name:i.previousName,content:i.previousContent,favorite:i.previousFavorite,executeOnSelection:i.previousExecuteOnSelection,contexts:i.previousContexts},t(e,["reference","persistencyKey","id"])));var s=o.getRevertData().pop();o.setContent(s.previousContent);o.setState(s.previousState);break;case _.operationType.StateUpdate:default:break}a.setState(i.previousState);return a};_.overrideStandardVariant=function(e){var t=d.getCompVariantsMap(e.reference)[e.persistencyKey];var n=t.byId[t.standardVariant.getVariantId()];n.setExecuteOnSelection(!!e.executeOnSelection);var a=n.getChanges();n.removeAllChanges();a.forEach(function(e){l.applyChangeOnVariant(n,e)})};_.persist=async function(e){function t(e,t,n){if(e.getLayer()===r.PUBLIC){e.setFavorite(false)}return y.write({flexObjects:[e.convertToFileContent()],layer:e.getLayer(),transport:e.getRequest(),isLegacyVariant:e.isVariant&&e.isVariant(),parentVersion:n}).then(function(t){if(t&&t.response&&t.response[0]){e.setResponse(t.response[0]);if(n){C.onAllChangesSaved({reference:t.response[0].reference,layer:t.response[0].layer,draftFilenames:[t.response[0].fileName]})}}else{e.setState(u.LifecycleState.PERSISTED)}}).then(function(){const n=e.convertToFileContent();V(t.changes.comp,e).push(n);return n})}function n(e,n,a,r){switch(e.getState()){case u.LifecycleState.NEW:N(e);return t(e,a,r);case u.LifecycleState.DIRTY:N(e);return O(e,a,r);case u.LifecycleState.DELETED:N(e);return D(e,n,a,r);default:return undefined}}const a=e.reference;const i=e.persistencyKey;const o=d.getCompVariantsMap(a);const s=o._getOrCreate(i);const c=await d.getStorageResponse(a);const p=U(s).filter(E);const f=p.map(function(e,t){if(t===0){const t=h("/persistedVersion",{layer:e.getLayer(),reference:e.getFlexObjectMetadata().reference});return n(e,s,c,t).then(function(){const e=p.map(function(e,a){if(a!==0){const a=t?v.Number.Draft:undefined;return n(e,s,c,a)}return undefined});return Promise.all(e)})}return undefined});return Promise.all(f)};_.persistAll=async function(t){const n=e(d.getCompVariantsMap(t),"_getOrCreate","_initialize");const a=[];const r=w(t);for(const e of Object.keys(n)){const n=await _.persist({reference:t,persistencyKey:e});a.push(n)}r.forEach(e=>{e.setModified(false)});return a};_.hasDirtyChanges=function(e){var t=d.getCompVariantsMap(e);var n=[];for(var a in t){var r=t[a];for(var i in r.byId){n.push(r.byId[i])}}return n.some(function(e){return e.getState()!==u.LifecycleState.PERSISTED&&!(e.getVariantId&&e.getVariantId()==="*standard*")})};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/Adaptations", [],function(){"use strict";return{UrlParameter:"sap-ui-fl-adaptation",Type:{Default:"DEFAULT",Baseline:"BASELINE",ContextBased:"CONTEXTBASED"}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ContextBasedAdaptationsAPI", ["sap/ui/core/Lib","sap/ui/fl/write/api/Adaptations","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/write/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/compVariants/CompVariantMerger","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/_internal/Versions","sap/ui/model/json/JSONModel"],function(e,t,r,a,n,i,o,l,d,s,c,p,u,f,v,y,g){"use strict";var h={};var A;var x=[o.VENDOR,o.PARTNER,o.CUSTOMER_BASE,o.CUSTOMER];var I={};function m(e){var t=n.getFlexReferenceForControl(e);if(!t){throw Error("The application ID could not be determined")}return t}function C(e,t,r){if(r){return y.updateModelFromBackend({reference:t.appId,layer:t.layer}).then(function(){return e})}y.onAllChangesSaved({reference:t.appId,layer:t.layer,contextBasedAdaptation:true});return Promise.resolve(e)}I.initialize=function(t){A||=e.getResourceBundleFor("sap.ui.fl");if(!t.layer){return Promise.reject("No layer was provided")}if(!t.control){return Promise.reject("No control was provided")}var a=m(t.control);t.reference=a;var n=t.layer;if(h&&h[a]&&h[a][n]){return Promise.resolve(h[a][n])}var i;return r.isContextBasedAdaptationAvailable(n).then(function(e){i=e;var r=i?I.load(t):Promise.resolve({adaptations:[]});return r}).then(function(e){var r=s.get(t.control)||{};var a=e.adaptations[0];if(r.adaptationId){a=e.adaptations.find(function(e){return e.id===r.adaptationId})||a}return I.createModel(e.adaptations,a,i)}).then(function(e){h[a]||={};h[a][n]||={};h[a][n]=e;return h[a][n]})};I.createModel=function(e,r,a){if(!Array.isArray(e)){throw Error("Adaptations model can only be initialized with an array of adaptations")}if(a&&!r){throw Error("Invalid call, must pass displayed adaptation")}if(!a&&e.length){throw Error("Invalid call, must not pass adaptations if feature is disabled")}var n=new g({allAdaptations:[],adaptations:[],count:0,displayedAdaptation:{},contextBasedAdaptationsEnabled:a});n.updateAdaptations=function(e){var r=e.filter(function(e,r){e.rank=r+1;return e.type!==t.Type.Default});n.setProperty("/adaptations",r);n.setProperty("/allAdaptations",e);n.setProperty("/count",r.length);var a=n.getProperty("/displayedAdaptation");var i=e.find(function(e){return!!a&&e.id===a.id});if(i){a=Object.assign({},i);n.setProperty("/displayedAdaptation",a)}n.updateBindings(true)};n.insertAdaptation=function(e){var t=n.getProperty("/allAdaptations");t.splice(e.priority,0,e);delete e.priority;n.updateAdaptations(t)};n.deleteAdaptation=function(){var e=n.getProperty("/displayedAdaptation").rank-1;var t=n.getProperty("/adaptations");var r=n.getProperty("/count");var a;if(r>1){a=t[e+(e===r-1?-1:1)].id}t.splice(e,1);var i=n.getProperty("/allAdaptations").pop();t.push(i);n.updateAdaptations(t);return a};n.switchDisplayedAdaptation=function(e){var t=n.getIndexByAdaptationId(e);var r=t?n.getProperty("/allAdaptations")[t]:n.getProperty("/allAdaptations")[0];n.setProperty("/displayedAdaptation",r);n.updateBindings(true)};n.updateAdaptationContent=function(e){var t=n.getProperty("/allAdaptations");var r=t.find(function(t){return e.adaptationId===t.id});r.title=e.title;r.contexts=e.contexts;var a=r.rank-1;if(a!==e.priority){var i=t.splice(a,1);t.splice(e.priority,0,i[0])}n.updateAdaptations(t)};n.getIndexByAdaptationId=function(e){var t=n.getProperty("/allAdaptations");var r=t.findIndex(function(t){return t.id===e});return r>-1?r:undefined};if(e.length>0){n.updateAdaptations(e);n.setProperty("/displayedAdaptation",r)}return n};I.getAdaptationsModel=function(e){if(!e.layer){throw Error("No layer was provided")}if(!e.control){throw Error("No control was provided")}e.reference=m(e.control);var t=e.reference;var r=e.layer;if(!I.hasAdaptationsModel(e)){throw Error(`Adaptations model for reference '${t}' and layer '${r}' were not initialized.`)}return h[t][r]};I.getDisplayedAdaptationId=function(e){var r=this.getAdaptationsModel(e).getProperty("/displayedAdaptation/id");return r!==t.Type.Default?r:undefined};I.hasAdaptationsModel=function(e){var t=e.reference;var r=e.layer;return h[t]&&h[t][r]};I.adaptationExists=function(e){var t=e.reference;var r=e.layer;return this.hasAdaptationsModel({reference:t,layer:r})&&h[t][r].getProperty("/count")>0};I.clearInstances=function(){h={}};I.refreshAdaptationModel=function(e){this.clearInstances();return this.initialize(e).then(function(e){return e.getProperty("/displayedAdaptation/id")})};function P(e,t){return e.get(t)||t}function V(e,t){return v.contextBasedAdaptation.create({layer:e.layer,flexObject:t,appId:e.appId,parentVersion:_(e)}).then(function(r){var a=this.getAdaptationsModel(e);a.insertAdaptation(t);return C(r,e)}.bind(this))}function b(e,t){return v.write({layer:e.layer,flexObjects:t,transport:"",isLegacyVariant:false,parentVersion:_(e)})}function j(e,t,r){if(r.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=t.filter(function(e){return e.getChangeType()==="updateVariant"&&e.getSelector().variantId===r.getId()});var n=r.clone();a.forEach(p.applyChangeOnVariant.bind(p,n));n.removeAllChanges();n.destroy();return n.mProperties}return e.find(function(e){return e.key===r.getId()})}function w(e,t){var r={};var a=[];e.forEach(function(e){var n=t[e.getId()];if(n.visible){var i=true;var o=Object.keys(n.contexts);o.forEach(function(t){var a=Array.from(n.contexts[t]);a.forEach(function(t){i=false;if(r[t]){r[t].variants.push(e)}else{r[t]={contextBasedAdaptationId:d.createDefaultFileName(),variants:[e]}}})});if(i){a.push(e)}}});return{uniqueContexts:r,unrestrictedViews:a}}function O(e,t,r){if(e.isA("sap.ui.fl.apply._internal.flexObjects.CompVariant")){var a=e.getPersistencyKey();e=u.updateVariant({reference:t.appId,persistencyKey:a,id:e.getId(),layer:t.layer,visible:false,adaptationId:r,forceCreate:true});return e.getChanges().reverse()[0].convertToFileContent()}var n=d.getAppComponentForControl(t.control);var o=n.getModel(i.getVariantModelName());var l=o.createVariantChange(e.getVariantManagementReference(),{changeType:"setVisible",visible:false,variantReference:e.getId(),layer:t.layer,appComponent:n,adaptationId:r});return l.convertToFileContent()}function E(e,t,r){var a=e.filter(function(e){return r===e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")&&e.getLayer()===t});return a}function F(e){var t=e.getFileType();if(t==="change"){if(e.getSelector().variantId){return e.getSelector().variantId}if(e.getVariantReference()){return e.getVariantReference()}}else if(t==="ctrl_variant_change"&&e.getSelector().id){return e.getSelector().id}return undefined}function S(e){if(e.getFileType()==="ctrl_variant_change"&&e.getChangeType()==="setContexts"){return true}return false}function B(e,t){return t.filter(function(t){var r=F(t);if(S(t)){return false}return!r||e.indexOf(r)<0})}function M(e,t){var r=[];var a=[];var n=new Map;e.forEach(function(e){if(e.isA("sap.ui.fl.apply._internal.flexObjects.Variant")){r.push(e)}else{a.push(e)}});var i=N(r,n,t);var o=T(a,n,t);return i.concat(o).map(function(e){return e.convertToFileContent()})}function N(e,t,r){var n=[];e.forEach(function(e){var i=a.createFromFileContent(e.cloneFileContentWithNewId());i.setAdaptationId(r);i.setContexts();t.set(e.getId(),i.getId());n.push(i)});return n}function T(e,t,r){var n=[];e.forEach(function(e){var i=a.createFromFileContent(e.cloneFileContentWithNewId());var o=i.getContent();var l=i.getSelector();if(e.getFileType()==="change"){if(e.getSelector().variantId){l.variantId=P(t,i.getSelector().variantId);i.setSelector(l)}else if(e.getContent().defaultVariantName){o.defaultVariantName=P(t,i.getContent().defaultVariantName);i.setContent(o)}if(e.getVariantReference()){i.setVariantReference(P(t,i.getVariantReference()))}if(e.getChangeType()==="updateVariant"){delete i.getContent().contexts;if(!Object.keys(i.getContent()).length){return}}}else if(e.getFileType()==="ctrl_variant_change"&&e.getSelector().id){l.id=P(t,i.getSelector().id);i.setSelector(l)}else if(e.getFileType()==="ctrl_variant_management_change"&&e.getContent().defaultVariant){o.defaultVariant=P(t,i.getContent().defaultVariant);i.setContent(o)}i.setAdaptationId(r);n.push(i)});return n}function _(e){return y.getVersionsModel({layer:e.layer,reference:e.appId}).getProperty("/persistedVersion")}function R(e,t,r,a){var n={contextBasedAdaptations:[],flexObjects:[]};var i={};e.forEach(function(e){i[e.getId()]=j(t,r,e)});var l=w(e,i);var d=l.uniqueContexts;var s=l.unrestrictedViews;Object.entries(d).forEach(function(t){var i=t[0];var l=t[1];l.variants=l.variants.concat(s);var d=l.contextBasedAdaptationId;var c={id:d,title:A.getText("CBA_MIGRATED_ADAPTATION_TITLE",i),contexts:{role:[i]},priority:0};n.contextBasedAdaptations.push(c);var p=l.variants.filter(function(e){return e.getLayer()===o.CUSTOMER});var u=new Map;var f=N(p,u,d);f.forEach(function(e){n.flexObjects.push(e.convertToFileContent())});var v=l.variants.map(function(e){return e.getId()});var y=e.map(function(e){return e.getId()}).filter(function(e){return v.indexOf(e)<0});var g=B(y,r);var h=T(g,u,d);h.forEach(function(e){n.flexObjects.push(e.convertToFileContent())});e.forEach(function(e){if(e.getLayer()!==o.CUSTOMER&&v.indexOf(e.getId())<0){n.flexObjects.push(O(e,a,d))}})});e.forEach(function(e){var t=i[e.getId()];var r=s.indexOf(e)<0;if(t.visible===true&&r){n.flexObjects.push(O(e,a,undefined))}});return n}I.migrate=function(e){e.appId=m(e.control);var t=_(e);e.parentVersion=t;var r=[];var a=f.getAllVariants(n.getFlexReferenceForControl(e.control));var i={contextBasedAdaptation:[],flexObjects:[]};return c.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(e){x.forEach(function(t){r.push(E(e,t,true))});r.push(E(e,o.CUSTOMER,false));return Promise.all(r)}).then(function(t){var r=t.pop();var n=t.flat();i=R(n,a,r,e);var o=Promise.resolve();i.contextBasedAdaptations.forEach(function(t){o=o.then(V.bind(this,e,t))}.bind(this));return o}.bind(this)).then(function(){if(i.flexObjects.length>0){return b(e,i.flexObjects)}return Promise.resolve()}).then(function(){return this.refreshAdaptationModel({control:e.control,layer:e.layer})}.bind(this))};I.canMigrate=function(e){var t=I.getAdaptationsModel(e);if(t.getProperty("/count")!==0){return Promise.resolve(false)}return c.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true}).then(function(t){var r=[];x.forEach(function(e){r.push(E(t,e,true))});r=r.flat();var a=f.getAllVariants(n.getFlexReferenceForControl(e.control));return r.some(function(e){var r=j(a,t,e);return r.visible===true&&Object.keys(r.contexts).some(function(e){return r.contexts[e].length!==0})})})};I.create=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}e.contextBasedAdaptation.id=d.createDefaultFileName();e.appId=m(e.control);return V.call(this,e,e.contextBasedAdaptation).then(function(){return c.getFlexObjects({selector:e.control,invalidateCache:false,includeCtrlVariants:true,includeDirtyChanges:true,currentLayer:o.CUSTOMER})}).then(function(t){var r=l.filterChangeOrChangeDefinitionsByCurrentLayer(t,o.CUSTOMER);var a=M(r,e.contextBasedAdaptation.id);return b(e,a)})};I.update=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.contextBasedAdaptation){return Promise.reject("No contextBasedAdaptation was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.update({layer:e.layer,flexObject:e.contextBasedAdaptation,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e)})};I.reorder=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.parameters||!e.parameters.priorities){return Promise.reject("No valid priority list was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.reorder({layer:e.layer,flexObjects:e.parameters,appId:e.appId,parentVersion:_(e)}).then(function(t){return C(t,e)})};I.load=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.load({layer:e.layer,appId:e.appId,version:_(e)}).then(function(e){e||={adaptations:[]};return e})};I.remove=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.control){return Promise.reject("No control was provided")}if(!e.adaptationId){return Promise.reject("No adaptationId was provided")}e.appId=m(e.control);return v.contextBasedAdaptation.remove({layer:e.layer,appId:e.appId,adaptationId:e.adaptationId,parentVersion:_(e)}).then(function(t){return C(t,e,true)})};return I});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ExtensionPointRegistryAPI", ["sap/ui/fl/write/_internal/extensionPoint/Registry"],function(n){"use strict";var e={getExtensionPointInfo(e){return n.getExtensionPointInfo(e.name,e.view)},getExtensionPointInfoByViewId(e){return n.getExtensionPointInfoByViewId(e.viewId)},getExtensionPointInfoByParentId(e){return n.getExtensionPointInfoByParentId(e.parentId)},addCreatedControlsToExtensionPointInfo(e){n.addCreatedControls(e.name,e.viewId,e.createdControlsIds)}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/FeaturesAPI", ["sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(e,n,t){"use strict";var r={isPublishAvailable(){return e.getInstance().then(function(e){return e.isPublishAvailable()||!e.isProductiveSystem()&&e.isSystemWithTransports()})},isSaveAsAvailable(r){return Promise.all([e.getInstance(),t.getUShellService("CrossApplicationNavigation")]).then(function(e){var t=e[0];var i=e[1];return t.isAppVariantSaveAsEnabled()&&r===n.CUSTOMER&&i!==undefined}).catch(function(){return false})},isContextBasedAdaptationAvailable(t){return e.getInstance().then(function(e){if(e.isContextBasedAdaptationEnabled()&&t===n.CUSTOMER){return true}return false})},isKeyUser(){return e.getInstance().then(function(e){return e.isKeyUser()})},isVersioningEnabled(n){return e.getInstance().then(function(e){return e.isVersioningEnabled(n)})},isKeyUserTranslationEnabled(t){if(t===n.CUSTOMER){return e.getInstance().then(function(e){return e.isKeyUserTranslationEnabled()})}return Promise.resolve(false)},isContextSharingEnabled(t){if(t!==n.CUSTOMER){return Promise.resolve(false)}return e.getInstance().then(function(e){return e.isContextSharingEnabled({layer:t})})}};return r});
sap.ui.require.preload({
	"sap/ui/fl/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.fl","type":"library","embeds":["support/apps/contentbrowser","variants/context"],"applicationVersion":{"version":"1.120.31"},"title":"SAPUI5 library with sap.ui.fl controls.","description":"SAPUI5 library with sap.ui.fl controls.","ach":"CA-UI5-FL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.31"},"sap.m":{"minVersion":"1.120.31"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.fl.variants.VariantManagement","sap.ui.fl.util.IFrame"],"elements":[],"types":[],"interfaces":[]}}}}'
},"sap/ui/fl/library-preload");
sap.ui.loader.config({bundlesUI5:{
"sap/ui/fl/library-preload-apply.js":['sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes.js','sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil.js','sap/ui/fl/apply/_internal/changes/descriptor/Registration.js','sap/ui/fl/apply/_internal/changes/descriptor/RegistrationBuild.js','sap/ui/fl/apply/_internal/changes/descriptor/app/AddAnnotationsToOData.js','sap/ui/fl/apply/_internal/changes/descriptor/app/AddNewInbound.js','sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource.js','sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeInbound.js','sap/ui/fl/apply/_internal/changes/descriptor/app/RemoveAllInboundsExceptOne.js','sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle.js','sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetAbstract.js','sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds.js','sap/ui/fl/apply/_internal/changes/descriptor/ovp/AddNewCard.js','sap/ui/fl/apply/_internal/changes/descriptor/ovp/ChangeCard.js','sap/ui/fl/apply/_internal/changes/descriptor/ovp/DeleteCard.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddComponentUsages.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModel.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled.js','sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version.js','sap/ui/fl/apply/_internal/connectors/ObjectStorageConnector.js','sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils.js','sap/ui/fl/apply/_internal/extensionPoint/Processor.js','sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState.js','sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState.js','sap/ui/fl/apply/api/SmartVariantManagementApplyAPI.js','sap/ui/fl/apply/api/UI2PersonalizationApplyAPI.js','sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory.js','sap/ui/fl/descriptorRelated/internal/Utils.js','sap/ui/fl/transport/TransportDialog.js','sap/ui/fl/transport/TransportSelection.js','sap/ui/fl/util/DescriptorChangeCheck.js','sap/ui/fl/util/IFrame.flexibility.js','sap/ui/fl/util/changePropertyValueByPath.js','sap/ui/fl/write/_internal/appVariant/AppVariantInlineChange.js','sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory.js','sap/ui/fl/write/_internal/connectors/Utils.js','sap/ui/fl/write/_internal/transport/TransportDialog.js','sap/ui/fl/write/_internal/transport/TransportSelection.js','sap/ui/fl/write/_internal/transport/Transports.js','sap/ui/fl/write/api/ChangesWriteAPI.js'],
"sap/ui/fl/library-preload-write.js":['sap/ui/fl/FakeLrepConnector.js','sap/ui/fl/FakeLrepConnectorLocalStorage.js','sap/ui/fl/FakeLrepConnectorSessionStorage.js','sap/ui/fl/FakeLrepLocalStorage.js','sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory.js','sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory.js','sap/ui/fl/util/resolveBinding.js','sap/ui/fl/variants/context/Component.js','sap/ui/fl/variants/context/controller/ContextVisibility.controller.js','sap/ui/fl/variants/context/view/ContextVisibility.view.xml','sap/ui/fl/write/_internal/SaveAs.js','sap/ui/fl/write/_internal/appVariant/AppVariant.js','sap/ui/fl/write/_internal/appVariant/AppVariantFactory.js','sap/ui/fl/write/_internal/connectors/BackendConnector.js','sap/ui/fl/write/_internal/connectors/BtpServiceConnector.js','sap/ui/fl/write/_internal/connectors/JsObjectConnector.js','sap/ui/fl/write/_internal/connectors/KeyUserConnector.js','sap/ui/fl/write/_internal/connectors/LocalStorageConnector.js','sap/ui/fl/write/_internal/connectors/LrepConnector.js','sap/ui/fl/write/_internal/connectors/NeoLrepConnector.js','sap/ui/fl/write/_internal/connectors/ObjectPathConnector.js','sap/ui/fl/write/_internal/connectors/ObjectStorageConnector.js','sap/ui/fl/write/_internal/connectors/PersonalizationConnector.js','sap/ui/fl/write/_internal/connectors/SessionStorageConnector.js','sap/ui/fl/write/_internal/delegates/ODataV4ReadDelegate.js','sap/ui/fl/write/_internal/extensionPoint/Processor.js','sap/ui/fl/write/_internal/fieldExtensibility/ABAPAccess.js','sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant.js','sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariantFactory.js','sap/ui/fl/write/_internal/fieldExtensibility/MultiTenantABAPExtensibilityVariant.js','sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation.js','sap/ui/fl/write/_internal/fieldExtensibility/SingleTenantABAPExtensibilityVariant.js','sap/ui/fl/write/_internal/fieldExtensibility/UriParser.js','sap/ui/fl/write/_internal/fieldExtensibility/Utils.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/CAPAccess.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/getEditorConfig.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor.fragment.xml','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor.js','sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/validators/IsRequired.js','sap/ui/fl/write/_internal/flexState/UI2Personalization/UI2PersonalizationState.js','sap/ui/fl/write/api/AppVariantWriteAPI.js','sap/ui/fl/write/api/ContextSharingAPI.js','sap/ui/fl/write/api/ControlPersonalizationWriteAPI.js','sap/ui/fl/write/api/FieldExtensibility.js','sap/ui/fl/write/api/LocalResetAPI.js','sap/ui/fl/write/api/PersistenceWriteAPI.js','sap/ui/fl/write/api/ReloadInfoAPI.js','sap/ui/fl/write/api/SmartBusinessWriteAPI.js','sap/ui/fl/write/api/SmartVariantManagementWriteAPI.js','sap/ui/fl/write/api/TranslationAPI.js','sap/ui/fl/write/api/UI2PersonalizationWriteAPI.js','sap/ui/fl/write/api/VersionsAPI.js','sap/ui/fl/write/api/connectors/FileListBaseConnector.js','sap/ui/fl/write/api/connectors/ObjectStorageConnector.js','sap/ui/fl/write/connectors/BaseConnector.js']
}});
//# sourceMappingURL=library-preload.js.map
