/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/write/_internal/Storage","sap/ui/fl/Utils","sap/base/Log"],function(t,e,n){"use strict";function r(t){if(t&&t.logonUser){return Promise.resolve(t.logonUser)}var r=e.getUshellContainer();if(r){return e.getUShellService("UserInfo").then(function(t){var e=t.getUser();return e&&e.getId()}).catch(function(t){n.error(`Error getting service from Unified Shell: ${t.message}`)})}return Promise.resolve()}var o=function(t){if(!t){throw new Error("no flex settings provided")}this._oSettings=t};o.attachEvent=function(t,e){o._oEventProvider.attachEvent(t,e)};o.detachEvent=function(t,e){o._oEventProvider.detachEvent(t,e)};o.getInstance=function(){if(o._instance){return Promise.resolve(o._instance)}if(o._oLoadSettingsPromise){return o._oLoadSettingsPromise}return o._loadSettings()};o._loadSettings=function(){var e;var i=t.loadFeatures().then(function(t){e=t;return r(e)}).then(function(t){if(!e){n.error("The request for flexibility settings failed; A default response is generated and returned to consuming APIs");e={isKeyUser:false,isKeyUserTranslationEnabled:false,isVariantSharingEnabled:false,isVariantPersonalizationEnabled:true,isAtoAvailable:false,isAtoEnabled:false,isAppVariantSaveAsEnabled:false,isContextSharingEnabled:true,isContextBasedAdaptationEnabled:false,isCondensingEnabled:false,isProductiveSystem:true,isPublicLayerAvailable:false,isLocalResetEnabled:false,isVariantAdaptationEnabled:false,versioning:{},_bFlexChangeMode:false,_bFlexibilityAdaptationButtonAllowed:false}}e.userId=t;return o._storeInstance(e)});o._oLoadSettingsPromise=i;return i};o._storeInstance=function(t){o._instance||=new o(t);return o._instance};o.getInstanceOrUndef=function(){return o._instance};o.getDefaultLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:true,PUBLIC:false,USER:false}};o.getDeveloperModeLayerPermissions=function(){return{VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:false,PUBLIC:false,USER:false}};o.prototype._getBooleanProperty=function(t){return this._oSettings[t]||false};o.prototype.isKeyUser=function(){return this._getBooleanProperty("isKeyUser")};o.prototype.isKeyUserTranslationEnabled=function(){return this._getBooleanProperty("isKeyUserTranslationEnabled")};o.prototype.isPublicLayerAvailable=function(){return this._getBooleanProperty("isPublicLayerAvailable")};o.prototype.isVariantAdaptationEnabled=function(){return this._getBooleanProperty("isVariantAdaptationEnabled")};o.prototype.isAppVariantSaveAsEnabled=function(){return!this.isContextBasedAdaptationEnabled()&&this._getBooleanProperty("isAppVariantSaveAsEnabled")};o.prototype.isContextBasedAdaptationEnabled=function(){var t=new URLSearchParams(window.location.search);var e=t.get("sap-ui-xx-rta-adaptations");return e==="true"||this._getBooleanProperty("isContextBasedAdaptationEnabled")};o.prototype.isVersioningEnabled=function(t){return!!(this._oSettings.versioning[t]||this._oSettings.versioning.ALL)};o.prototype.isModelS=function(){return this._getBooleanProperty("isAtoAvailable")};o.prototype.isAtoEnabled=function(){return this._getBooleanProperty("isAtoEnabled")};o.prototype.isAtoAvailable=function(){return this._getBooleanProperty("isAtoAvailable")};o.prototype.isProductiveSystem=function(){return this._getBooleanProperty("isProductiveSystem")};o.prototype.isVariantSharingEnabled=function(){return this._getBooleanProperty("isVariantSharingEnabled")};o.prototype.isPublicFlVariantEnabled=function(){return this._getBooleanProperty("isPublicFlVariantEnabled")};o.prototype.isContextSharingEnabled=function(){return this._getBooleanProperty("isContextSharingEnabled")};o.prototype.isVariantPersonalizationEnabled=function(){return this._getBooleanProperty("isVariantPersonalizationEnabled")};o.prototype.isCondensingEnabled=function(){return this._getBooleanProperty("isCondensingEnabled")};o.prototype.hasPersoConnector=function(){return this._getBooleanProperty("hasPersoConnector")};o.prototype.isSystemWithTransports=function(){return!!(this._oSettings.system&&this._oSettings.client)};o.prototype.isPublishAvailable=function(){return!!this._oSettings.isPublishAvailable};o.prototype.isProductiveSystemWithTransports=function(){return this.isProductiveSystem()&&this.isSystemWithTransports()};o.prototype.isLocalResetEnabled=function(){return this._getBooleanProperty("isLocalResetEnabled")};o.prototype.getSystem=function(){return this._oSettings.system};o.prototype.getClient=function(){return this._oSettings.client};o.prototype._getHostname=function(){return document.location.hostname};o.prototype.isCustomerSystem=function(){var t=this._oSettings.systemType;var e={CUSTOMER:true,SAP:false}[t];var n=this._getHostname();return e!==undefined?e:!(n==="localhost"||n==="127.0.0.1")};o.prototype.getUserId=function(){return this._oSettings.userId};return o},true);
//# sourceMappingURL=Settings.js.map