/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/Context","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VariantItem","sap/m/VariantManagement","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/registry/Settings","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/base/Log"],function(t,e,a,n,i,o,r,s,l,h,p){"use strict";var{TitleLevel:c}=h;var d=s.extend("sap.ui.fl.variants.VariantManagement",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl"],library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false},resetOnContextChange:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:""},editable:{type:"boolean",group:"Misc",defaultValue:true},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},executeOnSelectionForStandardDefault:{type:"boolean",group:"Misc",defaultValue:false},displayTextForExecuteOnSelectionForStandardVariant:{type:"string",group:"Misc",defaultValue:""},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:c.Auto},titleStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:c.Auto},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},events:{initialized:{},save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},public:{type:"boolean"},def:{type:"boolean"},tile:{type:"boolean"}}},cancel:{},manage:{parameters:{renamed:{type:"object[]"},deleted:{type:"string[]"},exe:{type:"object[]"},def:{type:"string"}}},select:{parameters:{key:{type:"string"}}}},associations:{for:{type:"sap.ui.core.Control",multiple:true}},aggregations:{_embeddedVM:{type:"sap.m.VariantManagement",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2,render(t,e){t.openStart("div",e);t.style("max-width",e.getMaxWidth());t.openEnd();t.renderControl(e._oVM);t.close("div")}}});d.prototype.init=function(){s.prototype.init.apply(this);this.addStyleClass("sapUiFlVarMngmt");this._oRb=l.getResourceBundleFor("sap.ui.fl");this.setModelName(o.getVariantModelName());this.attachModelContextChange(this._setModel,this);this._oVM=new i(`${this.getId()}-vm`);this.setAggregation("_embeddedVM",this._oVM,true);this._aCancelEventHandlers=[];this._aSaveEventHandlers=[];this._aManageEventHandlers=[];this._aSelectEventHandlers=[];this._oVM.attachManage(this._fireManage,this);this._oVM.attachCancel(this._fireCancel,this);this._oVM.attachSave(this._fireSave,this);this._oVM.attachSelect(this._fireSelect,this);this._updateWithSettingsInfo()};d.prototype.getOverflowToolbarConfig=function(){return{canOverflow:false,invalidationEvents:["save","manage","select"]}};d.prototype.attachCancel=function(t,e,a){this.attachEvent("cancel",t,e,a);return this};d.prototype._findCallback=function(t,e,a){var n=-1;t.some(function(t,i){if(t.fCallback===e&&t.oObj===a){n=i}return n>=0});return n};d.prototype.detachCancel=function(t,e){var a=this._findCallback(this._aCancelEventHandlers,t,e);if(a>=0){this.detachEvent("cancel",t,e);this._aCancelEventHandlers.splice(a,1)}return this};d.prototype.fireManage=function(t){this._oVM.fireManage(t)};d.prototype.fireSave=function(t){this._oVM.fireSave(t)};d.prototype._fireCancel=function(t){for(var e=0;e<this._aCancelEventHandlers.length;e++){t.oSource=this;this._aCancelEventHandlers[e].fCallbackBound(t,this._aCancelEventHandlers[e].mProps)}};d.prototype.attachSave=function(t,e,a){this.attachEvent("save",t,e,a);return this};d.prototype.detachSave=function(t,e){var a=this._findCallback(this._aSaveEventHandlers,t,e);if(a>-1){this.detachEvent("save",t,e);this._aSaveEventHandlers.splice(a,1)}return this};d.prototype._fireSave=function(t){this._handleAllListeners(t,this._aSaveEventHandlers)};d.prototype.hasListeners=function(...t){const[e]=t;const a=["save","select","cancel","manage"];if(a.indexOf(e)>-1){var n=null;if(e==="select"){n=this._aSelectEventHandlers}else if(e==="save"){n=this._aSaveEventHandlers}else if(e==="manage"){n=this._aManageEventHandlers}else if(e==="cancel"){n=this._aCancelEventHandlers}return n.length>0}return s.prototype.hasListeners.apply(this,t)};d.prototype.attachEvent=function(...t){const[e,,a]=t;let[,n,,i]=t;const o=["save","select","cancel","manage"];if(o.indexOf(e)>-1){var r=null;var l=a;if(typeof n==="function"){l=n;i=a;n=undefined}i=i===this?undefined:i;if(e==="select"){r=this._aSelectEventHandlers}else if(e==="save"){r=this._aSaveEventHandlers}else if(e==="manage"){r=this._aManageEventHandlers}else if(e==="cancel"){r=this._aCancelEventHandlers}r.push({fCallback:l,fCallbackBound:i?l.bind(i):l,oObj:i,mProps:n})}else{s.prototype.attachEvent.apply(this,t)}};d.prototype.attachEventOnce=function(...t){const[e,a,n,i]=t;var o;if(e==="manage"){o=this._findCallback(this._aManageEventHandlers,n,i);if(o>-1&&this._aManageEventHandlers[o].bOnce){this._aManageEventHandlers.splice(o,1)}this.attachManage(a,n,i);o=this._findCallback(this._aManageEventHandlers,n,i);if(o>-1){this._aManageEventHandlers[o].bOnce=true}}else if(e==="save"){o=this._findCallback(this._aSaveEventHandlers,n,i);if(o>-1&&this._aSaveEventHandlers[o].bOnce){this._aSaveEventHandlers.splice(o,1)}this.attachSave(a,n,i);o=this._findCallback(this._aSaveEventHandlers,n,i);if(o>-1){this._aSaveEventHandlers[o].bOnce=true}}else if(e==="select"){o=this._findCallback(this._aSelectEventHandlers,n,i);if(o>-1&&this._aSelectEventHandlers[o].bOnce){this._aSelectEventHandlers.splice(o,1)}this.attachSelect(a,n,i);o=this._findCallback(this._aSelectEventHandlers,n,i);if(o>-1){this._aSelectEventHandlers[o].bOnce=true}}else{s.prototype.attachEventOnce.apply(this,t)}};d.prototype.attachManage=function(t,e,a){this.attachEvent("manage",t,e,a);return this};d.prototype._handleAllListeners=function(t,e){var a=0;var n=[];while(a<e.length){t.oSource=this;e[a].fCallbackBound(t,e[a].mProps);if(e[a]){if(e[a].hasOwnProperty("bOnce")&&e[a].bOnce){n.push(a)}a+=1}}for(a=n.length-1;a>-1;a--){e.splice(n[a],1)}};d.prototype._fireManage=function(t){this._handleAllListeners(t,this._aManageEventHandlers)};d.prototype.detachManage=function(t,e){var a=this._findCallback(this._aManageEventHandlers,t,e);if(a>-1){this.detachEvent("manage",t,e);this._aManageEventHandlers.splice(a,1)}return this};d.prototype.attachSelect=function(t,e,a){this.attachEvent("select",t,e,a);return this};d.prototype._fireSelect=function(t){this._handleAllListeners(t,this._aSelectEventHandlers)};d.prototype.detachSelect=function(t,e){var a=this._findCallback(this._aSelectEventHandlers,t,e);if(a>-1){this.detachEvent("select",t,e);this._aSelectEventHandlers.splice(a,1)}return this};d.prototype._createSaveAsDialog=function(){this._oVM._createSaveAsDialog()};d.prototype._handleVariantSaveAs=function(t){this._oVM._handleVariantSaveAs(t)};d.prototype.getFocusDomRef=function(){if(this._oVM){return this._oVM.oVariantPopoverTrigger.getFocusDomRef()}return null};d.prototype.getManageDialog=function(){if(this._oVM){return this._oVM.oManagementDialog}return null};d.prototype.getVariants=function(){return this._oVM?this._oVM.getItems():[]};d.prototype.getVariantByKey=function(t){return this._oVM?this._oVM._getItemByKey(t):null};d.prototype.getTitle=function(){return this._oVM.getTitle()};d.prototype.refreshTitle=function(){this._oVM.refreshTitle()};d.prototype.setPopoverTitle=function(t){this._oVM.setPopoverTitle(t);return this};d.prototype.setHeaderLevel=function(t){this.setProperty("headerLevel",t);this._oVM.setLevel(t);return this};d.prototype.setTitleStyle=function(t){this.setProperty("titleStyle",t);this._oVM.setTitleStyle(t);return this};d.prototype.setShowAsText=function(t){this._oVM.setShowAsText(t);return this};d.prototype.getShowAsText=function(){return this._oVM.getShowAsText()};d.prototype.setEditable=function(t){this.setProperty("editable",t);this._oVM.setShowFooter(t);return this};d.prototype.setShowExecuteOnSelection=function(t){this._oVM.setSupportApplyAutomatically(t);return this};d.prototype.setShowSetAsDefault=function(t){this.setProperty("showSetAsDefault",t);this._oVM.setSupportDefault(t);return this};d.prototype.setDisplayTextForExecuteOnSelectionForStandardVariant=function(t){this.setProperty("displayTextForExecuteOnSelectionForStandardVariant",t);this._oVM.setDisplayTextForExecuteOnSelectionForStandardVariant(t);return this};d.prototype.setInErrorState=function(t){this.setProperty("inErrorState",t);this._oVM.setInErrorState(t);return this};d.prototype._setStandardVariantKey=function(t){this._oVM.setStandardVariantKey(t)};d.prototype.openManagementDialog=function(t,e,a){this._oVM.openManagementDialog(t,e,a)};d.prototype.openSaveAsDialogForKeyUser=function(t,e){this._oVM.openSaveAsDialog(t,e)};d.prototype.setEditable=function(t){this._oVM.setProperty("showFooter",t);return this};d.prototype.setCurrentVariantKey=function(t){this._oVM.setSelectedKey(t)};d.prototype.getCurrentVariantKey=function(){return this._oVM.getSelectedKey()};d.prototype.setDefaultVariantKey=function(t){this._oVM.setDefaultKey(t)};d.prototype.getDefaultVariantKey=function(){return this._oVM.getDefaultKey()};d.prototype.enteringDesignMode=function(){this._oVM.setDesignMode(true)};d.prototype.leavingDesignMode=function(){this._oVM.setDesignMode(false)};d.prototype.getModified=function(){return this._oVM.getModified()};d.prototype.setModified=function(t){this._oVM.setModified(t)};d.prototype.getStandardVariantKey=function(){return this._oVM.getStandardVariantKey()};d.prototype._getEmbeddedVM=function(){return this._oVM};d.prototype._updateWithSettingsInfo=function(){r.getInstance().then(function(t){if(this._oVM){this._oVM.setShowSaveAs(t.isVariantPersonalizationEnabled());this._oVM.setSupportPublic(t.isPublicFlVariantEnabled())}}.bind(this)).catch(function(t){p.error(t)})};d.prototype.getModelName=function(){return this.getProperty("modelName")};d.prototype.setModelName=function(t){if(this.getModelName()){this.oContext=null;this._aCancelEventHandlers=[];this._aSaveEventHandlers=[];this._aManageEventHandlers=[];this._aSelectEventHandlers=[]}this.setProperty("modelName",t);return this};d.prototype._setModel=function(){this._setBindingContext()};d.prototype._setBindingContext=function(){var e;var a;var n=this.getModelName();if(!this.oContext){e=this.getModel(n);if(e){a=this._getLocalId(e);if(a){this.oContext=new t(e,`/${a}`);this.setBindingContext(this.oContext,n);if(e.registerToModel){e.registerToModel(this)}this.fireInitialized();this._oVM.setModel(e,n);this._oVM.setSupportDefault(true);this._createItemsModel(n);this._oVM.bindProperty("selectedKey",{path:`${this.oContext}/currentVariant`,model:n});this._oVM.bindProperty("defaultKey",{path:`${this.oContext}/defaultVariant`,model:n});this._oVM.bindProperty("modified",{path:`${this.oContext}/modified`,model:n});this._oVM.bindProperty("supportFavorites",{path:`${this.oContext}/showFavorites`,model:n});this._oVM.bindProperty("supportApplyAutomatically",{path:`${this.oContext}/showExecuteOnSelection`,model:n});this._oVM.bindProperty("showFooter",{path:`${this.oContext}/variantsEditable`,model:n});this._oVM.setPopoverTitle(this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS"));this._setStandardVariantKey(a)}}}};d.prototype._createItemsModel=function(t){var i=new n({key:`{${t}>key}`,title:`{${t}>title}`,sharing:`{${t}>sharing}`,remove:`{${t}>remove}`,favorite:`{${t}>favorite}`,executeOnSelect:`{${t}>executeOnSelect}`,rename:`{${t}>rename}`,visible:`{${t}>visible}`,changeable:`{${t}>change}`,author:`{${t}>author}`,contexts:`{${t}>contexts}`});this._oVM.bindAggregation("items",{path:`${this.oContext}/variants`,model:t,template:i,filters:new e({path:"visible",operator:a.EQ,value1:true})})};d.prototype._getLocalId=function(t){var e=this.getModelName();if(!e){return null}if(e!==o.getVariantModelName()){return this.getId()}return t.getVariantManagementReferenceForControl(this)};d.prototype._getInnerItems=function(){var t=[];if(this.oContext&&this.oContext.getObject()){t=this.oContext.getObject().variants.filter(function(t){if(!t.hasOwnProperty("visible")){return true}return t.visible})}return t};d.prototype._getInnerItemByKey=function(t){var e=null;var a=this._getInnerItems();a.some(function(a){if(a.key===t){e=a}return e!==null});return e};d.prototype.registerApplyAutomaticallyOnStandardVariant=function(t){this._fRegisteredApplyAutomaticallyOnStandardVariant=t;return this};d.prototype.getApplyAutomaticallyOnVariant=function(t){var e=false;if(t){e=t.executeOnSelect;if(this._fRegisteredApplyAutomaticallyOnStandardVariant&&this.getDisplayTextForExecuteOnSelectionForStandardVariant()&&t.key===this._oVM.getStandardVariantKey()){try{e=this._fRegisteredApplyAutomaticallyOnStandardVariant(t)}catch(t){p.error("callback for determination of apply automatically on standard variant failed")}}}return e};d.prototype.exit=function(...t){this._oVM.detachManage(this._fireManage,this);this._oVM.detachCancel(this._fireCancel,this);this._oVM.detachSelect(this._fireSelect,this);this._oVM.detachSave(this._fireSave,this);s.prototype.exit.apply(this,t);this._oVM=undefined;this._fRegisteredApplyAutomaticallyOnStandardVariant=null;this.oContext=undefined;this._oRb=undefined;this._aCancelEventHandlers=undefined;this._aSaveEventHandlers=undefined;this._aManageEventHandlers=undefined;this._aSelectEventHandlers=undefined};d.prototype.addFor=function(t){this.addAssociation("for",t);return this};d.prototype._getToolbarInteractive=function(){return true};return d});
//# sourceMappingURL=VariantManagement.js.map