/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_omit","sap/base/util/restricted/_isEqual","sap/base/util/each","sap/base/util/includes","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel"],function(e,t,a,n,r,i,o,s,c,l,h,f,u,p,g,d,v,m,C,V,y,R,D,b,S,x,I){"use strict";var F={};function M(e,t){return E(function(e,t){var a=t.model;var n=t.vmReference;var r=false;var i=o.get([n,"modified"],a.oData);var s=e.key;var c=e.key;return Promise.resolve().then(function(){if(o.get([n,"currentVariant"],a.oData)&&a.oData[n].currentVariant!==s){c=a.oData[n].currentVariant;r=true;return a.updateCurrentVariant({variantManagementReference:n,newVariantReference:s,appComponent:a.oAppComponent,internallyCalled:true})}}).then(function(){if(i){var e=m.getControlChangesForVariant({reference:a.sFlexReference,vmReference:n,vReference:c});return P({changes:e,vmReference:n,vReference:c,revert:!r,model:a})}return Promise.resolve()}).then(function(){if(!r){a.callVariantSwitchListeners(n,a.oData[n].currentVariant)}})}.bind(null,e.getParameters(),t),t.model)}function P(e){var t=e.model._getDirtyChangesFromVariantChanges(e.changes);t=t.reverse();return Promise.resolve().then(function(){if(e.revert){return p.revertMultipleChanges(t,{appComponent:e.model.oAppComponent,modifier:c,flexController:e.model.oFlexController})}return undefined}).then(function(){e.model.oChangePersistence.deleteChanges(t)})}function E(e,t){t._oVariantSwitchPromise=t._oVariantSwitchPromise.catch(function(){}).then(e);t.oFlexController.setVariantSwitchPromise(t._oVariantSwitchPromise);return t._oVariantSwitchPromise}function _(e,t){F[e]=t}function U(e,t){return v.switchVariant(e).then(function(){if(this.oData[e.vmReference].updateVariantInURL){g.updateVariantInURL({vmReference:e.vmReference,newVReference:e.newVReference,model:this})}this.callVariantSwitchListeners(e.vmReference,e.newVReference,undefined,t)}.bind(this))}function L(e){var t=b.getInstanceOrUndef();if(t&&!t.isVariantPersonalizationEnabled()){e.remove=false;e.rename=false;e.change=false}}function w(e){var t=b.getInstanceOrUndef();var a=t&&(t.isKeyUser()||!t.getUserId()||t.isPublicFlVariantEnabled()&&t.getUserId().toUpperCase()===e.author.toUpperCase());e.remove=a;e.rename=a;e.change=a}function A(e,t,a){var n=a?R.getCurrentLayer():y.USER;if(e.layer===n&&e.key!==t){return true}return false}function T(e){return new Promise(function(t){if(e.getDomRef()){t()}else{e.addEventDelegate({onAfterRendering(){t()}})}})}function O(){var e=D.getUshellContainer();if(e){var t=[D.getUShellService("UserInfo"),D.getUShellService("URLParsing"),D.getUShellService("CrossApplicationNavigation"),D.getUShellService("ShellNavigation")];return Promise.all(t).then(function(e){_("UserInfo",e[0]);_("URLParsing",e[1]);_("CrossApplicationNavigation",e[2]);_("ShellNavigation",e[3])}).catch(function(e){throw new Error(`Error getting service from Unified Shell: ${e}`)})}}function k(e,t){return i({},e.find(function(e){return e.key===t}))}function B(e,t,a){var n={layer:e,control:t,reference:a};var r=S.hasAdaptationsModel(n);return r&&S.getDisplayedAdaptationId(n)}var N=I.extend("sap.ui.fl.variants.VariantModel",{constructor:function(e,t){this.pSequentialImportCompleted=Promise.resolve();I.apply(this,[e]);this.sharing={PRIVATE:"private",PUBLIC:"public"};this.oFlexController=t.flexController;this.oChangePersistence=this.oFlexController._oChangePersistence;this.sFlexReference=C.getFlexReferenceForControl(t.appComponent);this.oAppComponent=t.appComponent;this._oResourceBundle=f.getResourceBundleFor("sap.ui.fl");this._oVariantSwitchPromise=Promise.resolve();this._oVariantAppliedListeners={};this.fnUpdateListener=this.updateData.bind(this);this.oDataSelector=m.getVariantManagementMap();this.oDataSelector.addUpdateListener(this.fnUpdateListener);this.updateData();this.setDefaultBindingMode(x.OneWay)}});N.prototype.updateData=function(){var e=this.oDataSelector.get({reference:this.sFlexReference});var t=Object.assign({},this.getData());Object.entries(e).forEach(function(e){var a=e[0];var n=Object.assign({},e[1]);t[a]||={};t[a].variants=n.variants.map(function(e){var n=(t[a].variants||[]).find(function(t){return t.key===e.key});return Object.assign({},n||{},e)});t[a].currentVariant=n.currentVariant;t[a].defaultVariant=n.defaultVariant;t[a].modified=n.modified});this.setData(t);this.refresh(true)};N.prototype.invalidateMap=function(){this.oDataSelector.checkUpdate({reference:this.sFlexReference})};N.prototype.initialize=function(){return Promise.all([b.getInstance(),O()]).then(function(){g.initialize({model:this})}.bind(this))};N.prototype.updateCurrentVariant=function(e){var t={vmReference:e.variantManagementReference,currentVReference:this.getCurrentVariantReference(e.variantManagementReference),newVReference:e.newVariantReference,flexController:this.oFlexController,appComponent:e.appComponent||this.oAppComponent,modifier:c,reference:this.sFlexReference};if(e.internallyCalled){return U.call(this,t,e.scenario)}return E(U.bind(this,t,e.scenario),this)};N.prototype.getCurrentVariantReference=function(e){return this.oData[e].currentVariant};N.prototype.getVariantManagementReference=function(e){var t="";var a=-1;Object.keys(this.oData).some(function(n){return this.oData[n].variants.some(function(r,i){if(r.key===e){t=n;a=i;return true}})}.bind(this));return{variantManagementReference:t,variantIndex:a}};N.prototype.getVariant=function(e,t){var a=t||this.getVariantManagementReference(e).variantManagementReference;return k(this.oData[a].variants,e)};N.prototype.getVariantTitle=function(e,t){return k(this.oData[t].variants,e).title};function j(e,t){var a=m.getVariantChangesForVariant({vmReference:e,reference:this.sFlexReference});var n=this.oData[e].defaultVariant;if(t.getExecuteOnSelectionForStandardDefault()&&n===e&&!a.setExecuteOnSelect){var r=k(this.oData[e].variants,e);r.instance.setExecuteOnSelection(true);this.oData[e].variants[0].executeOnSelect=true;return true}return false}N.prototype.attachVariantApplied=function(e){var t=h.getElementById(e.vmControlId);var a=this.getVariantManagementReferenceForControl(t);return this.waitForVMControlInit(a).then(function(e,a){this._oVariantAppliedListeners[e]||={};var n=j.call(this,e,t);if(a.callAfterInitialVariant||n){var r={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:e,flexController:this.oFlexController};m.waitForInitialVariantChanges(r).then(function(){var t=this.oData[e].currentVariant;this.callVariantSwitchListeners(e,t,a.callback)}.bind(this))}return T(a.control).then(function(){if(V.getRelevantVariantManagementControlId(a.control,this.getVariantManagementControlIds())===a.vmControlId){this.oData[e].showExecuteOnSelection=true;this.checkUpdate(true);this._oVariantAppliedListeners[e][a.control.getId()]=a.callback}else{s.error("Error in attachVariantApplied: The passed VariantManagement ID does not match the "+"responsible VariantManagement control")}}.bind(this))}.bind(this,a,e))};N.prototype.callVariantSwitchListeners=function(e,t,n,r){if(this._oVariantAppliedListeners[e]){var i=k(this.oData[e].variants,t);if(r){i.createScenario=r}if(n){n(i)}else{a(this._oVariantAppliedListeners[e],function(e,t){t(i)})}}};N.prototype.detachVariantApplied=function(e,t){var a=this.getVariantManagementReferenceForControl(h.getElementById(e));if(this._oVariantAppliedListeners[a]){delete this._oVariantAppliedListeners[a][t]}};N.prototype.eraseDirtyChangesOnVariant=function(e,t){var a=m.getControlChangesForVariant({reference:this.sFlexReference,vmReference:e,vReference:t});var n=this._getDirtyChangesFromVariantChanges(a);return P({changes:a,vmReference:e,vReference:t,model:this,revert:true}).then(function(){return n})};N.prototype.addAndApplyChangesOnVariant=function(e){this.oChangePersistence.addChanges(e,this.oAppComponent);return e.reduce(function(e,t){return e.then(function(){var e=h.getElementById(c.getControlIdBySelector(t.getSelector(),this.oAppComponent));return u.applyChangeOnControl(t,e,{modifier:c,appComponent:this.oAppComponent,view:D.getViewForControl(e)}).then(e=>{if(!e.success){var a=e.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(t,true);throw a}})}.bind(this))}.bind(this),Promise.resolve())};N.prototype._getVariantTitleCount=function(e,t){var a=this.getData();return a[t].variants.reduce(function(t,a){if(e.toLowerCase()===a.title.toLowerCase()&&a.visible){t++}return t},0)};function H(e,t){var a={id:t.newVariantReference,variantName:t.title,contexts:t.contexts,layer:t.layer,adaptationId:t.adaptationId,reference:e.getFlexObjectMetadata().reference,generator:t.generator,variantManagementReference:t.variantManagementReference};if(t.layer===y.VENDOR){a.user="SAP"}if(t.currentVariantComparison===1){if(t.sourceVariantSource.instance.getLayer()===t.layer){a.variantReference=t.sourceVariantSource.instance.getVariantReference()}else{a.variantReference=e.getVariantReference()}}else if(t.currentVariantComparison===0){a.variantReference=e.getVariantReference()}else if(t.currentVariantComparison===-1){a.variantReference=t.sourceVariantReference}return d.createFlVariant(a)}N.prototype._duplicateVariant=function(e){var t=e.sourceVariantReference;var a=e.variantManagementReference;var n=this.getVariant(t);var r=m.getControlChangesForVariant({vmReference:a,vReference:t,reference:this.sFlexReference}).map(function(e){return e.convertToFileContent()});e.currentVariantComparison=R.compareAgainstCurrentLayer(n.instance.getLayer(),e.layer);if(e.currentVariantComparison===1){e.sourceVariantSource=this.getVariant(n.instance.getVariantReference())}var o={instance:H(n.instance,e),controlChanges:r,variantChanges:{}};r=o.controlChanges.slice();var s={};o.controlChanges=r.reduce(function(t,a){if(R.compareAgainstCurrentLayer(a.layer,e.layer)>=0){s=i({},a);s.layer=e.layer;s.variantReference=o.instance.getId();s.support||={};s.support.sourceChangeFileName=a.fileName;s.packageName="$TMP";s.fileName=D.createDefaultFileName(s.changeType);t.push(d.createFromFileContent(s))}return t},[]);return o};N.prototype.copyVariant=function(e){var t=this._duplicateVariant(e);t.generator=e.generator;this.oData[e.variantManagementReference].variants.push({key:t.instance.getId(),rename:true,change:true,remove:true,sharing:e.layer===y.USER?this.sharing.PRIVATE:this.sharing.PUBLIC});var a=[];if(e.layer===y.PUBLIC){t.instance.setFavorite(false);var n={selector:c.getSelector(e.newVariantReference,e.appComponent),changeType:"setFavorite",fileType:"ctrl_variant_change",generator:e.generator,layer:y.USER,reference:this.sFlexReference,content:{favorite:true}};a.push(d.createUIChange(n))}a=this.oChangePersistence.addDirtyChanges(a.concat([t.instance].concat(t.controlChanges).concat(e.additionalVariantChanges)));return this.updateCurrentVariant({variantManagementReference:e.variantManagementReference,newVariantReference:t.instance.getId(),appComponent:e.appComponent,internallyCalled:true,scenario:"saveAs"}).then(function(){return a})};N.prototype.removeVariant=function(e){var t=this.oChangePersistence.getDirtyChanges().filter(function(t){return t.getVariantReference&&t.getVariantReference()===e.variant.getId()||t.getId()===e.variant.getId()});return this.updateCurrentVariant({variantManagementReference:e.variantManagementReference,newVariantReference:e.sourceVariantReference,appComponent:e.component}).then(function(){this.oChangePersistence.deleteChanges(t)}.bind(this))};N.prototype._collectModelChanges=function(e,t,a){const n=this.getData()[e];const r=n.variants;const i=[];const o=b.getInstanceOrUndef();const s=e=>r.find(t=>t.key===e);const c=(e,a,n)=>{const r=["setTitle","setExecuteOnSelect","setVisible"].includes(a);const s=r&&o?.isPublicFlVariantEnabled()&&e.layer===y.PUBLIC?y.PUBLIC:t;i.push({variantReference:e.key,changeType:a,layer:s,...n})};a.getParameter("renamed")?.forEach(({key:e,name:t})=>{const a=s(e);c(a,"setTitle",{title:t,originalTitle:a.title})});a.getParameter("fav")?.forEach(({key:e,visible:t})=>{const a=s(e);c(a,"setFavorite",{favorite:t,originalFavorite:a.favorite})});a.getParameter("exe")?.forEach(({key:e,exe:t})=>{const a=s(e);c(a,"setExecuteOnSelect",{executeOnSelect:t,originalExecuteOnSelect:a.executeOnSelect})});a.getParameter("deleted")?.forEach(e=>{const t=s(e);c(t,"setVisible",{visible:false})});a.getParameter("contexts")?.forEach(({key:e,contexts:t})=>{const a=s(e);c(a,"setContexts",{contexts:t,originalContexts:a.contexts})});const l=a.getParameter("def");if(l){i.push({variantManagementReference:e,changeType:"setDefault",defaultVariant:l,originalDefaultVariant:n.defaultVariant,layer:t})}return i};N.prototype.manageVariants=function(e,t,a,n,r){return new Promise(function(i){e.attachEventOnce("manage",{resolve:i,variantManagementReference:t,layer:a},this.fnManageClickRta,this);e.openManagementDialog(true,n,r)}.bind(this))};N.prototype.createVariantChange=function(e,t){var a=this.setVariantProperties(e,t);var n={changeType:t.changeType,layer:t.layer,generator:t.generator,reference:this.sFlexReference};if(t.adaptationId!==undefined){n.adaptationId=t.adaptationId}else{n.adaptationId=B(t.layer,t.appComponent,this.sFlexReference)}if(t.changeType==="setDefault"){n.fileType="ctrl_variant_management_change";n.selector=c.getSelector(e,t.appComponent)}else{n.fileType="ctrl_variant_change";n.selector=c.getSelector(t.variantReference,t.appComponent)}var r=d.createUIChange(n);r.setContent(a);if(t.changeType==="setTitle"){r.setText("title",t.title,"XFLD")}return r};N.prototype.addVariantChange=function(e,t){var a=this.createVariantChange(e,t);this.oChangePersistence.addDirtyChange(a);return a};N.prototype.addVariantChanges=function(e,t){var a=t.map(function(t){return this.createVariantChange(e,t)}.bind(this));this.oChangePersistence.addDirtyChanges(a);return a};N.prototype.deleteVariantChange=function(e,t,a){this.setVariantProperties(e,t);this.oChangePersistence.deleteChange(a)};N.prototype.setVariantProperties=function(e,t){var a=this.getData();var n=this.getVariant(t.variantReference,e).instance;var r={};switch(t.changeType){case"setTitle":n.setName(t.title,true);break;case"setFavorite":r.favorite=t.favorite;n.setFavorite(t.favorite);break;case"setExecuteOnSelect":r.executeOnSelect=t.executeOnSelect;n.setExecuteOnSelection(t.executeOnSelect);break;case"setVisible":r.visible=t.visible;r.createdByReset=false;n.setVisible(t.visible);break;case"setContexts":r.contexts=t.contexts;n.setContexts(t.contexts);break;case"setDefault":r.defaultVariant=t.defaultVariant;var i=g.getStoredHashParams({model:this});if(i){if(a[e].defaultVariant!==a[e].currentVariant&&i.indexOf(a[e].currentVariant)===-1){g.update({parameters:i.concat(a[e].currentVariant),updateURL:!this._bDesignTimeMode&&this.oData[e].updateVariantInURL,updateHashEntry:true,model:this})}else if(a[e].defaultVariant===a[e].currentVariant&&i.indexOf(a[e].currentVariant)>-1){i.splice(i.indexOf(a[e].currentVariant),1);g.update({parameters:i,updateURL:!this._bDesignTimeMode&&this.oData[e].updateVariantInURL,updateHashEntry:true,model:this})}}break;default:break}return r};N.prototype._ensureStandardVariantExists=function(t){var a=this.getData();var n=a[t]||{};var i=e(n,["initPromise"]);if(!a[t]||r(i)){var o=d.createFlVariant({id:t,variantManagementReference:t,variantName:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),user:V.DEFAULT_AUTHOR,layer:y.BASE,reference:this.sFlexReference});m.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),o)}};N.prototype.setModelPropertiesForControl=function(e,t,a){this.oData[e].showFavorites=true;var n=this._bDesignTimeMode;if(n!==t){this._bDesignTimeMode=t;if(t){g.clearAllVariantURLParameters({model:this})}else if(n){g.update({parameters:g.getStoredHashParams({model:this}),updateURL:this.oData[e].updateVariantInURL,updateHashEntry:false,model:this})}}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents()}a.detachManage(this.fnManageClick,this);if(t&&this.oData[e]._isEditable){this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(a){a.rename=true;a.change=true;a.sharing=this.sharing.PUBLIC;a.remove=A(a,e,t)}.bind(this))}else if(this.oData[e]._isEditable){a.attachManage({variantManagementReference:e},this.fnManageClick,this);this.oData[e].variantsEditable=true;this.oData[e].variants.forEach(function(a){a.remove=A(a,e,t);switch(a.layer){case y.USER:a.rename=true;a.change=true;a.sharing=this.sharing.PRIVATE;L(a);break;case y.PUBLIC:a.sharing=this.sharing.PUBLIC;w(a);break;default:a.rename=false;a.change=false;a.sharing=this.sharing.PUBLIC}}.bind(this))}else{this.oData[e].variantsEditable=false;this.oData[e].variants.forEach(function(e){e.remove=false;e.rename=false;e.change=false})}};N.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,t){var a=this._collectModelChanges(t.variantManagementReference,t.layer,e);t.resolve(a)};this.fnManageClick=function(e,t){(async()=>{if(!this.oFlexController||!this.getData()){return}var a=this._collectModelChanges(t.variantManagementReference,y.USER,e);if(a.some(e=>e.visible===false&&e.variantReference===this.getCurrentVariantReference(t.variantManagementReference))){await this.updateCurrentVariant({variantManagementReference:t.variantManagementReference,newVariantReference:t.variantManagementReference})}var n=[];a.forEach(function(e){e.appComponent=this.oAppComponent}.bind(this));n=n.concat(this.addVariantChanges(t.variantManagementReference,a));this.oChangePersistence.saveDirtyChanges(this.oAppComponent,false,n)})()}};function z(e,t,a,n){if(!this._bDesignTimeMode){return e.saveSequenceOfDirtyChanges(t,n).then(function(e){if(e){const t=e.response.find(e=>e.fileType==="ctrl_variant");const n=this.oData[a].variants.find(e=>e.key===t.fileName);const r=n.instance.getSupportInformation();r.user=t.support.user;n.instance.setSupportInformation(r)}this.invalidateMap()}.bind(this))}return Promise.resolve()}N.prototype._handleSaveEvent=function(e){if(!this._bDesignTimeMode){var t=e.getSource();var a=e.getParameters();return this._handleSave(t,a)}return Promise.resolve()};N.prototype._handleSave=function(e,t){var a=D.getAppComponentForControl(e);var n=this.getLocalId(e.getId(),a);var r;return E(function(e,t,a){var n=this.getCurrentVariantReference(e);var o=m.getControlChangesForVariant({reference:this.sFlexReference,vmReference:e,vReference:n});if(a.overwrite){r=this._getDirtyChangesFromVariantChanges(o);if(this.getVariant(n,e).layer===y.PUBLIC){r.forEach(e=>e.setLayer(y.PUBLIC))}return this.oFlexController.saveSequenceOfDirtyChanges(r,t).then(function(e){this.invalidateMap();return e}.bind(this))}var s=a.layer||(a.public?y.PUBLIC:y.USER);var l=a.layer||y.USER;var h=a.newVariantReference||D.createDefaultFileName("flVariant");var f={variantManagementReference:e,appComponent:t,layer:s,title:a.name,contexts:a.contexts,sourceVariantReference:n,newVariantReference:h,generator:a.generator,additionalVariantChanges:[],adaptationId:B(l,t,this.sFlexReference)};var u={content:{},reference:this.sFlexReference,generator:f.generator,layer:l,adaptationId:f.adaptationId};if(a.def){var p=i({changeType:"setDefault",content:{defaultVariant:h},fileType:"ctrl_variant_management_change",selector:c.getSelector(e,f.appComponent)},u);f.additionalVariantChanges.push(d.createUIChange(p))}if(a.execute){var g=i({changeType:"setExecuteOnSelect",content:{executeOnSelect:true},fileType:"ctrl_variant_change",selector:c.getSelector(f.newVariantReference,f.appComponent)},u);f.additionalVariantChanges.push(d.createUIChange(g))}return this.copyVariant(f).then(function(a){r=a;return P({changes:o,vmReference:e,vReference:n,model:this}).then(z.bind(this,this.oFlexController,r,e,t))}.bind(this))}.bind(this,n,a,t),this).then(function(){return r})};N.prototype.getLocalId=function(e,t){return c.getSelector(e,t).id};N.prototype.getVariantManagementReferenceForControl=function(e){var t=e.getId();var a=D.getAppComponentForControl(e);return a&&a.getLocalId(t)||t};N.prototype.switchToDefaultForVariantManagement=function(e){if(this.oData[e].currentVariant!==this.oData[e].defaultVariant){l.show(200);this.updateCurrentVariant({variantManagementReference:e,newVariantReference:this.oData[e].defaultVariant}).then(function(){l.hide()})}};N.prototype.switchToDefaultForVariant=function(e){Object.keys(this.oData).forEach(function(t){if(!e||this.oData[t].currentVariant===e){this.switchToDefaultForVariantManagement(t)}}.bind(this))};function q(e,t){this.oData[t].variants.forEach(function(a){var n=a.title&&a.title.match(/{(\w+)>(\w.+)}/);if(n){var r=n[1];var i=n[2];var o=e.getModel(r);if(o){var s=o.getResourceBundle().getText(i);var c={variantReference:a.key,changeType:"setTitle",title:s,layer:a.layer,appComponent:this.oAppComponent};var l=this.createVariantChange(t,c);m.addRuntimeSteadyObject(this.sFlexReference,this.oAppComponent.getId(),l)}else{e.attachEventOnce("modelContextChange",q.bind(this,e,t))}}}.bind(this))}N.prototype.registerToModel=function(e){var t=this.getVariantManagementReferenceForControl(e);this._ensureStandardVariantExists(t);this.oData[t]._isEditable=e.getEditable();this.oData[t].showExecuteOnSelection=false;q.call(this,e,t);e.attachEvent("select",{vmReference:t,model:this},M);e.attachSave(this._handleSaveEvent,this);this.setModelPropertiesForControl(t,false,e);var a=e.getUpdateVariantInURL();this.oData[t].updateVariantInURL=a;g.registerControl({vmReference:t,updateURL:!!a,model:this});g.handleModelContextChange({model:this,vmControl:e});if(this.oData[t].initPromise){this.oData[t].initPromise.resolveFunction();delete this.oData[t].initPromise}this.oData[t].init=true;var n={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:t,flexController:this.oFlexController};this._oVariantSwitchPromise=this._oVariantSwitchPromise.then(m.waitForInitialVariantChanges.bind(undefined,n))};N.prototype.waitForVMControlInit=function(e){if(!this.oData[e]){this.oData[e]={}}else if(this.oData[e].init){return Promise.resolve()}this.oData[e].initPromise={};this.oData[e].initPromise.promise=new Promise(function(t){this.oData[e].initPromise.resolveFunction=t}.bind(this));return this.oData[e].initPromise.promise};N.prototype._getDirtyChangesFromVariantChanges=function(e){var t=e.map(function(e){return e.getId()});return this.oChangePersistence.getDirtyChanges().filter(function(e){return n(t,e.getId())&&!e.getSavedToVariant()})};N.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(e,t){return e.concat([this.oData[t].currentVariant])}.bind(this),[])};N.prototype.getVariantManagementControlIds=function(){var e;return Object.keys(this.oData||{}).reduce(function(t,a){if(this.oAppComponent.byId(a)){e=this.oAppComponent.createId(a)}else{e=a}t.push(e);return t}.bind(this),[])};N.prototype.destroy=function(){this.oDataSelector.removeUpdateListener(this.fnUpdateListener);m.clearRuntimeSteadyObjects(this.sFlexReference,this.oAppComponent.getId());m.resetCurrentVariantReference(this.sFlexReference);I.prototype.destroy.apply(this)};N.prototype.getUShellService=function(e){return D.getUshellContainer()&&F[e]};return N});
//# sourceMappingURL=VariantModel.js.map