/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/library","sap/ui/core/Element","sap/ui/core/Supportability","sap/base/util/fetch"],function(e,t,r,i){"use strict";var o=t.extend("sap.ui.integration.Host",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},resolveDestination:{type:"function",invalidate:false,parameters:{destinationName:{type:"string"},card:{type:"sap.ui.integration.widgets.Card"}}}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:"object"},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},cardConfigurationChange:{parameters:{card:{type:"sap.ui.core.Control"},changes:{type:"object"}}},cardStateChanged:{parameters:{card:{type:"sap.ui.core.Control"}}},cardInitialized:{parameters:{card:{type:"sap.ui.core.Control"}}},message:{parameters:{data:{type:"object"}}}}}});o.prototype.init=function(){this._handlePostMessageBound=this._handlePostMessage.bind(this)};o.prototype.getDestination=function(e,t){var r=this.getResolveDestination(),i;if(typeof r!=="function"){return Promise.reject("Could not resolve destination '"+e+"'. There is no 'resolveDestination' callback function configured in the host.")}i=r(e,t);if(i===null||i===undefined){return Promise.reject("Destination '"+e+"' could not be resolved by the host.")}if(i instanceof Promise){return i}return Promise.resolve(i)};o.prototype.getCsrfToken=function(e){return Promise.resolve()};o.prototype.csrfTokenFetched=function(e,t){};o.prototype.csrfTokenExpired=function(e){};o.prototype.getContextValue=function(e){if(!e){return Promise.resolve(null)}return Promise.resolve(null)};o.prototype.getDestinations=function(){return Promise.resolve([])};o.prototype.getContexts=function(){return Promise.resolve({})};o.prototype.useExperimentalCaching=function(){this.bUseExperimentalCaching=true;this.subscribeForMessages()};o.prototype.stopUsingExperimentalCaching=function(){this.bUseExperimentalCaching=false;this.unsubscribeForMessages()};o.prototype.modifyRequestHeaders=function(e,t,r){return e};o.prototype.modifyRequest=function(e,t,r){return e};o.prototype.fetch=function(e,t,o,a){if(r.isStatisticsEnabled()){e=this._addStatisticsParameter(e)}if(this.bUseExperimentalCaching){this._addCacheHeaders(t.headers,o)}return i(e,t)};o.prototype._addStatisticsParameter=function(e){var t=new URL(e,window.location.href);t.searchParams.set("sap-statistics","true");return t.href};o.prototype._addCacheHeaders=function(e,t){var r=t.cache,i=[];if(r.enabled===false){i.push("max-age=0");i.push("no-store")}else{i.push("max-age="+parseInt(r.maxAge||0));if(r.staleWhileRevalidate){i.push("x-stale-while-revalidate")}}if(i.length){e.set("Cache-Control",i.join(", "))}e.set("x-sap-card","true");e.set("x-use-cryptocache","true")};o.prototype.subscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.addEventListener("message",this._handlePostMessageBound)};o.prototype.unsubscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.removeEventListener("message",this._handlePostMessageBound)};o.prototype._handlePostMessage=function(e){this.fireMessage({data:e.data})};return o});
//# sourceMappingURL=Host.js.map