/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticalContentRenderer","./BaseContent","sap/f/cards/loading/AnalyticalPlaceholder","sap/m/IllustratedMessageType","sap/ui/integration/library","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/base/util/merge","sap/ui/core/Core"],function(t,e,a,i,n,r,o,s,l){"use strict";var p=n.CardActionArea;var c,d,u,g,h,v;var f={Top:"top",Bottom:"bottom",Left:"left",Right:"right"};var m={TopLeft:"topLeft",Center:"center"};var y={Left:"left",Center:"center",Right:"right"};var _={Line:"line",StackedColumn:"stacked_column",StackedBar:"stacked_bar",Donut:"donut"};var A={Chart:"Chart",Full:"Full"};var b=e.extend("sap.ui.integration.cards.AnalyticalContent",{metadata:{library:"sap.ui.integration"},renderer:t});b.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oPopover){this._oPopover.destroy()}};b.prototype.createLoadingPlaceholder=function(e){return new a({chartType:e.chartType,minHeight:t.getMinHeight(e)})};b.prototype.loadDependencies=function(t){return new Promise(function(t,e){l.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(["sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/controls/Popover","sap/viz/ui5/data/FlattenedDataset","sap/viz/ui5/data/MeasureDefinition","sap/viz/ui5/data/DimensionDefinition"],function(e,a,i,n,r,o){c=e;d=a;g=i;u=n;h=r;v=o;t()},function(t){e(t)})}).catch(function(){e("Analytical content type is not available with this distribution.")})})};b.prototype.onDataChanged=function(){this._createChart();var t=this.getAggregation("_content");if(t){var e=t._getVizDataset(),a=e&&e._FlatTableD&&e._FlatTableD._data&&Array.isArray(e._FlatTableD._data)&&e._FlatTableD._data.length;if(a){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:i.NoEntries,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_LISTS")})}}};b.prototype._createChart=function(){var t=this.getParsedConfiguration();if(!t.chartType){o.error('"sap.card".content.chartType is mandatory property.',null,"sap.ui.integration.widgets.Card");return}var e=r.resolveValue(t,this,"/");var a=new c({uiConfig:{applicationSet:"fiori"},height:"100%",width:"100%",vizType:_[e.chartType]||e.chartType,vizProperties:this._getVizProperties(e),dataset:this._getDataset(t,e),feeds:this._getFeeds(e)});this.setAggregation("_content",a);this._attachActions(t);if(e.popover&&e.popover.active){this._attachPopover()}};b.prototype._attachActions=function(t){var e={area:p.Content,actions:t.actions,control:this};if(t.actionableArea===A.Chart){e.eventName="selectData";e.actionControl=this.getAggregation("_content");this._oActions.setBindingPathResolver(function(t){var e=t.getParameter("data")[0].data._context_row_number;return this.getBindingContext().getPath()+"/"+e}.bind(this))}else{e.eventName="press"}this._oActions.attach(e)};b.prototype._attachPopover=function(){if(this._oPopover){this._oPopover.destroy()}this._oPopover=new g;this._oPopover.connect(this.getAggregation("_content").getVizUid())};b.prototype._getVizProperties=function(t){if(!t){return null}var e=t.title,a=t.legend,i=t.plotArea;var n={title:{style:{fontWeight:"normal"},layout:{respectPlotPosition:false}},legend:{},legendGroup:{layout:{}},plotArea:{window:{start:"firstDataPoint",end:"lastDataPoint"}},categoryAxis:{title:{}},valueAxis:{title:{}},interaction:{noninteractiveMode:true}};if(t.actions||t.popover){var r=t.actionableArea===A.Chart||t.popover&&t.popover.active;n.interaction.noninteractiveMode=!r}if(e){n.title.text=e.text;n.title.visible=e.visible;n.title.alignment=y[e.alignment];o.warning('"sap.card".content.title is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(a){n.legend.visible=a.visible;n.legendGroup.layout.position=f[a.position];n.legendGroup.layout.alignment=m[a.alignment];o.warning('"sap.card".content.legend is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(i){if(i.dataLabel){n.plotArea.dataLabel=i.dataLabel}if(i.categoryAxisText){n.categoryAxis.title.visible=i.categoryAxisText.visible}if(i.valueAxisText){n.valueAxis.title.visible=i.valueAxisText.visible}o.warning('"sap.card".content.plotArea is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}s(n,t.chartProperties);return n};b.prototype._getDataset=function(t,e){var a,i;if(t.dimensions){i=t.dimensions.map(function(t,a){return new v({name:e.dimensions[a].name||e.dimensions[a].label,value:t.value,displayValue:t.displayValue,dataType:t.dataType})})}if(t.measures){a=t.measures.map(function(t,a){return new h({name:e.measures[a].name||e.measures[a].label,value:t.value})})}return new u({measures:a,dimensions:i,data:{path:this.getBindingContext().getPath()}})};b.prototype._getFeeds=function(t){var e=t.feeds;if(t.measureAxis||t.dimensionAxis){o.warning('"sap.card".content.measureAxis and "sap.card".content.dimensionAxis are deprecated. Use "sap.card".content.feeds instead',null,"sap.ui.integration.widgets.Card");e=[{uid:t.measureAxis,type:"Measure",values:t.measures.map(function(t){return t.label})},{uid:t.dimensionAxis,type:"Dimension",values:t.dimensions.map(function(t){return t.label})}]}return e.map(function(t){return new d(t)})};return b});
//# sourceMappingURL=AnalyticalContent.js.map