/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticsCloudContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/core/HTML","sap/ui/integration/util/BindingResolver","sap/m/IllustratedMessageType","sap/base/Log"],function(t,i,r,e,h,a,s){"use strict";var n=r.CardActionArea;var o=i.extend("sap.ui.integration.cards.AnalyticsCloudContent",{metadata:{library:"sap.ui.integration"},renderer:t});o.prototype.init=function(){i.prototype.init.apply(this,arguments);var t=this.getId()+"-highchartContainer";this._oHighchartContainer=new e(t,{content:"<div id="+t+" class='sapFCardAnalyticsCloudContentHCC'></div>"});this.setAggregation("_content",this._oHighchartContainer)};o.prototype.exit=function(){i.prototype.exit.apply(this,arguments);if(this._oHighchart){this._oHighchart.destroy();this._oHighchart=null}if(this._oHighchartContainer){this._oHighchartContainer.destroy();this._oHighchartContainer=null}};o.prototype.loadDependencies=function(t){return this._loadHighcharts()};o.prototype.applyConfiguration=function(){var t=this.getParsedConfiguration();this.fireEvent("_actionContentReady");this._oActions.attach({area:n.Content,actions:t.actions,control:this})};o.prototype.onAfterRendering=function(){if(this.getAggregation("_blockingMessage")){return}this._createHighchart()};o.prototype._loadHighcharts=function(){var t=this.getCardInstance(),i=o.SAC_DESTINATION_KEY,r=t.resolveDestination(i);return r.then(function(t){return o.loadHighcharts(t)},function(t){return Promise.reject("Destination with key '"+i+"' is required for AnalyticsCloud card. It could not be resolved. Reason: '"+t+"'")})};o.prototype._createHighchart=function(){if(this._bIsBeingDestroyed){return}var t=this.getCardInstance(),i=this.getParsedConfiguration(),r=this.getBindingContext(),e,n;if(!t.isReady()){t.attachEventOnce("_ready",this._createHighchart,this);return}if(!window.Highcharts){this.handleError({illustrationType:a.ErrorScreen,title:t.getTranslatedText("CARD_DATA_LOAD_ERROR"),description:t.getTranslatedText("CARD_ERROR_HIGHCHARTS_DESCRIPTION")});return}if(!this._oHighchartContainer){s.error("Highcharts container is not created or destroyed.");return}if(r){e=r.getPath()}n=h.resolveValue(i.options,this,e);this._oHighchart=new window.Highcharts.Chart(this._oHighchartContainer.getId(),n)};o.SAC_DESTINATION_KEY="sac";o.HIGHCHART_MODULES={"highcharts/highstock":{amd:true,exports:"Highcharts"},"highcharts/highcharts-more":{deps:["highcharts/highstock"]},"highcharts/solid-gauge":{deps:["highcharts/highstock","highcharts/highcharts-more"]},"highcharts/histogram-bellcurve":{deps:["highcharts/highstock"]},"highcharts/no-data-to-display":{deps:["highcharts/highstock"]},"highcharts/wordcloud":{deps:["highcharts/highstock"]},"highcharts/variable-pie":{deps:["highcharts/highstock"]},"highcharts/heatmap":{deps:["highcharts/highstock"]},"highcharts/treemap":{deps:["highcharts/highstock"]},"highcharts/variwide":{deps:["highcharts/highstock"]},"highcharts/pattern-fill":{deps:["highcharts/highstock"]},"highcharts/highcharts-3d":{deps:["highcharts/highstock"]},"highcharts/grouped-categories":{deps:["highcharts/highstock"]}};o.loadHighcharts=function(t){var i=t.trim().replace(/\/$/,""),r=i,e=this._isHighchartsIncluded(r),h=this._isHighchartsIncludedByThirdParty();if(e){return this._pLoadModules}if(h){return Promise.resolve()}this._sIncludedFrom=r;this._pLoadModules=this._loadModules(r);return this._pLoadModules};o._isHighchartsIncluded=function(t){var i=this._sIncludedFrom;if(i&&i===t){return true}if(i&&i!==t){s.warning("Highcharts library is already included from '"+i+"'. The included version will be used and will not load from '"+t+"'","sap.ui.integration.widgets.Card#AnalyticsCloud");return true}return false};o._isHighchartsIncludedByThirdParty=function(){if(window.Highcharts){s.warning("Highcharts library is already included on the page. The included version will be used and will not load another one.","sap.ui.integration.widgets.Card#AnalyticsCloud");return true}return false};o._loadModules=function(t){var i=this.HIGHCHART_MODULES,r=Object.getOwnPropertyNames(i);sap.ui.loader.config({paths:{highcharts:t+"/highcharts"},async:true,shim:i});return this._require(r).catch(function(){return Promise.reject("There was a problem with loading of the Highcharts library files.")})};o._require=function(t){return new Promise(function(i,r){sap.ui.require(t,function(){i(arguments)},function(t){r(t)})})};return o});
//# sourceMappingURL=AnalyticsCloudContent.js.map