/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/base/util/extend","sap/f/cards/NumericHeader","sap/f/cards/NumericHeaderRenderer","sap/f/cards/NumericSideIndicator","sap/m/library","sap/m/Text","sap/ui/integration/util/BindingHelper","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider"],function(t,i,e,a,r,n,o,s,d,c,l){"use strict";var u=n.AvatarColor;var h=e.extend("sap.ui.integration.cards.NumericHeader",{constructor:function(t,a,n,d){a=a||{};var c={title:a.title,titleMaxLines:a.titleMaxLines,subtitle:a.subTitle,subtitleMaxLines:a.subTitleMaxLines,dataTimestamp:a.dataTimestamp,visible:a.visible};if(a.status&&a.status.text&&!a.status.text.format){c.statusText=a.status.text;c.statusVisible=a.status.visible}if(a.icon){var l=a.icon.initials||a.icon.text;var h=a.icon.backgroundColor||(l?u.Accent6:u.Transparent);c.iconSrc=a.icon.src;c.iconDisplayShape=a.icon.shape;c.iconInitials=l;c.iconAlt=a.icon.alt;c.iconBackgroundColor=h;c.iconVisible=a.icon.visible}if(c.iconSrc){c.iconSrc=s.formattedProperty(c.iconSrc,function(t){return d.formatSrc(t)})}i(c,{unitOfMeasurement:a.unitOfMeasurement,details:a.details?.text||a.details,detailsMaxLines:a.details?.maxLines||a.detailsMaxLines,sideIndicatorsAlignment:a.sideIndicatorsAlignment});if(a.details?.state){c.detailsState=a.details.state}if(a.mainIndicator){c.number=a.mainIndicator.number;c.scale=a.mainIndicator.unit;c.trend=a.mainIndicator.trend;c.state=a.mainIndicator.state;c.numberVisible=a.mainIndicator.visible}if(a.sideIndicators){c.sideIndicators=a.sideIndicators.map(function(t){return new r(t)})}if(a.banner){c.bannerLines=a.banner.map(function(t){var i=new o({text:t.text,visible:t.visible});if(t.diminished){i.addStyleClass("sapFCardHeaderBannerLineDiminished")}return i})}c.toolbar=n;e.call(this,t,c)},metadata:{library:"sap.ui.integration",properties:{interactive:{type:"boolean",defaultValue:false}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:a});h.prototype.init=function(){e.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new l);this._aReadyPromises=[];this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready")}.bind(this))};h.prototype.exit=function(){e.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};h.prototype.isInteractive=function(){return this.getInteractive()};h.prototype.isReady=function(){return this._bReady};h.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};h.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(i){this.attachEventOnce(t,function(){i()})}.bind(this)))};h.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};h.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};h.prototype._setDataConfiguration=function(t){var i=this.getCardInstance(),e="/",a;if(t&&t.path){e=c.resolveValue(t.path,this.getCardInstance())}this.bindObject(e);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t&&t.name){a=i.getModel(t.name)}else if(this._oDataProvider){a=new d;this.setModel(a)}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){a.setData(t.getParameter("data"));this.onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getSettings()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};h.prototype._handleError=function(t){this.fireEvent("_error",{errorInfo:t})};h.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};h.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};h.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};h.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};h.prototype.getCardInstance=function(){return t.byId(this.getCard())};h.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};return h});
//# sourceMappingURL=NumericHeader.js.map