/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/InvisibleText","sap/base/Log","sap/ui/core/Icon","sap/m/HBox","sap/m/Text","sap/ui/integration/model/ObservableModel","sap/ui/integration/util/LoadingProvider"],function(t,e,i,a,r,o,n,s,d){"use strict";var l=t.extend("sap.ui.integration.cards.filters.BaseFilter",{metadata:{abstract:true,library:"sap.ui.integration",properties:{key:{type:"string",defaultValue:""},config:{type:"object",defaultValue:"null"},value:{type:"object",defaultValue:null}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_label:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){var i=e.isLoading();t.openStart("div",e).class("sapFCardFilter");if(i){t.class("sapFCardFilterLoading")}t.openEnd();if(e._hasError()){t.renderControl(e._getErrorMessage())}else{t.renderControl(e.getField())}t.close("div")}}});l.prototype.init=function(){this.setAggregation("_loadingProvider",new d);this.attachEventOnce("_dataReady",function(){this.fireEvent("_ready")})};l.prototype.exit=function(){if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}};l.prototype.isLoading=function(){var t=this.getAggregation("_loadingProvider");return t.getLoading()};l.prototype.getField=function(){return null};l.prototype.createLabel=function(t){if(t.label){this.setAggregation("_label",new i({text:t.label}).toStatic());return this.getAggregation("_label")}return null};l.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};l.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};l.prototype.onDataChanged=function(){};l.prototype.setValueFromOutside=function(t){};l.prototype.getValueForModel=function(){};l.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};l.prototype.getCardInstance=function(){return e.byId(this.getCard())};l.prototype._hasError=function(){return!!this._bError};l.prototype._getErrorMessage=function(){var t=e.getLibraryResourceBundle("sap.ui.integration").getText("CARD_FILTER_DATA_LOAD_ERROR");return new o({justifyContent:"Center",alignItems:"Center",items:[new r({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new n({text:t})]})};l.prototype._handleError=function(t){a.error(t);this._bError=true;this.invalidate()};l.prototype._onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};l.prototype._setDataConfiguration=function(t){var e=this.getCardInstance(),i;if(!t){this.fireEvent("_dataReady");return}if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=e.getDataProviderFactory().create(t,null,true);if(t.name){i=e.getModel(t.name)}else if(this._oDataProvider){i=new s;i.setSizeLimit(e.getModelSizeLimit());this.setModel(i)}if(!i){this.fireEvent("_dataReady");return}i.attachEvent("change",function(){this.onDataChanged()}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){i.setData(t.getParameter("data"));this._onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError(t.getParameter("message"));this._onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};l.prototype._syncValue=function(){var t=this.getValueForModel(),e=this.getCardInstance(),i={},a;this.setValue(t);if(e){a="/sap.card/configuration/filters/"+this.getKey()+"/value";i[a]=t.value;e._fireConfigurationChange(i);e.resetPaginator()}};l.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};return l});
//# sourceMappingURL=BaseFilter.js.map