/*!
* OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["../library","sap/base/Log","sap/m/Bar","sap/m/Button","sap/m/Dialog","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/m/Title","sap/m/Text","sap/ui/Device","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/library"],function(e,t,i,a,s,n,r,o,l,p,g,u,d,c,f){"use strict";var y=f.TitleLevel;var C=e.CardBlockingMessageType;var T=c.extend("sap.ui.integration.controls.BlockingMessage",{metadata:{library:"sap.ui.integration",properties:{type:{type:"sap.ui.integration.CardBlockingMessageType",defaultValue:C.Information},height:{type:"sap.ui.core.CSSSize",defaultValue:""},illustrationType:{type:"string",defaultValue:"ErrorScreen"},illustrationSize:{type:"sap.m.IllustratedMessageSize",defaultValue:o.Auto},title:{type:"string",defaultValue:""},description:{type:"string",defaultValue:""},details:{type:"string",defaultValue:""},httpResponse:{type:"object",defaultValue:null}},aggregations:{_illustratedMessage:{type:"sap.m.IllustratedMessage",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapUiIntBlockingMsg");if(t.getHeight()){e.style("height",t.getHeight())}e.openEnd();e.renderControl(t.getAggregation("_illustratedMessage"));e.close("div")}}});T.create=function(e,i){var a=e.illustrationType,s=e.illustrationSize||o.Auto,n="100%",l=e.title,p=e.description,g=e.details;if(e.type===C.Error){a=a||r.ErrorScreen}else if(e.type===C.NoData){a=a||r.NoData}i._oContentMessage={type:e.type===C.NoData?"noData":"error",illustrationType:a,illustrationSize:s,title:l,description:p,details:g};if(i.getCardContent()&&i.getCardContent().getDomRef()){n=i.getCardContent().getDomRef().offsetHeight+"px"}var u=new T({type:e.type,height:n,illustrationType:a,illustrationSize:s,title:l,description:p,httpResponse:e.httpResponse});if(g&&d.getDebug()){u.setDetails(g)}else if(g){t.error(g)}return u};T.prototype.init=function(){this.setAggregation("_illustratedMessage",new n({enableDefaultTitleAndDescription:false,enableVerticalResponsiveness:true}))};T.prototype.onBeforeRendering=function(){var e=this.getAggregation("_illustratedMessage");e.setIllustrationType(this.getIllustrationType()).setIllustrationSize(this.getIllustrationSize()).setTitle(this.getTitle()).setDescription(this.getDescription()).destroyAdditionalContent();if(this.getDetails()){e.addAdditionalContent(this._getAdditionalContent())}};T.prototype._getAdditionalContent=function(){var e=u.getLibraryResourceBundle("sap.ui.integration");return new a({text:e.getText("CARD_BUTTON_SHOW_MORE"),press:function(){var t=new p({renderWhitespace:true,text:this.getDetails()}).addStyleClass("sapUiSmallMargin");var n=new s({stretch:g.system.phone,customHeader:new i({contentMiddle:new l({text:e.getText("CARD_ERROR_DIALOG_TITLE"),level:y.H1}),contentRight:new a({icon:"sap-icon://copy",tooltip:e.getText("CARD_TEXT_COPY"),press:function(){var e=document.createRange(),i=t.getDomRef();e.selectNode(i);window.getSelection().removeAllRanges();window.getSelection().addRange(e);window.navigator.clipboard.writeText(i.textContent)}})}),content:[t],buttons:[new a({text:e.getText("CARD_DIALOG_CLOSE_BUTTON"),press:function(){n.close()}})],afterClose:function(){n.destroy()}});n.open()}.bind(this)})};return T});
//# sourceMappingURL=BlockingMessage.js.map