/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/isTemplate","sap/ui/integration/designtime/baseEditor/util/StylesheetManager","sap/base/util/restricted/_intersection","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver"],function(t,e,i,r,o,s,a,n,p,h,d,u){"use strict";var y="config";var g="tags";var f={list:{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{responsiveGridLayout:{labelSpanXL:12,labelSpanL:12,labelSpanM:12,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false}}},form:{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{}}};var l=t.extend("sap.ui.integration.designtime.baseEditor.PropertyEditors",{metadata:{library:"sap.ui.integration",properties:{tags:{type:"string"},renderLabels:{type:"boolean"},config:{type:"array"},layout:{type:"string",defaultValue:"list"},layoutConfig:{type:"object"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor",visibility:"hidden"}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorsChange:{parameters:{previousPropertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"}}},init:{},configChange:{parameters:{previousConfig:{type:"array"},config:{type:"array"}}},tagsChange:{parameters:{previousTags:{type:"string"},tags:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},layoutChange:{parameters:{previousLayout:{type:"string"},layout:{type:"string"}}},layoutConfigChange:{parameters:{previousLayoutConfig:{type:"object"},layoutConfig:{type:"object"}}}}},_bEditorAutoDetect:false,_sCreatedBy:null,_bLayoutReady:false,constructor:function(){this._iExpectedWrapperCount=0;this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;t.prototype.constructor.apply(this,arguments);var e=new d;this.setModel(e);if(!this.getEditor()){this._bEditorAutoDetect=true}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(){if(this._sCreatedBy){this._removePropertyEditors()}this._initPropertyEditors()});this.attachConfigChange(function(t){var e=t.getParameter("previousConfig");var i=t.getParameter("config");if(this._fnCancelInit||this._sCreatedBy===g||!Array.isArray(e)||!Array.isArray(i)||e.length!==i.length){this._removePropertyEditors();this._initPropertyEditors()}else if(this._sCreatedBy){this._evaluateViewRecreation(e,i)}});this.attachTagsChange(function(){if(this._sCreatedBy===g){this._removePropertyEditors()}if(this._sCreatedBy!==y){this._initPropertyEditors()}});if(this.getMetadata().getProperty("layout").getDefaultValue()===this.getLayout()){this._initLayout(this.getLayout())}},renderer:function(t,e){t.openStart("div",e);t.openEnd();t.renderControl(e.getContent());t.close("div")}});l.prototype.init=function(){this.attachLayoutChange(function(t){var e=t.getParameter("previousLayout");this._removeStylesheet(this._getLayoutPath(e));var i=t.getParameter("layout");this._initLayout(i)},this);this.attachLayoutConfigChange(function(){if(this._sCreatedBy){this._removePropertyEditors()}this._initPropertyEditors()},this);Promise.resolve().then(function(){this._bInitFinished=true;this.fireInit()}.bind(this))};l.prototype.destroy=function(){this._bInitFinished=false;this._setReady(false);if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading()}this._removeStylesheet(this._getLayoutPath(this.getLayout()));t.prototype.destroy.apply(this,arguments)};l.prototype._loadFragment=function(t){return h.load({name:t,controller:this})};l.prototype._loadModule=function(t){return new Promise(function(e,i){sap.ui.require([t],e,i)})};l.prototype._loadStylesheet=function(t){this._bCssRequested=true;return o.add(t)};l.prototype._removeStylesheet=function(t){if(this._bCssRequested){o.remove(t);delete this._bCssRequested}};l.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"))};l.prototype.setConfig=function(t){var e=this.getConfig();if(!Array.isArray(e)||!Array.isArray(t)||JSON.stringify(e)!==JSON.stringify(t)){var i=p(t);this.setProperty("config",i);this.fireConfigChange({previousConfig:e,config:i})}};l.prototype.setTags=function(t){var e=this.getTags();var i=t;if(typeof t==="string"){i=t.split(",").sort().join(",")}if(e!==i){this.setProperty("tags",i);this.fireTagsChange({previousTags:e,tags:i})}};l.prototype.setEditor=function(t){var e=this.getEditor();var i=typeof t==="string"?sap.ui.getCore().byId(t):t;if(e!==i){this.setAssociation("editor",t);var i=this.getEditor();this.fireEditorChange({previousEditor:e,editor:i})}};l.prototype._removePropertyEditors=function(){var t=this.removeAllAssociation("propertyEditors").map(function(t){return sap.ui.getCore().byId(t)});this._iExpectedWrapperCount=0;this.getModel().setData({});this._sCreatedBy=null;if(t.length){this.firePropertyEditorsChange({previousPropertyEditors:t,propertyEditors:[]})}};l.prototype._initPropertyEditors=function(){if(this.getEditor()&&(this.getConfig()||!this.getBindingInfo("config")&&this.getTags())&&this._bLayoutReady){var t=this.getEditor();var e;if(this.getConfig()){e=this.getConfig();this._sCreatedBy=y}else{var i=this.getTags().split(",");e=t.getConfigsByTag(i);this._sCreatedBy=g}var r=(this._getPropertyEditors()||[]).slice();this._updateViewModel(e);this.ready().then(function(){this.firePropertyEditorsChange({previousPropertyEditors:r,propertyEditors:(this._getPropertyEditors()||[]).slice()})}.bind(this))}this._checkReadyState()};l.prototype._propagationListener=function(){var t=e(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(t){this.setEditor(t);this.removePropagationListener(this._propagationListener)}};l.prototype.setParent=function(i){t.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var r=e(i,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(r){this.setEditor(r)}else{this.addPropagationListener(this._propagationListener)}}};l.prototype.setLayout=function(t){var e=this.getLayout();if(e!==t){this.setProperty("layout",t);this.fireLayoutChange({previousLayout:e,layout:t})}};l.prototype.setLayoutConfig=function(t){var e=this.getLayoutConfig();if(!n(e,t)){this.setProperty("layoutConfig",t);this.fireLayoutConfigChange({previousLayoutConfig:e,layoutConfig:t})}};l.prototype._getLayoutConfig=function(){var t=this.getLayoutConfig();var e=this.getRenderLabels();var i;if(typeof e==="boolean"){i={renderLabels:e}}var r=f[this.getLayout()]&&f[this.getLayout()].defaultConfig||{};return Object.assign({},r,t,i)};l.prototype._getLayoutPath=function(t){return f.hasOwnProperty(t)?f[t].module:t};l.prototype._initLayout=function(t){this.destroyContent();var e=this._getLayoutPath(t);this._bLayoutReady=false;if(this._sCreatedBy){this._removePropertyEditors()}if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading()}var r=i(function(t,i){this._loadStylesheet(e);Promise.all([this._loadFragment(e),this._loadModule(e)]).then(t,i)}.bind(this));r.promise.then(function(t){delete this._fnCancelLayoutLoading;var e=t[0];var i=t[1];this._prepareData=i.prepareData;this._aUpdateDependencies=i.updateDependencies||[];this.setContent(e);this._bLayoutReady=true;this._initPropertyEditors()}.bind(this));this._fnCancelLayoutLoading=r.cancel};l.prototype._evaluateViewRecreation=function(t,e){var i=this._getPropertyEditors()||[];if(t.length!==e.length||e.length!==i.length||e.some(function(e,i){return this._aUpdateDependencies.some(function(r){return t[i][r]!==e[r]})}.bind(this))){this._updateViewModel(e)}else{i.map(function(t,i){var r=e[i];t.setConfig(a(p(r),"value"));if(r.hasOwnProperty("value")){t.setValue(r.value)}})}};l.prototype._updateViewModel=function(t){var e=this._prepareData(t,this._getLayoutConfig());this._iExpectedWrapperCount=e.count;if(this._iExpectedWrapperCount>0){this._checkReadyState()}this.getModel().setData(e)};l.prototype.ready=function(){return new Promise(function(t){if(this.isReady()){t()}else{this.attachEventOnce("ready",t)}}.bind(this))};l.prototype.isReady=function(){return!!this._bIsReady};l.prototype.hasError=function(){return this._aEditorWrappers.some(function(t){return t.hasError()})};l.prototype._setReady=function(t){var e=this._bIsReady;this._bIsReady=t;if(e!==true&&t===true){this.fireReady()}};l.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel()}if(!this._bInitFinished){this._setReady(false);return}if(!this._bLayoutReady){this._setReady(false);return}if(this._iExpectedWrapperCount===0){this._setReady(true);return}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(t){return t.isReady()})){this._setReady(true)}else{this._setReady(false);this._mWrapperReadyCheck=i(function(t){Promise.all(this._aEditorWrappers.map(function(t){return t.ready()})).then(t)}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck}.bind(this))}}else{this._setReady(false)}};l.prototype.wrapperInit=function(t){var e=t.getSource();if(r(e,this)){return}if(!e.getEditor()){e.setEditor(this.getEditor())}this._aEditorWrappers.push(e);this.addAssociation("propertyEditors",e);e.attachReady(function(){this._setReady(false);this._checkReadyState()}.bind(this));e.attachValidationErrorChange(function(){this.fireValidationErrorChange({hasError:this.hasError()})}.bind(this));if(!this._oWrapperObserver){this._oWrapperObserver=new u(function(t){this._aEditorWrappers=this._aEditorWrappers.filter(function(e){return e!==t.object});this.removeAssociation("propertyEditors",t.object)}.bind(this))}this._oWrapperObserver.observe(e,{destroy:true});this._checkReadyState()};l.prototype._getPropertyEditors=function(){var t=(this.getAssociation("propertyEditors")||[]).map(function(t){return sap.ui.getCore().byId(t)});return t.length&&t||null};return l});
//# sourceMappingURL=PropertyEditors.js.map